/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 29 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "sourcescanner.h"
#include "scannerparser.h"

#ifdef G_OS_WIN32
#include <io.h>
#endif

extern FILE *yyin;
extern int lineno;
extern char linebuf[2000];
extern char *yytext;

extern int yylex (GISourceScanner *scanner);
static void yyerror (GISourceScanner *scanner, const char *str);

extern void ctype_free (GISourceType * type);

static int last_enum_value = -1;
static gboolean is_bitfield;

/**
 * parse_c_string_literal:
 * @str: A string containing a C string literal
 *
 * Based on g_strcompress(), but also handles
 * hexadecimal escapes.
 */
static char *
parse_c_string_literal (const char *str)
{
  const gchar *p = str, *num;
  gchar *dest = g_malloc (strlen (str) + 1);
  gchar *q = dest;

  while (*p)
    {
      if (*p == '\\')
        {
          p++;
          switch (*p)
            {
            case '\0':
              g_warning ("parse_c_string_literal: trailing \\");
              goto out;
            case '0':  case '1':  case '2':  case '3':  case '4':
            case '5':  case '6':  case '7':
              *q = 0;
              num = p;
              while ((p < num + 3) && (*p >= '0') && (*p <= '7'))
                {
                  *q = (*q * 8) + (*p - '0');
                  p++;
                }
              q++;
              p--;
              break;
	    case 'x':
	      *q = 0;
	      p++;
	      num = p;
	      while ((p < num + 2) && (g_ascii_isxdigit(*p)))
		{
		  *q = (*q * 16) + g_ascii_xdigit_value(*p);
		  p++;
		}
              q++;
              p--;
	      break;
            case 'b':
              *q++ = '\b';
              break;
            case 'f':
              *q++ = '\f';
              break;
            case 'n':
              *q++ = '\n';
              break;
            case 'r':
              *q++ = '\r';
              break;
            case 't':
              *q++ = '\t';
              break;
            default:            /* Also handles \" and \\ */
              *q++ = *p;
              break;
            }
        }
      else
        *q++ = *p;
      p++;
    }
out:
  *q = 0;

  return dest;
}

enum {
  IRRELEVANT = 1,
  NOT_GI_SCANNER = 2,
  FOR_GI_SCANNER = 3,
};

static void
update_skipping (GISourceScanner *scanner)
{
  GList *l;
  for (l = scanner->conditionals.head; l != NULL; l = g_list_next (l))
    {
      if (GPOINTER_TO_INT (l->data) == NOT_GI_SCANNER)
        {
           scanner->skipping = TRUE;
           return;
        }
    }

  scanner->skipping = FALSE;
}

static void
push_conditional (GISourceScanner *scanner,
                  gint type)
{
  g_assert (type != 0);
  g_queue_push_head (&scanner->conditionals, GINT_TO_POINTER (type));
}

static gint
pop_conditional (GISourceScanner *scanner)
{
  gint type = GPOINTER_TO_INT (g_queue_pop_head (&scanner->conditionals));

  if (type == 0)
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error = g_strdup_printf ("%s:%d: mismatched %s", filename, lineno, yytext);
      g_ptr_array_add (scanner->errors, error);
      g_free (filename);
    }

  return type;
}

static void
warn_if_cond_has_gi_scanner (GISourceScanner *scanner,
                             const gchar *text)
{
  /* Some other conditional that is not __GI_SCANNER__ */
  if (strstr (text, "__GI_SCANNER__"))
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error = g_strdup_printf ("%s:%d: the __GI_SCANNER__ constant should only be used with simple #ifdef or #endif: %s",
               filename, lineno, text);
      g_ptr_array_add (scanner->errors, error);
      g_free (filename);
    }
}

static void
toggle_conditional (GISourceScanner *scanner)
{
  switch (pop_conditional (scanner))
    {
    case FOR_GI_SCANNER:
      push_conditional (scanner, NOT_GI_SCANNER);
      break;
    case NOT_GI_SCANNER:
      push_conditional (scanner, FOR_GI_SCANNER);
      break;
    case 0:
      break;
    default:
      push_conditional (scanner, IRRELEVANT);
      break;
    }
}

static void
set_or_merge_base_type (GISourceType *type,
                        GISourceType *base)
{
  /* combine basic types like unsigned int and long long */
  if (base->type == CTYPE_BASIC_TYPE && type->type == CTYPE_BASIC_TYPE)
    {
      char *name = g_strdup_printf ("%s %s", type->name, base->name);
      g_free (type->name);
      type->name = name;

      type->storage_class_specifier |= base->storage_class_specifier;
      type->type_qualifier |= base->type_qualifier;
      type->function_specifier |= base->function_specifier;
      type->is_bitfield |= base->is_bitfield;

      ctype_free (base);
    }
  else if (base->type == CTYPE_INVALID)
    {
      g_assert (base->base_type == NULL);

      type->storage_class_specifier |= base->storage_class_specifier;
      type->type_qualifier |= base->type_qualifier;
      type->function_specifier |= base->function_specifier;
      type->is_bitfield |= base->is_bitfield;

      ctype_free (base);
    }
  else
    {
      g_assert (type->base_type == NULL);

      type->base_type = base;
    }
}


#line 295 "giscanner/scannerparser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "scannerparser.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_BASIC_TYPE = 3,                 /* BASIC_TYPE  */
  YYSYMBOL_IDENTIFIER = 4,                 /* "identifier"  */
  YYSYMBOL_TYPEDEF_NAME = 5,               /* "typedef-name"  */
  YYSYMBOL_INTEGER = 6,                    /* INTEGER  */
  YYSYMBOL_FLOATING = 7,                   /* FLOATING  */
  YYSYMBOL_BOOLEAN = 8,                    /* BOOLEAN  */
  YYSYMBOL_CHARACTER = 9,                  /* CHARACTER  */
  YYSYMBOL_STRING = 10,                    /* STRING  */
  YYSYMBOL_INTL_CONST = 11,                /* INTL_CONST  */
  YYSYMBOL_INTUL_CONST = 12,               /* INTUL_CONST  */
  YYSYMBOL_ELLIPSIS = 13,                  /* ELLIPSIS  */
  YYSYMBOL_ADDEQ = 14,                     /* ADDEQ  */
  YYSYMBOL_SUBEQ = 15,                     /* SUBEQ  */
  YYSYMBOL_MULEQ = 16,                     /* MULEQ  */
  YYSYMBOL_DIVEQ = 17,                     /* DIVEQ  */
  YYSYMBOL_MODEQ = 18,                     /* MODEQ  */
  YYSYMBOL_XOREQ = 19,                     /* XOREQ  */
  YYSYMBOL_ANDEQ = 20,                     /* ANDEQ  */
  YYSYMBOL_OREQ = 21,                      /* OREQ  */
  YYSYMBOL_SL = 22,                        /* SL  */
  YYSYMBOL_SR = 23,                        /* SR  */
  YYSYMBOL_SLEQ = 24,                      /* SLEQ  */
  YYSYMBOL_SREQ = 25,                      /* SREQ  */
  YYSYMBOL_EQ = 26,                        /* EQ  */
  YYSYMBOL_NOTEQ = 27,                     /* NOTEQ  */
  YYSYMBOL_LTEQ = 28,                      /* LTEQ  */
  YYSYMBOL_GTEQ = 29,                      /* GTEQ  */
  YYSYMBOL_ANDAND = 30,                    /* ANDAND  */
  YYSYMBOL_OROR = 31,                      /* OROR  */
  YYSYMBOL_PLUSPLUS = 32,                  /* PLUSPLUS  */
  YYSYMBOL_MINUSMINUS = 33,                /* MINUSMINUS  */
  YYSYMBOL_ARROW = 34,                     /* ARROW  */
  YYSYMBOL_AUTO = 35,                      /* AUTO  */
  YYSYMBOL_BREAK = 36,                     /* BREAK  */
  YYSYMBOL_CASE = 37,                      /* CASE  */
  YYSYMBOL_COMPLEX = 38,                   /* COMPLEX  */
  YYSYMBOL_CONST = 39,                     /* CONST  */
  YYSYMBOL_CONTINUE = 40,                  /* CONTINUE  */
  YYSYMBOL_DEFAULT = 41,                   /* DEFAULT  */
  YYSYMBOL_DO = 42,                        /* DO  */
  YYSYMBOL_ELSE = 43,                      /* ELSE  */
  YYSYMBOL_ENUM = 44,                      /* ENUM  */
  YYSYMBOL_EXTENSION = 45,                 /* EXTENSION  */
  YYSYMBOL_EXTERN = 46,                    /* EXTERN  */
  YYSYMBOL_FOR = 47,                       /* FOR  */
  YYSYMBOL_GOTO = 48,                      /* GOTO  */
  YYSYMBOL_IF = 49,                        /* IF  */
  YYSYMBOL_INLINE = 50,                    /* INLINE  */
  YYSYMBOL_REGISTER = 51,                  /* REGISTER  */
  YYSYMBOL_RESTRICT = 52,                  /* RESTRICT  */
  YYSYMBOL_RETURN = 53,                    /* RETURN  */
  YYSYMBOL_SHORT = 54,                     /* SHORT  */
  YYSYMBOL_SIGNED = 55,                    /* SIGNED  */
  YYSYMBOL_SIZEOF = 56,                    /* SIZEOF  */
  YYSYMBOL_STATIC = 57,                    /* STATIC  */
  YYSYMBOL_STRUCT = 58,                    /* STRUCT  */
  YYSYMBOL_SWITCH = 59,                    /* SWITCH  */
  YYSYMBOL_THREAD_LOCAL = 60,              /* THREAD_LOCAL  */
  YYSYMBOL_TYPEDEF = 61,                   /* TYPEDEF  */
  YYSYMBOL_UNION = 62,                     /* UNION  */
  YYSYMBOL_UNSIGNED = 63,                  /* UNSIGNED  */
  YYSYMBOL_VOID = 64,                      /* VOID  */
  YYSYMBOL_VOLATILE = 65,                  /* VOLATILE  */
  YYSYMBOL_WHILE = 66,                     /* WHILE  */
  YYSYMBOL_FUNCTION_MACRO = 67,            /* FUNCTION_MACRO  */
  YYSYMBOL_OBJECT_MACRO = 68,              /* OBJECT_MACRO  */
  YYSYMBOL_IFDEF_GI_SCANNER = 69,          /* IFDEF_GI_SCANNER  */
  YYSYMBOL_IFNDEF_GI_SCANNER = 70,         /* IFNDEF_GI_SCANNER  */
  YYSYMBOL_IFDEF_COND = 71,                /* IFDEF_COND  */
  YYSYMBOL_IFNDEF_COND = 72,               /* IFNDEF_COND  */
  YYSYMBOL_IF_COND = 73,                   /* IF_COND  */
  YYSYMBOL_ELIF_COND = 74,                 /* ELIF_COND  */
  YYSYMBOL_ELSE_COND = 75,                 /* ELSE_COND  */
  YYSYMBOL_ENDIF_COND = 76,                /* ENDIF_COND  */
  YYSYMBOL_77_ = 77,                       /* '('  */
  YYSYMBOL_78_ = 78,                       /* ')'  */
  YYSYMBOL_79_ = 79,                       /* '{'  */
  YYSYMBOL_80_ = 80,                       /* '}'  */
  YYSYMBOL_81_ = 81,                       /* '['  */
  YYSYMBOL_82_ = 82,                       /* ']'  */
  YYSYMBOL_83_ = 83,                       /* '.'  */
  YYSYMBOL_84_ = 84,                       /* ','  */
  YYSYMBOL_85_ = 85,                       /* '&'  */
  YYSYMBOL_86_ = 86,                       /* '*'  */
  YYSYMBOL_87_ = 87,                       /* '+'  */
  YYSYMBOL_88_ = 88,                       /* '-'  */
  YYSYMBOL_89_ = 89,                       /* '~'  */
  YYSYMBOL_90_ = 90,                       /* '!'  */
  YYSYMBOL_91_ = 91,                       /* '/'  */
  YYSYMBOL_92_ = 92,                       /* '%'  */
  YYSYMBOL_93_ = 93,                       /* '<'  */
  YYSYMBOL_94_ = 94,                       /* '>'  */
  YYSYMBOL_95_ = 95,                       /* '^'  */
  YYSYMBOL_96_ = 96,                       /* '|'  */
  YYSYMBOL_97_ = 97,                       /* '?'  */
  YYSYMBOL_98_ = 98,                       /* ':'  */
  YYSYMBOL_99_ = 99,                       /* '='  */
  YYSYMBOL_100_ = 100,                     /* ';'  */
  YYSYMBOL_YYACCEPT = 101,                 /* $accept  */
  YYSYMBOL_primary_expression = 102,       /* primary_expression  */
  YYSYMBOL_strings = 103,                  /* strings  */
  YYSYMBOL_identifier = 104,               /* identifier  */
  YYSYMBOL_identifier_or_typedef_name = 105, /* identifier_or_typedef_name  */
  YYSYMBOL_postfix_expression = 106,       /* postfix_expression  */
  YYSYMBOL_argument_expression_list = 107, /* argument_expression_list  */
  YYSYMBOL_unary_expression = 108,         /* unary_expression  */
  YYSYMBOL_unary_operator = 109,           /* unary_operator  */
  YYSYMBOL_cast_expression = 110,          /* cast_expression  */
  YYSYMBOL_multiplicative_expression = 111, /* multiplicative_expression  */
  YYSYMBOL_additive_expression = 112,      /* additive_expression  */
  YYSYMBOL_shift_expression = 113,         /* shift_expression  */
  YYSYMBOL_relational_expression = 114,    /* relational_expression  */
  YYSYMBOL_equality_expression = 115,      /* equality_expression  */
  YYSYMBOL_and_expression = 116,           /* and_expression  */
  YYSYMBOL_exclusive_or_expression = 117,  /* exclusive_or_expression  */
  YYSYMBOL_inclusive_or_expression = 118,  /* inclusive_or_expression  */
  YYSYMBOL_logical_and_expression = 119,   /* logical_and_expression  */
  YYSYMBOL_logical_or_expression = 120,    /* logical_or_expression  */
  YYSYMBOL_conditional_expression = 121,   /* conditional_expression  */
  YYSYMBOL_assignment_expression = 122,    /* assignment_expression  */
  YYSYMBOL_assignment_operator = 123,      /* assignment_operator  */
  YYSYMBOL_expression = 124,               /* expression  */
  YYSYMBOL_constant_expression = 125,      /* constant_expression  */
  YYSYMBOL_declaration = 126,              /* declaration  */
  YYSYMBOL_empty_declaration = 127,        /* empty_declaration  */
  YYSYMBOL_declaration_specifiers = 128,   /* declaration_specifiers  */
  YYSYMBOL_init_declarator_list = 129,     /* init_declarator_list  */
  YYSYMBOL_init_declarator = 130,          /* init_declarator  */
  YYSYMBOL_storage_class_specifier = 131,  /* storage_class_specifier  */
  YYSYMBOL_basic_type = 132,               /* basic_type  */
  YYSYMBOL_type_specifier = 133,           /* type_specifier  */
  YYSYMBOL_struct_or_union_specifier = 134, /* struct_or_union_specifier  */
  YYSYMBOL_struct_or_union = 135,          /* struct_or_union  */
  YYSYMBOL_struct_declaration_list = 136,  /* struct_declaration_list  */
  YYSYMBOL_struct_declaration = 137,       /* struct_declaration  */
  YYSYMBOL_specifier_qualifier_list = 138, /* specifier_qualifier_list  */
  YYSYMBOL_struct_declarator_list = 139,   /* struct_declarator_list  */
  YYSYMBOL_struct_declarator = 140,        /* struct_declarator  */
  YYSYMBOL_enum_specifier = 141,           /* enum_specifier  */
  YYSYMBOL_enum_keyword = 142,             /* enum_keyword  */
  YYSYMBOL_static_keyword = 143,           /* static_keyword  */
  YYSYMBOL_enumerator_list = 144,          /* enumerator_list  */
  YYSYMBOL_145_1 = 145,                    /* $@1  */
  YYSYMBOL_enumerator = 146,               /* enumerator  */
  YYSYMBOL_type_qualifier = 147,           /* type_qualifier  */
  YYSYMBOL_function_specifier = 148,       /* function_specifier  */
  YYSYMBOL_declarator = 149,               /* declarator  */
  YYSYMBOL_direct_declarator = 150,        /* direct_declarator  */
  YYSYMBOL_pointer = 151,                  /* pointer  */
  YYSYMBOL_type_qualifier_list = 152,      /* type_qualifier_list  */
  YYSYMBOL_parameter_list = 153,           /* parameter_list  */
  YYSYMBOL_parameter_declaration = 154,    /* parameter_declaration  */
  YYSYMBOL_identifier_list = 155,          /* identifier_list  */
  YYSYMBOL_type_name = 156,                /* type_name  */
  YYSYMBOL_abstract_declarator = 157,      /* abstract_declarator  */
  YYSYMBOL_direct_abstract_declarator = 158, /* direct_abstract_declarator  */
  YYSYMBOL_typedef_name = 159,             /* typedef_name  */
  YYSYMBOL_initializer = 160,              /* initializer  */
  YYSYMBOL_initializer_list = 161,         /* initializer_list  */
  YYSYMBOL_initializer_list_item = 162,    /* initializer_list_item  */
  YYSYMBOL_designator_list = 163,          /* designator_list  */
  YYSYMBOL_designator = 164,               /* designator  */
  YYSYMBOL_statement = 165,                /* statement  */
  YYSYMBOL_labeled_statement = 166,        /* labeled_statement  */
  YYSYMBOL_compound_statement = 167,       /* compound_statement  */
  YYSYMBOL_block_item_list = 168,          /* block_item_list  */
  YYSYMBOL_block_item = 169,               /* block_item  */
  YYSYMBOL_expression_statement = 170,     /* expression_statement  */
  YYSYMBOL_selection_statement = 171,      /* selection_statement  */
  YYSYMBOL_iteration_statement = 172,      /* iteration_statement  */
  YYSYMBOL_jump_statement = 173,           /* jump_statement  */
  YYSYMBOL_translation_unit = 174,         /* translation_unit  */
  YYSYMBOL_external_declaration = 175,     /* external_declaration  */
  YYSYMBOL_function_definition = 176,      /* function_definition  */
  YYSYMBOL_declaration_list = 177,         /* declaration_list  */
  YYSYMBOL_function_macro = 178,           /* function_macro  */
  YYSYMBOL_object_macro = 179,             /* object_macro  */
  YYSYMBOL_function_macro_argument_list = 180, /* function_macro_argument_list  */
  YYSYMBOL_function_macro_define = 181,    /* function_macro_define  */
  YYSYMBOL_object_macro_define = 182,      /* object_macro_define  */
  YYSYMBOL_preproc_conditional = 183,      /* preproc_conditional  */
  YYSYMBOL_macro = 184                     /* macro  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  75
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2740

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  101
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  84
/* YYNRULES -- Number of rules.  */
#define YYNRULES  267
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  445

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   331


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    90,     2,     2,     2,    92,    85,     2,
      77,    78,    86,    87,    84,    88,    83,    91,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    98,   100,
      93,    99,    94,    97,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    81,     2,    82,    95,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    79,    96,    80,    89,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   349,   349,   358,   374,   380,   386,   393,   394,   398,
     406,   421,   435,   442,   443,   447,   448,   452,   456,   460,
     464,   468,   472,   479,   480,   484,   485,   489,   493,   516,
     523,   530,   534,   542,   546,   550,   554,   558,   562,   569,
     570,   582,   583,   589,   597,   608,   609,   615,   624,   625,
     637,   646,   647,   653,   659,   665,   674,   675,   681,   690,
     691,   700,   701,   710,   711,   720,   721,   732,   733,   744,
     745,   752,   753,   760,   761,   762,   763,   764,   765,   766,
     767,   768,   769,   770,   774,   775,   776,   783,   789,   807,
     814,   817,   822,   827,   832,   833,   838,   843,   848,   856,
     860,   867,   868,   872,   876,   880,   884,   888,   892,   899,
     906,   910,   914,   918,   922,   927,   928,   929,   937,   957,
     962,   970,   975,   983,   984,   991,  1011,  1016,  1017,  1022,
    1030,  1034,  1042,  1045,  1046,  1050,  1061,  1068,  1075,  1082,
    1089,  1096,  1104,  1111,  1111,  1120,  1128,  1136,  1148,  1152,
    1156,  1160,  1167,  1174,  1179,  1183,  1188,  1192,  1197,  1202,
    1207,  1217,  1224,  1233,  1238,  1242,  1253,  1266,  1267,  1274,
    1278,  1285,  1290,  1295,  1300,  1307,  1313,  1322,  1323,  1327,
    1332,  1333,  1341,  1345,  1350,  1355,  1360,  1365,  1371,  1381,
    1387,  1400,  1407,  1408,  1409,  1413,  1414,  1418,  1419,  1423,
    1424,  1428,  1429,  1435,  1436,  1437,  1438,  1439,  1440,  1444,
    1445,  1446,  1450,  1451,  1455,  1456,  1460,  1461,  1465,  1466,
    1470,  1471,  1472,  1476,  1477,  1478,  1479,  1480,  1481,  1482,
    1483,  1484,  1485,  1489,  1490,  1491,  1492,  1493,  1499,  1500,
    1504,  1505,  1506,  1507,  1511,  1512,  1516,  1517,  1523,  1530,
    1537,  1543,  1548,  1557,  1567,  1580,  1597,  1602,  1607,  1612,
    1617,  1622,  1629,  1634,  1642,  1643,  1644,  1645
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "BASIC_TYPE",
  "\"identifier\"", "\"typedef-name\"", "INTEGER", "FLOATING", "BOOLEAN",
  "CHARACTER", "STRING", "INTL_CONST", "INTUL_CONST", "ELLIPSIS", "ADDEQ",
  "SUBEQ", "MULEQ", "DIVEQ", "MODEQ", "XOREQ", "ANDEQ", "OREQ", "SL", "SR",
  "SLEQ", "SREQ", "EQ", "NOTEQ", "LTEQ", "GTEQ", "ANDAND", "OROR",
  "PLUSPLUS", "MINUSMINUS", "ARROW", "AUTO", "BREAK", "CASE", "COMPLEX",
  "CONST", "CONTINUE", "DEFAULT", "DO", "ELSE", "ENUM", "EXTENSION",
  "EXTERN", "FOR", "GOTO", "IF", "INLINE", "REGISTER", "RESTRICT",
  "RETURN", "SHORT", "SIGNED", "SIZEOF", "STATIC", "STRUCT", "SWITCH",
  "THREAD_LOCAL", "TYPEDEF", "UNION", "UNSIGNED", "VOID", "VOLATILE",
  "WHILE", "FUNCTION_MACRO", "OBJECT_MACRO", "IFDEF_GI_SCANNER",
  "IFNDEF_GI_SCANNER", "IFDEF_COND", "IFNDEF_COND", "IF_COND", "ELIF_COND",
  "ELSE_COND", "ENDIF_COND", "'('", "')'", "'{'", "'}'", "'['", "']'",
  "'.'", "','", "'&'", "'*'", "'+'", "'-'", "'~'", "'!'", "'/'", "'%'",
  "'<'", "'>'", "'^'", "'|'", "'?'", "':'", "'='", "';'", "$accept",
  "primary_expression", "strings", "identifier",
  "identifier_or_typedef_name", "postfix_expression",
  "argument_expression_list", "unary_expression", "unary_operator",
  "cast_expression", "multiplicative_expression", "additive_expression",
  "shift_expression", "relational_expression", "equality_expression",
  "and_expression", "exclusive_or_expression", "inclusive_or_expression",
  "logical_and_expression", "logical_or_expression",
  "conditional_expression", "assignment_expression", "assignment_operator",
  "expression", "constant_expression", "declaration", "empty_declaration",
  "declaration_specifiers", "init_declarator_list", "init_declarator",
  "storage_class_specifier", "basic_type", "type_specifier",
  "struct_or_union_specifier", "struct_or_union",
  "struct_declaration_list", "struct_declaration",
  "specifier_qualifier_list", "struct_declarator_list",
  "struct_declarator", "enum_specifier", "enum_keyword", "static_keyword",
  "enumerator_list", "$@1", "enumerator", "type_qualifier",
  "function_specifier", "declarator", "direct_declarator", "pointer",
  "type_qualifier_list", "parameter_list", "parameter_declaration",
  "identifier_list", "type_name", "abstract_declarator",
  "direct_abstract_declarator", "typedef_name", "initializer",
  "initializer_list", "initializer_list_item", "designator_list",
  "designator", "statement", "labeled_statement", "compound_statement",
  "block_item_list", "block_item", "expression_statement",
  "selection_statement", "iteration_statement", "jump_statement",
  "translation_unit", "external_declaration", "function_definition",
  "declaration_list", "function_macro", "object_macro",
  "function_macro_argument_list", "function_macro_define",
  "object_macro_define", "preproc_conditional", "macro", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-240)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-15)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     549,  -240,  -240,  -240,  -240,  -240,  -240,  -240,  -240,  -240,
    -240,  -240,  -240,  -240,  -240,  -240,  -240,  -240,  -240,  -240,
    -240,  -240,  -240,  -240,  -240,  -240,  -240,  -240,  -240,  -240,
    -240,  -240,  -240,  -240,  -240,    14,  2675,  -240,  2675,  -240,
      30,  -240,    64,  2675,  2675,  -240,   456,  -240,  -240,   -58,
    2050,  -240,  -240,  -240,  -240,  -240,    50,   179,  -240,  -240,
     -43,  -240,  1061,   -41,    48,  -240,  -240,  2264,  -240,   -57,
    -240,  -240,   -36,  -240,  -240,  -240,  -240,    69,  -240,  -240,
    -240,  -240,  -240,     4,    53,  2101,  2101,    56,  2152,  1403,
    -240,  -240,  -240,  -240,  -240,  -240,  -240,   141,  -240,   130,
    -240,  2050,  -240,    82,    66,    38,   121,   145,    98,   100,
     133,   221,   -21,  -240,  -240,   177,  -240,  -240,   179,    50,
    -240,   623,  1642,  -240,    14,  -240,  2455,  2518,  1583,   -41,
    2264,  1520,  -240,    24,  2264,  2264,   -22,   259,  -240,  -240,
    -240,   201,   217,  2101,  2101,  2203,  -240,  -240,   220,  1403,
    -240,  2254,   185,  -240,  -240,   108,   171,   232,  -240,  -240,
    -240,   309,  1693,  2203,   309,  -240,  2050,  2050,  2050,  2050,
    2050,  2050,  2050,  2050,  2050,  2050,  2050,  2050,  2050,  2050,
    2050,  2050,  2050,  2050,  2203,  -240,  -240,  -240,  -240,   218,
     223,  2050,   224,   228,  1004,   250,   309,   251,  1123,   254,
     255,  -240,  -240,   237,   240,   -20,  -240,   241,  -240,  -240,
    -240,   721,  -240,  -240,  -240,  -240,  -240,  1524,  -240,  -240,
    -240,  -240,  -240,  -240,  -240,   101,   142,  -240,   143,  -240,
    -240,   258,  2050,  -240,  -240,  -240,  2050,    55,  -240,   243,
    -240,  2417,  -240,     8,   244,  -240,   113,    59,  -240,   264,
     266,  2254,   917,   267,  1340,   268,  -240,  -240,  -240,  -240,
    -240,  -240,  -240,  -240,  -240,  -240,  -240,  2050,  -240,  2050,
    2373,  1744,   117,  -240,   160,  2050,  -240,  -240,   150,  -240,
     225,  -240,  -240,  -240,  -240,    82,    82,    66,    66,    38,
      38,    38,    38,   121,   121,   145,    98,   100,   133,   221,
     -31,  -240,   256,  -240,  1004,   282,  1139,   253,  2203,  -240,
      81,  2203,  2203,  1004,  -240,  -240,  -240,  2050,   259,  -240,
     178,  -240,   -33,  -240,  2310,  -240,    34,  -240,  -240,  2644,
    -240,   259,  -240,   273,  -240,    24,  -240,  2050,  -240,  -240,
    -240,  2050,  -240,    23,  -240,  -240,  -240,   819,  -240,  -240,
    -240,  -240,   155,   278,  -240,   275,   160,  2581,  1795,  -240,
    -240,  2050,  -240,  2203,  1004,  -240,   283,  1226,    91,  -240,
     175,  -240,   176,   188,  -240,   277,  -240,  -240,  1465,  1642,
    -240,  -240,  -240,  -240,  -240,  -240,  -240,  -240,   286,  -240,
    -240,  -240,  -240,   195,  -240,   279,  -240,   268,  -240,  2203,
    1846,   132,  1242,  1004,  1004,  1004,  -240,  -240,  -240,  -240,
    -240,  -240,  -240,   196,  1004,   197,  1897,  1948,   135,   322,
    -240,  -240,   271,  -240,  1004,  1004,   204,  1004,   209,  1999,
    1004,  -240,  -240,  -240,  1004,  -240,  1004,  1004,   214,  -240,
    -240,  -240,  -240,  1004,  -240
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       0,   267,   109,   191,   106,   111,   148,   141,   150,   104,
     152,   107,   149,   112,   105,   121,   108,   103,   122,   113,
     110,   151,   248,   249,   256,   257,   258,   259,   260,   261,
     262,   263,    90,   241,   242,     0,    92,   114,    94,   115,
       0,   116,     0,    96,    98,   117,     0,   238,   240,     0,
       0,   264,   265,   266,   243,    12,     0,   164,    89,   155,
       0,    99,   101,   154,     0,    91,    93,     0,    13,   120,
      14,   143,   140,    95,    97,     1,   239,     0,     3,     6,
       4,     5,    10,     0,     0,     0,     0,     0,     0,     0,
      33,    34,    35,    36,    37,    38,    15,     7,     2,    25,
      39,     0,    41,    45,    48,    51,    56,    59,    61,    63,
      65,    67,    69,    87,   255,     0,   167,   166,   163,     0,
      88,     0,     0,   246,     0,   245,     0,     0,     0,   153,
     127,     0,   123,   132,   129,     0,     0,     0,   143,   251,
     254,   250,     0,     0,     0,     0,    26,    27,     0,     0,
      31,   150,    39,    71,    84,     0,   177,     0,    11,    21,
      22,     0,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   156,   168,   165,   100,   101,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   212,   218,     2,     0,     0,   216,   117,   217,   203,
     204,     0,   214,   205,   206,   207,   208,     0,   192,   102,
     247,   244,   174,   162,   175,   173,     0,   169,     0,   142,
     159,     0,     0,   126,   119,   124,     0,     0,   130,   133,
     128,     0,   137,     0,   146,   144,     0,     0,   253,     0,
       0,     0,     0,     0,     0,    86,    77,    78,    74,    75,
      76,    82,    81,    83,    79,    80,    73,     0,     8,     0,
       0,     0,   179,   178,   180,     0,    20,    18,     0,    23,
       0,    19,    42,    43,    44,    46,    47,    49,    50,    54,
      55,    52,    53,    57,    58,    60,    62,    64,    66,    68,
       0,   235,     0,   234,     0,     0,     0,     0,     0,   236,
       0,     0,     0,     0,   219,   213,   215,     0,     0,   198,
       0,   195,     0,   199,     0,   171,   179,   172,   160,     0,
     161,     0,   158,     0,   134,   132,   125,     0,   118,   139,
     145,     0,   136,     0,   252,    29,    30,     0,    32,    72,
      85,   187,     0,     0,   183,     0,   181,     0,     0,    40,
      17,     0,    16,     0,     0,   211,     0,     0,     0,   233,
       0,   237,     0,     0,   209,     0,   202,   193,     0,     0,
     200,   170,   176,   157,   131,   135,   147,   138,     0,   188,
     182,   184,   189,     0,   185,     0,    24,    70,   210,     0,
       0,     0,     0,     0,     0,     0,   201,   194,   196,   197,
       9,   190,   186,     0,     0,     0,     0,     0,     0,   220,
     222,   223,     0,   225,     0,     0,     0,     0,     0,     0,
       0,   224,   229,   227,     0,   226,     0,     0,     0,   221,
     231,   230,   228,     0,   232
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -240,  -240,  -240,   -35,   -16,  -240,  -240,   261,  -240,   -26,
     146,   147,   129,   144,   193,   187,   192,   198,   191,  -240,
     -47,  -111,  -240,   -66,  -171,    31,  -240,     1,  -240,   262,
    -240,  -240,   -18,  -240,  -240,   247,  -106,   -75,  -240,    49,
    -240,  -240,  -240,   245,  -240,   248,   -11,  -240,   -29,   -62,
     -48,  -240,  -119,    57,  -240,   239,  -126,  -239,   -27,  -118,
    -240,    13,  -240,    71,    62,  -240,   -30,   154,  -195,  -240,
    -240,  -240,  -240,  -240,   348,  -240,  -240,  -240,  -240,   149,
    -240,  -240,  -240,  -240
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,    96,    97,    98,   204,    99,   278,   152,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     153,   154,   267,   205,   114,   206,    34,   124,    60,    61,
      36,    37,    38,    39,    40,   131,   132,   133,   237,   238,
      41,    42,   232,   136,   137,   340,    43,    44,   115,    63,
      64,   118,   352,   227,   228,   157,   353,   274,    45,   319,
     320,   321,   322,   323,   208,   209,   210,   211,   212,   213,
     214,   215,   216,    46,    47,    48,   126,    49,    50,   142,
      51,    52,    53,    54
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      59,    35,   129,   113,   219,    68,    62,    68,   226,   117,
     183,   218,    55,    70,   156,    70,   316,   231,    55,    77,
     302,    59,   135,   155,    69,   235,    72,    55,    55,    59,
     273,    33,   125,   356,    55,     3,   127,    65,    55,    66,
     128,   119,   141,   138,    73,    74,   116,    35,   317,   130,
     318,   279,    55,   269,    55,   233,   134,   120,   242,   240,
     171,   172,   243,    55,   269,   334,   379,   363,    55,     3,
     187,   130,   139,    55,   156,   165,   184,    33,   134,   155,
     314,   143,   139,   155,    59,   255,   203,   356,   339,    59,
     189,    56,   224,   123,   207,   189,   221,   280,    59,   327,
      57,    56,   244,   387,   239,    55,   218,   186,   272,    67,
      57,   324,   130,   130,    58,   271,   130,   130,   300,   134,
     134,   333,   236,   134,   134,    56,    68,    56,   225,    68,
     144,   130,   310,   148,    70,   235,    57,    70,   134,   335,
     282,   283,   284,    71,   113,   276,   375,   140,   281,   173,
     174,   158,   316,   169,   170,   336,   349,   220,   350,   203,
     355,    68,   159,   160,   161,   269,   385,    70,   166,    70,
     386,   177,   178,   167,   168,   269,   203,   326,   324,   156,
     307,   371,   271,   179,   207,   255,   268,    57,   155,   113,
      59,   402,   269,   342,   270,   180,   325,   343,   271,   256,
     257,   258,   259,   260,   261,   262,   263,   162,   244,   264,
     265,   163,   141,   164,   175,   176,   269,   203,     6,   269,
     328,   330,   272,   130,     8,   207,   329,   331,   360,   181,
     134,    12,   416,   389,   361,   429,   130,   357,   393,   329,
     368,   358,   370,   134,    21,   372,   373,   395,   270,   359,
     396,   182,   271,   403,   404,   185,   305,    57,   377,   269,
     269,   409,   378,    55,   129,    57,   405,   218,   218,   203,
     113,   225,   269,   411,   422,   424,   326,    70,   203,   329,
     269,   269,   434,   376,   266,   247,    70,   436,   269,    59,
     113,    59,   443,   269,   113,   248,   382,   397,   269,   252,
      59,   401,   289,   290,   291,   292,   239,   362,   244,   269,
     275,   100,   203,    55,     3,   285,   286,   122,   287,   288,
     207,   293,   294,   301,   303,   225,   304,   306,   308,   203,
     225,   311,   312,   413,   415,   -13,   418,    70,   313,   -14,
     332,   337,   345,   341,   346,   348,   146,   147,   366,   150,
     426,   428,   269,   369,   364,   383,   390,   391,   225,   406,
     399,   412,   100,   438,   410,   430,   365,   296,   203,   203,
     203,   431,   295,   297,   299,   374,    70,    70,    70,   203,
     298,   188,   241,   246,   384,   245,   381,    70,   253,   203,
     203,   408,   203,   380,    76,   203,   344,    70,    70,   203,
      70,   203,   203,    70,   249,   250,   347,    70,   203,    70,
      70,     0,     0,     0,     0,     0,    70,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   398,   100,   100,   100,
     100,   100,   100,   100,   100,   100,   100,   100,   100,   100,
     100,   100,   100,   100,   100,     0,     0,     0,     0,     0,
       0,     0,   100,     0,     0,     0,    75,     1,     0,     2,
       0,     3,     0,     0,     0,   419,   420,   421,     0,     0,
       0,     0,     0,     0,     0,     0,   423,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   432,   433,     0,   435,
       0,     4,   439,     0,     5,     6,   440,   100,   441,   442,
       7,     8,     9,     0,     0,   444,    10,    11,    12,     0,
       0,    13,     0,    14,    15,     0,    16,    17,    18,    19,
      20,    21,     0,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,     0,     0,     0,   100,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       1,     0,     2,     0,     3,     0,    32,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   100,     0,
       0,     0,     0,     0,     4,     0,     0,     5,     6,     0,
       0,     0,     0,     7,     8,     9,     0,     0,   100,    10,
      11,    12,   100,     0,    13,     0,    14,    15,     0,    16,
      17,    18,    19,    20,    21,     0,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,     2,    55,     3,    78,
      79,    80,    81,    82,    83,    84,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    32,
       0,     0,     0,     0,     0,    85,    86,     0,     4,   190,
     191,     5,     6,   192,   193,   194,     0,     7,   151,     9,
     195,   196,   197,    10,    11,    12,   198,     0,    13,    88,
      14,    15,   199,    16,    17,    18,    19,    20,    21,   200,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      89,     0,   121,   201,     0,     0,     0,     0,    90,    91,
      92,    93,    94,    95,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   202,     2,    55,     3,    78,    79,    80,
      81,    82,    83,    84,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    85,    86,     0,     4,   190,   191,     5,
       6,   192,   193,   194,     0,     7,   151,     9,   195,   196,
     197,    10,    11,    12,   198,     0,    13,    88,    14,    15,
     199,    16,    17,    18,    19,    20,    21,   200,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    89,     0,
     121,   315,     0,     0,     0,     0,    90,    91,    92,    93,
      94,    95,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   202,     2,    55,     3,    78,    79,    80,    81,    82,
      83,    84,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    85,    86,     0,     4,   190,   191,     5,     6,   192,
     193,   194,     0,     7,   151,     9,   195,   196,   197,    10,
      11,    12,   198,     0,    13,    88,    14,    15,   199,    16,
      17,    18,    19,    20,    21,   200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    89,     0,   121,   388,
       0,     0,     0,     0,    90,    91,    92,    93,    94,    95,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   202,
       2,    55,     3,    78,    79,    80,    81,    82,    83,    84,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    85,
      86,     0,     4,   190,   191,     5,     6,   192,   193,   194,
       0,     7,   151,     9,   195,   196,   197,    10,    11,    12,
     198,     0,    13,    88,    14,    15,   199,    16,    17,    18,
      19,    20,    21,   200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    89,     0,   121,     0,     0,     0,
       0,     0,    90,    91,    92,    93,    94,    95,    55,     3,
      78,    79,    80,    81,    82,    83,    84,   202,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    85,    86,     0,     0,
     190,   191,     0,     0,   192,   193,   194,     0,     0,   251,
       0,   195,   196,   197,     0,     0,     0,   198,     0,     0,
      88,     0,     0,   199,     2,     0,     3,     0,     0,     0,
     200,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    89,     0,   121,     0,     0,     0,     0,     0,    90,
      91,    92,    93,    94,    95,     0,     4,     0,     0,     5,
       6,     0,     0,     0,   202,     7,     8,     9,     0,     0,
       0,    10,    11,    12,     0,     0,    13,     0,    14,    15,
       0,    16,    17,    18,    19,    20,    21,    55,     0,    78,
      79,    80,    81,    82,    83,    84,     0,     0,     0,     0,
     121,     0,     0,    55,     0,    78,    79,    80,    81,    82,
      83,    84,     0,     0,     0,    85,    86,     0,     0,     0,
     122,     0,     0,     0,     0,     0,     0,     0,   251,     0,
       0,    85,    86,     0,     0,     0,     0,     0,     0,    88,
       0,     0,     0,     0,   251,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    88,     0,     0,     0,     0,
      89,     0,     0,     0,     0,     0,     0,     0,    90,    91,
      92,    93,    94,    95,     0,     0,    89,     0,     0,     0,
       0,     0,     0,   309,    90,    91,    92,    93,    94,    95,
      55,     0,    78,    79,    80,    81,    82,    83,    84,   367,
       0,     0,     0,     0,     0,     0,    55,     0,    78,    79,
      80,    81,    82,    83,    84,     0,     0,     0,    85,    86,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   251,     0,     0,    85,    86,     0,     0,     0,     0,
       0,     0,    88,     0,     0,     0,     0,   251,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    88,     0,
       0,     0,     0,    89,     0,     0,     0,     0,     0,     0,
       0,    90,    91,    92,    93,    94,    95,     0,     0,    89,
       0,     0,     0,     0,     0,     0,   400,    90,    91,    92,
      93,    94,    95,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   417,     2,    55,     3,    78,    79,    80,    81,
      82,    83,    84,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    85,    86,     0,     0,     0,     0,     5,     6,
       0,     0,     0,     0,     7,   151,     0,     0,     0,     0,
       0,     0,    12,     0,     0,    13,    88,     0,    15,     0,
       0,     0,    18,    19,    20,    21,     2,    55,     3,    78,
      79,    80,    81,    82,    83,    84,     0,    89,     0,   252,
       0,     0,     0,     0,     0,    90,    91,    92,    93,    94,
      95,     0,     0,     0,     0,    85,    86,     0,     0,     0,
       0,     5,     6,     0,     0,     0,     0,     7,   151,     0,
       0,     0,     0,     0,     0,    12,     0,     0,    13,    88,
       0,    15,     0,     0,     0,    18,    19,    20,    21,    55,
       0,    78,    79,    80,    81,    82,    83,    84,     0,     0,
      89,     0,     0,     0,     0,     0,     0,     0,    90,    91,
      92,    93,    94,    95,     0,     0,     0,    85,    86,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      87,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    88,     0,     2,     0,     3,     0,     0,    55,     0,
      78,    79,    80,    81,    82,    83,    84,     0,     0,     0,
       0,     0,    89,     0,   217,   407,   317,     0,   318,     0,
      90,    91,    92,    93,    94,    95,    85,    86,     5,     6,
       0,     0,     0,     0,     7,     8,     0,     0,     0,    87,
       0,     0,    12,     0,     0,    13,     0,     0,    15,     0,
      88,     0,    18,    19,    20,    21,     0,    55,     0,    78,
      79,    80,    81,    82,    83,    84,     0,     0,     0,     0,
     234,    89,     0,   217,     0,   317,     0,   318,     0,    90,
      91,    92,    93,    94,    95,    85,    86,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    87,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    88,
     229,     0,     0,     0,     0,     0,    55,     0,    78,    79,
      80,    81,    82,    83,    84,     0,     0,     0,     0,     0,
      89,     0,     0,     0,     0,   230,     0,     0,    90,    91,
      92,    93,    94,    95,    85,    86,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    87,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    55,    88,    78,
      79,    80,    81,    82,    83,    84,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    89,
       0,   217,     0,     0,     0,    85,    86,    90,    91,    92,
      93,    94,    95,     0,     0,     0,     0,     0,    87,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    55,    88,
      78,    79,    80,    81,    82,    83,    84,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      89,   277,     0,     0,     0,     0,    85,    86,    90,    91,
      92,    93,    94,    95,     0,     0,     0,     0,     0,    87,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    55,
      88,    78,    79,    80,    81,    82,    83,    84,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    89,     0,     0,     0,     0,   354,    85,    86,    90,
      91,    92,    93,    94,    95,     0,     0,     0,     0,     0,
      87,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,    88,    78,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    89,     0,     0,     0,     0,   394,    85,    86,
      90,    91,    92,    93,    94,    95,     0,     0,     0,     0,
       0,   251,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    55,    88,    78,    79,    80,    81,    82,    83,    84,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,   414,     0,     0,     0,     0,    85,
      86,    90,    91,    92,    93,    94,    95,     0,     0,     0,
       0,     0,   251,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    55,    88,    78,    79,    80,    81,    82,    83,
      84,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    89,   425,     0,     0,     0,     0,
      85,    86,    90,    91,    92,    93,    94,    95,     0,     0,
       0,     0,     0,   251,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    55,    88,    78,    79,    80,    81,    82,
      83,    84,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    89,   427,     0,     0,     0,
       0,    85,    86,    90,    91,    92,    93,    94,    95,     0,
       0,     0,     0,     0,   251,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    55,    88,    78,    79,    80,    81,
      82,    83,    84,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    89,   437,     0,     0,
       0,     0,    85,    86,    90,    91,    92,    93,    94,    95,
       0,     0,     0,     0,     0,    87,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,    88,    78,    79,    80,
      81,    82,    83,    84,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    89,     0,     0,
       0,     0,     0,    85,    86,    90,    91,    92,    93,    94,
      95,     0,     0,     0,     0,     0,    87,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    55,    88,    78,    79,
      80,    81,    82,    83,    84,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,    85,    86,    90,    91,    92,    93,
      94,    95,     0,     0,     0,     0,     0,    87,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    55,    88,    78,
      79,    80,    81,    82,    83,    84,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   149,
       0,     0,     0,     0,     0,    85,    86,    90,    91,    92,
      93,    94,    95,     0,     0,     0,     0,     0,   251,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    55,    88,
      78,    79,    80,    81,    82,    83,    84,     2,     0,     3,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      89,     0,     0,     0,     0,     0,    85,    86,    90,    91,
      92,    93,    94,    95,     0,     0,     0,     0,     0,   251,
       0,     0,     5,     6,     0,     0,     0,     0,     7,     8,
      88,     0,     0,     2,    55,     3,    12,     0,     0,    13,
       0,     0,    15,   222,     0,     0,    18,    19,    20,    21,
       0,   254,     0,     0,     0,     0,     0,     0,     0,    90,
      91,    92,    93,    94,    95,     4,     0,     0,     5,     6,
       0,     0,     0,     0,     7,     8,     9,     0,     0,     0,
      10,    11,    12,     0,     0,    13,     0,    14,    15,     0,
      16,    17,    18,    19,    20,    21,     2,     0,     3,     0,
       0,     0,     0,     0,     0,     0,   222,   324,   351,     0,
       0,   271,     0,     0,     0,     0,    57,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,     0,
       0,     5,     6,     0,     0,     0,     0,     7,     8,     9,
       2,     0,     3,    10,    11,    12,     0,     0,    13,     0,
      14,    15,     0,    16,    17,    18,    19,    20,    21,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     270,   351,     0,     0,   271,     5,     6,     0,     2,    57,
       3,     7,     8,     0,     0,     0,     0,     0,     0,    12,
       0,     0,    13,     0,     0,    15,     0,     0,     0,    18,
      19,    20,    21,     0,     0,     0,     0,     0,     0,     0,
       4,     0,     0,     5,     6,     0,     0,   338,     0,     7,
       8,     9,     0,     0,     0,    10,    11,    12,     0,     0,
      13,     0,    14,    15,     0,    16,    17,    18,    19,    20,
      21,     2,    55,     3,     0,     0,     0,     0,     0,     0,
       0,   222,     0,     0,   121,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     4,     0,     0,     5,     6,     0,     0,
       0,     0,     7,     8,     9,     0,     0,     0,    10,    11,
      12,     0,     0,    13,     0,    14,    15,     0,    16,    17,
      18,    19,    20,    21,     2,     0,     3,     0,     0,     0,
       0,     0,     0,     0,   222,     0,   223,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     4,     0,     0,     5,
       6,     0,     0,     0,     0,     7,     8,     9,     0,     0,
       0,    10,    11,    12,     0,     0,    13,     0,    14,    15,
       0,    16,    17,    18,    19,    20,    21,     2,     0,     3,
       0,     0,     0,     0,     0,     0,     0,   222,     0,   392,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     2,     4,
       3,     0,     5,     6,     0,     0,     0,     0,     7,     8,
       9,     0,     0,     0,    10,    11,    12,     0,     0,    13,
       0,    14,    15,     0,    16,    17,    18,    19,    20,    21,
       4,     0,     0,     5,     6,     0,     0,     0,     0,     7,
       8,     9,     0,     0,     0,    10,    11,    12,     0,     0,
      13,     0,    14,    15,     0,    16,    17,    18,    19,    20,
      21
};

static const yytype_int16 yycheck[] =
{
      35,     0,    64,    50,   122,    40,    35,    42,   127,    57,
      31,   122,     4,    40,    89,    42,   211,   128,     4,    77,
     191,    56,    79,    89,    40,   131,    42,     4,     4,    64,
     156,     0,    62,   272,     4,     5,    77,    36,     4,    38,
      81,    84,    77,    79,    43,    44,    57,    46,    81,    67,
      83,   162,     4,    84,     4,   130,    67,   100,    80,   134,
      22,    23,    84,     4,    84,   236,    99,    98,     4,     5,
     118,    89,    13,     4,   149,   101,    97,    46,    89,   145,
     100,    77,    13,   149,   119,   151,   121,   326,    80,   124,
     119,    77,   127,    62,   121,   124,   126,   163,   133,   225,
      86,    77,   137,    80,   133,     4,   217,   118,   156,    79,
      86,    77,   130,   131,   100,    81,   134,   135,   184,   130,
     131,   232,    98,   134,   135,    77,   161,    77,   127,   164,
      77,   149,   198,    77,   161,   241,    86,   164,   149,    84,
     166,   167,   168,    79,   191,   161,   317,    78,   164,    28,
      29,    10,   347,    87,    88,   100,   267,   126,   269,   194,
     271,   196,    32,    33,    34,    84,   337,   194,    86,   196,
     341,    26,    27,    91,    92,    84,   211,   225,    77,   254,
     196,   100,    81,    85,   211,   251,    78,    86,   254,   236,
     225,   100,    84,    80,    77,    95,   225,    84,    81,    14,
      15,    16,    17,    18,    19,    20,    21,    77,   243,    24,
      25,    81,   247,    83,    93,    94,    84,   252,    39,    84,
      78,    78,   270,   241,    45,   252,    84,    84,    78,    96,
     241,    52,   100,    78,    84,   100,   254,    77,   357,    84,
     306,    81,   308,   254,    65,   311,   312,   358,    77,   275,
     361,    30,    81,    78,    78,    78,   194,    86,    80,    84,
      84,   379,    84,     4,   326,    86,    78,   378,   379,   304,
     317,   270,    84,    78,    78,    78,   324,   304,   313,    84,
      84,    84,    78,   318,    99,    84,   313,    78,    84,   324,
     337,   326,    78,    84,   341,    78,   331,   363,    84,    79,
     335,   367,   173,   174,   175,   176,   335,    82,   343,    84,
      78,    50,   347,     4,     5,   169,   170,    99,   171,   172,
     347,   177,   178,   100,   100,   324,    98,    77,    77,   364,
     329,    77,    77,   399,   400,    98,   402,   364,    98,    98,
      82,    98,    78,    99,    78,    78,    85,    86,    66,    88,
     416,   417,    84,   100,    98,    82,    78,    82,   357,    82,
      77,    82,   101,   429,    78,    43,   304,   180,   403,   404,
     405,   100,   179,   181,   183,   313,   403,   404,   405,   414,
     182,   119,   135,   138,   335,   137,   329,   414,   149,   424,
     425,   378,   427,   322,    46,   430,   247,   424,   425,   434,
     427,   436,   437,   430,   143,   144,   252,   434,   443,   436,
     437,    -1,    -1,    -1,    -1,    -1,   443,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   364,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   191,    -1,    -1,    -1,     0,     1,    -1,     3,
      -1,     5,    -1,    -1,    -1,   403,   404,   405,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   414,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   424,   425,    -1,   427,
      -1,    35,   430,    -1,    38,    39,   434,   236,   436,   437,
      44,    45,    46,    -1,    -1,   443,    50,    51,    52,    -1,
      -1,    55,    -1,    57,    58,    -1,    60,    61,    62,    63,
      64,    65,    -1,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    -1,    -1,    -1,   275,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       1,    -1,     3,    -1,     5,    -1,   100,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   317,    -1,
      -1,    -1,    -1,    -1,    35,    -1,    -1,    38,    39,    -1,
      -1,    -1,    -1,    44,    45,    46,    -1,    -1,   337,    50,
      51,    52,   341,    -1,    55,    -1,    57,    58,    -1,    60,
      61,    62,    63,    64,    65,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,
      -1,    -1,    -1,    -1,    -1,    32,    33,    -1,    35,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    -1,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    79,    80,    -1,    -1,    -1,    -1,    85,    86,
      87,    88,    89,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   100,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    -1,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      79,    80,    -1,    -1,    -1,    -1,    85,    86,    87,    88,
      89,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   100,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    -1,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    79,    80,
      -1,    -1,    -1,    -1,    85,    86,    87,    88,    89,    90,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    12,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    -1,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    85,    86,    87,    88,    89,    90,     4,     5,
       6,     7,     8,     9,    10,    11,    12,   100,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    32,    33,    -1,    -1,
      36,    37,    -1,    -1,    40,    41,    42,    -1,    -1,    45,
      -1,    47,    48,    49,    -1,    -1,    -1,    53,    -1,    -1,
      56,    -1,    -1,    59,     3,    -1,     5,    -1,    -1,    -1,
      66,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    85,
      86,    87,    88,    89,    90,    -1,    35,    -1,    -1,    38,
      39,    -1,    -1,    -1,   100,    44,    45,    46,    -1,    -1,
      -1,    50,    51,    52,    -1,    -1,    55,    -1,    57,    58,
      -1,    60,    61,    62,    63,    64,    65,     4,    -1,     6,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      79,    -1,    -1,     4,    -1,     6,     7,     8,     9,    10,
      11,    12,    -1,    -1,    -1,    32,    33,    -1,    -1,    -1,
      99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    32,    33,    -1,    -1,    -1,    -1,    -1,    -1,    56,
      -1,    -1,    -1,    -1,    45,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    56,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,    86,
      87,    88,    89,    90,    -1,    -1,    77,    -1,    -1,    -1,
      -1,    -1,    -1,   100,    85,    86,    87,    88,    89,    90,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,   100,
      -1,    -1,    -1,    -1,    -1,    -1,     4,    -1,     6,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,    32,    33,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    45,    -1,    -1,    32,    33,    -1,    -1,    -1,    -1,
      -1,    -1,    56,    -1,    -1,    -1,    -1,    45,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    56,    -1,
      -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    85,    86,    87,    88,    89,    90,    -1,    -1,    77,
      -1,    -1,    -1,    -1,    -1,    -1,   100,    85,    86,    87,
      88,    89,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   100,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    32,    33,    -1,    -1,    -1,    -1,    38,    39,
      -1,    -1,    -1,    -1,    44,    45,    -1,    -1,    -1,    -1,
      -1,    -1,    52,    -1,    -1,    55,    56,    -1,    58,    -1,
      -1,    -1,    62,    63,    64,    65,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    -1,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    85,    86,    87,    88,    89,
      90,    -1,    -1,    -1,    -1,    32,    33,    -1,    -1,    -1,
      -1,    38,    39,    -1,    -1,    -1,    -1,    44,    45,    -1,
      -1,    -1,    -1,    -1,    -1,    52,    -1,    -1,    55,    56,
      -1,    58,    -1,    -1,    -1,    62,    63,    64,    65,     4,
      -1,     6,     7,     8,     9,    10,    11,    12,    -1,    -1,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,    86,
      87,    88,    89,    90,    -1,    -1,    -1,    32,    33,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    56,    -1,     3,    -1,     5,    -1,    -1,     4,    -1,
       6,     7,     8,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    79,    80,    81,    -1,    83,    -1,
      85,    86,    87,    88,    89,    90,    32,    33,    38,    39,
      -1,    -1,    -1,    -1,    44,    45,    -1,    -1,    -1,    45,
      -1,    -1,    52,    -1,    -1,    55,    -1,    -1,    58,    -1,
      56,    -1,    62,    63,    64,    65,    -1,     4,    -1,     6,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      80,    77,    -1,    79,    -1,    81,    -1,    83,    -1,    85,
      86,    87,    88,    89,    90,    32,    33,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    56,
      57,    -1,    -1,    -1,    -1,    -1,     4,    -1,     6,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    -1,    82,    -1,    -1,    85,    86,
      87,    88,    89,    90,    32,    33,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     4,    56,     6,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,
      -1,    79,    -1,    -1,    -1,    32,    33,    85,    86,    87,
      88,    89,    90,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     4,    56,
       6,     7,     8,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    78,    -1,    -1,    -1,    -1,    32,    33,    85,    86,
      87,    88,    89,    90,    -1,    -1,    -1,    -1,    -1,    45,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     4,
      56,     6,     7,     8,     9,    10,    11,    12,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    77,    -1,    -1,    -1,    -1,    82,    32,    33,    85,
      86,    87,    88,    89,    90,    -1,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    56,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    77,    -1,    -1,    -1,    -1,    82,    32,    33,
      85,    86,    87,    88,    89,    90,    -1,    -1,    -1,    -1,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     4,    56,     6,     7,     8,     9,    10,    11,    12,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    78,    -1,    -1,    -1,    -1,    32,
      33,    85,    86,    87,    88,    89,    90,    -1,    -1,    -1,
      -1,    -1,    45,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     4,    56,     6,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    77,    78,    -1,    -1,    -1,    -1,
      32,    33,    85,    86,    87,    88,    89,    90,    -1,    -1,
      -1,    -1,    -1,    45,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     4,    56,     6,     7,     8,     9,    10,
      11,    12,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    77,    78,    -1,    -1,    -1,
      -1,    32,    33,    85,    86,    87,    88,    89,    90,    -1,
      -1,    -1,    -1,    -1,    45,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     4,    56,     6,     7,     8,     9,
      10,    11,    12,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    78,    -1,    -1,
      -1,    -1,    32,    33,    85,    86,    87,    88,    89,    90,
      -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     4,    56,     6,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,
      -1,    -1,    -1,    32,    33,    85,    86,    87,    88,    89,
      90,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     4,    56,     6,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    -1,    -1,    32,    33,    85,    86,    87,    88,
      89,    90,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     4,    56,     6,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,
      -1,    -1,    -1,    -1,    -1,    32,    33,    85,    86,    87,
      88,    89,    90,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     4,    56,
       6,     7,     8,     9,    10,    11,    12,     3,    -1,     5,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    -1,    -1,    -1,    -1,    -1,    32,    33,    85,    86,
      87,    88,    89,    90,    -1,    -1,    -1,    -1,    -1,    45,
      -1,    -1,    38,    39,    -1,    -1,    -1,    -1,    44,    45,
      56,    -1,    -1,     3,     4,     5,    52,    -1,    -1,    55,
      -1,    -1,    58,    13,    -1,    -1,    62,    63,    64,    65,
      -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,
      86,    87,    88,    89,    90,    35,    -1,    -1,    38,    39,
      -1,    -1,    -1,    -1,    44,    45,    46,    -1,    -1,    -1,
      50,    51,    52,    -1,    -1,    55,    -1,    57,    58,    -1,
      60,    61,    62,    63,    64,    65,     3,    -1,     5,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    13,    77,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,
      -1,    38,    39,    -1,    -1,    -1,    -1,    44,    45,    46,
       3,    -1,     5,    50,    51,    52,    -1,    -1,    55,    -1,
      57,    58,    -1,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      77,    78,    -1,    -1,    81,    38,    39,    -1,     3,    86,
       5,    44,    45,    -1,    -1,    -1,    -1,    -1,    -1,    52,
      -1,    -1,    55,    -1,    -1,    58,    -1,    -1,    -1,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      35,    -1,    -1,    38,    39,    -1,    -1,    80,    -1,    44,
      45,    46,    -1,    -1,    -1,    50,    51,    52,    -1,    -1,
      55,    -1,    57,    58,    -1,    60,    61,    62,    63,    64,
      65,     3,     4,     5,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    13,    -1,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    35,    -1,    -1,    38,    39,    -1,    -1,
      -1,    -1,    44,    45,    46,    -1,    -1,    -1,    50,    51,
      52,    -1,    -1,    55,    -1,    57,    58,    -1,    60,    61,
      62,    63,    64,    65,     3,    -1,     5,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    13,    -1,    78,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,    -1,    38,
      39,    -1,    -1,    -1,    -1,    44,    45,    46,    -1,    -1,
      -1,    50,    51,    52,    -1,    -1,    55,    -1,    57,    58,
      -1,    60,    61,    62,    63,    64,    65,     3,    -1,     5,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,    -1,    78,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,    35,
       5,    -1,    38,    39,    -1,    -1,    -1,    -1,    44,    45,
      46,    -1,    -1,    -1,    50,    51,    52,    -1,    -1,    55,
      -1,    57,    58,    -1,    60,    61,    62,    63,    64,    65,
      35,    -1,    -1,    38,    39,    -1,    -1,    -1,    -1,    44,
      45,    46,    -1,    -1,    -1,    50,    51,    52,    -1,    -1,
      55,    -1,    57,    58,    -1,    60,    61,    62,    63,    64,
      65
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     5,    35,    38,    39,    44,    45,    46,
      50,    51,    52,    55,    57,    58,    60,    61,    62,    63,
      64,    65,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,   100,   126,   127,   128,   131,   132,   133,   134,
     135,   141,   142,   147,   148,   159,   174,   175,   176,   178,
     179,   181,   182,   183,   184,     4,    77,    86,   100,   104,
     129,   130,   149,   150,   151,   128,   128,    79,   104,   105,
     159,    79,   105,   128,   128,     0,   175,    77,     6,     7,
       8,     9,    10,    11,    12,    32,    33,    45,    56,    77,
      85,    86,    87,    88,    89,    90,   102,   103,   104,   106,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   125,   149,   147,   151,   152,    84,
     100,    79,    99,   126,   128,   167,   177,    77,    81,   150,
     133,   136,   137,   138,   147,    79,   144,   145,    79,    13,
      78,   104,   180,    77,    77,    77,   108,   108,    77,    77,
     108,    45,   108,   121,   122,   124,   138,   156,    10,    32,
      33,    34,    77,    81,    83,   110,    86,    91,    92,    87,
      88,    22,    23,    28,    29,    93,    94,    26,    27,    85,
      95,    96,    30,    31,    97,    78,   147,   151,   130,   149,
      36,    37,    40,    41,    42,    47,    48,    49,    53,    59,
      66,    80,   100,   104,   105,   124,   126,   159,   165,   166,
     167,   168,   169,   170,   171,   172,   173,    79,   122,   160,
     126,   167,    13,    78,   104,   128,   153,   154,   155,    57,
      82,   122,   143,   138,    80,   137,    98,   139,   140,   149,
     138,   136,    80,    84,   104,   146,   144,    84,    78,   108,
     108,    45,    79,   156,    77,   124,    14,    15,    16,    17,
      18,    19,    20,    21,    24,    25,    99,   123,    78,    84,
      77,    81,   151,   157,   158,    78,   105,    78,   107,   122,
     124,   105,   110,   110,   110,   111,   111,   112,   112,   113,
     113,   113,   113,   114,   114,   115,   116,   117,   118,   119,
     124,   100,   125,   100,    98,   165,    77,   105,    77,   100,
     124,    77,    77,    98,   100,    80,   169,    81,    83,   160,
     161,   162,   163,   164,    77,   149,   151,   157,    78,    84,
      78,    84,    82,   122,   125,    84,   100,    98,    80,    80,
     146,    99,    80,    84,   180,    78,    78,   168,    78,   122,
     122,    78,   153,   157,    82,   122,   158,    77,    81,   110,
      78,    84,    82,    98,    98,   165,    66,   100,   124,   100,
     124,   100,   124,   124,   165,   125,   104,    80,    84,    99,
     164,   154,   104,    82,   140,   125,   125,    80,    80,    78,
      78,    82,    78,   153,    82,   122,   122,   124,   165,    77,
     100,   124,   100,    78,    78,    78,    82,    80,   162,   160,
      78,    78,    82,   124,    78,   124,   100,   100,   124,   165,
     165,   165,    78,   165,    78,    78,   124,    78,   124,   100,
      43,   100,   165,   165,    78,   165,    78,    78,   124,   165,
     165,   165,   165,    78,   165
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,   101,   102,   102,   102,   102,   102,   102,   102,   102,
     103,   103,   104,   105,   105,   106,   106,   106,   106,   106,
     106,   106,   106,   107,   107,   108,   108,   108,   108,   108,
     108,   108,   108,   109,   109,   109,   109,   109,   109,   110,
     110,   111,   111,   111,   111,   112,   112,   112,   113,   113,
     113,   114,   114,   114,   114,   114,   115,   115,   115,   116,
     116,   117,   117,   118,   118,   119,   119,   120,   120,   121,
     121,   122,   122,   123,   123,   123,   123,   123,   123,   123,
     123,   123,   123,   123,   124,   124,   124,   125,   126,   126,
     127,   128,   128,   128,   128,   128,   128,   128,   128,   129,
     129,   130,   130,   131,   131,   131,   131,   131,   131,   132,
     133,   133,   133,   133,   133,   133,   133,   133,   134,   134,
     134,   135,   135,   136,   136,   137,   138,   138,   138,   138,
     139,   139,   140,   140,   140,   140,   141,   141,   141,   141,
     141,   142,   143,   145,   144,   144,   146,   146,   147,   147,
     147,   147,   148,   149,   149,   150,   150,   150,   150,   150,
     150,   150,   150,   151,   151,   151,   151,   152,   152,   153,
     153,   154,   154,   154,   154,   155,   155,   156,   156,   157,
     157,   157,   158,   158,   158,   158,   158,   158,   158,   158,
     158,   159,   160,   160,   160,   161,   161,   162,   162,   163,
     163,   164,   164,   165,   165,   165,   165,   165,   165,   166,
     166,   166,   167,   167,   168,   168,   169,   169,   170,   170,
     171,   171,   171,   172,   172,   172,   172,   172,   172,   172,
     172,   172,   172,   173,   173,   173,   173,   173,   174,   174,
     175,   175,   175,   175,   176,   176,   177,   177,   178,   179,
     180,   180,   180,   181,   181,   182,   183,   183,   183,   183,
     183,   183,   183,   183,   184,   184,   184,   184
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     3,     6,
       1,     2,     1,     1,     1,     1,     4,     4,     3,     3,
       3,     2,     2,     1,     3,     1,     2,     2,     2,     4,
       4,     2,     4,     1,     1,     1,     1,     1,     1,     1,
       4,     1,     3,     3,     3,     1,     3,     3,     1,     3,
       3,     1,     3,     3,     3,     3,     1,     3,     3,     1,
       3,     1,     3,     1,     3,     1,     3,     1,     3,     1,
       5,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     2,     1,     3,     2,
       1,     2,     1,     2,     1,     2,     1,     2,     1,     1,
       3,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     5,     4,
       2,     1,     1,     1,     2,     3,     2,     1,     2,     1,
       1,     3,     0,     1,     2,     3,     5,     4,     6,     5,
       2,     1,     1,     0,     2,     3,     1,     3,     1,     1,
       1,     1,     1,     2,     1,     1,     3,     5,     4,     3,
       4,     4,     3,     2,     1,     3,     2,     1,     2,     1,
       3,     2,     2,     1,     1,     1,     3,     1,     2,     1,
       1,     2,     3,     2,     3,     3,     4,     2,     3,     3,
       4,     1,     1,     3,     4,     1,     3,     3,     1,     1,
       2,     3,     2,     1,     1,     1,     1,     1,     1,     3,
       4,     3,     2,     3,     1,     2,     1,     1,     1,     2,
       5,     7,     5,     5,     7,     6,     7,     7,     8,     7,
       8,     8,     9,     3,     2,     2,     2,     3,     1,     2,
       1,     1,     1,     1,     4,     3,     1,     2,     1,     1,
       1,     1,     3,     4,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (scanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, scanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, GISourceScanner* scanner)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (scanner);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, GISourceScanner* scanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, scanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, GISourceScanner* scanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], scanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, scanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, GISourceScanner* scanner)
{
  YY_USE (yyvaluep);
  YY_USE (scanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (GISourceScanner* scanner)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (scanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* primary_expression: identifier  */
#line 350 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = g_hash_table_lookup (scanner->const_table, (yyvsp[0].str));
		if ((yyval.symbol) == NULL) {
			(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		} else {
			(yyval.symbol) = gi_source_symbol_ref ((yyval.symbol));
		}
	  }
#line 2554 "giscanner/scannerparser.c"
    break;

  case 3: /* primary_expression: INTEGER  */
#line 359 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		char *rest;
		guint64 value;
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if (g_str_has_prefix (yytext, "0x") && strlen (yytext) > 2) {
			value = g_ascii_strtoull (yytext + 2, &rest, 16);
		} else if (g_str_has_prefix (yytext, "0") && strlen (yytext) > 1) {
			value = g_ascii_strtoull (yytext + 1, &rest, 8);
		} else {
			value = g_ascii_strtoull (yytext, &rest, 10);
		}
		(yyval.symbol)->const_int = value;
		(yyval.symbol)->const_int_is_unsigned = (rest && (rest[0] == 'U'));
	  }
#line 2574 "giscanner/scannerparser.c"
    break;

  case 4: /* primary_expression: BOOLEAN  */
#line 375 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_boolean_set = TRUE;
		(yyval.symbol)->const_boolean = g_ascii_strcasecmp (yytext, "true") == 0 ? TRUE : FALSE;
	  }
#line 2584 "giscanner/scannerparser.c"
    break;

  case 5: /* primary_expression: CHARACTER  */
#line 381 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = g_utf8_get_char(yytext + 1);
	  }
#line 2594 "giscanner/scannerparser.c"
    break;

  case 6: /* primary_expression: FLOATING  */
#line 387 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_double_set = TRUE;
		(yyval.symbol)->const_double = 0.0;
        sscanf (yytext, "%lf", &((yyval.symbol)->const_double));
	  }
#line 2605 "giscanner/scannerparser.c"
    break;

  case 8: /* primary_expression: '(' expression ')'  */
#line 395 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
	  }
#line 2613 "giscanner/scannerparser.c"
    break;

  case 9: /* primary_expression: EXTENSION '(' '{' block_item_list '}' ')'  */
#line 399 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2621 "giscanner/scannerparser.c"
    break;

  case 10: /* strings: STRING  */
#line 407 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		yytext[strlen (yytext) - 1] = '\0';
		(yyval.symbol)->const_string = parse_c_string_literal (yytext + 1);
                if (!g_utf8_validate ((yyval.symbol)->const_string, -1, NULL))
                  {
#if 0
                    g_warning ("Ignoring non-UTF-8 constant string \"%s\"", yytext + 1);
#endif
                    g_free((yyval.symbol)->const_string);
                    (yyval.symbol)->const_string = NULL;
                  }

	  }
#line 2640 "giscanner/scannerparser.c"
    break;

  case 11: /* strings: strings STRING  */
#line 422 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		char *strings, *string2;
		(yyval.symbol) = (yyvsp[-1].symbol);
		yytext[strlen (yytext) - 1] = '\0';
		string2 = parse_c_string_literal (yytext + 1);
		strings = g_strconcat ((yyval.symbol)->const_string, string2, NULL);
		g_free ((yyval.symbol)->const_string);
		g_free (string2);
		(yyval.symbol)->const_string = strings;
	  }
#line 2655 "giscanner/scannerparser.c"
    break;

  case 12: /* identifier: "identifier"  */
#line 436 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext);
	  }
#line 2663 "giscanner/scannerparser.c"
    break;

  case 16: /* postfix_expression: postfix_expression '[' expression ']'  */
#line 449 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2671 "giscanner/scannerparser.c"
    break;

  case 17: /* postfix_expression: postfix_expression '(' argument_expression_list ')'  */
#line 453 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2679 "giscanner/scannerparser.c"
    break;

  case 18: /* postfix_expression: postfix_expression '(' ')'  */
#line 457 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2687 "giscanner/scannerparser.c"
    break;

  case 19: /* postfix_expression: postfix_expression '.' identifier_or_typedef_name  */
#line 461 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2695 "giscanner/scannerparser.c"
    break;

  case 20: /* postfix_expression: postfix_expression ARROW identifier_or_typedef_name  */
#line 465 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2703 "giscanner/scannerparser.c"
    break;

  case 21: /* postfix_expression: postfix_expression PLUSPLUS  */
#line 469 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2711 "giscanner/scannerparser.c"
    break;

  case 22: /* postfix_expression: postfix_expression MINUSMINUS  */
#line 473 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2719 "giscanner/scannerparser.c"
    break;

  case 26: /* unary_expression: PLUSPLUS unary_expression  */
#line 486 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2727 "giscanner/scannerparser.c"
    break;

  case 27: /* unary_expression: MINUSMINUS unary_expression  */
#line 490 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2735 "giscanner/scannerparser.c"
    break;

  case 28: /* unary_expression: unary_operator cast_expression  */
#line 494 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		switch ((yyvsp[-1].unary_operator)) {
		case UNARY_PLUS:
			(yyval.symbol) = (yyvsp[0].symbol);
			break;
		case UNARY_MINUS:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[0].symbol));
			(yyval.symbol)->const_int = -(yyvsp[0].symbol)->const_int;
			break;
		case UNARY_BITWISE_COMPLEMENT:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[0].symbol));
			(yyval.symbol)->const_int = ~(yyvsp[0].symbol)->const_int;
			break;
		case UNARY_LOGICAL_NEGATION:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[0].symbol));
			(yyval.symbol)->const_int = !gi_source_symbol_get_const_boolean ((yyvsp[0].symbol));
			break;
		default:
			(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
			break;
		}
	  }
#line 2762 "giscanner/scannerparser.c"
    break;

  case 29: /* unary_expression: INTL_CONST '(' unary_expression ')'  */
#line 517 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
		if ((yyval.symbol)->const_int_set) {
			(yyval.symbol)->base_type = gi_source_basic_type_new ((yyval.symbol)->const_int_is_unsigned ? "guint64" : "gint64");
		}
	  }
#line 2773 "giscanner/scannerparser.c"
    break;

  case 30: /* unary_expression: INTUL_CONST '(' unary_expression ')'  */
#line 524 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
		if ((yyval.symbol)->const_int_set) {
			(yyval.symbol)->base_type = gi_source_basic_type_new ("guint64");
		}
	  }
#line 2784 "giscanner/scannerparser.c"
    break;

  case 31: /* unary_expression: SIZEOF unary_expression  */
#line 531 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2792 "giscanner/scannerparser.c"
    break;

  case 32: /* unary_expression: SIZEOF '(' type_name ')'  */
#line 535 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		ctype_free ((yyvsp[-1].ctype));
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2801 "giscanner/scannerparser.c"
    break;

  case 33: /* unary_operator: '&'  */
#line 543 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_ADDRESS_OF;
	  }
#line 2809 "giscanner/scannerparser.c"
    break;

  case 34: /* unary_operator: '*'  */
#line 547 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_POINTER_INDIRECTION;
	  }
#line 2817 "giscanner/scannerparser.c"
    break;

  case 35: /* unary_operator: '+'  */
#line 551 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_PLUS;
	  }
#line 2825 "giscanner/scannerparser.c"
    break;

  case 36: /* unary_operator: '-'  */
#line 555 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_MINUS;
	  }
#line 2833 "giscanner/scannerparser.c"
    break;

  case 37: /* unary_operator: '~'  */
#line 559 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_BITWISE_COMPLEMENT;
	  }
#line 2841 "giscanner/scannerparser.c"
    break;

  case 38: /* unary_operator: '!'  */
#line 563 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_LOGICAL_NEGATION;
	  }
#line 2849 "giscanner/scannerparser.c"
    break;

  case 40: /* cast_expression: '(' type_name ')' cast_expression  */
#line 571 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		if ((yyval.symbol)->const_int_set || (yyval.symbol)->const_double_set || (yyval.symbol)->const_string != NULL) {
			(yyval.symbol)->base_type = (yyvsp[-2].ctype);
		} else {
			ctype_free ((yyvsp[-2].ctype));
		}
	  }
#line 2862 "giscanner/scannerparser.c"
    break;

  case 42: /* multiplicative_expression: multiplicative_expression '*' cast_expression  */
#line 584 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int * (yyvsp[0].symbol)->const_int;
	  }
#line 2872 "giscanner/scannerparser.c"
    break;

  case 43: /* multiplicative_expression: multiplicative_expression '/' cast_expression  */
#line 590 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if ((yyvsp[0].symbol)->const_int != 0) {
			(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int / (yyvsp[0].symbol)->const_int;
		}
	  }
#line 2884 "giscanner/scannerparser.c"
    break;

  case 44: /* multiplicative_expression: multiplicative_expression '%' cast_expression  */
#line 598 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if ((yyvsp[0].symbol)->const_int != 0) {
			(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int % (yyvsp[0].symbol)->const_int;
		}
	  }
#line 2896 "giscanner/scannerparser.c"
    break;

  case 46: /* additive_expression: additive_expression '+' multiplicative_expression  */
#line 610 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int + (yyvsp[0].symbol)->const_int;
	  }
#line 2906 "giscanner/scannerparser.c"
    break;

  case 47: /* additive_expression: additive_expression '-' multiplicative_expression  */
#line 616 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int - (yyvsp[0].symbol)->const_int;
	  }
#line 2916 "giscanner/scannerparser.c"
    break;

  case 49: /* shift_expression: shift_expression SL additive_expression  */
#line 626 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int << (yyvsp[0].symbol)->const_int;

		/* assume this is a bitfield/flags declaration
		 * if a left shift operator is sued in an enum value
                 * This mimics the glib-mkenum behavior.
		 */
		is_bitfield = TRUE;
	  }
#line 2932 "giscanner/scannerparser.c"
    break;

  case 50: /* shift_expression: shift_expression SR additive_expression  */
#line 638 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int >> (yyvsp[0].symbol)->const_int;
	  }
#line 2942 "giscanner/scannerparser.c"
    break;

  case 52: /* relational_expression: relational_expression '<' shift_expression  */
#line 648 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int < (yyvsp[0].symbol)->const_int;
	  }
#line 2952 "giscanner/scannerparser.c"
    break;

  case 53: /* relational_expression: relational_expression '>' shift_expression  */
#line 654 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int > (yyvsp[0].symbol)->const_int;
	  }
#line 2962 "giscanner/scannerparser.c"
    break;

  case 54: /* relational_expression: relational_expression LTEQ shift_expression  */
#line 660 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int <= (yyvsp[0].symbol)->const_int;
	  }
#line 2972 "giscanner/scannerparser.c"
    break;

  case 55: /* relational_expression: relational_expression GTEQ shift_expression  */
#line 666 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int >= (yyvsp[0].symbol)->const_int;
	  }
#line 2982 "giscanner/scannerparser.c"
    break;

  case 57: /* equality_expression: equality_expression EQ relational_expression  */
#line 676 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int == (yyvsp[0].symbol)->const_int;
	  }
#line 2992 "giscanner/scannerparser.c"
    break;

  case 58: /* equality_expression: equality_expression NOTEQ relational_expression  */
#line 682 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int != (yyvsp[0].symbol)->const_int;
	  }
#line 3002 "giscanner/scannerparser.c"
    break;

  case 60: /* and_expression: and_expression '&' equality_expression  */
#line 692 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int & (yyvsp[0].symbol)->const_int;
	  }
#line 3012 "giscanner/scannerparser.c"
    break;

  case 62: /* exclusive_or_expression: exclusive_or_expression '^' and_expression  */
#line 702 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int ^ (yyvsp[0].symbol)->const_int;
	  }
#line 3022 "giscanner/scannerparser.c"
    break;

  case 64: /* inclusive_or_expression: inclusive_or_expression '|' exclusive_or_expression  */
#line 712 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int | (yyvsp[0].symbol)->const_int;
	  }
#line 3032 "giscanner/scannerparser.c"
    break;

  case 66: /* logical_and_expression: logical_and_expression ANDAND inclusive_or_expression  */
#line 722 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int =
		  gi_source_symbol_get_const_boolean ((yyvsp[-2].symbol)) &&
		  gi_source_symbol_get_const_boolean ((yyvsp[0].symbol));
	  }
#line 3044 "giscanner/scannerparser.c"
    break;

  case 68: /* logical_or_expression: logical_or_expression OROR logical_and_expression  */
#line 734 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int =
		  gi_source_symbol_get_const_boolean ((yyvsp[-2].symbol)) ||
		  gi_source_symbol_get_const_boolean ((yyvsp[0].symbol));
	  }
#line 3056 "giscanner/scannerparser.c"
    break;

  case 70: /* conditional_expression: logical_or_expression '?' expression ':' expression  */
#line 746 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_get_const_boolean ((yyvsp[-4].symbol)) ? (yyvsp[-2].symbol) : (yyvsp[0].symbol);
	  }
#line 3064 "giscanner/scannerparser.c"
    break;

  case 72: /* assignment_expression: unary_expression assignment_operator assignment_expression  */
#line 754 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3072 "giscanner/scannerparser.c"
    break;

  case 86: /* expression: EXTENSION expression  */
#line 777 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3080 "giscanner/scannerparser.c"
    break;

  case 88: /* declaration: declaration_specifiers init_declarator_list ';'  */
#line 790 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GList *l;
		for (l = (yyvsp[-1].list); l != NULL; l = l->next) {
			GISourceSymbol *sym = l->data;
			gi_source_symbol_merge_type (sym, gi_source_type_copy ((yyvsp[-2].ctype)));
			if ((yyvsp[-2].ctype)->storage_class_specifier & STORAGE_CLASS_TYPEDEF) {
				sym->type = CSYMBOL_TYPE_TYPEDEF;
			} else if (sym->base_type->type == CTYPE_FUNCTION) {
				sym->type = CSYMBOL_TYPE_FUNCTION;
			} else {
				sym->type = CSYMBOL_TYPE_OBJECT;
			}
			gi_source_scanner_add_symbol (scanner, sym);
			gi_source_symbol_unref (sym);
		}
		ctype_free ((yyvsp[-2].ctype));
	  }
#line 3102 "giscanner/scannerparser.c"
    break;

  case 89: /* declaration: declaration_specifiers ';'  */
#line 808 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		ctype_free ((yyvsp[-1].ctype));
	  }
#line 3110 "giscanner/scannerparser.c"
    break;

  case 91: /* declaration_specifiers: storage_class_specifier declaration_specifiers  */
#line 818 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->storage_class_specifier |= (yyvsp[-1].storage_class_specifier);
	  }
#line 3119 "giscanner/scannerparser.c"
    break;

  case 92: /* declaration_specifiers: storage_class_specifier  */
#line 823 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->storage_class_specifier |= (yyvsp[0].storage_class_specifier);
	  }
#line 3128 "giscanner/scannerparser.c"
    break;

  case 93: /* declaration_specifiers: type_specifier declaration_specifiers  */
#line 828 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-1].ctype);
		set_or_merge_base_type ((yyvsp[-1].ctype), (yyvsp[0].ctype));
	  }
#line 3137 "giscanner/scannerparser.c"
    break;

  case 95: /* declaration_specifiers: type_qualifier declaration_specifiers  */
#line 834 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->type_qualifier |= (yyvsp[-1].type_qualifier);
	  }
#line 3146 "giscanner/scannerparser.c"
    break;

  case 96: /* declaration_specifiers: type_qualifier  */
#line 839 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->type_qualifier |= (yyvsp[0].type_qualifier);
	  }
#line 3155 "giscanner/scannerparser.c"
    break;

  case 97: /* declaration_specifiers: function_specifier declaration_specifiers  */
#line 844 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->function_specifier |= (yyvsp[-1].function_specifier);
	  }
#line 3164 "giscanner/scannerparser.c"
    break;

  case 98: /* declaration_specifiers: function_specifier  */
#line 849 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->function_specifier |= (yyvsp[0].function_specifier);
	  }
#line 3173 "giscanner/scannerparser.c"
    break;

  case 99: /* init_declarator_list: init_declarator  */
#line 857 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3181 "giscanner/scannerparser.c"
    break;

  case 100: /* init_declarator_list: init_declarator_list ',' init_declarator  */
#line 861 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3189 "giscanner/scannerparser.c"
    break;

  case 103: /* storage_class_specifier: TYPEDEF  */
#line 873 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_TYPEDEF;
	  }
#line 3197 "giscanner/scannerparser.c"
    break;

  case 104: /* storage_class_specifier: EXTERN  */
#line 877 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_EXTERN;
	  }
#line 3205 "giscanner/scannerparser.c"
    break;

  case 105: /* storage_class_specifier: STATIC  */
#line 881 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_STATIC;
	  }
#line 3213 "giscanner/scannerparser.c"
    break;

  case 106: /* storage_class_specifier: AUTO  */
#line 885 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_AUTO;
	  }
#line 3221 "giscanner/scannerparser.c"
    break;

  case 107: /* storage_class_specifier: REGISTER  */
#line 889 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_REGISTER;
	  }
#line 3229 "giscanner/scannerparser.c"
    break;

  case 108: /* storage_class_specifier: THREAD_LOCAL  */
#line 893 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_THREAD_LOCAL;
	  }
#line 3237 "giscanner/scannerparser.c"
    break;

  case 109: /* basic_type: BASIC_TYPE  */
#line 900 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext);
	  }
#line 3245 "giscanner/scannerparser.c"
    break;

  case 110: /* type_specifier: VOID  */
#line 907 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_VOID);
	  }
#line 3253 "giscanner/scannerparser.c"
    break;

  case 111: /* type_specifier: COMPLEX  */
#line 911 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_basic_type_new ("_Complex");
	  }
#line 3261 "giscanner/scannerparser.c"
    break;

  case 112: /* type_specifier: SIGNED  */
#line 915 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_basic_type_new ("signed");
	  }
#line 3269 "giscanner/scannerparser.c"
    break;

  case 113: /* type_specifier: UNSIGNED  */
#line 919 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_basic_type_new ("unsigned");
	  }
#line 3277 "giscanner/scannerparser.c"
    break;

  case 114: /* type_specifier: basic_type  */
#line 923 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_BASIC_TYPE);
		(yyval.ctype)->name = (yyvsp[0].str);
	  }
#line 3286 "giscanner/scannerparser.c"
    break;

  case 117: /* type_specifier: typedef_name  */
#line 930 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_typedef_new ((yyvsp[0].str));
		g_free ((yyvsp[0].str));
	  }
#line 3295 "giscanner/scannerparser.c"
    break;

  case 118: /* struct_or_union_specifier: struct_or_union identifier_or_typedef_name '{' struct_declaration_list '}'  */
#line 938 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym;
		(yyval.ctype) = (yyvsp[-4].ctype);
		(yyval.ctype)->name = (yyvsp[-3].str);
		(yyval.ctype)->child_list = (yyvsp[-1].list);

		sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		if ((yyval.ctype)->type == CTYPE_STRUCT) {
			sym->type = CSYMBOL_TYPE_STRUCT;
		} else if ((yyval.ctype)->type == CTYPE_UNION) {
			sym->type = CSYMBOL_TYPE_UNION;
		} else {
			g_assert_not_reached ();
		}
		sym->ident = g_strdup ((yyval.ctype)->name);
		sym->base_type = gi_source_type_copy ((yyval.ctype));
		gi_source_scanner_add_symbol (scanner, sym);
		gi_source_symbol_unref (sym);
	  }
#line 3319 "giscanner/scannerparser.c"
    break;

  case 119: /* struct_or_union_specifier: struct_or_union '{' struct_declaration_list '}'  */
#line 958 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-3].ctype);
		(yyval.ctype)->child_list = (yyvsp[-1].list);
	  }
#line 3328 "giscanner/scannerparser.c"
    break;

  case 120: /* struct_or_union_specifier: struct_or_union identifier_or_typedef_name  */
#line 963 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-1].ctype);
		(yyval.ctype)->name = (yyvsp[0].str);
	  }
#line 3337 "giscanner/scannerparser.c"
    break;

  case 121: /* struct_or_union: STRUCT  */
#line 971 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
                scanner->private = FALSE;
		(yyval.ctype) = gi_source_struct_new (NULL);
	  }
#line 3346 "giscanner/scannerparser.c"
    break;

  case 122: /* struct_or_union: UNION  */
#line 976 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
                scanner->private = FALSE;
		(yyval.ctype) = gi_source_union_new (NULL);
	  }
#line 3355 "giscanner/scannerparser.c"
    break;

  case 124: /* struct_declaration_list: struct_declaration_list struct_declaration  */
#line 985 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_concat ((yyvsp[-1].list), (yyvsp[0].list));
	  }
#line 3363 "giscanner/scannerparser.c"
    break;

  case 125: /* struct_declaration: specifier_qualifier_list struct_declarator_list ';'  */
#line 992 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
	    GList *l;
	    (yyval.list) = NULL;
	    for (l = (yyvsp[-1].list); l != NULL; l = l->next)
	      {
		GISourceSymbol *sym = l->data;
		if ((yyvsp[-2].ctype)->storage_class_specifier & STORAGE_CLASS_TYPEDEF)
		    sym->type = CSYMBOL_TYPE_TYPEDEF;
		else
		    sym->type = CSYMBOL_TYPE_MEMBER;
		gi_source_symbol_merge_type (sym, gi_source_type_copy ((yyvsp[-2].ctype)));
                sym->private = scanner->private;
                (yyval.list) = g_list_append ((yyval.list), sym);
	      }
	    ctype_free ((yyvsp[-2].ctype));
	  }
#line 3384 "giscanner/scannerparser.c"
    break;

  case 126: /* specifier_qualifier_list: type_specifier specifier_qualifier_list  */
#line 1012 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-1].ctype);
		set_or_merge_base_type ((yyvsp[-1].ctype), (yyvsp[0].ctype));
	  }
#line 3393 "giscanner/scannerparser.c"
    break;

  case 128: /* specifier_qualifier_list: type_qualifier specifier_qualifier_list  */
#line 1018 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->type_qualifier |= (yyvsp[-1].type_qualifier);
	  }
#line 3402 "giscanner/scannerparser.c"
    break;

  case 129: /* specifier_qualifier_list: type_qualifier  */
#line 1023 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->type_qualifier |= (yyvsp[0].type_qualifier);
	  }
#line 3411 "giscanner/scannerparser.c"
    break;

  case 130: /* struct_declarator_list: struct_declarator  */
#line 1031 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3419 "giscanner/scannerparser.c"
    break;

  case 131: /* struct_declarator_list: struct_declarator_list ',' struct_declarator  */
#line 1035 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3427 "giscanner/scannerparser.c"
    break;

  case 132: /* struct_declarator: %empty  */
#line 1042 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3435 "giscanner/scannerparser.c"
    break;

  case 134: /* struct_declarator: ':' constant_expression  */
#line 1047 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3443 "giscanner/scannerparser.c"
    break;

  case 135: /* struct_declarator: declarator ':' constant_expression  */
#line 1051 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-2].symbol);
		if ((yyvsp[0].symbol)->const_int_set) {
		  (yyval.symbol)->const_int_set = TRUE;
		  (yyval.symbol)->const_int = (yyvsp[0].symbol)->const_int;
		}
	  }
#line 3455 "giscanner/scannerparser.c"
    break;

  case 136: /* enum_specifier: enum_keyword identifier_or_typedef_name '{' enumerator_list '}'  */
#line 1062 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[-3].str));
		(yyval.ctype)->child_list = (yyvsp[-1].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3466 "giscanner/scannerparser.c"
    break;

  case 137: /* enum_specifier: enum_keyword '{' enumerator_list '}'  */
#line 1069 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new (NULL);
		(yyval.ctype)->child_list = (yyvsp[-1].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3477 "giscanner/scannerparser.c"
    break;

  case 138: /* enum_specifier: enum_keyword identifier_or_typedef_name '{' enumerator_list ',' '}'  */
#line 1076 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[-4].str));
		(yyval.ctype)->child_list = (yyvsp[-2].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3488 "giscanner/scannerparser.c"
    break;

  case 139: /* enum_specifier: enum_keyword '{' enumerator_list ',' '}'  */
#line 1083 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new (NULL);
		(yyval.ctype)->child_list = (yyvsp[-2].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3499 "giscanner/scannerparser.c"
    break;

  case 140: /* enum_specifier: enum_keyword identifier_or_typedef_name  */
#line 1090 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[0].str));
	  }
#line 3507 "giscanner/scannerparser.c"
    break;

  case 141: /* enum_keyword: ENUM  */
#line 1097 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
                scanner->flags = FALSE;
                scanner->private = FALSE;
          }
#line 3516 "giscanner/scannerparser.c"
    break;

  case 142: /* static_keyword: STATIC  */
#line 1105 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
          }
#line 3523 "giscanner/scannerparser.c"
    break;

  case 143: /* $@1: %empty  */
#line 1111 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		/* reset flag before the first enum value */
		is_bitfield = FALSE;
	  }
#line 3532 "giscanner/scannerparser.c"
    break;

  case 144: /* enumerator_list: $@1 enumerator  */
#line 1116 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
            (yyvsp[0].symbol)->private = scanner->private;
            (yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3541 "giscanner/scannerparser.c"
    break;

  case 145: /* enumerator_list: enumerator_list ',' enumerator  */
#line 1121 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
            (yyvsp[0].symbol)->private = scanner->private;
            (yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3550 "giscanner/scannerparser.c"
    break;

  case 146: /* enumerator: identifier  */
#line 1129 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_OBJECT, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[0].str);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = ++last_enum_value;
		g_hash_table_insert (scanner->const_table, g_strdup ((yyval.symbol)->ident), gi_source_symbol_ref ((yyval.symbol)));
	  }
#line 3562 "giscanner/scannerparser.c"
    break;

  case 147: /* enumerator: identifier '=' constant_expression  */
#line 1137 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_OBJECT, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[-2].str);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[0].symbol)->const_int;
		last_enum_value = (yyval.symbol)->const_int;
		g_hash_table_insert (scanner->const_table, g_strdup ((yyval.symbol)->ident), gi_source_symbol_ref ((yyval.symbol)));
	  }
#line 3575 "giscanner/scannerparser.c"
    break;

  case 148: /* type_qualifier: CONST  */
#line 1149 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_CONST;
	  }
#line 3583 "giscanner/scannerparser.c"
    break;

  case 149: /* type_qualifier: RESTRICT  */
#line 1153 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_RESTRICT;
	  }
#line 3591 "giscanner/scannerparser.c"
    break;

  case 150: /* type_qualifier: EXTENSION  */
#line 1157 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_EXTENSION;
	  }
#line 3599 "giscanner/scannerparser.c"
    break;

  case 151: /* type_qualifier: VOLATILE  */
#line 1161 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_VOLATILE;
	  }
#line 3607 "giscanner/scannerparser.c"
    break;

  case 152: /* function_specifier: INLINE  */
#line 1168 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.function_specifier) = FUNCTION_INLINE;
	  }
#line 3615 "giscanner/scannerparser.c"
    break;

  case 153: /* declarator: pointer direct_declarator  */
#line 1175 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3624 "giscanner/scannerparser.c"
    break;

  case 155: /* direct_declarator: identifier  */
#line 1184 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[0].str);
	  }
#line 3633 "giscanner/scannerparser.c"
    break;

  case 156: /* direct_declarator: '(' declarator ')'  */
#line 1189 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
	  }
#line 3641 "giscanner/scannerparser.c"
    break;

  case 157: /* direct_declarator: direct_declarator '[' static_keyword assignment_expression ']'  */
#line 1193 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
                (yyval.symbol) = (yyvsp[-4].symbol);
                gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
          }
#line 3650 "giscanner/scannerparser.c"
    break;

  case 158: /* direct_declarator: direct_declarator '[' assignment_expression ']'  */
#line 1198 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
	  }
#line 3659 "giscanner/scannerparser.c"
    break;

  case 159: /* direct_declarator: direct_declarator '[' ']'  */
#line 1203 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
#line 3668 "giscanner/scannerparser.c"
    break;

  case 160: /* direct_declarator: direct_declarator '(' parameter_list ')'  */
#line 1208 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[-1].list) != NULL && ((yyvsp[-1].list)->next != NULL || ((GISourceSymbol *) (yyvsp[-1].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[-1].list);
		}
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3682 "giscanner/scannerparser.c"
    break;

  case 161: /* direct_declarator: direct_declarator '(' identifier_list ')'  */
#line 1218 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		func->child_list = (yyvsp[-1].list);
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3693 "giscanner/scannerparser.c"
    break;

  case 162: /* direct_declarator: direct_declarator '(' ')'  */
#line 1225 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3703 "giscanner/scannerparser.c"
    break;

  case 163: /* pointer: '*' type_qualifier_list  */
#line 1234 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_pointer_new (NULL);
		(yyval.ctype)->type_qualifier = (yyvsp[0].type_qualifier);
	  }
#line 3712 "giscanner/scannerparser.c"
    break;

  case 164: /* pointer: '*'  */
#line 1239 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_pointer_new (NULL);
	  }
#line 3720 "giscanner/scannerparser.c"
    break;

  case 165: /* pointer: '*' type_qualifier_list pointer  */
#line 1243 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceType **base = &((yyvsp[0].ctype)->base_type);

		while (*base != NULL) {
			base = &((*base)->base_type);
		}
		*base = gi_source_pointer_new (NULL);
		(*base)->type_qualifier = (yyvsp[-1].type_qualifier);
		(yyval.ctype) = (yyvsp[0].ctype);
	  }
#line 3735 "giscanner/scannerparser.c"
    break;

  case 166: /* pointer: '*' pointer  */
#line 1254 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceType **base = &((yyvsp[0].ctype)->base_type);

		while (*base != NULL) {
			base = &((*base)->base_type);
		}
		*base = gi_source_pointer_new (NULL);
		(yyval.ctype) = (yyvsp[0].ctype);
	  }
#line 3749 "giscanner/scannerparser.c"
    break;

  case 168: /* type_qualifier_list: type_qualifier_list type_qualifier  */
#line 1268 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = (yyvsp[-1].type_qualifier) | (yyvsp[0].type_qualifier);
	  }
#line 3757 "giscanner/scannerparser.c"
    break;

  case 169: /* parameter_list: parameter_declaration  */
#line 1275 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3765 "giscanner/scannerparser.c"
    break;

  case 170: /* parameter_list: parameter_list ',' parameter_declaration  */
#line 1279 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3773 "giscanner/scannerparser.c"
    break;

  case 171: /* parameter_declaration: declaration_specifiers declarator  */
#line 1286 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3782 "giscanner/scannerparser.c"
    break;

  case 172: /* parameter_declaration: declaration_specifiers abstract_declarator  */
#line 1291 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3791 "giscanner/scannerparser.c"
    break;

  case 173: /* parameter_declaration: declaration_specifiers  */
#line 1296 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		(yyval.symbol)->base_type = (yyvsp[0].ctype);
	  }
#line 3800 "giscanner/scannerparser.c"
    break;

  case 174: /* parameter_declaration: ELLIPSIS  */
#line 1301 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_ELLIPSIS, scanner->current_file, lineno);
	  }
#line 3808 "giscanner/scannerparser.c"
    break;

  case 175: /* identifier_list: identifier  */
#line 1308 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[0].str);
		(yyval.list) = g_list_append (NULL, sym);
	  }
#line 3818 "giscanner/scannerparser.c"
    break;

  case 176: /* identifier_list: identifier_list ',' identifier  */
#line 1314 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[0].str);
		(yyval.list) = g_list_append ((yyvsp[-2].list), sym);
	  }
#line 3828 "giscanner/scannerparser.c"
    break;

  case 179: /* abstract_declarator: pointer  */
#line 1328 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[0].ctype));
	  }
#line 3837 "giscanner/scannerparser.c"
    break;

  case 181: /* abstract_declarator: pointer direct_abstract_declarator  */
#line 1334 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3846 "giscanner/scannerparser.c"
    break;

  case 182: /* direct_abstract_declarator: '(' abstract_declarator ')'  */
#line 1342 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
	  }
#line 3854 "giscanner/scannerparser.c"
    break;

  case 183: /* direct_abstract_declarator: '[' ']'  */
#line 1346 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
#line 3863 "giscanner/scannerparser.c"
    break;

  case 184: /* direct_abstract_declarator: '[' assignment_expression ']'  */
#line 1351 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
	  }
#line 3872 "giscanner/scannerparser.c"
    break;

  case 185: /* direct_abstract_declarator: direct_abstract_declarator '[' ']'  */
#line 1356 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
#line 3881 "giscanner/scannerparser.c"
    break;

  case 186: /* direct_abstract_declarator: direct_abstract_declarator '[' assignment_expression ']'  */
#line 1361 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
	  }
#line 3890 "giscanner/scannerparser.c"
    break;

  case 187: /* direct_abstract_declarator: '(' ')'  */
#line 1366 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3900 "giscanner/scannerparser.c"
    break;

  case 188: /* direct_abstract_declarator: '(' parameter_list ')'  */
#line 1372 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[-1].list) != NULL && ((yyvsp[-1].list)->next != NULL || ((GISourceSymbol *) (yyvsp[-1].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[-1].list);
		}
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3914 "giscanner/scannerparser.c"
    break;

  case 189: /* direct_abstract_declarator: direct_abstract_declarator '(' ')'  */
#line 1382 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3924 "giscanner/scannerparser.c"
    break;

  case 190: /* direct_abstract_declarator: direct_abstract_declarator '(' parameter_list ')'  */
#line 1388 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[-1].list) != NULL && ((yyvsp[-1].list)->next != NULL || ((GISourceSymbol *) (yyvsp[-1].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[-1].list);
		}
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3938 "giscanner/scannerparser.c"
    break;

  case 191: /* typedef_name: "typedef-name"  */
#line 1401 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext);
	  }
#line 3946 "giscanner/scannerparser.c"
    break;

  case 248: /* function_macro: FUNCTION_MACRO  */
#line 1524 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext + strlen ("#define "));
	  }
#line 3954 "giscanner/scannerparser.c"
    break;

  case 249: /* object_macro: OBJECT_MACRO  */
#line 1531 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext + strlen ("#define "));
	  }
#line 3962 "giscanner/scannerparser.c"
    break;

  case 250: /* function_macro_argument_list: identifier  */
#line 1538 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[0].str);
		(yyval.list) = g_list_append (NULL, sym);
	  }
#line 3972 "giscanner/scannerparser.c"
    break;

  case 251: /* function_macro_argument_list: ELLIPSIS  */
#line 1544 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_ELLIPSIS, scanner->current_file, lineno);
		(yyval.list) = g_list_append (NULL, sym);
	  }
#line 3981 "giscanner/scannerparser.c"
    break;

  case 252: /* function_macro_argument_list: identifier ',' function_macro_argument_list  */
#line 1549 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[-2].str);
		(yyval.list) = g_list_prepend ((yyvsp[0].list), sym);
	  }
#line 3991 "giscanner/scannerparser.c"
    break;

  case 253: /* function_macro_define: function_macro '(' function_macro_argument_list ')'  */
#line 1558 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
           {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_FUNCTION_MACRO, scanner->current_file, lineno);
		GISourceType *func = gi_source_function_new ();
		sym->ident = g_strdup ((yyvsp[-3].str));
		func->child_list = (yyvsp[-1].list);
		gi_source_symbol_merge_type (sym, func);
		gi_source_scanner_add_symbol (scanner, sym);
		gi_source_symbol_unref (sym);
	   }
#line 4005 "giscanner/scannerparser.c"
    break;

  case 254: /* function_macro_define: function_macro '(' ')'  */
#line 1568 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
           {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_FUNCTION_MACRO, scanner->current_file, lineno);
		GISourceType *func = gi_source_function_new ();
		sym->ident = g_strdup ((yyvsp[-2].str));
		func->child_list = NULL;
		gi_source_symbol_merge_type (sym, func);
		gi_source_scanner_add_symbol (scanner, sym);
		gi_source_symbol_unref (sym);
	   }
#line 4019 "giscanner/scannerparser.c"
    break;

  case 255: /* object_macro_define: object_macro constant_expression  */
#line 1581 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		if ((yyvsp[0].symbol)->const_int_set || (yyvsp[0].symbol)->const_boolean_set || (yyvsp[0].symbol)->const_double_set || (yyvsp[0].symbol)->const_string != NULL) {
			GISourceSymbol *macro = gi_source_symbol_copy ((yyvsp[0].symbol));
			g_free (macro->ident);
			macro->ident = (yyvsp[-1].str);
			gi_source_scanner_add_symbol (scanner, macro);
			gi_source_symbol_unref (macro);
			gi_source_symbol_unref ((yyvsp[0].symbol));
		} else {
			g_free ((yyvsp[-1].str));
			gi_source_symbol_unref ((yyvsp[0].symbol));
		}
	  }
#line 4037 "giscanner/scannerparser.c"
    break;

  case 256: /* preproc_conditional: IFDEF_GI_SCANNER  */
#line 1598 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		push_conditional (scanner, FOR_GI_SCANNER);
		update_skipping (scanner);
	  }
#line 4046 "giscanner/scannerparser.c"
    break;

  case 257: /* preproc_conditional: IFNDEF_GI_SCANNER  */
#line 1603 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		push_conditional (scanner, NOT_GI_SCANNER);
		update_skipping (scanner);
	  }
#line 4055 "giscanner/scannerparser.c"
    break;

  case 258: /* preproc_conditional: IFDEF_COND  */
#line 1608 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
	 	warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
#line 4064 "giscanner/scannerparser.c"
    break;

  case 259: /* preproc_conditional: IFNDEF_COND  */
#line 1613 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
#line 4073 "giscanner/scannerparser.c"
    break;

  case 260: /* preproc_conditional: IF_COND  */
#line 1618 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
#line 4082 "giscanner/scannerparser.c"
    break;

  case 261: /* preproc_conditional: ELIF_COND  */
#line 1623 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		pop_conditional (scanner);
		push_conditional (scanner, IRRELEVANT);
		update_skipping (scanner);
	  }
#line 4093 "giscanner/scannerparser.c"
    break;

  case 262: /* preproc_conditional: ELSE_COND  */
#line 1630 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		toggle_conditional (scanner);
		update_skipping (scanner);
	  }
#line 4102 "giscanner/scannerparser.c"
    break;

  case 263: /* preproc_conditional: ENDIF_COND  */
#line 1635 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"
          {
		pop_conditional (scanner);
		update_skipping (scanner);
	  }
#line 4111 "giscanner/scannerparser.c"
    break;


#line 4115 "giscanner/scannerparser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (scanner, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, scanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, scanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (scanner, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, scanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, scanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 1648 "../sources/gobject-introspection-1.84.0/giscanner/scannerparser.y"

static void
yyerror (GISourceScanner *scanner, const char *s)
{
  /* ignore errors while doing a macro scan as not all object macros
   * have valid expressions */
  if (!scanner->macro_scan)
    {
      gchar *error = g_strdup_printf ("%s:%d: %s in '%s' at '%s'",
          g_file_get_parse_name (scanner->current_file), lineno, s, linebuf, yytext);
      g_ptr_array_add (scanner->errors, error);
    }
}

static int
eat_hspace (FILE * f)
{
  int c;
  do
    {
      c = fgetc (f);
    }
  while (c == ' ' || c == '\t');
  return c;
}

static int
pass_line (FILE * f, int c,
           FILE *out)
{
  while (c != EOF && c != '\n')
    {
      if (out)
        fputc (c, out);
      c = fgetc (f);
    }
  if (c == '\n')
    {
      if (out)
        fputc (c, out);
      c = fgetc (f);
      if (c == ' ' || c == '\t')
        {
          c = eat_hspace (f);
        }
    }
  return c;
}

static int
eat_line (FILE * f, int c)
{
  return pass_line (f, c, NULL);
}

static int
read_identifier (FILE * f, int c, char **identifier)
{
  GString *id = g_string_new ("");
  while (g_ascii_isalnum (c) || c == '_')
    {
      g_string_append_c (id, c);
      c = fgetc (f);
    }
  *identifier = g_string_free (id, FALSE);
  return c;
}

static gboolean
parse_file (GISourceScanner *scanner, FILE *file)
{
  g_return_val_if_fail (file != NULL, FALSE);

  lineno = 1;
  yyin = file;
  yyparse (scanner);
  yyin = NULL;

  return TRUE;
}

void
gi_source_scanner_parse_macros (GISourceScanner *scanner, GList *filenames)
{
  GError *error = NULL;
  char *tmp_name = NULL;
  gint tmp_fd;
  FILE *fmacros;
  GList *l;

  tmp_fd = g_file_open_tmp ("gen-introspect-XXXXXX.h", &tmp_name, &error);

  if (tmp_fd == -1)
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error_msg = g_strdup_printf ("%s: failed to create temporary file '%s' while parsing macros: %s", filename, tmp_name, error->message);
      g_ptr_array_add (scanner->errors, error_msg);
      g_free (filename);
      g_error_free (error);
      return;
    }

  fmacros = fdopen (tmp_fd, "w+");

  if (!fmacros)
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error_msg = g_strdup_printf ("%s: failed to open temporary file '%s' while parsing macros", filename, tmp_name);
      g_ptr_array_add (scanner->errors, error_msg);
      g_free (filename);
      close (tmp_fd);
      g_unlink (tmp_name);
      g_free (tmp_name);
      return;
    }

  for (l = filenames; l != NULL; l = l->next)
    {
      FILE *f = fopen (l->data, "r");
      int line = 1;

      GString *define_line;
      char *str;
      gboolean error_line = FALSE;
      gboolean end_of_word;
      int c = eat_hspace (f);
      while (c != EOF)
        {
          if (c != '#')
            {
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }

          /* print current location */
          str = g_strescape (l->data, "");
          fprintf (fmacros, "# %d \"%s\"\n", line, str);
          g_free (str);

          c = eat_hspace (f);
          c = read_identifier (f, c, &str);
          end_of_word = (c == ' ' || c == '\t' || c == '\n' || c == EOF);
          if (end_of_word &&
              (g_str_equal (str, "if") ||
               g_str_equal (str, "endif") ||
               g_str_equal (str, "ifndef") ||
               g_str_equal (str, "ifdef") ||
               g_str_equal (str, "else") ||
               g_str_equal (str, "elif")))
            {
              fprintf (fmacros, "#%s ", str);
              g_free (str);
              c = pass_line (f, c, fmacros);
              line++;
              continue;
            }
          else if (strcmp (str, "define") != 0 || !end_of_word)
            {
              g_free (str);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          g_free (str);
          c = eat_hspace (f);
          c = read_identifier (f, c, &str);
          if (strlen (str) == 0 || (c != ' ' && c != '\t' && c != '('))
            {
              g_free (str);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          define_line = g_string_new ("#define ");
          g_string_append (define_line, str);
          g_free (str);
          if (c == '(')
            {
              while (c != ')')
                {
                  g_string_append_c (define_line, c);
                  c = fgetc (f);
                  if (c == EOF || c == '\n')
                    {
                      error_line = TRUE;
                      break;
                    }
                }
              if (error_line)
                {
                  g_string_free (define_line, TRUE);
                  /* ignore line */
                  c = eat_line (f, c);
                  line++;
                  continue;
                }

              g_assert (c == ')');
              g_string_append_c (define_line, c);
              c = fgetc (f);

              /* found function-like macro */
              fprintf (fmacros, "%s\n", define_line->str);

              g_string_free (define_line, TRUE);
              /* ignore rest of line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          if (c != ' ' && c != '\t')
            {
              g_string_free (define_line, TRUE);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          while (c != EOF && c != '\n')
            {
              g_string_append_c (define_line, c);
              c = fgetc (f);
              if (c == '\\')
                {
                  c = fgetc (f);
                  if (c == '\n')
                    {
                      /* fold lines when seeing backslash new-line sequence */
                      c = fgetc (f);
                    }
                  else
                    {
                      g_string_append_c (define_line, '\\');
                    }
                }
            }

          /* found object-like macro */
          fprintf (fmacros, "%s\n", define_line->str);

          c = eat_line (f, c);
          line++;
        }

      fclose (f);
    }

  rewind (fmacros);
  parse_file (scanner, fmacros);
  fclose (fmacros);
  g_unlink (tmp_name);
  g_free (tmp_name);
}

gboolean
gi_source_scanner_parse_file (GISourceScanner *scanner, const gchar *filename)
{
  FILE *file;
  gboolean result;

  file = g_fopen (filename, "r");
  result = parse_file (scanner, file);
  fclose (file);

  return result;
}

gboolean
gi_source_scanner_lex_filename (GISourceScanner *scanner, const gchar *filename)
{
  lineno = 1;
  yyin = g_fopen (filename, "r");

  while (yylex (scanner) != YYEOF)
    ;

  fclose (yyin);

  return TRUE;
}
