/* This is a generated file, see Makefile.am for its inputs. */
static const char riscv64_syscall_strings[] = "accept\0accept4\0acct\0add_key\0adjtimex\0bind\0bpf\0brk\0cachestat\0capget\0"
	"capset\0chdir\0chroot\0clock_adjtime\0clock_getres\0clock_gettime\0clock_nanosleep\0clock_settime\0clone\0clone3\0"
	"close\0close_range\0connect\0copy_file_range\0delete_module\0dup\0dup3\0epoll_create1\0epoll_ctl\0epoll_pwait\0"
	"epoll_pwait2\0eventfd2\0execve\0execveat\0exit\0exit_group\0faccessat\0faccessat2\0fadvise64\0fallocate\0"
	"fanotify_init\0fanotify_mark\0fchdir\0fchmod\0fchmodat\0fchmodat2\0fchown\0fchownat\0fcntl\0fdatasync\0"
	"fgetxattr\0finit_module\0flistxattr\0flock\0fremovexattr\0fsconfig\0fsetxattr\0fsmount\0fsopen\0fspick\0"
	"fstat\0fstatfs\0fsync\0ftruncate\0futex\0futex_requeue\0futex_wait\0futex_waitv\0futex_wake\0get_mempolicy\0"
	"get_robust_list\0getcpu\0getcwd\0getdents64\0getegid\0geteuid\0getgid\0getgroups\0getitimer\0getpeername\0"
	"getpgid\0getpid\0getppid\0getpriority\0getrandom\0getresgid\0getresuid\0getrlimit\0getrusage\0getsid\0"
	"getsockname\0getsockopt\0gettid\0gettimeofday\0getuid\0getxattr\0getxattrat\0init_module\0inotify_add_watch\0inotify_init1\0"
	"inotify_rm_watch\0io_cancel\0io_destroy\0io_getevents\0io_pgetevents\0io_setup\0io_submit\0io_uring_enter\0io_uring_register\0io_uring_setup\0"
	"ioctl\0ioprio_get\0ioprio_set\0kcmp\0kexec_file_load\0kexec_load\0keyctl\0kill\0landlock_add_rule\0landlock_create_ruleset\0"
	"landlock_restrict_self\0lgetxattr\0linkat\0listen\0listmount\0listxattr\0listxattrat\0llistxattr\0lookup_dcookie\0lremovexattr\0"
	"lseek\0lsetxattr\0lsm_get_self_attr\0lsm_list_modules\0lsm_set_self_attr\0madvise\0map_shadow_stack\0mbind\0membarrier\0memfd_create\0"
	"memfd_secret\0migrate_pages\0mincore\0mkdirat\0mknodat\0mlock\0mlock2\0mlockall\0mmap\0mount\0"
	"mount_setattr\0move_mount\0move_pages\0mprotect\0mq_getsetattr\0mq_notify\0mq_open\0mq_timedreceive\0mq_timedsend\0mq_unlink\0"
	"mremap\0mseal\0msgctl\0msgget\0msgrcv\0msgsnd\0msync\0munlock\0munlockall\0munmap\0"
	"name_to_handle_at\0nanosleep\0newfstatat\0nfsservctl\0open_by_handle_at\0open_tree\0open_tree_attr\0openat\0openat2\0perf_event_open\0"
	"personality\0pidfd_getfd\0pidfd_open\0pidfd_send_signal\0pipe2\0pivot_root\0pkey_alloc\0pkey_free\0pkey_mprotect\0ppoll\0"
	"prctl\0pread64\0preadv\0preadv2\0prlimit64\0process_madvise\0process_mrelease\0process_vm_readv\0process_vm_writev\0pselect6\0"
	"ptrace\0pwrite64\0pwritev\0pwritev2\0quotactl\0quotactl_fd\0read\0readahead\0readlinkat\0readv\0"
	"reboot\0recvfrom\0recvmmsg\0recvmsg\0remap_file_pages\0removexattr\0removexattrat\0renameat2\0request_key\0restart_syscall\0"
	"riscv_flush_icache\0riscv_hwprobe\0rseq\0rt_sigaction\0rt_sigpending\0rt_sigprocmask\0rt_sigqueueinfo\0rt_sigreturn\0rt_sigsuspend\0rt_sigtimedwait\0"
	"rt_tgsigqueueinfo\0sched_get_priority_max\0sched_get_priority_min\0sched_getaffinity\0sched_getattr\0sched_getparam\0sched_getscheduler\0sched_rr_get_interval\0sched_setaffinity\0sched_setattr\0"
	"sched_setparam\0sched_setscheduler\0sched_yield\0seccomp\0semctl\0semget\0semop\0semtimedop\0sendfile\0sendmmsg\0"
	"sendmsg\0sendto\0set_mempolicy\0set_mempolicy_home_node\0set_robust_list\0set_tid_address\0setdomainname\0setfsgid\0setfsuid\0setgid\0"
	"setgroups\0sethostname\0setitimer\0setns\0setpgid\0setpriority\0setregid\0setresgid\0setresuid\0setreuid\0"
	"setrlimit\0setsid\0setsockopt\0settimeofday\0setuid\0setxattr\0setxattrat\0shmat\0shmctl\0shmdt\0"
	"shmget\0shutdown\0sigaltstack\0signalfd4\0socket\0socketpair\0splice\0statfs\0statmount\0statx\0"
	"swapoff\0swapon\0symlinkat\0sync\0sync_file_range\0syncfs\0sysinfo\0syslog\0tee\0tgkill\0"
	"timer_create\0timer_delete\0timer_getoverrun\0timer_gettime\0timer_settime\0timerfd_create\0timerfd_gettime\0timerfd_settime\0times\0tkill\0"
	"truncate\0umask\0umount2\0uname\0unlinkat\0unshare\0userfaultfd\0utimensat\0vhangup\0vmsplice\0"
	"wait4\0waitid\0write\0writev";
static const unsigned riscv64_syscall_s2i_s[] = {
	0,7,15,20,28,37,42,46,50,60,
	67,74,80,87,101,114,128,144,158,164,
	171,177,189,197,213,227,231,236,250,260,
	272,285,294,301,310,315,326,336,347,357,
	367,381,395,402,409,418,428,435,444,450,
	460,470,483,494,500,513,522,532,540,547,
	554,560,568,574,584,590,604,615,627,638,
	652,668,675,682,693,701,709,716,726,736,
	748,756,763,771,783,793,803,813,823,833,
	840,852,863,870,883,890,899,910,922,940,
	954,971,981,992,1005,1019,1028,1038,1053,1071,
	1086,1092,1103,1114,1119,1135,1146,1153,1158,1176,
	1200,1223,1233,1240,1247,1257,1267,1279,1290,1305,
	1318,1324,1334,1352,1369,1387,1395,1412,1418,1429,
	1442,1455,1469,1477,1485,1493,1499,1506,1515,1520,
	1526,1540,1551,1562,1571,1585,1595,1603,1619,1632,
	1642,1649,1655,1662,1669,1676,1683,1689,1697,1708,
	1715,1733,1743,1754,1765,1783,1793,1808,1815,1823,
	1839,1851,1863,1874,1892,1898,1909,1920,1930,1944,
	1950,1956,1964,1971,1979,1989,2005,2022,2039,2057,
	2066,2073,2082,2090,2099,2108,2120,2125,2135,2146,
	2152,2159,2168,2177,2185,2202,2214,2228,2238,2250,
	2266,2285,2299,2304,2317,2331,2346,2362,2375,2389,
	2405,2423,2446,2469,2487,2501,2516,2535,2557,2575,
	2589,2604,2623,2635,2643,2650,2657,2663,2674,2683,
	2692,2700,2707,2721,2745,2761,2777,2791,2800,2809,
	2816,2826,2838,2848,2854,2862,2874,2883,2893,2903,
	2912,2922,2929,2940,2953,2960,2969,2980,2986,2993,
	2999,3006,3015,3027,3037,3044,3055,3062,3069,3079,
	3085,3093,3100,3110,3115,3131,3138,3146,3153,3157,
	3164,3177,3190,3207,3221,3235,3250,3266,3282,3288,
	3294,3303,3309,3317,3323,3332,3340,3352,3362,3370,
	3379,3385,3392,3398,
};
static const int riscv64_syscall_s2i_i[] = {
	202,242,89,217,171,200,280,214,451,90,
	91,49,51,266,114,113,115,112,220,435,
	57,436,203,285,106,23,24,20,21,22,
	441,19,221,281,93,94,48,439,223,47,
	262,263,50,52,53,452,55,54,25,83,
	10,273,13,32,16,431,7,432,430,433,
	80,44,82,46,98,456,455,449,454,236,
	100,168,17,61,177,175,176,158,102,205,
	155,172,173,141,278,150,148,163,165,156,
	204,209,178,169,174,8,464,105,27,26,
	28,3,1,4,292,0,2,426,427,425,
	29,31,30,272,294,104,219,129,445,444,
	446,9,37,201,458,11,465,12,18,15,
	62,6,459,461,460,233,453,235,283,279,
	447,238,232,34,33,228,284,230,222,40,
	442,429,239,226,185,184,180,183,182,181,
	216,462,187,186,188,189,227,229,231,215,
	264,101,79,42,265,428,467,56,437,241,
	92,438,434,424,59,41,289,290,288,73,
	167,67,69,286,261,440,448,270,271,72,
	117,68,70,287,60,443,63,213,78,65,
	142,207,243,212,234,14,466,276,218,128,
	259,258,293,134,136,135,138,139,133,137,
	240,125,126,123,275,121,120,127,122,274,
	118,119,124,277,191,190,193,192,71,269,
	211,206,237,450,99,96,162,152,151,144,
	159,161,103,268,154,140,143,149,147,145,
	164,157,208,170,146,5,463,196,195,197,
	194,210,132,74,198,199,76,43,457,291,
	225,224,36,81,84,267,179,116,77,131,
	107,111,109,108,110,85,87,86,153,130,
	45,166,39,160,35,97,282,88,58,75,
	260,95,64,66,
};
static int riscv64_syscall_s2i(const char *s, int *value) {
	size_t len, i;
	 if (s == NULL || value == NULL)
		return 0;
	len = strlen(s);
	{ char copy[len + 1];
	for (i = 0; i < len; i++) {
		char c = s[i];
		copy[i] = GT_ISUPPER(c) ? c - 'A' + 'a' : c;
	}
	copy[i] = 0;
	return s2i__(riscv64_syscall_strings, riscv64_syscall_s2i_s, riscv64_syscall_s2i_i, 324, copy, value);
	}
}
static const unsigned riscv64_syscall_i2s_direct[] = {
	1019,981,1028,971,992,2960,1324,522,890,1223,
	460,1257,1279,483,2202,1305,500,675,1290,285,
	236,250,260,227,231,444,940,922,954,1086,
	1103,1092,494,1485,1477,3323,3100,1233,-1u,3309,
	1520,1898,1754,3062,560,3294,574,357,326,74,
	395,80,402,409,435,428,1808,171,3362,1892,
	2099,682,1318,2120,3392,2146,3398,1956,2073,1964,
	2082,2674,2057,1944,3027,3370,3055,3153,2135,1743,
	554,3110,568,450,3115,3235,3266,3250,3352,15,
	60,67,1839,310,315,3385,2761,3332,584,2745,
	652,1733,726,2838,1135,910,213,3164,3207,3190,
	3221,3177,144,114,101,128,3146,2066,2589,2604,
	2516,2501,2557,2469,2623,2423,2446,2535,2250,1153,
	3288,3157,3015,2375,2304,2331,2317,2389,2346,2362,
	2862,771,2152,2874,2809,2903,2953,2893,803,2883,
	793,2800,2791,3282,2854,748,833,2922,716,2816,
	3317,2826,2777,813,2912,823,3303,1950,668,870,
	2940,28,756,763,883,701,709,693,863,3138,
	1595,1632,1619,1603,1585,1571,1662,1655,1669,1676,
	2650,2643,2663,2657,2999,2986,2980,2993,3037,3044,
	37,1240,0,189,840,736,2700,2159,2929,852,
	3006,2692,2177,2125,46,1708,1642,20,2238,1146,
	158,294,1515,347,3093,3085,1562,1683,1493,1689,
	1506,1697,1469,1387,2185,1412,638,2707,1455,1551,
	2405,1823,7,2168,-1u,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,2285,2266,
	3379,1979,367,381,1715,1765,87,3131,2848,2683,
	2022,2039,1114,470,2575,2487,2228,2635,783,1429,
	42,301,3340,1418,1499,197,1971,2090,1930,1909,
	1920,3079,1005,2299,1119,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,-1u,
	-1u,-1u,-1u,-1u,1874,1071,1038,1053,1783,1540,
	540,513,532,547,1863,164,177,1815,1851,336,
	1989,272,1526,2108,1176,1158,1200,1442,2005,615,
	2721,50,418,1395,627,604,590,3069,1247,1334,
	1369,1352,1649,2969,899,1267,2214,1793,
};
static const char *riscv64_syscall_i2s(int v) {
	return i2s_direct__(riscv64_syscall_strings, riscv64_syscall_i2s_direct, 0, 467, v);
}
