/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.43 from the
 * contents of POSIX.xs. Do not edit this file, edit POSIX.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "POSIX.xs"
#define PERL_EXT_POSIX
#define PERL_EXT

#ifdef NETWARE
	#define _POSIX_
	/*
	 * Ideally this should be somewhere down in the includes
	 * but putting it in other places is giving compiler errors.
	 * Also here I am unable to check for HAS_UNAME since it wouldn't have
	 * yet come into the file at this stage - sgp 18th Oct 2000
	 */
	#include <sys/utsname.h>
#endif	/* NETWARE */

#define PERL_NO_GET_CONTEXT

#include "EXTERN.h"
#define PERLIO_NOT_STDIO 1
#include "perl.h"
#include "XSUB.h"

static int not_here(const char *s);

#if defined(PERL_IMPLICIT_SYS)
#  undef signal
#  undef open
#  undef setmode
#  define open PerlLIO_open3
#endif
#include <ctype.h>
#ifdef I_DIRENT    /* XXX maybe better to just rely on perl.h? */
#include <dirent.h>
#endif
#include <errno.h>
#ifdef WIN32
#include <sys/errno2.h>
#endif
#include <float.h>
#ifdef I_FENV
#if !(defined(__vax__) && defined(__NetBSD__))
#include <fenv.h>
#endif
#endif
#include <limits.h>
#include <locale.h>
#include <math.h>
#ifdef I_PWD
#include <pwd.h>
#endif
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stddef.h>

#ifdef I_UNISTD
#include <unistd.h>
#endif

#ifdef I_SYS_TIME
# include <sys/time.h>
#endif

#ifdef I_SYS_RESOURCE
# include <sys/resource.h>
#endif

/* Cygwin's stdio.h doesn't make cuserid() visible with -D_GNU_SOURCE,
   unlike Linux.
*/
#ifdef __CYGWIN__
# undef HAS_CUSERID
#endif

#if defined(USE_QUADMATH) && defined(I_QUADMATH)

#  undef M_E
#  undef M_LOG2E
#  undef M_LOG10E
#  undef M_LN2
#  undef M_LN10
#  undef M_PI
#  undef M_PI_2
#  undef M_PI_4
#  undef M_1_PI
#  undef M_2_PI
#  undef M_2_SQRTPI
#  undef M_SQRT2
#  undef M_SQRT1_2

#  define M_E        M_Eq
#  define M_LOG2E    M_LOG2Eq
#  define M_LOG10E   M_LOG10Eq
#  define M_LN2      M_LN2q
#  define M_LN10     M_LN10q
#  define M_PI       M_PIq
#  define M_PI_2     M_PI_2q
#  define M_PI_4     M_PI_4q
#  define M_1_PI     M_1_PIq
#  define M_2_PI     M_2_PIq
#  define M_2_SQRTPI M_2_SQRTPIq
#  define M_SQRT2    M_SQRT2q
#  define M_SQRT1_2  M_SQRT1_2q

#else

#  ifdef USE_LONG_DOUBLE
#    undef M_E
#    undef M_LOG2E
#    undef M_LOG10E
#    undef M_LN2
#    undef M_LN10
#    undef M_PI
#    undef M_PI_2
#    undef M_PI_4
#    undef M_1_PI
#    undef M_2_PI
#    undef M_2_SQRTPI
#    undef M_SQRT2
#    undef M_SQRT1_2
#    define FLOAT_C(c) CAT2(c,L)
#  else
#    define FLOAT_C(c) (c)
#  endif

#  ifndef M_E
#    define M_E		FLOAT_C(2.71828182845904523536028747135266250)
#  endif
#  ifndef M_LOG2E
#    define M_LOG2E	FLOAT_C(1.44269504088896340735992468100189214)
#  endif
#  ifndef M_LOG10E
#    define M_LOG10E	FLOAT_C(0.434294481903251827651128918916605082)
#  endif
#  ifndef M_LN2
#    define M_LN2	FLOAT_C(0.693147180559945309417232121458176568)
#  endif
#  ifndef M_LN10
#    define M_LN10	FLOAT_C(2.30258509299404568401799145468436421)
#  endif
#  ifndef M_PI
#    define M_PI	FLOAT_C(3.14159265358979323846264338327950288)
#  endif
#  ifndef M_PI_2
#    define M_PI_2	FLOAT_C(1.57079632679489661923132169163975144)
#  endif
#  ifndef M_PI_4
#    define M_PI_4	FLOAT_C(0.785398163397448309615660845819875721)
#  endif
#  ifndef M_1_PI
#    define M_1_PI	FLOAT_C(0.318309886183790671537767526745028724)
#  endif
#  ifndef M_2_PI
#    define M_2_PI	FLOAT_C(0.636619772367581343075535053490057448)
#  endif
#  ifndef M_2_SQRTPI
#    define M_2_SQRTPI	FLOAT_C(1.12837916709551257389615890312154517)
#  endif
#  ifndef M_SQRT2
#    define M_SQRT2	FLOAT_C(1.41421356237309504880168872420969808)
#  endif
#  ifndef M_SQRT1_2
#    define M_SQRT1_2	FLOAT_C(0.707106781186547524400844362104849039)
#  endif

#endif

#if !defined(INFINITY) && defined(NV_INF)
#  define INFINITY NV_INF
#endif

#if !defined(NAN) && defined(NV_NAN)
#  define NAN NV_NAN
#endif

#if !defined(Inf) && defined(NV_INF)
#  define Inf NV_INF
#endif

#if !defined(NaN) && defined(NV_NAN)
#  define NaN NV_NAN
#endif

/* We will have an emulation. */
#ifndef FP_INFINITE
#  define FP_INFINITE	0
#  define FP_NAN	1
#  define FP_NORMAL	2
#  define FP_SUBNORMAL	3
#  define FP_ZERO	4
#endif

/* We will have an emulation. */
#ifndef FE_TONEAREST
#  define FE_TOWARDZERO	0
#  define FE_TONEAREST	1
#  define FE_UPWARD	2
#  define FE_DOWNWARD	3
#endif

/* C89 math.h:

   acos asin atan atan2 ceil cos cosh exp fabs floor fmod frexp ldexp
   log log10 modf pow sin sinh sqrt tan tanh

 * Implemented in core:

   atan2 cos exp log pow sin sqrt

 * C99 math.h added:

   acosh asinh atanh cbrt copysign erf erfc exp2 expm1 fdim fma fmax
   fmin fpclassify hypot ilogb isfinite isgreater isgreaterequal isinf
   isless islessequal islessgreater isnan isnormal isunordered lgamma
   log1p log2 logb lrint lround nan nearbyint nextafter nexttoward remainder
   remquo rint round scalbn signbit tgamma trunc

   See:
   http://pubs.opengroup.org/onlinepubs/009695399/basedefs/math.h.html

 * Berkeley/SVID extensions:

   j0 j1 jn y0 y1 yn

 * Configure already (5.21.5) scans for:

   copysign*l* fpclassify isfinite isinf isnan isnan*l* ilogb*l* signbit scalbn*l*

 * For floating-point round mode (which matters for e.g. lrint and rint)

   fegetround fesetround

*/

/* XXX Constant FP_FAST_FMA (if true, FMA is faster) */

/* XXX Add ldiv(), lldiv()?  It's C99, but from stdlib.h, not math.h  */

/* XXX Beware old gamma() -- one cannot know whether that is the
 * gamma or the log of gamma, that's why the new tgamma and lgamma.
 * Though also remember lgamma_r. */

/* Certain AIX releases have the C99 math, but not in long double.
 * The <math.h> has them, e.g. __expl128, but no library has them!
 *
 * Also see the comments in hints/aix.sh about long doubles. */

#if defined(USE_QUADMATH) && defined(I_QUADMATH)
#  define c99_acosh	acoshq
#  define c99_asinh	asinhq
#  define c99_atanh	atanhq
#  define c99_cbrt	cbrtq
#  define c99_copysign	copysignq
#  define c99_erf	erfq
#  define c99_erfc	erfcq
/* no exp2q */
#  define c99_expm1	expm1q
#  define c99_fdim	fdimq
#  define c99_fma	fmaq
#  define c99_fmax	fmaxq
#  define c99_fmin	fminq
#  define c99_hypot	hypotq
#  define c99_ilogb	ilogbq
#  define c99_lgamma	lgammaq
#  define c99_log1p	log1pq
#  define c99_log2	log2q
/* no logbq */
#  if defined(USE_64_BIT_INT) && QUADKIND == QUAD_IS_LONG_LONG
#    define c99_lrint	llrintq
#    define c99_lround	llroundq
#  else
#    define c99_lrint	lrintq
#    define c99_lround	lroundq
#  endif
#  define c99_nan	nanq
#  define c99_nearbyint	nearbyintq
#  define c99_nextafter	nextafterq
/* no nexttowardq */
#  define c99_remainder	remainderq
#  define c99_remquo	remquoq
#  define c99_rint	rintq
#  define c99_round	roundq
#  define c99_scalbn	scalbnq
/* We already define Perl_signbit to signbitq in perl.h. */
#  define c99_tgamma	tgammaq
#  define c99_trunc	truncq
#  define bessel_j0 j0q
#  define bessel_j1 j1q
#  define bessel_jn jnq
#  define bessel_y0 y0q
#  define bessel_y1 y1q
#  define bessel_yn ynq
#elif defined(USE_LONG_DOUBLE) && \
  (defined(HAS_FREXPL) || defined(HAS_ILOGBL)) && defined(HAS_SQRTL)
/* Use some of the Configure scans for long double math functions
 * as the canary for all the C99 *l variants being defined. */
#  define c99_acosh	acoshl
#  define c99_asinh	asinhl
#  define c99_atanh	atanhl
#  define c99_cbrt	cbrtl
#  define c99_copysign	copysignl
#  define c99_erf	erfl
#  define c99_erfc	erfcl
#  define c99_exp2	exp2l
#  define c99_expm1	expm1l
#  define c99_fdim	fdiml
#  define c99_fma	fmal
#  define c99_fmax	fmaxl
#  define c99_fmin	fminl
#  define c99_hypot	hypotl
#  define c99_ilogb	ilogbl
#  define c99_lgamma	lgammal
#  define c99_log1p	log1pl
#  define c99_log2	log2l
#  define c99_logb	logbl
#  if defined(USE_64_BIT_INT) && QUADKIND == QUAD_IS_LONG_LONG && defined(HAS_LLRINTL)
#    define c99_lrint	llrintl
#  elif defined(HAS_LRINTL)
#    define c99_lrint	lrintl
#  endif
#  if defined(USE_64_BIT_INT) && QUADKIND == QUAD_IS_LONG_LONG && defined(HAS_LLROUNDL)
#    define c99_lround	llroundl
#  elif defined(HAS_LROUNDL)
#    define c99_lround	lroundl
#  endif
#  define c99_nan	nanl
#  define c99_nearbyint	nearbyintl
#  define c99_nextafter	nextafterl
#  define c99_nexttoward	nexttowardl
#  define c99_remainder	remainderl
#  define c99_remquo	remquol
#  define c99_rint	rintl
#  define c99_round	roundl
#  define c99_scalbn	scalbnl
/* We already define Perl_signbit in perl.h. */
#  define c99_tgamma	tgammal
#  define c99_trunc	truncl
#else
#  define c99_acosh	acosh
#  define c99_asinh	asinh
#  define c99_atanh	atanh
#  define c99_cbrt	cbrt
#  define c99_copysign	copysign
#  define c99_erf	erf
#  define c99_erfc	erfc
#  define c99_exp2	exp2
#  define c99_expm1	expm1
#  define c99_fdim	fdim
#  define c99_fma	fma
#  define c99_fmax	fmax
#  define c99_fmin	fmin
#  define c99_hypot	hypot
#  define c99_ilogb	ilogb
#  define c99_lgamma	lgamma
#  define c99_log1p	log1p
#  define c99_log2	log2
#  define c99_logb	logb
#  if defined(USE_64_BIT_INT) && QUADKIND == QUAD_IS_LONG_LONG && defined(HAS_LLRINT)
#    define c99_lrint	llrint
#  else
#    define c99_lrint	lrint
#  endif
#  if defined(USE_64_BIT_INT) && QUADKIND == QUAD_IS_LONG_LONG && defined(HAS_LLROUND)
#    define c99_lround	llround
#  else
#    define c99_lround	lround
#  endif
#  define c99_nan	nan
#  define c99_nearbyint	nearbyint
#  define c99_nextafter	nextafter
#  define c99_nexttoward	nexttoward
#  define c99_remainder	remainder
#  define c99_remquo	remquo
#  define c99_rint	rint
#  define c99_round	round
#  define c99_scalbn	scalbn
/* We already define Perl_signbit in perl.h. */
#  define c99_tgamma	tgamma
#  define c99_trunc	trunc
#endif

/* AIX xlc (__IBMC__) really doesn't have the following long double
 * math interfaces (no __acoshl128 aka acoshl, etc.), see
 * hints/aix.sh.  These are in the -lc128 but fail to be found
 * during dynamic linking/loading.
 *
 * XXX1 Better Configure scans
 * XXX2 Is this xlc version dependent? */
#if defined(USE_LONG_DOUBLE) && defined(__IBMC__)
#  undef c99_acosh
#  undef c99_asinh
#  undef c99_atanh
#  undef c99_cbrt
#  undef c99_copysign
#  undef c99_exp2
#  undef c99_expm1
#  undef c99_fdim
#  undef c99_fma
#  undef c99_fmax
#  undef c99_fmin
#  undef c99_hypot
#  undef c99_ilogb
#  undef c99_lrint
#  undef c99_lround
#  undef c99_log1p
#  undef c99_log2
#  undef c99_logb
#  undef c99_nan
#  undef c99_nearbyint
#  undef c99_nextafter
#  undef c99_nexttoward
#  undef c99_remainder
#  undef c99_remquo
#  undef c99_rint
#  undef c99_round
#  undef c99_scalbn
#  undef c99_tgamma
#  undef c99_trunc
#endif

/* The cc with NetBSD 8.0 and 9.0 claims to be a C11 hosted compiler,
 * but doesn't define several functions required by C99, let alone C11.
 * http://gnats.netbsd.org/53234
 */
#if defined(USE_LONG_DOUBLE) && defined(__NetBSD__) \
  && !defined(NETBSD_HAVE_FIXED_LONG_DOUBLE_MATH)
#  undef c99_expm1
#  undef c99_lgamma
#  undef c99_log1p
#  undef c99_log2
#  undef c99_nexttoward
#  undef c99_remainder
#  undef c99_remquo
#  undef c99_tgamma
#endif

#ifndef isunordered
#  ifdef Perl_isnan
#    define isunordered(x, y) (Perl_isnan(x) || Perl_isnan(y))
#  elif defined(HAS_UNORDERED)
#    define isunordered(x, y) unordered(x, y)
#  endif
#endif

/* XXX these isgreater/isnormal/isunordered macros definitions should
 * be moved further in the file to be part of the emulations, so that
 * platforms can e.g. #undef c99_isunordered and have it work like
 * it does for the other interfaces. */

#if !defined(isgreater) && defined(isunordered)
#  define isgreater(x, y)         (!isunordered((x), (y)) && (x) > (y))
#  define isgreaterequal(x, y)    (!isunordered((x), (y)) && (x) >= (y))
#  define isless(x, y)            (!isunordered((x), (y)) && (x) < (y))
#  define islessequal(x, y)       (!isunordered((x), (y)) && (x) <= (y))
#  define islessgreater(x, y)     (!isunordered((x), (y)) && \
                                     ((x) > (y) || (y) > (x)))
#endif

/* Check both the Configure symbol and the macro-ness (like C99 promises). */ 
#if defined(HAS_FPCLASSIFY) && defined(fpclassify)
#  define c99_fpclassify	fpclassify
#endif
/* Like isnormal(), the isfinite(), isinf(), and isnan() are also C99
   and also (sizeof-arg-aware) macros, but they are already well taken
   care of by Configure et al, and defined in perl.h as
   Perl_isfinite(), Perl_isinf(), and Perl_isnan(). */
#ifdef isnormal
#  define c99_isnormal	isnormal
#endif
#ifdef isgreater /* canary for all the C99 is*<cmp>* macros. */
#  define c99_isgreater	isgreater
#  define c99_isgreaterequal	isgreaterequal
#  define c99_isless		isless
#  define c99_islessequal	islessequal
#  define c99_islessgreater	islessgreater
#  define c99_isunordered	isunordered
#endif

/* The Great Wall of Undef where according to the definedness of HAS_FOO symbols
 * the corresponding c99_foo wrappers are undefined.  This list doesn't include
 * the isfoo() interfaces because they are either type-aware macros, or dealt
 * separately, already in perl.h */

#ifndef HAS_ACOSH
#  undef c99_acosh
#endif
#ifndef HAS_ASINH
#  undef c99_asinh
#endif
#ifndef HAS_ATANH
#  undef c99_atanh
#endif
#ifndef HAS_CBRT
#  undef c99_cbrt
#endif
#ifndef HAS_COPYSIGN
#  undef c99_copysign
#endif
#ifndef HAS_ERF
#  undef c99_erf
#endif
#ifndef HAS_ERFC
#  undef c99_erfc
#endif
#ifndef HAS_EXP2
#  undef c99_exp2
#endif
#ifndef HAS_EXPM1
#  undef c99_expm1
#endif
#ifndef HAS_FDIM
#  undef c99_fdim
#endif
#ifndef HAS_FMA
#  undef c99_fma
#endif
#ifndef HAS_FMAX
#  undef c99_fmax
#endif
#ifndef HAS_FMIN
#  undef c99_fmin
#endif
#ifndef HAS_FPCLASSIFY
#  undef c99_fpclassify
#endif
#ifndef HAS_HYPOT
#  undef c99_hypot
#endif
#ifndef HAS_ILOGB
#  undef c99_ilogb
#endif
#ifndef HAS_LGAMMA
#  undef c99_lgamma
#endif
#ifndef HAS_LOG1P
#  undef c99_log1p
#endif
#ifndef HAS_LOG2
#  undef c99_log2
#endif
#ifndef HAS_LOGB
#  undef c99_logb
#endif
#ifndef HAS_LRINT
#  undef c99_lrint
#endif
#ifndef HAS_LROUND
#  undef c99_lround
#endif
#ifndef HAS_NAN
#  undef c99_nan
#endif
#ifndef HAS_NEARBYINT
#  undef c99_nearbyint
#endif
#ifndef HAS_NEXTAFTER
#  undef c99_nextafter
#endif
#ifndef HAS_NEXTTOWARD
#  undef c99_nexttoward
#endif
#ifndef HAS_REMAINDER
#  undef c99_remainder
#endif
#ifndef HAS_REMQUO
#  undef c99_remquo
#endif
#ifndef HAS_RINT
#  undef c99_rint
#endif
#ifndef HAS_ROUND
#  undef c99_round
#endif
#ifndef HAS_SCALBN
#  undef c99_scalbn
#endif
#ifndef HAS_TGAMMA
#  undef c99_tgamma
#endif
#ifndef HAS_TRUNC
#  undef c99_trunc
#endif

#ifdef _MSC_VER

/* Some APIs exist under Win32 with "underbar" names. */
#  undef c99_hypot
#  undef c99_logb
#  undef c99_nextafter
#  define c99_hypot _hypot
#  define c99_logb _logb
#  define c99_nextafter _nextafter

#  define bessel_j0 _j0
#  define bessel_j1 _j1
#  define bessel_jn _jn
#  define bessel_y0 _y0
#  define bessel_y1 _y1
#  define bessel_yn _yn

#endif

/* The Bessel functions: BSD, SVID, XPG4, and POSIX.  But not C99. */
#if defined(HAS_J0) && !defined(bessel_j0)
#  if defined(USE_LONG_DOUBLE) && defined(HAS_J0L)
#    define bessel_j0 j0l
#    define bessel_j1 j1l
#    define bessel_jn jnl
#    define bessel_y0 y0l
#    define bessel_y1 y1l
#    define bessel_yn ynl
#  else
#    define bessel_j0 j0
#    define bessel_j1 j1
#    define bessel_jn jn
#    define bessel_y0 y0
#    define bessel_y1 y1
#    define bessel_yn yn
#  endif
#endif

/* Emulations for missing math APIs.
 *
 * Keep in mind that the point of many of these functions is that
 * they, if available, are supposed to give more precise/more
 * numerically stable results.
 *
 * See e.g. http://www.johndcook.com/math_h.html
 */

#ifndef c99_acosh
static NV my_acosh(NV x)
{
  return Perl_log(x + Perl_sqrt(x * x - 1));
}
#  define c99_acosh my_acosh
#endif

#ifndef c99_asinh
static NV my_asinh(NV x)
{
  return Perl_log(x + Perl_sqrt(x * x + 1));
}
#  define c99_asinh my_asinh
#endif

#ifndef c99_atanh
static NV my_atanh(NV x)
{
  return (Perl_log(1 + x) - Perl_log(1 - x)) / 2;
}
#  define c99_atanh my_atanh
#endif

#ifndef c99_cbrt
static NV my_cbrt(NV x)
{
  static const NV one_third = (NV)1.0/3;
  return x >= 0.0 ? Perl_pow(x, one_third) : -Perl_pow(-x, one_third);
}
#  define c99_cbrt my_cbrt
#endif

#ifndef c99_copysign
static NV my_copysign(NV x, NV y)
{
  return y >= 0 ? (x < 0 ? -x : x) : (x < 0 ? x : -x);
}
#  define c99_copysign my_copysign
#endif

/* XXX cosh (though c89) */

#ifndef c99_erf
static NV my_erf(NV x)
{
  /* http://www.johndcook.com/cpp_erf.html -- public domain */
  NV a1 =  0.254829592;
  NV a2 = -0.284496736;
  NV a3 =  1.421413741;
  NV a4 = -1.453152027;
  NV a5 =  1.061405429;
  NV p  =  0.3275911;
  NV t, y;
  int sign = x < 0 ? -1 : 1; /* Save the sign. */
  x = PERL_ABS(x);

  /* Abramowitz and Stegun formula 7.1.26 */
  t = 1.0 / (1.0 + p * x);
  y = 1.0 - (((((a5*t + a4)*t) + a3)*t + a2)*t + a1) * t * Perl_exp(-x*x);

  return sign * y;
}
#  define c99_erf my_erf
#endif

#ifndef c99_erfc
static NV my_erfc(NV x) {
  /* This is not necessarily numerically stable, but better than nothing. */
  return 1.0 - c99_erf(x);
}
#  define c99_erfc my_erfc
#endif

#ifndef c99_exp2
static NV my_exp2(NV x)
{
  return Perl_pow((NV)2.0, x);
}
#  define c99_exp2 my_exp2
#endif

#ifndef c99_expm1
static NV my_expm1(NV x)
{
  if (PERL_ABS(x) < 1e-5)
    /* http://www.johndcook.com/cpp_expm1.html -- public domain.
     * Taylor series, the first four terms (the last term quartic). */
    /* Probably not enough for long doubles. */
    return x * (1.0 + x * (1/2.0 + x * (1/6.0 + x/24.0)));
  else
    return Perl_exp(x) - 1;
}
#  define c99_expm1 my_expm1
#endif

#ifndef c99_fdim
static NV my_fdim(NV x, NV y)
{
#ifdef NV_NAN
  return (Perl_isnan(x) || Perl_isnan(y)) ? NV_NAN : (x > y ? x - y : 0);
#else
  return (x > y ? x - y : 0);
#endif
}
#  define c99_fdim my_fdim
#endif

#ifndef c99_fma
static NV my_fma(NV x, NV y, NV z)
{
  return (x * y) + z;
}
#  define c99_fma my_fma
#endif

#ifndef c99_fmax
static NV my_fmax(NV x, NV y)
{
#ifdef NV_NAN
  if (Perl_isnan(x)) {
    return Perl_isnan(y) ? NV_NAN : y;
  } else if (Perl_isnan(y)) {
    return x;
  }
#endif
  return x > y ? x : y;
}
#  define c99_fmax my_fmax
#endif

#ifndef c99_fmin
static NV my_fmin(NV x, NV y)
{
#ifdef NV_NAN
  if (Perl_isnan(x)) {
    return Perl_isnan(y) ? NV_NAN : y;
  } else if (Perl_isnan(y)) {
    return x;
  }
#endif
  return x < y ? x : y;
}
#  define c99_fmin my_fmin
#endif

#ifndef c99_fpclassify

static IV my_fpclassify(NV x)
{
#ifdef Perl_fp_class_inf
  if (Perl_fp_class_inf(x))    return FP_INFINITE;
  if (Perl_fp_class_nan(x))    return FP_NAN;
  if (Perl_fp_class_norm(x))   return FP_NORMAL;
  if (Perl_fp_class_denorm(x)) return FP_SUBNORMAL;
  if (Perl_fp_class_zero(x))   return FP_ZERO;
#  define c99_fpclassify my_fpclassify
#endif
  return -1;
}

#endif

#ifndef c99_hypot
static NV my_hypot(NV x, NV y)
{
  /* http://en.wikipedia.org/wiki/Hypot */
  NV t;
  x = PERL_ABS(x); /* Take absolute values. */
  if (y == 0)
    return x;
#ifdef NV_INF
  if (Perl_isnan(y))
    return NV_INF;
#endif
  y = PERL_ABS(y);
  if (x < y) { /* Swap so that y is less. */
    t = x;
    x = y;
    y = t;
  }
  t = y / x;
  return x * Perl_sqrt(1.0 + t * t);
}
#  define c99_hypot my_hypot
#endif

#ifndef c99_ilogb
static IV my_ilogb(NV x)
{
  return (IV)(Perl_log(x) * M_LOG2E);
}
#  define c99_ilogb my_ilogb
#endif

/* tgamma and lgamma emulations based on
 * http://www.johndcook.com/cpp_gamma.html,
 * code placed in public domain.
 *
 * Note that these implementations (neither the johndcook originals
 * nor these) do NOT set the global signgam variable.  This is not
 * necessarily a bad thing. */

/* Note that the tgamma() and lgamma() implementations
 * here depend on each other. */

#if !defined(HAS_TGAMMA) || !defined(c99_tgamma)
static NV my_tgamma(NV x);
#  define c99_tgamma my_tgamma
#  define USE_MY_TGAMMA
#endif
#if !defined(HAS_LGAMMA) || !defined(c99_lgamma)
static NV my_lgamma(NV x);
#  define c99_lgamma my_lgamma
#  define USE_MY_LGAMMA
#endif

#ifdef USE_MY_TGAMMA
static NV my_tgamma(NV x)
{
  const NV gamma = 0.577215664901532860606512090; /* Euler's gamma constant. */
#ifdef NV_NAN
  if (Perl_isnan(x) || x < 0.0)
    return NV_NAN;
#endif
#ifdef NV_INF
  if (x == 0.0 || x == NV_INF)
#ifdef DOUBLE_IS_IEEE_FORMAT
    return x == -0.0 ? -NV_INF : NV_INF;
#else
    return NV_INF;
#endif
#endif

  /* The function domain is split into three intervals:
   * (0, 0.001), [0.001, 12), and (12, infinity) */

  /* First interval: (0, 0.001)
   * For small values, 1/tgamma(x) has power series x + gamma x^2,
   * so in this range, 1/tgamma(x) = x + gamma x^2 with error on the order of x^3.
   * The relative error over this interval is less than 6e-7. */
  if (x < 0.001)
    return 1.0 / (x * (1.0 + gamma * x));

  /* Second interval: [0.001, 12) */
  if (x < 12.0) {
    double y = x; /* Working copy. */
    int n = 0;
    /* Numerator coefficients for approximation over the interval (1,2) */
    static const NV p[] = {
      -1.71618513886549492533811E+0,
      2.47656508055759199108314E+1,
      -3.79804256470945635097577E+2,
      6.29331155312818442661052E+2,
      8.66966202790413211295064E+2,
      -3.14512729688483675254357E+4,
      -3.61444134186911729807069E+4,
      6.64561438202405440627855E+4
    };
    /* Denominator coefficients for approximation over the interval (1, 2) */
    static const NV q[] = {
      -3.08402300119738975254353E+1,
      3.15350626979604161529144E+2,
      -1.01515636749021914166146E+3,
      -3.10777167157231109440444E+3,
      2.25381184209801510330112E+4,
      4.75584627752788110767815E+3,
      -1.34659959864969306392456E+5,
      -1.15132259675553483497211E+5
    };
    NV num = 0.0;
    NV den = 1.0;
    NV z;
    NV result;
    int i;

    if (x < 1.0)
      y += 1.0;
    else {
      n = (int)Perl_floor(y) - 1;
      y -= n;
    }
    z = y - 1;
    for (i = 0; i < 8; i++) {
      num = (num + p[i]) * z;
      den = den * z + q[i];
    }
    result = num / den + 1.0;

    if (x < 1.0) {
      /* Use the identity tgamma(z) = tgamma(z+1)/z
       * The variable "result" now holds tgamma of the original y + 1
       * Thus we use y - 1 to get back the original y. */
      result /= (y - 1.0);
    }
    else {
      /* Use the identity tgamma(z+n) = z*(z+1)* ... *(z+n-1)*tgamma(z) */
      for (i = 0; i < n; i++)
        result *= y++;
    }

    return result;
  }

#ifdef NV_INF
  /* Third interval: [12, +Inf) */
#if LDBL_MANT_DIG == 113 /* IEEE quad prec */
  if (x > 1755.548) {
    return NV_INF;
  }
#else
  if (x > 171.624) {
    return NV_INF;
  }
#endif
#endif

  return Perl_exp(c99_lgamma(x));
}
#endif

#ifdef USE_MY_LGAMMA
static NV my_lgamma(NV x)
{
#ifdef NV_NAN
  if (Perl_isnan(x))
    return NV_NAN;
#endif
#ifdef NV_INF
  if (x <= 0 || x == NV_INF)
    return NV_INF;
#endif
  if (x == 1.0 || x == 2.0)
    return 0;
  if (x < 12.0)
    return Perl_log(PERL_ABS(c99_tgamma(x)));
  /* Abramowitz and Stegun 6.1.41
   * Asymptotic series should be good to at least 11 or 12 figures
   * For error analysis, see Whittiker and Watson
   * A Course in Modern Analysis (1927), page 252 */
  {
    static const NV c[8] = {
      1.0/12.0,
      -1.0/360.0,
      1.0/1260.0,
      -1.0/1680.0,
      1.0/1188.0,
      -691.0/360360.0,
      1.0/156.0,
      -3617.0/122400.0
    };
    NV z = 1.0 / (x * x);
    NV sum = c[7];
    static const NV half_log_of_two_pi =
      0.91893853320467274178032973640562;
    NV series;
    int i;
    for (i = 6; i >= 0; i--) {
      sum *= z;
      sum += c[i];
    }
    series = sum / x;
    return (x - 0.5) * Perl_log(x) - x + half_log_of_two_pi + series;
  }
}
#endif

#ifndef c99_log1p
static NV my_log1p(NV x)
{
  /* http://www.johndcook.com/cpp_log_one_plus_x.html -- public domain.
   * Taylor series, the first four terms (the last term quartic). */
#ifdef NV_NAN
  if (x < -1.0)
    return NV_NAN;
#endif
#ifdef NV_INF
  if (x == -1.0)
    return -NV_INF;
#endif
  if (PERL_ABS(x) > 1e-4)
    return Perl_log(1.0 + x);
  else
    /* Probably not enough for long doubles. */
    return x * (1.0 + x * (-1/2.0 + x * (1/3.0 - x/4.0)));
}
#  define c99_log1p my_log1p
#endif

#ifndef c99_log2
static NV my_log2(NV x)
{
  return Perl_log(x) * M_LOG2E;
}
#  define c99_log2 my_log2
#endif

/* XXX nextafter */

/* XXX nexttoward */

static int my_fegetround()
{
#ifdef HAS_FEGETROUND
  return fegetround();
#elif defined(HAS_FPGETROUND)
  switch (fpgetround()) {
  case FP_RN: return FE_TONEAREST;
  case FP_RZ: return FE_TOWARDZERO;
  case FP_RM: return FE_DOWNWARD;
  case FP_RP: return FE_UPWARD;
  default: return -1;
  }
#elif defined(FLT_ROUNDS)
  switch (FLT_ROUNDS) {
  case 0: return FE_TOWARDZERO;
  case 1: return FE_TONEAREST;
  case 2: return FE_UPWARD;
  case 3: return FE_DOWNWARD;
  default: return -1;
  }
#elif defined(__osf__) /* Tru64 */
  switch (read_rnd()) {
  case FP_RND_RN: return FE_TONEAREST;
  case FP_RND_RZ: return FE_TOWARDZERO;
  case FP_RND_RM: return FE_DOWNWARD;
  case FP_RND_RP: return FE_UPWARD;
  default: return -1;
  }
#else
  return -1;
#endif
}

/* Toward closest integer. */
#define MY_ROUND_NEAREST(x) ((NV)((IV)((x) >= 0.0 ? (x) + 0.5 : (x) - 0.5)))

/* Toward zero. */
#define MY_ROUND_TRUNC(x) ((NV)((IV)(x)))

/* Toward minus infinity. */
#define MY_ROUND_DOWN(x) ((NV)((IV)((x) >= 0.0 ? (x) : (x) - 0.5)))

/* Toward plus infinity. */
#define MY_ROUND_UP(x) ((NV)((IV)((x) >= 0.0 ? (x) + 0.5 : (x))))

#if (!defined(c99_nearbyint) || !defined(c99_lrint)) && defined(FE_TONEAREST)
static NV my_rint(NV x)
{
#ifdef FE_TONEAREST
  switch (my_fegetround()) {
  case FE_TONEAREST:  return MY_ROUND_NEAREST(x);
  case FE_TOWARDZERO: return MY_ROUND_TRUNC(x);
  case FE_DOWNWARD:   return MY_ROUND_DOWN(x);
  case FE_UPWARD:     return MY_ROUND_UP(x);
  default: break;
  }
#elif defined(HAS_FPGETROUND)
  switch (fpgetround()) {
  case FP_RN: return MY_ROUND_NEAREST(x);
  case FP_RZ: return MY_ROUND_TRUNC(x);
  case FP_RM: return MY_ROUND_DOWN(x);
  case FE_RP: return MY_ROUND_UP(x);
  default: break;
  }
#endif
  not_here("rint");
  NOT_REACHED; /* NOTREACHED */
}
#endif

/* XXX nearbyint() and rint() are not really identical -- but the difference
 * is messy: nearbyint is defined NOT to raise FE_INEXACT floating point
 * exceptions, while rint() is defined to MAYBE raise them.  At the moment
 * Perl is blissfully unaware of such fine detail of floating point. */
#ifndef c99_nearbyint
#  ifdef FE_TONEAREST
#    define c99_nearbyrint my_rint
#  endif
#endif

#ifndef c99_lrint
#  ifdef FE_TONEAREST
static IV my_lrint(NV x)
{
  return (IV)my_rint(x);
}
#    define c99_lrint my_lrint
#  endif
#endif

#ifndef c99_lround
static IV my_lround(NV x)
{
  return (IV)MY_ROUND_NEAREST(x);
}
#  define c99_lround my_lround
#endif

/* XXX remainder */

/* XXX remquo */

#ifndef c99_rint
#  ifdef FE_TONEAREST
#    define c99_rint my_rint
#  endif
#endif

#ifndef c99_round
static NV my_round(NV x)
{
  return MY_ROUND_NEAREST(x);
}
#  define c99_round my_round
#endif

#ifndef c99_scalbn
#   if defined(Perl_ldexp) && FLT_RADIX == 2
static NV my_scalbn(NV x, int y)
{
  return Perl_ldexp(x, y);
}
#    define c99_scalbn my_scalbn
#  endif
#endif

/* XXX sinh (though c89) */

/* tgamma -- see lgamma */

/* XXX tanh (though c89) */

#ifndef c99_trunc
static NV my_trunc(NV x)
{
  return MY_ROUND_TRUNC(x);
}
#  define c99_trunc my_trunc
#endif

#ifdef NV_NAN

#undef NV_PAYLOAD_DEBUG

/* NOTE: the NaN payload API implementation is hand-rolled, since the
 * APIs are only proposed ones as of June 2015, so very few, if any,
 * platforms have implementations yet, so HAS_SETPAYLOAD and such are
 * unlikely to be helpful.
 *
 * XXX - if the core numification wants to actually generate
 * the nan payload in "nan(123)", and maybe "nans(456)", for
 * signaling payload", this needs to be moved to e.g. numeric.c
 * (look for grok_infnan)
 *
 * Conversely, if the core stringification wants the nan payload
 * and/or the nan quiet/signaling distinction, S_getpayload()
 * from this file needs to be moved, to e.g. sv.c (look for S_infnan_2pv),
 * and the (trivial) functionality of issignaling() copied
 * (for generating "NaNS", or maybe even "NaNQ") -- or maybe there
 * are too many formatting parameters for simple stringification?
 */

/* While it might make sense for the payload to be UV or IV,
 * to avoid conversion loss, the proposed ISO interfaces use
 * a floating point input, which is then truncated to integer,
 * and only the integer part being used.  This is workable,
 * except for: (1) the conversion loss (2) suboptimal for
 * 32-bit integer platforms.  A workaround API for (2) and
 * in general for bit-honesty would be an array of integers
 * as the payload... but the proposed C API does nothing of
 * the kind. */
#if NVSIZE == UVSIZE
#  define NV_PAYLOAD_TYPE UV
#else
#  define NV_PAYLOAD_TYPE NV
#endif

#if defined(USE_LONG_DOUBLE) && defined(LONGDOUBLE_DOUBLEDOUBLE)
#  define NV_PAYLOAD_SIZEOF_ASSERT(a) \
    STATIC_ASSERT_STMT(sizeof(a) == NVSIZE / 2)
#else
#  define NV_PAYLOAD_SIZEOF_ASSERT(a) \
    STATIC_ASSERT_STMT(sizeof(a) == NVSIZE)
#endif

static void S_setpayload(NV* nvp, NV_PAYLOAD_TYPE payload, bool signaling)
{
  dTHX;
  static const U8 m[] = { NV_NAN_PAYLOAD_MASK };
  static const U8 p[] = { NV_NAN_PAYLOAD_PERM };
  UV a[(NVSIZE + UVSIZE - 1) / UVSIZE] = { 0 };
  int i;
  NV_PAYLOAD_SIZEOF_ASSERT(m);
  NV_PAYLOAD_SIZEOF_ASSERT(p);
  *nvp = NV_NAN;
  /* Divide the input into the array in "base unsigned integer" in
   * little-endian order.  Note that the integer might be smaller than
   * an NV (if UV is U32, for example). */
#if NVSIZE == UVSIZE
  a[0] = payload;  /* The trivial case. */
#else
  {
    NV t1 = c99_trunc(payload); /* towards zero (drop fractional) */
#ifdef NV_PAYLOAD_DEBUG
    Perl_warn(aTHX_ "t1 = %" NVgf " (payload %" NVgf ")\n", t1, payload);
#endif
    if (t1 <= UV_MAX) {
      a[0] = (UV)t1;  /* Fast path, also avoids rounding errors (right?) */
    } else {
      /* UVSIZE < NVSIZE or payload > UV_MAX.
       *
       * This may happen for example if:
       * (1) UVSIZE == 32 and common 64-bit double NV
       *     (32-bit system not using -Duse64bitint)
       * (2) UVSIZE == 64 and the x86-style 80-bit long double NV
       *     (note that here the room for payload is actually the 64 bits)
       * (3) UVSIZE == 64 and the 128-bit IEEE 764 quadruple NV
       *     (112 bits in mantissa, 111 bits room for payload)
       *
       * NOTE: this is very sensitive to correctly functioning
       * fmod()/fmodl(), and correct casting of big-unsigned-integer to NV.
       * If these don't work right, especially the low order bits
       * are in danger.  For example Solaris and AIX seem to have issues
       * here, especially if using 32-bit UVs. */
      NV t2;
      for (i = 0, t2 = t1; i < (int)C_ARRAY_LENGTH(a); i++) {
        a[i] = (UV)Perl_fmod(t2, (NV)UV_MAX);
        t2 = Perl_floor(t2 / (NV)UV_MAX);
      }
    }
  }
#endif
#ifdef NV_PAYLOAD_DEBUG
  for (i = 0; i < (int)C_ARRAY_LENGTH(a); i++) {
    Perl_warn(aTHX_ "a[%d] = 0x%" UVxf "\n", i, a[i]);
  }
#endif
  for (i = 0; i < (int)sizeof(p); i++) {
    if (m[i] && p[i] < sizeof(p)) {
      U8 s = (p[i] % UVSIZE) << 3;
      UV u = a[p[i] / UVSIZE] & ((UV)0xFF << s);
      U8 b = (U8)((u >> s) & m[i]);
      ((U8 *)(nvp))[i] &= ~m[i]; /* For NaNs with non-zero payload bits. */
      ((U8 *)(nvp))[i] |= b;
#ifdef NV_PAYLOAD_DEBUG
      Perl_warn(aTHX_
                "set p[%2d] = %02x (i = %d, m = %02x, s = %2d, b = %02x, u = %08"
                UVxf ")\n", i, ((U8 *)(nvp))[i], i, m[i], s, b, u);
#endif
      a[p[i] / UVSIZE] &= ~u;
    }
  }
  if (signaling) {
    NV_NAN_SET_SIGNALING(nvp);
  }
#ifdef USE_LONG_DOUBLE
# if LONG_DOUBLEKIND == 3 || LONG_DOUBLEKIND == 4
#  if LONG_DOUBLESIZE > 10
  memset((char *)nvp + 10, '\0', LONG_DOUBLESIZE - 10); /* x86 long double */
#  endif
# endif
#endif
  for (i = 0; i < (int)C_ARRAY_LENGTH(a); i++) {
    if (a[i]) {
      Perl_warn(aTHX_ "payload lost bits (%" UVxf ")", a[i]);
      break;
    }
  }
#ifdef NV_PAYLOAD_DEBUG
  for (i = 0; i < NVSIZE; i++) {
    PerlIO_printf(Perl_debug_log, "%02x ", ((U8 *)(nvp))[i]);
  }
  PerlIO_printf(Perl_debug_log, "\n");
#endif
}

static NV_PAYLOAD_TYPE S_getpayload(NV nv)
{
  dTHX;
  static const U8 m[] = { NV_NAN_PAYLOAD_MASK };
  static const U8 p[] = { NV_NAN_PAYLOAD_PERM };
  UV a[(NVSIZE + UVSIZE - 1) / UVSIZE] = { 0 };
  int i;
  NV payload;
  NV_PAYLOAD_SIZEOF_ASSERT(m);
  NV_PAYLOAD_SIZEOF_ASSERT(p);
  payload = 0;
  for (i = 0; i < (int)sizeof(p); i++) {
    if (m[i] && p[i] < NVSIZE) {
      U8 s = (p[i] % UVSIZE) << 3;
      a[p[i] / UVSIZE] |= (UV)(((U8 *)(&nv))[i] & m[i]) << s;
    }
  }
  for (i = (int)C_ARRAY_LENGTH(a) - 1; i >= 0; i--) {
#ifdef NV_PAYLOAD_DEBUG
    Perl_warn(aTHX_ "a[%d] = %" UVxf "\n", i, a[i]);
#endif
    payload *= (NV) UV_MAX;
    payload += a[i];
  }
#ifdef NV_PAYLOAD_DEBUG
  for (i = 0; i < NVSIZE; i++) {
    PerlIO_printf(Perl_debug_log, "%02x ", ((U8 *)(&nv))[i]);
  }
  PerlIO_printf(Perl_debug_log, "\n");
#endif
  return payload;
}

#endif  /* #ifdef NV_NAN */

/* XXX This comment is just to make I_TERMIO and I_SGTTY visible to
   metaconfig for future extension writers.  We don't use them in POSIX.
   (This is really sneaky :-)  --AD
*/
#if defined(I_TERMIOS)
#include <termios.h>
#endif
#include <stdlib.h>
#ifndef __ultrix__
#include <string.h>
#endif
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#ifdef I_UNISTD
#include <unistd.h>
#endif
#include <fcntl.h>

#ifdef HAS_TZNAME
#  if !defined(WIN32) && !defined(__CYGWIN__) && !defined(NETWARE) && !defined(__UWIN__)
extern char *tzname[];
#  endif
#else
#if !defined(WIN32) && !defined(__UWIN__) || (defined(__MINGW32__) && !defined(tzname))
char *tzname[] = { "" , "" };
#endif
#endif

#if defined(__VMS) && !defined(__POSIX_SOURCE)

#  include <utsname.h>

#  undef mkfifo
#  define mkfifo(a,b) (not_here("mkfifo"),-1)

   /* The POSIX notion of ttyname() is better served by getname() under VMS */
   static char ttnambuf[64];
#  define ttyname(fd) (isatty(fd) > 0 ? getname(fd,ttnambuf,0) : NULL)

#else
#if defined (__CYGWIN__)
#    define tzname _tzname
#endif
#if defined (WIN32) || defined (NETWARE)
#  undef mkfifo
#  define mkfifo(a,b) not_here("mkfifo")
#  define ttyname(a) (char*)not_here("ttyname")
#  define sigset_t long
#  define pid_t long
#  ifdef _MSC_VER
#    define mode_t short
#  endif
#  ifdef __MINGW32__
#    define mode_t short
#    ifndef tzset
#      define tzset()		not_here("tzset")
#    endif
#    ifndef _POSIX_OPEN_MAX
#      define _POSIX_OPEN_MAX	FOPEN_MAX	/* XXX bogus ? */
#    endif
#  endif
#  define sigaction(a,b,c)	not_here("sigaction")
#  define sigpending(a)		not_here("sigpending")
#  define sigprocmask(a,b,c)	not_here("sigprocmask")
#  define sigsuspend(a)		not_here("sigsuspend")
#  define sigemptyset(a)	not_here("sigemptyset")
#  define sigaddset(a,b)	not_here("sigaddset")
#  define sigdelset(a,b)	not_here("sigdelset")
#  define sigfillset(a)		not_here("sigfillset")
#  define sigismember(a,b)	not_here("sigismember")
#ifndef NETWARE
#  undef setuid
#  undef setgid
#  define setuid(a)		not_here("setuid")
#  define setgid(a)		not_here("setgid")
#endif	/* NETWARE */
#if !defined(USE_LONG_DOUBLE) && !defined(USE_QUADMATH)
#  define strtold(s1,s2)	not_here("strtold")
#endif  /* !(USE_LONG_DOUBLE) && !(USE_QUADMATH) */
#else

#  ifndef HAS_MKFIFO
#    if defined(OS2) || defined(__amigaos4__)
#      define mkfifo(a,b) not_here("mkfifo")
#    else	/* !( defined OS2 ) */
#      ifndef mkfifo
#        define mkfifo(path, mode) (mknod((path), (mode) | S_IFIFO, 0))
#      endif
#    endif
#  endif /* !HAS_MKFIFO */

#  ifdef I_GRP
#    include <grp.h>
#  endif
#  include <sys/times.h>
#  ifdef HAS_UNAME
#    include <sys/utsname.h>
#  endif
#  ifndef __amigaos4__
#    include <sys/wait.h>
#  endif
#  ifdef I_UTIME
#    include <utime.h>
#  endif
#endif /* WIN32 || NETWARE */
#endif /* __VMS */

typedef int SysRet;
typedef long SysRetLong;
typedef sigset_t* POSIX__SigSet;
typedef HV* POSIX__SigAction;
typedef int POSIX__SigNo;
typedef int POSIX__Fd;
#ifdef I_TERMIOS
typedef struct termios* POSIX__Termios;
#else /* Define termios types to int, and call not_here for the functions.*/
#define POSIX__Termios int
#define speed_t int
#define tcflag_t int
#define cc_t int
#define cfgetispeed(x) not_here("cfgetispeed")
#define cfgetospeed(x) not_here("cfgetospeed")
#define tcdrain(x) not_here("tcdrain")
#define tcflush(x,y) not_here("tcflush")
#define tcsendbreak(x,y) not_here("tcsendbreak")
#define cfsetispeed(x,y) not_here("cfsetispeed")
#define cfsetospeed(x,y) not_here("cfsetospeed")
#define ctermid(x) (char *) not_here("ctermid")
#define tcflow(x,y) not_here("tcflow")
#define tcgetattr(x,y) not_here("tcgetattr")
#define tcsetattr(x,y,z) not_here("tcsetattr")
#endif

/* Possibly needed prototypes */
#ifndef WIN32
START_EXTERN_C
double strtod (const char *, char **);
long strtol (const char *, char **, int);
unsigned long strtoul (const char *, char **, int);
#ifdef HAS_STRTOLD
long double strtold (const char *, char **);
#endif
END_EXTERN_C
#endif

#ifndef HAS_DIFFTIME
#ifndef difftime
#define difftime(a,b) not_here("difftime")
#endif
#endif
#ifndef HAS_FPATHCONF
#define fpathconf(f,n)	(SysRetLong) not_here("fpathconf")
#endif
#ifndef HAS_MKTIME
#define mktime(a) not_here("mktime")
#endif
#ifndef HAS_NICE
#define nice(a) not_here("nice")
#endif
#ifndef HAS_PATHCONF
#define pathconf(f,n)	(SysRetLong) not_here("pathconf")
#endif
#ifndef HAS_SYSCONF
#define sysconf(n)	(SysRetLong) not_here("sysconf")
#endif
#ifndef HAS_READLINK
#define readlink(a,b,c) not_here("readlink")
#endif
#ifndef HAS_SETPGID
#define setpgid(a,b) not_here("setpgid")
#endif
#ifndef HAS_SETSID
#define setsid() not_here("setsid")
#endif
#ifndef HAS_STRCOLL
#define strcoll(s1,s2) not_here("strcoll")
#endif
#ifndef HAS_STRTOD
#define strtod(s1,s2) not_here("strtod")
#endif
#ifndef HAS_STRTOLD
#define strtold(s1,s2) not_here("strtold")
#endif
#ifndef HAS_STRTOL
#define strtol(s1,s2,b) not_here("strtol")
#endif
#ifndef HAS_STRTOUL
#define strtoul(s1,s2,b) not_here("strtoul")
#endif
#ifndef HAS_STRXFRM
#define strxfrm(s1,s2,n) not_here("strxfrm")
#endif
#ifndef HAS_TCGETPGRP
#define tcgetpgrp(a) not_here("tcgetpgrp")
#endif
#ifndef HAS_TCSETPGRP
#define tcsetpgrp(a,b) not_here("tcsetpgrp")
#endif
#ifndef HAS_TIMES
#ifndef NETWARE
#define times(a) not_here("times")
#endif	/* NETWARE */
#endif
#ifndef HAS_UNAME
#define uname(a) not_here("uname")
#endif
#ifndef HAS_WAITPID
#define waitpid(a,b,c) not_here("waitpid")
#endif

#if ! defined(HAS_MBLEN) && ! defined(HAS_MBRLEN)
#  define mblen(a,b) not_here("mblen")
#endif
#if ! defined(HAS_MBTOWC) && ! defined(HAS_MBRTOWC)
#  define mbtowc(pwc, s, n) not_here("mbtowc")
#endif
#if ! defined(HAS_WCTOMB) && ! defined(HAS_WCRTOMB)
#  define wctomb(s, wchar) not_here("wctomb")
#endif
#if !defined(HAS_MBLEN) && !defined(HAS_MBSTOWCS) && !defined(HAS_MBTOWC) && !defined(HAS_WCSTOMBS) && !defined(HAS_WCTOMB)
/* If we don't have these functions, then we wouldn't have gotten a typedef
   for wchar_t, the wide character type.  Defining wchar_t allows the
   functions referencing it to compile.  Its actual type is then meaningless,
   since without the above functions, all sections using it end up calling
   not_here() and croak.  --Kaveh Ghazi (ghazi@noc.rutgers.edu) 9/18/94. */
#ifndef wchar_t
#define wchar_t char
#endif
#endif

#if ! defined(HAS_LOCALECONV) && ! defined(HAS_LOCALECONV_L)
#   define localeconv() not_here("localeconv")
#else
struct lconv_offset {
    const char *name;
    size_t offset;
};

static const struct lconv_offset lconv_strings[] = {
#ifdef USE_LOCALE_NUMERIC
    {"decimal_point",     STRUCT_OFFSET(struct lconv, decimal_point)},
    {"thousands_sep",     STRUCT_OFFSET(struct lconv, thousands_sep)},
#  ifndef NO_LOCALECONV_GROUPING
    {"grouping",          STRUCT_OFFSET(struct lconv, grouping)},
#  endif
#endif
#ifdef USE_LOCALE_MONETARY
    {"int_curr_symbol",   STRUCT_OFFSET(struct lconv, int_curr_symbol)},
    {"currency_symbol",   STRUCT_OFFSET(struct lconv, currency_symbol)},
    {"mon_decimal_point", STRUCT_OFFSET(struct lconv, mon_decimal_point)},
#  ifndef NO_LOCALECONV_MON_THOUSANDS_SEP
    {"mon_thousands_sep", STRUCT_OFFSET(struct lconv, mon_thousands_sep)},
#  endif
#  ifndef NO_LOCALECONV_MON_GROUPING
    {"mon_grouping",      STRUCT_OFFSET(struct lconv, mon_grouping)},
#  endif
    {"positive_sign",     STRUCT_OFFSET(struct lconv, positive_sign)},
    {"negative_sign",     STRUCT_OFFSET(struct lconv, negative_sign)},
#endif
    {NULL, 0}
};

#ifdef USE_LOCALE_NUMERIC

/* The Linux man pages say these are the field names for the structure
 * components that are LC_NUMERIC; the rest being LC_MONETARY */
#   define isLC_NUMERIC_STRING(name) (   strEQ(name, "decimal_point")   \
                                      || strEQ(name, "thousands_sep")   \
                                                                        \
                                      /* There should be no harm done   \
                                       * checking for this, even if     \
                                       * NO_LOCALECONV_GROUPING */      \
                                      || strEQ(name, "grouping"))
#else
#   define isLC_NUMERIC_STRING(name) (0)
#endif

static const struct lconv_offset lconv_integers[] = {
#ifdef USE_LOCALE_MONETARY
    {"int_frac_digits",   STRUCT_OFFSET(struct lconv, int_frac_digits)},
    {"frac_digits",       STRUCT_OFFSET(struct lconv, frac_digits)},
    {"p_cs_precedes",     STRUCT_OFFSET(struct lconv, p_cs_precedes)},
    {"p_sep_by_space",    STRUCT_OFFSET(struct lconv, p_sep_by_space)},
    {"n_cs_precedes",     STRUCT_OFFSET(struct lconv, n_cs_precedes)},
    {"n_sep_by_space",    STRUCT_OFFSET(struct lconv, n_sep_by_space)},
    {"p_sign_posn",       STRUCT_OFFSET(struct lconv, p_sign_posn)},
    {"n_sign_posn",       STRUCT_OFFSET(struct lconv, n_sign_posn)},
#ifdef HAS_LC_MONETARY_2008
    {"int_p_cs_precedes",  STRUCT_OFFSET(struct lconv, int_p_cs_precedes)},
    {"int_p_sep_by_space", STRUCT_OFFSET(struct lconv, int_p_sep_by_space)},
    {"int_n_cs_precedes",  STRUCT_OFFSET(struct lconv, int_n_cs_precedes)},
    {"int_n_sep_by_space", STRUCT_OFFSET(struct lconv, int_n_sep_by_space)},
    {"int_p_sign_posn",    STRUCT_OFFSET(struct lconv, int_p_sign_posn)},
    {"int_n_sign_posn",    STRUCT_OFFSET(struct lconv, int_n_sign_posn)},
#endif
#endif
    {NULL, 0}
};

#endif /* HAS_LOCALECONV */

#ifdef HAS_LONG_DOUBLE
#  if LONG_DOUBLESIZE > NVSIZE
#    undef HAS_LONG_DOUBLE  /* XXX until we figure out how to use them */
#  endif
#endif

#ifndef HAS_LONG_DOUBLE
#ifdef LDBL_MAX
#undef LDBL_MAX
#endif
#ifdef LDBL_MIN
#undef LDBL_MIN
#endif
#ifdef LDBL_EPSILON
#undef LDBL_EPSILON
#endif
#endif

/* Background: in most systems the low byte of the wait status
 * is the signal (the lowest 7 bits) and the coredump flag is
 * the eight bit, and the second lowest byte is the exit status.
 * BeOS bucks the trend and has the bytes in different order.
 * See beos/beos.c for how the reality is bent even in BeOS
 * to follow the traditional.  However, to make the POSIX
 * wait W*() macros to work in BeOS, we need to unbend the
 * reality back in place. --jhi */
/* In actual fact the code below is to blame here. Perl has an internal
 * representation of the exit status ($?), which it re-composes from the
 * OS's representation using the W*() POSIX macros. The code below
 * incorrectly uses the W*() macros on the internal representation,
 * which fails for OSs that have a different representation (namely BeOS
 * and Haiku). WMUNGE() is a hack that converts the internal
 * representation into the OS specific one, so that the W*() macros work
 * as expected. The better solution would be not to use the W*() macros
 * in the first place, though. -- Ingo Weinhold
 */
#if defined(__HAIKU__)
#    define WMUNGE(x) (((x) & 0xFF00) >> 8 | ((x) & 0x00FF) << 8)
#else
#    define WMUNGE(x) (x)
#endif

static int
not_here(const char *s)
{
    croak("POSIX::%s not implemented on this architecture", s);
    return -1;
}

#include "const-c.inc"

static void
restore_sigmask(pTHX_ SV *osset_sv)
{
     /* Fortunately, restoring the signal mask can't fail, because
      * there's nothing we can do about it if it does -- we're not
      * supposed to return -1 from sigaction unless the disposition
      * was unaffected.
      */
#if !(defined(__amigaos4__) && defined(__NEWLIB__))
     sigset_t *ossetp = (sigset_t *) SvPV_nolen( osset_sv );
     (void)sigprocmask(SIG_SETMASK, ossetp, (sigset_t *)0);
#endif
}

static void *
allocate_struct(pTHX_ SV *rv, const STRLEN size, const char *packname) {
    SV *const t = newSVrv(rv, packname);
    void *const p = sv_grow(t, size + 1);

    /* Ensure at least one use of not_here() to avoid "defined but not
     * used" warning.  This is not at all related to allocate_struct(); I
     * just needed somewhere to dump it - DAPM */
    if (0) { not_here(""); }

    SvCUR_set(t, size);
    SvPOK_on(t);
    return p;
}

#ifdef WIN32

/*
 * (1) The CRT maintains its own copy of the environment, separate from
 * the Win32API copy.
 *
 * (2) CRT getenv() retrieves from this copy. CRT putenv() updates this
 * copy, and then calls SetEnvironmentVariableA() to update the Win32API
 * copy.
 *
 * (3) win32_getenv() and win32_putenv() call GetEnvironmentVariableA() and
 * SetEnvironmentVariableA() directly, bypassing the CRT copy of the
 * environment.
 *
 * (4) The CRT strftime() "%Z" implementation calls __tzset(). That
 * calls CRT tzset(), but only the first time it is called, and in turn
 * that uses CRT getenv("TZ") to retrieve the timezone info from the CRT
 * local copy of the environment and hence gets the original setting as
 * perl never updates the CRT copy when assigning to $ENV{TZ}.
 *
 * Therefore, we need to retrieve the value of $ENV{TZ} and call CRT
 * putenv() to update the CRT copy of the environment (if it is different)
 * whenever we're about to call tzset().
 *
 * In addition to all that, when perl is built with PERL_IMPLICIT_SYS
 * defined:
 *
 * (a) Each interpreter has its own copy of the environment inside the
 * perlhost structure. That allows applications that host multiple
 * independent Perl interpreters to isolate environment changes from
 * each other. (This is similar to how the perlhost mechanism keeps a
 * separate working directory for each Perl interpreter, so that calling
 * chdir() will not affect other interpreters.)
 *
 * (b) Only the first Perl interpreter instantiated within a process will
 * "write through" environment changes to the process environment.
 *
 * (c) Even the primary Perl interpreter won't update the CRT copy of the
 * environment, only the Win32API copy (it calls win32_putenv()).
 *
 * As with CPerlHost::Getenv() and CPerlHost::Putenv() themselves, it makes
 * sense to only update the process environment when inside the main
 * interpreter, but we don't have access to CPerlHost's m_bTopLevel member
 * from here so we'll just have to check PL_curinterp instead.
 *
 * Therefore, we can simply #undef getenv() and putenv() so that those names
 * always refer to the CRT functions, and explicitly call win32_getenv() to
 * access perl's %ENV.
 *
 * We also #undef malloc() and free() to be sure we are using the CRT
 * functions otherwise under PERL_IMPLICIT_SYS they are redefined to calls
 * into VMem::Malloc() and VMem::Free() and all allocations will be freed
 * when the Perl interpreter is being destroyed so we'd end up with a pointer
 * into deallocated memory in environ[] if a program embedding a Perl
 * interpreter continues to operate even after the main Perl interpreter has
 * been destroyed.
 *
 * Note that we don't free() the malloc()ed memory unless and until we call
 * malloc() again ourselves because the CRT putenv() function simply puts its
 * pointer argument into the environ[] array (it doesn't make a copy of it)
 * so this memory must otherwise be leaked.
 */

#undef getenv
#undef putenv
#undef malloc
#undef free

static void
fix_win32_tzenv(void)
{
    static char* oldenv = NULL;
    char* newenv;
    const char* perl_tz_env = win32_getenv("TZ");
    const char* crt_tz_env = getenv("TZ");

    if (perl_tz_env == NULL)
        perl_tz_env = "";
    if (crt_tz_env == NULL)
        crt_tz_env = "";
    if (strNE(perl_tz_env, crt_tz_env)) {
        newenv = (char*)malloc((strlen(perl_tz_env) + 4) * sizeof(char));
        if (newenv != NULL) {
            sprintf(newenv, "TZ=%s", perl_tz_env);
            putenv(newenv);
            if (oldenv != NULL)
                free(oldenv);
            oldenv = newenv;
        }
    }
}

#endif

/*
 * my_tzset - wrapper to tzset() with a fix to make it work (better) on Win32.
 * This code is duplicated in the Time-Piece module, so any changes made here
 * should be made there too.
 */
static void
my_tzset(pTHX)
{
#ifdef WIN32
#if defined(USE_ITHREADS) && defined(PERL_IMPLICIT_SYS)
    if (PL_curinterp == aTHX)
#endif
        fix_win32_tzenv();
#endif
    tzset();
}

#line 1845 "POSIX.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 1989 "POSIX.c"

XS_EUPXS(XS_POSIX__SigSet_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__SigSet_new)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	const char *	packname;

	if (items < 1)
	    packname = "POSIX::SigSet";
	else {
	    packname = (const char *)SvPV_nolen(ST(0))
;
	}
#line 1841 "POSIX.xs"
	{
	    int i;
	    sigset_t *const s
		= (sigset_t *) allocate_struct(aTHX_ (ST(0) = sv_newmortal()),
					       sizeof(sigset_t),
					       packname);
	    sigemptyset(s);
	    for (i = 1; i < items; i++) {
                IV sig = SvIV(ST(i));
		if (sigaddset(s, sig) < 0)
                    croak("POSIX::Sigset->new: failed to add signal %" IVdf, sig);
            }
	    XSRETURN(1);
	}
#line 2021 "POSIX.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX__SigSet_addset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__SigSet_addset)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "sigset, sig");
    {
	POSIX__SigSet	sigset;
	POSIX__SigNo	sig;
	SysRet	RETVAL;

	{
	    SV * sv = ST(0);
	    if (SvROK(sv) && sv_derived_from(sv, "POSIX::SigSet"))
		sigset = (POSIX__SigSet)SvPV_nolen(SvRV(sv));
	    else
		croak("%s: %s is not of type %s",
			    GvNAME(CvGV(cv)),
			"sigset", "POSIX::SigSet");
	}
;

	if ((sig = SvIV(ST(1))) < 0) {
	   croak("%s: Negative signals are not allowed %d",
		GvNAME(CvGV(cv)),
                                   sig);
	}
;
#line 1863 "POSIX.xs"
	RETVAL = ix ? sigdelset(sigset, sig) : sigaddset(sigset, sig);
#line 2058 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX__SigSet_emptyset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__SigSet_emptyset)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "sigset");
    {
	POSIX__SigSet	sigset;
	SysRet	RETVAL;

	{
	    SV * sv = ST(0);
	    if (SvROK(sv) && sv_derived_from(sv, "POSIX::SigSet"))
		sigset = (POSIX__SigSet)SvPV_nolen(SvRV(sv));
	    else
		croak("%s: %s is not of type %s",
			    GvNAME(CvGV(cv)),
			"sigset", "POSIX::SigSet");
	}
;
#line 1873 "POSIX.xs"
	RETVAL = ix ? sigfillset(sigset) : sigemptyset(sigset);
#line 2098 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX__SigSet_ismember); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__SigSet_ismember)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sigset, sig");
    {
	POSIX__SigSet	sigset;
	POSIX__SigNo	sig;
	int	RETVAL;
	dXSTARG;

	{
	    SV * sv = ST(0);
	    if (SvROK(sv) && sv_derived_from(sv, "POSIX::SigSet"))
		sigset = (POSIX__SigSet)SvPV_nolen(SvRV(sv));
	    else
		croak("%s: %s is not of type %s",
			    "POSIX::SigSet::ismember",
			"sigset", "POSIX::SigSet");
	}
;

	if ((sig = SvIV(ST(1))) < 0) {
	   croak("%s: Negative signals are not allowed %d",
		"POSIX::SigSet::ismember",
                                   sig);
	}
;

	RETVAL = sigismember(sigset, sig);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX__Termios_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__Termios_new)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	const char *	packname;

	if (items < 1)
	    packname = "POSIX::Termios";
	else {
	    packname = (const char *)SvPV_nolen(ST(0))
;
	}
#line 1888 "POSIX.xs"
	{
#ifdef I_TERMIOS
	    void *const p = allocate_struct(aTHX_ (ST(0) = sv_newmortal()),
					    sizeof(struct termios), packname);
	    /* The previous implementation stored a pointer to an uninitialised
	       struct termios. Seems safer to initialise it, particularly as
	       this implementation exposes the struct to prying from perl-space.
	    */
	    memset(p, 0, 1 + sizeof(struct termios));
	    XSRETURN(1);
#else
	    not_here("termios");
#endif
	}
#line 2182 "POSIX.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX__Termios_getattr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__Termios_getattr)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "termios_ref, fd = 0");
    {
	POSIX__Termios	termios_ref;
	POSIX__Fd	fd;
	SysRet	RETVAL;

	{
	    SV * sv = ST(0);
	    if (SvROK(sv) && sv_derived_from(sv, "POSIX::Termios"))
		termios_ref = (POSIX__Termios)SvPV_nolen(SvRV(sv));
	    else
		croak("%s: %s is not of type %s",
			    "POSIX::Termios::getattr",
			"termios_ref", "POSIX::Termios");
	}
;

	if (items < 2)
	    fd = 0;
	else {
	    if ((fd = (int)SvIV(ST(1))) < 0) {
		 SETERRNO(EBADF, RMS_IFI);
		 XSRETURN_IV(-1);
	    }
;
	}
#line 1908 "POSIX.xs"
	RETVAL = tcgetattr(fd, termios_ref);
#line 2221 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#ifndef TCSANOW
#  define DEF_SETATTR_ACTION 0
#else
#  define DEF_SETATTR_ACTION TCSANOW
#endif

XS_EUPXS(XS_POSIX__Termios_setattr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__Termios_setattr)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "termios_ref, fd = 0, optional_actions = DEF_SETATTR_ACTION");
    {
	POSIX__Termios	termios_ref;
	POSIX__Fd	fd;
	int	optional_actions;
	SysRet	RETVAL;

	{
	    SV * sv = ST(0);
	    if (SvROK(sv) && sv_derived_from(sv, "POSIX::Termios"))
		termios_ref = (POSIX__Termios)SvPV_nolen(SvRV(sv));
	    else
		croak("%s: %s is not of type %s",
			    "POSIX::Termios::setattr",
			"termios_ref", "POSIX::Termios");
	}
;

	if (items < 2)
	    fd = 0;
	else {
	    if ((fd = (int)SvIV(ST(1))) < 0) {
		 SETERRNO(EBADF, RMS_IFI);
		 XSRETURN_IV(-1);
	    }
;
	}

	if (items < 3)
	    optional_actions = DEF_SETATTR_ACTION;
	else {
	    optional_actions = (int)SvIV(ST(2))
;
	}
#line 1926 "POSIX.xs"
	/* The second argument to the call is mandatory, but we'd like to give
	   it a useful default. 0 isn't valid on all operating systems - on
           Solaris (at least) TCSANOW, TCSADRAIN and TCSAFLUSH have the same
           values as the equivalent ioctls, TCSETS, TCSETSW and TCSETSF.  */
	if (optional_actions < 0) {
            SETERRNO(EINVAL, LIB_INVARG);
            RETVAL = -1;
        } else {
            RETVAL = tcsetattr(fd, optional_actions, termios_ref);
        }
#line 2293 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX__Termios_getispeed); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__Termios_getispeed)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "termios_ref");
    {
	POSIX__Termios	termios_ref;
	speed_t	RETVAL;
	dXSTARG;

	{
	    SV * sv = ST(0);
	    if (SvROK(sv) && sv_derived_from(sv, "POSIX::Termios"))
		termios_ref = (POSIX__Termios)SvPV_nolen(SvRV(sv));
	    else
		croak("%s: %s is not of type %s",
			    GvNAME(CvGV(cv)),
			"termios_ref", "POSIX::Termios");
	}
;
#line 1945 "POSIX.xs"
	RETVAL = ix ? cfgetospeed(termios_ref) : cfgetispeed(termios_ref);
#line 2334 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX__Termios_getiflag); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__Termios_getiflag)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "termios_ref");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	RETVAL;
	dXSTARG;

	{
	    SV * sv = ST(0);
	    if (SvROK(sv) && sv_derived_from(sv, "POSIX::Termios"))
		termios_ref = (POSIX__Termios)SvPV_nolen(SvRV(sv));
	    else
		croak("%s: %s is not of type %s",
			    GvNAME(CvGV(cv)),
			"termios_ref", "POSIX::Termios");
	}
;
#line 1957 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	switch(ix) {
	case 0:
	    RETVAL = termios_ref->c_iflag;
	    break;
	case 1:
	    RETVAL = termios_ref->c_oflag;
	    break;
	case 2:
	    RETVAL = termios_ref->c_cflag;
	    break;
	case 3:
	    RETVAL = termios_ref->c_lflag;
	    break;
        default:
	    RETVAL = 0; /* silence compiler warning */
	}
#else
	not_here(GvNAME(CvGV(cv)));
	RETVAL = 0;
#endif
#line 2385 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX__Termios_getcc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__Termios_getcc)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "termios_ref, ccix");
    {
	POSIX__Termios	termios_ref;
	unsigned int	ccix = (unsigned int)SvUV(ST(1))
;
	cc_t	RETVAL;
	dXSTARG;

	{
	    SV * sv = ST(0);
	    if (SvROK(sv) && sv_derived_from(sv, "POSIX::Termios"))
		termios_ref = (POSIX__Termios)SvPV_nolen(SvRV(sv));
	    else
		croak("%s: %s is not of type %s",
			    "POSIX::Termios::getcc",
			"termios_ref", "POSIX::Termios");
	}
;
#line 1986 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	if (ccix >= NCCS)
	    croak("Bad getcc subscript");
	RETVAL = termios_ref->c_cc[ccix];
#else
     not_here("getcc");
     RETVAL = 0;
#endif
#line 2424 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX__Termios_setispeed); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__Termios_setispeed)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "termios_ref, speed");
    {
	POSIX__Termios	termios_ref;
	speed_t	speed = (speed_t)SvIV(ST(1))
;
	SysRet	RETVAL;

	{
	    SV * sv = ST(0);
	    if (SvROK(sv) && sv_derived_from(sv, "POSIX::Termios"))
		termios_ref = (POSIX__Termios)SvPV_nolen(SvRV(sv));
	    else
		croak("%s: %s is not of type %s",
			    GvNAME(CvGV(cv)),
			"termios_ref", "POSIX::Termios");
	}
;
#line 2004 "POSIX.xs"
	RETVAL = ix
	    ? cfsetospeed(termios_ref, speed) : cfsetispeed(termios_ref, speed);
#line 2457 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX__Termios_setiflag); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__Termios_setiflag)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "termios_ref, flag");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	flag = (tcflag_t)SvIV(ST(1))
;

	{
	    SV * sv = ST(0);
	    if (SvROK(sv) && sv_derived_from(sv, "POSIX::Termios"))
		termios_ref = (POSIX__Termios)SvPV_nolen(SvRV(sv));
	    else
		croak("%s: %s is not of type %s",
			    GvNAME(CvGV(cv)),
			"termios_ref", "POSIX::Termios");
	}
;
#line 2018 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	switch(ix) {
	case 0:
	    termios_ref->c_iflag = flag;
	    break;
	case 1:
	    termios_ref->c_oflag = flag;
	    break;
	case 2:
	    termios_ref->c_cflag = flag;
	    break;
	case 3:
	    termios_ref->c_lflag = flag;
	    break;
	}
#else
	not_here(GvNAME(CvGV(cv)));
#endif
#line 2515 "POSIX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_POSIX__Termios_setcc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__Termios_setcc)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "termios_ref, ccix, cc");
    {
	POSIX__Termios	termios_ref;
	unsigned int	ccix = (unsigned int)SvUV(ST(1))
;
	cc_t	cc = (cc_t)SvIV(ST(2))
;

	{
	    SV * sv = ST(0);
	    if (SvROK(sv) && sv_derived_from(sv, "POSIX::Termios"))
		termios_ref = (POSIX__Termios)SvPV_nolen(SvRV(sv));
	    else
		croak("%s: %s is not of type %s",
			    "POSIX::Termios::setcc",
			"termios_ref", "POSIX::Termios");
	}
;
#line 2043 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	if (ccix >= NCCS)
	    croak("Bad setcc subscript");
	termios_ref->c_cc[ccix] = cc;
#else
	    not_here("setcc");
#endif
#line 2552 "POSIX.c"
    }
    XSRETURN_EMPTY;
}


/* INCLUDE:  Including 'const-xs.inc' from 'POSIX.xs' */


XS_EUPXS(XS_POSIX_constant); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_constant)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
#line 1572 "./const-xs.inc"
	const PERL_CONTEXT *cx = caller_cx(0, NULL);
	/* cx is NULL if we've been called from the top level. PL_curcop isn't
	   ideal, but it's much cheaper than other ways of not going SEGV.  */
	const COP *cop = cx ? cx->blk_oldcop : PL_curcop;
#line 2577 "POSIX.c"
#line 1577 "./const-xs.inc"
#ifndef SYMBIAN
	/* It's not obvious how to calculate this at C pre-processor time.
	   However, any compiler optimiser worth its salt should be able to
	   remove the dead code, and hopefully the now-obviously-unused static
	   function too.  */
	HV *constant_missing = (C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? get_missing_hash(aTHX) : NULL;
	if ((C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? hv_exists_ent(constant_missing, sv, 0) : 0) {
	    sv = newSVpvf("Your vendor has not defined POSIX macro %" SVf
			  ", used at %" COP_FILE_F " line %" UVuf "\n", 
			  sv, COP_FILE(cop), (UV)CopLINE(cop));
	} else
#endif
	{
	    sv = newSVpvf("%" SVf
                          " is not a valid POSIX macro at %"
			  COP_FILE_F " line %" UVuf "\n",
			  sv, COP_FILE(cop), (UV)CopLINE(cop));
	}
	croak_sv(sv_2mortal(sv));
#line 2600 "POSIX.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'POSIX.xs' from 'const-xs.inc' */


XS_EUPXS(XS_POSIX_WEXITSTATUS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_WEXITSTATUS)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "status");
    {
	int	status = (int)SvIV(ST(0))
;
	int	RETVAL;
	dXSTARG;
#line 2066 "POSIX.xs"
#if !defined(WEXITSTATUS) || !defined(WIFEXITED) || !defined(WIFSIGNALED) \
      || !defined(WIFSTOPPED) || !defined(WSTOPSIG) || !defined(WTERMSIG)
        RETVAL = 0; /* Silence compilers that notice this, but don't realise
		       that not_here() can't return.  */
#endif
	switch(ix) {
	case 0:
#ifdef WEXITSTATUS
	    RETVAL = WEXITSTATUS(WMUNGE(status));
#else
	    not_here("WEXITSTATUS");
#endif
	    break;
	case 1:
#ifdef WIFEXITED
	    RETVAL = WIFEXITED(WMUNGE(status));
#else
	    not_here("WIFEXITED");
#endif
	    break;
	case 2:
#ifdef WIFSIGNALED
	    RETVAL = WIFSIGNALED(WMUNGE(status));
#else
	    not_here("WIFSIGNALED");
#endif
	    break;
	case 3:
#ifdef WIFSTOPPED
	    RETVAL = WIFSTOPPED(WMUNGE(status));
#else
	    not_here("WIFSTOPPED");
#endif
	    break;
	case 4:
#ifdef WSTOPSIG
	    RETVAL = WSTOPSIG(WMUNGE(status));
#else
	    not_here("WSTOPSIG");
#endif
	    break;
	case 5:
#ifdef WTERMSIG
	    RETVAL = WTERMSIG(WMUNGE(status));
#else
	    not_here("WTERMSIG");
#endif
	    break;
	default:
	    croak("Illegal alias %d for POSIX::W*", (int)ix);
	}
#line 2674 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_open); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_open)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "filename, flags = O_RDONLY, mode = 0666");
    {
	char *	filename = (char *)SvPV_nolen(ST(0))
;
	int	flags;
	Mode_t	mode;
	SysRet	RETVAL;

	if (items < 2)
	    flags = O_RDONLY;
	else {
	    flags = (int)SvIV(ST(1))
;
	}

	if (items < 3)
	    mode = 0666;
	else {
	    mode = (Mode_t)SvNV(ST(2))
;
	}
#line 2126 "POSIX.xs"
	if (flags & (O_APPEND|O_CREAT|O_TRUNC|O_RDWR|O_WRONLY|O_EXCL))
	    TAINT_PROPER("open");
	RETVAL = open(filename, flags, mode);
#line 2711 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_localeconv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_localeconv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HV *	RETVAL;
#line 2136 "POSIX.xs"
#ifndef HAS_LOCALECONV
	localeconv(); /* A stub to call not_here(). */
#else
	struct lconv *lcbuf;
#  if defined(USE_ITHREADS)                                             \
   && defined(HAS_POSIX_2008_LOCALE)                                    \
   && defined(HAS_LOCALECONV_L) /* Prefer this thread-safe version */
        bool do_free = FALSE;
        locale_t cur = NULL;
#  elif defined(TS_W32_BROKEN_LOCALECONV)
        const char * save_global;
        const char * save_thread;
#  endif
        DECLARATION_FOR_LC_NUMERIC_MANIPULATION;

        /* localeconv() deals with both LC_NUMERIC and LC_MONETARY, but
         * LC_MONETARY is already in the correct locale */
#  ifdef USE_LOCALE_MONETARY

        const bool is_monetary_utf8 = _is_cur_LC_category_utf8(LC_MONETARY);
#  endif
#  ifdef USE_LOCALE_NUMERIC

        bool is_numeric_utf8;

        STORE_LC_NUMERIC_FORCE_TO_UNDERLYING();

        is_numeric_utf8 = _is_cur_LC_category_utf8(LC_NUMERIC);
#  endif

	RETVAL = newHV();
	sv_2mortal((SV*)RETVAL);
#  if defined(USE_ITHREADS)                         \
   && defined(HAS_POSIX_2008_LOCALE)                \
   && defined(HAS_LOCALECONV_L)

        cur = uselocale((locale_t) 0);
        if (cur == LC_GLOBAL_LOCALE) {
            cur = duplocale(LC_GLOBAL_LOCALE);
            do_free = TRUE;
        }

        lcbuf = localeconv_l(cur);
#  else
        LOCALECONV_LOCK;    /* Prevent interference with other threads using
                               localeconv() */
#    ifdef TS_W32_BROKEN_LOCALECONV
        /* This is a workaround for a Windows bug prior to VS 15, in which
         * localeconv only looks at the global locale.  We toggle to the global
         * locale; populate the return; then toggle back.  We have to use
         * LC_ALL instead of the individual ones because of another bug in
         * Windows */

        save_thread  = savepv(Perl_setlocale(LC_NUMERIC, NULL));

        _configthreadlocale(_DISABLE_PER_THREAD_LOCALE);

        save_global  = savepv(Perl_setlocale(LC_ALL, NULL));

        Perl_setlocale(LC_ALL,  save_thread);
#    endif
        lcbuf = localeconv();
#  endif
	if (lcbuf) {
	    const struct lconv_offset *strings = lconv_strings;
	    const struct lconv_offset *integers = lconv_integers;
	    const char *ptr = (const char *) lcbuf;

	    while (strings->name) {
                /* This string may be controlled by either LC_NUMERIC, or
                 * LC_MONETARY */
                const bool is_utf8_locale =
#  if defined(USE_LOCALE_NUMERIC) && defined(USE_LOCALE_MONETARY)
                                        (isLC_NUMERIC_STRING(strings->name))
                                        ? is_numeric_utf8
                                        : is_monetary_utf8;
#  elif defined(USE_LOCALE_NUMERIC)
                                        is_numeric_utf8;
#  elif defined(USE_LOCALE_MONETARY)
                                        is_monetary_utf8;
#  else
                                        FALSE;
#  endif

		const char *value = *((const char **)(ptr + strings->offset));

		if (value && *value) {
                    const STRLEN value_len = strlen(value);

                    /* We mark it as UTF-8 if a utf8 locale and is valid and
                     * variant under UTF-8 */
                    const bool is_utf8 = is_utf8_locale
                                     &&  is_utf8_non_invariant_string(
                                                                (U8*) value,
                                                                value_len);
		    (void) hv_store(RETVAL,
                                    strings->name,
                                    strlen(strings->name),
                                    newSVpvn_utf8(value, value_len, is_utf8),
                                    0);
            }
                strings++;
	    }

	    while (integers->name) {
		const char value = *((const char *)(ptr + integers->offset));

		if (value != CHAR_MAX)
		    (void) hv_store(RETVAL, integers->name,
				    strlen(integers->name), newSViv(value), 0);
                integers++;
            }
	}
#  if defined(USE_ITHREADS)                         \
   && defined(HAS_POSIX_2008_LOCALE)                \
   && defined(HAS_LOCALECONV_L)
        if (do_free) {
            freelocale(cur);
        }
#  else
#    ifdef TS_W32_BROKEN_LOCALECONV
        Perl_setlocale(LC_ALL, save_global);

        _configthreadlocale(_ENABLE_PER_THREAD_LOCALE);

        Perl_setlocale(LC_ALL, save_thread);

        Safefree(save_global);
        Safefree(save_thread);
#    endif
        LOCALECONV_UNLOCK;
#  endif
        RESTORE_LC_NUMERIC();
#endif  /* HAS_LOCALECONV */
#line 2871 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_setlocale); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_setlocale)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "category, locale = 0");
    {
	int	category = (int)SvIV(ST(0))
;
	const char *	locale;
#line 2278 "POSIX.xs"
	char *		retval;
#line 2895 "POSIX.c"
	char *	RETVAL;
	dXSTARG;

	if (items < 2)
	    locale = 0;
	else {
	    locale = (const char *)SvPV_nolen(ST(1))
;
	}
#line 2280 "POSIX.xs"
	retval = (char *) Perl_setlocale(category, locale);
        if (! retval) {
            XSRETURN_UNDEF;
        }

        RETVAL = retval;
#line 2912 "POSIX.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_acos); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_acos)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	NV	x = (NV)SvNV(ST(0))
;
	NV	RETVAL;
	dXSTARG;
#line 2324 "POSIX.xs"
	PERL_UNUSED_VAR(x);
#ifdef NV_NAN
	RETVAL = NV_NAN;
#else
	RETVAL = 0;
#endif
	switch (ix) {
	case 0:
	    RETVAL = Perl_acos(x); /* C89 math */
	    break;
	case 1:
#ifdef c99_acosh
	    RETVAL = c99_acosh(x);
#else
	    not_here("acosh");
#endif
	    break;
	case 2:
	    RETVAL = Perl_asin(x); /* C89 math */
	    break;
	case 3:
#ifdef c99_asinh
	    RETVAL = c99_asinh(x);
#else
	    not_here("asinh");
#endif
	    break;
	case 4:
	    RETVAL = Perl_atan(x); /* C89 math */
	    break;
	case 5:
#ifdef c99_atanh
	    RETVAL = c99_atanh(x);
#else
	    not_here("atanh");
#endif
	    break;
	case 6:
#ifdef c99_cbrt
	    RETVAL = c99_cbrt(x);
#else
	    not_here("cbrt");
#endif
	    break;
	case 7:
	    RETVAL = Perl_ceil(x); /* C89 math */
	    break;
	case 8:
	    RETVAL = Perl_cosh(x); /* C89 math */
	    break;
	case 9:
#ifdef c99_erf
	    RETVAL = c99_erf(x);
#else
	    not_here("erf");
#endif
	    break;
	case 10:
#ifdef c99_erfc
	    RETVAL = c99_erfc(x);
#else
	    not_here("erfc");
#endif
	    break;
	case 11:
#ifdef c99_exp2
	    RETVAL = c99_exp2(x);
#else
	    not_here("exp2");
#endif
	    break;
	case 12:
#ifdef c99_expm1
	    RETVAL = c99_expm1(x);
#else
	    not_here("expm1");
#endif
	    break;
	case 13:
	    RETVAL = Perl_floor(x); /* C89 math */
	    break;
	case 14:
#ifdef bessel_j0
	    RETVAL = bessel_j0(x);
#else
	    not_here("j0");
#endif
	    break;
	case 15:
#ifdef bessel_j1
	    RETVAL = bessel_j1(x);
#else
	    not_here("j1");
#endif
	    break;
	case 16:
        /* XXX Note: the lgamma modifies a global variable (signgam),
         * which is evil.  Some platforms have lgamma_r, which has
         * extra output parameter instead of the global variable. */
#ifdef c99_lgamma
	    RETVAL = c99_lgamma(x);
#else
	    not_here("lgamma");
#endif
	    break;
	case 17:
	    RETVAL = Perl_log10(x); /* C89 math */
	    break;
	case 18:
#ifdef c99_log1p
	    RETVAL = c99_log1p(x);
#else
	    not_here("log1p");
#endif
	    break;
	case 19:
#ifdef c99_log2
	    RETVAL = c99_log2(x);
#else
	    not_here("log2");
#endif
	    break;
	case 20:
#ifdef c99_logb
	    RETVAL = c99_logb(x);
#elif defined(c99_log2) && FLT_RADIX == 2
	    RETVAL = Perl_floor(c99_log2(PERL_ABS(x)));
#else
	    not_here("logb");
#endif
	    break;
	case 21:
#ifdef c99_nearbyint
	    RETVAL = c99_nearbyint(x);
#else
	    not_here("nearbyint");
#endif
	    break;
	case 22:
#ifdef c99_rint
	    RETVAL = c99_rint(x);
#else
	    not_here("rint");
#endif
	    break;
	case 23:
#ifdef c99_round
	    RETVAL = c99_round(x);
#else
	    not_here("round");
#endif
	    break;
	case 24:
	    RETVAL = Perl_sinh(x); /* C89 math */
	    break;
	case 25:
	    RETVAL = Perl_tan(x); /* C89 math */
	    break;
	case 26:
	    RETVAL = Perl_tanh(x); /* C89 math */
	    break;
	case 27:
#ifdef c99_tgamma
	    RETVAL = c99_tgamma(x);
#else
	    not_here("tgamma");
#endif
	    break;
	case 28:
#ifdef c99_trunc
	    RETVAL = c99_trunc(x);
#else
	    not_here("trunc");
#endif
	    break;
	case 29:
#ifdef bessel_y0
	    RETVAL = bessel_y0(x);
#else
	    not_here("y0");
#endif
	    break;
        case 30:
	default:
#ifdef bessel_y1
	    RETVAL = bessel_y1(x);
#else
	    not_here("y1");
#endif
	}
#line 3122 "POSIX.c"
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_fegetround); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_fegetround)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 2520 "POSIX.xs"
#ifdef HAS_FEGETROUND
	RETVAL = my_fegetround();
#else
	RETVAL = -1;
	not_here("fegetround");
#endif
#line 3145 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_fesetround); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_fesetround)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	IV	x = (IV)SvIV(ST(0))
;
	IV	RETVAL;
	dXSTARG;
#line 2533 "POSIX.xs"
#ifdef HAS_FEGETROUND /* canary for fesetround */
	RETVAL = fesetround(x);
#elif defined(HAS_FPGETROUND) /* canary for fpsetround */
	switch (x) {
	case FE_TONEAREST:  RETVAL = fpsetround(FP_RN); break;
	case FE_TOWARDZERO: RETVAL = fpsetround(FP_RZ); break;
	case FE_DOWNWARD:   RETVAL = fpsetround(FP_RM); break;
	case FE_UPWARD:     RETVAL = fpsetround(FP_RP); break;
        default: RETVAL = -1; break;
	}
#elif defined(__osf__) /* Tru64 */
	switch (x) {
	case FE_TONEAREST:  RETVAL = write_rnd(FP_RND_RN); break;
	case FE_TOWARDZERO: RETVAL = write_rnd(FP_RND_RZ); break;
	case FE_DOWNWARD:   RETVAL = write_rnd(FP_RND_RM); break;
	case FE_UPWARD:     RETVAL = write_rnd(FP_RND_RP); break;
        default: RETVAL = -1; break;
	}
#else
	PERL_UNUSED_VAR(x);
	RETVAL = -1;
	not_here("fesetround");
#endif
#line 3187 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_fpclassify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_fpclassify)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	NV	x = (NV)SvNV(ST(0))
;
	IV	RETVAL;
	dXSTARG;
#line 2572 "POSIX.xs"
        PERL_UNUSED_VAR(x);
	RETVAL = -1;
	switch (ix) {
	case 0:
#ifdef c99_fpclassify
	    RETVAL = c99_fpclassify(x);
#else
	    not_here("fpclassify");
#endif
	    break;
	case 1:
#ifdef c99_ilogb
	    RETVAL = c99_ilogb(x);
#else
	    not_here("ilogb");
#endif
	    break;
	case 2:
	    RETVAL = Perl_isfinite(x);
	    break;
	case 3:
	    RETVAL = Perl_isinf(x);
	    break;
	case 4:
	    RETVAL = Perl_isnan(x);
	    break;
	case 5:
#ifdef c99_isnormal
	    RETVAL = c99_isnormal(x);
#else
	    not_here("isnormal");
#endif
	    break;
	case 6:
#ifdef c99_lrint
	    RETVAL = c99_lrint(x);
#else
	    not_here("lrint");
#endif
	    break;
	case 7:
#ifdef c99_lround
	    RETVAL = c99_lround(x);
#else
	    not_here("lround");
#endif
	    break;
	case 8:
	default:
	    RETVAL = Perl_signbit(x);
	    break;
	}
#line 3259 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_getpayload); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_getpayload)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "nv");
    {
	NV	nv = (NV)SvNV(ST(0))
;
	NV	RETVAL;
	dXSTARG;
#line 2631 "POSIX.xs"
#ifdef DOUBLE_HAS_NAN
	RETVAL = S_getpayload(nv);
#else
        PERL_UNUSED_VAR(nv);
        RETVAL = 0.0;
	not_here("getpayload");
#endif
#line 3285 "POSIX.c"
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_setpayload); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_setpayload)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "nv, payload");
    {
	NV	nv = (NV)SvNV(ST(0))
;
	NV	payload = (NV)SvNV(ST(1))
;
#line 2646 "POSIX.xs"
#ifdef DOUBLE_HAS_NAN
	S_setpayload(&nv, payload, FALSE);
#else
        PERL_UNUSED_VAR(nv);
        PERL_UNUSED_VAR(payload);
	not_here("setpayload");
#endif
#line 3311 "POSIX.c"
	sv_setnv(ST(0), (NV)nv);
	SvSETMAGIC(ST(0));
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_POSIX_setpayloadsig); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_setpayloadsig)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "nv, payload");
    {
	NV	nv = (NV)SvNV(ST(0))
;
	NV	payload = (NV)SvNV(ST(1))
;
#line 2661 "POSIX.xs"
#ifdef DOUBLE_HAS_NAN
	nv = NV_NAN;
	S_setpayload(&nv, payload, TRUE);
#else
        PERL_UNUSED_VAR(nv);
        PERL_UNUSED_VAR(payload);
	not_here("setpayloadsig");
#endif
#line 3339 "POSIX.c"
	sv_setnv(ST(0), (NV)nv);
	SvSETMAGIC(ST(0));
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_POSIX_issignaling); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_issignaling)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "nv");
    {
	NV	nv = (NV)SvNV(ST(0))
;
	int	RETVAL;
	dXSTARG;
#line 2676 "POSIX.xs"
#ifdef DOUBLE_HAS_NAN
	RETVAL = Perl_isnan(nv) && NV_NAN_IS_SIGNALING(&nv);
#else
        PERL_UNUSED_VAR(nv);
        RETVAL = 0.0;
	not_here("issignaling");
#endif
#line 3366 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_copysign); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_copysign)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "x, y");
    {
	NV	x = (NV)SvNV(ST(0))
;
	NV	y = (NV)SvNV(ST(1))
;
	NV	RETVAL;
	dXSTARG;
#line 2706 "POSIX.xs"
        PERL_UNUSED_VAR(x);
        PERL_UNUSED_VAR(y);
#ifdef NV_NAN
	RETVAL = NV_NAN;
#else
	RETVAL = 0;
#endif
	switch (ix) {
	case 0:
#ifdef c99_copysign
	    RETVAL = c99_copysign(x, y);
#else
	    not_here("copysign");
#endif
	    break;
	case 1:
#ifdef c99_fdim
	    RETVAL = c99_fdim(x, y);
#else
	    not_here("fdim");
#endif
	    break;
	case 2:
#ifdef c99_fmax
	    RETVAL = c99_fmax(x, y);
#else
	    not_here("fmax");
#endif
	    break;
	case 3:
#ifdef c99_fmin
	    RETVAL = c99_fmin(x, y);
#else
	    not_here("fmin");
#endif
	    break;
	case 4:
	    RETVAL = Perl_fmod(x, y); /* C89 math */
	    break;
	case 5:
#ifdef c99_hypot
	    RETVAL = c99_hypot(x, y);
#else
	    not_here("hypot");
#endif
	    break;
	case 6:
#ifdef c99_isgreater
	    RETVAL = c99_isgreater(x, y);
#else
	    not_here("isgreater");
#endif
	    break;
	case 7:
#ifdef c99_isgreaterequal
	    RETVAL = c99_isgreaterequal(x, y);
#else
	    not_here("isgreaterequal");
#endif
	    break;
	case 8:
#ifdef c99_isless
	    RETVAL = c99_isless(x, y);
#else
	    not_here("isless");
#endif
	    break;
	case 9:
#ifdef c99_islessequal
	    RETVAL = c99_islessequal(x, y);
#else
	    not_here("islessequal");
#endif
	    break;
	case 10:
#ifdef c99_islessgreater
	    RETVAL = c99_islessgreater(x, y);
#else
	    not_here("islessgreater");
#endif
	    break;
	case 11:
#ifdef c99_isunordered
	    RETVAL = c99_isunordered(x, y);
#else
	    not_here("isunordered");
#endif
	    break;
	case 12:
#ifdef c99_nextafter
	    RETVAL = c99_nextafter(x, y);
#else
	    not_here("nextafter");
#endif
	    break;
	case 13:
#ifdef c99_nexttoward
	    RETVAL = c99_nexttoward(x, y);
#else
	    not_here("nexttoward");
#endif
	    break;
	case 14:
	default:
#ifdef c99_remainder
          RETVAL = c99_remainder(x, y);
#else
          not_here("remainder");
#endif
	    break;
	}
#line 3499 "POSIX.c"
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_frexp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_frexp)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	NV	x = (NV)SvNV(ST(0))
;
#line 2824 "POSIX.xs"
	int expvar;
	/* (We already know stack is long enough.) */
	PUSHs(sv_2mortal(newSVnv(Perl_frexp(x,&expvar)))); /* C89 math */
	PUSHs(sv_2mortal(newSViv(expvar)));
#line 3522 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_POSIX_ldexp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_ldexp)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, exp");
    {
	NV	x = (NV)SvNV(ST(0))
;
	int	exp = (int)SvIV(ST(1))
;
	NV	RETVAL;
	dXSTARG;
#line 2834 "POSIX.xs"
        RETVAL = Perl_ldexp(x, exp);
#line 3544 "POSIX.c"
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_modf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_modf)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	NV	x = (NV)SvNV(ST(0))
;
#line 2842 "POSIX.xs"
	NV intvar;
	/* (We already know stack is long enough.) */
	PUSHs(sv_2mortal(newSVnv(Perl_modf(x,&intvar)))); /* C89 math */
	PUSHs(sv_2mortal(newSVnv(intvar)));
#line 3567 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_POSIX_remquo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_remquo)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	NV	x = (NV)SvNV(ST(0))
;
	NV	y = (NV)SvNV(ST(1))
;
#line 2852 "POSIX.xs"
#ifdef c99_remquo
        int intvar;
        PUSHs(sv_2mortal(newSVnv(c99_remquo(x,y,&intvar))));
        PUSHs(sv_2mortal(newSVnv(intvar)));
#else
	PERL_UNUSED_VAR(x);
	PERL_UNUSED_VAR(y);
	not_here("remquo");
#endif
#line 3597 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_POSIX_scalbn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_scalbn)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, y");
    {
	NV	x = (NV)SvNV(ST(0))
;
	IV	y = (IV)SvIV(ST(1))
;
	NV	RETVAL;
	dXSTARG;
#line 2867 "POSIX.xs"
#ifdef c99_scalbn
	RETVAL = c99_scalbn(x, y);
#else
	PERL_UNUSED_VAR(x);
	PERL_UNUSED_VAR(y);
	RETVAL = NV_NAN;
	not_here("scalbn");
#endif
#line 3626 "POSIX.c"
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_fma); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_fma)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "x, y, z");
    {
	NV	x = (NV)SvNV(ST(0))
;
	NV	y = (NV)SvNV(ST(1))
;
	NV	z = (NV)SvNV(ST(2))
;
	NV	RETVAL;
	dXSTARG;
#line 2884 "POSIX.xs"
#ifdef c99_fma
	RETVAL = c99_fma(x, y, z);
#else
	PERL_UNUSED_VAR(x);
	PERL_UNUSED_VAR(y);
	PERL_UNUSED_VAR(z);
	not_here("fma");
#endif
#line 3657 "POSIX.c"
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_nan); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_nan)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "payload = 0");
    {
	NV	payload;
	NV	RETVAL;
	dXSTARG;

	if (items < 1)
	    payload = 0;
	else {
	    payload = (NV)SvNV(ST(0))
;
	}
#line 2899 "POSIX.xs"
#ifdef NV_NAN
        /* If no payload given, just return the default NaN.
         * This makes a difference in platforms where the default
         * NaN is not all zeros. */
	if (items == 0) {
          RETVAL = NV_NAN;
	} else {
          S_setpayload(&RETVAL, payload, FALSE);
        }
#elif defined(c99_nan)
	{
	  STRLEN elen = my_snprintf(PL_efloatbuf, PL_efloatsize, "%g", payload);
          if ((IV)elen == -1) {
#ifdef NV_NAN
	    RETVAL = NV_NAN;
#else            
            RETVAL = 0.0;
            not_here("nan");
#endif
          } else {
            RETVAL = c99_nan(PL_efloatbuf);
          }
        }
#else
	not_here("nan");
#endif
#line 3708 "POSIX.c"
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_jn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_jn)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "x, y");
    {
	IV	x = (IV)SvIV(ST(0))
;
	NV	y = (NV)SvNV(ST(1))
;
	NV	RETVAL;
	dXSTARG;
#line 2935 "POSIX.xs"
#ifdef NV_NAN
	RETVAL = NV_NAN;
#else
	RETVAL = 0;
#endif
        switch (ix) {
	case 0:
#ifdef bessel_jn
          RETVAL = bessel_jn(x, y);
#else
	  PERL_UNUSED_VAR(x);
	  PERL_UNUSED_VAR(y);
          not_here("jn");
#endif
            break;
	case 1:
	default:
#ifdef bessel_yn
          RETVAL = bessel_yn(x, y);
#else
	  PERL_UNUSED_VAR(x);
	  PERL_UNUSED_VAR(y);
          not_here("yn");
#endif
            break;
	}
#line 3756 "POSIX.c"
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_sigaction); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_sigaction)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "sig, optaction, oldaction = 0");
    {
	int	sig = (int)SvIV(ST(0))
;
	SV *	optaction = ST(1)
;
	POSIX__SigAction	oldaction;
	SysRet	RETVAL;

	if (items < 3)
	    oldaction = 0;
	else {
	    STMT_START {
		    SV* const xsub_tmp_sv = ST(2);
		    SvGETMAGIC(xsub_tmp_sv);
		    if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
			oldaction = (HV*)SvRV(xsub_tmp_sv);
		    }
		    else{
			Perl_croak_nocontext("%s: %s is not a HASH reference",
				    "POSIX::sigaction",
				    "oldaction");
		    }
	    } STMT_END
;
	}
#line 2970 "POSIX.xs"
#if defined(WIN32) || defined(NETWARE) || (defined(__amigaos4__) && defined(__NEWLIB__))
	RETVAL = not_here("sigaction");
#else

	{
	    POSIX__SigAction action;
	    GV *siggv = gv_fetchpvs("SIG", GV_ADD, SVt_PVHV);
	    struct sigaction act;
	    struct sigaction oact;
	    sigset_t sset;
	    SV *osset_sv;
	    sigset_t osset;
	    POSIX__SigSet sigset;
	    SV** svp;
	    SV** sigsvp;

            if (sig < 0) {
                croak("Negative signals are not allowed");
            }

	    if (sig == 0 && SvPOK(ST(0))) {
	        const char *s = SvPVX_const(ST(0));
		int i = whichsig(s);

	        if (i < 0 && memBEGINs(s, SvCUR(ST(0)), "SIG"))
		    i = whichsig(s + 3);
	        if (i < 0) {
	            if (ckWARN(WARN_SIGNAL))
		        Perl_warner(aTHX_ packWARN(WARN_SIGNAL),
                                    "No such signal: SIG%s", s);
	            XSRETURN_UNDEF;
		}
	        else
		    sig = i;
            }
#ifdef NSIG
	    if (sig > NSIG) { /* NSIG - 1 is still okay. */
	        Perl_warner(aTHX_ packWARN(WARN_SIGNAL),
                            "No such signal: %d", sig);
	        XSRETURN_UNDEF;
	    }
#endif
	    sigsvp = hv_fetch(GvHVn(siggv),
			      PL_sig_name[sig],
			      strlen(PL_sig_name[sig]),
			      TRUE);

	    /* Check optaction and set action */
	    if(SvTRUE(optaction)) {
		if(sv_isa(optaction, "POSIX::SigAction"))
			action = (HV*)SvRV(optaction);
		else
			croak("action is not of type POSIX::SigAction");
	    }
	    else {
		action=0;
	    }

	    /* sigaction() is supposed to look atomic. In particular, any
	     * signal handler invoked during a sigaction() call should
	     * see either the old or the new disposition, and not something
	     * in between. We use sigprocmask() to make it so.
	     */
	    sigfillset(&sset);
	    RETVAL=sigprocmask(SIG_BLOCK, &sset, &osset);
	    if(RETVAL == -1)
               XSRETURN_UNDEF;
	    ENTER;
	    /* Restore signal mask no matter how we exit this block. */
	    osset_sv = newSVpvn((char *)(&osset), sizeof(sigset_t));
	    SAVEFREESV( osset_sv );
	    SAVEDESTRUCTOR_X(restore_sigmask, osset_sv);

	    RETVAL=-1; /* In case both oldaction and action are 0. */

	    /* Remember old disposition if desired. */
	    if (oldaction) {
                int safe;

		svp = hv_fetchs(oldaction, "HANDLER", TRUE);
		if(!svp)
		    croak("Can't supply an oldaction without a HANDLER");
		if(SvTRUE(*sigsvp)) { /* TBD: what if "0"? */
			sv_setsv(*svp, *sigsvp);
		}
		else {
			sv_setpvs(*svp, "DEFAULT");
		}
		RETVAL = sigaction(sig, (struct sigaction *)0, & oact);
		if(RETVAL == -1) {
                   LEAVE;
                   XSRETURN_UNDEF;
                }
		/* Get back the mask. */
		svp = hv_fetchs(oldaction, "MASK", TRUE);
		if (sv_isa(*svp, "POSIX::SigSet")) {
		    sigset = (sigset_t *) SvPV_nolen(SvRV(*svp));
		}
		else {
		    sigset = (sigset_t *) allocate_struct(aTHX_ *svp,
							  sizeof(sigset_t),
							  "POSIX::SigSet");
		}
		*sigset = oact.sa_mask;

		/* Get back the flags. */
		svp = hv_fetchs(oldaction, "FLAGS", TRUE);
		sv_setiv(*svp, oact.sa_flags);

		/* Get back whether the old handler used safe signals;
                 * i.e. it used Perl_csighandler[13] rather than
                 * Perl_sighandler[13]
                 */
                safe =
#ifdef SA_SIGINFO
                    (oact.sa_flags & SA_SIGINFO)
                        ? (  oact.sa_sigaction == PL_csighandler3p
#ifdef PERL_USE_3ARG_SIGHANDLER
                          || oact.sa_sigaction == PL_csighandlerp
#endif
                          )
                        :
#endif
                           (  oact.sa_handler   == PL_csighandler1p
#ifndef PERL_USE_3ARG_SIGHANDLER
                          || oact.sa_handler   == PL_csighandlerp
#endif
                           );

		svp = hv_fetchs(oldaction, "SAFE", TRUE);
		sv_setiv(*svp, safe);
	    }

	    if (action) {
                int safe;

		/* Set up any desired flags. */
		svp = hv_fetchs(action, "FLAGS", FALSE);
		act.sa_flags = svp ? SvIV(*svp) : 0;

		/* Safe signals use "csighandler", which vectors through the
		   PL_sighandlerp pointer when it's safe to do so.
		   (BTW, "csighandler" is very different from "sighandler".) */
		svp = hv_fetchs(action, "SAFE", FALSE);
                safe = *svp && SvTRUE(*svp);
#ifdef SA_SIGINFO
                if (act.sa_flags & SA_SIGINFO) {
                    /* 3-arg handler */
                    act.sa_sigaction =
			    safe ? PL_csighandler3p : PL_sighandler3p;
                }
                else
#endif
                {
                    /* 1-arg handler */
                    act.sa_handler =
			    safe ? PL_csighandler1p : PL_sighandler1p;
                }

		/* Vector new Perl handler through %SIG.
		   (The core signal handlers read %SIG to dispatch.) */
		svp = hv_fetchs(action, "HANDLER", FALSE);
		if (!svp)
		    croak("Can't supply an action without a HANDLER");
		sv_setsv(*sigsvp, *svp);

		/* This call actually calls sigaction() with almost the
		   right settings, including appropriate interpretation
		   of DEFAULT and IGNORE.  However, why are we doing
		   this when we're about to do it again just below?  XXX */
		SvSETMAGIC(*sigsvp);

		/* And here again we duplicate -- DEFAULT/IGNORE checking. */
		if(SvPOK(*svp)) {
			const char *s=SvPVX_const(*svp);
			if(strEQ(s,"IGNORE")) {
				act.sa_handler = SIG_IGN;
			}
			else if(strEQ(s,"DEFAULT")) {
				act.sa_handler = SIG_DFL;
			}
		}

		/* Set up any desired mask. */
		svp = hv_fetchs(action, "MASK", FALSE);
		if (svp && sv_isa(*svp, "POSIX::SigSet")) {
		    sigset = (sigset_t *) SvPV_nolen(SvRV(*svp));
		    act.sa_mask = *sigset;
		}
		else
		    sigemptyset(& act.sa_mask);

		/* Don't worry about cleaning up *sigsvp if this fails,
		 * because that means we tried to disposition a
		 * nonblockable signal, in which case *sigsvp is
		 * essentially meaningless anyway.
		 */
		RETVAL = sigaction(sig, & act, (struct sigaction *)0);
		if(RETVAL == -1) {
                    LEAVE;
		    XSRETURN_UNDEF;
                }
	    }

	    LEAVE;
	}
#endif
#line 4002 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_sigpending); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_sigpending)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "sigset");
    {
	POSIX__SigSet	sigset;
	SysRet	RETVAL;

	{
	    SV * sv = ST(0);
	    if (SvROK(sv) && sv_derived_from(sv, "POSIX::SigSet"))
		sigset = (POSIX__SigSet)SvPV_nolen(SvRV(sv));
	    else
		croak("%s: %s is not of type %s",
			    GvNAME(CvGV(cv)),
			"sigset", "POSIX::SigSet");
	}
;
#line 3188 "POSIX.xs"
#ifdef __amigaos4__
	RETVAL = not_here("sigpending");
#else
	RETVAL = ix ? sigsuspend(sigset) : sigpending(sigset);
#endif
#line 4046 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
#line 3196 "POSIX.xs"
    PERL_ASYNC_CHECK();
#line 4060 "POSIX.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_sigprocmask); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_sigprocmask)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "how, sigset, oldsigset = 0");
    {
	int	how = (int)SvIV(ST(0))
;
	POSIX__SigSet	sigset;
	POSIX__SigSet	oldsigset;
	SysRet	RETVAL;
#line 3204 "POSIX.xs"
	if (! SvOK(ST(1))) {
	    sigset = NULL;
	} else if (sv_isa(ST(1), "POSIX::SigSet")) {
	    sigset = (sigset_t *) SvPV_nolen(SvRV(ST(1)));
	} else {
	    croak("sigset is not of type POSIX::SigSet");
	}

	if (items < 3 || ! SvOK(ST(2))) {
	    oldsigset = NULL;
	} else if (sv_isa(ST(2), "POSIX::SigSet")) {
	    oldsigset = (sigset_t *) SvPV_nolen(SvRV(ST(2)));
	} else {
	    croak("oldsigset is not of type POSIX::SigSet");
	}
#line 4094 "POSIX.c"

	RETVAL = sigprocmask(how, sigset, oldsigset);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX__exit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX__exit)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "status");
    {
	int	status = (int)SvIV(ST(0))
;

	_exit(status);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_POSIX_dup2); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_dup2)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "fd1, fd2");
    {
	int	fd1 = (int)SvIV(ST(0))
;
	int	fd2 = (int)SvIV(ST(1))
;
	SysRet	RETVAL;
#line 3229 "POSIX.xs"
	if (fd1 >= 0 && fd2 >= 0) {
#ifdef WIN32
            /* RT #98912 - More Microsoft muppetry - failing to
               actually implemented the well known documented POSIX
               behaviour for a POSIX API.
               http://msdn.microsoft.com/en-us/library/8syseb29.aspx  */
            RETVAL = dup2(fd1, fd2) == -1 ? -1 : fd2;
#else
            RETVAL = dup2(fd1, fd2);
#endif
        } else {
            SETERRNO(EBADF,RMS_IFI);
            RETVAL = -1;
        }
#line 4156 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_lseek); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_lseek)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "fd, offset, whence");
    {
	POSIX__Fd	fd;
	Off_t	offset = (Off_t)SvNV(ST(1))
;
	int	whence = (int)SvIV(ST(2))
;
	SV *	RETVAL;

	if ((fd = (int)SvIV(ST(0))) < 0) {
	     SETERRNO(EBADF, RMS_IFI);
	     XSRETURN_IV(-1);
	}
;
#line 3252 "POSIX.xs"
	{
              Off_t pos = PerlLIO_lseek(fd, offset, whence);
              RETVAL = sizeof(Off_t) > sizeof(IV)
                ? newSVnv((NV)pos) : newSViv((IV)pos);
        }
#line 4198 "POSIX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_nice); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_nice)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "incr");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	int	incr = (int)SvIV(ST(0))
;
#line 3264 "POSIX.xs"
	errno = 0;
	if ((incr = nice(incr)) != -1 || errno == 0) {
	    if (incr == 0)
		XPUSHs(newSVpvs_flags("0 but true", SVs_TEMP));
	    else
		XPUSHs(sv_2mortal(newSViv(incr)));
	}
#line 4225 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_POSIX_pipe); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_pipe)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 3275 "POSIX.xs"
	int fds[2];
	if (pipe(fds) != -1) {
	    EXTEND(SP,2);
	    PUSHs(sv_2mortal(newSViv(fds[0])));
	    PUSHs(sv_2mortal(newSViv(fds[1])));
	}
#line 4248 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_POSIX_read); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_read)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "fd, buffer, nbytes");
    {
#line 3285 "POSIX.xs"
        SV *sv_buffer = SvROK(ST(1)) ? SvRV(ST(1)) : ST(1);
#line 4264 "POSIX.c"
	POSIX__Fd	fd;
	size_t	nbytes = (size_t)SvUV(ST(2))
;
	char *	buffer = sv_grow( sv_buffer, nbytes+1 );
	SysRet	RETVAL;

	if ((fd = (int)SvIV(ST(0))) < 0) {
	     SETERRNO(EBADF, RMS_IFI);
	     XSRETURN_IV(-1);
	}
;

	RETVAL = read(fd, buffer, nbytes);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
#line 3291 "POSIX.xs"
        if (RETVAL >= 0) {
            SvCUR_set(sv_buffer, RETVAL);
            SvPOK_only(sv_buffer);
            *SvEND(sv_buffer) = '\0';
            SvTAINTED_on(sv_buffer);
        }
#line 4296 "POSIX.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_setpgid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_setpgid)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "pid, pgid");
    {
	pid_t	pid = (pid_t)SvNV(ST(0))
;
	pid_t	pgid = (pid_t)SvNV(ST(1))
;
	SysRet	RETVAL;

	RETVAL = setpgid(pid, pgid);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_setsid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_setsid)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	pid_t	RETVAL;
	dXSTARG;

	RETVAL = setsid();
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_tcgetpgrp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_tcgetpgrp)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "fd");
    {
	POSIX__Fd	fd;
	pid_t	RETVAL;
	dXSTARG;

	if ((fd = (int)SvIV(ST(0))) < 0) {
	     SETERRNO(EBADF, RMS_IFI);
	     XSRETURN_IV(-1);
	}
;

	RETVAL = tcgetpgrp(fd);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_tcsetpgrp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_tcsetpgrp)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "fd, pgrp_id");
    {
	POSIX__Fd	fd;
	pid_t	pgrp_id = (pid_t)SvNV(ST(1))
;
	SysRet	RETVAL;

	if ((fd = (int)SvIV(ST(0))) < 0) {
	     SETERRNO(EBADF, RMS_IFI);
	     XSRETURN_IV(-1);
	}
;

	RETVAL = tcsetpgrp(fd, pgrp_id);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_uname); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_uname)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 3318 "POSIX.xs"
#ifdef HAS_UNAME
	struct utsname buf;
	if (uname(&buf) >= 0) {
	    EXTEND(SP, 5);
	    PUSHs(newSVpvn_flags(buf.sysname, strlen(buf.sysname), SVs_TEMP));
	    PUSHs(newSVpvn_flags(buf.nodename, strlen(buf.nodename), SVs_TEMP));
	    PUSHs(newSVpvn_flags(buf.release, strlen(buf.release), SVs_TEMP));
	    PUSHs(newSVpvn_flags(buf.version, strlen(buf.version), SVs_TEMP));
	    PUSHs(newSVpvn_flags(buf.machine, strlen(buf.machine), SVs_TEMP));
	}
#else
	uname((char *) 0); /* A stub to call not_here(). */
#endif
#line 4431 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_POSIX_write); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_write)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "fd, buffer, nbytes");
    {
	POSIX__Fd	fd;
	char *	buffer = (char *)SvPV_nolen(ST(1))
;
	size_t	nbytes = (size_t)SvUV(ST(2))
;
	SysRet	RETVAL;

	if ((fd = (int)SvIV(ST(0))) < 0) {
	     SETERRNO(EBADF, RMS_IFI);
	     XSRETURN_IV(-1);
	}
;

	RETVAL = write(fd, buffer, nbytes);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_abort); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_abort)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	abort();
    }
    XSRETURN_EMPTY;
}

#if defined(HAS_MBRLEN) && (defined(USE_ITHREADS) || ! defined(HAS_MBLEN))
#  define USE_MBRLEN
#else
#  undef USE_MBRLEN
#endif

XS_EUPXS(XS_POSIX_mblen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_mblen)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "s, n = ~0");
    {
	SV *	s = ST(0)
;
	size_t	n;
	int	RETVAL;
	dXSTARG;

	if (items < 2)
	    n = ~0;
	else {
	    n = (size_t)SvUV(ST(1))
;
	}
#line 3352 "POSIX.xs"
        errno = 0;

        SvGETMAGIC(s);
        if (! SvOK(s)) {
#ifdef USE_MBRLEN
            /* Initialize the shift state in PL_mbrlen_ps.  The Standard says
             * that should be all zeros. */
            memzero(&PL_mbrlen_ps, sizeof(PL_mbrlen_ps));
            RETVAL = 0;
#else
            MBLEN_LOCK;
            RETVAL = mblen(NULL, 0);
            MBLEN_UNLOCK;
#endif
        }
        else {  /* Not resetting state */
            SV * byte_s = sv_2mortal(newSVsv_nomg(s));
            if (! sv_utf8_downgrade_nomg(byte_s, TRUE)) {
                SETERRNO(EINVAL, LIB_INVARG);
                RETVAL = -1;
            }
            else {
                size_t len;
                char * string = SvPV(byte_s, len);
                if (n < len) len = n;
#ifdef USE_MBRLEN
                RETVAL = (SSize_t) mbrlen(string, len, &PL_mbrlen_ps);
                if (RETVAL < 0) RETVAL = -1;    /* Use mblen() ret code for
                                                   transparency */
#else
                /* Locking prevents races, but locales can be switched out
                 * without locking, so this isn't a cure all */
                MBLEN_LOCK;
                RETVAL = mblen(string, len);
                MBLEN_UNLOCK;
#endif
            }
        }
#line 4552 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if defined(HAS_MBRTOWC) && (defined(USE_ITHREADS) || ! defined(HAS_MBTOWC))
#  define USE_MBRTOWC
#else
#  undef USE_MBRTOWC
#endif

XS_EUPXS(XS_POSIX_mbtowc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_mbtowc)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "pwc, s, n = ~0");
    {
	SV *	pwc = ST(0)
;
	SV *	s = ST(1)
;
	size_t	n;
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    n = ~0;
	else {
	    n = (size_t)SvUV(ST(2))
;
	}
#line 3405 "POSIX.xs"
        errno = 0;
        SvGETMAGIC(s);
        if (! SvOK(s)) { /* Initialize state */
#ifdef USE_MBRTOWC
            /* Initialize the shift state to all zeros in PL_mbrtowc_ps. */
            memzero(&PL_mbrtowc_ps, sizeof(PL_mbrtowc_ps));
            RETVAL = 0;
#else
            MBTOWC_LOCK;
            RETVAL = mbtowc(NULL, NULL, 0);
            MBTOWC_UNLOCK;
#endif
        }
        else {  /* Not resetting state */
            wchar_t wc;
            SV * byte_s = sv_2mortal(newSVsv_nomg(s));
            if (! sv_utf8_downgrade_nomg(byte_s, TRUE)) {
                SETERRNO(EINVAL, LIB_INVARG);
                RETVAL = -1;
            }
            else {
                size_t len;
                char * string = SvPV(byte_s, len);
                if (n < len) len = n;
#ifdef USE_MBRTOWC
                RETVAL = (SSize_t) mbrtowc(&wc, string, len, &PL_mbrtowc_ps);
#else
                /* Locking prevents races, but locales can be switched out
                 * without locking, so this isn't a cure all */
                MBTOWC_LOCK;
                RETVAL = mbtowc(&wc, string, len);
                MBTOWC_UNLOCK;
#endif
                if (RETVAL >= 0) {
                    sv_setiv_mg(pwc, wc);
                }
                else { /* Use mbtowc() ret code for transparency */
                    RETVAL = -1;
                }
            }
        }
#line 4627 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if defined(HAS_WCRTOMB) && (defined(USE_ITHREADS) || ! defined(HAS_WCTOMB))
#  define USE_WCRTOMB
#else
#  undef USE_WCRTOMB
#endif

XS_EUPXS(XS_POSIX_wctomb); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_wctomb)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, wchar");
    {
	SV *	s = ST(0)
;
	wchar_t	wchar = (wchar_t)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;
#line 3460 "POSIX.xs"
        errno = 0;
        SvGETMAGIC(s);
        if (s == &PL_sv_undef) {
#ifdef USE_WCRTOMB
            /* The man pages khw looked at are in agreement that this works.
             * But probably memzero would too */
            RETVAL = wcrtomb(NULL, L'\0', &PL_wcrtomb_ps);
#else
            WCTOMB_LOCK;
            RETVAL = wctomb(NULL, L'\0');
            WCTOMB_UNLOCK;
#endif
        }
        else {  /* Not resetting state */
            char buffer[MB_LEN_MAX];
#ifdef USE_WCRTOMB
            RETVAL = wcrtomb(buffer, wchar, &PL_wcrtomb_ps);
#else
            /* Locking prevents races, but locales can be switched out without
             * locking, so this isn't a cure all */
            WCTOMB_LOCK;
            RETVAL = wctomb(buffer, wchar);
            WCTOMB_UNLOCK;
#endif
            if (RETVAL >= 0) {
                sv_setpvn_mg(s, buffer, RETVAL);
            }
        }
#line 4681 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_strcoll); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_strcoll)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s1, s2");
    {
	char *	s1 = (char *)SvPV_nolen(ST(0))
;
	char *	s2 = (char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = strcoll(s1, s2);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_strtod); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_strtod)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "str");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *	str = (char *)SvPV_nolen(ST(0))
;
#line 3500 "POSIX.xs"
	double num;
	char *unparsed;
#line 4723 "POSIX.c"
#line 3503 "POSIX.xs"
        DECLARATION_FOR_LC_NUMERIC_MANIPULATION;
        STORE_LC_NUMERIC_FORCE_TO_UNDERLYING();
	num = strtod(str, &unparsed);
        RESTORE_LC_NUMERIC();
	PUSHs(sv_2mortal(newSVnv(num)));
	if (GIMME_V == G_ARRAY) {
	    EXTEND(SP, 1);
	    if (unparsed)
		PUSHs(sv_2mortal(newSViv(strlen(unparsed))));
	    else
		PUSHs(&PL_sv_undef);
	}
#line 4737 "POSIX.c"
	PUTBACK;
	return;
    }
}

#ifdef HAS_STRTOLD
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_POSIX_strtold); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_strtold)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "str");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *	str = (char *)SvPV_nolen(ST(0))
;
#line 3522 "POSIX.xs"
	long double num;
	char *unparsed;
#line 4761 "POSIX.c"
#line 3525 "POSIX.xs"
        DECLARATION_FOR_LC_NUMERIC_MANIPULATION;
        STORE_LC_NUMERIC_FORCE_TO_UNDERLYING();
	num = strtold(str, &unparsed);
        RESTORE_LC_NUMERIC();
	PUSHs(sv_2mortal(newSVnv(num)));
	if (GIMME_V == G_ARRAY) {
	    EXTEND(SP, 1);
	    if (unparsed)
		PUSHs(sv_2mortal(newSViv(strlen(unparsed))));
	    else
		PUSHs(&PL_sv_undef);
	}
#line 4775 "POSIX.c"
	PUTBACK;
	return;
    }
}

#endif

XS_EUPXS(XS_POSIX_strtol); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_strtol)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "str, base = 0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *	str = (char *)SvPV_nolen(ST(0))
;
	int	base;
#line 3545 "POSIX.xs"
	long num;
	char *unparsed;
#line 4798 "POSIX.c"

	if (items < 2)
	    base = 0;
	else {
	    base = (int)SvIV(ST(1))
;
	}
#line 3548 "POSIX.xs"
	if (base == 0 || inRANGE(base, 2, 36)) {
            num = strtol(str, &unparsed, base);
#if IVSIZE < LONGSIZE
            if (num < IV_MIN || num > IV_MAX)
                PUSHs(sv_2mortal(newSVnv((double)num)));
            else
#endif
                PUSHs(sv_2mortal(newSViv((IV)num)));
            if (GIMME_V == G_ARRAY) {
                EXTEND(SP, 1);
                if (unparsed)
                    PUSHs(sv_2mortal(newSViv(strlen(unparsed))));
                else
                    PUSHs(&PL_sv_undef);
            }
        } else {
	    SETERRNO(EINVAL, LIB_INVARG);
            PUSHs(&PL_sv_undef);
            if (GIMME_V == G_ARRAY) {
               EXTEND(SP, 1);
               PUSHs(&PL_sv_undef);
            }
        }
#line 4830 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_POSIX_strtoul); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_strtoul)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "str, base = 0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char *	str = (const char *)SvPV_nolen(ST(0))
;
	int	base;
#line 3577 "POSIX.xs"
	unsigned long num;
	char *unparsed = NULL;
#line 4852 "POSIX.c"

	if (items < 2)
	    base = 0;
	else {
	    base = (int)SvIV(ST(1))
;
	}
#line 3580 "POSIX.xs"
	PERL_UNUSED_VAR(str);
	PERL_UNUSED_VAR(base);
	if (base == 0 || inRANGE(base, 2, 36)) {
            num = strtoul(str, &unparsed, base);
#if IVSIZE <= LONGSIZE
            if (num > IV_MAX)
                PUSHs(sv_2mortal(newSVnv((double)num)));
            else
#endif
                PUSHs(sv_2mortal(newSViv((IV)num)));
            if (GIMME_V == G_ARRAY) {
                EXTEND(SP, 1);
                if (unparsed)
                    PUSHs(sv_2mortal(newSViv(strlen(unparsed))));
                else
                  PUSHs(&PL_sv_undef);
            }
	} else {
	    SETERRNO(EINVAL, LIB_INVARG);
            PUSHs(&PL_sv_undef);
            if (GIMME_V == G_ARRAY) {
               EXTEND(SP, 1);
               PUSHs(&PL_sv_undef);
            }
        }
#line 4886 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_POSIX_strxfrm); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_strxfrm)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "src");
    {
	SV *	src = ST(0)
;
#line 3610 "POSIX.xs"
	{
          STRLEN srclen;
          STRLEN dstlen;
          STRLEN buflen;
          char *p = SvPV(src,srclen);
          srclen++;
          buflen = srclen * 4 + 1;
          ST(0) = sv_2mortal(newSV(buflen));
          dstlen = strxfrm(SvPVX(ST(0)), p, (size_t)buflen);
          if (dstlen >= buflen) {
              dstlen++;
              SvGROW(ST(0), dstlen);
              strxfrm(SvPVX(ST(0)), p, (size_t)dstlen);
              dstlen--;
          }
          SvCUR_set(ST(0), dstlen);
	    SvPOK_only(ST(0));
	}
#line 4921 "POSIX.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_mkfifo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_mkfifo)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "filename, mode");
    {
	char *	filename = (char *)SvPV_nolen(ST(0))
;
	Mode_t	mode = (Mode_t)SvNV(ST(1))
;
	SysRet	RETVAL;
#line 3636 "POSIX.xs"
	if(ix) {
	    RETVAL = access(filename, mode);
	} else {
	    TAINT_PROPER("mkfifo");
	    RETVAL = mkfifo(filename, mode);
	}
#line 4947 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_tcdrain); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_tcdrain)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "fd");
    {
	POSIX__Fd	fd;
	SysRet	RETVAL;

	if ((fd = (int)SvIV(ST(0))) < 0) {
	     SETERRNO(EBADF, RMS_IFI);
	     XSRETURN_IV(-1);
	}
;
#line 3652 "POSIX.xs"
	if (fd >= 0) {
	    RETVAL = ix == 1 ? close(fd)
	      : (ix < 1 ? tcdrain(fd) : dup(fd));
	} else {
	    SETERRNO(EBADF,RMS_IFI);
	    RETVAL = -1;
	}
#line 4988 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_tcflow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_tcflow)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "fd, action");
    {
	POSIX__Fd	fd;
	int	action = (int)SvIV(ST(1))
;
	SysRet	RETVAL;

	if ((fd = (int)SvIV(ST(0))) < 0) {
	     SETERRNO(EBADF, RMS_IFI);
	     XSRETURN_IV(-1);
	}
;
#line 3671 "POSIX.xs"
        if (action >= 0) {
            RETVAL = ix == 1 ? tcflush(fd, action)
              : (ix < 1 ? tcflow(fd, action) : tcsendbreak(fd, action));
        } else {
            SETERRNO(EINVAL,LIB_INVARG);
            RETVAL = -1;
        }
#line 5031 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_asctime); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_asctime)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 6 || items > 9)
       croak_xs_usage(cv,  "sec, min, hour, mday, mon, year, wday = 0, yday = 0, isdst = -1");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	int	sec = (int)SvIV(ST(0))
;
	int	min = (int)SvIV(ST(1))
;
	int	hour = (int)SvIV(ST(2))
;
	int	mday = (int)SvIV(ST(3))
;
	int	mon = (int)SvIV(ST(4))
;
	int	year = (int)SvIV(ST(5))
;
	int	wday;
	int	yday;
	int	isdst;

	if (items < 7)
	    wday = 0;
	else {
	    wday = (int)SvIV(ST(6))
;
	}

	if (items < 8)
	    yday = 0;
	else {
	    yday = (int)SvIV(ST(7))
;
	}

	if (items < 9)
	    isdst = -1;
	else {
	    isdst = (int)SvIV(ST(8))
;
	}
#line 3695 "POSIX.xs"
	{
	    dXSTARG;
	    struct tm mytm;
	    init_tm(&mytm);	/* XXX workaround - see init_tm() in core util.c */
	    mytm.tm_sec = sec;
	    mytm.tm_min = min;
	    mytm.tm_hour = hour;
	    mytm.tm_mday = mday;
	    mytm.tm_mon = mon;
	    mytm.tm_year = year;
	    mytm.tm_wday = wday;
	    mytm.tm_yday = yday;
	    mytm.tm_isdst = isdst;
	    if (ix) {
	        const time_t result = mktime(&mytm);
		if (result == (time_t)-1)
		    SvOK_off(TARG);
		else if (result == 0)
		    sv_setpvs(TARG, "0 but true");
		else
		    sv_setiv(TARG, (IV)result);
	    } else {
		sv_setpv(TARG, asctime(&mytm));
	    }
	    ST(0) = TARG;
	    XSRETURN(1);
	}
#line 5122 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_POSIX_clock); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_clock)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	long	RETVAL;
	dXSTARG;

	RETVAL = clock();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_ctime); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_ctime)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "time");
    {
	Time_t	time = (Time_t)SvNV(ST(0))
;
	char *	RETVAL;
	dXSTARG;

	RETVAL = ctime(&time);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_times); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_times)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 3733 "POSIX.xs"
	struct tms tms;
	clock_t realtime;
	realtime = times( &tms );
	EXTEND(SP,5);
	PUSHs( sv_2mortal( newSViv( (IV) realtime ) ) );
	PUSHs( sv_2mortal( newSViv( (IV) tms.tms_utime ) ) );
	PUSHs( sv_2mortal( newSViv( (IV) tms.tms_stime ) ) );
	PUSHs( sv_2mortal( newSViv( (IV) tms.tms_cutime ) ) );
	PUSHs( sv_2mortal( newSViv( (IV) tms.tms_cstime ) ) );
#line 5184 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_POSIX_difftime); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_difftime)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "time1, time2");
    {
	Time_t	time1 = (Time_t)SvNV(ST(0))
;
	Time_t	time2 = (Time_t)SvNV(ST(1))
;
	double	RETVAL;
	dXSTARG;

	RETVAL = difftime(time1, time2);
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_strftime); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_strftime)
{
    dVAR; dXSARGS;
    if (items < 7 || items > 10)
       croak_xs_usage(cv,  "fmt, sec, min, hour, mday, mon, year, wday = -1, yday = -1, isdst = -1");
    {
	SV *	fmt = ST(0)
;
	int	sec = (int)SvIV(ST(1))
;
	int	min = (int)SvIV(ST(2))
;
	int	hour = (int)SvIV(ST(3))
;
	int	mday = (int)SvIV(ST(4))
;
	int	mon = (int)SvIV(ST(5))
;
	int	year = (int)SvIV(ST(6))
;
	int	wday;
	int	yday;
	int	isdst;

	if (items < 8)
	    wday = -1;
	else {
	    wday = (int)SvIV(ST(7))
;
	}

	if (items < 9)
	    yday = -1;
	else {
	    yday = (int)SvIV(ST(8))
;
	}

	if (items < 10)
	    isdst = -1;
	else {
	    isdst = (int)SvIV(ST(9))
;
	}
#line 3764 "POSIX.xs"
	{
	    char *buf;
            SV *sv;

            /* allowing user-supplied (rather than literal) formats
             * is normally frowned upon as a potential security risk;
             * but this is part of the API so we have to allow it */
            GCC_DIAG_IGNORE_STMT(-Wformat-nonliteral);
	    buf = my_strftime(SvPV_nolen(fmt), sec, min, hour, mday, mon, year, wday, yday, isdst);
            GCC_DIAG_RESTORE_STMT;
            sv = sv_newmortal();
	    if (buf) {
                STRLEN len = strlen(buf);
		sv_usepvn_flags(sv, buf, len, SV_HAS_TRAILING_NUL);
		if (       SvUTF8(fmt)
                    || (   is_utf8_non_invariant_string((U8*) buf, len)
#ifdef USE_LOCALE_TIME
                        && _is_cur_LC_category_utf8(LC_TIME)
#else   /* If can't check directly, at least can see if script is consistent,
           under UTF-8, which gives us an extra measure of confidence. */

                        && isSCRIPT_RUN((const U8 *) buf,
                                        (const U8 *) buf + len,
                                        TRUE) /* Means assume UTF-8 */
#endif
                )) {
		    SvUTF8_on(sv);
		}
            }
            else {  /* We can't distinguish between errors and just an empty
                     * return; in all cases just return an empty string */
                SvUPGRADE(sv, SVt_PV);
                SvPV_set(sv, (char *) "");
                SvPOK_on(sv);
                SvCUR_set(sv, 0);
                SvLEN_set(sv, 0);   /* Won't attempt to free the string when sv
                                       gets destroyed */
            }
            ST(0) = sv;
	}
#line 5298 "POSIX.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_tzset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_tzset)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 3808 "POSIX.xs"
    my_tzset(aTHX);
#line 5315 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_POSIX_tzname); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_tzname)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 3813 "POSIX.xs"
	EXTEND(SP,2);
	PUSHs(newSVpvn_flags(tzname[0], strlen(tzname[0]), SVs_TEMP));
	PUSHs(newSVpvn_flags(tzname[1], strlen(tzname[1]), SVs_TEMP));
#line 5335 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_POSIX_ctermid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_ctermid)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "s = 0");
    {
	char *	s = 0;
	char *	RETVAL;
	dXSTARG;
#line 3821 "POSIX.xs"
#ifdef I_TERMIOS
        /* On some systems L_ctermid is a #define; but not all; this code works
         * for all cases (so far...) */
	s = (char *) safemalloc((size_t) L_ctermid);
#endif
	RETVAL = ctermid(s);
#line 5359 "POSIX.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
#line 3830 "POSIX.xs"
#ifdef I_TERMIOS
	Safefree(s);
#endif
#line 5365 "POSIX.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_cuserid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_cuserid)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "s = 0");
    {
	char *	s = 0;
	char *	RETVAL;
	dXSTARG;
#line 3838 "POSIX.xs"
#ifdef HAS_CUSERID
  RETVAL = cuserid(s);
#else
  PERL_UNUSED_VAR(s);
  RETVAL = 0;
  not_here("cuserid");
#endif
#line 5389 "POSIX.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_fpathconf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_fpathconf)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "fd, name");
    {
	POSIX__Fd	fd;
	int	name = (int)SvIV(ST(1))
;
	SysRetLong	RETVAL;

	if ((fd = (int)SvIV(ST(0))) < 0) {
	     SETERRNO(EBADF, RMS_IFI);
	     XSRETURN_IV(-1);
	}
;

	RETVAL = fpathconf(fd, name);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_pathconf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_pathconf)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "filename, name");
    {
	char *	filename = (char *)SvPV_nolen(ST(0))
;
	int	name = (int)SvIV(ST(1))
;
	SysRetLong	RETVAL;

	RETVAL = pathconf(filename, name);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_pause); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_pause)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SysRet	RETVAL;

	RETVAL = pause();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
#line 3861 "POSIX.xs"
    PERL_ASYNC_CHECK();
#line 5484 "POSIX.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_sleep); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_sleep)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "seconds");
    {
	unsigned int	seconds = (unsigned int)SvUV(ST(0))
;
	unsigned int	RETVAL;
	dXSTARG;
#line 3867 "POSIX.xs"
	RETVAL = PerlProc_sleep(seconds);
#line 5503 "POSIX.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_setgid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_setgid)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "gid");
    {
	Gid_t	gid = (Gid_t)SvNV(ST(0))
;
	SysRet	RETVAL;

	RETVAL = setgid(gid);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_setuid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_setuid)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "uid");
    {
	Uid_t	uid = (Uid_t)SvNV(ST(0))
;
	SysRet	RETVAL;

	RETVAL = setuid(uid);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_sysconf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_sysconf)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	int	name = (int)SvIV(ST(0))
;
	SysRetLong	RETVAL;

	RETVAL = sysconf(name);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_ttyname); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_ttyname)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "fd");
    {
	POSIX__Fd	fd;
	char *	RETVAL;
	dXSTARG;

	if ((fd = (int)SvIV(ST(0))) < 0) {
	     SETERRNO(EBADF, RMS_IFI);
	     XSRETURN_IV(-1);
	}
;

	RETVAL = ttyname(fd);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_POSIX_getcwd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_getcwd)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 3890 "POSIX.xs"
      {
	dXSTARG;
	getcwd_sv(TARG);
	XSprePUSH; PUSHTARG;
      }
#line 5633 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_POSIX_lchown); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_POSIX_lchown)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "uid, gid, path");
    {
	Uid_t	uid = (Uid_t)SvNV(ST(0))
;
	Gid_t	gid = (Gid_t)SvNV(ST(1))
;
	char *	path = (char *)SvPV_nolen(ST(2))
;
	SysRet	RETVAL;
#line 3902 "POSIX.xs"
#ifdef HAS_LCHOWN
       /* yes, the order of arguments is different,
        * but consistent with CORE::chown() */
       RETVAL = lchown(path, uid, gid);
#else
       PERL_UNUSED_VAR(uid);
       PERL_UNUSED_VAR(gid);
       PERL_UNUSED_VAR(path);
       RETVAL = not_here("lchown");
#endif
#line 5665 "POSIX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_POSIX); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_POSIX)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("POSIX::SigSet::new", XS_POSIX__SigSet_new);
        cv = newXS_deffile("POSIX::SigSet::addset", XS_POSIX__SigSet_addset);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::SigSet::delset", XS_POSIX__SigSet_addset);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("POSIX::SigSet::emptyset", XS_POSIX__SigSet_emptyset);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::SigSet::fillset", XS_POSIX__SigSet_emptyset);
        XSANY.any_i32 = 1;
        newXS_deffile("POSIX::SigSet::ismember", XS_POSIX__SigSet_ismember);
        newXS_deffile("POSIX::Termios::new", XS_POSIX__Termios_new);
        newXS_deffile("POSIX::Termios::getattr", XS_POSIX__Termios_getattr);
        newXS_deffile("POSIX::Termios::setattr", XS_POSIX__Termios_setattr);
        cv = newXS_deffile("POSIX::Termios::getispeed", XS_POSIX__Termios_getispeed);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::Termios::getospeed", XS_POSIX__Termios_getispeed);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("POSIX::Termios::getcflag", XS_POSIX__Termios_getiflag);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("POSIX::Termios::getiflag", XS_POSIX__Termios_getiflag);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::Termios::getlflag", XS_POSIX__Termios_getiflag);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("POSIX::Termios::getoflag", XS_POSIX__Termios_getiflag);
        XSANY.any_i32 = 1;
        newXS_deffile("POSIX::Termios::getcc", XS_POSIX__Termios_getcc);
        cv = newXS_deffile("POSIX::Termios::setispeed", XS_POSIX__Termios_setispeed);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::Termios::setospeed", XS_POSIX__Termios_setispeed);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("POSIX::Termios::setcflag", XS_POSIX__Termios_setiflag);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("POSIX::Termios::setiflag", XS_POSIX__Termios_setiflag);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::Termios::setlflag", XS_POSIX__Termios_setiflag);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("POSIX::Termios::setoflag", XS_POSIX__Termios_setiflag);
        XSANY.any_i32 = 1;
        newXS_deffile("POSIX::Termios::setcc", XS_POSIX__Termios_setcc);
        newXS_deffile("POSIX::constant", XS_POSIX_constant);
        cv = newXS_deffile("POSIX::WEXITSTATUS", XS_POSIX_WEXITSTATUS);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::WIFEXITED", XS_POSIX_WEXITSTATUS);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("POSIX::WIFSIGNALED", XS_POSIX_WEXITSTATUS);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("POSIX::WIFSTOPPED", XS_POSIX_WEXITSTATUS);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("POSIX::WSTOPSIG", XS_POSIX_WEXITSTATUS);
        XSANY.any_i32 = 4;
        cv = newXS_deffile("POSIX::WTERMSIG", XS_POSIX_WEXITSTATUS);
        XSANY.any_i32 = 5;
        newXS_deffile("POSIX::open", XS_POSIX_open);
        newXS_deffile("POSIX::localeconv", XS_POSIX_localeconv);
        newXS_deffile("POSIX::setlocale", XS_POSIX_setlocale);
        cv = newXS_deffile("POSIX::acos", XS_POSIX_acos);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::acosh", XS_POSIX_acos);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("POSIX::asin", XS_POSIX_acos);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("POSIX::asinh", XS_POSIX_acos);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("POSIX::atan", XS_POSIX_acos);
        XSANY.any_i32 = 4;
        cv = newXS_deffile("POSIX::atanh", XS_POSIX_acos);
        XSANY.any_i32 = 5;
        cv = newXS_deffile("POSIX::cbrt", XS_POSIX_acos);
        XSANY.any_i32 = 6;
        cv = newXS_deffile("POSIX::ceil", XS_POSIX_acos);
        XSANY.any_i32 = 7;
        cv = newXS_deffile("POSIX::cosh", XS_POSIX_acos);
        XSANY.any_i32 = 8;
        cv = newXS_deffile("POSIX::erf", XS_POSIX_acos);
        XSANY.any_i32 = 9;
        cv = newXS_deffile("POSIX::erfc", XS_POSIX_acos);
        XSANY.any_i32 = 10;
        cv = newXS_deffile("POSIX::exp2", XS_POSIX_acos);
        XSANY.any_i32 = 11;
        cv = newXS_deffile("POSIX::expm1", XS_POSIX_acos);
        XSANY.any_i32 = 12;
        cv = newXS_deffile("POSIX::floor", XS_POSIX_acos);
        XSANY.any_i32 = 13;
        cv = newXS_deffile("POSIX::j0", XS_POSIX_acos);
        XSANY.any_i32 = 14;
        cv = newXS_deffile("POSIX::j1", XS_POSIX_acos);
        XSANY.any_i32 = 15;
        cv = newXS_deffile("POSIX::lgamma", XS_POSIX_acos);
        XSANY.any_i32 = 16;
        cv = newXS_deffile("POSIX::log10", XS_POSIX_acos);
        XSANY.any_i32 = 17;
        cv = newXS_deffile("POSIX::log1p", XS_POSIX_acos);
        XSANY.any_i32 = 18;
        cv = newXS_deffile("POSIX::log2", XS_POSIX_acos);
        XSANY.any_i32 = 19;
        cv = newXS_deffile("POSIX::logb", XS_POSIX_acos);
        XSANY.any_i32 = 20;
        cv = newXS_deffile("POSIX::nearbyint", XS_POSIX_acos);
        XSANY.any_i32 = 21;
        cv = newXS_deffile("POSIX::rint", XS_POSIX_acos);
        XSANY.any_i32 = 22;
        cv = newXS_deffile("POSIX::round", XS_POSIX_acos);
        XSANY.any_i32 = 23;
        cv = newXS_deffile("POSIX::sinh", XS_POSIX_acos);
        XSANY.any_i32 = 24;
        cv = newXS_deffile("POSIX::tan", XS_POSIX_acos);
        XSANY.any_i32 = 25;
        cv = newXS_deffile("POSIX::tanh", XS_POSIX_acos);
        XSANY.any_i32 = 26;
        cv = newXS_deffile("POSIX::tgamma", XS_POSIX_acos);
        XSANY.any_i32 = 27;
        cv = newXS_deffile("POSIX::trunc", XS_POSIX_acos);
        XSANY.any_i32 = 28;
        cv = newXS_deffile("POSIX::y0", XS_POSIX_acos);
        XSANY.any_i32 = 29;
        cv = newXS_deffile("POSIX::y1", XS_POSIX_acos);
        XSANY.any_i32 = 30;
        newXS_deffile("POSIX::fegetround", XS_POSIX_fegetround);
        newXS_deffile("POSIX::fesetround", XS_POSIX_fesetround);
        cv = newXS_deffile("POSIX::fpclassify", XS_POSIX_fpclassify);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::ilogb", XS_POSIX_fpclassify);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("POSIX::isfinite", XS_POSIX_fpclassify);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("POSIX::isinf", XS_POSIX_fpclassify);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("POSIX::isnan", XS_POSIX_fpclassify);
        XSANY.any_i32 = 4;
        cv = newXS_deffile("POSIX::isnormal", XS_POSIX_fpclassify);
        XSANY.any_i32 = 5;
        cv = newXS_deffile("POSIX::lrint", XS_POSIX_fpclassify);
        XSANY.any_i32 = 6;
        cv = newXS_deffile("POSIX::lround", XS_POSIX_fpclassify);
        XSANY.any_i32 = 7;
        cv = newXS_deffile("POSIX::signbit", XS_POSIX_fpclassify);
        XSANY.any_i32 = 8;
        newXS_deffile("POSIX::getpayload", XS_POSIX_getpayload);
        newXS_deffile("POSIX::setpayload", XS_POSIX_setpayload);
        newXS_deffile("POSIX::setpayloadsig", XS_POSIX_setpayloadsig);
        newXS_deffile("POSIX::issignaling", XS_POSIX_issignaling);
        cv = newXS_deffile("POSIX::copysign", XS_POSIX_copysign);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::fdim", XS_POSIX_copysign);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("POSIX::fmax", XS_POSIX_copysign);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("POSIX::fmin", XS_POSIX_copysign);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("POSIX::fmod", XS_POSIX_copysign);
        XSANY.any_i32 = 4;
        cv = newXS_deffile("POSIX::hypot", XS_POSIX_copysign);
        XSANY.any_i32 = 5;
        cv = newXS_deffile("POSIX::isgreater", XS_POSIX_copysign);
        XSANY.any_i32 = 6;
        cv = newXS_deffile("POSIX::isgreaterequal", XS_POSIX_copysign);
        XSANY.any_i32 = 7;
        cv = newXS_deffile("POSIX::isless", XS_POSIX_copysign);
        XSANY.any_i32 = 8;
        cv = newXS_deffile("POSIX::islessequal", XS_POSIX_copysign);
        XSANY.any_i32 = 9;
        cv = newXS_deffile("POSIX::islessgreater", XS_POSIX_copysign);
        XSANY.any_i32 = 10;
        cv = newXS_deffile("POSIX::isunordered", XS_POSIX_copysign);
        XSANY.any_i32 = 11;
        cv = newXS_deffile("POSIX::nextafter", XS_POSIX_copysign);
        XSANY.any_i32 = 12;
        cv = newXS_deffile("POSIX::nexttoward", XS_POSIX_copysign);
        XSANY.any_i32 = 13;
        cv = newXS_deffile("POSIX::remainder", XS_POSIX_copysign);
        XSANY.any_i32 = 14;
        newXS_deffile("POSIX::frexp", XS_POSIX_frexp);
        newXS_deffile("POSIX::ldexp", XS_POSIX_ldexp);
        newXS_deffile("POSIX::modf", XS_POSIX_modf);
        newXS_deffile("POSIX::remquo", XS_POSIX_remquo);
        newXS_deffile("POSIX::scalbn", XS_POSIX_scalbn);
        newXS_deffile("POSIX::fma", XS_POSIX_fma);
        newXS_deffile("POSIX::nan", XS_POSIX_nan);
        cv = newXS_deffile("POSIX::jn", XS_POSIX_jn);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::yn", XS_POSIX_jn);
        XSANY.any_i32 = 1;
        newXS_deffile("POSIX::sigaction", XS_POSIX_sigaction);
        cv = newXS_deffile("POSIX::sigpending", XS_POSIX_sigpending);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::sigsuspend", XS_POSIX_sigpending);
        XSANY.any_i32 = 1;
        newXS_deffile("POSIX::sigprocmask", XS_POSIX_sigprocmask);
        newXS_deffile("POSIX::_exit", XS_POSIX__exit);
        newXS_deffile("POSIX::dup2", XS_POSIX_dup2);
        newXS_deffile("POSIX::lseek", XS_POSIX_lseek);
        newXS_deffile("POSIX::nice", XS_POSIX_nice);
        newXS_deffile("POSIX::pipe", XS_POSIX_pipe);
        newXS_deffile("POSIX::read", XS_POSIX_read);
        newXS_deffile("POSIX::setpgid", XS_POSIX_setpgid);
        newXS_deffile("POSIX::setsid", XS_POSIX_setsid);
        newXS_deffile("POSIX::tcgetpgrp", XS_POSIX_tcgetpgrp);
        newXS_deffile("POSIX::tcsetpgrp", XS_POSIX_tcsetpgrp);
        newXS_deffile("POSIX::uname", XS_POSIX_uname);
        newXS_deffile("POSIX::write", XS_POSIX_write);
        newXS_deffile("POSIX::abort", XS_POSIX_abort);
        newXS_deffile("POSIX::mblen", XS_POSIX_mblen);
        newXS_deffile("POSIX::mbtowc", XS_POSIX_mbtowc);
        newXS_deffile("POSIX::wctomb", XS_POSIX_wctomb);
        newXS_deffile("POSIX::strcoll", XS_POSIX_strcoll);
        newXS_deffile("POSIX::strtod", XS_POSIX_strtod);
#if XSubPPtmpAAAA
        newXS_deffile("POSIX::strtold", XS_POSIX_strtold);
#endif
        newXS_deffile("POSIX::strtol", XS_POSIX_strtol);
        newXS_deffile("POSIX::strtoul", XS_POSIX_strtoul);
        newXS_deffile("POSIX::strxfrm", XS_POSIX_strxfrm);
        cv = newXS_deffile("POSIX::access", XS_POSIX_mkfifo);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("POSIX::mkfifo", XS_POSIX_mkfifo);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::close", XS_POSIX_tcdrain);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("POSIX::dup", XS_POSIX_tcdrain);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("POSIX::tcdrain", XS_POSIX_tcdrain);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::tcflow", XS_POSIX_tcflow);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::tcflush", XS_POSIX_tcflow);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("POSIX::tcsendbreak", XS_POSIX_tcflow);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("POSIX::asctime", XS_POSIX_asctime);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("POSIX::mktime", XS_POSIX_asctime);
        XSANY.any_i32 = 1;
        newXS_deffile("POSIX::clock", XS_POSIX_clock);
        newXS_deffile("POSIX::ctime", XS_POSIX_ctime);
        newXS_deffile("POSIX::times", XS_POSIX_times);
        newXS_deffile("POSIX::difftime", XS_POSIX_difftime);
        newXS_deffile("POSIX::strftime", XS_POSIX_strftime);
        newXS_deffile("POSIX::tzset", XS_POSIX_tzset);
        newXS_deffile("POSIX::tzname", XS_POSIX_tzname);
        newXS_deffile("POSIX::ctermid", XS_POSIX_ctermid);
        newXS_deffile("POSIX::cuserid", XS_POSIX_cuserid);
        newXS_deffile("POSIX::fpathconf", XS_POSIX_fpathconf);
        newXS_deffile("POSIX::pathconf", XS_POSIX_pathconf);
        newXS_deffile("POSIX::pause", XS_POSIX_pause);
        newXS_deffile("POSIX::sleep", XS_POSIX_sleep);
        newXS_deffile("POSIX::setgid", XS_POSIX_setgid);
        newXS_deffile("POSIX::setuid", XS_POSIX_setuid);
        newXS_deffile("POSIX::sysconf", XS_POSIX_sysconf);
        newXS_deffile("POSIX::ttyname", XS_POSIX_ttyname);
        newXS_deffile("POSIX::getcwd", XS_POSIX_getcwd);
        newXS_deffile("POSIX::lchown", XS_POSIX_lchown);

    /* Initialisation Section */

#line 2 "./const-xs.inc"
  {
#if defined(dTHX) && !defined(PERL_NO_GET_CONTEXT)
    dTHX;
#endif
    HV *symbol_table = get_hv("POSIX::", GV_ADD);

    static const struct iv_s values_for_iv[] =
      {
#ifdef ARG_MAX
        { "ARG_MAX", 7, ARG_MAX },
#endif
#ifdef B0
        { "B0", 2, B0 },
#endif
#ifdef B110
        { "B110", 4, B110 },
#endif
#ifdef B1200
        { "B1200", 5, B1200 },
#endif
#ifdef B134
        { "B134", 4, B134 },
#endif
#ifdef B150
        { "B150", 4, B150 },
#endif
#ifdef B1800
        { "B1800", 5, B1800 },
#endif
#ifdef B19200
        { "B19200", 6, B19200 },
#endif
#ifdef B200
        { "B200", 4, B200 },
#endif
#ifdef B2400
        { "B2400", 5, B2400 },
#endif
#ifdef B300
        { "B300", 4, B300 },
#endif
#ifdef B38400
        { "B38400", 6, B38400 },
#endif
#ifdef B4800
        { "B4800", 5, B4800 },
#endif
#ifdef B50
        { "B50", 3, B50 },
#endif
#ifdef B600
        { "B600", 4, B600 },
#endif
#ifdef B75
        { "B75", 3, B75 },
#endif
#ifdef B9600
        { "B9600", 5, B9600 },
#endif
#ifdef BRKINT
        { "BRKINT", 6, BRKINT },
#endif
#ifdef BUFSIZ
        { "BUFSIZ", 6, BUFSIZ },
#endif
#ifdef CHAR_BIT
        { "CHAR_BIT", 8, CHAR_BIT },
#endif
#ifdef CHAR_MAX
        { "CHAR_MAX", 8, CHAR_MAX },
#endif
#ifdef CHAR_MIN
        { "CHAR_MIN", 8, CHAR_MIN },
#endif
#ifdef CHILD_MAX
        { "CHILD_MAX", 9, CHILD_MAX },
#endif
#ifdef CLOCAL
        { "CLOCAL", 6, CLOCAL },
#endif
#ifdef CLOCKS_PER_SEC
        { "CLOCKS_PER_SEC", 14, CLOCKS_PER_SEC },
#endif
#ifdef CREAD
        { "CREAD", 5, CREAD },
#endif
#ifdef CS5
        { "CS5", 3, CS5 },
#endif
#ifdef CS6
        { "CS6", 3, CS6 },
#endif
#ifdef CS7
        { "CS7", 3, CS7 },
#endif
#ifdef CS8
        { "CS8", 3, CS8 },
#endif
#ifdef CSIZE
        { "CSIZE", 5, CSIZE },
#endif
#ifdef CSTOPB
        { "CSTOPB", 6, CSTOPB },
#endif
#ifdef E2BIG
        { "E2BIG", 5, E2BIG },
#endif
#ifdef EACCES
        { "EACCES", 6, EACCES },
#endif
#ifdef EADDRINUSE
        { "EADDRINUSE", 10, EADDRINUSE },
#endif
#ifdef EADDRNOTAVAIL
        { "EADDRNOTAVAIL", 13, EADDRNOTAVAIL },
#endif
#ifdef EAFNOSUPPORT
        { "EAFNOSUPPORT", 12, EAFNOSUPPORT },
#endif
#ifdef EAGAIN
        { "EAGAIN", 6, EAGAIN },
#endif
#ifdef EALREADY
        { "EALREADY", 8, EALREADY },
#endif
#ifdef EBADF
        { "EBADF", 5, EBADF },
#endif
#ifdef EBADMSG
        { "EBADMSG", 7, EBADMSG },
#endif
#ifdef EBUSY
        { "EBUSY", 5, EBUSY },
#endif
#ifdef ECANCELED
        { "ECANCELED", 9, ECANCELED },
#endif
#ifdef ECHILD
        { "ECHILD", 6, ECHILD },
#endif
#ifdef ECHO
        { "ECHO", 4, ECHO },
#endif
#ifdef ECHOE
        { "ECHOE", 5, ECHOE },
#endif
#ifdef ECHOK
        { "ECHOK", 5, ECHOK },
#endif
#ifdef ECHONL
        { "ECHONL", 6, ECHONL },
#endif
#ifdef ECONNABORTED
        { "ECONNABORTED", 12, ECONNABORTED },
#endif
#ifdef ECONNREFUSED
        { "ECONNREFUSED", 12, ECONNREFUSED },
#endif
#ifdef ECONNRESET
        { "ECONNRESET", 10, ECONNRESET },
#endif
#ifdef EDEADLK
        { "EDEADLK", 7, EDEADLK },
#endif
#ifdef EDESTADDRREQ
        { "EDESTADDRREQ", 12, EDESTADDRREQ },
#endif
#ifdef EDOM
        { "EDOM", 4, EDOM },
#endif
#ifdef EDQUOT
        { "EDQUOT", 6, EDQUOT },
#endif
#ifdef EEXIST
        { "EEXIST", 6, EEXIST },
#endif
#ifdef EFAULT
        { "EFAULT", 6, EFAULT },
#endif
#ifdef EFBIG
        { "EFBIG", 5, EFBIG },
#endif
#ifdef EHOSTDOWN
        { "EHOSTDOWN", 9, EHOSTDOWN },
#endif
#ifdef EHOSTUNREACH
        { "EHOSTUNREACH", 12, EHOSTUNREACH },
#endif
#ifdef EIDRM
        { "EIDRM", 5, EIDRM },
#endif
#ifdef EILSEQ
        { "EILSEQ", 6, EILSEQ },
#endif
#ifdef EINPROGRESS
        { "EINPROGRESS", 11, EINPROGRESS },
#endif
#ifdef EINTR
        { "EINTR", 5, EINTR },
#endif
#ifdef EINVAL
        { "EINVAL", 6, EINVAL },
#endif
#ifdef EIO
        { "EIO", 3, EIO },
#endif
#ifdef EISCONN
        { "EISCONN", 7, EISCONN },
#endif
#ifdef EISDIR
        { "EISDIR", 6, EISDIR },
#endif
#ifdef ELOOP
        { "ELOOP", 5, ELOOP },
#endif
#ifdef EMFILE
        { "EMFILE", 6, EMFILE },
#endif
#ifdef EMLINK
        { "EMLINK", 6, EMLINK },
#endif
#ifdef EMSGSIZE
        { "EMSGSIZE", 8, EMSGSIZE },
#endif
#ifdef ENAMETOOLONG
        { "ENAMETOOLONG", 12, ENAMETOOLONG },
#endif
#ifdef ENETDOWN
        { "ENETDOWN", 8, ENETDOWN },
#endif
#ifdef ENETRESET
        { "ENETRESET", 9, ENETRESET },
#endif
#ifdef ENETUNREACH
        { "ENETUNREACH", 11, ENETUNREACH },
#endif
#ifdef ENFILE
        { "ENFILE", 6, ENFILE },
#endif
#ifdef ENOBUFS
        { "ENOBUFS", 7, ENOBUFS },
#endif
#ifdef ENODATA
        { "ENODATA", 7, ENODATA },
#endif
#ifdef ENODEV
        { "ENODEV", 6, ENODEV },
#endif
#ifdef ENOENT
        { "ENOENT", 6, ENOENT },
#endif
#ifdef ENOEXEC
        { "ENOEXEC", 7, ENOEXEC },
#endif
#ifdef ENOLCK
        { "ENOLCK", 6, ENOLCK },
#endif
#ifdef ENOLINK
        { "ENOLINK", 7, ENOLINK },
#endif
#ifdef ENOMEM
        { "ENOMEM", 6, ENOMEM },
#endif
#ifdef ENOMSG
        { "ENOMSG", 6, ENOMSG },
#endif
#ifdef ENOPROTOOPT
        { "ENOPROTOOPT", 11, ENOPROTOOPT },
#endif
#ifdef ENOSPC
        { "ENOSPC", 6, ENOSPC },
#endif
#ifdef ENOSR
        { "ENOSR", 5, ENOSR },
#endif
#ifdef ENOSTR
        { "ENOSTR", 6, ENOSTR },
#endif
#ifdef ENOSYS
        { "ENOSYS", 6, ENOSYS },
#endif
#ifdef ENOTBLK
        { "ENOTBLK", 7, ENOTBLK },
#endif
#ifdef ENOTCONN
        { "ENOTCONN", 8, ENOTCONN },
#endif
#ifdef ENOTDIR
        { "ENOTDIR", 7, ENOTDIR },
#endif
#ifdef ENOTEMPTY
        { "ENOTEMPTY", 9, ENOTEMPTY },
#endif
#ifdef ENOTRECOVERABLE
        { "ENOTRECOVERABLE", 15, ENOTRECOVERABLE },
#endif
#ifdef ENOTSOCK
        { "ENOTSOCK", 8, ENOTSOCK },
#endif
#ifdef ENOTSUP
        { "ENOTSUP", 7, ENOTSUP },
#endif
#ifdef ENOTTY
        { "ENOTTY", 6, ENOTTY },
#endif
#ifdef ENXIO
        { "ENXIO", 5, ENXIO },
#endif
#ifdef EOF
        { "EOF", 3, EOF },
#endif
#ifdef EOPNOTSUPP
        { "EOPNOTSUPP", 10, EOPNOTSUPP },
#endif
#ifdef EOTHER
        { "EOTHER", 6, EOTHER },
#endif
#ifdef EOVERFLOW
        { "EOVERFLOW", 9, EOVERFLOW },
#endif
#ifdef EOWNERDEAD
        { "EOWNERDEAD", 10, EOWNERDEAD },
#endif
#ifdef EPERM
        { "EPERM", 5, EPERM },
#endif
#ifdef EPFNOSUPPORT
        { "EPFNOSUPPORT", 12, EPFNOSUPPORT },
#endif
#ifdef EPIPE
        { "EPIPE", 5, EPIPE },
#endif
#ifdef EPROCLIM
        { "EPROCLIM", 8, EPROCLIM },
#endif
#ifdef EPROTO
        { "EPROTO", 6, EPROTO },
#endif
#ifdef EPROTONOSUPPORT
        { "EPROTONOSUPPORT", 15, EPROTONOSUPPORT },
#endif
#ifdef EPROTOTYPE
        { "EPROTOTYPE", 10, EPROTOTYPE },
#endif
#ifdef ERANGE
        { "ERANGE", 6, ERANGE },
#endif
#ifdef EREMOTE
        { "EREMOTE", 7, EREMOTE },
#endif
#ifdef ERESTART
        { "ERESTART", 8, ERESTART },
#endif
#ifdef EROFS
        { "EROFS", 5, EROFS },
#endif
#ifdef ESHUTDOWN
        { "ESHUTDOWN", 9, ESHUTDOWN },
#endif
#ifdef ESOCKTNOSUPPORT
        { "ESOCKTNOSUPPORT", 15, ESOCKTNOSUPPORT },
#endif
#ifdef ESPIPE
        { "ESPIPE", 6, ESPIPE },
#endif
#ifdef ESRCH
        { "ESRCH", 5, ESRCH },
#endif
#ifdef ESTALE
        { "ESTALE", 6, ESTALE },
#endif
#ifdef ETIME
        { "ETIME", 5, ETIME },
#endif
#ifdef ETIMEDOUT
        { "ETIMEDOUT", 9, ETIMEDOUT },
#endif
#ifdef ETOOMANYREFS
        { "ETOOMANYREFS", 12, ETOOMANYREFS },
#endif
#ifdef ETXTBSY
        { "ETXTBSY", 7, ETXTBSY },
#endif
#ifdef EUSERS
        { "EUSERS", 6, EUSERS },
#endif
#ifdef EWOULDBLOCK
        { "EWOULDBLOCK", 11, EWOULDBLOCK },
#endif
#ifdef EXDEV
        { "EXDEV", 5, EXDEV },
#endif
#ifdef FILENAME_MAX
        { "FILENAME_MAX", 12, FILENAME_MAX },
#endif
#ifdef F_OK
        { "F_OK", 4, F_OK },
#endif
#ifdef HUPCL
        { "HUPCL", 5, HUPCL },
#endif
#ifdef ICANON
        { "ICANON", 6, ICANON },
#endif
#ifdef ICRNL
        { "ICRNL", 5, ICRNL },
#endif
#ifdef IEXTEN
        { "IEXTEN", 6, IEXTEN },
#endif
#ifdef IGNBRK
        { "IGNBRK", 6, IGNBRK },
#endif
#ifdef IGNCR
        { "IGNCR", 5, IGNCR },
#endif
#ifdef IGNPAR
        { "IGNPAR", 6, IGNPAR },
#endif
#ifdef INLCR
        { "INLCR", 5, INLCR },
#endif
#ifdef INPCK
        { "INPCK", 5, INPCK },
#endif
#ifdef INT_MAX
        { "INT_MAX", 7, INT_MAX },
#endif
#ifdef INT_MIN
        { "INT_MIN", 7, INT_MIN },
#endif
#ifdef ISIG
        { "ISIG", 4, ISIG },
#endif
#ifdef ISTRIP
        { "ISTRIP", 6, ISTRIP },
#endif
#ifdef IXOFF
        { "IXOFF", 5, IXOFF },
#endif
#ifdef IXON
        { "IXON", 4, IXON },
#endif
#ifdef LC_ADDRESS
        { "LC_ADDRESS", 10, LC_ADDRESS },
#endif
#ifdef LC_ALL
        { "LC_ALL", 6, LC_ALL },
#endif
#ifdef LC_COLLATE
        { "LC_COLLATE", 10, LC_COLLATE },
#endif
#ifdef LC_CTYPE
        { "LC_CTYPE", 8, LC_CTYPE },
#endif
#ifdef LC_IDENTIFICATION
        { "LC_IDENTIFICATION", 17, LC_IDENTIFICATION },
#endif
#ifdef LC_MEASUREMENT
        { "LC_MEASUREMENT", 14, LC_MEASUREMENT },
#endif
#ifdef LC_MESSAGES
        { "LC_MESSAGES", 11, LC_MESSAGES },
#endif
#ifdef LC_MONETARY
        { "LC_MONETARY", 11, LC_MONETARY },
#endif
#ifdef LC_NUMERIC
        { "LC_NUMERIC", 10, LC_NUMERIC },
#endif
#ifdef LC_PAPER
        { "LC_PAPER", 8, LC_PAPER },
#endif
#ifdef LC_TELEPHONE
        { "LC_TELEPHONE", 12, LC_TELEPHONE },
#endif
#ifdef LC_TIME
        { "LC_TIME", 7, LC_TIME },
#endif
#ifdef LINK_MAX
        { "LINK_MAX", 8, LINK_MAX },
#endif
#ifdef LONG_MAX
        { "LONG_MAX", 8, LONG_MAX },
#endif
#ifdef LONG_MIN
        { "LONG_MIN", 8, LONG_MIN },
#endif
#ifdef L_ctermid
        { "L_ctermid", 9, L_ctermid },
#endif
#ifdef L_cuserid
        { "L_cuserid", 9, L_cuserid },
#endif
#ifdef MAX_CANON
        { "MAX_CANON", 9, MAX_CANON },
#endif
#ifdef MAX_INPUT
        { "MAX_INPUT", 9, MAX_INPUT },
#endif
#ifdef MB_LEN_MAX
        { "MB_LEN_MAX", 10, MB_LEN_MAX },
#endif
#ifdef MSG_CTRUNC
        { "MSG_CTRUNC", 10, MSG_CTRUNC },
#endif
#ifdef MSG_DONTROUTE
        { "MSG_DONTROUTE", 13, MSG_DONTROUTE },
#endif
#ifdef MSG_EOR
        { "MSG_EOR", 7, MSG_EOR },
#endif
#ifdef MSG_OOB
        { "MSG_OOB", 7, MSG_OOB },
#endif
#ifdef MSG_PEEK
        { "MSG_PEEK", 8, MSG_PEEK },
#endif
#ifdef MSG_TRUNC
        { "MSG_TRUNC", 9, MSG_TRUNC },
#endif
#ifdef MSG_WAITALL
        { "MSG_WAITALL", 11, MSG_WAITALL },
#endif
#ifdef NAME_MAX
        { "NAME_MAX", 8, NAME_MAX },
#endif
#ifdef NCCS
        { "NCCS", 4, NCCS },
#endif
#ifdef NGROUPS_MAX
        { "NGROUPS_MAX", 11, NGROUPS_MAX },
#endif
#ifdef NOFLSH
        { "NOFLSH", 6, NOFLSH },
#endif
#ifdef OPEN_MAX
        { "OPEN_MAX", 8, OPEN_MAX },
#endif
#ifdef OPOST
        { "OPOST", 5, OPOST },
#endif
#ifdef PARENB
        { "PARENB", 6, PARENB },
#endif
#ifdef PARMRK
        { "PARMRK", 6, PARMRK },
#endif
#ifdef PARODD
        { "PARODD", 6, PARODD },
#endif
#ifdef PATH_MAX
        { "PATH_MAX", 8, PATH_MAX },
#endif
#ifdef PIPE_BUF
        { "PIPE_BUF", 8, PIPE_BUF },
#endif
#ifdef RAND_MAX
        { "RAND_MAX", 8, RAND_MAX },
#endif
#ifdef R_OK
        { "R_OK", 4, R_OK },
#endif
#ifdef SCHAR_MAX
        { "SCHAR_MAX", 9, SCHAR_MAX },
#endif
#ifdef SCHAR_MIN
        { "SCHAR_MIN", 9, SCHAR_MIN },
#endif
#ifdef SHRT_MAX
        { "SHRT_MAX", 8, SHRT_MAX },
#endif
#ifdef SHRT_MIN
        { "SHRT_MIN", 8, SHRT_MIN },
#endif
#ifdef SIGABRT
        { "SIGABRT", 7, SIGABRT },
#endif
#ifdef SIGALRM
        { "SIGALRM", 7, SIGALRM },
#endif
#ifdef SIGCHLD
        { "SIGCHLD", 7, SIGCHLD },
#endif
#ifdef SIGCONT
        { "SIGCONT", 7, SIGCONT },
#endif
#ifdef SIGFPE
        { "SIGFPE", 6, SIGFPE },
#endif
#ifdef SIGHUP
        { "SIGHUP", 6, SIGHUP },
#endif
#ifdef SIGILL
        { "SIGILL", 6, SIGILL },
#endif
#ifdef SIGINT
        { "SIGINT", 6, SIGINT },
#endif
#ifdef SIGKILL
        { "SIGKILL", 7, SIGKILL },
#endif
#ifdef SIGPIPE
        { "SIGPIPE", 7, SIGPIPE },
#endif
#ifdef SIGQUIT
        { "SIGQUIT", 7, SIGQUIT },
#endif
#ifdef SIGSEGV
        { "SIGSEGV", 7, SIGSEGV },
#endif
#ifdef SIGSTOP
        { "SIGSTOP", 7, SIGSTOP },
#endif
#ifdef SIGTERM
        { "SIGTERM", 7, SIGTERM },
#endif
#ifdef SIGTSTP
        { "SIGTSTP", 7, SIGTSTP },
#endif
#ifdef SIGTTIN
        { "SIGTTIN", 7, SIGTTIN },
#endif
#ifdef SIGTTOU
        { "SIGTTOU", 7, SIGTTOU },
#endif
#ifdef SIGUSR1
        { "SIGUSR1", 7, SIGUSR1 },
#endif
#ifdef SIGUSR2
        { "SIGUSR2", 7, SIGUSR2 },
#endif
#ifdef SIG_BLOCK
        { "SIG_BLOCK", 9, SIG_BLOCK },
#endif
#ifdef SIG_SETMASK
        { "SIG_SETMASK", 11, SIG_SETMASK },
#endif
#ifdef SIG_UNBLOCK
        { "SIG_UNBLOCK", 11, SIG_UNBLOCK },
#endif
#ifdef SSIZE_MAX
        { "SSIZE_MAX", 9, SSIZE_MAX },
#endif
#ifdef SIGBUS
        { "SIGBUS", 6, SIGBUS },
#endif
#ifdef SIGPOLL
        { "SIGPOLL", 7, SIGPOLL },
#endif
#ifdef SIGPROF
        { "SIGPROF", 7, SIGPROF },
#endif
#ifdef SIGSYS
        { "SIGSYS", 6, SIGSYS },
#endif
#ifdef SIGTRAP
        { "SIGTRAP", 7, SIGTRAP },
#endif
#ifdef SIGURG
        { "SIGURG", 6, SIGURG },
#endif
#ifdef SIGVTALRM
        { "SIGVTALRM", 9, SIGVTALRM },
#endif
#ifdef SIGXCPU
        { "SIGXCPU", 7, SIGXCPU },
#endif
#ifdef SIGXFSZ
        { "SIGXFSZ", 7, SIGXFSZ },
#endif
#ifdef STDERR_FILENO
        { "STDERR_FILENO", 13, STDERR_FILENO },
#endif
#ifdef STDIN_FILENO
        { "STDIN_FILENO", 12, STDIN_FILENO },
#endif
#ifdef STDOUT_FILENO
        { "STDOUT_FILENO", 13, STDOUT_FILENO },
#endif
#ifdef STREAM_MAX
        { "STREAM_MAX", 10, STREAM_MAX },
#endif
#ifdef TCIFLUSH
        { "TCIFLUSH", 8, TCIFLUSH },
#endif
#ifdef TCIOFF
        { "TCIOFF", 6, TCIOFF },
#endif
#ifdef TCIOFLUSH
        { "TCIOFLUSH", 9, TCIOFLUSH },
#endif
#ifdef TCION
        { "TCION", 5, TCION },
#endif
#ifdef TCOFLUSH
        { "TCOFLUSH", 8, TCOFLUSH },
#endif
#ifdef TCOOFF
        { "TCOOFF", 6, TCOOFF },
#endif
#ifdef TCOON
        { "TCOON", 5, TCOON },
#endif
#ifdef TCSADRAIN
        { "TCSADRAIN", 9, TCSADRAIN },
#endif
#ifdef TCSAFLUSH
        { "TCSAFLUSH", 9, TCSAFLUSH },
#endif
#ifdef TCSANOW
        { "TCSANOW", 7, TCSANOW },
#endif
#ifdef TMP_MAX
        { "TMP_MAX", 7, TMP_MAX },
#endif
#ifdef TOSTOP
        { "TOSTOP", 6, TOSTOP },
#endif
#ifdef TZNAME_MAX
        { "TZNAME_MAX", 10, TZNAME_MAX },
#endif
#ifdef VEOF
        { "VEOF", 4, VEOF },
#endif
#ifdef VEOL
        { "VEOL", 4, VEOL },
#endif
#ifdef VERASE
        { "VERASE", 6, VERASE },
#endif
#ifdef VINTR
        { "VINTR", 5, VINTR },
#endif
#ifdef VKILL
        { "VKILL", 5, VKILL },
#endif
#ifdef VMIN
        { "VMIN", 4, VMIN },
#endif
#ifdef VQUIT
        { "VQUIT", 5, VQUIT },
#endif
#ifdef VSTART
        { "VSTART", 6, VSTART },
#endif
#ifdef VSTOP
        { "VSTOP", 5, VSTOP },
#endif
#ifdef VSUSP
        { "VSUSP", 5, VSUSP },
#endif
#ifdef VTIME
        { "VTIME", 5, VTIME },
#endif
#ifdef WNOHANG
        { "WNOHANG", 7, WNOHANG },
#endif
#ifdef WUNTRACED
        { "WUNTRACED", 9, WUNTRACED },
#endif
#ifdef W_OK
        { "W_OK", 4, W_OK },
#endif
#ifdef X_OK
        { "X_OK", 4, X_OK },
#endif
#ifdef _PC_CHOWN_RESTRICTED
        { "_PC_CHOWN_RESTRICTED", 20, _PC_CHOWN_RESTRICTED },
#endif
#ifdef _PC_LINK_MAX
        { "_PC_LINK_MAX", 12, _PC_LINK_MAX },
#endif
#ifdef _PC_MAX_CANON
        { "_PC_MAX_CANON", 13, _PC_MAX_CANON },
#endif
#ifdef _PC_MAX_INPUT
        { "_PC_MAX_INPUT", 13, _PC_MAX_INPUT },
#endif
#ifdef _PC_NAME_MAX
        { "_PC_NAME_MAX", 12, _PC_NAME_MAX },
#endif
#ifdef _PC_NO_TRUNC
        { "_PC_NO_TRUNC", 12, _PC_NO_TRUNC },
#endif
#ifdef _PC_PATH_MAX
        { "_PC_PATH_MAX", 12, _PC_PATH_MAX },
#endif
#ifdef _PC_PIPE_BUF
        { "_PC_PIPE_BUF", 12, _PC_PIPE_BUF },
#endif
#ifdef _PC_VDISABLE
        { "_PC_VDISABLE", 12, _PC_VDISABLE },
#endif
#ifdef _SC_ARG_MAX
        { "_SC_ARG_MAX", 11, _SC_ARG_MAX },
#endif
#ifdef _SC_CHILD_MAX
        { "_SC_CHILD_MAX", 13, _SC_CHILD_MAX },
#endif
#ifdef _SC_CLK_TCK
        { "_SC_CLK_TCK", 11, _SC_CLK_TCK },
#endif
#ifdef _SC_JOB_CONTROL
        { "_SC_JOB_CONTROL", 15, _SC_JOB_CONTROL },
#endif
#ifdef _SC_NGROUPS_MAX
        { "_SC_NGROUPS_MAX", 15, _SC_NGROUPS_MAX },
#endif
#ifdef _SC_OPEN_MAX
        { "_SC_OPEN_MAX", 12, _SC_OPEN_MAX },
#endif
#ifdef _SC_PAGESIZE
        { "_SC_PAGESIZE", 12, _SC_PAGESIZE },
#endif
#ifdef _SC_SAVED_IDS
        { "_SC_SAVED_IDS", 13, _SC_SAVED_IDS },
#endif
#ifdef _SC_STREAM_MAX
        { "_SC_STREAM_MAX", 14, _SC_STREAM_MAX },
#endif
#ifdef _SC_TZNAME_MAX
        { "_SC_TZNAME_MAX", 14, _SC_TZNAME_MAX },
#endif
#ifdef _SC_VERSION
        { "_SC_VERSION", 11, _SC_VERSION },
#endif
#ifdef EAI_AGAIN
        { "EAI_AGAIN", 9, EAI_AGAIN },
#endif
#ifdef EAI_BADFLAGS
        { "EAI_BADFLAGS", 12, EAI_BADFLAGS },
#endif
#ifdef EAI_FAIL
        { "EAI_FAIL", 8, EAI_FAIL },
#endif
#ifdef EAI_FAMILY
        { "EAI_FAMILY", 10, EAI_FAMILY },
#endif
#ifdef EAI_MEMORY
        { "EAI_MEMORY", 10, EAI_MEMORY },
#endif
#ifdef EAI_NONAME
        { "EAI_NONAME", 10, EAI_NONAME },
#endif
#ifdef EAI_SERVICE
        { "EAI_SERVICE", 11, EAI_SERVICE },
#endif
#ifdef EAI_SOCKTYPE
        { "EAI_SOCKTYPE", 12, EAI_SOCKTYPE },
#endif
#ifdef EAI_SYSTEM
        { "EAI_SYSTEM", 10, EAI_SYSTEM },
#endif
#ifdef EAI_OVERFLOW
        { "EAI_OVERFLOW", 12, EAI_OVERFLOW },
#endif
#ifdef PRIO_PROCESS
        { "PRIO_PROCESS", 12, PRIO_PROCESS },
#endif
#ifdef PRIO_PGRP
        { "PRIO_PGRP", 9, PRIO_PGRP },
#endif
#ifdef PRIO_USER
        { "PRIO_USER", 9, PRIO_USER },
#endif
#ifdef EXIT_FAILURE
        { "EXIT_FAILURE", 12, EXIT_FAILURE },
#endif
#ifdef EXIT_SUCCESS
        { "EXIT_SUCCESS", 12, EXIT_SUCCESS },
#endif
#ifdef NULL
        { "NULL", 4, 0 },
#endif
#ifdef DBL_DIG
        { "DBL_DIG", 7, DBL_DIG },
#endif
#ifdef DBL_MANT_DIG
        { "DBL_MANT_DIG", 12, DBL_MANT_DIG },
#endif
#ifdef DBL_MAX_10_EXP
        { "DBL_MAX_10_EXP", 14, DBL_MAX_10_EXP },
#endif
#ifdef DBL_MAX_EXP
        { "DBL_MAX_EXP", 11, DBL_MAX_EXP },
#endif
#ifdef DBL_MIN_10_EXP
        { "DBL_MIN_10_EXP", 14, DBL_MIN_10_EXP },
#endif
#ifdef DBL_MIN_EXP
        { "DBL_MIN_EXP", 11, DBL_MIN_EXP },
#endif
#ifdef FLT_DIG
        { "FLT_DIG", 7, FLT_DIG },
#endif
#ifdef FLT_MANT_DIG
        { "FLT_MANT_DIG", 12, FLT_MANT_DIG },
#endif
#ifdef FLT_MAX_10_EXP
        { "FLT_MAX_10_EXP", 14, FLT_MAX_10_EXP },
#endif
#ifdef FLT_MAX_EXP
        { "FLT_MAX_EXP", 11, FLT_MAX_EXP },
#endif
#ifdef FLT_MIN_10_EXP
        { "FLT_MIN_10_EXP", 14, FLT_MIN_10_EXP },
#endif
#ifdef FLT_MIN_EXP
        { "FLT_MIN_EXP", 11, FLT_MIN_EXP },
#endif
#ifdef FLT_RADIX
        { "FLT_RADIX", 9, FLT_RADIX },
#endif
#ifdef LDBL_DIG
        { "LDBL_DIG", 8, LDBL_DIG },
#endif
#ifdef LDBL_MANT_DIG
        { "LDBL_MANT_DIG", 13, LDBL_MANT_DIG },
#endif
#ifdef LDBL_MAX_10_EXP
        { "LDBL_MAX_10_EXP", 15, LDBL_MAX_10_EXP },
#endif
#ifdef LDBL_MAX_EXP
        { "LDBL_MAX_EXP", 12, LDBL_MAX_EXP },
#endif
#ifdef LDBL_MIN_10_EXP
        { "LDBL_MIN_10_EXP", 15, LDBL_MIN_10_EXP },
#endif
#ifdef LDBL_MIN_EXP
        { "LDBL_MIN_EXP", 12, LDBL_MIN_EXP },
#endif
#ifdef FP_ILOGB0
        { "FP_ILOGB0", 9, FP_ILOGB0 },
#endif
#ifdef FP_ILOGBNAN
        { "FP_ILOGBNAN", 11, FP_ILOGBNAN },
#endif
#ifdef FP_INFINITE
        { "FP_INFINITE", 11, FP_INFINITE },
#endif
#ifdef FP_NAN
        { "FP_NAN", 6, FP_NAN },
#endif
#ifdef FP_NORMAL
        { "FP_NORMAL", 9, FP_NORMAL },
#endif
#ifdef FP_SUBNORMAL
        { "FP_SUBNORMAL", 12, FP_SUBNORMAL },
#endif
#ifdef FP_ZERO
        { "FP_ZERO", 7, FP_ZERO },
#endif
#ifdef FE_DOWNWARD
        { "FE_DOWNWARD", 11, FE_DOWNWARD },
#endif
#ifdef FE_TONEAREST
        { "FE_TONEAREST", 12, FE_TONEAREST },
#endif
#ifdef FE_TOWARDZERO
        { "FE_TOWARDZERO", 13, FE_TOWARDZERO },
#endif
#ifdef FE_UPWARD
        { "FE_UPWARD", 9, FE_UPWARD },
#endif
#ifdef _POSIX_ARG_MAX
        { "_POSIX_ARG_MAX", 14, _POSIX_ARG_MAX },
#endif
#ifdef _POSIX_CHILD_MAX
        { "_POSIX_CHILD_MAX", 16, _POSIX_CHILD_MAX },
#endif
#ifdef _POSIX_CHOWN_RESTRICTED
        { "_POSIX_CHOWN_RESTRICTED", 23, _POSIX_CHOWN_RESTRICTED },
#endif
#ifdef _POSIX_LINK_MAX
        { "_POSIX_LINK_MAX", 15, _POSIX_LINK_MAX },
#endif
#ifdef _POSIX_MAX_CANON
        { "_POSIX_MAX_CANON", 16, _POSIX_MAX_CANON },
#endif
#ifdef _POSIX_MAX_INPUT
        { "_POSIX_MAX_INPUT", 16, _POSIX_MAX_INPUT },
#endif
#ifdef _POSIX_NAME_MAX
        { "_POSIX_NAME_MAX", 15, _POSIX_NAME_MAX },
#endif
#ifdef _POSIX_NGROUPS_MAX
        { "_POSIX_NGROUPS_MAX", 18, _POSIX_NGROUPS_MAX },
#endif
#ifdef _POSIX_NO_TRUNC
        { "_POSIX_NO_TRUNC", 15, _POSIX_NO_TRUNC },
#endif
#ifdef _POSIX_OPEN_MAX
        { "_POSIX_OPEN_MAX", 15, _POSIX_OPEN_MAX },
#endif
#ifdef _POSIX_PATH_MAX
        { "_POSIX_PATH_MAX", 15, _POSIX_PATH_MAX },
#endif
#ifdef _POSIX_PIPE_BUF
        { "_POSIX_PIPE_BUF", 15, _POSIX_PIPE_BUF },
#endif
#ifdef _POSIX_SSIZE_MAX
        { "_POSIX_SSIZE_MAX", 16, _POSIX_SSIZE_MAX },
#endif
#ifdef _POSIX_STREAM_MAX
        { "_POSIX_STREAM_MAX", 17, _POSIX_STREAM_MAX },
#endif
#ifdef _POSIX_TZNAME_MAX
        { "_POSIX_TZNAME_MAX", 17, _POSIX_TZNAME_MAX },
#endif
#ifdef _POSIX_VDISABLE
        { "_POSIX_VDISABLE", 15, _POSIX_VDISABLE },
#endif
#ifdef _POSIX_VERSION
        { "_POSIX_VERSION", 14, _POSIX_VERSION },
#endif
#ifdef ILL_ILLOPC
        { "ILL_ILLOPC", 10, ILL_ILLOPC },
#endif
#ifdef ILL_ILLOPN
        { "ILL_ILLOPN", 10, ILL_ILLOPN },
#endif
#ifdef ILL_ILLADR
        { "ILL_ILLADR", 10, ILL_ILLADR },
#endif
#ifdef ILL_ILLTRP
        { "ILL_ILLTRP", 10, ILL_ILLTRP },
#endif
#ifdef ILL_PRVOPC
        { "ILL_PRVOPC", 10, ILL_PRVOPC },
#endif
#ifdef ILL_PRVREG
        { "ILL_PRVREG", 10, ILL_PRVREG },
#endif
#ifdef ILL_COPROC
        { "ILL_COPROC", 10, ILL_COPROC },
#endif
#ifdef ILL_BADSTK
        { "ILL_BADSTK", 10, ILL_BADSTK },
#endif
#ifdef FPE_INTDIV
        { "FPE_INTDIV", 10, FPE_INTDIV },
#endif
#ifdef FPE_INTOVF
        { "FPE_INTOVF", 10, FPE_INTOVF },
#endif
#ifdef FPE_FLTDIV
        { "FPE_FLTDIV", 10, FPE_FLTDIV },
#endif
#ifdef FPE_FLTOVF
        { "FPE_FLTOVF", 10, FPE_FLTOVF },
#endif
#ifdef FPE_FLTUND
        { "FPE_FLTUND", 10, FPE_FLTUND },
#endif
#ifdef FPE_FLTRES
        { "FPE_FLTRES", 10, FPE_FLTRES },
#endif
#ifdef FPE_FLTINV
        { "FPE_FLTINV", 10, FPE_FLTINV },
#endif
#ifdef FPE_FLTSUB
        { "FPE_FLTSUB", 10, FPE_FLTSUB },
#endif
#ifdef SEGV_MAPERR
        { "SEGV_MAPERR", 11, SEGV_MAPERR },
#endif
#ifdef SEGV_ACCERR
        { "SEGV_ACCERR", 11, SEGV_ACCERR },
#endif
#ifdef BUS_ADRALN
        { "BUS_ADRALN", 10, BUS_ADRALN },
#endif
#ifdef BUS_ADRERR
        { "BUS_ADRERR", 10, BUS_ADRERR },
#endif
#ifdef BUS_OBJERR
        { "BUS_OBJERR", 10, BUS_OBJERR },
#endif
#ifdef TRAP_BRKPT
        { "TRAP_BRKPT", 10, TRAP_BRKPT },
#endif
#ifdef TRAP_TRACE
        { "TRAP_TRACE", 10, TRAP_TRACE },
#endif
#ifdef CLD_EXITED
        { "CLD_EXITED", 10, CLD_EXITED },
#endif
#ifdef CLD_KILLED
        { "CLD_KILLED", 10, CLD_KILLED },
#endif
#ifdef CLD_DUMPED
        { "CLD_DUMPED", 10, CLD_DUMPED },
#endif
#ifdef CLD_TRAPPED
        { "CLD_TRAPPED", 11, CLD_TRAPPED },
#endif
#ifdef CLD_STOPPED
        { "CLD_STOPPED", 11, CLD_STOPPED },
#endif
#ifdef CLD_CONTINUED
        { "CLD_CONTINUED", 13, CLD_CONTINUED },
#endif
#ifdef POLL_IN
        { "POLL_IN", 7, POLL_IN },
#endif
#ifdef POLL_OUT
        { "POLL_OUT", 8, POLL_OUT },
#endif
#ifdef POLL_MSG
        { "POLL_MSG", 8, POLL_MSG },
#endif
#ifdef POLL_ERR
        { "POLL_ERR", 8, POLL_ERR },
#endif
#ifdef POLL_PRI
        { "POLL_PRI", 8, POLL_PRI },
#endif
#ifdef POLL_HUP
        { "POLL_HUP", 8, POLL_HUP },
#endif
#ifdef SI_USER
        { "SI_USER", 7, SI_USER },
#endif
#ifdef SI_QUEUE
        { "SI_QUEUE", 8, SI_QUEUE },
#endif
#ifdef SI_TIMER
        { "SI_TIMER", 8, SI_TIMER },
#endif
#ifdef SI_ASYNCIO
        { "SI_ASYNCIO", 10, SI_ASYNCIO },
#endif
#ifdef SI_MESGQ
        { "SI_MESGQ", 8, SI_MESGQ },
#endif
#if 0
        { "SIGRTMAX", 8, SIGRTMAX },
#endif
#if 0
        { "SIGRTMIN", 8, SIGRTMIN },
#endif
#ifndef EXIT_FAILURE
        /* This is the default value: */
        { "EXIT_FAILURE", 12, 1 },
#endif
#ifndef EXIT_SUCCESS
        /* This is the default value: */
        { "EXIT_SUCCESS", 12, 0 },
#endif
#ifndef _POSIX_JOB_CONTROL
        /* This is the default value: */
        { "_POSIX_JOB_CONTROL", 18, 0 },
#endif
#ifndef _POSIX_SAVED_IDS
        /* This is the default value: */
        { "_POSIX_SAVED_IDS", 16, 0 },
#endif
#ifndef _POSIX_ARG_MAX
        /* This is the default value: */
        { "_POSIX_ARG_MAX", 14, 0 },
#endif
#ifndef _POSIX_CHILD_MAX
        /* This is the default value: */
        { "_POSIX_CHILD_MAX", 16, 0 },
#endif
#ifndef _POSIX_CHOWN_RESTRICTED
        /* This is the default value: */
        { "_POSIX_CHOWN_RESTRICTED", 23, 0 },
#endif
#ifndef _POSIX_LINK_MAX
        /* This is the default value: */
        { "_POSIX_LINK_MAX", 15, 0 },
#endif
#ifndef _POSIX_MAX_CANON
        /* This is the default value: */
        { "_POSIX_MAX_CANON", 16, 0 },
#endif
#ifndef _POSIX_MAX_INPUT
        /* This is the default value: */
        { "_POSIX_MAX_INPUT", 16, 0 },
#endif
#ifndef _POSIX_NAME_MAX
        /* This is the default value: */
        { "_POSIX_NAME_MAX", 15, 0 },
#endif
#ifndef _POSIX_NGROUPS_MAX
        /* This is the default value: */
        { "_POSIX_NGROUPS_MAX", 18, 0 },
#endif
#ifndef _POSIX_NO_TRUNC
        /* This is the default value: */
        { "_POSIX_NO_TRUNC", 15, 0 },
#endif
#ifndef _POSIX_OPEN_MAX
        /* This is the default value: */
        { "_POSIX_OPEN_MAX", 15, 0 },
#endif
#ifndef _POSIX_PATH_MAX
        /* This is the default value: */
        { "_POSIX_PATH_MAX", 15, 0 },
#endif
#ifndef _POSIX_PIPE_BUF
        /* This is the default value: */
        { "_POSIX_PIPE_BUF", 15, 0 },
#endif
#ifndef _POSIX_SSIZE_MAX
        /* This is the default value: */
        { "_POSIX_SSIZE_MAX", 16, 0 },
#endif
#ifndef _POSIX_STREAM_MAX
        /* This is the default value: */
        { "_POSIX_STREAM_MAX", 17, 0 },
#endif
#ifndef _POSIX_TZNAME_MAX
        /* This is the default value: */
        { "_POSIX_TZNAME_MAX", 17, 0 },
#endif
#ifndef _POSIX_VDISABLE
        /* This is the default value: */
        { "_POSIX_VDISABLE", 15, 0 },
#endif
#ifndef _POSIX_VERSION
        /* This is the default value: */
        { "_POSIX_VERSION", 14, 0 },
#endif
        { NULL, 0, 0 } };
	const struct iv_s *value_for_iv = values_for_iv;

    static const struct nv_s values_for_nv[] =
      {
#ifdef M_1_PI
        { "M_1_PI", 6, M_1_PI },
#endif
#ifdef M_2_PI
        { "M_2_PI", 6, M_2_PI },
#endif
#ifdef M_2_SQRTPI
        { "M_2_SQRTPI", 10, M_2_SQRTPI },
#endif
#ifdef M_E
        { "M_E", 3, M_E },
#endif
#ifdef M_LN10
        { "M_LN10", 6, M_LN10 },
#endif
#ifdef M_LN2
        { "M_LN2", 5, M_LN2 },
#endif
#ifdef M_LOG10E
        { "M_LOG10E", 8, M_LOG10E },
#endif
#ifdef M_LOG2E
        { "M_LOG2E", 7, M_LOG2E },
#endif
#ifdef M_PI
        { "M_PI", 4, M_PI },
#endif
#ifdef M_PI_2
        { "M_PI_2", 6, M_PI_2 },
#endif
#ifdef M_PI_4
        { "M_PI_4", 6, M_PI_4 },
#endif
#ifdef M_SQRT1_2
        { "M_SQRT1_2", 9, M_SQRT1_2 },
#endif
#ifdef M_SQRT2
        { "M_SQRT2", 7, M_SQRT2 },
#endif
        { NULL, 0, 0 } };
	const struct nv_s *value_for_nv = values_for_nv;

    static const struct uv_s values_for_uv[] =
      {
#ifdef SA_NOCLDSTOP
        { "SA_NOCLDSTOP", 12, SA_NOCLDSTOP },
#endif
#ifdef SA_NOCLDWAIT
        { "SA_NOCLDWAIT", 12, SA_NOCLDWAIT },
#endif
#ifdef SA_NODEFER
        { "SA_NODEFER", 10, SA_NODEFER },
#endif
#ifdef SA_ONSTACK
        { "SA_ONSTACK", 10, SA_ONSTACK },
#endif
#ifdef SA_RESETHAND
        { "SA_RESETHAND", 12, SA_RESETHAND },
#endif
#ifdef SA_RESTART
        { "SA_RESTART", 10, SA_RESTART },
#endif
#ifdef SA_SIGINFO
        { "SA_SIGINFO", 10, SA_SIGINFO },
#endif
#ifdef UCHAR_MAX
        { "UCHAR_MAX", 9, UCHAR_MAX },
#endif
#ifdef UINT_MAX
        { "UINT_MAX", 8, UINT_MAX },
#endif
#ifdef ULONG_MAX
        { "ULONG_MAX", 9, ULONG_MAX },
#endif
#ifdef USHRT_MAX
        { "USHRT_MAX", 9, USHRT_MAX },
#endif
        { NULL, 0, 0 } };
	const struct uv_s *value_for_uv = values_for_uv;

    static const struct yes_s values_for_yes[] =
      {
#ifdef _POSIX_JOB_CONTROL
        { "_POSIX_JOB_CONTROL", 18 },
#endif
#ifdef _POSIX_SAVED_IDS
        { "_POSIX_SAVED_IDS", 16 },
#endif
        { NULL, 0 } };
	const struct yes_s *value_for_yes = values_for_yes;
        while (value_for_iv->name) {
	    constant_add_symbol(aTHX_  symbol_table, value_for_iv->name,
				value_for_iv->namelen, newSViv(value_for_iv->value));
            ++value_for_iv;
	}
        while (value_for_nv->name) {
	    constant_add_symbol(aTHX_  symbol_table, value_for_nv->name,
				value_for_nv->namelen, newSVnv(value_for_nv->value));
            ++value_for_nv;
	}
        while (value_for_uv->name) {
	    constant_add_symbol(aTHX_  symbol_table, value_for_uv->name,
				value_for_uv->namelen, newSVuv(value_for_uv->value));
            ++value_for_uv;
	}
        while (value_for_yes->name) {
	    constant_add_symbol(aTHX_  symbol_table, value_for_yes->name,
				value_for_yes->namelen, &PL_sv_yes);
            ++value_for_yes;
	}
	if (C_ARRAY_LENGTH(values_for_notfound) > 1) {
#ifndef SYMBIAN
	    HV *const constant_missing = get_missing_hash(aTHX);
#endif
	    const struct notfound_s *value_for_notfound = values_for_notfound;
	    do {

		/* Need to add prototypes, else parsing will vary by platform.  */
		HE *he = (HE*) hv_common_key_len(symbol_table,
						 value_for_notfound->name,
						 value_for_notfound->namelen,
						 HV_FETCH_LVALUE, NULL, 0);
		SV *sv;
#ifndef SYMBIAN
		HEK *hek;
#endif
		if (!he) {
		    croak("Couldn't add key '%s' to %%POSIX::",
			  value_for_notfound->name);
		}
		sv = HeVAL(he);
		if (!SvOK(sv) && SvTYPE(sv) != SVt_PVGV) {
		    /* Nothing was here before, so mark a prototype of ""  */
		    sv_setpvn(sv, "", 0);
		} else if (SvPOK(sv) && SvCUR(sv) == 0) {
		    /* There is already a prototype of "" - do nothing  */
		} else {
		    /* Someone has been here before us - have to make a real
		       typeglob.  */
		    /* It turns out to be incredibly hard to deal with all the
		       corner cases of sub foo (); and reporting errors correctly,
		       so lets cheat a bit.  Start with a constant subroutine  */
		    CV *cv = newCONSTSUB(symbol_table,
					 value_for_notfound->name,
					 &PL_sv_yes);
		    /* and then turn it into a non constant declaration only.  */
		    SvREFCNT_dec(CvXSUBANY(cv).any_ptr);
		    CvCONST_off(cv);
		    CvXSUB(cv) = NULL;
		    CvXSUBANY(cv).any_ptr = NULL;
		}
#ifndef SYMBIAN
		hek = HeKEY_hek(he);
		if (!hv_common(constant_missing, NULL, HEK_KEY(hek),
 			       HEK_LEN(hek), HEK_FLAGS(hek), HV_FETCH_ISSTORE,
			       &PL_sv_yes, HEK_HASH(hek)))
		    croak("Couldn't add key '%s' to missing_hash",
			  value_for_notfound->name);
#endif
	    } while ((++value_for_notfound)->name);
	}
#ifdef CLK_TCK
        {
            IV temp0;
            temp0 = CLK_TCK;
	    constant_add_symbol(aTHX_  symbol_table, "CLK_TCK",
				    7, newSViv(temp0));
        }
#endif
#ifdef MB_CUR_MAX
        {
            IV temp0;
            temp0 = MB_CUR_MAX;
	    constant_add_symbol(aTHX_  symbol_table, "MB_CUR_MAX",
				    10, newSViv(temp0));
        }
#endif
#ifdef SIG_DFL
        {
            IV temp0;
            temp0 = PTR2IV(SIG_DFL);
	    constant_add_symbol(aTHX_  symbol_table, "SIG_DFL",
				    7, newSViv(temp0));
        }
#endif
#ifdef SIG_ERR
        {
            IV temp0;
            temp0 = PTR2IV(SIG_ERR);
	    constant_add_symbol(aTHX_  symbol_table, "SIG_ERR",
				    7, newSViv(temp0));
        }
#endif
#ifdef SIG_IGN
        {
            IV temp0;
            temp0 = PTR2IV(SIG_IGN);
	    constant_add_symbol(aTHX_  symbol_table, "SIG_IGN",
				    7, newSViv(temp0));
        }
#endif
#ifdef FLT_ROUNDS
        {
            NV temp0;
            temp0 = FLT_ROUNDS;
	    constant_add_symbol(aTHX_  symbol_table, "FLT_ROUNDS",
				    10, newSVnv(temp0));
        }
#endif
#if (defined(USE_LONG_DOUBLE) && defined(HUGE_VALL)) || defined(HUGE_VAL)
	/* HUGE_VALL is admittedly non-POSIX but if we are using long doubles
	 * we might as well use long doubles. --jhi */
        {
            NV temp0;
            temp0 = 
#if defined(USE_LONG_DOUBLE) && defined(HUGE_VALL)
                   HUGE_VALL
#else
                   HUGE_VAL
#endif
                           ;
	    constant_add_symbol(aTHX_  symbol_table, "HUGE_VAL",
				    8, newSVnv(temp0));
        }
#endif
#ifdef INFINITY
        {
            NV temp0;
            temp0 = INFINITY;
	    constant_add_symbol(aTHX_  symbol_table, "INFINITY",
				    8, newSVnv(temp0));
        }
#endif
#ifdef NAN
        {
            NV temp0;
            temp0 = NAN;
	    constant_add_symbol(aTHX_  symbol_table, "NAN",
				    3, newSVnv(temp0));
        }
#endif
#ifdef Inf
        {
            NV temp0;
            temp0 = NV_INF;
	    constant_add_symbol(aTHX_  symbol_table, "Inf",
				    3, newSVnv(temp0));
        }
#endif
#ifdef NaN
        {
            NV temp0;
            temp0 = NV_NAN;
	    constant_add_symbol(aTHX_  symbol_table, "NaN",
				    3, newSVnv(temp0));
        }
#endif
#ifdef DBL_MAX
        {
            NV temp0;
            temp0 = DBL_MAX;
	    constant_add_symbol(aTHX_  symbol_table, "DBL_MAX",
				    7, newSVnv(temp0));
        }
#endif
#ifdef FLT_MAX
        {
            NV temp0;
            temp0 = FLT_MAX;
	    constant_add_symbol(aTHX_  symbol_table, "FLT_MAX",
				    7, newSVnv(temp0));
        }
#endif
#ifdef LDBL_MAX
        {
            NV temp0;
            temp0 = LDBL_MAX;
	    constant_add_symbol(aTHX_  symbol_table, "LDBL_MAX",
				    8, newSVnv(temp0));
        }
#endif
#ifdef LDBL_MIN
        {
            NV temp0;
            temp0 = LDBL_MIN;
	    constant_add_symbol(aTHX_  symbol_table, "LDBL_MIN",
				    8, newSVnv(temp0));
        }
#endif
#ifdef LDBL_EPSILON
        {
            NV temp0;
            temp0 = LDBL_EPSILON;
	    constant_add_symbol(aTHX_  symbol_table, "LDBL_EPSILON",
				    12, newSVnv(temp0));
        }
#endif
#ifdef DBL_EPSILON
        {
            NV temp0;
            temp0 = DBL_EPSILON;
	    constant_add_symbol(aTHX_  symbol_table, "DBL_EPSILON",
				    11, newSVnv(temp0));
        }
#endif
#ifdef DBL_MIN
        {
            NV temp0;
            temp0 = DBL_MIN;
	    constant_add_symbol(aTHX_  symbol_table, "DBL_MIN",
				    7, newSVnv(temp0));
        }
#endif
#ifdef FLT_EPSILON
        {
            NV temp0;
            temp0 = FLT_EPSILON;
	    constant_add_symbol(aTHX_  symbol_table, "FLT_EPSILON",
				    11, newSVnv(temp0));
        }
#endif
#ifdef FLT_MIN
        {
            NV temp0;
            temp0 = FLT_MIN;
	    constant_add_symbol(aTHX_  symbol_table, "FLT_MIN",
				    7, newSVnv(temp0));
        }
#endif
    /* As we've been creating subroutines, we better invalidate any cached
       methods  */
    mro_method_changed_in(symbol_table);
  }

#if XSubPPtmpAAAA
#endif
#line 7531 "POSIX.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

