/* Generated by wayland-scanner 1.20.0 */

#ifndef AGL_SCREENSHOOTER_CLIENT_PROTOCOL_H
#define AGL_SCREENSHOOTER_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_agl_screenshooter The agl_screenshooter protocol
 * @section page_ifaces_agl_screenshooter Interfaces
 * - @subpage page_iface_agl_screenshooter - agl screenshooter
 * @section page_copyright_agl_screenshooter Copyright
 * <pre>
 *
 * Copyright © 2020 Collabora. Ltd,
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct agl_screenshooter;
struct wl_buffer;
struct wl_output;

#ifndef AGL_SCREENSHOOTER_INTERFACE
#define AGL_SCREENSHOOTER_INTERFACE
/**
 * @page page_iface_agl_screenshooter agl_screenshooter
 * @section page_iface_agl_screenshooter_desc Description
 *
 * agl compositor extension that performs a screenshot of the output, which
 * is represented by a 'wl_output' object.
 *
 * A client would call 'take_shot' request and wait until the compositor
 * finishes to write the data to a wayland buffer, moment in which signals
 * back the client with the help of the 'done' event. Clients should wait
 * until the 'done' event is received, if they want to take another
 * screenshot, or take another screnshot of a different output.
 *
 * The client must provide a wl_shm-based wl_buffer of the correct size when
 * taking a shot. The compositor will write the shot into the wl_buffer and then
 * send the 'done' event that signals completion of writing the data.
 *
 * Once the compositor has finished to transfer the data back into the supplied
 * wayland buffer, the client should be able to transfer it to a popular
 * file format on the disk.
 * @section page_iface_agl_screenshooter_api API
 * See @ref iface_agl_screenshooter.
 */
/**
 * @defgroup iface_agl_screenshooter The agl_screenshooter interface
 *
 * agl compositor extension that performs a screenshot of the output, which
 * is represented by a 'wl_output' object.
 *
 * A client would call 'take_shot' request and wait until the compositor
 * finishes to write the data to a wayland buffer, moment in which signals
 * back the client with the help of the 'done' event. Clients should wait
 * until the 'done' event is received, if they want to take another
 * screenshot, or take another screnshot of a different output.
 *
 * The client must provide a wl_shm-based wl_buffer of the correct size when
 * taking a shot. The compositor will write the shot into the wl_buffer and then
 * send the 'done' event that signals completion of writing the data.
 *
 * Once the compositor has finished to transfer the data back into the supplied
 * wayland buffer, the client should be able to transfer it to a popular
 * file format on the disk.
 */
extern const struct wl_interface agl_screenshooter_interface;
#endif

#ifndef AGL_SCREENSHOOTER_DONE_STATUS_ENUM
#define AGL_SCREENSHOOTER_DONE_STATUS_ENUM
enum agl_screenshooter_done_status {
	AGL_SCREENSHOOTER_DONE_STATUS_SUCCESS = 0,
	AGL_SCREENSHOOTER_DONE_STATUS_NO_MEMORY = 1,
	AGL_SCREENSHOOTER_DONE_STATUS_BAD_BUFFER = 2,
};
#endif /* AGL_SCREENSHOOTER_DONE_STATUS_ENUM */

/**
 * @ingroup iface_agl_screenshooter
 * @struct agl_screenshooter_listener
 */
struct agl_screenshooter_listener {
	/**
	 * sent when 'take_shot' finished
	 *
	 * Even sent back to notify client 'take_shot' request has
	 * completed.
	 */
	void (*done)(void *data,
		     struct agl_screenshooter *agl_screenshooter,
		     uint32_t status);
};

/**
 * @ingroup iface_agl_screenshooter
 */
static inline int
agl_screenshooter_add_listener(struct agl_screenshooter *agl_screenshooter,
			       const struct agl_screenshooter_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) agl_screenshooter,
				     (void (**)(void)) listener, data);
}

#define AGL_SCREENSHOOTER_TAKE_SHOT 0
#define AGL_SCREENSHOOTER_DESTROY 1

/**
 * @ingroup iface_agl_screenshooter
 */
#define AGL_SCREENSHOOTER_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_agl_screenshooter
 */
#define AGL_SCREENSHOOTER_TAKE_SHOT_SINCE_VERSION 1
/**
 * @ingroup iface_agl_screenshooter
 */
#define AGL_SCREENSHOOTER_DESTROY_SINCE_VERSION 1

/** @ingroup iface_agl_screenshooter */
static inline void
agl_screenshooter_set_user_data(struct agl_screenshooter *agl_screenshooter, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) agl_screenshooter, user_data);
}

/** @ingroup iface_agl_screenshooter */
static inline void *
agl_screenshooter_get_user_data(struct agl_screenshooter *agl_screenshooter)
{
	return wl_proxy_get_user_data((struct wl_proxy *) agl_screenshooter);
}

static inline uint32_t
agl_screenshooter_get_version(struct agl_screenshooter *agl_screenshooter)
{
	return wl_proxy_get_version((struct wl_proxy *) agl_screenshooter);
}

/**
 * @ingroup iface_agl_screenshooter
 *
 * Takes a screenshot of the wayland output represented by a 'wl_output'
 * object. Clients should first retrieve it using global registry, as well
 * as the 'wl_shm' object in order to create a wayland buffer type of
 * object ('wl_buffer').
 *
 * Clients can derive the stride and size from the 'wl_output' object, and
 * later on use those when creating shm-based 'wl_buffer', as well as supplying
 * the pixel format.
 */
static inline void
agl_screenshooter_take_shot(struct agl_screenshooter *agl_screenshooter, struct wl_output *output, struct wl_buffer *buffer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) agl_screenshooter,
			 AGL_SCREENSHOOTER_TAKE_SHOT, NULL, wl_proxy_get_version((struct wl_proxy *) agl_screenshooter), 0, output, buffer);
}

/**
 * @ingroup iface_agl_screenshooter
 *
 * Destroys the 'weston_screenshooter' interface.
 */
static inline void
agl_screenshooter_destroy(struct agl_screenshooter *agl_screenshooter)
{
	wl_proxy_marshal_flags((struct wl_proxy *) agl_screenshooter,
			 AGL_SCREENSHOOTER_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) agl_screenshooter), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
