/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-derived-value.h"
#include "libical-glib-private.h"
#include "i-cal-attach.h"
#include "i-cal-datetimeperiod.h"
#include "i-cal-value.h"
#include "i-cal-recurrence.h"
#include "i-cal-reqstat.h"
#include "i-cal-trigger.h"
#include "i-cal-period.h"
#include "i-cal-geo.h"
#include "i-cal-time.h"
#include "i-cal-duration.h"

/**
 * i_cal_value_set_x:
 * @value: The #ICalValue
 * @v: The x value
 *
 * Sets the x in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_x (ICalValue *value, 
                   const gchar *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (v != NULL);

	icalvalue_set_x ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), v);
}

/**
 * i_cal_value_new_x:
 * @v: The x value
 *
 * Creates a new #ICalValue with the type x.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_x (const gchar *v)
{
	g_return_val_if_fail (v != NULL, NULL);

	return i_cal_value_new_full (icalvalue_new_x (v), NULL);
}

/**
 * i_cal_value_get_x:
 * @value: The #ICalValue to be queried
 *
 * Gets the x of #ICalValue.
 *
 * Returns: (nullable) (transfer none): The x within #ICalValue
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_value_get_x (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return icalvalue_get_x ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_value_set_recur:
 * @value: The #ICalValue
 * @v: The recur value
 *
 * Sets the recur in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_recur (ICalValue *value, 
                       ICalRecurrence *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (I_CAL_IS_RECURRENCE (v));

	icalvalue_set_recur ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), * (struct icalrecurrencetype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_value_new_recur:
 * @v: The recur value
 *
 * Creates a new #ICalValue with the type recur.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_recur (ICalRecurrence *v)
{
	g_return_val_if_fail (I_CAL_IS_RECURRENCE (v), NULL);

	return i_cal_value_new_full (icalvalue_new_recur (* (struct icalrecurrencetype *)i_cal_object_get_native (I_CAL_OBJECT (v))), NULL);
}

/**
 * i_cal_value_get_recur:
 * @value: The #ICalValue to be queried
 *
 * Gets the recur of #ICalValue.
 *
 * Returns: (nullable) (transfer full): The recur within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalRecurrence *
i_cal_value_get_recur (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return i_cal_recurrence_new_full (icalvalue_get_recur ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_trigger:
 * @value: The #ICalValue
 * @v: The trigger value
 *
 * Sets the trigger in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_trigger (ICalValue *value, 
                         ICalTrigger *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (I_CAL_IS_TRIGGER (v));

	icalvalue_set_trigger ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), * (struct icaltriggertype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_value_new_trigger:
 * @v: The trigger value
 *
 * Creates a new #ICalValue with the type trigger.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_trigger (ICalTrigger *v)
{
	g_return_val_if_fail (I_CAL_IS_TRIGGER (v), NULL);

	return i_cal_value_new_full (icalvalue_new_trigger (* (struct icaltriggertype *)i_cal_object_get_native (I_CAL_OBJECT (v))), NULL);
}

/**
 * i_cal_value_get_trigger:
 * @value: The #ICalValue to be queried
 *
 * Gets the trigger of #ICalValue.
 *
 * Returns: (nullable) (transfer full): The trigger within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalTrigger *
i_cal_value_get_trigger (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return i_cal_trigger_new_full (icalvalue_get_trigger ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_datetime:
 * @value: The #ICalValue
 * @v: The datetime value
 *
 * Sets the datetime in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_datetime (ICalValue *value, 
                          ICalTime *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (I_CAL_IS_TIME (v));

	icalvalue_set_datetime ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), * (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_value_new_datetime:
 * @v: The datetime value
 *
 * Creates a new #ICalValue with the type datetime.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_datetime (ICalTime *v)
{
	g_return_val_if_fail (I_CAL_IS_TIME (v), NULL);

	return i_cal_value_new_full (icalvalue_new_datetime (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (v))), NULL);
}

/**
 * i_cal_value_get_datetime:
 * @value: The #ICalValue to be queried
 *
 * Gets the datetime of #ICalValue.
 *
 * Returns: (nullable) (transfer full): The datetime within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_value_get_datetime (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return i_cal_time_new_full (icalvalue_get_datetime ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_datetimedate:
 * @value: The #ICalValue
 * @v: The datetimedate (DATE-TIME or DATE) value
 *
 * Sets the datetimedate (DATE-TIME or DATE) in the #ICalValue.
 *
 * Since: 3.0
 *
 **/
void
i_cal_value_set_datetimedate (ICalValue *value, 
                              ICalTime *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (I_CAL_IS_TIME (v));

	icalvalue_set_datetimedate ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), * (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_value_new_datetimedate:
 * @v: The DATE-TIME or DATE value
 *
 * Creates a new #ICalValue with the type datetimedate (DATE-TIME or DATE).
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 3.0
 *
 **/
ICalValue *
i_cal_value_new_datetimedate (ICalTime *v)
{
	g_return_val_if_fail (I_CAL_IS_TIME (v), NULL);

	return i_cal_value_new_full (icalvalue_new_datetimedate (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (v))), NULL);
}

/**
 * i_cal_value_get_datetimedate:
 * @value: The #ICalValue to be queried
 *
 * Gets the datetimedate (DATE-TIME or DATE) of #ICalValue.
 *
 * Returns: (nullable) (transfer full): The datetimedate within #ICalValue
 *
 * Since: 3.0
 *
 **/
ICalTime *
i_cal_value_get_datetimedate (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return i_cal_time_new_full (icalvalue_get_datetimedate ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_datetimeperiod:
 * @value: The #ICalValue
 * @v: The datetimeperiod value
 *
 * Sets the datetimeperiod in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_datetimeperiod (ICalValue *value, 
                                ICalDatetimeperiod *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (I_CAL_IS_DATETIMEPERIOD (v));

	icalvalue_set_datetimeperiod ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), * (struct icaldatetimeperiodtype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_value_new_datetimeperiod:
 * @v: The datetimeperiod value
 *
 * Creates a new #ICalValue with the type datetimeperiod.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_datetimeperiod (ICalDatetimeperiod *v)
{
	g_return_val_if_fail (I_CAL_IS_DATETIMEPERIOD (v), NULL);

	return i_cal_value_new_full (icalvalue_new_datetimeperiod (* (struct icaldatetimeperiodtype *)i_cal_object_get_native (I_CAL_OBJECT (v))), NULL);
}

/**
 * i_cal_value_get_datetimeperiod:
 * @value: The #ICalValue to be queried
 *
 * Gets the datetimeperiod of #ICalValue.
 *
 * Returns: (nullable) (transfer full): The datetimeperiod within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalDatetimeperiod *
i_cal_value_get_datetimeperiod (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return i_cal_datetimeperiod_new_full (icalvalue_get_datetimeperiod ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_geo:
 * @value: The #ICalValue
 * @v: The geo value
 *
 * Sets the geo in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_geo (ICalValue *value, 
                     ICalGeo *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (I_CAL_IS_GEO (v));

	icalvalue_set_geo ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), * (struct icalgeotype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_value_new_geo:
 * @v: The geo value
 *
 * Creates a new #ICalValue with the type geo.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_geo (ICalGeo *v)
{
	g_return_val_if_fail (I_CAL_IS_GEO (v), NULL);

	return i_cal_value_new_full (icalvalue_new_geo (* (struct icalgeotype *)i_cal_object_get_native (I_CAL_OBJECT (v))), NULL);
}

/**
 * i_cal_value_get_geo:
 * @value: The #ICalValue to be queried
 *
 * Gets the geo of #ICalValue.
 *
 * Returns: (nullable) (transfer full): The geo within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalGeo *
i_cal_value_get_geo (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return i_cal_geo_new_full (icalvalue_get_geo ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_attach:
 * @value: The #ICalValue
 * @v: The attach value
 *
 * Sets the attach in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_attach (ICalValue *value, 
                        ICalAttach *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (I_CAL_IS_ATTACH (v));

	i_cal_object_set_owner ((ICalObject *)v, (GObject *)value);
	icalvalue_set_attach ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalattach *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_value_new_attach:
 * @v: The attach value
 *
 * Creates a new #ICalValue with the type attach.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_attach (ICalAttach *v)
{
	g_return_val_if_fail (I_CAL_IS_ATTACH (v), NULL);

	return i_cal_value_new_full (icalvalue_new_attach ((icalattach *)i_cal_object_get_native (I_CAL_OBJECT (v))), NULL);
}

/**
 * i_cal_value_get_attach:
 * @value: The #ICalValue to be queried
 *
 * Gets the attach of #ICalValue.
 *
 * Returns: (nullable) (transfer none): The attach within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalAttach *
i_cal_value_get_attach (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return i_cal_attach_new_full (icalvalue_get_attach ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))), (GObject *)value);
}

/**
 * i_cal_value_reset_kind:
 * @value: The #ICalValue's kind to be reset
 *
 * Resets the kind of #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_reset_kind (ICalValue *value)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_reset_kind ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_value_set_xlicclass:
 * @value: The #ICalValue
 * @v: The xlicclass value
 *
 * Sets the xlicclass in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_xlicclass (ICalValue *value, 
                           ICalPropertyXlicclass v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_xlicclass ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalproperty_xlicclass) (v));
}

/**
 * i_cal_value_new_xlicclass:
 * @v: The xlicclass value
 *
 * Creates a new #ICalValue with the type xlicclass.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_xlicclass (ICalPropertyXlicclass v)
{
	return i_cal_value_new_full (icalvalue_new_xlicclass ((icalproperty_xlicclass) (v)), NULL);
}

/**
 * i_cal_value_get_xlicclass:
 * @value: The #ICalValue to be queried
 *
 * Gets the xlicclass of #ICalValue.
 *
 * Returns: The xlicclass within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalPropertyXlicclass
i_cal_value_get_xlicclass (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), I_CAL_XLICCLASS_NONE);

	return (ICalPropertyXlicclass) (icalvalue_get_xlicclass ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_boolean:
 * @value: The #ICalValue
 * @v: The boolean value
 *
 * Sets the boolean in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_boolean (ICalValue *value, 
                         gint v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_boolean ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), v);
}

/**
 * i_cal_value_new_boolean:
 * @v: The boolean value
 *
 * Creates a new #ICalValue with the type boolean.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_boolean (gint v)
{
	return i_cal_value_new_full (icalvalue_new_boolean (v), NULL);
}

/**
 * i_cal_value_get_boolean:
 * @value: The #ICalValue to be queried
 *
 * Gets the boolean of #ICalValue.
 *
 * Returns: The boolean within #ICalValue
 *
 * Since: 1.0
 *
 **/
gint
i_cal_value_get_boolean (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), 0);

	return icalvalue_get_boolean ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_value_set_busytype:
 * @value: The #ICalValue
 * @v: The busytype value
 *
 * Sets the busytype in the #ICalValue.
 *
 * Since: 2.0
 *
 **/
void
i_cal_value_set_busytype (ICalValue *value, 
                          ICalPropertyBusytype v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_busytype ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalproperty_busytype) (v));
}

/**
 * i_cal_value_new_busytype:
 * @v: The busytype value
 *
 * Creates a new #ICalValue with the type busytype.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 2.0
 *
 **/
ICalValue *
i_cal_value_new_busytype (ICalPropertyBusytype v)
{
	return i_cal_value_new_full (icalvalue_new_busytype ((icalproperty_busytype) (v)), NULL);
}

/**
 * i_cal_value_get_busytype:
 * @value: The #ICalValue to be queried
 *
 * Gets the busytype of #ICalValue.
 *
 * Returns: The busytype within #ICalValue
 *
 * Since: 2.0
 *
 **/
ICalPropertyBusytype
i_cal_value_get_busytype (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), I_CAL_BUSYTYPE_NONE);

	return (ICalPropertyBusytype) (icalvalue_get_busytype ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_pollcompletion:
 * @value: The #ICalValue
 * @v: The pollcompletion value
 *
 * Sets the pollcompletion in the #ICalValue.
 *
 * Since: 2.0
 *
 **/
void
i_cal_value_set_pollcompletion (ICalValue *value, 
                                ICalPropertyPollcompletion v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_pollcompletion ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalproperty_pollcompletion) (v));
}

/**
 * i_cal_value_new_pollcompletion:
 * @v: The pollcompletion value
 *
 * Creates a new #ICalValue with the type pollcompletion.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 2.0
 *
 **/
ICalValue *
i_cal_value_new_pollcompletion (ICalPropertyPollcompletion v)
{
	return i_cal_value_new_full (icalvalue_new_pollcompletion ((icalproperty_pollcompletion) (v)), NULL);
}

/**
 * i_cal_value_get_pollcompletion:
 * @value: The #ICalValue to be queried
 *
 * Gets the pollcompletion of #ICalValue.
 *
 * Returns: The pollcompletion within #ICalValue
 *
 * Since: 2.0
 *
 **/
ICalPropertyPollcompletion
i_cal_value_get_pollcompletion (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), I_CAL_POLLCOMPLETION_NONE);

	return (ICalPropertyPollcompletion) (icalvalue_get_pollcompletion ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_taskmode:
 * @value: The #ICalValue
 * @v: The taskmode value
 *
 * Sets the taskmode in the #ICalValue.
 *
 * Since: 2.0
 *
 **/
void
i_cal_value_set_taskmode (ICalValue *value, 
                          ICalPropertyTaskmode v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_taskmode ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalproperty_taskmode) (v));
}

/**
 * i_cal_value_new_taskmode:
 * @v: The taskmode value
 *
 * Creates a new #ICalValue with the type taskmode.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 2.0
 *
 **/
ICalValue *
i_cal_value_new_taskmode (ICalPropertyTaskmode v)
{
	return i_cal_value_new_full (icalvalue_new_taskmode ((icalproperty_taskmode) (v)), NULL);
}

/**
 * i_cal_value_get_taskmode:
 * @value: The #ICalValue to be queried
 *
 * Gets the taskmode of #ICalValue.
 *
 * Returns: The taskmode within #ICalValue
 *
 * Since: 2.0
 *
 **/
ICalPropertyTaskmode
i_cal_value_get_taskmode (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), I_CAL_TASKMODE_NONE);

	return (ICalPropertyTaskmode) (icalvalue_get_taskmode ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_pollmode:
 * @value: The #ICalValue
 * @v: The pollmode value
 *
 * Sets the pollmode in the #ICalValue.
 *
 * Since: 2.0
 *
 **/
void
i_cal_value_set_pollmode (ICalValue *value, 
                          ICalPropertyPollmode v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_pollmode ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalproperty_pollmode) (v));
}

/**
 * i_cal_value_new_pollmode:
 * @v: The pollmode value
 *
 * Creates a new #ICalValue with the type pollmode.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 2.0
 *
 **/
ICalValue *
i_cal_value_new_pollmode (ICalPropertyPollmode v)
{
	return i_cal_value_new_full (icalvalue_new_pollmode ((icalproperty_pollmode) (v)), NULL);
}

/**
 * i_cal_value_get_pollmode:
 * @value: The #ICalValue to be queried
 *
 * Gets the pollmode of #ICalValue.
 *
 * Returns: The pollmode within #ICalValue
 *
 * Since: 2.0
 *
 **/
ICalPropertyPollmode
i_cal_value_get_pollmode (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), I_CAL_POLLMODE_NONE);

	return (ICalPropertyPollmode) (icalvalue_get_pollmode ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_utcoffset:
 * @value: The #ICalValue
 * @v: The utcoffset value
 *
 * Sets the utcoffset in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_utcoffset (ICalValue *value, 
                           gint v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_utcoffset ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), v);
}

/**
 * i_cal_value_new_utcoffset:
 * @v: The utcoffset value
 *
 * Creates a new #ICalValue with the type utcoffset.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_utcoffset (gint v)
{
	return i_cal_value_new_full (icalvalue_new_utcoffset (v), NULL);
}

/**
 * i_cal_value_get_utcoffset:
 * @value: The #ICalValue to be queried
 *
 * Gets the utcoffset of #ICalValue.
 *
 * Returns: The utcoffset within #ICalValue
 *
 * Since: 1.0
 *
 **/
gint
i_cal_value_get_utcoffset (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), 0);

	return icalvalue_get_utcoffset ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_value_set_method:
 * @value: The #ICalValue
 * @v: The method value
 *
 * Sets the method in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_method (ICalValue *value, 
                        ICalPropertyMethod v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_method ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalproperty_method) (v));
}

/**
 * i_cal_value_new_method:
 * @v: The method value
 *
 * Creates a new #ICalValue with the type method.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_method (ICalPropertyMethod v)
{
	return i_cal_value_new_full (icalvalue_new_method ((icalproperty_method) (v)), NULL);
}

/**
 * i_cal_value_get_method:
 * @value: The #ICalValue to be queried
 *
 * Gets the method of #ICalValue.
 *
 * Returns: The method within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalPropertyMethod
i_cal_value_get_method (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), I_CAL_METHOD_NONE);

	return (ICalPropertyMethod) (icalvalue_get_method ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_caladdress:
 * @value: The #ICalValue
 * @v: The caladdress value
 *
 * Sets the caladdress in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_caladdress (ICalValue *value, 
                            const gchar *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (v != NULL);

	icalvalue_set_caladdress ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), v);
}

/**
 * i_cal_value_new_caladdress:
 * @v: The caladdress value
 *
 * Creates a new #ICalValue with the type caladdress.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_caladdress (const gchar *v)
{
	g_return_val_if_fail (v != NULL, NULL);

	return i_cal_value_new_full (icalvalue_new_caladdress (v), NULL);
}

/**
 * i_cal_value_get_caladdress:
 * @value: The #ICalValue to be queried
 *
 * Gets the caladdress of #ICalValue.
 *
 * Returns: (nullable) (transfer none): The caladdress within #ICalValue
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_value_get_caladdress (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return icalvalue_get_caladdress ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_value_set_period:
 * @value: The #ICalValue
 * @v: The period value
 *
 * Sets the period in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_period (ICalValue *value, 
                        ICalPeriod *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (I_CAL_IS_PERIOD (v));

	icalvalue_set_period ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), * (struct icalperiodtype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_value_new_period:
 * @v: The period value
 *
 * Creates a new #ICalValue with the type period.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_period (ICalPeriod *v)
{
	g_return_val_if_fail (I_CAL_IS_PERIOD (v), NULL);

	return i_cal_value_new_full (icalvalue_new_period (* (struct icalperiodtype *)i_cal_object_get_native (I_CAL_OBJECT (v))), NULL);
}

/**
 * i_cal_value_get_period:
 * @value: The #ICalValue to be queried
 *
 * Gets the period of #ICalValue.
 *
 * Returns: (nullable) (transfer full): The period within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalPeriod *
i_cal_value_get_period (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return i_cal_period_new_full (icalvalue_get_period ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_status:
 * @value: The #ICalValue
 * @v: The status value
 *
 * Sets the status in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_status (ICalValue *value, 
                        ICalPropertyStatus v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_status ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalproperty_status) (v));
}

/**
 * i_cal_value_new_status:
 * @v: The status value
 *
 * Creates a new #ICalValue with the type status.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_status (ICalPropertyStatus v)
{
	return i_cal_value_new_full (icalvalue_new_status ((icalproperty_status) (v)), NULL);
}

/**
 * i_cal_value_get_status:
 * @value: The #ICalValue to be queried
 *
 * Gets the status of #ICalValue.
 *
 * Returns: The status within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalPropertyStatus
i_cal_value_get_status (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), I_CAL_STATUS_NONE);

	return (ICalPropertyStatus) (icalvalue_get_status ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_binary:
 * @value: The #ICalValue
 * @v: The binary value
 *
 * Sets the binary in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_binary (ICalValue *value, 
                        const gchar *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (v != NULL);

	icalvalue_set_binary ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), v);
}

/**
 * i_cal_value_new_binary:
 * @v: The binary value
 *
 * Creates a new #ICalValue with the type binary.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_binary (const gchar *v)
{
	g_return_val_if_fail (v != NULL, NULL);

	return i_cal_value_new_full (icalvalue_new_binary (v), NULL);
}

/**
 * i_cal_value_get_binary:
 * @value: The #ICalValue to be queried
 *
 * Gets the binary of #ICalValue.
 *
 * Returns: (nullable) (transfer none): The binary within #ICalValue
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_value_get_binary (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return icalvalue_get_binary ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_value_set_text:
 * @value: The #ICalValue
 * @v: The text value
 *
 * Sets the text in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_text (ICalValue *value, 
                      const gchar *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (v != NULL);

	icalvalue_set_text ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), v);
}

/**
 * i_cal_value_new_text:
 * @v: The text value
 *
 * Creates a new #ICalValue with the type text.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_text (const gchar *v)
{
	g_return_val_if_fail (v != NULL, NULL);

	return i_cal_value_new_full (icalvalue_new_text (v), NULL);
}

/**
 * i_cal_value_get_text:
 * @value: The #ICalValue to be queried
 *
 * Gets the text of #ICalValue.
 *
 * Returns: (nullable) (transfer none): The text within #ICalValue
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_value_get_text (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return icalvalue_get_text ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_value_set_duration:
 * @value: The #ICalValue
 * @v: The duration value
 *
 * Sets the duration in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_duration (ICalValue *value, 
                          ICalDuration *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (I_CAL_IS_DURATION (v));

	icalvalue_set_duration ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), * (struct icaldurationtype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_value_new_duration:
 * @v: The duration value
 *
 * Creates a new #ICalValue with the type duration.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_duration (ICalDuration *v)
{
	g_return_val_if_fail (I_CAL_IS_DURATION (v), NULL);

	return i_cal_value_new_full (icalvalue_new_duration (* (struct icaldurationtype *)i_cal_object_get_native (I_CAL_OBJECT (v))), NULL);
}

/**
 * i_cal_value_get_duration:
 * @value: The #ICalValue to be queried
 *
 * Gets the duration of #ICalValue.
 *
 * Returns: (nullable) (transfer full): The duration within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalDuration *
i_cal_value_get_duration (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return i_cal_duration_new_full (icalvalue_get_duration ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_integer:
 * @value: The #ICalValue
 * @v: The integer value
 *
 * Sets the integer in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_integer (ICalValue *value, 
                         gint v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_integer ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), v);
}

/**
 * i_cal_value_new_integer:
 * @v: The integer value
 *
 * Creates a new #ICalValue with the type integer.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_integer (gint v)
{
	return i_cal_value_new_full (icalvalue_new_integer (v), NULL);
}

/**
 * i_cal_value_get_integer:
 * @value: The #ICalValue to be queried
 *
 * Gets the integer of #ICalValue.
 *
 * Returns: The integer within #ICalValue
 *
 * Since: 1.0
 *
 **/
gint
i_cal_value_get_integer (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), 0);

	return icalvalue_get_integer ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_value_set_uri:
 * @value: The #ICalValue
 * @v: The uri value
 *
 * Sets the uri in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_uri (ICalValue *value, 
                     const gchar *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (v != NULL);

	icalvalue_set_uri ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), v);
}

/**
 * i_cal_value_new_uri:
 * @v: The uri value
 *
 * Creates a new #ICalValue with the type uri.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_uri (const gchar *v)
{
	g_return_val_if_fail (v != NULL, NULL);

	return i_cal_value_new_full (icalvalue_new_uri (v), NULL);
}

/**
 * i_cal_value_get_uri:
 * @value: The #ICalValue to be queried
 *
 * Gets the uri of #ICalValue.
 *
 * Returns: (nullable) (transfer none): The uri within #ICalValue
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_value_get_uri (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return icalvalue_get_uri ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_value_set_class:
 * @value: The #ICalValue
 * @v: The class value
 *
 * Sets the class in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_class (ICalValue *value, 
                       ICalProperty_Class v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_class ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalproperty_class) (v));
}

/**
 * i_cal_value_new_class:
 * @v: The class value
 *
 * Creates a new #ICalValue with the type class.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_class (ICalProperty_Class v)
{
	return i_cal_value_new_full (icalvalue_new_class ((icalproperty_class) (v)), NULL);
}

/**
 * i_cal_value_get_class:
 * @value: The #ICalValue to be queried
 *
 * Gets the class of #ICalValue.
 *
 * Returns: The class within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalProperty_Class
i_cal_value_get_class (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), I_CAL_CLASS_NONE);

	return (ICalProperty_Class) (icalvalue_get_class ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_float:
 * @value: The #ICalValue
 * @v: The float value
 *
 * Sets the float in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_float (ICalValue *value, 
                       gdouble v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_float ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), v);
}

/**
 * i_cal_value_new_float:
 * @v: The float value
 *
 * Creates a new #ICalValue with the type float.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_float (gdouble v)
{
	return i_cal_value_new_full (icalvalue_new_float (v), NULL);
}

/**
 * i_cal_value_get_float:
 * @value: The #ICalValue to be queried
 *
 * Gets the float of #ICalValue.
 *
 * Returns: The float within #ICalValue
 *
 * Since: 1.0
 *
 **/
gdouble
i_cal_value_get_float (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), 0);

	return icalvalue_get_float ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_value_set_query:
 * @value: The #ICalValue
 * @v: The query value
 *
 * Sets the query in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_query (ICalValue *value, 
                       const gchar *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (v != NULL);

	icalvalue_set_query ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), v);
}

/**
 * i_cal_value_new_query:
 * @v: The query value
 *
 * Creates a new #ICalValue with the type query.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_query (const gchar *v)
{
	g_return_val_if_fail (v != NULL, NULL);

	return i_cal_value_new_full (icalvalue_new_query (v), NULL);
}

/**
 * i_cal_value_get_query:
 * @value: The #ICalValue to be queried
 *
 * Gets the query of #ICalValue.
 *
 * Returns: (nullable) (transfer none): The query within #ICalValue
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_value_get_query (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return icalvalue_get_query ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_value_set_string:
 * @value: The #ICalValue
 * @v: The string value
 *
 * Sets the string in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_string (ICalValue *value, 
                        const gchar *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (v != NULL);

	icalvalue_set_string ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), v);
}

/**
 * i_cal_value_new_string:
 * @v: The string value
 *
 * Creates a new #ICalValue with the type string.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_string (const gchar *v)
{
	g_return_val_if_fail (v != NULL, NULL);

	return i_cal_value_new_full (icalvalue_new_string (v), NULL);
}

/**
 * i_cal_value_get_string:
 * @value: The #ICalValue to be queried
 *
 * Gets the string of #ICalValue.
 *
 * Returns: (nullable) (transfer none): The string within #ICalValue
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_value_get_string (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return icalvalue_get_string ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)));
}

/**
 * i_cal_value_set_transp:
 * @value: The #ICalValue
 * @v: The transp value
 *
 * Sets the transp in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_transp (ICalValue *value, 
                        ICalPropertyTransp v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_transp ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalproperty_transp) (v));
}

/**
 * i_cal_value_new_transp:
 * @v: The transp value
 *
 * Creates a new #ICalValue with the type transp.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_transp (ICalPropertyTransp v)
{
	return i_cal_value_new_full (icalvalue_new_transp ((icalproperty_transp) (v)), NULL);
}

/**
 * i_cal_value_get_transp:
 * @value: The #ICalValue to be queried
 *
 * Gets the transp of #ICalValue.
 *
 * Returns: The transp within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalPropertyTransp
i_cal_value_get_transp (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), I_CAL_TRANSP_NONE);

	return (ICalPropertyTransp) (icalvalue_get_transp ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_requeststatus:
 * @value: The #ICalValue
 * @v: The requeststatus value
 *
 * Sets the requeststatus in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_requeststatus (ICalValue *value, 
                               ICalReqstat *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (I_CAL_IS_REQSTAT (v));

	icalvalue_set_requeststatus ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), * (struct icalreqstattype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_value_new_requeststatus:
 * @v: The requeststatus value
 *
 * Creates a new #ICalValue with the type requeststatus.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_requeststatus (ICalReqstat *v)
{
	g_return_val_if_fail (I_CAL_IS_REQSTAT (v), NULL);

	return i_cal_value_new_full (icalvalue_new_requeststatus (* (struct icalreqstattype *)i_cal_object_get_native (I_CAL_OBJECT (v))), NULL);
}

/**
 * i_cal_value_get_requeststatus:
 * @value: The #ICalValue to be queried
 *
 * Gets the requeststatus of #ICalValue.
 *
 * Returns: (nullable) (transfer full): The requeststatus within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalReqstat *
i_cal_value_get_requeststatus (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return i_cal_reqstat_new_full (icalvalue_get_requeststatus ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_date:
 * @value: The #ICalValue
 * @v: The date value
 *
 * Sets the date in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_date (ICalValue *value, 
                      ICalTime *v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));
	g_return_if_fail (I_CAL_IS_TIME (v));

	icalvalue_set_date ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), * (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (v)));
}

/**
 * i_cal_value_new_date:
 * @v: The date value
 *
 * Creates a new #ICalValue with the type date.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_date (ICalTime *v)
{
	g_return_val_if_fail (I_CAL_IS_TIME (v), NULL);

	return i_cal_value_new_full (icalvalue_new_date (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (v))), NULL);
}

/**
 * i_cal_value_get_date:
 * @value: The #ICalValue to be queried
 *
 * Gets the date of #ICalValue.
 *
 * Returns: (nullable) (transfer full): The date within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_value_get_date (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), NULL);

	return i_cal_time_new_full (icalvalue_get_date ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_action:
 * @value: The #ICalValue
 * @v: The action value
 *
 * Sets the action in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_action (ICalValue *value, 
                        ICalPropertyAction v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_action ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalproperty_action) (v));
}

/**
 * i_cal_value_new_action:
 * @v: The action value
 *
 * Creates a new #ICalValue with the type action.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_action (ICalPropertyAction v)
{
	return i_cal_value_new_full (icalvalue_new_action ((icalproperty_action) (v)), NULL);
}

/**
 * i_cal_value_get_action:
 * @value: The #ICalValue to be queried
 *
 * Gets the action of #ICalValue.
 *
 * Returns: The action within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalPropertyAction
i_cal_value_get_action (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), I_CAL_ACTION_NONE);

	return (ICalPropertyAction) (icalvalue_get_action ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_cmd:
 * @value: The #ICalValue
 * @v: The cmd value
 *
 * Sets the cmd in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_cmd (ICalValue *value, 
                     ICalPropertyCmd v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_cmd ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalproperty_cmd) (v));
}

/**
 * i_cal_value_new_cmd:
 * @v: The cmd value
 *
 * Creates a new #ICalValue with the type cmd.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_cmd (ICalPropertyCmd v)
{
	return i_cal_value_new_full (icalvalue_new_cmd ((icalproperty_cmd) (v)), NULL);
}

/**
 * i_cal_value_get_cmd:
 * @value: The #ICalValue to be queried
 *
 * Gets the cmd of #ICalValue.
 *
 * Returns: The cmd within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalPropertyCmd
i_cal_value_get_cmd (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), I_CAL_CMD_NONE);

	return (ICalPropertyCmd) (icalvalue_get_cmd ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_querylevel:
 * @value: The #ICalValue
 * @v: The querylevel value
 *
 * Sets the querylevel in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_querylevel (ICalValue *value, 
                            ICalPropertyQuerylevel v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_querylevel ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalproperty_querylevel) (v));
}

/**
 * i_cal_value_new_querylevel:
 * @v: The querylevel value
 *
 * Creates a new #ICalValue with the type querylevel.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_querylevel (ICalPropertyQuerylevel v)
{
	return i_cal_value_new_full (icalvalue_new_querylevel ((icalproperty_querylevel) (v)), NULL);
}

/**
 * i_cal_value_get_querylevel:
 * @value: The #ICalValue to be queried
 *
 * Gets the querylevel of #ICalValue.
 *
 * Returns: The querylevel within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalPropertyQuerylevel
i_cal_value_get_querylevel (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), I_CAL_QUERYLEVEL_NONE);

	return (ICalPropertyQuerylevel) (icalvalue_get_querylevel ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}

/**
 * i_cal_value_set_carlevel:
 * @value: The #ICalValue
 * @v: The carlevel value
 *
 * Sets the carlevel in the #ICalValue.
 *
 * Since: 1.0
 *
 **/
void
i_cal_value_set_carlevel (ICalValue *value, 
                          ICalPropertyCarlevel v)
{
	g_return_if_fail (I_CAL_IS_VALUE (value));

	icalvalue_set_carlevel ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value)), (icalproperty_carlevel) (v));
}

/**
 * i_cal_value_new_carlevel:
 * @v: The carlevel value
 *
 * Creates a new #ICalValue with the type carlevel.
 *
 * Returns: (transfer full): The newly created #ICalValue.
 *
 * Since: 1.0
 *
 **/
ICalValue *
i_cal_value_new_carlevel (ICalPropertyCarlevel v)
{
	return i_cal_value_new_full (icalvalue_new_carlevel ((icalproperty_carlevel) (v)), NULL);
}

/**
 * i_cal_value_get_carlevel:
 * @value: The #ICalValue to be queried
 *
 * Gets the carlevel of #ICalValue.
 *
 * Returns: The carlevel within #ICalValue
 *
 * Since: 1.0
 *
 **/
ICalPropertyCarlevel
i_cal_value_get_carlevel (ICalValue *value)
{
	g_return_val_if_fail (I_CAL_IS_VALUE (value), I_CAL_CARLEVEL_NONE);

	return (ICalPropertyCarlevel) (icalvalue_get_carlevel ((icalvalue *)i_cal_object_get_native (I_CAL_OBJECT (value))));
}
