/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-datetimeperiod.h"
#include "libical-glib-private.h"
#include "i-cal-period.h"
#include "i-cal-time.h"

G_DEFINE_TYPE (ICalDatetimeperiod, i_cal_datetimeperiod, I_CAL_TYPE_OBJECT)

static void i_cal_datetimeperiod_class_init (G_GNUC_UNUSED ICalDatetimeperiodClass *klass)
{
}

static void i_cal_datetimeperiod_init (G_GNUC_UNUSED ICalDatetimeperiod *self)
{
}

/**
 * i_cal_datetimeperiod_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalDatetimeperiod *
i_cal_datetimeperiod_new_full (struct icaldatetimeperiodtype native)
{
    ICalDatetimeperiod *object;
    struct icaldatetimeperiodtype *clone;
    
    
    clone = g_new (struct icaldatetimeperiodtype, 1);
    *clone = native;
    object = i_cal_object_construct (I_CAL_TYPE_DATETIMEPERIOD,
                            (gpointer) clone,
                            (GDestroyNotify) g_free,
                            FALSE,
                            NULL);

    return object;
}


/**
 * i_cal_datetimeperiod_new_default: (skip)
 *
 * Creates a new default #ICalDatetimeperiod.
 *
 * Returns: (transfer full): The newly created #ICalDatetimeperiod
 *
 * Since: 1.0
 *
 **/
struct icaldatetimeperiodtype
i_cal_datetimeperiod_new_default (void)
{
	struct icaldatetimeperiodtype datetimeperiodtype;
	datetimeperiodtype.time = icaltime_null_time ();
	datetimeperiodtype.period = icalperiodtype_null_period ();
	return datetimeperiodtype;
}

/**
 * i_cal_datetimeperiod_new:
 *
 * Creates a new #ICalDatetimeperiod.
 *
 * Returns: (transfer full): The newly created #ICalDatetimeperiod.
 *
 * Since: 1.0
 *
 **/
ICalDatetimeperiod *
i_cal_datetimeperiod_new (void)
{
	return i_cal_datetimeperiod_new_full(i_cal_datetimeperiod_new_default());
}

/**
 * i_cal_datetimeperiod_get_time:
 * @dtp: The #ICalDatetimeperiod to be queried
 *
 * Gets the time attribute of #ICalDatetimeperiod.
 *
 * Returns: (transfer full): The time attribute of @dtp.
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_datetimeperiod_get_time (ICalDatetimeperiod *dtp)
{
	g_return_val_if_fail (dtp != NULL && I_CAL_IS_DATETIMEPERIOD (dtp), NULL);
	return i_cal_time_new_full (((struct icaldatetimeperiodtype *)i_cal_object_get_native ((ICalObject *)dtp))->time);
}

/**
 * i_cal_datetimeperiod_set_time:
 * @dtp: The #ICalDatetimeperiod to be set
 * @time: The time attribute of @dtp
 *
 * Sets the time attribute of #ICalDatetimeperiod.
 *
 * Since: 1.0
 *
 **/
void
i_cal_datetimeperiod_set_time (ICalDatetimeperiod *dtp, 
                               ICalTime *time)
{
	g_return_if_fail (dtp != NULL && I_CAL_IS_DATETIMEPERIOD (dtp));
	g_return_if_fail (time != NULL && I_CAL_IS_TIME(time));
	((struct icaldatetimeperiodtype *)i_cal_object_get_native ((ICalObject *)dtp))->time = *(struct icaltimetype *)i_cal_object_get_native ((ICalObject *)time);
}

/**
 * i_cal_datetimeperiod_get_period:
 * @dtp: The #ICalDatetimeperiod to be queried
 *
 * Gets the period attribute of #ICalDatetimeperiod.
 *
 * Returns: (transfer full): The period attribute of @dtp.
 *
 * Since: 1.0
 *
 **/
ICalPeriod *
i_cal_datetimeperiod_get_period (ICalDatetimeperiod *dtp)
{
	g_return_val_if_fail (dtp != NULL && I_CAL_IS_DATETIMEPERIOD (dtp), NULL);
	return i_cal_period_new_full (((struct icaldatetimeperiodtype *)i_cal_object_get_native ((ICalObject *)dtp))->period);
}

/**
 * i_cal_datetimeperiod_set_period:
 * @dtp: The #ICalDatetimeperiod to be set
 * @period: The period attribute of @dtp
 *
 * Sets the period attribute of #ICalDatetimeperiod.
 *
 * Since: 1.0
 *
 **/
void
i_cal_datetimeperiod_set_period (ICalDatetimeperiod *dtp, 
                                 ICalPeriod *period)
{
	g_return_if_fail (dtp != NULL && I_CAL_IS_DATETIMEPERIOD (dtp));
	g_return_if_fail (period != NULL && I_CAL_IS_PERIOD(period));
	((struct icaldatetimeperiodtype *)i_cal_object_get_native ((ICalObject *)dtp))->period = *(struct icalperiodtype *)i_cal_object_get_native ((ICalObject *)period);
}
