/*
* @copyright Copyright (c) 2023 Toyota Connected North America
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#pragma once

#include <map>
#include <memory>
#include <string>

#include "flutter/fml/macros.h"

#include <shell/platform/embedder/embedder.h>

#include "constants.h"

class Engine;

class KeyboardManager {
 public:
  static constexpr char kChannelName[] = "flutter/keyboard";

  /**
  * @brief Callback function for platform messages about keyboard
  * @param[in] message Received message
  * @param[in] userdata Pointer to User data
  * @return void
  * @relation
  * flutter
  *
   */
  MAYBE_UNUSED static void OnPlatformMessage(
      const FlutterPlatformMessage* message,
      void* userdata);

  FML_DISALLOW_COPY_AND_ASSIGN(KeyboardManager);

 private:
  static constexpr char kGetKeyboardState[] = "getKeyboardState";
};