/* Generated by wayland-scanner 1.20.0 */

#ifndef BUILD_TIME_WAYLAND_TESTS_CLIENT_PROTOCOL_H
#define BUILD_TIME_WAYLAND_TESTS_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_build_time_wayland_tests The build_time_wayland_tests protocol
 * @section page_ifaces_build_time_wayland_tests Interfaces
 * - @subpage page_iface_fd_passer - Sends an event with an fd
 * @section page_copyright_build_time_wayland_tests Copyright
 * <pre>
 *
 * Copyright © 2017 Samsung Electronics Co., Ltd
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * </pre>
 */
struct fd_passer;

#ifndef FD_PASSER_INTERFACE
#define FD_PASSER_INTERFACE
/**
 * @page page_iface_fd_passer fd_passer
 * @section page_iface_fd_passer_desc Description
 *
 * A trivial interface for fd passing tests.
 * @section page_iface_fd_passer_api API
 * See @ref iface_fd_passer.
 */
/**
 * @defgroup iface_fd_passer The fd_passer interface
 *
 * A trivial interface for fd passing tests.
 */
extern const struct wl_interface fd_passer_interface;
#endif

/**
 * @ingroup iface_fd_passer
 * @struct fd_passer_listener
 */
struct fd_passer_listener {
	/**
	 */
	void (*pre_fd)(void *data,
		       struct fd_passer *fd_passer);
	/**
	 * passes a file descriptor
	 *
	 * 
	 * @param fd file descriptor
	 */
	void (*fd)(void *data,
		   struct fd_passer *fd_passer,
		   int32_t fd);
};

/**
 * @ingroup iface_fd_passer
 */
static inline int
fd_passer_add_listener(struct fd_passer *fd_passer,
		       const struct fd_passer_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) fd_passer,
				     (void (**)(void)) listener, data);
}

#define FD_PASSER_DESTROY 0
#define FD_PASSER_CONJOIN 1

/**
 * @ingroup iface_fd_passer
 */
#define FD_PASSER_PRE_FD_SINCE_VERSION 1
/**
 * @ingroup iface_fd_passer
 */
#define FD_PASSER_FD_SINCE_VERSION 1

/**
 * @ingroup iface_fd_passer
 */
#define FD_PASSER_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_fd_passer
 */
#define FD_PASSER_CONJOIN_SINCE_VERSION 2

/** @ingroup iface_fd_passer */
static inline void
fd_passer_set_user_data(struct fd_passer *fd_passer, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) fd_passer, user_data);
}

/** @ingroup iface_fd_passer */
static inline void *
fd_passer_get_user_data(struct fd_passer *fd_passer)
{
	return wl_proxy_get_user_data((struct wl_proxy *) fd_passer);
}

static inline uint32_t
fd_passer_get_version(struct fd_passer *fd_passer)
{
	return wl_proxy_get_version((struct wl_proxy *) fd_passer);
}

/**
 * @ingroup iface_fd_passer
 */
static inline void
fd_passer_destroy(struct fd_passer *fd_passer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) fd_passer,
			 FD_PASSER_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) fd_passer), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_fd_passer
 *
 * Tells this fd passer object about another one to send events
 * to for more complicated fd leak tests.
 */
static inline void
fd_passer_conjoin(struct fd_passer *fd_passer, struct fd_passer *passer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) fd_passer,
			 FD_PASSER_CONJOIN, NULL, wl_proxy_get_version((struct wl_proxy *) fd_passer), 0, passer);
}

#ifdef  __cplusplus
}
#endif

#endif
