/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "udisks-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.UDisks2.Manager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:UDisksManager
 * @title: UDisksManager
 * @short_description: Generated C code for the org.freedesktop.UDisks2.Manager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Manager.top_of_page">org.freedesktop.UDisks2.Manager</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.UDisks2.Manager ---- */

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_can_format_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_can_format_IN_ARG_pointers[] =
{
  &_udisks_manager_method_info_can_format_IN_ARG_type.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_can_format_OUT_ARG_available =
{
  {
    -1,
    (gchar *) "available",
    (gchar *) "(bs)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_can_format_OUT_ARG_pointers[] =
{
  &_udisks_manager_method_info_can_format_OUT_ARG_available.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_manager_method_info_can_format =
{
  {
    -1,
    (gchar *) "CanFormat",
    (GDBusArgInfo **) &_udisks_manager_method_info_can_format_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_manager_method_info_can_format_OUT_ARG_pointers,
    NULL
  },
  "handle-can-format",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_can_resize_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_can_resize_IN_ARG_pointers[] =
{
  &_udisks_manager_method_info_can_resize_IN_ARG_type.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_can_resize_OUT_ARG_available =
{
  {
    -1,
    (gchar *) "available",
    (gchar *) "(bts)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_can_resize_OUT_ARG_pointers[] =
{
  &_udisks_manager_method_info_can_resize_OUT_ARG_available.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_manager_method_info_can_resize =
{
  {
    -1,
    (gchar *) "CanResize",
    (GDBusArgInfo **) &_udisks_manager_method_info_can_resize_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_manager_method_info_can_resize_OUT_ARG_pointers,
    NULL
  },
  "handle-can-resize",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_can_check_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_can_check_IN_ARG_pointers[] =
{
  &_udisks_manager_method_info_can_check_IN_ARG_type.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_can_check_OUT_ARG_available =
{
  {
    -1,
    (gchar *) "available",
    (gchar *) "(bs)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_can_check_OUT_ARG_pointers[] =
{
  &_udisks_manager_method_info_can_check_OUT_ARG_available.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_manager_method_info_can_check =
{
  {
    -1,
    (gchar *) "CanCheck",
    (GDBusArgInfo **) &_udisks_manager_method_info_can_check_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_manager_method_info_can_check_OUT_ARG_pointers,
    NULL
  },
  "handle-can-check",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_can_repair_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_can_repair_IN_ARG_pointers[] =
{
  &_udisks_manager_method_info_can_repair_IN_ARG_type.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_can_repair_OUT_ARG_available =
{
  {
    -1,
    (gchar *) "available",
    (gchar *) "(bs)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_can_repair_OUT_ARG_pointers[] =
{
  &_udisks_manager_method_info_can_repair_OUT_ARG_available.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_manager_method_info_can_repair =
{
  {
    -1,
    (gchar *) "CanRepair",
    (GDBusArgInfo **) &_udisks_manager_method_info_can_repair_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_manager_method_info_can_repair_OUT_ARG_pointers,
    NULL
  },
  "handle-can-repair",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_loop_setup_IN_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_loop_setup_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_loop_setup_IN_ARG_pointers[] =
{
  &_udisks_manager_method_info_loop_setup_IN_ARG_fd.parent_struct,
  &_udisks_manager_method_info_loop_setup_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_loop_setup_OUT_ARG_resulting_device =
{
  {
    -1,
    (gchar *) "resulting_device",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_loop_setup_OUT_ARG_pointers[] =
{
  &_udisks_manager_method_info_loop_setup_OUT_ARG_resulting_device.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_manager_method_info_loop_setup =
{
  {
    -1,
    (gchar *) "LoopSetup",
    (GDBusArgInfo **) &_udisks_manager_method_info_loop_setup_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_manager_method_info_loop_setup_OUT_ARG_pointers,
    NULL
  },
  "handle-loop-setup",
  TRUE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_mdraid_create_IN_ARG_blocks =
{
  {
    -1,
    (gchar *) "blocks",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_mdraid_create_IN_ARG_level =
{
  {
    -1,
    (gchar *) "level",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_mdraid_create_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_mdraid_create_IN_ARG_chunk =
{
  {
    -1,
    (gchar *) "chunk",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_mdraid_create_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_mdraid_create_IN_ARG_pointers[] =
{
  &_udisks_manager_method_info_mdraid_create_IN_ARG_blocks.parent_struct,
  &_udisks_manager_method_info_mdraid_create_IN_ARG_level.parent_struct,
  &_udisks_manager_method_info_mdraid_create_IN_ARG_name.parent_struct,
  &_udisks_manager_method_info_mdraid_create_IN_ARG_chunk.parent_struct,
  &_udisks_manager_method_info_mdraid_create_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_mdraid_create_OUT_ARG_resulting_array =
{
  {
    -1,
    (gchar *) "resulting_array",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_mdraid_create_OUT_ARG_pointers[] =
{
  &_udisks_manager_method_info_mdraid_create_OUT_ARG_resulting_array.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_manager_method_info_mdraid_create =
{
  {
    -1,
    (gchar *) "MDRaidCreate",
    (GDBusArgInfo **) &_udisks_manager_method_info_mdraid_create_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_manager_method_info_mdraid_create_OUT_ARG_pointers,
    NULL
  },
  "handle-mdraid-create",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_enable_modules_IN_ARG_enable =
{
  {
    -1,
    (gchar *) "enable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_enable_modules_IN_ARG_pointers[] =
{
  &_udisks_manager_method_info_enable_modules_IN_ARG_enable.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _udisks_manager_method_enable_modules_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Deprecated",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _udisks_manager_method_enable_modules_annotation_info_pointers[] =
{
  &_udisks_manager_method_enable_modules_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_manager_method_info_enable_modules =
{
  {
    -1,
    (gchar *) "EnableModules",
    (GDBusArgInfo **) &_udisks_manager_method_info_enable_modules_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_udisks_manager_method_enable_modules_annotation_info_pointers
  },
  "handle-enable-modules",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_enable_module_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_enable_module_IN_ARG_enable =
{
  {
    -1,
    (gchar *) "enable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_enable_module_IN_ARG_pointers[] =
{
  &_udisks_manager_method_info_enable_module_IN_ARG_name.parent_struct,
  &_udisks_manager_method_info_enable_module_IN_ARG_enable.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_manager_method_info_enable_module =
{
  {
    -1,
    (gchar *) "EnableModule",
    (GDBusArgInfo **) &_udisks_manager_method_info_enable_module_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-enable-module",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_get_block_devices_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_get_block_devices_IN_ARG_pointers[] =
{
  &_udisks_manager_method_info_get_block_devices_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_get_block_devices_OUT_ARG_block_objects =
{
  {
    -1,
    (gchar *) "block_objects",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_get_block_devices_OUT_ARG_pointers[] =
{
  &_udisks_manager_method_info_get_block_devices_OUT_ARG_block_objects.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_manager_method_info_get_block_devices =
{
  {
    -1,
    (gchar *) "GetBlockDevices",
    (GDBusArgInfo **) &_udisks_manager_method_info_get_block_devices_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_manager_method_info_get_block_devices_OUT_ARG_pointers,
    NULL
  },
  "handle-get-block-devices",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_resolve_device_IN_ARG_devspec =
{
  {
    -1,
    (gchar *) "devspec",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_resolve_device_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_resolve_device_IN_ARG_pointers[] =
{
  &_udisks_manager_method_info_resolve_device_IN_ARG_devspec.parent_struct,
  &_udisks_manager_method_info_resolve_device_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_manager_method_info_resolve_device_OUT_ARG_devices =
{
  {
    -1,
    (gchar *) "devices",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_manager_method_info_resolve_device_OUT_ARG_pointers[] =
{
  &_udisks_manager_method_info_resolve_device_OUT_ARG_devices.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_manager_method_info_resolve_device =
{
  {
    -1,
    (gchar *) "ResolveDevice",
    (GDBusArgInfo **) &_udisks_manager_method_info_resolve_device_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_manager_method_info_resolve_device_OUT_ARG_pointers,
    NULL
  },
  "handle-resolve-device",
  FALSE
};

static const GDBusMethodInfo * const _udisks_manager_method_info_pointers[] =
{
  &_udisks_manager_method_info_can_format.parent_struct,
  &_udisks_manager_method_info_can_resize.parent_struct,
  &_udisks_manager_method_info_can_check.parent_struct,
  &_udisks_manager_method_info_can_repair.parent_struct,
  &_udisks_manager_method_info_loop_setup.parent_struct,
  &_udisks_manager_method_info_mdraid_create.parent_struct,
  &_udisks_manager_method_info_enable_modules.parent_struct,
  &_udisks_manager_method_info_enable_module.parent_struct,
  &_udisks_manager_method_info_get_block_devices.parent_struct,
  &_udisks_manager_method_info_resolve_device.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _udisks_manager_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_manager_property_info_supported_filesystems =
{
  {
    -1,
    (gchar *) "SupportedFilesystems",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-filesystems",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_manager_property_info_supported_encryption_types =
{
  {
    -1,
    (gchar *) "SupportedEncryptionTypes",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-encryption-types",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_manager_property_info_default_encryption_type =
{
  {
    -1,
    (gchar *) "DefaultEncryptionType",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "default-encryption-type",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _udisks_manager_property_info_pointers[] =
{
  &_udisks_manager_property_info_version.parent_struct,
  &_udisks_manager_property_info_supported_filesystems.parent_struct,
  &_udisks_manager_property_info_supported_encryption_types.parent_struct,
  &_udisks_manager_property_info_default_encryption_type.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _udisks_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.UDisks2.Manager",
    (GDBusMethodInfo **) &_udisks_manager_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_udisks_manager_property_info_pointers,
    NULL
  },
  "manager",
};


/**
 * udisks_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Manager.top_of_page">org.freedesktop.UDisks2.Manager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
udisks_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_udisks_manager_interface_info.parent_struct;
}

/**
 * udisks_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #UDisksManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
udisks_manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  g_object_class_override_property (klass, property_id_begin++, "supported-filesystems");
  g_object_class_override_property (klass, property_id_begin++, "supported-encryption-types");
  g_object_class_override_property (klass, property_id_begin++, "default-encryption-type");
  return property_id_begin - 1;
}



/**
 * UDisksManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Manager.top_of_page">org.freedesktop.UDisks2.Manager</link>.
 */

/**
 * UDisksManagerIface:
 * @parent_iface: The parent interface.
 * @handle_enable_modules: Handler for the #UDisksManager::handle-enable-modules signal.
 * @handle_loop_setup: Handler for the #UDisksManager::handle-loop-setup signal.
 * @get_default_encryption_type: Getter for the #UDisksManager:default-encryption-type property.
 * @get_supported_encryption_types: Getter for the #UDisksManager:supported-encryption-types property.
 * @get_supported_filesystems: Getter for the #UDisksManager:supported-filesystems property.
 * @get_version: Getter for the #UDisksManager:version property.
 * @handle_mdraid_create: Handler for the #UDisksManager::handle-mdraid-create signal.
 * @handle_can_check: Handler for the #UDisksManager::handle-can-check signal.
 * @handle_can_format: Handler for the #UDisksManager::handle-can-format signal.
 * @handle_can_repair: Handler for the #UDisksManager::handle-can-repair signal.
 * @handle_can_resize: Handler for the #UDisksManager::handle-can-resize signal.
 * @handle_get_block_devices: Handler for the #UDisksManager::handle-get-block-devices signal.
 * @handle_resolve_device: Handler for the #UDisksManager::handle-resolve-device signal.
 * @handle_enable_module: Handler for the #UDisksManager::handle-enable-module signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Manager.top_of_page">org.freedesktop.UDisks2.Manager</link>.
 */

typedef UDisksManagerIface UDisksManagerInterface;
G_DEFINE_INTERFACE (UDisksManager, udisks_manager, G_TYPE_OBJECT)

static void
udisks_manager_default_init (UDisksManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * UDisksManager::handle-can-format:
   * @object: A #UDisksManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanFormat">CanFormat()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_manager_complete_can_format() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.7.2
   */
  g_signal_new ("handle-can-format",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksManagerIface, handle_can_format),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * UDisksManager::handle-can-resize:
   * @object: A #UDisksManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanResize">CanResize()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_manager_complete_can_resize() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.7.2
   */
  g_signal_new ("handle-can-resize",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksManagerIface, handle_can_resize),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * UDisksManager::handle-can-check:
   * @object: A #UDisksManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanCheck">CanCheck()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_manager_complete_can_check() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.7.2
   */
  g_signal_new ("handle-can-check",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksManagerIface, handle_can_check),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * UDisksManager::handle-can-repair:
   * @object: A #UDisksManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanRepair">CanRepair()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_manager_complete_can_repair() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.7.2
   */
  g_signal_new ("handle-can-repair",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksManagerIface, handle_can_repair),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * UDisksManager::handle-loop-setup:
   * @object: A #UDisksManager.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_fd: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.LoopSetup">LoopSetup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_manager_complete_loop_setup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-loop-setup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksManagerIface, handle_loop_setup),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * UDisksManager::handle-mdraid-create:
   * @object: A #UDisksManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_blocks: Argument passed by remote caller.
   * @arg_level: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   * @arg_chunk: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.MDRaidCreate">MDRaidCreate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_manager_complete_mdraid_create() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.0.0
   */
  g_signal_new ("handle-mdraid-create",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksManagerIface, handle_mdraid_create),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT64, G_TYPE_VARIANT);

  /**
   * UDisksManager::handle-enable-modules:
   * @object: A #UDisksManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_enable: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.EnableModules">EnableModules()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_manager_complete_enable_modules() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Deprecated: The D-Bus method has been deprecated.
   */
  g_signal_new ("handle-enable-modules",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksManagerIface, handle_enable_modules),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * UDisksManager::handle-enable-module:
   * @object: A #UDisksManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_enable: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.EnableModule">EnableModule()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_manager_complete_enable_module() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.9.0
   */
  g_signal_new ("handle-enable-module",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksManagerIface, handle_enable_module),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * UDisksManager::handle-get-block-devices:
   * @object: A #UDisksManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.GetBlockDevices">GetBlockDevices()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_manager_complete_get_block_devices() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.7.2
   */
  g_signal_new ("handle-get-block-devices",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksManagerIface, handle_get_block_devices),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksManager::handle-resolve-device:
   * @object: A #UDisksManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_devspec: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.ResolveDevice">ResolveDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_manager_complete_resolve_device() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.7.3
   */
  g_signal_new ("handle-resolve-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksManagerIface, handle_resolve_device),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * UDisksManager:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("version", "Version", "Version", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksManager:supported-filesystems:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.SupportedFilesystems">"SupportedFilesystems"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("supported-filesystems", "SupportedFilesystems", "SupportedFilesystems", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksManager:supported-encryption-types:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.SupportedEncryptionTypes">"SupportedEncryptionTypes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("supported-encryption-types", "SupportedEncryptionTypes", "SupportedEncryptionTypes", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksManager:default-encryption-type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.DefaultEncryptionType">"DefaultEncryptionType"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("default-encryption-type", "DefaultEncryptionType", "DefaultEncryptionType", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * udisks_manager_get_version: (skip)
 * @object: A #UDisksManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_manager_dup_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_manager_get_version (UDisksManager *object)
{
  return UDISKS_MANAGER_GET_IFACE (object)->get_version (object);
}

/**
 * udisks_manager_dup_version: (skip)
 * @object: A #UDisksManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_manager_dup_version (UDisksManager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "version", &value, NULL);
  return value;
}

/**
 * udisks_manager_set_version: (skip)
 * @object: A #UDisksManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_manager_set_version (UDisksManager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * udisks_manager_get_supported_filesystems: (skip)
 * @object: A #UDisksManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.SupportedFilesystems">"SupportedFilesystems"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_manager_dup_supported_filesystems() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
udisks_manager_get_supported_filesystems (UDisksManager *object)
{
  return UDISKS_MANAGER_GET_IFACE (object)->get_supported_filesystems (object);
}

/**
 * udisks_manager_dup_supported_filesystems: (skip)
 * @object: A #UDisksManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.SupportedFilesystems">"SupportedFilesystems"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
udisks_manager_dup_supported_filesystems (UDisksManager *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "supported-filesystems", &value, NULL);
  return value;
}

/**
 * udisks_manager_set_supported_filesystems: (skip)
 * @object: A #UDisksManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.SupportedFilesystems">"SupportedFilesystems"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_manager_set_supported_filesystems (UDisksManager *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "supported-filesystems", value, NULL);
}

/**
 * udisks_manager_get_supported_encryption_types: (skip)
 * @object: A #UDisksManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.SupportedEncryptionTypes">"SupportedEncryptionTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_manager_dup_supported_encryption_types() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
udisks_manager_get_supported_encryption_types (UDisksManager *object)
{
  return UDISKS_MANAGER_GET_IFACE (object)->get_supported_encryption_types (object);
}

/**
 * udisks_manager_dup_supported_encryption_types: (skip)
 * @object: A #UDisksManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.SupportedEncryptionTypes">"SupportedEncryptionTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
udisks_manager_dup_supported_encryption_types (UDisksManager *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "supported-encryption-types", &value, NULL);
  return value;
}

/**
 * udisks_manager_set_supported_encryption_types: (skip)
 * @object: A #UDisksManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.SupportedEncryptionTypes">"SupportedEncryptionTypes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_manager_set_supported_encryption_types (UDisksManager *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "supported-encryption-types", value, NULL);
}

/**
 * udisks_manager_get_default_encryption_type: (skip)
 * @object: A #UDisksManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.DefaultEncryptionType">"DefaultEncryptionType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_manager_dup_default_encryption_type() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_manager_get_default_encryption_type (UDisksManager *object)
{
  return UDISKS_MANAGER_GET_IFACE (object)->get_default_encryption_type (object);
}

/**
 * udisks_manager_dup_default_encryption_type: (skip)
 * @object: A #UDisksManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.DefaultEncryptionType">"DefaultEncryptionType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_manager_dup_default_encryption_type (UDisksManager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "default-encryption-type", &value, NULL);
  return value;
}

/**
 * udisks_manager_set_default_encryption_type: (skip)
 * @object: A #UDisksManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Manager.DefaultEncryptionType">"DefaultEncryptionType"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_manager_set_default_encryption_type (UDisksManager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "default-encryption-type", value, NULL);
}

/**
 * udisks_manager_call_can_format:
 * @proxy: A #UDisksManagerProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanFormat">CanFormat()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_manager_call_can_format_finish() to get the result of the operation.
 *
 * See udisks_manager_call_can_format_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.7.2
 */
void
udisks_manager_call_can_format (
    UDisksManager *proxy,
    const gchar *arg_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanFormat",
    g_variant_new ("(s)",
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_manager_call_can_format_finish:
 * @proxy: A #UDisksManagerProxy.
 * @out_available: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_manager_call_can_format().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_manager_call_can_format().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_manager_call_can_format_finish (
    UDisksManager *proxy,
    GVariant **out_available,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(bs))",
                 out_available);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_can_format_sync:
 * @proxy: A #UDisksManagerProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @out_available: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanFormat">CanFormat()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_manager_call_can_format() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_manager_call_can_format_sync (
    UDisksManager *proxy,
    const gchar *arg_type,
    GVariant **out_available,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanFormat",
    g_variant_new ("(s)",
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(bs))",
                 out_available);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_can_resize:
 * @proxy: A #UDisksManagerProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanResize">CanResize()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_manager_call_can_resize_finish() to get the result of the operation.
 *
 * See udisks_manager_call_can_resize_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.7.2
 */
void
udisks_manager_call_can_resize (
    UDisksManager *proxy,
    const gchar *arg_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanResize",
    g_variant_new ("(s)",
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_manager_call_can_resize_finish:
 * @proxy: A #UDisksManagerProxy.
 * @out_available: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_manager_call_can_resize().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_manager_call_can_resize().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_manager_call_can_resize_finish (
    UDisksManager *proxy,
    GVariant **out_available,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(bts))",
                 out_available);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_can_resize_sync:
 * @proxy: A #UDisksManagerProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @out_available: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanResize">CanResize()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_manager_call_can_resize() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_manager_call_can_resize_sync (
    UDisksManager *proxy,
    const gchar *arg_type,
    GVariant **out_available,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanResize",
    g_variant_new ("(s)",
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(bts))",
                 out_available);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_can_check:
 * @proxy: A #UDisksManagerProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanCheck">CanCheck()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_manager_call_can_check_finish() to get the result of the operation.
 *
 * See udisks_manager_call_can_check_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.7.2
 */
void
udisks_manager_call_can_check (
    UDisksManager *proxy,
    const gchar *arg_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanCheck",
    g_variant_new ("(s)",
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_manager_call_can_check_finish:
 * @proxy: A #UDisksManagerProxy.
 * @out_available: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_manager_call_can_check().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_manager_call_can_check().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_manager_call_can_check_finish (
    UDisksManager *proxy,
    GVariant **out_available,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(bs))",
                 out_available);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_can_check_sync:
 * @proxy: A #UDisksManagerProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @out_available: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanCheck">CanCheck()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_manager_call_can_check() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_manager_call_can_check_sync (
    UDisksManager *proxy,
    const gchar *arg_type,
    GVariant **out_available,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanCheck",
    g_variant_new ("(s)",
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(bs))",
                 out_available);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_can_repair:
 * @proxy: A #UDisksManagerProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanRepair">CanRepair()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_manager_call_can_repair_finish() to get the result of the operation.
 *
 * See udisks_manager_call_can_repair_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.7.2
 */
void
udisks_manager_call_can_repair (
    UDisksManager *proxy,
    const gchar *arg_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanRepair",
    g_variant_new ("(s)",
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_manager_call_can_repair_finish:
 * @proxy: A #UDisksManagerProxy.
 * @out_available: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_manager_call_can_repair().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_manager_call_can_repair().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_manager_call_can_repair_finish (
    UDisksManager *proxy,
    GVariant **out_available,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(bs))",
                 out_available);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_can_repair_sync:
 * @proxy: A #UDisksManagerProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @out_available: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanRepair">CanRepair()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_manager_call_can_repair() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_manager_call_can_repair_sync (
    UDisksManager *proxy,
    const gchar *arg_type,
    GVariant **out_available,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanRepair",
    g_variant_new ("(s)",
                   arg_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(bs))",
                 out_available);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_loop_setup:
 * @proxy: A #UDisksManagerProxy.
 * @arg_fd: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.LoopSetup">LoopSetup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_manager_call_loop_setup_finish() to get the result of the operation.
 *
 * See udisks_manager_call_loop_setup_sync() for the synchronous, blocking version of this method.
 */
void
udisks_manager_call_loop_setup (
    UDisksManager *proxy,
    GVariant *arg_fd,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "LoopSetup",
    g_variant_new ("(@h@a{sv})",
                   arg_fd,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_manager_call_loop_setup_finish:
 * @proxy: A #UDisksManagerProxy.
 * @out_resulting_device: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_manager_call_loop_setup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_manager_call_loop_setup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_manager_call_loop_setup_finish (
    UDisksManager *proxy,
    gchar **out_resulting_device,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_resulting_device);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_loop_setup_sync:
 * @proxy: A #UDisksManagerProxy.
 * @arg_fd: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_resulting_device: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.LoopSetup">LoopSetup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_manager_call_loop_setup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_manager_call_loop_setup_sync (
    UDisksManager *proxy,
    GVariant *arg_fd,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    gchar **out_resulting_device,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "LoopSetup",
    g_variant_new ("(@h@a{sv})",
                   arg_fd,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_resulting_device);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_mdraid_create:
 * @proxy: A #UDisksManagerProxy.
 * @arg_blocks: Argument to pass with the method invocation.
 * @arg_level: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_chunk: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.MDRaidCreate">MDRaidCreate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_manager_call_mdraid_create_finish() to get the result of the operation.
 *
 * See udisks_manager_call_mdraid_create_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.0.0
 */
void
udisks_manager_call_mdraid_create (
    UDisksManager *proxy,
    const gchar *const *arg_blocks,
    const gchar *arg_level,
    const gchar *arg_name,
    guint64 arg_chunk,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MDRaidCreate",
    g_variant_new ("(^aosst@a{sv})",
                   arg_blocks,
                   arg_level,
                   arg_name,
                   arg_chunk,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_manager_call_mdraid_create_finish:
 * @proxy: A #UDisksManagerProxy.
 * @out_resulting_array: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_manager_call_mdraid_create().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_manager_call_mdraid_create().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.0.0
 */
gboolean
udisks_manager_call_mdraid_create_finish (
    UDisksManager *proxy,
    gchar **out_resulting_array,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_resulting_array);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_mdraid_create_sync:
 * @proxy: A #UDisksManagerProxy.
 * @arg_blocks: Argument to pass with the method invocation.
 * @arg_level: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_chunk: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_resulting_array: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.MDRaidCreate">MDRaidCreate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_manager_call_mdraid_create() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.0.0
 */
gboolean
udisks_manager_call_mdraid_create_sync (
    UDisksManager *proxy,
    const gchar *const *arg_blocks,
    const gchar *arg_level,
    const gchar *arg_name,
    guint64 arg_chunk,
    GVariant *arg_options,
    gchar **out_resulting_array,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MDRaidCreate",
    g_variant_new ("(^aosst@a{sv})",
                   arg_blocks,
                   arg_level,
                   arg_name,
                   arg_chunk,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_resulting_array);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_enable_modules:
 * @proxy: A #UDisksManagerProxy.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.EnableModules">EnableModules()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_manager_call_enable_modules_finish() to get the result of the operation.
 *
 * See udisks_manager_call_enable_modules_sync() for the synchronous, blocking version of this method.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
udisks_manager_call_enable_modules (
    UDisksManager *proxy,
    gboolean arg_enable,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnableModules",
    g_variant_new ("(b)",
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_manager_call_enable_modules_finish:
 * @proxy: A #UDisksManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_manager_call_enable_modules().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_manager_call_enable_modules().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
udisks_manager_call_enable_modules_finish (
    UDisksManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_enable_modules_sync:
 * @proxy: A #UDisksManagerProxy.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.EnableModules">EnableModules()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_manager_call_enable_modules() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
gboolean
udisks_manager_call_enable_modules_sync (
    UDisksManager *proxy,
    gboolean arg_enable,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnableModules",
    g_variant_new ("(b)",
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_enable_module:
 * @proxy: A #UDisksManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.EnableModule">EnableModule()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_manager_call_enable_module_finish() to get the result of the operation.
 *
 * See udisks_manager_call_enable_module_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.9.0
 */
void
udisks_manager_call_enable_module (
    UDisksManager *proxy,
    const gchar *arg_name,
    gboolean arg_enable,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnableModule",
    g_variant_new ("(sb)",
                   arg_name,
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_manager_call_enable_module_finish:
 * @proxy: A #UDisksManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_manager_call_enable_module().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_manager_call_enable_module().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.9.0
 */
gboolean
udisks_manager_call_enable_module_finish (
    UDisksManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_enable_module_sync:
 * @proxy: A #UDisksManagerProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.EnableModule">EnableModule()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_manager_call_enable_module() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.9.0
 */
gboolean
udisks_manager_call_enable_module_sync (
    UDisksManager *proxy,
    const gchar *arg_name,
    gboolean arg_enable,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnableModule",
    g_variant_new ("(sb)",
                   arg_name,
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_get_block_devices:
 * @proxy: A #UDisksManagerProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.GetBlockDevices">GetBlockDevices()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_manager_call_get_block_devices_finish() to get the result of the operation.
 *
 * See udisks_manager_call_get_block_devices_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.7.2
 */
void
udisks_manager_call_get_block_devices (
    UDisksManager *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetBlockDevices",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_manager_call_get_block_devices_finish:
 * @proxy: A #UDisksManagerProxy.
 * @out_block_objects: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_manager_call_get_block_devices().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_manager_call_get_block_devices().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_manager_call_get_block_devices_finish (
    UDisksManager *proxy,
    gchar ***out_block_objects,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_block_objects);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_get_block_devices_sync:
 * @proxy: A #UDisksManagerProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_block_objects: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.GetBlockDevices">GetBlockDevices()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_manager_call_get_block_devices() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_manager_call_get_block_devices_sync (
    UDisksManager *proxy,
    GVariant *arg_options,
    gchar ***out_block_objects,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetBlockDevices",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_block_objects);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_resolve_device:
 * @proxy: A #UDisksManagerProxy.
 * @arg_devspec: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.ResolveDevice">ResolveDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_manager_call_resolve_device_finish() to get the result of the operation.
 *
 * See udisks_manager_call_resolve_device_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.7.3
 */
void
udisks_manager_call_resolve_device (
    UDisksManager *proxy,
    GVariant *arg_devspec,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ResolveDevice",
    g_variant_new ("(@a{sv}@a{sv})",
                   arg_devspec,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_manager_call_resolve_device_finish:
 * @proxy: A #UDisksManagerProxy.
 * @out_devices: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_manager_call_resolve_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_manager_call_resolve_device().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.3
 */
gboolean
udisks_manager_call_resolve_device_finish (
    UDisksManager *proxy,
    gchar ***out_devices,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_devices);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_call_resolve_device_sync:
 * @proxy: A #UDisksManagerProxy.
 * @arg_devspec: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_devices: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.ResolveDevice">ResolveDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_manager_call_resolve_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.3
 */
gboolean
udisks_manager_call_resolve_device_sync (
    UDisksManager *proxy,
    GVariant *arg_devspec,
    GVariant *arg_options,
    gchar ***out_devices,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ResolveDevice",
    g_variant_new ("(@a{sv}@a{sv})",
                   arg_devspec,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_devices);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_manager_complete_can_format:
 * @object: A #UDisksManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @available: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanFormat">CanFormat()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.7.2
 */
void
udisks_manager_complete_can_format (
    UDisksManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *available)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@(bs))",
                   available));
}

/**
 * udisks_manager_complete_can_resize:
 * @object: A #UDisksManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @available: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanResize">CanResize()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.7.2
 */
void
udisks_manager_complete_can_resize (
    UDisksManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *available)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@(bts))",
                   available));
}

/**
 * udisks_manager_complete_can_check:
 * @object: A #UDisksManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @available: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanCheck">CanCheck()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.7.2
 */
void
udisks_manager_complete_can_check (
    UDisksManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *available)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@(bs))",
                   available));
}

/**
 * udisks_manager_complete_can_repair:
 * @object: A #UDisksManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @available: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.CanRepair">CanRepair()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.7.2
 */
void
udisks_manager_complete_can_repair (
    UDisksManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *available)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@(bs))",
                   available));
}

/**
 * udisks_manager_complete_loop_setup:
 * @object: A #UDisksManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @resulting_device: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.LoopSetup">LoopSetup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_manager_complete_loop_setup (
    UDisksManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    const gchar *resulting_device)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(o)",
                   resulting_device),
    fd_list);
}

/**
 * udisks_manager_complete_mdraid_create:
 * @object: A #UDisksManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @resulting_array: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.MDRaidCreate">MDRaidCreate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.0.0
 */
void
udisks_manager_complete_mdraid_create (
    UDisksManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *resulting_array)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   resulting_array));
}

/**
 * udisks_manager_complete_enable_modules:
 * @object: A #UDisksManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.EnableModules">EnableModules()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Deprecated: The D-Bus method has been deprecated.
 */
void
udisks_manager_complete_enable_modules (
    UDisksManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_manager_complete_enable_module:
 * @object: A #UDisksManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.EnableModule">EnableModule()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.9.0
 */
void
udisks_manager_complete_enable_module (
    UDisksManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_manager_complete_get_block_devices:
 * @object: A #UDisksManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @block_objects: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.GetBlockDevices">GetBlockDevices()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.7.2
 */
void
udisks_manager_complete_get_block_devices (
    UDisksManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *block_objects)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   block_objects));
}

/**
 * udisks_manager_complete_resolve_device:
 * @object: A #UDisksManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @devices: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Manager.ResolveDevice">ResolveDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.7.3
 */
void
udisks_manager_complete_resolve_device (
    UDisksManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *devices)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   devices));
}

/* ------------------------------------------------------------------------ */

/**
 * UDisksManagerProxy:
 *
 * The #UDisksManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksManagerProxy.
 */

struct _UDisksManagerProxyPrivate
{
  GData *qdata;
};

static void udisks_manager_proxy_iface_init (UDisksManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksManagerProxy, udisks_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (UDisksManagerProxy)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_MANAGER, udisks_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksManagerProxy, udisks_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_MANAGER, udisks_manager_proxy_iface_init))

#endif
static void
udisks_manager_proxy_finalize (GObject *object)
{
  UDisksManagerProxy *proxy = UDISKS_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (udisks_manager_proxy_parent_class)->finalize (object);
}

static void
udisks_manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
udisks_manager_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.UDisks2.Manager: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
udisks_manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.UDisks2.Manager", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) udisks_manager_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
udisks_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_udisks_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], UDISKS_TYPE_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
udisks_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  UDisksManagerProxy *proxy = UDISKS_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
udisks_manager_proxy_get_version (UDisksManager *object)
{
  UDisksManagerProxy *proxy = UDISKS_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
udisks_manager_proxy_get_supported_filesystems (UDisksManager *object)
{
  UDisksManagerProxy *proxy = UDISKS_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "SupportedFilesystems");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedFilesystems");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "SupportedFilesystems", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
udisks_manager_proxy_get_supported_encryption_types (UDisksManager *object)
{
  UDisksManagerProxy *proxy = UDISKS_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "SupportedEncryptionTypes");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedEncryptionTypes");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "SupportedEncryptionTypes", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_manager_proxy_get_default_encryption_type (UDisksManager *object)
{
  UDisksManagerProxy *proxy = UDISKS_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultEncryptionType");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
udisks_manager_proxy_init (UDisksManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = udisks_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, UDISKS_TYPE_MANAGER_PROXY, UDisksManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), udisks_manager_interface_info ());
}

static void
udisks_manager_proxy_class_init (UDisksManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = udisks_manager_proxy_finalize;
  gobject_class->get_property = udisks_manager_proxy_get_property;
  gobject_class->set_property = udisks_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = udisks_manager_proxy_g_signal;
  proxy_class->g_properties_changed = udisks_manager_proxy_g_properties_changed;

  udisks_manager_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksManagerProxyPrivate));
#endif
}

static void
udisks_manager_proxy_iface_init (UDisksManagerIface *iface)
{
  iface->get_version = udisks_manager_proxy_get_version;
  iface->get_supported_filesystems = udisks_manager_proxy_get_supported_filesystems;
  iface->get_supported_encryption_types = udisks_manager_proxy_get_supported_encryption_types;
  iface->get_default_encryption_type = udisks_manager_proxy_get_default_encryption_type;
}

/**
 * udisks_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Manager.top_of_page">org.freedesktop.UDisks2.Manager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_manager_proxy_new_finish() to get the result of the operation.
 *
 * See udisks_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Manager", NULL);
}

/**
 * udisks_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_manager_proxy_new().
 *
 * Returns: (transfer full) (type UDisksManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksManager *
udisks_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_MANAGER (ret);
  else
    return NULL;
}

/**
 * udisks_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Manager.top_of_page">org.freedesktop.UDisks2.Manager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksManager *
udisks_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Manager", NULL);
  if (ret != NULL)
    return UDISKS_MANAGER (ret);
  else
    return NULL;
}


/**
 * udisks_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like udisks_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See udisks_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Manager", NULL);
}

/**
 * udisks_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type UDisksManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksManager *
udisks_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_MANAGER (ret);
  else
    return NULL;
}

/**
 * udisks_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like udisks_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksManager *
udisks_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Manager", NULL);
  if (ret != NULL)
    return UDISKS_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * UDisksManagerSkeleton:
 *
 * The #UDisksManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksManagerSkeleton.
 */

struct _UDisksManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_udisks_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], UDISKS_TYPE_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_udisks_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_udisks_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _udisks_manager_skeleton_vtable =
{
  _udisks_manager_skeleton_handle_method_call,
  _udisks_manager_skeleton_handle_get_property,
  _udisks_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
udisks_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return udisks_manager_interface_info ();
}

static GDBusInterfaceVTable *
udisks_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_udisks_manager_skeleton_vtable;
}

static GVariant *
udisks_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_udisks_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _udisks_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _udisks_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _udisks_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.UDisks2.Manager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _udisks_manager_emit_changed (gpointer user_data);

static void
udisks_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _udisks_manager_emit_changed (skeleton);
}

static void udisks_manager_skeleton_iface_init (UDisksManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksManagerSkeleton, udisks_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (UDisksManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_MANAGER, udisks_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksManagerSkeleton, udisks_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_MANAGER, udisks_manager_skeleton_iface_init))

#endif
static void
udisks_manager_skeleton_finalize (GObject *object)
{
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (object);
  guint n;
  for (n = 0; n < 4; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (udisks_manager_skeleton_parent_class)->finalize (object);
}

static void
udisks_manager_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_udisks_manager_emit_changed (gpointer user_data)
{
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.UDisks2.Manager",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_udisks_manager_schedule_emit_changed (UDisksManagerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
udisks_manager_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _udisks_manager_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _udisks_manager_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
udisks_manager_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_manager_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _udisks_manager_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
udisks_manager_skeleton_init (UDisksManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = udisks_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, UDISKS_TYPE_MANAGER_SKELETON, UDisksManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 4);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
}

static const gchar *
udisks_manager_skeleton_get_version (UDisksManager *object)
{
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
udisks_manager_skeleton_get_supported_filesystems (UDisksManager *object)
{
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
udisks_manager_skeleton_get_supported_encryption_types (UDisksManager *object)
{
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_manager_skeleton_get_default_encryption_type (UDisksManager *object)
{
  UDisksManagerSkeleton *skeleton = UDISKS_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
udisks_manager_skeleton_class_init (UDisksManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = udisks_manager_skeleton_finalize;
  gobject_class->get_property = udisks_manager_skeleton_get_property;
  gobject_class->set_property = udisks_manager_skeleton_set_property;
  gobject_class->notify       = udisks_manager_skeleton_notify;


  udisks_manager_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = udisks_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = udisks_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = udisks_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = udisks_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksManagerSkeletonPrivate));
#endif
}

static void
udisks_manager_skeleton_iface_init (UDisksManagerIface *iface)
{
  iface->get_version = udisks_manager_skeleton_get_version;
  iface->get_supported_filesystems = udisks_manager_skeleton_get_supported_filesystems;
  iface->get_supported_encryption_types = udisks_manager_skeleton_get_supported_encryption_types;
  iface->get_default_encryption_type = udisks_manager_skeleton_get_default_encryption_type;
}

/**
 * udisks_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Manager.top_of_page">org.freedesktop.UDisks2.Manager</link>.
 *
 * Returns: (transfer full) (type UDisksManagerSkeleton): The skeleton object.
 */
UDisksManager *
udisks_manager_skeleton_new (void)
{
  return UDISKS_MANAGER (g_object_new (UDISKS_TYPE_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.UDisks2.Drive
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:UDisksDrive
 * @title: UDisksDrive
 * @short_description: Generated C code for the org.freedesktop.UDisks2.Drive D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive.top_of_page">org.freedesktop.UDisks2.Drive</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.UDisks2.Drive ---- */

static const _ExtendedGDBusArgInfo _udisks_drive_method_info_eject_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_method_info_eject_IN_ARG_pointers[] =
{
  &_udisks_drive_method_info_eject_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_drive_method_info_eject =
{
  {
    -1,
    (gchar *) "Eject",
    (GDBusArgInfo **) &_udisks_drive_method_info_eject_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-eject",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_drive_method_info_set_configuration_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_drive_method_info_set_configuration_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_method_info_set_configuration_IN_ARG_pointers[] =
{
  &_udisks_drive_method_info_set_configuration_IN_ARG_value.parent_struct,
  &_udisks_drive_method_info_set_configuration_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_drive_method_info_set_configuration =
{
  {
    -1,
    (gchar *) "SetConfiguration",
    (GDBusArgInfo **) &_udisks_drive_method_info_set_configuration_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-configuration",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_drive_method_info_power_off_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_method_info_power_off_IN_ARG_pointers[] =
{
  &_udisks_drive_method_info_power_off_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_drive_method_info_power_off =
{
  {
    -1,
    (gchar *) "PowerOff",
    (GDBusArgInfo **) &_udisks_drive_method_info_power_off_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-power-off",
  FALSE
};

static const GDBusMethodInfo * const _udisks_drive_method_info_pointers[] =
{
  &_udisks_drive_method_info_eject.parent_struct,
  &_udisks_drive_method_info_set_configuration.parent_struct,
  &_udisks_drive_method_info_power_off.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_vendor =
{
  {
    -1,
    (gchar *) "Vendor",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "vendor",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_model =
{
  {
    -1,
    (gchar *) "Model",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "model",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_revision =
{
  {
    -1,
    (gchar *) "Revision",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "revision",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_serial =
{
  {
    -1,
    (gchar *) "Serial",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "serial",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_wwn =
{
  {
    -1,
    (gchar *) "WWN",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "wwn",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_id =
{
  {
    -1,
    (gchar *) "Id",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "id",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_configuration =
{
  {
    -1,
    (gchar *) "Configuration",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "configuration",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_media =
{
  {
    -1,
    (gchar *) "Media",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "media",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_media_compatibility =
{
  {
    -1,
    (gchar *) "MediaCompatibility",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "media-compatibility",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_media_removable =
{
  {
    -1,
    (gchar *) "MediaRemovable",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "media-removable",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_media_available =
{
  {
    -1,
    (gchar *) "MediaAvailable",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "media-available",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_media_change_detected =
{
  {
    -1,
    (gchar *) "MediaChangeDetected",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "media-change-detected",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_size =
{
  {
    -1,
    (gchar *) "Size",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "size",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_time_detected =
{
  {
    -1,
    (gchar *) "TimeDetected",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "time-detected",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_time_media_detected =
{
  {
    -1,
    (gchar *) "TimeMediaDetected",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "time-media-detected",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_optical =
{
  {
    -1,
    (gchar *) "Optical",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "optical",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_optical_blank =
{
  {
    -1,
    (gchar *) "OpticalBlank",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "optical-blank",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_optical_num_tracks =
{
  {
    -1,
    (gchar *) "OpticalNumTracks",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "optical-num-tracks",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_optical_num_audio_tracks =
{
  {
    -1,
    (gchar *) "OpticalNumAudioTracks",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "optical-num-audio-tracks",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_optical_num_data_tracks =
{
  {
    -1,
    (gchar *) "OpticalNumDataTracks",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "optical-num-data-tracks",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_optical_num_sessions =
{
  {
    -1,
    (gchar *) "OpticalNumSessions",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "optical-num-sessions",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_rotation_rate =
{
  {
    -1,
    (gchar *) "RotationRate",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "rotation-rate",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_connection_bus =
{
  {
    -1,
    (gchar *) "ConnectionBus",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "connection-bus",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_seat =
{
  {
    -1,
    (gchar *) "Seat",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "seat",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_removable =
{
  {
    -1,
    (gchar *) "Removable",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "removable",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_ejectable =
{
  {
    -1,
    (gchar *) "Ejectable",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "ejectable",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_sort_key =
{
  {
    -1,
    (gchar *) "SortKey",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "sort-key",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_can_power_off =
{
  {
    -1,
    (gchar *) "CanPowerOff",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-power-off",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_property_info_sibling_id =
{
  {
    -1,
    (gchar *) "SiblingId",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "sibling-id",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _udisks_drive_property_info_pointers[] =
{
  &_udisks_drive_property_info_vendor.parent_struct,
  &_udisks_drive_property_info_model.parent_struct,
  &_udisks_drive_property_info_revision.parent_struct,
  &_udisks_drive_property_info_serial.parent_struct,
  &_udisks_drive_property_info_wwn.parent_struct,
  &_udisks_drive_property_info_id.parent_struct,
  &_udisks_drive_property_info_configuration.parent_struct,
  &_udisks_drive_property_info_media.parent_struct,
  &_udisks_drive_property_info_media_compatibility.parent_struct,
  &_udisks_drive_property_info_media_removable.parent_struct,
  &_udisks_drive_property_info_media_available.parent_struct,
  &_udisks_drive_property_info_media_change_detected.parent_struct,
  &_udisks_drive_property_info_size.parent_struct,
  &_udisks_drive_property_info_time_detected.parent_struct,
  &_udisks_drive_property_info_time_media_detected.parent_struct,
  &_udisks_drive_property_info_optical.parent_struct,
  &_udisks_drive_property_info_optical_blank.parent_struct,
  &_udisks_drive_property_info_optical_num_tracks.parent_struct,
  &_udisks_drive_property_info_optical_num_audio_tracks.parent_struct,
  &_udisks_drive_property_info_optical_num_data_tracks.parent_struct,
  &_udisks_drive_property_info_optical_num_sessions.parent_struct,
  &_udisks_drive_property_info_rotation_rate.parent_struct,
  &_udisks_drive_property_info_connection_bus.parent_struct,
  &_udisks_drive_property_info_seat.parent_struct,
  &_udisks_drive_property_info_removable.parent_struct,
  &_udisks_drive_property_info_ejectable.parent_struct,
  &_udisks_drive_property_info_sort_key.parent_struct,
  &_udisks_drive_property_info_can_power_off.parent_struct,
  &_udisks_drive_property_info_sibling_id.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _udisks_drive_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.UDisks2.Drive",
    (GDBusMethodInfo **) &_udisks_drive_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_udisks_drive_property_info_pointers,
    NULL
  },
  "drive",
};


/**
 * udisks_drive_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive.top_of_page">org.freedesktop.UDisks2.Drive</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
udisks_drive_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_udisks_drive_interface_info.parent_struct;
}

/**
 * udisks_drive_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #UDisksDrive interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
udisks_drive_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "vendor");
  g_object_class_override_property (klass, property_id_begin++, "model");
  g_object_class_override_property (klass, property_id_begin++, "revision");
  g_object_class_override_property (klass, property_id_begin++, "serial");
  g_object_class_override_property (klass, property_id_begin++, "wwn");
  g_object_class_override_property (klass, property_id_begin++, "id");
  g_object_class_override_property (klass, property_id_begin++, "configuration");
  g_object_class_override_property (klass, property_id_begin++, "media");
  g_object_class_override_property (klass, property_id_begin++, "media-compatibility");
  g_object_class_override_property (klass, property_id_begin++, "media-removable");
  g_object_class_override_property (klass, property_id_begin++, "media-available");
  g_object_class_override_property (klass, property_id_begin++, "media-change-detected");
  g_object_class_override_property (klass, property_id_begin++, "size");
  g_object_class_override_property (klass, property_id_begin++, "time-detected");
  g_object_class_override_property (klass, property_id_begin++, "time-media-detected");
  g_object_class_override_property (klass, property_id_begin++, "optical");
  g_object_class_override_property (klass, property_id_begin++, "optical-blank");
  g_object_class_override_property (klass, property_id_begin++, "optical-num-tracks");
  g_object_class_override_property (klass, property_id_begin++, "optical-num-audio-tracks");
  g_object_class_override_property (klass, property_id_begin++, "optical-num-data-tracks");
  g_object_class_override_property (klass, property_id_begin++, "optical-num-sessions");
  g_object_class_override_property (klass, property_id_begin++, "rotation-rate");
  g_object_class_override_property (klass, property_id_begin++, "connection-bus");
  g_object_class_override_property (klass, property_id_begin++, "seat");
  g_object_class_override_property (klass, property_id_begin++, "removable");
  g_object_class_override_property (klass, property_id_begin++, "ejectable");
  g_object_class_override_property (klass, property_id_begin++, "sort-key");
  g_object_class_override_property (klass, property_id_begin++, "can-power-off");
  g_object_class_override_property (klass, property_id_begin++, "sibling-id");
  return property_id_begin - 1;
}



/**
 * UDisksDrive:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive.top_of_page">org.freedesktop.UDisks2.Drive</link>.
 */

/**
 * UDisksDriveIface:
 * @parent_iface: The parent interface.
 * @handle_eject: Handler for the #UDisksDrive::handle-eject signal.
 * @handle_set_configuration: Handler for the #UDisksDrive::handle-set-configuration signal.
 * @get_configuration: Getter for the #UDisksDrive:configuration property.
 * @get_connection_bus: Getter for the #UDisksDrive:connection-bus property.
 * @get_ejectable: Getter for the #UDisksDrive:ejectable property.
 * @get_id: Getter for the #UDisksDrive:id property.
 * @get_media: Getter for the #UDisksDrive:media property.
 * @get_media_available: Getter for the #UDisksDrive:media-available property.
 * @get_media_change_detected: Getter for the #UDisksDrive:media-change-detected property.
 * @get_media_compatibility: Getter for the #UDisksDrive:media-compatibility property.
 * @get_media_removable: Getter for the #UDisksDrive:media-removable property.
 * @get_model: Getter for the #UDisksDrive:model property.
 * @get_optical: Getter for the #UDisksDrive:optical property.
 * @get_optical_blank: Getter for the #UDisksDrive:optical-blank property.
 * @get_optical_num_audio_tracks: Getter for the #UDisksDrive:optical-num-audio-tracks property.
 * @get_optical_num_data_tracks: Getter for the #UDisksDrive:optical-num-data-tracks property.
 * @get_optical_num_sessions: Getter for the #UDisksDrive:optical-num-sessions property.
 * @get_optical_num_tracks: Getter for the #UDisksDrive:optical-num-tracks property.
 * @get_removable: Getter for the #UDisksDrive:removable property.
 * @get_revision: Getter for the #UDisksDrive:revision property.
 * @get_rotation_rate: Getter for the #UDisksDrive:rotation-rate property.
 * @get_seat: Getter for the #UDisksDrive:seat property.
 * @get_serial: Getter for the #UDisksDrive:serial property.
 * @get_size: Getter for the #UDisksDrive:size property.
 * @get_sort_key: Getter for the #UDisksDrive:sort-key property.
 * @get_time_detected: Getter for the #UDisksDrive:time-detected property.
 * @get_time_media_detected: Getter for the #UDisksDrive:time-media-detected property.
 * @get_vendor: Getter for the #UDisksDrive:vendor property.
 * @get_wwn: Getter for the #UDisksDrive:wwn property.
 * @handle_power_off: Handler for the #UDisksDrive::handle-power-off signal.
 * @get_can_power_off: Getter for the #UDisksDrive:can-power-off property.
 * @get_sibling_id: Getter for the #UDisksDrive:sibling-id property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive.top_of_page">org.freedesktop.UDisks2.Drive</link>.
 */

typedef UDisksDriveIface UDisksDriveInterface;
G_DEFINE_INTERFACE (UDisksDrive, udisks_drive, G_TYPE_OBJECT)

static void
udisks_drive_default_init (UDisksDriveIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * UDisksDrive::handle-eject:
   * @object: A #UDisksDrive.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive.Eject">Eject()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_drive_complete_eject() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-eject",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksDriveIface, handle_eject),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksDrive::handle-set-configuration:
   * @object: A #UDisksDrive.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_value: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive.SetConfiguration">SetConfiguration()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_drive_complete_set_configuration() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-configuration",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksDriveIface, handle_set_configuration),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * UDisksDrive::handle-power-off:
   * @object: A #UDisksDrive.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive.PowerOff">PowerOff()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_drive_complete_power_off() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.0.0
   */
  g_signal_new ("handle-power-off",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksDriveIface, handle_power_off),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * UDisksDrive:vendor:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Vendor">"Vendor"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("vendor", "Vendor", "Vendor", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:model:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Model">"Model"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("model", "Model", "Model", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:revision:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Revision">"Revision"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("revision", "Revision", "Revision", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:serial:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Serial">"Serial"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("serial", "Serial", "Serial", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:wwn:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.WWN">"WWN"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("wwn", "WWN", "WWN", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Id">"Id"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("id", "Id", "Id", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:configuration:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Configuration">"Configuration"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("configuration", "Configuration", "Configuration", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:media:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Media">"Media"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("media", "Media", "Media", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:media-compatibility:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.MediaCompatibility">"MediaCompatibility"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("media-compatibility", "MediaCompatibility", "MediaCompatibility", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:media-removable:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.MediaRemovable">"MediaRemovable"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("media-removable", "MediaRemovable", "MediaRemovable", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:media-available:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.MediaAvailable">"MediaAvailable"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("media-available", "MediaAvailable", "MediaAvailable", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:media-change-detected:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.MediaChangeDetected">"MediaChangeDetected"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("media-change-detected", "MediaChangeDetected", "MediaChangeDetected", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:size:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Size">"Size"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("size", "Size", "Size", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:time-detected:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.TimeDetected">"TimeDetected"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("time-detected", "TimeDetected", "TimeDetected", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:time-media-detected:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.TimeMediaDetected">"TimeMediaDetected"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("time-media-detected", "TimeMediaDetected", "TimeMediaDetected", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:optical:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Optical">"Optical"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("optical", "Optical", "Optical", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:optical-blank:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalBlank">"OpticalBlank"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("optical-blank", "OpticalBlank", "OpticalBlank", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:optical-num-tracks:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalNumTracks">"OpticalNumTracks"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("optical-num-tracks", "OpticalNumTracks", "OpticalNumTracks", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:optical-num-audio-tracks:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalNumAudioTracks">"OpticalNumAudioTracks"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("optical-num-audio-tracks", "OpticalNumAudioTracks", "OpticalNumAudioTracks", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:optical-num-data-tracks:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalNumDataTracks">"OpticalNumDataTracks"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("optical-num-data-tracks", "OpticalNumDataTracks", "OpticalNumDataTracks", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:optical-num-sessions:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalNumSessions">"OpticalNumSessions"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("optical-num-sessions", "OpticalNumSessions", "OpticalNumSessions", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:rotation-rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.RotationRate">"RotationRate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("rotation-rate", "RotationRate", "RotationRate", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:connection-bus:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.ConnectionBus">"ConnectionBus"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("connection-bus", "ConnectionBus", "ConnectionBus", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:seat:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Seat">"Seat"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("seat", "Seat", "Seat", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:removable:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Removable">"Removable"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("removable", "Removable", "Removable", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:ejectable:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Ejectable">"Ejectable"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("ejectable", "Ejectable", "Ejectable", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:sort-key:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.SortKey">"SortKey"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("sort-key", "SortKey", "SortKey", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:can-power-off:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.CanPowerOff">"CanPowerOff"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 2.0.0
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-power-off", "CanPowerOff", "CanPowerOff", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDrive:sibling-id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.SiblingId">"SiblingId"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 2.0.0
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("sibling-id", "SiblingId", "SiblingId", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * udisks_drive_get_vendor: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Vendor">"Vendor"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_dup_vendor() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_drive_get_vendor (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_vendor (object);
}

/**
 * udisks_drive_dup_vendor: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Vendor">"Vendor"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_drive_dup_vendor (UDisksDrive *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "vendor", &value, NULL);
  return value;
}

/**
 * udisks_drive_set_vendor: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Vendor">"Vendor"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_vendor (UDisksDrive *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "vendor", value, NULL);
}

/**
 * udisks_drive_get_model: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Model">"Model"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_dup_model() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_drive_get_model (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_model (object);
}

/**
 * udisks_drive_dup_model: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Model">"Model"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_drive_dup_model (UDisksDrive *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "model", &value, NULL);
  return value;
}

/**
 * udisks_drive_set_model: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Model">"Model"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_model (UDisksDrive *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "model", value, NULL);
}

/**
 * udisks_drive_get_revision: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Revision">"Revision"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_dup_revision() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_drive_get_revision (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_revision (object);
}

/**
 * udisks_drive_dup_revision: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Revision">"Revision"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_drive_dup_revision (UDisksDrive *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "revision", &value, NULL);
  return value;
}

/**
 * udisks_drive_set_revision: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Revision">"Revision"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_revision (UDisksDrive *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "revision", value, NULL);
}

/**
 * udisks_drive_get_serial: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Serial">"Serial"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_dup_serial() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_drive_get_serial (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_serial (object);
}

/**
 * udisks_drive_dup_serial: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Serial">"Serial"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_drive_dup_serial (UDisksDrive *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "serial", &value, NULL);
  return value;
}

/**
 * udisks_drive_set_serial: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Serial">"Serial"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_serial (UDisksDrive *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "serial", value, NULL);
}

/**
 * udisks_drive_get_wwn: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.WWN">"WWN"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_dup_wwn() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_drive_get_wwn (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_wwn (object);
}

/**
 * udisks_drive_dup_wwn: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.WWN">"WWN"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_drive_dup_wwn (UDisksDrive *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "wwn", &value, NULL);
  return value;
}

/**
 * udisks_drive_set_wwn: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.WWN">"WWN"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_wwn (UDisksDrive *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "wwn", value, NULL);
}

/**
 * udisks_drive_get_id: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_dup_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_drive_get_id (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_id (object);
}

/**
 * udisks_drive_dup_id: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_drive_dup_id (UDisksDrive *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "id", &value, NULL);
  return value;
}

/**
 * udisks_drive_set_id: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Id">"Id"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_id (UDisksDrive *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "id", value, NULL);
}

/**
 * udisks_drive_get_configuration: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Configuration">"Configuration"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_dup_configuration() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
udisks_drive_get_configuration (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_configuration (object);
}

/**
 * udisks_drive_dup_configuration: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Configuration">"Configuration"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
udisks_drive_dup_configuration (UDisksDrive *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "configuration", &value, NULL);
  return value;
}

/**
 * udisks_drive_set_configuration: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Configuration">"Configuration"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_configuration (UDisksDrive *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "configuration", value, NULL);
}

/**
 * udisks_drive_get_media: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Media">"Media"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_dup_media() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_drive_get_media (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_media (object);
}

/**
 * udisks_drive_dup_media: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Media">"Media"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_drive_dup_media (UDisksDrive *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "media", &value, NULL);
  return value;
}

/**
 * udisks_drive_set_media: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Media">"Media"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_media (UDisksDrive *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "media", value, NULL);
}

/**
 * udisks_drive_get_media_compatibility: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.MediaCompatibility">"MediaCompatibility"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_dup_media_compatibility() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
udisks_drive_get_media_compatibility (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_media_compatibility (object);
}

/**
 * udisks_drive_dup_media_compatibility: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.MediaCompatibility">"MediaCompatibility"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
udisks_drive_dup_media_compatibility (UDisksDrive *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "media-compatibility", &value, NULL);
  return value;
}

/**
 * udisks_drive_set_media_compatibility: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.MediaCompatibility">"MediaCompatibility"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_media_compatibility (UDisksDrive *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "media-compatibility", value, NULL);
}

/**
 * udisks_drive_get_media_removable: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.MediaRemovable">"MediaRemovable"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_get_media_removable (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_media_removable (object);
}

/**
 * udisks_drive_set_media_removable: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.MediaRemovable">"MediaRemovable"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_media_removable (UDisksDrive *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "media-removable", value, NULL);
}

/**
 * udisks_drive_get_media_available: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.MediaAvailable">"MediaAvailable"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_get_media_available (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_media_available (object);
}

/**
 * udisks_drive_set_media_available: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.MediaAvailable">"MediaAvailable"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_media_available (UDisksDrive *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "media-available", value, NULL);
}

/**
 * udisks_drive_get_media_change_detected: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.MediaChangeDetected">"MediaChangeDetected"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_get_media_change_detected (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_media_change_detected (object);
}

/**
 * udisks_drive_set_media_change_detected: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.MediaChangeDetected">"MediaChangeDetected"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_media_change_detected (UDisksDrive *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "media-change-detected", value, NULL);
}

/**
 * udisks_drive_get_size: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Size">"Size"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
udisks_drive_get_size (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_size (object);
}

/**
 * udisks_drive_set_size: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Size">"Size"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_size (UDisksDrive *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "size", value, NULL);
}

/**
 * udisks_drive_get_time_detected: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.TimeDetected">"TimeDetected"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
udisks_drive_get_time_detected (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_time_detected (object);
}

/**
 * udisks_drive_set_time_detected: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.TimeDetected">"TimeDetected"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_time_detected (UDisksDrive *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "time-detected", value, NULL);
}

/**
 * udisks_drive_get_time_media_detected: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.TimeMediaDetected">"TimeMediaDetected"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
udisks_drive_get_time_media_detected (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_time_media_detected (object);
}

/**
 * udisks_drive_set_time_media_detected: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.TimeMediaDetected">"TimeMediaDetected"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_time_media_detected (UDisksDrive *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "time-media-detected", value, NULL);
}

/**
 * udisks_drive_get_optical: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Optical">"Optical"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_get_optical (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_optical (object);
}

/**
 * udisks_drive_set_optical: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Optical">"Optical"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_optical (UDisksDrive *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "optical", value, NULL);
}

/**
 * udisks_drive_get_optical_blank: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalBlank">"OpticalBlank"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_get_optical_blank (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_optical_blank (object);
}

/**
 * udisks_drive_set_optical_blank: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalBlank">"OpticalBlank"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_optical_blank (UDisksDrive *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "optical-blank", value, NULL);
}

/**
 * udisks_drive_get_optical_num_tracks: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalNumTracks">"OpticalNumTracks"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
udisks_drive_get_optical_num_tracks (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_optical_num_tracks (object);
}

/**
 * udisks_drive_set_optical_num_tracks: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalNumTracks">"OpticalNumTracks"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_optical_num_tracks (UDisksDrive *object, guint value)
{
  g_object_set (G_OBJECT (object), "optical-num-tracks", value, NULL);
}

/**
 * udisks_drive_get_optical_num_audio_tracks: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalNumAudioTracks">"OpticalNumAudioTracks"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
udisks_drive_get_optical_num_audio_tracks (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_optical_num_audio_tracks (object);
}

/**
 * udisks_drive_set_optical_num_audio_tracks: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalNumAudioTracks">"OpticalNumAudioTracks"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_optical_num_audio_tracks (UDisksDrive *object, guint value)
{
  g_object_set (G_OBJECT (object), "optical-num-audio-tracks", value, NULL);
}

/**
 * udisks_drive_get_optical_num_data_tracks: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalNumDataTracks">"OpticalNumDataTracks"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
udisks_drive_get_optical_num_data_tracks (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_optical_num_data_tracks (object);
}

/**
 * udisks_drive_set_optical_num_data_tracks: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalNumDataTracks">"OpticalNumDataTracks"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_optical_num_data_tracks (UDisksDrive *object, guint value)
{
  g_object_set (G_OBJECT (object), "optical-num-data-tracks", value, NULL);
}

/**
 * udisks_drive_get_optical_num_sessions: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalNumSessions">"OpticalNumSessions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
udisks_drive_get_optical_num_sessions (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_optical_num_sessions (object);
}

/**
 * udisks_drive_set_optical_num_sessions: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.OpticalNumSessions">"OpticalNumSessions"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_optical_num_sessions (UDisksDrive *object, guint value)
{
  g_object_set (G_OBJECT (object), "optical-num-sessions", value, NULL);
}

/**
 * udisks_drive_get_rotation_rate: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.RotationRate">"RotationRate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
udisks_drive_get_rotation_rate (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_rotation_rate (object);
}

/**
 * udisks_drive_set_rotation_rate: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.RotationRate">"RotationRate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_rotation_rate (UDisksDrive *object, gint value)
{
  g_object_set (G_OBJECT (object), "rotation-rate", value, NULL);
}

/**
 * udisks_drive_get_connection_bus: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.ConnectionBus">"ConnectionBus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_dup_connection_bus() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_drive_get_connection_bus (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_connection_bus (object);
}

/**
 * udisks_drive_dup_connection_bus: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.ConnectionBus">"ConnectionBus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_drive_dup_connection_bus (UDisksDrive *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "connection-bus", &value, NULL);
  return value;
}

/**
 * udisks_drive_set_connection_bus: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.ConnectionBus">"ConnectionBus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_connection_bus (UDisksDrive *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "connection-bus", value, NULL);
}

/**
 * udisks_drive_get_seat: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Seat">"Seat"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_dup_seat() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_drive_get_seat (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_seat (object);
}

/**
 * udisks_drive_dup_seat: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Seat">"Seat"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_drive_dup_seat (UDisksDrive *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "seat", &value, NULL);
  return value;
}

/**
 * udisks_drive_set_seat: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Seat">"Seat"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_seat (UDisksDrive *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "seat", value, NULL);
}

/**
 * udisks_drive_get_removable: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Removable">"Removable"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_get_removable (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_removable (object);
}

/**
 * udisks_drive_set_removable: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Removable">"Removable"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_removable (UDisksDrive *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "removable", value, NULL);
}

/**
 * udisks_drive_get_ejectable: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Ejectable">"Ejectable"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_get_ejectable (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_ejectable (object);
}

/**
 * udisks_drive_set_ejectable: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.Ejectable">"Ejectable"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_ejectable (UDisksDrive *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "ejectable", value, NULL);
}

/**
 * udisks_drive_get_sort_key: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.SortKey">"SortKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_dup_sort_key() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_drive_get_sort_key (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_sort_key (object);
}

/**
 * udisks_drive_dup_sort_key: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.SortKey">"SortKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_drive_dup_sort_key (UDisksDrive *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "sort-key", &value, NULL);
  return value;
}

/**
 * udisks_drive_set_sort_key: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.SortKey">"SortKey"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_set_sort_key (UDisksDrive *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "sort-key", value, NULL);
}

/**
 * udisks_drive_get_can_power_off: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.CanPowerOff">"CanPowerOff"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 *
 * Since: 2.0.0
 */
gboolean 
udisks_drive_get_can_power_off (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_can_power_off (object);
}

/**
 * udisks_drive_set_can_power_off: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.CanPowerOff">"CanPowerOff"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 2.0.0
 */
void
udisks_drive_set_can_power_off (UDisksDrive *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-power-off", value, NULL);
}

/**
 * udisks_drive_get_sibling_id: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.SiblingId">"SiblingId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_dup_sibling_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 2.0.0
 */
const gchar *
udisks_drive_get_sibling_id (UDisksDrive *object)
{
  return UDISKS_DRIVE_GET_IFACE (object)->get_sibling_id (object);
}

/**
 * udisks_drive_dup_sibling_id: (skip)
 * @object: A #UDisksDrive.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.SiblingId">"SiblingId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 *
 * Since: 2.0.0
 */
gchar *
udisks_drive_dup_sibling_id (UDisksDrive *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "sibling-id", &value, NULL);
  return value;
}

/**
 * udisks_drive_set_sibling_id: (skip)
 * @object: A #UDisksDrive.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive.SiblingId">"SiblingId"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 2.0.0
 */
void
udisks_drive_set_sibling_id (UDisksDrive *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "sibling-id", value, NULL);
}

/**
 * udisks_drive_call_eject:
 * @proxy: A #UDisksDriveProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive.Eject">Eject()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_call_eject_finish() to get the result of the operation.
 *
 * See udisks_drive_call_eject_sync() for the synchronous, blocking version of this method.
 */
void
udisks_drive_call_eject (
    UDisksDrive *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Eject",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_drive_call_eject_finish:
 * @proxy: A #UDisksDriveProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_call_eject().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_drive_call_eject().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_call_eject_finish (
    UDisksDrive *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_call_eject_sync:
 * @proxy: A #UDisksDriveProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive.Eject">Eject()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_call_eject() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_call_eject_sync (
    UDisksDrive *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Eject",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_call_set_configuration:
 * @proxy: A #UDisksDriveProxy.
 * @arg_value: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive.SetConfiguration">SetConfiguration()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_call_set_configuration_finish() to get the result of the operation.
 *
 * See udisks_drive_call_set_configuration_sync() for the synchronous, blocking version of this method.
 */
void
udisks_drive_call_set_configuration (
    UDisksDrive *proxy,
    GVariant *arg_value,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetConfiguration",
    g_variant_new ("(@a{sv}@a{sv})",
                   arg_value,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_drive_call_set_configuration_finish:
 * @proxy: A #UDisksDriveProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_call_set_configuration().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_drive_call_set_configuration().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_call_set_configuration_finish (
    UDisksDrive *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_call_set_configuration_sync:
 * @proxy: A #UDisksDriveProxy.
 * @arg_value: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive.SetConfiguration">SetConfiguration()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_call_set_configuration() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_call_set_configuration_sync (
    UDisksDrive *proxy,
    GVariant *arg_value,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetConfiguration",
    g_variant_new ("(@a{sv}@a{sv})",
                   arg_value,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_call_power_off:
 * @proxy: A #UDisksDriveProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive.PowerOff">PowerOff()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_call_power_off_finish() to get the result of the operation.
 *
 * See udisks_drive_call_power_off_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.0.0
 */
void
udisks_drive_call_power_off (
    UDisksDrive *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PowerOff",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_drive_call_power_off_finish:
 * @proxy: A #UDisksDriveProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_call_power_off().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_drive_call_power_off().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.0.0
 */
gboolean
udisks_drive_call_power_off_finish (
    UDisksDrive *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_call_power_off_sync:
 * @proxy: A #UDisksDriveProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive.PowerOff">PowerOff()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_call_power_off() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.0.0
 */
gboolean
udisks_drive_call_power_off_sync (
    UDisksDrive *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PowerOff",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_complete_eject:
 * @object: A #UDisksDrive.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive.Eject">Eject()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_drive_complete_eject (
    UDisksDrive *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_drive_complete_set_configuration:
 * @object: A #UDisksDrive.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive.SetConfiguration">SetConfiguration()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_drive_complete_set_configuration (
    UDisksDrive *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_drive_complete_power_off:
 * @object: A #UDisksDrive.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive.PowerOff">PowerOff()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.0.0
 */
void
udisks_drive_complete_power_off (
    UDisksDrive *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * UDisksDriveProxy:
 *
 * The #UDisksDriveProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksDriveProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksDriveProxy.
 */

struct _UDisksDriveProxyPrivate
{
  GData *qdata;
};

static void udisks_drive_proxy_iface_init (UDisksDriveIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksDriveProxy, udisks_drive_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (UDisksDriveProxy)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_DRIVE, udisks_drive_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksDriveProxy, udisks_drive_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_DRIVE, udisks_drive_proxy_iface_init))

#endif
static void
udisks_drive_proxy_finalize (GObject *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (udisks_drive_proxy_parent_class)->finalize (object);
}

static void
udisks_drive_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 29);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_drive_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
udisks_drive_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.UDisks2.Drive: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
udisks_drive_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 29);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_drive_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.UDisks2.Drive", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) udisks_drive_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
udisks_drive_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_udisks_drive_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], UDISKS_TYPE_DRIVE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_DRIVE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
udisks_drive_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_drive_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_drive_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
udisks_drive_proxy_get_vendor (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Vendor");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_drive_proxy_get_model (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Model");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_drive_proxy_get_revision (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Revision");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_drive_proxy_get_serial (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Serial");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_drive_proxy_get_wwn (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WWN");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_drive_proxy_get_id (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Id");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
udisks_drive_proxy_get_configuration (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Configuration");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
udisks_drive_proxy_get_media (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Media");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
udisks_drive_proxy_get_media_compatibility (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "MediaCompatibility");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MediaCompatibility");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "MediaCompatibility", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_proxy_get_media_removable (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MediaRemovable");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_proxy_get_media_available (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MediaAvailable");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_proxy_get_media_change_detected (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MediaChangeDetected");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
udisks_drive_proxy_get_size (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Size");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
udisks_drive_proxy_get_time_detected (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TimeDetected");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
udisks_drive_proxy_get_time_media_detected (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TimeMediaDetected");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_proxy_get_optical (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Optical");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_proxy_get_optical_blank (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OpticalBlank");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
udisks_drive_proxy_get_optical_num_tracks (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OpticalNumTracks");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
udisks_drive_proxy_get_optical_num_audio_tracks (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OpticalNumAudioTracks");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
udisks_drive_proxy_get_optical_num_data_tracks (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OpticalNumDataTracks");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
udisks_drive_proxy_get_optical_num_sessions (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OpticalNumSessions");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
udisks_drive_proxy_get_rotation_rate (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RotationRate");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_drive_proxy_get_connection_bus (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConnectionBus");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_drive_proxy_get_seat (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Seat");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_proxy_get_removable (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Removable");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_proxy_get_ejectable (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Ejectable");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_drive_proxy_get_sort_key (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SortKey");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_proxy_get_can_power_off (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanPowerOff");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_drive_proxy_get_sibling_id (UDisksDrive *object)
{
  UDisksDriveProxy *proxy = UDISKS_DRIVE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SiblingId");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
udisks_drive_proxy_init (UDisksDriveProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = udisks_drive_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, UDISKS_TYPE_DRIVE_PROXY, UDisksDriveProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), udisks_drive_interface_info ());
}

static void
udisks_drive_proxy_class_init (UDisksDriveProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = udisks_drive_proxy_finalize;
  gobject_class->get_property = udisks_drive_proxy_get_property;
  gobject_class->set_property = udisks_drive_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = udisks_drive_proxy_g_signal;
  proxy_class->g_properties_changed = udisks_drive_proxy_g_properties_changed;

  udisks_drive_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksDriveProxyPrivate));
#endif
}

static void
udisks_drive_proxy_iface_init (UDisksDriveIface *iface)
{
  iface->get_vendor = udisks_drive_proxy_get_vendor;
  iface->get_model = udisks_drive_proxy_get_model;
  iface->get_revision = udisks_drive_proxy_get_revision;
  iface->get_serial = udisks_drive_proxy_get_serial;
  iface->get_wwn = udisks_drive_proxy_get_wwn;
  iface->get_id = udisks_drive_proxy_get_id;
  iface->get_configuration = udisks_drive_proxy_get_configuration;
  iface->get_media = udisks_drive_proxy_get_media;
  iface->get_media_compatibility = udisks_drive_proxy_get_media_compatibility;
  iface->get_media_removable = udisks_drive_proxy_get_media_removable;
  iface->get_media_available = udisks_drive_proxy_get_media_available;
  iface->get_media_change_detected = udisks_drive_proxy_get_media_change_detected;
  iface->get_size = udisks_drive_proxy_get_size;
  iface->get_time_detected = udisks_drive_proxy_get_time_detected;
  iface->get_time_media_detected = udisks_drive_proxy_get_time_media_detected;
  iface->get_optical = udisks_drive_proxy_get_optical;
  iface->get_optical_blank = udisks_drive_proxy_get_optical_blank;
  iface->get_optical_num_tracks = udisks_drive_proxy_get_optical_num_tracks;
  iface->get_optical_num_audio_tracks = udisks_drive_proxy_get_optical_num_audio_tracks;
  iface->get_optical_num_data_tracks = udisks_drive_proxy_get_optical_num_data_tracks;
  iface->get_optical_num_sessions = udisks_drive_proxy_get_optical_num_sessions;
  iface->get_rotation_rate = udisks_drive_proxy_get_rotation_rate;
  iface->get_connection_bus = udisks_drive_proxy_get_connection_bus;
  iface->get_seat = udisks_drive_proxy_get_seat;
  iface->get_removable = udisks_drive_proxy_get_removable;
  iface->get_ejectable = udisks_drive_proxy_get_ejectable;
  iface->get_sort_key = udisks_drive_proxy_get_sort_key;
  iface->get_can_power_off = udisks_drive_proxy_get_can_power_off;
  iface->get_sibling_id = udisks_drive_proxy_get_sibling_id;
}

/**
 * udisks_drive_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive.top_of_page">org.freedesktop.UDisks2.Drive</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_proxy_new_finish() to get the result of the operation.
 *
 * See udisks_drive_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_drive_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_DRIVE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Drive", NULL);
}

/**
 * udisks_drive_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_drive_proxy_new().
 *
 * Returns: (transfer full) (type UDisksDriveProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksDrive *
udisks_drive_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_DRIVE (ret);
  else
    return NULL;
}

/**
 * udisks_drive_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive.top_of_page">org.freedesktop.UDisks2.Drive</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksDriveProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksDrive *
udisks_drive_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_DRIVE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Drive", NULL);
  if (ret != NULL)
    return UDISKS_DRIVE (ret);
  else
    return NULL;
}


/**
 * udisks_drive_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like udisks_drive_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See udisks_drive_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_drive_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_DRIVE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Drive", NULL);
}

/**
 * udisks_drive_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_drive_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type UDisksDriveProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksDrive *
udisks_drive_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_DRIVE (ret);
  else
    return NULL;
}

/**
 * udisks_drive_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like udisks_drive_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksDriveProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksDrive *
udisks_drive_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_DRIVE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Drive", NULL);
  if (ret != NULL)
    return UDISKS_DRIVE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * UDisksDriveSkeleton:
 *
 * The #UDisksDriveSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksDriveSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksDriveSkeleton.
 */

struct _UDisksDriveSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_udisks_drive_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], UDISKS_TYPE_DRIVE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_DRIVE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_udisks_drive_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_drive_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_udisks_drive_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_drive_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _udisks_drive_skeleton_vtable =
{
  _udisks_drive_skeleton_handle_method_call,
  _udisks_drive_skeleton_handle_get_property,
  _udisks_drive_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
udisks_drive_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return udisks_drive_interface_info ();
}

static GDBusInterfaceVTable *
udisks_drive_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_udisks_drive_skeleton_vtable;
}

static GVariant *
udisks_drive_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_udisks_drive_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _udisks_drive_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _udisks_drive_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _udisks_drive_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.UDisks2.Drive", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _udisks_drive_emit_changed (gpointer user_data);

static void
udisks_drive_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _udisks_drive_emit_changed (skeleton);
}

static void udisks_drive_skeleton_iface_init (UDisksDriveIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksDriveSkeleton, udisks_drive_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (UDisksDriveSkeleton)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_DRIVE, udisks_drive_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksDriveSkeleton, udisks_drive_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_DRIVE, udisks_drive_skeleton_iface_init))

#endif
static void
udisks_drive_skeleton_finalize (GObject *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  guint n;
  for (n = 0; n < 29; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (udisks_drive_skeleton_parent_class)->finalize (object);
}

static void
udisks_drive_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 29);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_udisks_drive_emit_changed (gpointer user_data)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.UDisks2.Drive",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_udisks_drive_schedule_emit_changed (UDisksDriveSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
udisks_drive_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _udisks_drive_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _udisks_drive_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
udisks_drive_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 29);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_drive_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _udisks_drive_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
udisks_drive_skeleton_init (UDisksDriveSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = udisks_drive_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, UDISKS_TYPE_DRIVE_SKELETON, UDisksDriveSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 29);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[15], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[16], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[17], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[18], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[19], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[20], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[21], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[22], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[23], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[24], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[25], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[26], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[27], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[28], G_TYPE_STRING);
}

static const gchar *
udisks_drive_skeleton_get_vendor (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_drive_skeleton_get_model (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_drive_skeleton_get_revision (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_drive_skeleton_get_serial (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_drive_skeleton_get_wwn (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_drive_skeleton_get_id (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
udisks_drive_skeleton_get_configuration (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_drive_skeleton_get_media (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
udisks_drive_skeleton_get_media_compatibility (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_skeleton_get_media_removable (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_skeleton_get_media_available (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_skeleton_get_media_change_detected (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
udisks_drive_skeleton_get_size (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
udisks_drive_skeleton_get_time_detected (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
udisks_drive_skeleton_get_time_media_detected (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_skeleton_get_optical (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[15]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_skeleton_get_optical_blank (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[16]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
udisks_drive_skeleton_get_optical_num_tracks (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[17]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
udisks_drive_skeleton_get_optical_num_audio_tracks (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[18]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
udisks_drive_skeleton_get_optical_num_data_tracks (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[19]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
udisks_drive_skeleton_get_optical_num_sessions (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[20]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
udisks_drive_skeleton_get_rotation_rate (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[21]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_drive_skeleton_get_connection_bus (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[22]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_drive_skeleton_get_seat (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[23]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_skeleton_get_removable (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[24]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_skeleton_get_ejectable (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[25]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_drive_skeleton_get_sort_key (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[26]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_skeleton_get_can_power_off (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[27]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_drive_skeleton_get_sibling_id (UDisksDrive *object)
{
  UDisksDriveSkeleton *skeleton = UDISKS_DRIVE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[28]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
udisks_drive_skeleton_class_init (UDisksDriveSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = udisks_drive_skeleton_finalize;
  gobject_class->get_property = udisks_drive_skeleton_get_property;
  gobject_class->set_property = udisks_drive_skeleton_set_property;
  gobject_class->notify       = udisks_drive_skeleton_notify;


  udisks_drive_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = udisks_drive_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = udisks_drive_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = udisks_drive_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = udisks_drive_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksDriveSkeletonPrivate));
#endif
}

static void
udisks_drive_skeleton_iface_init (UDisksDriveIface *iface)
{
  iface->get_vendor = udisks_drive_skeleton_get_vendor;
  iface->get_model = udisks_drive_skeleton_get_model;
  iface->get_revision = udisks_drive_skeleton_get_revision;
  iface->get_serial = udisks_drive_skeleton_get_serial;
  iface->get_wwn = udisks_drive_skeleton_get_wwn;
  iface->get_id = udisks_drive_skeleton_get_id;
  iface->get_configuration = udisks_drive_skeleton_get_configuration;
  iface->get_media = udisks_drive_skeleton_get_media;
  iface->get_media_compatibility = udisks_drive_skeleton_get_media_compatibility;
  iface->get_media_removable = udisks_drive_skeleton_get_media_removable;
  iface->get_media_available = udisks_drive_skeleton_get_media_available;
  iface->get_media_change_detected = udisks_drive_skeleton_get_media_change_detected;
  iface->get_size = udisks_drive_skeleton_get_size;
  iface->get_time_detected = udisks_drive_skeleton_get_time_detected;
  iface->get_time_media_detected = udisks_drive_skeleton_get_time_media_detected;
  iface->get_optical = udisks_drive_skeleton_get_optical;
  iface->get_optical_blank = udisks_drive_skeleton_get_optical_blank;
  iface->get_optical_num_tracks = udisks_drive_skeleton_get_optical_num_tracks;
  iface->get_optical_num_audio_tracks = udisks_drive_skeleton_get_optical_num_audio_tracks;
  iface->get_optical_num_data_tracks = udisks_drive_skeleton_get_optical_num_data_tracks;
  iface->get_optical_num_sessions = udisks_drive_skeleton_get_optical_num_sessions;
  iface->get_rotation_rate = udisks_drive_skeleton_get_rotation_rate;
  iface->get_connection_bus = udisks_drive_skeleton_get_connection_bus;
  iface->get_seat = udisks_drive_skeleton_get_seat;
  iface->get_removable = udisks_drive_skeleton_get_removable;
  iface->get_ejectable = udisks_drive_skeleton_get_ejectable;
  iface->get_sort_key = udisks_drive_skeleton_get_sort_key;
  iface->get_can_power_off = udisks_drive_skeleton_get_can_power_off;
  iface->get_sibling_id = udisks_drive_skeleton_get_sibling_id;
}

/**
 * udisks_drive_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive.top_of_page">org.freedesktop.UDisks2.Drive</link>.
 *
 * Returns: (transfer full) (type UDisksDriveSkeleton): The skeleton object.
 */
UDisksDrive *
udisks_drive_skeleton_new (void)
{
  return UDISKS_DRIVE (g_object_new (UDISKS_TYPE_DRIVE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.UDisks2.Drive.Ata
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:UDisksDriveAta
 * @title: UDisksDriveAta
 * @short_description: Generated C code for the org.freedesktop.UDisks2.Drive.Ata D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive-Ata.top_of_page">org.freedesktop.UDisks2.Drive.Ata</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.UDisks2.Drive.Ata ---- */

static const _ExtendedGDBusArgInfo _udisks_drive_ata_method_info_smart_update_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_ata_method_info_smart_update_IN_ARG_pointers[] =
{
  &_udisks_drive_ata_method_info_smart_update_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_drive_ata_method_info_smart_update =
{
  {
    -1,
    (gchar *) "SmartUpdate",
    (GDBusArgInfo **) &_udisks_drive_ata_method_info_smart_update_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-smart-update",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_drive_ata_method_info_smart_get_attributes_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_ata_method_info_smart_get_attributes_IN_ARG_pointers[] =
{
  &_udisks_drive_ata_method_info_smart_get_attributes_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_drive_ata_method_info_smart_get_attributes_OUT_ARG_attributes =
{
  {
    -1,
    (gchar *) "attributes",
    (gchar *) "a(ysqiiixia{sv})",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_ata_method_info_smart_get_attributes_OUT_ARG_pointers[] =
{
  &_udisks_drive_ata_method_info_smart_get_attributes_OUT_ARG_attributes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_drive_ata_method_info_smart_get_attributes =
{
  {
    -1,
    (gchar *) "SmartGetAttributes",
    (GDBusArgInfo **) &_udisks_drive_ata_method_info_smart_get_attributes_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_drive_ata_method_info_smart_get_attributes_OUT_ARG_pointers,
    NULL
  },
  "handle-smart-get-attributes",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_drive_ata_method_info_smart_selftest_start_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_drive_ata_method_info_smart_selftest_start_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_ata_method_info_smart_selftest_start_IN_ARG_pointers[] =
{
  &_udisks_drive_ata_method_info_smart_selftest_start_IN_ARG_type.parent_struct,
  &_udisks_drive_ata_method_info_smart_selftest_start_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_drive_ata_method_info_smart_selftest_start =
{
  {
    -1,
    (gchar *) "SmartSelftestStart",
    (GDBusArgInfo **) &_udisks_drive_ata_method_info_smart_selftest_start_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-smart-selftest-start",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_drive_ata_method_info_smart_selftest_abort_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_ata_method_info_smart_selftest_abort_IN_ARG_pointers[] =
{
  &_udisks_drive_ata_method_info_smart_selftest_abort_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_drive_ata_method_info_smart_selftest_abort =
{
  {
    -1,
    (gchar *) "SmartSelftestAbort",
    (GDBusArgInfo **) &_udisks_drive_ata_method_info_smart_selftest_abort_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-smart-selftest-abort",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_drive_ata_method_info_smart_set_enabled_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_drive_ata_method_info_smart_set_enabled_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_ata_method_info_smart_set_enabled_IN_ARG_pointers[] =
{
  &_udisks_drive_ata_method_info_smart_set_enabled_IN_ARG_value.parent_struct,
  &_udisks_drive_ata_method_info_smart_set_enabled_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_drive_ata_method_info_smart_set_enabled =
{
  {
    -1,
    (gchar *) "SmartSetEnabled",
    (GDBusArgInfo **) &_udisks_drive_ata_method_info_smart_set_enabled_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-smart-set-enabled",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_drive_ata_method_info_pm_get_state_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_ata_method_info_pm_get_state_IN_ARG_pointers[] =
{
  &_udisks_drive_ata_method_info_pm_get_state_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_drive_ata_method_info_pm_get_state_OUT_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "y",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_ata_method_info_pm_get_state_OUT_ARG_pointers[] =
{
  &_udisks_drive_ata_method_info_pm_get_state_OUT_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_drive_ata_method_info_pm_get_state =
{
  {
    -1,
    (gchar *) "PmGetState",
    (GDBusArgInfo **) &_udisks_drive_ata_method_info_pm_get_state_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_drive_ata_method_info_pm_get_state_OUT_ARG_pointers,
    NULL
  },
  "handle-pm-get-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_drive_ata_method_info_pm_standby_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_ata_method_info_pm_standby_IN_ARG_pointers[] =
{
  &_udisks_drive_ata_method_info_pm_standby_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_drive_ata_method_info_pm_standby =
{
  {
    -1,
    (gchar *) "PmStandby",
    (GDBusArgInfo **) &_udisks_drive_ata_method_info_pm_standby_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-pm-standby",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_drive_ata_method_info_pm_wakeup_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_ata_method_info_pm_wakeup_IN_ARG_pointers[] =
{
  &_udisks_drive_ata_method_info_pm_wakeup_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_drive_ata_method_info_pm_wakeup =
{
  {
    -1,
    (gchar *) "PmWakeup",
    (GDBusArgInfo **) &_udisks_drive_ata_method_info_pm_wakeup_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-pm-wakeup",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_drive_ata_method_info_security_erase_unit_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_drive_ata_method_info_security_erase_unit_IN_ARG_pointers[] =
{
  &_udisks_drive_ata_method_info_security_erase_unit_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_drive_ata_method_info_security_erase_unit =
{
  {
    -1,
    (gchar *) "SecurityEraseUnit",
    (GDBusArgInfo **) &_udisks_drive_ata_method_info_security_erase_unit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-security-erase-unit",
  FALSE
};

static const GDBusMethodInfo * const _udisks_drive_ata_method_info_pointers[] =
{
  &_udisks_drive_ata_method_info_smart_update.parent_struct,
  &_udisks_drive_ata_method_info_smart_get_attributes.parent_struct,
  &_udisks_drive_ata_method_info_smart_selftest_start.parent_struct,
  &_udisks_drive_ata_method_info_smart_selftest_abort.parent_struct,
  &_udisks_drive_ata_method_info_smart_set_enabled.parent_struct,
  &_udisks_drive_ata_method_info_pm_get_state.parent_struct,
  &_udisks_drive_ata_method_info_pm_standby.parent_struct,
  &_udisks_drive_ata_method_info_pm_wakeup.parent_struct,
  &_udisks_drive_ata_method_info_security_erase_unit.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_smart_supported =
{
  {
    -1,
    (gchar *) "SmartSupported",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "smart-supported",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_smart_enabled =
{
  {
    -1,
    (gchar *) "SmartEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "smart-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_smart_updated =
{
  {
    -1,
    (gchar *) "SmartUpdated",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "smart-updated",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_smart_failing =
{
  {
    -1,
    (gchar *) "SmartFailing",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "smart-failing",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_smart_power_on_seconds =
{
  {
    -1,
    (gchar *) "SmartPowerOnSeconds",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "smart-power-on-seconds",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_smart_temperature =
{
  {
    -1,
    (gchar *) "SmartTemperature",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "smart-temperature",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_smart_num_attributes_failing =
{
  {
    -1,
    (gchar *) "SmartNumAttributesFailing",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "smart-num-attributes-failing",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_smart_num_attributes_failed_in_the_past =
{
  {
    -1,
    (gchar *) "SmartNumAttributesFailedInThePast",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "smart-num-attributes-failed-in-the-past",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_smart_num_bad_sectors =
{
  {
    -1,
    (gchar *) "SmartNumBadSectors",
    (gchar *) "x",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "smart-num-bad-sectors",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_smart_selftest_status =
{
  {
    -1,
    (gchar *) "SmartSelftestStatus",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "smart-selftest-status",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_smart_selftest_percent_remaining =
{
  {
    -1,
    (gchar *) "SmartSelftestPercentRemaining",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "smart-selftest-percent-remaining",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_pm_supported =
{
  {
    -1,
    (gchar *) "PmSupported",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "pm-supported",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_pm_enabled =
{
  {
    -1,
    (gchar *) "PmEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "pm-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_apm_supported =
{
  {
    -1,
    (gchar *) "ApmSupported",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "apm-supported",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_apm_enabled =
{
  {
    -1,
    (gchar *) "ApmEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "apm-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_aam_supported =
{
  {
    -1,
    (gchar *) "AamSupported",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "aam-supported",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_aam_enabled =
{
  {
    -1,
    (gchar *) "AamEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "aam-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_aam_vendor_recommended_value =
{
  {
    -1,
    (gchar *) "AamVendorRecommendedValue",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "aam-vendor-recommended-value",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_write_cache_supported =
{
  {
    -1,
    (gchar *) "WriteCacheSupported",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "write-cache-supported",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_write_cache_enabled =
{
  {
    -1,
    (gchar *) "WriteCacheEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "write-cache-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_read_lookahead_supported =
{
  {
    -1,
    (gchar *) "ReadLookaheadSupported",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "read-lookahead-supported",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_read_lookahead_enabled =
{
  {
    -1,
    (gchar *) "ReadLookaheadEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "read-lookahead-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_security_erase_unit_minutes =
{
  {
    -1,
    (gchar *) "SecurityEraseUnitMinutes",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "security-erase-unit-minutes",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_security_enhanced_erase_unit_minutes =
{
  {
    -1,
    (gchar *) "SecurityEnhancedEraseUnitMinutes",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "security-enhanced-erase-unit-minutes",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_drive_ata_property_info_security_frozen =
{
  {
    -1,
    (gchar *) "SecurityFrozen",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "security-frozen",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _udisks_drive_ata_property_info_pointers[] =
{
  &_udisks_drive_ata_property_info_smart_supported.parent_struct,
  &_udisks_drive_ata_property_info_smart_enabled.parent_struct,
  &_udisks_drive_ata_property_info_smart_updated.parent_struct,
  &_udisks_drive_ata_property_info_smart_failing.parent_struct,
  &_udisks_drive_ata_property_info_smart_power_on_seconds.parent_struct,
  &_udisks_drive_ata_property_info_smart_temperature.parent_struct,
  &_udisks_drive_ata_property_info_smart_num_attributes_failing.parent_struct,
  &_udisks_drive_ata_property_info_smart_num_attributes_failed_in_the_past.parent_struct,
  &_udisks_drive_ata_property_info_smart_num_bad_sectors.parent_struct,
  &_udisks_drive_ata_property_info_smart_selftest_status.parent_struct,
  &_udisks_drive_ata_property_info_smart_selftest_percent_remaining.parent_struct,
  &_udisks_drive_ata_property_info_pm_supported.parent_struct,
  &_udisks_drive_ata_property_info_pm_enabled.parent_struct,
  &_udisks_drive_ata_property_info_apm_supported.parent_struct,
  &_udisks_drive_ata_property_info_apm_enabled.parent_struct,
  &_udisks_drive_ata_property_info_aam_supported.parent_struct,
  &_udisks_drive_ata_property_info_aam_enabled.parent_struct,
  &_udisks_drive_ata_property_info_aam_vendor_recommended_value.parent_struct,
  &_udisks_drive_ata_property_info_write_cache_supported.parent_struct,
  &_udisks_drive_ata_property_info_write_cache_enabled.parent_struct,
  &_udisks_drive_ata_property_info_read_lookahead_supported.parent_struct,
  &_udisks_drive_ata_property_info_read_lookahead_enabled.parent_struct,
  &_udisks_drive_ata_property_info_security_erase_unit_minutes.parent_struct,
  &_udisks_drive_ata_property_info_security_enhanced_erase_unit_minutes.parent_struct,
  &_udisks_drive_ata_property_info_security_frozen.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _udisks_drive_ata_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.UDisks2.Drive.Ata",
    (GDBusMethodInfo **) &_udisks_drive_ata_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_udisks_drive_ata_property_info_pointers,
    NULL
  },
  "drive-ata",
};


/**
 * udisks_drive_ata_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive-Ata.top_of_page">org.freedesktop.UDisks2.Drive.Ata</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
udisks_drive_ata_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_udisks_drive_ata_interface_info.parent_struct;
}

/**
 * udisks_drive_ata_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #UDisksDriveAta interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
udisks_drive_ata_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "smart-supported");
  g_object_class_override_property (klass, property_id_begin++, "smart-enabled");
  g_object_class_override_property (klass, property_id_begin++, "smart-updated");
  g_object_class_override_property (klass, property_id_begin++, "smart-failing");
  g_object_class_override_property (klass, property_id_begin++, "smart-power-on-seconds");
  g_object_class_override_property (klass, property_id_begin++, "smart-temperature");
  g_object_class_override_property (klass, property_id_begin++, "smart-num-attributes-failing");
  g_object_class_override_property (klass, property_id_begin++, "smart-num-attributes-failed-in-the-past");
  g_object_class_override_property (klass, property_id_begin++, "smart-num-bad-sectors");
  g_object_class_override_property (klass, property_id_begin++, "smart-selftest-status");
  g_object_class_override_property (klass, property_id_begin++, "smart-selftest-percent-remaining");
  g_object_class_override_property (klass, property_id_begin++, "pm-supported");
  g_object_class_override_property (klass, property_id_begin++, "pm-enabled");
  g_object_class_override_property (klass, property_id_begin++, "apm-supported");
  g_object_class_override_property (klass, property_id_begin++, "apm-enabled");
  g_object_class_override_property (klass, property_id_begin++, "aam-supported");
  g_object_class_override_property (klass, property_id_begin++, "aam-enabled");
  g_object_class_override_property (klass, property_id_begin++, "aam-vendor-recommended-value");
  g_object_class_override_property (klass, property_id_begin++, "write-cache-supported");
  g_object_class_override_property (klass, property_id_begin++, "write-cache-enabled");
  g_object_class_override_property (klass, property_id_begin++, "read-lookahead-supported");
  g_object_class_override_property (klass, property_id_begin++, "read-lookahead-enabled");
  g_object_class_override_property (klass, property_id_begin++, "security-erase-unit-minutes");
  g_object_class_override_property (klass, property_id_begin++, "security-enhanced-erase-unit-minutes");
  g_object_class_override_property (klass, property_id_begin++, "security-frozen");
  return property_id_begin - 1;
}



/**
 * UDisksDriveAta:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive-Ata.top_of_page">org.freedesktop.UDisks2.Drive.Ata</link>.
 */

/**
 * UDisksDriveAtaIface:
 * @parent_iface: The parent interface.
 * @handle_pm_get_state: Handler for the #UDisksDriveAta::handle-pm-get-state signal.
 * @handle_pm_standby: Handler for the #UDisksDriveAta::handle-pm-standby signal.
 * @handle_pm_wakeup: Handler for the #UDisksDriveAta::handle-pm-wakeup signal.
 * @handle_security_erase_unit: Handler for the #UDisksDriveAta::handle-security-erase-unit signal.
 * @handle_smart_get_attributes: Handler for the #UDisksDriveAta::handle-smart-get-attributes signal.
 * @handle_smart_selftest_abort: Handler for the #UDisksDriveAta::handle-smart-selftest-abort signal.
 * @handle_smart_selftest_start: Handler for the #UDisksDriveAta::handle-smart-selftest-start signal.
 * @handle_smart_update: Handler for the #UDisksDriveAta::handle-smart-update signal.
 * @get_aam_enabled: Getter for the #UDisksDriveAta:aam-enabled property.
 * @get_aam_supported: Getter for the #UDisksDriveAta:aam-supported property.
 * @get_aam_vendor_recommended_value: Getter for the #UDisksDriveAta:aam-vendor-recommended-value property.
 * @get_apm_enabled: Getter for the #UDisksDriveAta:apm-enabled property.
 * @get_apm_supported: Getter for the #UDisksDriveAta:apm-supported property.
 * @get_pm_enabled: Getter for the #UDisksDriveAta:pm-enabled property.
 * @get_pm_supported: Getter for the #UDisksDriveAta:pm-supported property.
 * @get_security_enhanced_erase_unit_minutes: Getter for the #UDisksDriveAta:security-enhanced-erase-unit-minutes property.
 * @get_security_erase_unit_minutes: Getter for the #UDisksDriveAta:security-erase-unit-minutes property.
 * @get_security_frozen: Getter for the #UDisksDriveAta:security-frozen property.
 * @get_smart_enabled: Getter for the #UDisksDriveAta:smart-enabled property.
 * @get_smart_failing: Getter for the #UDisksDriveAta:smart-failing property.
 * @get_smart_num_attributes_failed_in_the_past: Getter for the #UDisksDriveAta:smart-num-attributes-failed-in-the-past property.
 * @get_smart_num_attributes_failing: Getter for the #UDisksDriveAta:smart-num-attributes-failing property.
 * @get_smart_num_bad_sectors: Getter for the #UDisksDriveAta:smart-num-bad-sectors property.
 * @get_smart_power_on_seconds: Getter for the #UDisksDriveAta:smart-power-on-seconds property.
 * @get_smart_selftest_percent_remaining: Getter for the #UDisksDriveAta:smart-selftest-percent-remaining property.
 * @get_smart_selftest_status: Getter for the #UDisksDriveAta:smart-selftest-status property.
 * @get_smart_supported: Getter for the #UDisksDriveAta:smart-supported property.
 * @get_smart_temperature: Getter for the #UDisksDriveAta:smart-temperature property.
 * @get_smart_updated: Getter for the #UDisksDriveAta:smart-updated property.
 * @handle_smart_set_enabled: Handler for the #UDisksDriveAta::handle-smart-set-enabled signal.
 * @get_write_cache_enabled: Getter for the #UDisksDriveAta:write-cache-enabled property.
 * @get_write_cache_supported: Getter for the #UDisksDriveAta:write-cache-supported property.
 * @get_read_lookahead_enabled: Getter for the #UDisksDriveAta:read-lookahead-enabled property.
 * @get_read_lookahead_supported: Getter for the #UDisksDriveAta:read-lookahead-supported property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive-Ata.top_of_page">org.freedesktop.UDisks2.Drive.Ata</link>.
 */

typedef UDisksDriveAtaIface UDisksDriveAtaInterface;
G_DEFINE_INTERFACE (UDisksDriveAta, udisks_drive_ata, G_TYPE_OBJECT)

static void
udisks_drive_ata_default_init (UDisksDriveAtaIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * UDisksDriveAta::handle-smart-update:
   * @object: A #UDisksDriveAta.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartUpdate">SmartUpdate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_drive_ata_complete_smart_update() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-smart-update",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksDriveAtaIface, handle_smart_update),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksDriveAta::handle-smart-get-attributes:
   * @object: A #UDisksDriveAta.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartGetAttributes">SmartGetAttributes()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_drive_ata_complete_smart_get_attributes() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-smart-get-attributes",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksDriveAtaIface, handle_smart_get_attributes),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksDriveAta::handle-smart-selftest-start:
   * @object: A #UDisksDriveAta.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_type: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestStart">SmartSelftestStart()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_drive_ata_complete_smart_selftest_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-smart-selftest-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksDriveAtaIface, handle_smart_selftest_start),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * UDisksDriveAta::handle-smart-selftest-abort:
   * @object: A #UDisksDriveAta.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestAbort">SmartSelftestAbort()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_drive_ata_complete_smart_selftest_abort() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-smart-selftest-abort",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksDriveAtaIface, handle_smart_selftest_abort),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksDriveAta::handle-smart-set-enabled:
   * @object: A #UDisksDriveAta.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_value: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartSetEnabled">SmartSetEnabled()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_drive_ata_complete_smart_set_enabled() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.0.0
   */
  g_signal_new ("handle-smart-set-enabled",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksDriveAtaIface, handle_smart_set_enabled),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_VARIANT);

  /**
   * UDisksDriveAta::handle-pm-get-state:
   * @object: A #UDisksDriveAta.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.PmGetState">PmGetState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_drive_ata_complete_pm_get_state() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pm-get-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksDriveAtaIface, handle_pm_get_state),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksDriveAta::handle-pm-standby:
   * @object: A #UDisksDriveAta.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.PmStandby">PmStandby()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_drive_ata_complete_pm_standby() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pm-standby",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksDriveAtaIface, handle_pm_standby),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksDriveAta::handle-pm-wakeup:
   * @object: A #UDisksDriveAta.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.PmWakeup">PmWakeup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_drive_ata_complete_pm_wakeup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pm-wakeup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksDriveAtaIface, handle_pm_wakeup),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksDriveAta::handle-security-erase-unit:
   * @object: A #UDisksDriveAta.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SecurityEraseUnit">SecurityEraseUnit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_drive_ata_complete_security_erase_unit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-security-erase-unit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksDriveAtaIface, handle_security_erase_unit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * UDisksDriveAta:smart-supported:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartSupported">"SmartSupported"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("smart-supported", "SmartSupported", "SmartSupported", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:smart-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartEnabled">"SmartEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("smart-enabled", "SmartEnabled", "SmartEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:smart-updated:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartUpdated">"SmartUpdated"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("smart-updated", "SmartUpdated", "SmartUpdated", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:smart-failing:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartFailing">"SmartFailing"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("smart-failing", "SmartFailing", "SmartFailing", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:smart-power-on-seconds:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartPowerOnSeconds">"SmartPowerOnSeconds"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("smart-power-on-seconds", "SmartPowerOnSeconds", "SmartPowerOnSeconds", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:smart-temperature:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartTemperature">"SmartTemperature"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("smart-temperature", "SmartTemperature", "SmartTemperature", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:smart-num-attributes-failing:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartNumAttributesFailing">"SmartNumAttributesFailing"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("smart-num-attributes-failing", "SmartNumAttributesFailing", "SmartNumAttributesFailing", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:smart-num-attributes-failed-in-the-past:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartNumAttributesFailedInThePast">"SmartNumAttributesFailedInThePast"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("smart-num-attributes-failed-in-the-past", "SmartNumAttributesFailedInThePast", "SmartNumAttributesFailedInThePast", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:smart-num-bad-sectors:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartNumBadSectors">"SmartNumBadSectors"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int64 ("smart-num-bad-sectors", "SmartNumBadSectors", "SmartNumBadSectors", G_MININT64, G_MAXINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:smart-selftest-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestStatus">"SmartSelftestStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("smart-selftest-status", "SmartSelftestStatus", "SmartSelftestStatus", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:smart-selftest-percent-remaining:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestPercentRemaining">"SmartSelftestPercentRemaining"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("smart-selftest-percent-remaining", "SmartSelftestPercentRemaining", "SmartSelftestPercentRemaining", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:pm-supported:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.PmSupported">"PmSupported"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("pm-supported", "PmSupported", "PmSupported", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:pm-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.PmEnabled">"PmEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("pm-enabled", "PmEnabled", "PmEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:apm-supported:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.ApmSupported">"ApmSupported"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("apm-supported", "ApmSupported", "ApmSupported", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:apm-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.ApmEnabled">"ApmEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("apm-enabled", "ApmEnabled", "ApmEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:aam-supported:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.AamSupported">"AamSupported"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("aam-supported", "AamSupported", "AamSupported", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:aam-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.AamEnabled">"AamEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("aam-enabled", "AamEnabled", "AamEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:aam-vendor-recommended-value:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.AamVendorRecommendedValue">"AamVendorRecommendedValue"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("aam-vendor-recommended-value", "AamVendorRecommendedValue", "AamVendorRecommendedValue", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:write-cache-supported:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.WriteCacheSupported">"WriteCacheSupported"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 2.0.0
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("write-cache-supported", "WriteCacheSupported", "WriteCacheSupported", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:write-cache-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.WriteCacheEnabled">"WriteCacheEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 2.0.0
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("write-cache-enabled", "WriteCacheEnabled", "WriteCacheEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:read-lookahead-supported:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.ReadLookaheadSupported">"ReadLookaheadSupported"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 2.1.7
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("read-lookahead-supported", "ReadLookaheadSupported", "ReadLookaheadSupported", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:read-lookahead-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.ReadLookaheadEnabled">"ReadLookaheadEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 2.1.7
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("read-lookahead-enabled", "ReadLookaheadEnabled", "ReadLookaheadEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:security-erase-unit-minutes:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SecurityEraseUnitMinutes">"SecurityEraseUnitMinutes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("security-erase-unit-minutes", "SecurityEraseUnitMinutes", "SecurityEraseUnitMinutes", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:security-enhanced-erase-unit-minutes:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SecurityEnhancedEraseUnitMinutes">"SecurityEnhancedEraseUnitMinutes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("security-enhanced-erase-unit-minutes", "SecurityEnhancedEraseUnitMinutes", "SecurityEnhancedEraseUnitMinutes", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksDriveAta:security-frozen:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SecurityFrozen">"SecurityFrozen"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("security-frozen", "SecurityFrozen", "SecurityFrozen", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * udisks_drive_ata_get_smart_supported: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartSupported">"SmartSupported"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_ata_get_smart_supported (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_smart_supported (object);
}

/**
 * udisks_drive_ata_set_smart_supported: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartSupported">"SmartSupported"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_smart_supported (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "smart-supported", value, NULL);
}

/**
 * udisks_drive_ata_get_smart_enabled: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartEnabled">"SmartEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_ata_get_smart_enabled (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_smart_enabled (object);
}

/**
 * udisks_drive_ata_set_smart_enabled: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartEnabled">"SmartEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_smart_enabled (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "smart-enabled", value, NULL);
}

/**
 * udisks_drive_ata_get_smart_updated: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartUpdated">"SmartUpdated"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
udisks_drive_ata_get_smart_updated (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_smart_updated (object);
}

/**
 * udisks_drive_ata_set_smart_updated: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartUpdated">"SmartUpdated"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_smart_updated (UDisksDriveAta *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "smart-updated", value, NULL);
}

/**
 * udisks_drive_ata_get_smart_failing: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartFailing">"SmartFailing"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_ata_get_smart_failing (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_smart_failing (object);
}

/**
 * udisks_drive_ata_set_smart_failing: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartFailing">"SmartFailing"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_smart_failing (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "smart-failing", value, NULL);
}

/**
 * udisks_drive_ata_get_smart_power_on_seconds: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartPowerOnSeconds">"SmartPowerOnSeconds"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
udisks_drive_ata_get_smart_power_on_seconds (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_smart_power_on_seconds (object);
}

/**
 * udisks_drive_ata_set_smart_power_on_seconds: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartPowerOnSeconds">"SmartPowerOnSeconds"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_smart_power_on_seconds (UDisksDriveAta *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "smart-power-on-seconds", value, NULL);
}

/**
 * udisks_drive_ata_get_smart_temperature: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartTemperature">"SmartTemperature"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
udisks_drive_ata_get_smart_temperature (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_smart_temperature (object);
}

/**
 * udisks_drive_ata_set_smart_temperature: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartTemperature">"SmartTemperature"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_smart_temperature (UDisksDriveAta *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "smart-temperature", value, NULL);
}

/**
 * udisks_drive_ata_get_smart_num_attributes_failing: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartNumAttributesFailing">"SmartNumAttributesFailing"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
udisks_drive_ata_get_smart_num_attributes_failing (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_smart_num_attributes_failing (object);
}

/**
 * udisks_drive_ata_set_smart_num_attributes_failing: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartNumAttributesFailing">"SmartNumAttributesFailing"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_smart_num_attributes_failing (UDisksDriveAta *object, gint value)
{
  g_object_set (G_OBJECT (object), "smart-num-attributes-failing", value, NULL);
}

/**
 * udisks_drive_ata_get_smart_num_attributes_failed_in_the_past: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartNumAttributesFailedInThePast">"SmartNumAttributesFailedInThePast"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
udisks_drive_ata_get_smart_num_attributes_failed_in_the_past (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_smart_num_attributes_failed_in_the_past (object);
}

/**
 * udisks_drive_ata_set_smart_num_attributes_failed_in_the_past: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartNumAttributesFailedInThePast">"SmartNumAttributesFailedInThePast"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_smart_num_attributes_failed_in_the_past (UDisksDriveAta *object, gint value)
{
  g_object_set (G_OBJECT (object), "smart-num-attributes-failed-in-the-past", value, NULL);
}

/**
 * udisks_drive_ata_get_smart_num_bad_sectors: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartNumBadSectors">"SmartNumBadSectors"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint64 
udisks_drive_ata_get_smart_num_bad_sectors (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_smart_num_bad_sectors (object);
}

/**
 * udisks_drive_ata_set_smart_num_bad_sectors: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartNumBadSectors">"SmartNumBadSectors"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_smart_num_bad_sectors (UDisksDriveAta *object, gint64 value)
{
  g_object_set (G_OBJECT (object), "smart-num-bad-sectors", value, NULL);
}

/**
 * udisks_drive_ata_get_smart_selftest_status: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestStatus">"SmartSelftestStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_drive_ata_dup_smart_selftest_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_drive_ata_get_smart_selftest_status (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_smart_selftest_status (object);
}

/**
 * udisks_drive_ata_dup_smart_selftest_status: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestStatus">"SmartSelftestStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_drive_ata_dup_smart_selftest_status (UDisksDriveAta *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "smart-selftest-status", &value, NULL);
  return value;
}

/**
 * udisks_drive_ata_set_smart_selftest_status: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestStatus">"SmartSelftestStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_smart_selftest_status (UDisksDriveAta *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "smart-selftest-status", value, NULL);
}

/**
 * udisks_drive_ata_get_smart_selftest_percent_remaining: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestPercentRemaining">"SmartSelftestPercentRemaining"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
udisks_drive_ata_get_smart_selftest_percent_remaining (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_smart_selftest_percent_remaining (object);
}

/**
 * udisks_drive_ata_set_smart_selftest_percent_remaining: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestPercentRemaining">"SmartSelftestPercentRemaining"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_smart_selftest_percent_remaining (UDisksDriveAta *object, gint value)
{
  g_object_set (G_OBJECT (object), "smart-selftest-percent-remaining", value, NULL);
}

/**
 * udisks_drive_ata_get_pm_supported: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.PmSupported">"PmSupported"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_ata_get_pm_supported (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_pm_supported (object);
}

/**
 * udisks_drive_ata_set_pm_supported: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.PmSupported">"PmSupported"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_pm_supported (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "pm-supported", value, NULL);
}

/**
 * udisks_drive_ata_get_pm_enabled: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.PmEnabled">"PmEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_ata_get_pm_enabled (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_pm_enabled (object);
}

/**
 * udisks_drive_ata_set_pm_enabled: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.PmEnabled">"PmEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_pm_enabled (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "pm-enabled", value, NULL);
}

/**
 * udisks_drive_ata_get_apm_supported: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.ApmSupported">"ApmSupported"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_ata_get_apm_supported (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_apm_supported (object);
}

/**
 * udisks_drive_ata_set_apm_supported: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.ApmSupported">"ApmSupported"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_apm_supported (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "apm-supported", value, NULL);
}

/**
 * udisks_drive_ata_get_apm_enabled: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.ApmEnabled">"ApmEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_ata_get_apm_enabled (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_apm_enabled (object);
}

/**
 * udisks_drive_ata_set_apm_enabled: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.ApmEnabled">"ApmEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_apm_enabled (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "apm-enabled", value, NULL);
}

/**
 * udisks_drive_ata_get_aam_supported: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.AamSupported">"AamSupported"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_ata_get_aam_supported (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_aam_supported (object);
}

/**
 * udisks_drive_ata_set_aam_supported: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.AamSupported">"AamSupported"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_aam_supported (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "aam-supported", value, NULL);
}

/**
 * udisks_drive_ata_get_aam_enabled: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.AamEnabled">"AamEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_ata_get_aam_enabled (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_aam_enabled (object);
}

/**
 * udisks_drive_ata_set_aam_enabled: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.AamEnabled">"AamEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_aam_enabled (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "aam-enabled", value, NULL);
}

/**
 * udisks_drive_ata_get_aam_vendor_recommended_value: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.AamVendorRecommendedValue">"AamVendorRecommendedValue"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
udisks_drive_ata_get_aam_vendor_recommended_value (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_aam_vendor_recommended_value (object);
}

/**
 * udisks_drive_ata_set_aam_vendor_recommended_value: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.AamVendorRecommendedValue">"AamVendorRecommendedValue"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_aam_vendor_recommended_value (UDisksDriveAta *object, gint value)
{
  g_object_set (G_OBJECT (object), "aam-vendor-recommended-value", value, NULL);
}

/**
 * udisks_drive_ata_get_write_cache_supported: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.WriteCacheSupported">"WriteCacheSupported"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 *
 * Since: 2.0.0
 */
gboolean 
udisks_drive_ata_get_write_cache_supported (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_write_cache_supported (object);
}

/**
 * udisks_drive_ata_set_write_cache_supported: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.WriteCacheSupported">"WriteCacheSupported"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 2.0.0
 */
void
udisks_drive_ata_set_write_cache_supported (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "write-cache-supported", value, NULL);
}

/**
 * udisks_drive_ata_get_write_cache_enabled: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.WriteCacheEnabled">"WriteCacheEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 *
 * Since: 2.0.0
 */
gboolean 
udisks_drive_ata_get_write_cache_enabled (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_write_cache_enabled (object);
}

/**
 * udisks_drive_ata_set_write_cache_enabled: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.WriteCacheEnabled">"WriteCacheEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 2.0.0
 */
void
udisks_drive_ata_set_write_cache_enabled (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "write-cache-enabled", value, NULL);
}

/**
 * udisks_drive_ata_get_read_lookahead_supported: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.ReadLookaheadSupported">"ReadLookaheadSupported"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 *
 * Since: 2.1.7
 */
gboolean 
udisks_drive_ata_get_read_lookahead_supported (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_read_lookahead_supported (object);
}

/**
 * udisks_drive_ata_set_read_lookahead_supported: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.ReadLookaheadSupported">"ReadLookaheadSupported"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 2.1.7
 */
void
udisks_drive_ata_set_read_lookahead_supported (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "read-lookahead-supported", value, NULL);
}

/**
 * udisks_drive_ata_get_read_lookahead_enabled: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.ReadLookaheadEnabled">"ReadLookaheadEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 *
 * Since: 2.1.7
 */
gboolean 
udisks_drive_ata_get_read_lookahead_enabled (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_read_lookahead_enabled (object);
}

/**
 * udisks_drive_ata_set_read_lookahead_enabled: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.ReadLookaheadEnabled">"ReadLookaheadEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 2.1.7
 */
void
udisks_drive_ata_set_read_lookahead_enabled (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "read-lookahead-enabled", value, NULL);
}

/**
 * udisks_drive_ata_get_security_erase_unit_minutes: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SecurityEraseUnitMinutes">"SecurityEraseUnitMinutes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
udisks_drive_ata_get_security_erase_unit_minutes (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_security_erase_unit_minutes (object);
}

/**
 * udisks_drive_ata_set_security_erase_unit_minutes: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SecurityEraseUnitMinutes">"SecurityEraseUnitMinutes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_security_erase_unit_minutes (UDisksDriveAta *object, gint value)
{
  g_object_set (G_OBJECT (object), "security-erase-unit-minutes", value, NULL);
}

/**
 * udisks_drive_ata_get_security_enhanced_erase_unit_minutes: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SecurityEnhancedEraseUnitMinutes">"SecurityEnhancedEraseUnitMinutes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
udisks_drive_ata_get_security_enhanced_erase_unit_minutes (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_security_enhanced_erase_unit_minutes (object);
}

/**
 * udisks_drive_ata_set_security_enhanced_erase_unit_minutes: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SecurityEnhancedEraseUnitMinutes">"SecurityEnhancedEraseUnitMinutes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_security_enhanced_erase_unit_minutes (UDisksDriveAta *object, gint value)
{
  g_object_set (G_OBJECT (object), "security-enhanced-erase-unit-minutes", value, NULL);
}

/**
 * udisks_drive_ata_get_security_frozen: (skip)
 * @object: A #UDisksDriveAta.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SecurityFrozen">"SecurityFrozen"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_drive_ata_get_security_frozen (UDisksDriveAta *object)
{
  return UDISKS_DRIVE_ATA_GET_IFACE (object)->get_security_frozen (object);
}

/**
 * udisks_drive_ata_set_security_frozen: (skip)
 * @object: A #UDisksDriveAta.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Drive-Ata.SecurityFrozen">"SecurityFrozen"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_drive_ata_set_security_frozen (UDisksDriveAta *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "security-frozen", value, NULL);
}

/**
 * udisks_drive_ata_call_smart_update:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartUpdate">SmartUpdate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_ata_call_smart_update_finish() to get the result of the operation.
 *
 * See udisks_drive_ata_call_smart_update_sync() for the synchronous, blocking version of this method.
 */
void
udisks_drive_ata_call_smart_update (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SmartUpdate",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_drive_ata_call_smart_update_finish:
 * @proxy: A #UDisksDriveAtaProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_ata_call_smart_update().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_drive_ata_call_smart_update().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_smart_update_finish (
    UDisksDriveAta *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_smart_update_sync:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartUpdate">SmartUpdate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_ata_call_smart_update() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_smart_update_sync (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SmartUpdate",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_smart_get_attributes:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartGetAttributes">SmartGetAttributes()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_ata_call_smart_get_attributes_finish() to get the result of the operation.
 *
 * See udisks_drive_ata_call_smart_get_attributes_sync() for the synchronous, blocking version of this method.
 */
void
udisks_drive_ata_call_smart_get_attributes (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SmartGetAttributes",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_drive_ata_call_smart_get_attributes_finish:
 * @proxy: A #UDisksDriveAtaProxy.
 * @out_attributes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_ata_call_smart_get_attributes().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_drive_ata_call_smart_get_attributes().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_smart_get_attributes_finish (
    UDisksDriveAta *proxy,
    GVariant **out_attributes,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ysqiiixia{sv}))",
                 out_attributes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_smart_get_attributes_sync:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_attributes: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartGetAttributes">SmartGetAttributes()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_ata_call_smart_get_attributes() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_smart_get_attributes_sync (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    GVariant **out_attributes,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SmartGetAttributes",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ysqiiixia{sv}))",
                 out_attributes);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_smart_selftest_start:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestStart">SmartSelftestStart()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_ata_call_smart_selftest_start_finish() to get the result of the operation.
 *
 * See udisks_drive_ata_call_smart_selftest_start_sync() for the synchronous, blocking version of this method.
 */
void
udisks_drive_ata_call_smart_selftest_start (
    UDisksDriveAta *proxy,
    const gchar *arg_type,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SmartSelftestStart",
    g_variant_new ("(s@a{sv})",
                   arg_type,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_drive_ata_call_smart_selftest_start_finish:
 * @proxy: A #UDisksDriveAtaProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_ata_call_smart_selftest_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_drive_ata_call_smart_selftest_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_smart_selftest_start_finish (
    UDisksDriveAta *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_smart_selftest_start_sync:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestStart">SmartSelftestStart()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_ata_call_smart_selftest_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_smart_selftest_start_sync (
    UDisksDriveAta *proxy,
    const gchar *arg_type,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SmartSelftestStart",
    g_variant_new ("(s@a{sv})",
                   arg_type,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_smart_selftest_abort:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestAbort">SmartSelftestAbort()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_ata_call_smart_selftest_abort_finish() to get the result of the operation.
 *
 * See udisks_drive_ata_call_smart_selftest_abort_sync() for the synchronous, blocking version of this method.
 */
void
udisks_drive_ata_call_smart_selftest_abort (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SmartSelftestAbort",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_drive_ata_call_smart_selftest_abort_finish:
 * @proxy: A #UDisksDriveAtaProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_ata_call_smart_selftest_abort().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_drive_ata_call_smart_selftest_abort().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_smart_selftest_abort_finish (
    UDisksDriveAta *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_smart_selftest_abort_sync:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestAbort">SmartSelftestAbort()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_ata_call_smart_selftest_abort() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_smart_selftest_abort_sync (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SmartSelftestAbort",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_smart_set_enabled:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_value: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartSetEnabled">SmartSetEnabled()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_ata_call_smart_set_enabled_finish() to get the result of the operation.
 *
 * See udisks_drive_ata_call_smart_set_enabled_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.0.0
 */
void
udisks_drive_ata_call_smart_set_enabled (
    UDisksDriveAta *proxy,
    gboolean arg_value,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SmartSetEnabled",
    g_variant_new ("(b@a{sv})",
                   arg_value,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_drive_ata_call_smart_set_enabled_finish:
 * @proxy: A #UDisksDriveAtaProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_ata_call_smart_set_enabled().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_drive_ata_call_smart_set_enabled().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.0.0
 */
gboolean
udisks_drive_ata_call_smart_set_enabled_finish (
    UDisksDriveAta *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_smart_set_enabled_sync:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_value: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartSetEnabled">SmartSetEnabled()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_ata_call_smart_set_enabled() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.0.0
 */
gboolean
udisks_drive_ata_call_smart_set_enabled_sync (
    UDisksDriveAta *proxy,
    gboolean arg_value,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SmartSetEnabled",
    g_variant_new ("(b@a{sv})",
                   arg_value,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_pm_get_state:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.PmGetState">PmGetState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_ata_call_pm_get_state_finish() to get the result of the operation.
 *
 * See udisks_drive_ata_call_pm_get_state_sync() for the synchronous, blocking version of this method.
 */
void
udisks_drive_ata_call_pm_get_state (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PmGetState",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_drive_ata_call_pm_get_state_finish:
 * @proxy: A #UDisksDriveAtaProxy.
 * @out_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_ata_call_pm_get_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_drive_ata_call_pm_get_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_pm_get_state_finish (
    UDisksDriveAta *proxy,
    guchar *out_state,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(y)",
                 out_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_pm_get_state_sync:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.PmGetState">PmGetState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_ata_call_pm_get_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_pm_get_state_sync (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    guchar *out_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PmGetState",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(y)",
                 out_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_pm_standby:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.PmStandby">PmStandby()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_ata_call_pm_standby_finish() to get the result of the operation.
 *
 * See udisks_drive_ata_call_pm_standby_sync() for the synchronous, blocking version of this method.
 */
void
udisks_drive_ata_call_pm_standby (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PmStandby",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_drive_ata_call_pm_standby_finish:
 * @proxy: A #UDisksDriveAtaProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_ata_call_pm_standby().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_drive_ata_call_pm_standby().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_pm_standby_finish (
    UDisksDriveAta *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_pm_standby_sync:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.PmStandby">PmStandby()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_ata_call_pm_standby() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_pm_standby_sync (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PmStandby",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_pm_wakeup:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.PmWakeup">PmWakeup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_ata_call_pm_wakeup_finish() to get the result of the operation.
 *
 * See udisks_drive_ata_call_pm_wakeup_sync() for the synchronous, blocking version of this method.
 */
void
udisks_drive_ata_call_pm_wakeup (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PmWakeup",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_drive_ata_call_pm_wakeup_finish:
 * @proxy: A #UDisksDriveAtaProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_ata_call_pm_wakeup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_drive_ata_call_pm_wakeup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_pm_wakeup_finish (
    UDisksDriveAta *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_pm_wakeup_sync:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.PmWakeup">PmWakeup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_ata_call_pm_wakeup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_pm_wakeup_sync (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PmWakeup",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_security_erase_unit:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SecurityEraseUnit">SecurityEraseUnit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_ata_call_security_erase_unit_finish() to get the result of the operation.
 *
 * See udisks_drive_ata_call_security_erase_unit_sync() for the synchronous, blocking version of this method.
 */
void
udisks_drive_ata_call_security_erase_unit (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SecurityEraseUnit",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_drive_ata_call_security_erase_unit_finish:
 * @proxy: A #UDisksDriveAtaProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_ata_call_security_erase_unit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_drive_ata_call_security_erase_unit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_security_erase_unit_finish (
    UDisksDriveAta *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_call_security_erase_unit_sync:
 * @proxy: A #UDisksDriveAtaProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SecurityEraseUnit">SecurityEraseUnit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_ata_call_security_erase_unit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_drive_ata_call_security_erase_unit_sync (
    UDisksDriveAta *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SecurityEraseUnit",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_drive_ata_complete_smart_update:
 * @object: A #UDisksDriveAta.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartUpdate">SmartUpdate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_drive_ata_complete_smart_update (
    UDisksDriveAta *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_drive_ata_complete_smart_get_attributes:
 * @object: A #UDisksDriveAta.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @attributes: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartGetAttributes">SmartGetAttributes()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_drive_ata_complete_smart_get_attributes (
    UDisksDriveAta *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *attributes)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(ysqiiixia{sv}))",
                   attributes));
}

/**
 * udisks_drive_ata_complete_smart_selftest_start:
 * @object: A #UDisksDriveAta.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestStart">SmartSelftestStart()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_drive_ata_complete_smart_selftest_start (
    UDisksDriveAta *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_drive_ata_complete_smart_selftest_abort:
 * @object: A #UDisksDriveAta.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartSelftestAbort">SmartSelftestAbort()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_drive_ata_complete_smart_selftest_abort (
    UDisksDriveAta *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_drive_ata_complete_smart_set_enabled:
 * @object: A #UDisksDriveAta.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SmartSetEnabled">SmartSetEnabled()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.0.0
 */
void
udisks_drive_ata_complete_smart_set_enabled (
    UDisksDriveAta *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_drive_ata_complete_pm_get_state:
 * @object: A #UDisksDriveAta.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @state: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.PmGetState">PmGetState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_drive_ata_complete_pm_get_state (
    UDisksDriveAta *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guchar state)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(y)",
                   state));
}

/**
 * udisks_drive_ata_complete_pm_standby:
 * @object: A #UDisksDriveAta.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.PmStandby">PmStandby()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_drive_ata_complete_pm_standby (
    UDisksDriveAta *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_drive_ata_complete_pm_wakeup:
 * @object: A #UDisksDriveAta.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.PmWakeup">PmWakeup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_drive_ata_complete_pm_wakeup (
    UDisksDriveAta *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_drive_ata_complete_security_erase_unit:
 * @object: A #UDisksDriveAta.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Drive-Ata.SecurityEraseUnit">SecurityEraseUnit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_drive_ata_complete_security_erase_unit (
    UDisksDriveAta *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * UDisksDriveAtaProxy:
 *
 * The #UDisksDriveAtaProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksDriveAtaProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksDriveAtaProxy.
 */

struct _UDisksDriveAtaProxyPrivate
{
  GData *qdata;
};

static void udisks_drive_ata_proxy_iface_init (UDisksDriveAtaIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksDriveAtaProxy, udisks_drive_ata_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (UDisksDriveAtaProxy)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_DRIVE_ATA, udisks_drive_ata_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksDriveAtaProxy, udisks_drive_ata_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_DRIVE_ATA, udisks_drive_ata_proxy_iface_init))

#endif
static void
udisks_drive_ata_proxy_finalize (GObject *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (udisks_drive_ata_proxy_parent_class)->finalize (object);
}

static void
udisks_drive_ata_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 25);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_drive_ata_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
udisks_drive_ata_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.UDisks2.Drive.Ata: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
udisks_drive_ata_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 25);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_drive_ata_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.UDisks2.Drive.Ata", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) udisks_drive_ata_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
udisks_drive_ata_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_udisks_drive_ata_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], UDISKS_TYPE_DRIVE_ATA);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_DRIVE_ATA);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
udisks_drive_ata_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_drive_ata_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_drive_ata_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
udisks_drive_ata_proxy_get_smart_supported (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SmartSupported");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_ata_proxy_get_smart_enabled (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SmartEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
udisks_drive_ata_proxy_get_smart_updated (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SmartUpdated");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_ata_proxy_get_smart_failing (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SmartFailing");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
udisks_drive_ata_proxy_get_smart_power_on_seconds (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SmartPowerOnSeconds");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
udisks_drive_ata_proxy_get_smart_temperature (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gdouble value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SmartTemperature");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
udisks_drive_ata_proxy_get_smart_num_attributes_failing (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SmartNumAttributesFailing");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
udisks_drive_ata_proxy_get_smart_num_attributes_failed_in_the_past (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SmartNumAttributesFailedInThePast");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint64 
udisks_drive_ata_proxy_get_smart_num_bad_sectors (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SmartNumBadSectors");
  if (variant != NULL)
    {
      value = g_variant_get_int64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_drive_ata_proxy_get_smart_selftest_status (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SmartSelftestStatus");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
udisks_drive_ata_proxy_get_smart_selftest_percent_remaining (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SmartSelftestPercentRemaining");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_ata_proxy_get_pm_supported (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PmSupported");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_ata_proxy_get_pm_enabled (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PmEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_ata_proxy_get_apm_supported (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ApmSupported");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_ata_proxy_get_apm_enabled (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ApmEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_ata_proxy_get_aam_supported (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AamSupported");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_ata_proxy_get_aam_enabled (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AamEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
udisks_drive_ata_proxy_get_aam_vendor_recommended_value (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AamVendorRecommendedValue");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_ata_proxy_get_write_cache_supported (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WriteCacheSupported");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_ata_proxy_get_write_cache_enabled (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WriteCacheEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_ata_proxy_get_read_lookahead_supported (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ReadLookaheadSupported");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_ata_proxy_get_read_lookahead_enabled (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ReadLookaheadEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
udisks_drive_ata_proxy_get_security_erase_unit_minutes (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SecurityEraseUnitMinutes");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
udisks_drive_ata_proxy_get_security_enhanced_erase_unit_minutes (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SecurityEnhancedEraseUnitMinutes");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_drive_ata_proxy_get_security_frozen (UDisksDriveAta *object)
{
  UDisksDriveAtaProxy *proxy = UDISKS_DRIVE_ATA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SecurityFrozen");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
udisks_drive_ata_proxy_init (UDisksDriveAtaProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = udisks_drive_ata_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, UDISKS_TYPE_DRIVE_ATA_PROXY, UDisksDriveAtaProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), udisks_drive_ata_interface_info ());
}

static void
udisks_drive_ata_proxy_class_init (UDisksDriveAtaProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = udisks_drive_ata_proxy_finalize;
  gobject_class->get_property = udisks_drive_ata_proxy_get_property;
  gobject_class->set_property = udisks_drive_ata_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = udisks_drive_ata_proxy_g_signal;
  proxy_class->g_properties_changed = udisks_drive_ata_proxy_g_properties_changed;

  udisks_drive_ata_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksDriveAtaProxyPrivate));
#endif
}

static void
udisks_drive_ata_proxy_iface_init (UDisksDriveAtaIface *iface)
{
  iface->get_smart_supported = udisks_drive_ata_proxy_get_smart_supported;
  iface->get_smart_enabled = udisks_drive_ata_proxy_get_smart_enabled;
  iface->get_smart_updated = udisks_drive_ata_proxy_get_smart_updated;
  iface->get_smart_failing = udisks_drive_ata_proxy_get_smart_failing;
  iface->get_smart_power_on_seconds = udisks_drive_ata_proxy_get_smart_power_on_seconds;
  iface->get_smart_temperature = udisks_drive_ata_proxy_get_smart_temperature;
  iface->get_smart_num_attributes_failing = udisks_drive_ata_proxy_get_smart_num_attributes_failing;
  iface->get_smart_num_attributes_failed_in_the_past = udisks_drive_ata_proxy_get_smart_num_attributes_failed_in_the_past;
  iface->get_smart_num_bad_sectors = udisks_drive_ata_proxy_get_smart_num_bad_sectors;
  iface->get_smart_selftest_status = udisks_drive_ata_proxy_get_smart_selftest_status;
  iface->get_smart_selftest_percent_remaining = udisks_drive_ata_proxy_get_smart_selftest_percent_remaining;
  iface->get_pm_supported = udisks_drive_ata_proxy_get_pm_supported;
  iface->get_pm_enabled = udisks_drive_ata_proxy_get_pm_enabled;
  iface->get_apm_supported = udisks_drive_ata_proxy_get_apm_supported;
  iface->get_apm_enabled = udisks_drive_ata_proxy_get_apm_enabled;
  iface->get_aam_supported = udisks_drive_ata_proxy_get_aam_supported;
  iface->get_aam_enabled = udisks_drive_ata_proxy_get_aam_enabled;
  iface->get_aam_vendor_recommended_value = udisks_drive_ata_proxy_get_aam_vendor_recommended_value;
  iface->get_write_cache_supported = udisks_drive_ata_proxy_get_write_cache_supported;
  iface->get_write_cache_enabled = udisks_drive_ata_proxy_get_write_cache_enabled;
  iface->get_read_lookahead_supported = udisks_drive_ata_proxy_get_read_lookahead_supported;
  iface->get_read_lookahead_enabled = udisks_drive_ata_proxy_get_read_lookahead_enabled;
  iface->get_security_erase_unit_minutes = udisks_drive_ata_proxy_get_security_erase_unit_minutes;
  iface->get_security_enhanced_erase_unit_minutes = udisks_drive_ata_proxy_get_security_enhanced_erase_unit_minutes;
  iface->get_security_frozen = udisks_drive_ata_proxy_get_security_frozen;
}

/**
 * udisks_drive_ata_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive-Ata.top_of_page">org.freedesktop.UDisks2.Drive.Ata</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_ata_proxy_new_finish() to get the result of the operation.
 *
 * See udisks_drive_ata_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_drive_ata_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_DRIVE_ATA_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Drive.Ata", NULL);
}

/**
 * udisks_drive_ata_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_ata_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_drive_ata_proxy_new().
 *
 * Returns: (transfer full) (type UDisksDriveAtaProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksDriveAta *
udisks_drive_ata_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_DRIVE_ATA (ret);
  else
    return NULL;
}

/**
 * udisks_drive_ata_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive-Ata.top_of_page">org.freedesktop.UDisks2.Drive.Ata</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_ata_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksDriveAtaProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksDriveAta *
udisks_drive_ata_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_DRIVE_ATA_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Drive.Ata", NULL);
  if (ret != NULL)
    return UDISKS_DRIVE_ATA (ret);
  else
    return NULL;
}


/**
 * udisks_drive_ata_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like udisks_drive_ata_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_drive_ata_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See udisks_drive_ata_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_drive_ata_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_DRIVE_ATA_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Drive.Ata", NULL);
}

/**
 * udisks_drive_ata_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_drive_ata_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_drive_ata_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type UDisksDriveAtaProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksDriveAta *
udisks_drive_ata_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_DRIVE_ATA (ret);
  else
    return NULL;
}

/**
 * udisks_drive_ata_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like udisks_drive_ata_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_drive_ata_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksDriveAtaProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksDriveAta *
udisks_drive_ata_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_DRIVE_ATA_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Drive.Ata", NULL);
  if (ret != NULL)
    return UDISKS_DRIVE_ATA (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * UDisksDriveAtaSkeleton:
 *
 * The #UDisksDriveAtaSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksDriveAtaSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksDriveAtaSkeleton.
 */

struct _UDisksDriveAtaSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_udisks_drive_ata_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], UDISKS_TYPE_DRIVE_ATA);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_DRIVE_ATA);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_udisks_drive_ata_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_drive_ata_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_udisks_drive_ata_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_drive_ata_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _udisks_drive_ata_skeleton_vtable =
{
  _udisks_drive_ata_skeleton_handle_method_call,
  _udisks_drive_ata_skeleton_handle_get_property,
  _udisks_drive_ata_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
udisks_drive_ata_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return udisks_drive_ata_interface_info ();
}

static GDBusInterfaceVTable *
udisks_drive_ata_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_udisks_drive_ata_skeleton_vtable;
}

static GVariant *
udisks_drive_ata_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_udisks_drive_ata_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _udisks_drive_ata_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _udisks_drive_ata_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _udisks_drive_ata_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.UDisks2.Drive.Ata", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _udisks_drive_ata_emit_changed (gpointer user_data);

static void
udisks_drive_ata_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _udisks_drive_ata_emit_changed (skeleton);
}

static void udisks_drive_ata_skeleton_iface_init (UDisksDriveAtaIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksDriveAtaSkeleton, udisks_drive_ata_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (UDisksDriveAtaSkeleton)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_DRIVE_ATA, udisks_drive_ata_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksDriveAtaSkeleton, udisks_drive_ata_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_DRIVE_ATA, udisks_drive_ata_skeleton_iface_init))

#endif
static void
udisks_drive_ata_skeleton_finalize (GObject *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  guint n;
  for (n = 0; n < 25; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (udisks_drive_ata_skeleton_parent_class)->finalize (object);
}

static void
udisks_drive_ata_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 25);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_udisks_drive_ata_emit_changed (gpointer user_data)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.UDisks2.Drive.Ata",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_udisks_drive_ata_schedule_emit_changed (UDisksDriveAtaSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
udisks_drive_ata_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _udisks_drive_ata_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _udisks_drive_ata_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
udisks_drive_ata_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 25);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_drive_ata_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _udisks_drive_ata_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
udisks_drive_ata_skeleton_init (UDisksDriveAtaSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = udisks_drive_ata_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, UDISKS_TYPE_DRIVE_ATA_SKELETON, UDisksDriveAtaSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 25);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_INT64);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[15], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[16], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[17], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[18], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[19], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[20], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[21], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[22], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[23], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[24], G_TYPE_BOOLEAN);
}

static gboolean 
udisks_drive_ata_skeleton_get_smart_supported (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_ata_skeleton_get_smart_enabled (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
udisks_drive_ata_skeleton_get_smart_updated (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_ata_skeleton_get_smart_failing (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
udisks_drive_ata_skeleton_get_smart_power_on_seconds (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
udisks_drive_ata_skeleton_get_smart_temperature (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_double (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
udisks_drive_ata_skeleton_get_smart_num_attributes_failing (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
udisks_drive_ata_skeleton_get_smart_num_attributes_failed_in_the_past (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint64 
udisks_drive_ata_skeleton_get_smart_num_bad_sectors (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int64 (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_drive_ata_skeleton_get_smart_selftest_status (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
udisks_drive_ata_skeleton_get_smart_selftest_percent_remaining (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_ata_skeleton_get_pm_supported (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_ata_skeleton_get_pm_enabled (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_ata_skeleton_get_apm_supported (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_ata_skeleton_get_apm_enabled (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_ata_skeleton_get_aam_supported (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[15]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_ata_skeleton_get_aam_enabled (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[16]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
udisks_drive_ata_skeleton_get_aam_vendor_recommended_value (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[17]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_ata_skeleton_get_write_cache_supported (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[18]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_ata_skeleton_get_write_cache_enabled (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[19]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_ata_skeleton_get_read_lookahead_supported (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[20]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_ata_skeleton_get_read_lookahead_enabled (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[21]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
udisks_drive_ata_skeleton_get_security_erase_unit_minutes (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[22]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
udisks_drive_ata_skeleton_get_security_enhanced_erase_unit_minutes (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[23]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_drive_ata_skeleton_get_security_frozen (UDisksDriveAta *object)
{
  UDisksDriveAtaSkeleton *skeleton = UDISKS_DRIVE_ATA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[24]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
udisks_drive_ata_skeleton_class_init (UDisksDriveAtaSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = udisks_drive_ata_skeleton_finalize;
  gobject_class->get_property = udisks_drive_ata_skeleton_get_property;
  gobject_class->set_property = udisks_drive_ata_skeleton_set_property;
  gobject_class->notify       = udisks_drive_ata_skeleton_notify;


  udisks_drive_ata_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = udisks_drive_ata_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = udisks_drive_ata_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = udisks_drive_ata_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = udisks_drive_ata_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksDriveAtaSkeletonPrivate));
#endif
}

static void
udisks_drive_ata_skeleton_iface_init (UDisksDriveAtaIface *iface)
{
  iface->get_smart_supported = udisks_drive_ata_skeleton_get_smart_supported;
  iface->get_smart_enabled = udisks_drive_ata_skeleton_get_smart_enabled;
  iface->get_smart_updated = udisks_drive_ata_skeleton_get_smart_updated;
  iface->get_smart_failing = udisks_drive_ata_skeleton_get_smart_failing;
  iface->get_smart_power_on_seconds = udisks_drive_ata_skeleton_get_smart_power_on_seconds;
  iface->get_smart_temperature = udisks_drive_ata_skeleton_get_smart_temperature;
  iface->get_smart_num_attributes_failing = udisks_drive_ata_skeleton_get_smart_num_attributes_failing;
  iface->get_smart_num_attributes_failed_in_the_past = udisks_drive_ata_skeleton_get_smart_num_attributes_failed_in_the_past;
  iface->get_smart_num_bad_sectors = udisks_drive_ata_skeleton_get_smart_num_bad_sectors;
  iface->get_smart_selftest_status = udisks_drive_ata_skeleton_get_smart_selftest_status;
  iface->get_smart_selftest_percent_remaining = udisks_drive_ata_skeleton_get_smart_selftest_percent_remaining;
  iface->get_pm_supported = udisks_drive_ata_skeleton_get_pm_supported;
  iface->get_pm_enabled = udisks_drive_ata_skeleton_get_pm_enabled;
  iface->get_apm_supported = udisks_drive_ata_skeleton_get_apm_supported;
  iface->get_apm_enabled = udisks_drive_ata_skeleton_get_apm_enabled;
  iface->get_aam_supported = udisks_drive_ata_skeleton_get_aam_supported;
  iface->get_aam_enabled = udisks_drive_ata_skeleton_get_aam_enabled;
  iface->get_aam_vendor_recommended_value = udisks_drive_ata_skeleton_get_aam_vendor_recommended_value;
  iface->get_write_cache_supported = udisks_drive_ata_skeleton_get_write_cache_supported;
  iface->get_write_cache_enabled = udisks_drive_ata_skeleton_get_write_cache_enabled;
  iface->get_read_lookahead_supported = udisks_drive_ata_skeleton_get_read_lookahead_supported;
  iface->get_read_lookahead_enabled = udisks_drive_ata_skeleton_get_read_lookahead_enabled;
  iface->get_security_erase_unit_minutes = udisks_drive_ata_skeleton_get_security_erase_unit_minutes;
  iface->get_security_enhanced_erase_unit_minutes = udisks_drive_ata_skeleton_get_security_enhanced_erase_unit_minutes;
  iface->get_security_frozen = udisks_drive_ata_skeleton_get_security_frozen;
}

/**
 * udisks_drive_ata_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Drive-Ata.top_of_page">org.freedesktop.UDisks2.Drive.Ata</link>.
 *
 * Returns: (transfer full) (type UDisksDriveAtaSkeleton): The skeleton object.
 */
UDisksDriveAta *
udisks_drive_ata_skeleton_new (void)
{
  return UDISKS_DRIVE_ATA (g_object_new (UDISKS_TYPE_DRIVE_ATA_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.UDisks2.Block
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:UDisksBlock
 * @title: UDisksBlock
 * @short_description: Generated C code for the org.freedesktop.UDisks2.Block D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Block.top_of_page">org.freedesktop.UDisks2.Block</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.UDisks2.Block ---- */

static const _ExtendedGDBusArgInfo _udisks_block_method_info_add_configuration_item_IN_ARG_item =
{
  {
    -1,
    (gchar *) "item",
    (gchar *) "(sa{sv})",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_add_configuration_item_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_add_configuration_item_IN_ARG_pointers[] =
{
  &_udisks_block_method_info_add_configuration_item_IN_ARG_item.parent_struct,
  &_udisks_block_method_info_add_configuration_item_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_block_method_info_add_configuration_item =
{
  {
    -1,
    (gchar *) "AddConfigurationItem",
    (GDBusArgInfo **) &_udisks_block_method_info_add_configuration_item_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-add-configuration-item",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_remove_configuration_item_IN_ARG_item =
{
  {
    -1,
    (gchar *) "item",
    (gchar *) "(sa{sv})",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_remove_configuration_item_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_remove_configuration_item_IN_ARG_pointers[] =
{
  &_udisks_block_method_info_remove_configuration_item_IN_ARG_item.parent_struct,
  &_udisks_block_method_info_remove_configuration_item_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_block_method_info_remove_configuration_item =
{
  {
    -1,
    (gchar *) "RemoveConfigurationItem",
    (GDBusArgInfo **) &_udisks_block_method_info_remove_configuration_item_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-remove-configuration-item",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_update_configuration_item_IN_ARG_old_item =
{
  {
    -1,
    (gchar *) "old_item",
    (gchar *) "(sa{sv})",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_update_configuration_item_IN_ARG_new_item =
{
  {
    -1,
    (gchar *) "new_item",
    (gchar *) "(sa{sv})",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_update_configuration_item_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_update_configuration_item_IN_ARG_pointers[] =
{
  &_udisks_block_method_info_update_configuration_item_IN_ARG_old_item.parent_struct,
  &_udisks_block_method_info_update_configuration_item_IN_ARG_new_item.parent_struct,
  &_udisks_block_method_info_update_configuration_item_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_block_method_info_update_configuration_item =
{
  {
    -1,
    (gchar *) "UpdateConfigurationItem",
    (GDBusArgInfo **) &_udisks_block_method_info_update_configuration_item_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-update-configuration-item",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_get_secret_configuration_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_get_secret_configuration_IN_ARG_pointers[] =
{
  &_udisks_block_method_info_get_secret_configuration_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_get_secret_configuration_OUT_ARG_configuration =
{
  {
    -1,
    (gchar *) "configuration",
    (gchar *) "a(sa{sv})",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_get_secret_configuration_OUT_ARG_pointers[] =
{
  &_udisks_block_method_info_get_secret_configuration_OUT_ARG_configuration.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_block_method_info_get_secret_configuration =
{
  {
    -1,
    (gchar *) "GetSecretConfiguration",
    (GDBusArgInfo **) &_udisks_block_method_info_get_secret_configuration_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_block_method_info_get_secret_configuration_OUT_ARG_pointers,
    NULL
  },
  "handle-get-secret-configuration",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_format_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_format_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_format_IN_ARG_pointers[] =
{
  &_udisks_block_method_info_format_IN_ARG_type.parent_struct,
  &_udisks_block_method_info_format_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_block_method_info_format =
{
  {
    -1,
    (gchar *) "Format",
    (GDBusArgInfo **) &_udisks_block_method_info_format_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-format",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_open_for_backup_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_open_for_backup_IN_ARG_pointers[] =
{
  &_udisks_block_method_info_open_for_backup_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_open_for_backup_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_open_for_backup_OUT_ARG_pointers[] =
{
  &_udisks_block_method_info_open_for_backup_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_block_method_info_open_for_backup =
{
  {
    -1,
    (gchar *) "OpenForBackup",
    (GDBusArgInfo **) &_udisks_block_method_info_open_for_backup_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_block_method_info_open_for_backup_OUT_ARG_pointers,
    NULL
  },
  "handle-open-for-backup",
  TRUE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_open_for_restore_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_open_for_restore_IN_ARG_pointers[] =
{
  &_udisks_block_method_info_open_for_restore_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_open_for_restore_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_open_for_restore_OUT_ARG_pointers[] =
{
  &_udisks_block_method_info_open_for_restore_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_block_method_info_open_for_restore =
{
  {
    -1,
    (gchar *) "OpenForRestore",
    (GDBusArgInfo **) &_udisks_block_method_info_open_for_restore_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_block_method_info_open_for_restore_OUT_ARG_pointers,
    NULL
  },
  "handle-open-for-restore",
  TRUE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_open_for_benchmark_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_open_for_benchmark_IN_ARG_pointers[] =
{
  &_udisks_block_method_info_open_for_benchmark_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_open_for_benchmark_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_open_for_benchmark_OUT_ARG_pointers[] =
{
  &_udisks_block_method_info_open_for_benchmark_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_block_method_info_open_for_benchmark =
{
  {
    -1,
    (gchar *) "OpenForBenchmark",
    (GDBusArgInfo **) &_udisks_block_method_info_open_for_benchmark_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_block_method_info_open_for_benchmark_OUT_ARG_pointers,
    NULL
  },
  "handle-open-for-benchmark",
  TRUE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_open_device_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_open_device_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_open_device_IN_ARG_pointers[] =
{
  &_udisks_block_method_info_open_device_IN_ARG_mode.parent_struct,
  &_udisks_block_method_info_open_device_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_open_device_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_open_device_OUT_ARG_pointers[] =
{
  &_udisks_block_method_info_open_device_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_block_method_info_open_device =
{
  {
    -1,
    (gchar *) "OpenDevice",
    (GDBusArgInfo **) &_udisks_block_method_info_open_device_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_block_method_info_open_device_OUT_ARG_pointers,
    NULL
  },
  "handle-open-device",
  TRUE
};

static const _ExtendedGDBusArgInfo _udisks_block_method_info_rescan_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_block_method_info_rescan_IN_ARG_pointers[] =
{
  &_udisks_block_method_info_rescan_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_block_method_info_rescan =
{
  {
    -1,
    (gchar *) "Rescan",
    (GDBusArgInfo **) &_udisks_block_method_info_rescan_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-rescan",
  FALSE
};

static const GDBusMethodInfo * const _udisks_block_method_info_pointers[] =
{
  &_udisks_block_method_info_add_configuration_item.parent_struct,
  &_udisks_block_method_info_remove_configuration_item.parent_struct,
  &_udisks_block_method_info_update_configuration_item.parent_struct,
  &_udisks_block_method_info_get_secret_configuration.parent_struct,
  &_udisks_block_method_info_format.parent_struct,
  &_udisks_block_method_info_open_for_backup.parent_struct,
  &_udisks_block_method_info_open_for_restore.parent_struct,
  &_udisks_block_method_info_open_for_benchmark.parent_struct,
  &_udisks_block_method_info_open_device.parent_struct,
  &_udisks_block_method_info_rescan.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_device =
{
  {
    -1,
    (gchar *) "Device",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "device",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_preferred_device =
{
  {
    -1,
    (gchar *) "PreferredDevice",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "preferred-device",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_symlinks =
{
  {
    -1,
    (gchar *) "Symlinks",
    (gchar *) "aay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "symlinks",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_device_number =
{
  {
    -1,
    (gchar *) "DeviceNumber",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "device-number",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_id =
{
  {
    -1,
    (gchar *) "Id",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "id",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_size =
{
  {
    -1,
    (gchar *) "Size",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "size",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_read_only =
{
  {
    -1,
    (gchar *) "ReadOnly",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "read-only",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_drive =
{
  {
    -1,
    (gchar *) "Drive",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "drive",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_mdraid =
{
  {
    -1,
    (gchar *) "MDRaid",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "mdraid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_mdraid_member =
{
  {
    -1,
    (gchar *) "MDRaidMember",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "mdraid-member",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_id_usage =
{
  {
    -1,
    (gchar *) "IdUsage",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "id-usage",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_id_type =
{
  {
    -1,
    (gchar *) "IdType",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "id-type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_id_version =
{
  {
    -1,
    (gchar *) "IdVersion",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "id-version",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_id_label =
{
  {
    -1,
    (gchar *) "IdLabel",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "id-label",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_id_uuid =
{
  {
    -1,
    (gchar *) "IdUUID",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "id-uuid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_configuration =
{
  {
    -1,
    (gchar *) "Configuration",
    (gchar *) "a(sa{sv})",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "configuration",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_crypto_backing_device =
{
  {
    -1,
    (gchar *) "CryptoBackingDevice",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "crypto-backing-device",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_hint_partitionable =
{
  {
    -1,
    (gchar *) "HintPartitionable",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "hint-partitionable",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_hint_system =
{
  {
    -1,
    (gchar *) "HintSystem",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "hint-system",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_hint_ignore =
{
  {
    -1,
    (gchar *) "HintIgnore",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "hint-ignore",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_hint_auto =
{
  {
    -1,
    (gchar *) "HintAuto",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "hint-auto",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_hint_name =
{
  {
    -1,
    (gchar *) "HintName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "hint-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_hint_icon_name =
{
  {
    -1,
    (gchar *) "HintIconName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "hint-icon-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_hint_symbolic_icon_name =
{
  {
    -1,
    (gchar *) "HintSymbolicIconName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "hint-symbolic-icon-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_block_property_info_userspace_mount_options =
{
  {
    -1,
    (gchar *) "UserspaceMountOptions",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "userspace-mount-options",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _udisks_block_property_info_pointers[] =
{
  &_udisks_block_property_info_device.parent_struct,
  &_udisks_block_property_info_preferred_device.parent_struct,
  &_udisks_block_property_info_symlinks.parent_struct,
  &_udisks_block_property_info_device_number.parent_struct,
  &_udisks_block_property_info_id.parent_struct,
  &_udisks_block_property_info_size.parent_struct,
  &_udisks_block_property_info_read_only.parent_struct,
  &_udisks_block_property_info_drive.parent_struct,
  &_udisks_block_property_info_mdraid.parent_struct,
  &_udisks_block_property_info_mdraid_member.parent_struct,
  &_udisks_block_property_info_id_usage.parent_struct,
  &_udisks_block_property_info_id_type.parent_struct,
  &_udisks_block_property_info_id_version.parent_struct,
  &_udisks_block_property_info_id_label.parent_struct,
  &_udisks_block_property_info_id_uuid.parent_struct,
  &_udisks_block_property_info_configuration.parent_struct,
  &_udisks_block_property_info_crypto_backing_device.parent_struct,
  &_udisks_block_property_info_hint_partitionable.parent_struct,
  &_udisks_block_property_info_hint_system.parent_struct,
  &_udisks_block_property_info_hint_ignore.parent_struct,
  &_udisks_block_property_info_hint_auto.parent_struct,
  &_udisks_block_property_info_hint_name.parent_struct,
  &_udisks_block_property_info_hint_icon_name.parent_struct,
  &_udisks_block_property_info_hint_symbolic_icon_name.parent_struct,
  &_udisks_block_property_info_userspace_mount_options.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _udisks_block_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.UDisks2.Block",
    (GDBusMethodInfo **) &_udisks_block_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_udisks_block_property_info_pointers,
    NULL
  },
  "block",
};


/**
 * udisks_block_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Block.top_of_page">org.freedesktop.UDisks2.Block</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
udisks_block_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_udisks_block_interface_info.parent_struct;
}

/**
 * udisks_block_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #UDisksBlock interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
udisks_block_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "device");
  g_object_class_override_property (klass, property_id_begin++, "preferred-device");
  g_object_class_override_property (klass, property_id_begin++, "symlinks");
  g_object_class_override_property (klass, property_id_begin++, "device-number");
  g_object_class_override_property (klass, property_id_begin++, "id");
  g_object_class_override_property (klass, property_id_begin++, "size");
  g_object_class_override_property (klass, property_id_begin++, "read-only");
  g_object_class_override_property (klass, property_id_begin++, "drive");
  g_object_class_override_property (klass, property_id_begin++, "mdraid");
  g_object_class_override_property (klass, property_id_begin++, "mdraid-member");
  g_object_class_override_property (klass, property_id_begin++, "id-usage");
  g_object_class_override_property (klass, property_id_begin++, "id-type");
  g_object_class_override_property (klass, property_id_begin++, "id-version");
  g_object_class_override_property (klass, property_id_begin++, "id-label");
  g_object_class_override_property (klass, property_id_begin++, "id-uuid");
  g_object_class_override_property (klass, property_id_begin++, "configuration");
  g_object_class_override_property (klass, property_id_begin++, "crypto-backing-device");
  g_object_class_override_property (klass, property_id_begin++, "hint-partitionable");
  g_object_class_override_property (klass, property_id_begin++, "hint-system");
  g_object_class_override_property (klass, property_id_begin++, "hint-ignore");
  g_object_class_override_property (klass, property_id_begin++, "hint-auto");
  g_object_class_override_property (klass, property_id_begin++, "hint-name");
  g_object_class_override_property (klass, property_id_begin++, "hint-icon-name");
  g_object_class_override_property (klass, property_id_begin++, "hint-symbolic-icon-name");
  g_object_class_override_property (klass, property_id_begin++, "userspace-mount-options");
  return property_id_begin - 1;
}



/**
 * UDisksBlock:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Block.top_of_page">org.freedesktop.UDisks2.Block</link>.
 */

/**
 * UDisksBlockIface:
 * @parent_iface: The parent interface.
 * @handle_add_configuration_item: Handler for the #UDisksBlock::handle-add-configuration-item signal.
 * @handle_format: Handler for the #UDisksBlock::handle-format signal.
 * @handle_get_secret_configuration: Handler for the #UDisksBlock::handle-get-secret-configuration signal.
 * @handle_open_for_backup: Handler for the #UDisksBlock::handle-open-for-backup signal.
 * @handle_open_for_benchmark: Handler for the #UDisksBlock::handle-open-for-benchmark signal.
 * @handle_open_for_restore: Handler for the #UDisksBlock::handle-open-for-restore signal.
 * @handle_remove_configuration_item: Handler for the #UDisksBlock::handle-remove-configuration-item signal.
 * @handle_rescan: Handler for the #UDisksBlock::handle-rescan signal.
 * @handle_update_configuration_item: Handler for the #UDisksBlock::handle-update-configuration-item signal.
 * @get_configuration: Getter for the #UDisksBlock:configuration property.
 * @get_crypto_backing_device: Getter for the #UDisksBlock:crypto-backing-device property.
 * @get_device: Getter for the #UDisksBlock:device property.
 * @get_device_number: Getter for the #UDisksBlock:device-number property.
 * @get_drive: Getter for the #UDisksBlock:drive property.
 * @get_hint_auto: Getter for the #UDisksBlock:hint-auto property.
 * @get_hint_icon_name: Getter for the #UDisksBlock:hint-icon-name property.
 * @get_hint_ignore: Getter for the #UDisksBlock:hint-ignore property.
 * @get_hint_name: Getter for the #UDisksBlock:hint-name property.
 * @get_hint_partitionable: Getter for the #UDisksBlock:hint-partitionable property.
 * @get_hint_system: Getter for the #UDisksBlock:hint-system property.
 * @get_id_label: Getter for the #UDisksBlock:id-label property.
 * @get_id_type: Getter for the #UDisksBlock:id-type property.
 * @get_id_usage: Getter for the #UDisksBlock:id-usage property.
 * @get_id_uuid: Getter for the #UDisksBlock:id-uuid property.
 * @get_id_version: Getter for the #UDisksBlock:id-version property.
 * @get_preferred_device: Getter for the #UDisksBlock:preferred-device property.
 * @get_read_only: Getter for the #UDisksBlock:read-only property.
 * @get_size: Getter for the #UDisksBlock:size property.
 * @get_symlinks: Getter for the #UDisksBlock:symlinks property.
 * @get_userspace_mount_options: Getter for the #UDisksBlock:userspace-mount-options property.
 * @get_hint_symbolic_icon_name: Getter for the #UDisksBlock:hint-symbolic-icon-name property.
 * @get_id: Getter for the #UDisksBlock:id property.
 * @get_mdraid: Getter for the #UDisksBlock:mdraid property.
 * @get_mdraid_member: Getter for the #UDisksBlock:mdraid-member property.
 * @handle_open_device: Handler for the #UDisksBlock::handle-open-device signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Block.top_of_page">org.freedesktop.UDisks2.Block</link>.
 */

typedef UDisksBlockIface UDisksBlockInterface;
G_DEFINE_INTERFACE (UDisksBlock, udisks_block, G_TYPE_OBJECT)

static void
udisks_block_default_init (UDisksBlockIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * UDisksBlock::handle-add-configuration-item:
   * @object: A #UDisksBlock.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_item: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.AddConfigurationItem">AddConfigurationItem()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_block_complete_add_configuration_item() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-configuration-item",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksBlockIface, handle_add_configuration_item),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * UDisksBlock::handle-remove-configuration-item:
   * @object: A #UDisksBlock.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_item: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.RemoveConfigurationItem">RemoveConfigurationItem()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_block_complete_remove_configuration_item() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-remove-configuration-item",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksBlockIface, handle_remove_configuration_item),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * UDisksBlock::handle-update-configuration-item:
   * @object: A #UDisksBlock.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_old_item: Argument passed by remote caller.
   * @arg_new_item: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.UpdateConfigurationItem">UpdateConfigurationItem()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_block_complete_update_configuration_item() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update-configuration-item",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksBlockIface, handle_update_configuration_item),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * UDisksBlock::handle-get-secret-configuration:
   * @object: A #UDisksBlock.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.GetSecretConfiguration">GetSecretConfiguration()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_block_complete_get_secret_configuration() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-secret-configuration",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksBlockIface, handle_get_secret_configuration),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksBlock::handle-format:
   * @object: A #UDisksBlock.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_type: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.Format">Format()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_block_complete_format() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-format",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksBlockIface, handle_format),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * UDisksBlock::handle-open-for-backup:
   * @object: A #UDisksBlock.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenForBackup">OpenForBackup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_block_complete_open_for_backup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-for-backup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksBlockIface, handle_open_for_backup),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

  /**
   * UDisksBlock::handle-open-for-restore:
   * @object: A #UDisksBlock.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenForRestore">OpenForRestore()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_block_complete_open_for_restore() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-for-restore",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksBlockIface, handle_open_for_restore),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

  /**
   * UDisksBlock::handle-open-for-benchmark:
   * @object: A #UDisksBlock.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenForBenchmark">OpenForBenchmark()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_block_complete_open_for_benchmark() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-for-benchmark",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksBlockIface, handle_open_for_benchmark),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

  /**
   * UDisksBlock::handle-open-device:
   * @object: A #UDisksBlock.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_mode: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenDevice">OpenDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_block_complete_open_device() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.7.3
   */
  g_signal_new ("handle-open-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksBlockIface, handle_open_device),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * UDisksBlock::handle-rescan:
   * @object: A #UDisksBlock.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.Rescan">Rescan()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_block_complete_rescan() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-rescan",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksBlockIface, handle_rescan),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * UDisksBlock:device:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Device">"Device"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("device", "Device", "Device", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:preferred-device:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.PreferredDevice">"PreferredDevice"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("preferred-device", "PreferredDevice", "PreferredDevice", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:symlinks:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Symlinks">"Symlinks"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("symlinks", "Symlinks", "Symlinks", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:device-number:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.DeviceNumber">"DeviceNumber"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("device-number", "DeviceNumber", "DeviceNumber", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Id">"Id"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 2.0.0
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("id", "Id", "Id", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:size:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Size">"Size"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("size", "Size", "Size", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:read-only:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.ReadOnly">"ReadOnly"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("read-only", "ReadOnly", "ReadOnly", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:drive:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Drive">"Drive"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("drive", "Drive", "Drive", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:mdraid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.MDRaid">"MDRaid"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 2.0.0
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("mdraid", "MDRaid", "MDRaid", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:mdraid-member:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.MDRaidMember">"MDRaidMember"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 2.0.0
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("mdraid-member", "MDRaidMember", "MDRaidMember", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:id-usage:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdUsage">"IdUsage"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("id-usage", "IdUsage", "IdUsage", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:id-type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdType">"IdType"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("id-type", "IdType", "IdType", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:id-version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdVersion">"IdVersion"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("id-version", "IdVersion", "IdVersion", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:id-label:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdLabel">"IdLabel"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("id-label", "IdLabel", "IdLabel", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:id-uuid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdUUID">"IdUUID"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("id-uuid", "IdUUID", "IdUUID", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:configuration:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Configuration">"Configuration"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("configuration", "Configuration", "Configuration", G_VARIANT_TYPE ("a(sa{sv})"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:crypto-backing-device:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.CryptoBackingDevice">"CryptoBackingDevice"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("crypto-backing-device", "CryptoBackingDevice", "CryptoBackingDevice", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:hint-partitionable:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintPartitionable">"HintPartitionable"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("hint-partitionable", "HintPartitionable", "HintPartitionable", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:hint-system:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintSystem">"HintSystem"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("hint-system", "HintSystem", "HintSystem", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:hint-ignore:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintIgnore">"HintIgnore"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("hint-ignore", "HintIgnore", "HintIgnore", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:hint-auto:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintAuto">"HintAuto"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("hint-auto", "HintAuto", "HintAuto", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:hint-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintName">"HintName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("hint-name", "HintName", "HintName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:hint-icon-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintIconName">"HintIconName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("hint-icon-name", "HintIconName", "HintIconName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:hint-symbolic-icon-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintSymbolicIconName">"HintSymbolicIconName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 2.0.0
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("hint-symbolic-icon-name", "HintSymbolicIconName", "HintSymbolicIconName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksBlock:userspace-mount-options:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.UserspaceMountOptions">"UserspaceMountOptions"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("userspace-mount-options", "UserspaceMountOptions", "UserspaceMountOptions", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * udisks_block_get_device: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Device">"Device"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_device() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_block_get_device (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_device (object);
}

/**
 * udisks_block_dup_device: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Device">"Device"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_block_dup_device (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "device", &value, NULL);
  return value;
}

/**
 * udisks_block_set_device: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Device">"Device"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_device (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "device", value, NULL);
}

/**
 * udisks_block_get_preferred_device: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.PreferredDevice">"PreferredDevice"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_preferred_device() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_block_get_preferred_device (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_preferred_device (object);
}

/**
 * udisks_block_dup_preferred_device: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.PreferredDevice">"PreferredDevice"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_block_dup_preferred_device (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "preferred-device", &value, NULL);
  return value;
}

/**
 * udisks_block_set_preferred_device: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.PreferredDevice">"PreferredDevice"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_preferred_device (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "preferred-device", value, NULL);
}

/**
 * udisks_block_get_symlinks: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Symlinks">"Symlinks"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_symlinks() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
udisks_block_get_symlinks (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_symlinks (object);
}

/**
 * udisks_block_dup_symlinks: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Symlinks">"Symlinks"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
udisks_block_dup_symlinks (UDisksBlock *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "symlinks", &value, NULL);
  return value;
}

/**
 * udisks_block_set_symlinks: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Symlinks">"Symlinks"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_symlinks (UDisksBlock *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "symlinks", value, NULL);
}

/**
 * udisks_block_get_device_number: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.DeviceNumber">"DeviceNumber"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
udisks_block_get_device_number (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_device_number (object);
}

/**
 * udisks_block_set_device_number: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.DeviceNumber">"DeviceNumber"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_device_number (UDisksBlock *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "device-number", value, NULL);
}

/**
 * udisks_block_get_id: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 2.0.0
 */
const gchar *
udisks_block_get_id (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_id (object);
}

/**
 * udisks_block_dup_id: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 *
 * Since: 2.0.0
 */
gchar *
udisks_block_dup_id (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "id", &value, NULL);
  return value;
}

/**
 * udisks_block_set_id: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Id">"Id"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 2.0.0
 */
void
udisks_block_set_id (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "id", value, NULL);
}

/**
 * udisks_block_get_size: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Size">"Size"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
udisks_block_get_size (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_size (object);
}

/**
 * udisks_block_set_size: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Size">"Size"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_size (UDisksBlock *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "size", value, NULL);
}

/**
 * udisks_block_get_read_only: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.ReadOnly">"ReadOnly"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_block_get_read_only (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_read_only (object);
}

/**
 * udisks_block_set_read_only: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.ReadOnly">"ReadOnly"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_read_only (UDisksBlock *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "read-only", value, NULL);
}

/**
 * udisks_block_get_drive: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Drive">"Drive"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_drive() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_block_get_drive (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_drive (object);
}

/**
 * udisks_block_dup_drive: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Drive">"Drive"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_block_dup_drive (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "drive", &value, NULL);
  return value;
}

/**
 * udisks_block_set_drive: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Drive">"Drive"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_drive (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "drive", value, NULL);
}

/**
 * udisks_block_get_mdraid: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.MDRaid">"MDRaid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_mdraid() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 2.0.0
 */
const gchar *
udisks_block_get_mdraid (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_mdraid (object);
}

/**
 * udisks_block_dup_mdraid: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.MDRaid">"MDRaid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 *
 * Since: 2.0.0
 */
gchar *
udisks_block_dup_mdraid (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "mdraid", &value, NULL);
  return value;
}

/**
 * udisks_block_set_mdraid: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.MDRaid">"MDRaid"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 2.0.0
 */
void
udisks_block_set_mdraid (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "mdraid", value, NULL);
}

/**
 * udisks_block_get_mdraid_member: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.MDRaidMember">"MDRaidMember"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_mdraid_member() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 2.0.0
 */
const gchar *
udisks_block_get_mdraid_member (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_mdraid_member (object);
}

/**
 * udisks_block_dup_mdraid_member: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.MDRaidMember">"MDRaidMember"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 *
 * Since: 2.0.0
 */
gchar *
udisks_block_dup_mdraid_member (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "mdraid-member", &value, NULL);
  return value;
}

/**
 * udisks_block_set_mdraid_member: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.MDRaidMember">"MDRaidMember"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 2.0.0
 */
void
udisks_block_set_mdraid_member (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "mdraid-member", value, NULL);
}

/**
 * udisks_block_get_id_usage: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdUsage">"IdUsage"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_id_usage() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_block_get_id_usage (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_id_usage (object);
}

/**
 * udisks_block_dup_id_usage: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdUsage">"IdUsage"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_block_dup_id_usage (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "id-usage", &value, NULL);
  return value;
}

/**
 * udisks_block_set_id_usage: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdUsage">"IdUsage"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_id_usage (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "id-usage", value, NULL);
}

/**
 * udisks_block_get_id_type: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdType">"IdType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_id_type() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_block_get_id_type (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_id_type (object);
}

/**
 * udisks_block_dup_id_type: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdType">"IdType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_block_dup_id_type (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "id-type", &value, NULL);
  return value;
}

/**
 * udisks_block_set_id_type: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdType">"IdType"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_id_type (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "id-type", value, NULL);
}

/**
 * udisks_block_get_id_version: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdVersion">"IdVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_id_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_block_get_id_version (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_id_version (object);
}

/**
 * udisks_block_dup_id_version: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdVersion">"IdVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_block_dup_id_version (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "id-version", &value, NULL);
  return value;
}

/**
 * udisks_block_set_id_version: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdVersion">"IdVersion"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_id_version (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "id-version", value, NULL);
}

/**
 * udisks_block_get_id_label: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdLabel">"IdLabel"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_id_label() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_block_get_id_label (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_id_label (object);
}

/**
 * udisks_block_dup_id_label: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdLabel">"IdLabel"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_block_dup_id_label (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "id-label", &value, NULL);
  return value;
}

/**
 * udisks_block_set_id_label: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdLabel">"IdLabel"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_id_label (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "id-label", value, NULL);
}

/**
 * udisks_block_get_id_uuid: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdUUID">"IdUUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_id_uuid() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_block_get_id_uuid (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_id_uuid (object);
}

/**
 * udisks_block_dup_id_uuid: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdUUID">"IdUUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_block_dup_id_uuid (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "id-uuid", &value, NULL);
  return value;
}

/**
 * udisks_block_set_id_uuid: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.IdUUID">"IdUUID"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_id_uuid (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "id-uuid", value, NULL);
}

/**
 * udisks_block_get_configuration: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Configuration">"Configuration"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_configuration() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
udisks_block_get_configuration (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_configuration (object);
}

/**
 * udisks_block_dup_configuration: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Configuration">"Configuration"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
udisks_block_dup_configuration (UDisksBlock *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "configuration", &value, NULL);
  return value;
}

/**
 * udisks_block_set_configuration: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.Configuration">"Configuration"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_configuration (UDisksBlock *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "configuration", value, NULL);
}

/**
 * udisks_block_get_crypto_backing_device: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.CryptoBackingDevice">"CryptoBackingDevice"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_crypto_backing_device() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_block_get_crypto_backing_device (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_crypto_backing_device (object);
}

/**
 * udisks_block_dup_crypto_backing_device: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.CryptoBackingDevice">"CryptoBackingDevice"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_block_dup_crypto_backing_device (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "crypto-backing-device", &value, NULL);
  return value;
}

/**
 * udisks_block_set_crypto_backing_device: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.CryptoBackingDevice">"CryptoBackingDevice"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_crypto_backing_device (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "crypto-backing-device", value, NULL);
}

/**
 * udisks_block_get_hint_partitionable: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintPartitionable">"HintPartitionable"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_block_get_hint_partitionable (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_hint_partitionable (object);
}

/**
 * udisks_block_set_hint_partitionable: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintPartitionable">"HintPartitionable"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_hint_partitionable (UDisksBlock *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "hint-partitionable", value, NULL);
}

/**
 * udisks_block_get_hint_system: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintSystem">"HintSystem"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_block_get_hint_system (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_hint_system (object);
}

/**
 * udisks_block_set_hint_system: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintSystem">"HintSystem"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_hint_system (UDisksBlock *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "hint-system", value, NULL);
}

/**
 * udisks_block_get_hint_ignore: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintIgnore">"HintIgnore"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_block_get_hint_ignore (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_hint_ignore (object);
}

/**
 * udisks_block_set_hint_ignore: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintIgnore">"HintIgnore"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_hint_ignore (UDisksBlock *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "hint-ignore", value, NULL);
}

/**
 * udisks_block_get_hint_auto: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintAuto">"HintAuto"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_block_get_hint_auto (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_hint_auto (object);
}

/**
 * udisks_block_set_hint_auto: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintAuto">"HintAuto"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_hint_auto (UDisksBlock *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "hint-auto", value, NULL);
}

/**
 * udisks_block_get_hint_name: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintName">"HintName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_hint_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_block_get_hint_name (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_hint_name (object);
}

/**
 * udisks_block_dup_hint_name: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintName">"HintName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_block_dup_hint_name (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "hint-name", &value, NULL);
  return value;
}

/**
 * udisks_block_set_hint_name: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintName">"HintName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_hint_name (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "hint-name", value, NULL);
}

/**
 * udisks_block_get_hint_icon_name: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintIconName">"HintIconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_hint_icon_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_block_get_hint_icon_name (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_hint_icon_name (object);
}

/**
 * udisks_block_dup_hint_icon_name: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintIconName">"HintIconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_block_dup_hint_icon_name (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "hint-icon-name", &value, NULL);
  return value;
}

/**
 * udisks_block_set_hint_icon_name: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintIconName">"HintIconName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_hint_icon_name (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "hint-icon-name", value, NULL);
}

/**
 * udisks_block_get_hint_symbolic_icon_name: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintSymbolicIconName">"HintSymbolicIconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_hint_symbolic_icon_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 2.0.0
 */
const gchar *
udisks_block_get_hint_symbolic_icon_name (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_hint_symbolic_icon_name (object);
}

/**
 * udisks_block_dup_hint_symbolic_icon_name: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintSymbolicIconName">"HintSymbolicIconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 *
 * Since: 2.0.0
 */
gchar *
udisks_block_dup_hint_symbolic_icon_name (UDisksBlock *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "hint-symbolic-icon-name", &value, NULL);
  return value;
}

/**
 * udisks_block_set_hint_symbolic_icon_name: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.HintSymbolicIconName">"HintSymbolicIconName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 2.0.0
 */
void
udisks_block_set_hint_symbolic_icon_name (UDisksBlock *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "hint-symbolic-icon-name", value, NULL);
}

/**
 * udisks_block_get_userspace_mount_options: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.UserspaceMountOptions">"UserspaceMountOptions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_block_dup_userspace_mount_options() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
udisks_block_get_userspace_mount_options (UDisksBlock *object)
{
  return UDISKS_BLOCK_GET_IFACE (object)->get_userspace_mount_options (object);
}

/**
 * udisks_block_dup_userspace_mount_options: (skip)
 * @object: A #UDisksBlock.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.UserspaceMountOptions">"UserspaceMountOptions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
udisks_block_dup_userspace_mount_options (UDisksBlock *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "userspace-mount-options", &value, NULL);
  return value;
}

/**
 * udisks_block_set_userspace_mount_options: (skip)
 * @object: A #UDisksBlock.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Block.UserspaceMountOptions">"UserspaceMountOptions"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_block_set_userspace_mount_options (UDisksBlock *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "userspace-mount-options", value, NULL);
}

/**
 * udisks_block_call_add_configuration_item:
 * @proxy: A #UDisksBlockProxy.
 * @arg_item: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.AddConfigurationItem">AddConfigurationItem()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_block_call_add_configuration_item_finish() to get the result of the operation.
 *
 * See udisks_block_call_add_configuration_item_sync() for the synchronous, blocking version of this method.
 */
void
udisks_block_call_add_configuration_item (
    UDisksBlock *proxy,
    GVariant *arg_item,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddConfigurationItem",
    g_variant_new ("(@(sa{sv})@a{sv})",
                   arg_item,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_block_call_add_configuration_item_finish:
 * @proxy: A #UDisksBlockProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_block_call_add_configuration_item().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_block_call_add_configuration_item().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_add_configuration_item_finish (
    UDisksBlock *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_add_configuration_item_sync:
 * @proxy: A #UDisksBlockProxy.
 * @arg_item: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.AddConfigurationItem">AddConfigurationItem()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_block_call_add_configuration_item() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_add_configuration_item_sync (
    UDisksBlock *proxy,
    GVariant *arg_item,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddConfigurationItem",
    g_variant_new ("(@(sa{sv})@a{sv})",
                   arg_item,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_remove_configuration_item:
 * @proxy: A #UDisksBlockProxy.
 * @arg_item: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.RemoveConfigurationItem">RemoveConfigurationItem()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_block_call_remove_configuration_item_finish() to get the result of the operation.
 *
 * See udisks_block_call_remove_configuration_item_sync() for the synchronous, blocking version of this method.
 */
void
udisks_block_call_remove_configuration_item (
    UDisksBlock *proxy,
    GVariant *arg_item,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RemoveConfigurationItem",
    g_variant_new ("(@(sa{sv})@a{sv})",
                   arg_item,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_block_call_remove_configuration_item_finish:
 * @proxy: A #UDisksBlockProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_block_call_remove_configuration_item().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_block_call_remove_configuration_item().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_remove_configuration_item_finish (
    UDisksBlock *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_remove_configuration_item_sync:
 * @proxy: A #UDisksBlockProxy.
 * @arg_item: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.RemoveConfigurationItem">RemoveConfigurationItem()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_block_call_remove_configuration_item() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_remove_configuration_item_sync (
    UDisksBlock *proxy,
    GVariant *arg_item,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RemoveConfigurationItem",
    g_variant_new ("(@(sa{sv})@a{sv})",
                   arg_item,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_update_configuration_item:
 * @proxy: A #UDisksBlockProxy.
 * @arg_old_item: Argument to pass with the method invocation.
 * @arg_new_item: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.UpdateConfigurationItem">UpdateConfigurationItem()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_block_call_update_configuration_item_finish() to get the result of the operation.
 *
 * See udisks_block_call_update_configuration_item_sync() for the synchronous, blocking version of this method.
 */
void
udisks_block_call_update_configuration_item (
    UDisksBlock *proxy,
    GVariant *arg_old_item,
    GVariant *arg_new_item,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UpdateConfigurationItem",
    g_variant_new ("(@(sa{sv})@(sa{sv})@a{sv})",
                   arg_old_item,
                   arg_new_item,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_block_call_update_configuration_item_finish:
 * @proxy: A #UDisksBlockProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_block_call_update_configuration_item().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_block_call_update_configuration_item().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_update_configuration_item_finish (
    UDisksBlock *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_update_configuration_item_sync:
 * @proxy: A #UDisksBlockProxy.
 * @arg_old_item: Argument to pass with the method invocation.
 * @arg_new_item: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.UpdateConfigurationItem">UpdateConfigurationItem()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_block_call_update_configuration_item() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_update_configuration_item_sync (
    UDisksBlock *proxy,
    GVariant *arg_old_item,
    GVariant *arg_new_item,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UpdateConfigurationItem",
    g_variant_new ("(@(sa{sv})@(sa{sv})@a{sv})",
                   arg_old_item,
                   arg_new_item,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_get_secret_configuration:
 * @proxy: A #UDisksBlockProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.GetSecretConfiguration">GetSecretConfiguration()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_block_call_get_secret_configuration_finish() to get the result of the operation.
 *
 * See udisks_block_call_get_secret_configuration_sync() for the synchronous, blocking version of this method.
 */
void
udisks_block_call_get_secret_configuration (
    UDisksBlock *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSecretConfiguration",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_block_call_get_secret_configuration_finish:
 * @proxy: A #UDisksBlockProxy.
 * @out_configuration: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_block_call_get_secret_configuration().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_block_call_get_secret_configuration().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_get_secret_configuration_finish (
    UDisksBlock *proxy,
    GVariant **out_configuration,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sa{sv}))",
                 out_configuration);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_get_secret_configuration_sync:
 * @proxy: A #UDisksBlockProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_configuration: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.GetSecretConfiguration">GetSecretConfiguration()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_block_call_get_secret_configuration() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_get_secret_configuration_sync (
    UDisksBlock *proxy,
    GVariant *arg_options,
    GVariant **out_configuration,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSecretConfiguration",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sa{sv}))",
                 out_configuration);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_format:
 * @proxy: A #UDisksBlockProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.Format">Format()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_block_call_format_finish() to get the result of the operation.
 *
 * See udisks_block_call_format_sync() for the synchronous, blocking version of this method.
 */
void
udisks_block_call_format (
    UDisksBlock *proxy,
    const gchar *arg_type,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Format",
    g_variant_new ("(s@a{sv})",
                   arg_type,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_block_call_format_finish:
 * @proxy: A #UDisksBlockProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_block_call_format().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_block_call_format().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_format_finish (
    UDisksBlock *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_format_sync:
 * @proxy: A #UDisksBlockProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.Format">Format()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_block_call_format() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_format_sync (
    UDisksBlock *proxy,
    const gchar *arg_type,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Format",
    g_variant_new ("(s@a{sv})",
                   arg_type,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_open_for_backup:
 * @proxy: A #UDisksBlockProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenForBackup">OpenForBackup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_block_call_open_for_backup_finish() to get the result of the operation.
 *
 * See udisks_block_call_open_for_backup_sync() for the synchronous, blocking version of this method.
 */
void
udisks_block_call_open_for_backup (
    UDisksBlock *proxy,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "OpenForBackup",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_block_call_open_for_backup_finish:
 * @proxy: A #UDisksBlockProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_block_call_open_for_backup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_block_call_open_for_backup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_open_for_backup_finish (
    UDisksBlock *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_open_for_backup_sync:
 * @proxy: A #UDisksBlockProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenForBackup">OpenForBackup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_block_call_open_for_backup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_open_for_backup_sync (
    UDisksBlock *proxy,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "OpenForBackup",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_open_for_restore:
 * @proxy: A #UDisksBlockProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenForRestore">OpenForRestore()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_block_call_open_for_restore_finish() to get the result of the operation.
 *
 * See udisks_block_call_open_for_restore_sync() for the synchronous, blocking version of this method.
 */
void
udisks_block_call_open_for_restore (
    UDisksBlock *proxy,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "OpenForRestore",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_block_call_open_for_restore_finish:
 * @proxy: A #UDisksBlockProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_block_call_open_for_restore().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_block_call_open_for_restore().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_open_for_restore_finish (
    UDisksBlock *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_open_for_restore_sync:
 * @proxy: A #UDisksBlockProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenForRestore">OpenForRestore()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_block_call_open_for_restore() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_open_for_restore_sync (
    UDisksBlock *proxy,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "OpenForRestore",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_open_for_benchmark:
 * @proxy: A #UDisksBlockProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenForBenchmark">OpenForBenchmark()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_block_call_open_for_benchmark_finish() to get the result of the operation.
 *
 * See udisks_block_call_open_for_benchmark_sync() for the synchronous, blocking version of this method.
 */
void
udisks_block_call_open_for_benchmark (
    UDisksBlock *proxy,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "OpenForBenchmark",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_block_call_open_for_benchmark_finish:
 * @proxy: A #UDisksBlockProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_block_call_open_for_benchmark().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_block_call_open_for_benchmark().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_open_for_benchmark_finish (
    UDisksBlock *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_open_for_benchmark_sync:
 * @proxy: A #UDisksBlockProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenForBenchmark">OpenForBenchmark()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_block_call_open_for_benchmark() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_open_for_benchmark_sync (
    UDisksBlock *proxy,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "OpenForBenchmark",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_open_device:
 * @proxy: A #UDisksBlockProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenDevice">OpenDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_block_call_open_device_finish() to get the result of the operation.
 *
 * See udisks_block_call_open_device_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.7.3
 */
void
udisks_block_call_open_device (
    UDisksBlock *proxy,
    const gchar *arg_mode,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "OpenDevice",
    g_variant_new ("(s@a{sv})",
                   arg_mode,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_block_call_open_device_finish:
 * @proxy: A #UDisksBlockProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_block_call_open_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_block_call_open_device().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.3
 */
gboolean
udisks_block_call_open_device_finish (
    UDisksBlock *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_open_device_sync:
 * @proxy: A #UDisksBlockProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenDevice">OpenDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_block_call_open_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.3
 */
gboolean
udisks_block_call_open_device_sync (
    UDisksBlock *proxy,
    const gchar *arg_mode,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "OpenDevice",
    g_variant_new ("(s@a{sv})",
                   arg_mode,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_rescan:
 * @proxy: A #UDisksBlockProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.Rescan">Rescan()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_block_call_rescan_finish() to get the result of the operation.
 *
 * See udisks_block_call_rescan_sync() for the synchronous, blocking version of this method.
 */
void
udisks_block_call_rescan (
    UDisksBlock *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Rescan",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_block_call_rescan_finish:
 * @proxy: A #UDisksBlockProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_block_call_rescan().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_block_call_rescan().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_rescan_finish (
    UDisksBlock *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_call_rescan_sync:
 * @proxy: A #UDisksBlockProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.Rescan">Rescan()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_block_call_rescan() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_block_call_rescan_sync (
    UDisksBlock *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Rescan",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_block_complete_add_configuration_item:
 * @object: A #UDisksBlock.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.AddConfigurationItem">AddConfigurationItem()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_block_complete_add_configuration_item (
    UDisksBlock *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_block_complete_remove_configuration_item:
 * @object: A #UDisksBlock.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.RemoveConfigurationItem">RemoveConfigurationItem()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_block_complete_remove_configuration_item (
    UDisksBlock *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_block_complete_update_configuration_item:
 * @object: A #UDisksBlock.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.UpdateConfigurationItem">UpdateConfigurationItem()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_block_complete_update_configuration_item (
    UDisksBlock *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_block_complete_get_secret_configuration:
 * @object: A #UDisksBlock.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @configuration: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.GetSecretConfiguration">GetSecretConfiguration()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_block_complete_get_secret_configuration (
    UDisksBlock *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *configuration)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sa{sv}))",
                   configuration));
}

/**
 * udisks_block_complete_format:
 * @object: A #UDisksBlock.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.Format">Format()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_block_complete_format (
    UDisksBlock *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_block_complete_open_for_backup:
 * @object: A #UDisksBlock.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenForBackup">OpenForBackup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_block_complete_open_for_backup (
    UDisksBlock *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/**
 * udisks_block_complete_open_for_restore:
 * @object: A #UDisksBlock.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenForRestore">OpenForRestore()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_block_complete_open_for_restore (
    UDisksBlock *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/**
 * udisks_block_complete_open_for_benchmark:
 * @object: A #UDisksBlock.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenForBenchmark">OpenForBenchmark()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_block_complete_open_for_benchmark (
    UDisksBlock *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/**
 * udisks_block_complete_open_device:
 * @object: A #UDisksBlock.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.OpenDevice">OpenDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.7.3
 */
void
udisks_block_complete_open_device (
    UDisksBlock *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/**
 * udisks_block_complete_rescan:
 * @object: A #UDisksBlock.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Block.Rescan">Rescan()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_block_complete_rescan (
    UDisksBlock *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * UDisksBlockProxy:
 *
 * The #UDisksBlockProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksBlockProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksBlockProxy.
 */

struct _UDisksBlockProxyPrivate
{
  GData *qdata;
};

static void udisks_block_proxy_iface_init (UDisksBlockIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksBlockProxy, udisks_block_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (UDisksBlockProxy)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_BLOCK, udisks_block_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksBlockProxy, udisks_block_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_BLOCK, udisks_block_proxy_iface_init))

#endif
static void
udisks_block_proxy_finalize (GObject *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (udisks_block_proxy_parent_class)->finalize (object);
}

static void
udisks_block_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 25);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_block_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
udisks_block_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.UDisks2.Block: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
udisks_block_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 25);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_block_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.UDisks2.Block", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) udisks_block_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
udisks_block_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_udisks_block_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], UDISKS_TYPE_BLOCK);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_BLOCK);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
udisks_block_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_block_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_block_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
udisks_block_proxy_get_device (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Device");
  if (variant != NULL)
    {
      value = g_variant_get_bytestring (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_block_proxy_get_preferred_device (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PreferredDevice");
  if (variant != NULL)
    {
      value = g_variant_get_bytestring (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
udisks_block_proxy_get_symlinks (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Symlinks");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Symlinks");
  if (variant != NULL)
    {
      value = g_variant_get_bytestring_array (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Symlinks", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
udisks_block_proxy_get_device_number (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DeviceNumber");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_block_proxy_get_id (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Id");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
udisks_block_proxy_get_size (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Size");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_block_proxy_get_read_only (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ReadOnly");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_block_proxy_get_drive (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Drive");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_block_proxy_get_mdraid (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MDRaid");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_block_proxy_get_mdraid_member (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MDRaidMember");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_block_proxy_get_id_usage (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IdUsage");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_block_proxy_get_id_type (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IdType");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_block_proxy_get_id_version (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IdVersion");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_block_proxy_get_id_label (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IdLabel");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_block_proxy_get_id_uuid (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IdUUID");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
udisks_block_proxy_get_configuration (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Configuration");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
udisks_block_proxy_get_crypto_backing_device (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CryptoBackingDevice");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_block_proxy_get_hint_partitionable (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HintPartitionable");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_block_proxy_get_hint_system (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HintSystem");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_block_proxy_get_hint_ignore (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HintIgnore");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_block_proxy_get_hint_auto (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HintAuto");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_block_proxy_get_hint_name (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HintName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_block_proxy_get_hint_icon_name (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HintIconName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_block_proxy_get_hint_symbolic_icon_name (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HintSymbolicIconName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
udisks_block_proxy_get_userspace_mount_options (UDisksBlock *object)
{
  UDisksBlockProxy *proxy = UDISKS_BLOCK_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "UserspaceMountOptions");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UserspaceMountOptions");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "UserspaceMountOptions", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
udisks_block_proxy_init (UDisksBlockProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = udisks_block_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, UDISKS_TYPE_BLOCK_PROXY, UDisksBlockProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), udisks_block_interface_info ());
}

static void
udisks_block_proxy_class_init (UDisksBlockProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = udisks_block_proxy_finalize;
  gobject_class->get_property = udisks_block_proxy_get_property;
  gobject_class->set_property = udisks_block_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = udisks_block_proxy_g_signal;
  proxy_class->g_properties_changed = udisks_block_proxy_g_properties_changed;

  udisks_block_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksBlockProxyPrivate));
#endif
}

static void
udisks_block_proxy_iface_init (UDisksBlockIface *iface)
{
  iface->get_device = udisks_block_proxy_get_device;
  iface->get_preferred_device = udisks_block_proxy_get_preferred_device;
  iface->get_symlinks = udisks_block_proxy_get_symlinks;
  iface->get_device_number = udisks_block_proxy_get_device_number;
  iface->get_id = udisks_block_proxy_get_id;
  iface->get_size = udisks_block_proxy_get_size;
  iface->get_read_only = udisks_block_proxy_get_read_only;
  iface->get_drive = udisks_block_proxy_get_drive;
  iface->get_mdraid = udisks_block_proxy_get_mdraid;
  iface->get_mdraid_member = udisks_block_proxy_get_mdraid_member;
  iface->get_id_usage = udisks_block_proxy_get_id_usage;
  iface->get_id_type = udisks_block_proxy_get_id_type;
  iface->get_id_version = udisks_block_proxy_get_id_version;
  iface->get_id_label = udisks_block_proxy_get_id_label;
  iface->get_id_uuid = udisks_block_proxy_get_id_uuid;
  iface->get_configuration = udisks_block_proxy_get_configuration;
  iface->get_crypto_backing_device = udisks_block_proxy_get_crypto_backing_device;
  iface->get_hint_partitionable = udisks_block_proxy_get_hint_partitionable;
  iface->get_hint_system = udisks_block_proxy_get_hint_system;
  iface->get_hint_ignore = udisks_block_proxy_get_hint_ignore;
  iface->get_hint_auto = udisks_block_proxy_get_hint_auto;
  iface->get_hint_name = udisks_block_proxy_get_hint_name;
  iface->get_hint_icon_name = udisks_block_proxy_get_hint_icon_name;
  iface->get_hint_symbolic_icon_name = udisks_block_proxy_get_hint_symbolic_icon_name;
  iface->get_userspace_mount_options = udisks_block_proxy_get_userspace_mount_options;
}

/**
 * udisks_block_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Block.top_of_page">org.freedesktop.UDisks2.Block</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_block_proxy_new_finish() to get the result of the operation.
 *
 * See udisks_block_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_block_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_BLOCK_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Block", NULL);
}

/**
 * udisks_block_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_block_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_block_proxy_new().
 *
 * Returns: (transfer full) (type UDisksBlockProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksBlock *
udisks_block_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_BLOCK (ret);
  else
    return NULL;
}

/**
 * udisks_block_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Block.top_of_page">org.freedesktop.UDisks2.Block</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_block_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksBlockProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksBlock *
udisks_block_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_BLOCK_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Block", NULL);
  if (ret != NULL)
    return UDISKS_BLOCK (ret);
  else
    return NULL;
}


/**
 * udisks_block_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like udisks_block_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_block_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See udisks_block_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_block_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_BLOCK_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Block", NULL);
}

/**
 * udisks_block_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_block_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_block_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type UDisksBlockProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksBlock *
udisks_block_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_BLOCK (ret);
  else
    return NULL;
}

/**
 * udisks_block_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like udisks_block_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_block_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksBlockProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksBlock *
udisks_block_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_BLOCK_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Block", NULL);
  if (ret != NULL)
    return UDISKS_BLOCK (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * UDisksBlockSkeleton:
 *
 * The #UDisksBlockSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksBlockSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksBlockSkeleton.
 */

struct _UDisksBlockSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_udisks_block_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], UDISKS_TYPE_BLOCK);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_BLOCK);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_udisks_block_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_block_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_udisks_block_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_block_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _udisks_block_skeleton_vtable =
{
  _udisks_block_skeleton_handle_method_call,
  _udisks_block_skeleton_handle_get_property,
  _udisks_block_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
udisks_block_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return udisks_block_interface_info ();
}

static GDBusInterfaceVTable *
udisks_block_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_udisks_block_skeleton_vtable;
}

static GVariant *
udisks_block_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_udisks_block_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _udisks_block_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _udisks_block_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _udisks_block_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.UDisks2.Block", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _udisks_block_emit_changed (gpointer user_data);

static void
udisks_block_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _udisks_block_emit_changed (skeleton);
}

static void udisks_block_skeleton_iface_init (UDisksBlockIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksBlockSkeleton, udisks_block_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (UDisksBlockSkeleton)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_BLOCK, udisks_block_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksBlockSkeleton, udisks_block_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_BLOCK, udisks_block_skeleton_iface_init))

#endif
static void
udisks_block_skeleton_finalize (GObject *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  guint n;
  for (n = 0; n < 25; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (udisks_block_skeleton_parent_class)->finalize (object);
}

static void
udisks_block_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 25);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_udisks_block_emit_changed (gpointer user_data)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.UDisks2.Block",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_udisks_block_schedule_emit_changed (UDisksBlockSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
udisks_block_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _udisks_block_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _udisks_block_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
udisks_block_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 25);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_block_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _udisks_block_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
udisks_block_skeleton_init (UDisksBlockSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = udisks_block_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, UDISKS_TYPE_BLOCK_SKELETON, UDisksBlockSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 25);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[15], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[16], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[17], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[18], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[19], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[20], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[21], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[22], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[23], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[24], G_TYPE_STRV);
}

static const gchar *
udisks_block_skeleton_get_device (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_preferred_device (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
udisks_block_skeleton_get_symlinks (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
udisks_block_skeleton_get_device_number (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_id (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
udisks_block_skeleton_get_size (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_block_skeleton_get_read_only (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_drive (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_mdraid (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_mdraid_member (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_id_usage (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_id_type (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_id_version (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_id_label (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_id_uuid (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
udisks_block_skeleton_get_configuration (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[15]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_crypto_backing_device (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[16]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_block_skeleton_get_hint_partitionable (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[17]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_block_skeleton_get_hint_system (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[18]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_block_skeleton_get_hint_ignore (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[19]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_block_skeleton_get_hint_auto (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[20]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_hint_name (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[21]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_hint_icon_name (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[22]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_block_skeleton_get_hint_symbolic_icon_name (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[23]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
udisks_block_skeleton_get_userspace_mount_options (UDisksBlock *object)
{
  UDisksBlockSkeleton *skeleton = UDISKS_BLOCK_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[24]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
udisks_block_skeleton_class_init (UDisksBlockSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = udisks_block_skeleton_finalize;
  gobject_class->get_property = udisks_block_skeleton_get_property;
  gobject_class->set_property = udisks_block_skeleton_set_property;
  gobject_class->notify       = udisks_block_skeleton_notify;


  udisks_block_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = udisks_block_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = udisks_block_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = udisks_block_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = udisks_block_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksBlockSkeletonPrivate));
#endif
}

static void
udisks_block_skeleton_iface_init (UDisksBlockIface *iface)
{
  iface->get_device = udisks_block_skeleton_get_device;
  iface->get_preferred_device = udisks_block_skeleton_get_preferred_device;
  iface->get_symlinks = udisks_block_skeleton_get_symlinks;
  iface->get_device_number = udisks_block_skeleton_get_device_number;
  iface->get_id = udisks_block_skeleton_get_id;
  iface->get_size = udisks_block_skeleton_get_size;
  iface->get_read_only = udisks_block_skeleton_get_read_only;
  iface->get_drive = udisks_block_skeleton_get_drive;
  iface->get_mdraid = udisks_block_skeleton_get_mdraid;
  iface->get_mdraid_member = udisks_block_skeleton_get_mdraid_member;
  iface->get_id_usage = udisks_block_skeleton_get_id_usage;
  iface->get_id_type = udisks_block_skeleton_get_id_type;
  iface->get_id_version = udisks_block_skeleton_get_id_version;
  iface->get_id_label = udisks_block_skeleton_get_id_label;
  iface->get_id_uuid = udisks_block_skeleton_get_id_uuid;
  iface->get_configuration = udisks_block_skeleton_get_configuration;
  iface->get_crypto_backing_device = udisks_block_skeleton_get_crypto_backing_device;
  iface->get_hint_partitionable = udisks_block_skeleton_get_hint_partitionable;
  iface->get_hint_system = udisks_block_skeleton_get_hint_system;
  iface->get_hint_ignore = udisks_block_skeleton_get_hint_ignore;
  iface->get_hint_auto = udisks_block_skeleton_get_hint_auto;
  iface->get_hint_name = udisks_block_skeleton_get_hint_name;
  iface->get_hint_icon_name = udisks_block_skeleton_get_hint_icon_name;
  iface->get_hint_symbolic_icon_name = udisks_block_skeleton_get_hint_symbolic_icon_name;
  iface->get_userspace_mount_options = udisks_block_skeleton_get_userspace_mount_options;
}

/**
 * udisks_block_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Block.top_of_page">org.freedesktop.UDisks2.Block</link>.
 *
 * Returns: (transfer full) (type UDisksBlockSkeleton): The skeleton object.
 */
UDisksBlock *
udisks_block_skeleton_new (void)
{
  return UDISKS_BLOCK (g_object_new (UDISKS_TYPE_BLOCK_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.UDisks2.PartitionTable
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:UDisksPartitionTable
 * @title: UDisksPartitionTable
 * @short_description: Generated C code for the org.freedesktop.UDisks2.PartitionTable D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-UDisks2-PartitionTable.top_of_page">org.freedesktop.UDisks2.PartitionTable</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.UDisks2.PartitionTable ---- */

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_IN_ARG_offset =
{
  {
    -1,
    (gchar *) "offset",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_IN_ARG_size =
{
  {
    -1,
    (gchar *) "size",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_partition_table_method_info_create_partition_IN_ARG_pointers[] =
{
  &_udisks_partition_table_method_info_create_partition_IN_ARG_offset.parent_struct,
  &_udisks_partition_table_method_info_create_partition_IN_ARG_size.parent_struct,
  &_udisks_partition_table_method_info_create_partition_IN_ARG_type.parent_struct,
  &_udisks_partition_table_method_info_create_partition_IN_ARG_name.parent_struct,
  &_udisks_partition_table_method_info_create_partition_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_OUT_ARG_created_partition =
{
  {
    -1,
    (gchar *) "created_partition",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_partition_table_method_info_create_partition_OUT_ARG_pointers[] =
{
  &_udisks_partition_table_method_info_create_partition_OUT_ARG_created_partition.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_partition_table_method_info_create_partition =
{
  {
    -1,
    (gchar *) "CreatePartition",
    (GDBusArgInfo **) &_udisks_partition_table_method_info_create_partition_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_partition_table_method_info_create_partition_OUT_ARG_pointers,
    NULL
  },
  "handle-create-partition",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_and_format_IN_ARG_offset =
{
  {
    -1,
    (gchar *) "offset",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_and_format_IN_ARG_size =
{
  {
    -1,
    (gchar *) "size",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_and_format_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_and_format_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_and_format_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_and_format_IN_ARG_format_type =
{
  {
    -1,
    (gchar *) "format_type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_and_format_IN_ARG_format_options =
{
  {
    -1,
    (gchar *) "format_options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_partition_table_method_info_create_partition_and_format_IN_ARG_pointers[] =
{
  &_udisks_partition_table_method_info_create_partition_and_format_IN_ARG_offset.parent_struct,
  &_udisks_partition_table_method_info_create_partition_and_format_IN_ARG_size.parent_struct,
  &_udisks_partition_table_method_info_create_partition_and_format_IN_ARG_type.parent_struct,
  &_udisks_partition_table_method_info_create_partition_and_format_IN_ARG_name.parent_struct,
  &_udisks_partition_table_method_info_create_partition_and_format_IN_ARG_options.parent_struct,
  &_udisks_partition_table_method_info_create_partition_and_format_IN_ARG_format_type.parent_struct,
  &_udisks_partition_table_method_info_create_partition_and_format_IN_ARG_format_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_partition_table_method_info_create_partition_and_format_OUT_ARG_created_partition =
{
  {
    -1,
    (gchar *) "created_partition",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_partition_table_method_info_create_partition_and_format_OUT_ARG_pointers[] =
{
  &_udisks_partition_table_method_info_create_partition_and_format_OUT_ARG_created_partition.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_partition_table_method_info_create_partition_and_format =
{
  {
    -1,
    (gchar *) "CreatePartitionAndFormat",
    (GDBusArgInfo **) &_udisks_partition_table_method_info_create_partition_and_format_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_partition_table_method_info_create_partition_and_format_OUT_ARG_pointers,
    NULL
  },
  "handle-create-partition-and-format",
  FALSE
};

static const GDBusMethodInfo * const _udisks_partition_table_method_info_pointers[] =
{
  &_udisks_partition_table_method_info_create_partition.parent_struct,
  &_udisks_partition_table_method_info_create_partition_and_format.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _udisks_partition_table_property_info_partitions =
{
  {
    -1,
    (gchar *) "Partitions",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "partitions",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_partition_table_property_info_type_ =
{
  {
    -1,
    (gchar *) "Type",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "type",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _udisks_partition_table_property_info_pointers[] =
{
  &_udisks_partition_table_property_info_partitions.parent_struct,
  &_udisks_partition_table_property_info_type_.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _udisks_partition_table_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.UDisks2.PartitionTable",
    (GDBusMethodInfo **) &_udisks_partition_table_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_udisks_partition_table_property_info_pointers,
    NULL
  },
  "partition-table",
};


/**
 * udisks_partition_table_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-UDisks2-PartitionTable.top_of_page">org.freedesktop.UDisks2.PartitionTable</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
udisks_partition_table_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_udisks_partition_table_interface_info.parent_struct;
}

/**
 * udisks_partition_table_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #UDisksPartitionTable interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
udisks_partition_table_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "partitions");
  g_object_class_override_property (klass, property_id_begin++, "type");
  return property_id_begin - 1;
}



/**
 * UDisksPartitionTable:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-PartitionTable.top_of_page">org.freedesktop.UDisks2.PartitionTable</link>.
 */

/**
 * UDisksPartitionTableIface:
 * @parent_iface: The parent interface.
 * @handle_create_partition: Handler for the #UDisksPartitionTable::handle-create-partition signal.
 * @handle_create_partition_and_format: Handler for the #UDisksPartitionTable::handle-create-partition-and-format signal.
 * @get_partitions: Getter for the #UDisksPartitionTable:partitions property.
 * @get_type_: Getter for the #UDisksPartitionTable:type property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-PartitionTable.top_of_page">org.freedesktop.UDisks2.PartitionTable</link>.
 */

typedef UDisksPartitionTableIface UDisksPartitionTableInterface;
G_DEFINE_INTERFACE (UDisksPartitionTable, udisks_partition_table, G_TYPE_OBJECT)

static void
udisks_partition_table_default_init (UDisksPartitionTableIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * UDisksPartitionTable::handle-create-partition:
   * @object: A #UDisksPartitionTable.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_offset: Argument passed by remote caller.
   * @arg_size: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-PartitionTable.CreatePartition">CreatePartition()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_partition_table_complete_create_partition() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-partition",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksPartitionTableIface, handle_create_partition),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_UINT64, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * UDisksPartitionTable::handle-create-partition-and-format:
   * @object: A #UDisksPartitionTable.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_offset: Argument passed by remote caller.
   * @arg_size: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_format_type: Argument passed by remote caller.
   * @arg_format_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-PartitionTable.CreatePartitionAndFormat">CreatePartitionAndFormat()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_partition_table_complete_create_partition_and_format() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-partition-and-format",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksPartitionTableIface, handle_create_partition_and_format),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    8,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_UINT64, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * UDisksPartitionTable:partitions:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-PartitionTable.Partitions">"Partitions"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("partitions", "Partitions", "Partitions", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksPartitionTable:type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-PartitionTable.Type">"Type"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("type", "Type", "Type", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * udisks_partition_table_get_partitions: (skip)
 * @object: A #UDisksPartitionTable.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-PartitionTable.Partitions">"Partitions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_partition_table_dup_partitions() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
udisks_partition_table_get_partitions (UDisksPartitionTable *object)
{
  return UDISKS_PARTITION_TABLE_GET_IFACE (object)->get_partitions (object);
}

/**
 * udisks_partition_table_dup_partitions: (skip)
 * @object: A #UDisksPartitionTable.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-PartitionTable.Partitions">"Partitions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
udisks_partition_table_dup_partitions (UDisksPartitionTable *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "partitions", &value, NULL);
  return value;
}

/**
 * udisks_partition_table_set_partitions: (skip)
 * @object: A #UDisksPartitionTable.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-PartitionTable.Partitions">"Partitions"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_partition_table_set_partitions (UDisksPartitionTable *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "partitions", value, NULL);
}

/**
 * udisks_partition_table_get_type_: (skip)
 * @object: A #UDisksPartitionTable.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-PartitionTable.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_partition_table_dup_type_() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_partition_table_get_type_ (UDisksPartitionTable *object)
{
  return UDISKS_PARTITION_TABLE_GET_IFACE (object)->get_type_ (object);
}

/**
 * udisks_partition_table_dup_type_: (skip)
 * @object: A #UDisksPartitionTable.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-PartitionTable.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_partition_table_dup_type_ (UDisksPartitionTable *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "type", &value, NULL);
  return value;
}

/**
 * udisks_partition_table_set_type_: (skip)
 * @object: A #UDisksPartitionTable.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-PartitionTable.Type">"Type"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_partition_table_set_type_ (UDisksPartitionTable *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "type", value, NULL);
}

/**
 * udisks_partition_table_call_create_partition:
 * @proxy: A #UDisksPartitionTableProxy.
 * @arg_offset: Argument to pass with the method invocation.
 * @arg_size: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-PartitionTable.CreatePartition">CreatePartition()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_partition_table_call_create_partition_finish() to get the result of the operation.
 *
 * See udisks_partition_table_call_create_partition_sync() for the synchronous, blocking version of this method.
 */
void
udisks_partition_table_call_create_partition (
    UDisksPartitionTable *proxy,
    guint64 arg_offset,
    guint64 arg_size,
    const gchar *arg_type,
    const gchar *arg_name,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreatePartition",
    g_variant_new ("(ttss@a{sv})",
                   arg_offset,
                   arg_size,
                   arg_type,
                   arg_name,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_partition_table_call_create_partition_finish:
 * @proxy: A #UDisksPartitionTableProxy.
 * @out_created_partition: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_partition_table_call_create_partition().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_partition_table_call_create_partition().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_table_call_create_partition_finish (
    UDisksPartitionTable *proxy,
    gchar **out_created_partition,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_created_partition);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_table_call_create_partition_sync:
 * @proxy: A #UDisksPartitionTableProxy.
 * @arg_offset: Argument to pass with the method invocation.
 * @arg_size: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_created_partition: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-PartitionTable.CreatePartition">CreatePartition()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_partition_table_call_create_partition() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_table_call_create_partition_sync (
    UDisksPartitionTable *proxy,
    guint64 arg_offset,
    guint64 arg_size,
    const gchar *arg_type,
    const gchar *arg_name,
    GVariant *arg_options,
    gchar **out_created_partition,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreatePartition",
    g_variant_new ("(ttss@a{sv})",
                   arg_offset,
                   arg_size,
                   arg_type,
                   arg_name,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_created_partition);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_table_call_create_partition_and_format:
 * @proxy: A #UDisksPartitionTableProxy.
 * @arg_offset: Argument to pass with the method invocation.
 * @arg_size: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_format_type: Argument to pass with the method invocation.
 * @arg_format_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-PartitionTable.CreatePartitionAndFormat">CreatePartitionAndFormat()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_partition_table_call_create_partition_and_format_finish() to get the result of the operation.
 *
 * See udisks_partition_table_call_create_partition_and_format_sync() for the synchronous, blocking version of this method.
 */
void
udisks_partition_table_call_create_partition_and_format (
    UDisksPartitionTable *proxy,
    guint64 arg_offset,
    guint64 arg_size,
    const gchar *arg_type,
    const gchar *arg_name,
    GVariant *arg_options,
    const gchar *arg_format_type,
    GVariant *arg_format_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreatePartitionAndFormat",
    g_variant_new ("(ttss@a{sv}s@a{sv})",
                   arg_offset,
                   arg_size,
                   arg_type,
                   arg_name,
                   arg_options,
                   arg_format_type,
                   arg_format_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_partition_table_call_create_partition_and_format_finish:
 * @proxy: A #UDisksPartitionTableProxy.
 * @out_created_partition: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_partition_table_call_create_partition_and_format().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_partition_table_call_create_partition_and_format().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_table_call_create_partition_and_format_finish (
    UDisksPartitionTable *proxy,
    gchar **out_created_partition,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_created_partition);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_table_call_create_partition_and_format_sync:
 * @proxy: A #UDisksPartitionTableProxy.
 * @arg_offset: Argument to pass with the method invocation.
 * @arg_size: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_format_type: Argument to pass with the method invocation.
 * @arg_format_options: Argument to pass with the method invocation.
 * @out_created_partition: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-PartitionTable.CreatePartitionAndFormat">CreatePartitionAndFormat()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_partition_table_call_create_partition_and_format() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_table_call_create_partition_and_format_sync (
    UDisksPartitionTable *proxy,
    guint64 arg_offset,
    guint64 arg_size,
    const gchar *arg_type,
    const gchar *arg_name,
    GVariant *arg_options,
    const gchar *arg_format_type,
    GVariant *arg_format_options,
    gchar **out_created_partition,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreatePartitionAndFormat",
    g_variant_new ("(ttss@a{sv}s@a{sv})",
                   arg_offset,
                   arg_size,
                   arg_type,
                   arg_name,
                   arg_options,
                   arg_format_type,
                   arg_format_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_created_partition);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_table_complete_create_partition:
 * @object: A #UDisksPartitionTable.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @created_partition: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-PartitionTable.CreatePartition">CreatePartition()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_partition_table_complete_create_partition (
    UDisksPartitionTable *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *created_partition)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   created_partition));
}

/**
 * udisks_partition_table_complete_create_partition_and_format:
 * @object: A #UDisksPartitionTable.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @created_partition: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-PartitionTable.CreatePartitionAndFormat">CreatePartitionAndFormat()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_partition_table_complete_create_partition_and_format (
    UDisksPartitionTable *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *created_partition)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   created_partition));
}

/* ------------------------------------------------------------------------ */

/**
 * UDisksPartitionTableProxy:
 *
 * The #UDisksPartitionTableProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksPartitionTableProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksPartitionTableProxy.
 */

struct _UDisksPartitionTableProxyPrivate
{
  GData *qdata;
};

static void udisks_partition_table_proxy_iface_init (UDisksPartitionTableIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksPartitionTableProxy, udisks_partition_table_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (UDisksPartitionTableProxy)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_PARTITION_TABLE, udisks_partition_table_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksPartitionTableProxy, udisks_partition_table_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_PARTITION_TABLE, udisks_partition_table_proxy_iface_init))

#endif
static void
udisks_partition_table_proxy_finalize (GObject *object)
{
  UDisksPartitionTableProxy *proxy = UDISKS_PARTITION_TABLE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (udisks_partition_table_proxy_parent_class)->finalize (object);
}

static void
udisks_partition_table_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_partition_table_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
udisks_partition_table_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.UDisks2.PartitionTable: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
udisks_partition_table_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_partition_table_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.UDisks2.PartitionTable", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) udisks_partition_table_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
udisks_partition_table_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_udisks_partition_table_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], UDISKS_TYPE_PARTITION_TABLE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_PARTITION_TABLE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
udisks_partition_table_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  UDisksPartitionTableProxy *proxy = UDISKS_PARTITION_TABLE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_partition_table_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_partition_table_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *const *
udisks_partition_table_proxy_get_partitions (UDisksPartitionTable *object)
{
  UDisksPartitionTableProxy *proxy = UDISKS_PARTITION_TABLE_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Partitions");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Partitions");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Partitions", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_partition_table_proxy_get_type_ (UDisksPartitionTable *object)
{
  UDisksPartitionTableProxy *proxy = UDISKS_PARTITION_TABLE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Type");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
udisks_partition_table_proxy_init (UDisksPartitionTableProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = udisks_partition_table_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, UDISKS_TYPE_PARTITION_TABLE_PROXY, UDisksPartitionTableProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), udisks_partition_table_interface_info ());
}

static void
udisks_partition_table_proxy_class_init (UDisksPartitionTableProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = udisks_partition_table_proxy_finalize;
  gobject_class->get_property = udisks_partition_table_proxy_get_property;
  gobject_class->set_property = udisks_partition_table_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = udisks_partition_table_proxy_g_signal;
  proxy_class->g_properties_changed = udisks_partition_table_proxy_g_properties_changed;

  udisks_partition_table_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksPartitionTableProxyPrivate));
#endif
}

static void
udisks_partition_table_proxy_iface_init (UDisksPartitionTableIface *iface)
{
  iface->get_partitions = udisks_partition_table_proxy_get_partitions;
  iface->get_type_ = udisks_partition_table_proxy_get_type_;
}

/**
 * udisks_partition_table_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-PartitionTable.top_of_page">org.freedesktop.UDisks2.PartitionTable</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_partition_table_proxy_new_finish() to get the result of the operation.
 *
 * See udisks_partition_table_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_partition_table_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_PARTITION_TABLE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.PartitionTable", NULL);
}

/**
 * udisks_partition_table_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_partition_table_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_partition_table_proxy_new().
 *
 * Returns: (transfer full) (type UDisksPartitionTableProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksPartitionTable *
udisks_partition_table_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_PARTITION_TABLE (ret);
  else
    return NULL;
}

/**
 * udisks_partition_table_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-PartitionTable.top_of_page">org.freedesktop.UDisks2.PartitionTable</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_partition_table_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksPartitionTableProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksPartitionTable *
udisks_partition_table_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_PARTITION_TABLE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.PartitionTable", NULL);
  if (ret != NULL)
    return UDISKS_PARTITION_TABLE (ret);
  else
    return NULL;
}


/**
 * udisks_partition_table_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like udisks_partition_table_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_partition_table_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See udisks_partition_table_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_partition_table_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_PARTITION_TABLE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.PartitionTable", NULL);
}

/**
 * udisks_partition_table_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_partition_table_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_partition_table_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type UDisksPartitionTableProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksPartitionTable *
udisks_partition_table_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_PARTITION_TABLE (ret);
  else
    return NULL;
}

/**
 * udisks_partition_table_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like udisks_partition_table_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_partition_table_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksPartitionTableProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksPartitionTable *
udisks_partition_table_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_PARTITION_TABLE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.PartitionTable", NULL);
  if (ret != NULL)
    return UDISKS_PARTITION_TABLE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * UDisksPartitionTableSkeleton:
 *
 * The #UDisksPartitionTableSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksPartitionTableSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksPartitionTableSkeleton.
 */

struct _UDisksPartitionTableSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_udisks_partition_table_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  UDisksPartitionTableSkeleton *skeleton = UDISKS_PARTITION_TABLE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], UDISKS_TYPE_PARTITION_TABLE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_PARTITION_TABLE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_udisks_partition_table_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  UDisksPartitionTableSkeleton *skeleton = UDISKS_PARTITION_TABLE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_partition_table_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_udisks_partition_table_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  UDisksPartitionTableSkeleton *skeleton = UDISKS_PARTITION_TABLE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_partition_table_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _udisks_partition_table_skeleton_vtable =
{
  _udisks_partition_table_skeleton_handle_method_call,
  _udisks_partition_table_skeleton_handle_get_property,
  _udisks_partition_table_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
udisks_partition_table_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return udisks_partition_table_interface_info ();
}

static GDBusInterfaceVTable *
udisks_partition_table_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_udisks_partition_table_skeleton_vtable;
}

static GVariant *
udisks_partition_table_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksPartitionTableSkeleton *skeleton = UDISKS_PARTITION_TABLE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_udisks_partition_table_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _udisks_partition_table_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _udisks_partition_table_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _udisks_partition_table_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.UDisks2.PartitionTable", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _udisks_partition_table_emit_changed (gpointer user_data);

static void
udisks_partition_table_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksPartitionTableSkeleton *skeleton = UDISKS_PARTITION_TABLE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _udisks_partition_table_emit_changed (skeleton);
}

static void udisks_partition_table_skeleton_iface_init (UDisksPartitionTableIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksPartitionTableSkeleton, udisks_partition_table_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (UDisksPartitionTableSkeleton)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_PARTITION_TABLE, udisks_partition_table_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksPartitionTableSkeleton, udisks_partition_table_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_PARTITION_TABLE, udisks_partition_table_skeleton_iface_init))

#endif
static void
udisks_partition_table_skeleton_finalize (GObject *object)
{
  UDisksPartitionTableSkeleton *skeleton = UDISKS_PARTITION_TABLE_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (udisks_partition_table_skeleton_parent_class)->finalize (object);
}

static void
udisks_partition_table_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  UDisksPartitionTableSkeleton *skeleton = UDISKS_PARTITION_TABLE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_udisks_partition_table_emit_changed (gpointer user_data)
{
  UDisksPartitionTableSkeleton *skeleton = UDISKS_PARTITION_TABLE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.UDisks2.PartitionTable",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_udisks_partition_table_schedule_emit_changed (UDisksPartitionTableSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
udisks_partition_table_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  UDisksPartitionTableSkeleton *skeleton = UDISKS_PARTITION_TABLE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _udisks_partition_table_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _udisks_partition_table_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
udisks_partition_table_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  UDisksPartitionTableSkeleton *skeleton = UDISKS_PARTITION_TABLE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_partition_table_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _udisks_partition_table_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
udisks_partition_table_skeleton_init (UDisksPartitionTableSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = udisks_partition_table_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, UDISKS_TYPE_PARTITION_TABLE_SKELETON, UDisksPartitionTableSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
}

static const gchar *const *
udisks_partition_table_skeleton_get_partitions (UDisksPartitionTable *object)
{
  UDisksPartitionTableSkeleton *skeleton = UDISKS_PARTITION_TABLE_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_partition_table_skeleton_get_type_ (UDisksPartitionTable *object)
{
  UDisksPartitionTableSkeleton *skeleton = UDISKS_PARTITION_TABLE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
udisks_partition_table_skeleton_class_init (UDisksPartitionTableSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = udisks_partition_table_skeleton_finalize;
  gobject_class->get_property = udisks_partition_table_skeleton_get_property;
  gobject_class->set_property = udisks_partition_table_skeleton_set_property;
  gobject_class->notify       = udisks_partition_table_skeleton_notify;


  udisks_partition_table_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = udisks_partition_table_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = udisks_partition_table_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = udisks_partition_table_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = udisks_partition_table_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksPartitionTableSkeletonPrivate));
#endif
}

static void
udisks_partition_table_skeleton_iface_init (UDisksPartitionTableIface *iface)
{
  iface->get_partitions = udisks_partition_table_skeleton_get_partitions;
  iface->get_type_ = udisks_partition_table_skeleton_get_type_;
}

/**
 * udisks_partition_table_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-PartitionTable.top_of_page">org.freedesktop.UDisks2.PartitionTable</link>.
 *
 * Returns: (transfer full) (type UDisksPartitionTableSkeleton): The skeleton object.
 */
UDisksPartitionTable *
udisks_partition_table_skeleton_new (void)
{
  return UDISKS_PARTITION_TABLE (g_object_new (UDISKS_TYPE_PARTITION_TABLE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.UDisks2.Partition
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:UDisksPartition
 * @title: UDisksPartition
 * @short_description: Generated C code for the org.freedesktop.UDisks2.Partition D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Partition.top_of_page">org.freedesktop.UDisks2.Partition</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.UDisks2.Partition ---- */

static const _ExtendedGDBusArgInfo _udisks_partition_method_info_set_type_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_method_info_set_type_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_partition_method_info_set_type_IN_ARG_pointers[] =
{
  &_udisks_partition_method_info_set_type_IN_ARG_type.parent_struct,
  &_udisks_partition_method_info_set_type_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_partition_method_info_set_type =
{
  {
    -1,
    (gchar *) "SetType",
    (GDBusArgInfo **) &_udisks_partition_method_info_set_type_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-type",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_method_info_set_name_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_method_info_set_name_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_partition_method_info_set_name_IN_ARG_pointers[] =
{
  &_udisks_partition_method_info_set_name_IN_ARG_name.parent_struct,
  &_udisks_partition_method_info_set_name_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_partition_method_info_set_name =
{
  {
    -1,
    (gchar *) "SetName",
    (GDBusArgInfo **) &_udisks_partition_method_info_set_name_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-name",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_method_info_set_flags_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_method_info_set_flags_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_partition_method_info_set_flags_IN_ARG_pointers[] =
{
  &_udisks_partition_method_info_set_flags_IN_ARG_flags.parent_struct,
  &_udisks_partition_method_info_set_flags_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_partition_method_info_set_flags =
{
  {
    -1,
    (gchar *) "SetFlags",
    (GDBusArgInfo **) &_udisks_partition_method_info_set_flags_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-flags",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_method_info_resize_IN_ARG_size =
{
  {
    -1,
    (gchar *) "size",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_method_info_resize_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_partition_method_info_resize_IN_ARG_pointers[] =
{
  &_udisks_partition_method_info_resize_IN_ARG_size.parent_struct,
  &_udisks_partition_method_info_resize_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_partition_method_info_resize =
{
  {
    -1,
    (gchar *) "Resize",
    (GDBusArgInfo **) &_udisks_partition_method_info_resize_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-resize",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_partition_method_info_delete_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_partition_method_info_delete_IN_ARG_pointers[] =
{
  &_udisks_partition_method_info_delete_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_partition_method_info_delete =
{
  {
    -1,
    (gchar *) "Delete",
    (GDBusArgInfo **) &_udisks_partition_method_info_delete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete",
  FALSE
};

static const GDBusMethodInfo * const _udisks_partition_method_info_pointers[] =
{
  &_udisks_partition_method_info_set_type.parent_struct,
  &_udisks_partition_method_info_set_name.parent_struct,
  &_udisks_partition_method_info_set_flags.parent_struct,
  &_udisks_partition_method_info_resize.parent_struct,
  &_udisks_partition_method_info_delete.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _udisks_partition_property_info_number =
{
  {
    -1,
    (gchar *) "Number",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "number",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_partition_property_info_type_ =
{
  {
    -1,
    (gchar *) "Type",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_partition_property_info_flags =
{
  {
    -1,
    (gchar *) "Flags",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "flags",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_partition_property_info_offset =
{
  {
    -1,
    (gchar *) "Offset",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "offset",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_partition_property_info_size =
{
  {
    -1,
    (gchar *) "Size",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "size",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_partition_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_partition_property_info_uuid =
{
  {
    -1,
    (gchar *) "UUID",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "uuid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_partition_property_info_table =
{
  {
    -1,
    (gchar *) "Table",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "table",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_partition_property_info_is_container =
{
  {
    -1,
    (gchar *) "IsContainer",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "is-container",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_partition_property_info_is_contained =
{
  {
    -1,
    (gchar *) "IsContained",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "is-contained",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _udisks_partition_property_info_pointers[] =
{
  &_udisks_partition_property_info_number.parent_struct,
  &_udisks_partition_property_info_type_.parent_struct,
  &_udisks_partition_property_info_flags.parent_struct,
  &_udisks_partition_property_info_offset.parent_struct,
  &_udisks_partition_property_info_size.parent_struct,
  &_udisks_partition_property_info_name.parent_struct,
  &_udisks_partition_property_info_uuid.parent_struct,
  &_udisks_partition_property_info_table.parent_struct,
  &_udisks_partition_property_info_is_container.parent_struct,
  &_udisks_partition_property_info_is_contained.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _udisks_partition_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.UDisks2.Partition",
    (GDBusMethodInfo **) &_udisks_partition_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_udisks_partition_property_info_pointers,
    NULL
  },
  "partition",
};


/**
 * udisks_partition_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Partition.top_of_page">org.freedesktop.UDisks2.Partition</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
udisks_partition_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_udisks_partition_interface_info.parent_struct;
}

/**
 * udisks_partition_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #UDisksPartition interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
udisks_partition_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "number");
  g_object_class_override_property (klass, property_id_begin++, "type");
  g_object_class_override_property (klass, property_id_begin++, "flags");
  g_object_class_override_property (klass, property_id_begin++, "offset");
  g_object_class_override_property (klass, property_id_begin++, "size");
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "uuid");
  g_object_class_override_property (klass, property_id_begin++, "table");
  g_object_class_override_property (klass, property_id_begin++, "is-container");
  g_object_class_override_property (klass, property_id_begin++, "is-contained");
  return property_id_begin - 1;
}



/**
 * UDisksPartition:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Partition.top_of_page">org.freedesktop.UDisks2.Partition</link>.
 */

/**
 * UDisksPartitionIface:
 * @parent_iface: The parent interface.
 * @handle_delete: Handler for the #UDisksPartition::handle-delete signal.
 * @handle_resize: Handler for the #UDisksPartition::handle-resize signal.
 * @handle_set_flags: Handler for the #UDisksPartition::handle-set-flags signal.
 * @handle_set_name: Handler for the #UDisksPartition::handle-set-name signal.
 * @handle_set_type: Handler for the #UDisksPartition::handle-set-type signal.
 * @get_flags: Getter for the #UDisksPartition:flags property.
 * @get_is_contained: Getter for the #UDisksPartition:is-contained property.
 * @get_is_container: Getter for the #UDisksPartition:is-container property.
 * @get_name: Getter for the #UDisksPartition:name property.
 * @get_number: Getter for the #UDisksPartition:number property.
 * @get_offset: Getter for the #UDisksPartition:offset property.
 * @get_size: Getter for the #UDisksPartition:size property.
 * @get_table: Getter for the #UDisksPartition:table property.
 * @get_type_: Getter for the #UDisksPartition:type property.
 * @get_uuid: Getter for the #UDisksPartition:uuid property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Partition.top_of_page">org.freedesktop.UDisks2.Partition</link>.
 */

typedef UDisksPartitionIface UDisksPartitionInterface;
G_DEFINE_INTERFACE (UDisksPartition, udisks_partition, G_TYPE_OBJECT)

static void
udisks_partition_default_init (UDisksPartitionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * UDisksPartition::handle-set-type:
   * @object: A #UDisksPartition.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_type: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.SetType">SetType()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_partition_complete_set_type() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-type",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksPartitionIface, handle_set_type),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * UDisksPartition::handle-set-name:
   * @object: A #UDisksPartition.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.SetName">SetName()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_partition_complete_set_name() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-name",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksPartitionIface, handle_set_name),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * UDisksPartition::handle-set-flags:
   * @object: A #UDisksPartition.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.SetFlags">SetFlags()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_partition_complete_set_flags() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-flags",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksPartitionIface, handle_set_flags),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_VARIANT);

  /**
   * UDisksPartition::handle-resize:
   * @object: A #UDisksPartition.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_size: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.Resize">Resize()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_partition_complete_resize() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-resize",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksPartitionIface, handle_resize),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_VARIANT);

  /**
   * UDisksPartition::handle-delete:
   * @object: A #UDisksPartition.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.Delete">Delete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_partition_complete_delete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksPartitionIface, handle_delete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * UDisksPartition:number:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Number">"Number"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("number", "Number", "Number", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksPartition:type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Type">"Type"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("type", "Type", "Type", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksPartition:flags:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Flags">"Flags"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("flags", "Flags", "Flags", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksPartition:offset:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Offset">"Offset"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("offset", "Offset", "Offset", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksPartition:size:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Size">"Size"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("size", "Size", "Size", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksPartition:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksPartition:uuid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.UUID">"UUID"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("uuid", "UUID", "UUID", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksPartition:table:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Table">"Table"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("table", "Table", "Table", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksPartition:is-container:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.IsContainer">"IsContainer"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("is-container", "IsContainer", "IsContainer", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksPartition:is-contained:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.IsContained">"IsContained"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("is-contained", "IsContained", "IsContained", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * udisks_partition_get_number: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Number">"Number"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
udisks_partition_get_number (UDisksPartition *object)
{
  return UDISKS_PARTITION_GET_IFACE (object)->get_number (object);
}

/**
 * udisks_partition_set_number: (skip)
 * @object: A #UDisksPartition.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Number">"Number"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_partition_set_number (UDisksPartition *object, guint value)
{
  g_object_set (G_OBJECT (object), "number", value, NULL);
}

/**
 * udisks_partition_get_type_: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_partition_dup_type_() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_partition_get_type_ (UDisksPartition *object)
{
  return UDISKS_PARTITION_GET_IFACE (object)->get_type_ (object);
}

/**
 * udisks_partition_dup_type_: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_partition_dup_type_ (UDisksPartition *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "type", &value, NULL);
  return value;
}

/**
 * udisks_partition_set_type_: (skip)
 * @object: A #UDisksPartition.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Type">"Type"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_partition_set_type_ (UDisksPartition *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "type", value, NULL);
}

/**
 * udisks_partition_get_flags: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Flags">"Flags"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
udisks_partition_get_flags (UDisksPartition *object)
{
  return UDISKS_PARTITION_GET_IFACE (object)->get_flags (object);
}

/**
 * udisks_partition_set_flags: (skip)
 * @object: A #UDisksPartition.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Flags">"Flags"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_partition_set_flags (UDisksPartition *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "flags", value, NULL);
}

/**
 * udisks_partition_get_offset: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Offset">"Offset"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
udisks_partition_get_offset (UDisksPartition *object)
{
  return UDISKS_PARTITION_GET_IFACE (object)->get_offset (object);
}

/**
 * udisks_partition_set_offset: (skip)
 * @object: A #UDisksPartition.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Offset">"Offset"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_partition_set_offset (UDisksPartition *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "offset", value, NULL);
}

/**
 * udisks_partition_get_size: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Size">"Size"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
udisks_partition_get_size (UDisksPartition *object)
{
  return UDISKS_PARTITION_GET_IFACE (object)->get_size (object);
}

/**
 * udisks_partition_set_size: (skip)
 * @object: A #UDisksPartition.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Size">"Size"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_partition_set_size (UDisksPartition *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "size", value, NULL);
}

/**
 * udisks_partition_get_name: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_partition_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_partition_get_name (UDisksPartition *object)
{
  return UDISKS_PARTITION_GET_IFACE (object)->get_name (object);
}

/**
 * udisks_partition_dup_name: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_partition_dup_name (UDisksPartition *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * udisks_partition_set_name: (skip)
 * @object: A #UDisksPartition.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_partition_set_name (UDisksPartition *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * udisks_partition_get_uuid: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.UUID">"UUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_partition_dup_uuid() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_partition_get_uuid (UDisksPartition *object)
{
  return UDISKS_PARTITION_GET_IFACE (object)->get_uuid (object);
}

/**
 * udisks_partition_dup_uuid: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.UUID">"UUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_partition_dup_uuid (UDisksPartition *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "uuid", &value, NULL);
  return value;
}

/**
 * udisks_partition_set_uuid: (skip)
 * @object: A #UDisksPartition.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.UUID">"UUID"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_partition_set_uuid (UDisksPartition *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "uuid", value, NULL);
}

/**
 * udisks_partition_get_table: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Table">"Table"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_partition_dup_table() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_partition_get_table (UDisksPartition *object)
{
  return UDISKS_PARTITION_GET_IFACE (object)->get_table (object);
}

/**
 * udisks_partition_dup_table: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Table">"Table"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_partition_dup_table (UDisksPartition *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "table", &value, NULL);
  return value;
}

/**
 * udisks_partition_set_table: (skip)
 * @object: A #UDisksPartition.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.Table">"Table"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_partition_set_table (UDisksPartition *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "table", value, NULL);
}

/**
 * udisks_partition_get_is_container: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.IsContainer">"IsContainer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_partition_get_is_container (UDisksPartition *object)
{
  return UDISKS_PARTITION_GET_IFACE (object)->get_is_container (object);
}

/**
 * udisks_partition_set_is_container: (skip)
 * @object: A #UDisksPartition.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.IsContainer">"IsContainer"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_partition_set_is_container (UDisksPartition *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "is-container", value, NULL);
}

/**
 * udisks_partition_get_is_contained: (skip)
 * @object: A #UDisksPartition.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.IsContained">"IsContained"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_partition_get_is_contained (UDisksPartition *object)
{
  return UDISKS_PARTITION_GET_IFACE (object)->get_is_contained (object);
}

/**
 * udisks_partition_set_is_contained: (skip)
 * @object: A #UDisksPartition.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Partition.IsContained">"IsContained"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_partition_set_is_contained (UDisksPartition *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "is-contained", value, NULL);
}

/**
 * udisks_partition_call_set_type:
 * @proxy: A #UDisksPartitionProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.SetType">SetType()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_partition_call_set_type_finish() to get the result of the operation.
 *
 * See udisks_partition_call_set_type_sync() for the synchronous, blocking version of this method.
 */
void
udisks_partition_call_set_type (
    UDisksPartition *proxy,
    const gchar *arg_type,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetType",
    g_variant_new ("(s@a{sv})",
                   arg_type,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_partition_call_set_type_finish:
 * @proxy: A #UDisksPartitionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_partition_call_set_type().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_partition_call_set_type().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_call_set_type_finish (
    UDisksPartition *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_call_set_type_sync:
 * @proxy: A #UDisksPartitionProxy.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.SetType">SetType()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_partition_call_set_type() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_call_set_type_sync (
    UDisksPartition *proxy,
    const gchar *arg_type,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetType",
    g_variant_new ("(s@a{sv})",
                   arg_type,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_call_set_name:
 * @proxy: A #UDisksPartitionProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.SetName">SetName()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_partition_call_set_name_finish() to get the result of the operation.
 *
 * See udisks_partition_call_set_name_sync() for the synchronous, blocking version of this method.
 */
void
udisks_partition_call_set_name (
    UDisksPartition *proxy,
    const gchar *arg_name,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetName",
    g_variant_new ("(s@a{sv})",
                   arg_name,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_partition_call_set_name_finish:
 * @proxy: A #UDisksPartitionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_partition_call_set_name().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_partition_call_set_name().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_call_set_name_finish (
    UDisksPartition *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_call_set_name_sync:
 * @proxy: A #UDisksPartitionProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.SetName">SetName()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_partition_call_set_name() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_call_set_name_sync (
    UDisksPartition *proxy,
    const gchar *arg_name,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetName",
    g_variant_new ("(s@a{sv})",
                   arg_name,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_call_set_flags:
 * @proxy: A #UDisksPartitionProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.SetFlags">SetFlags()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_partition_call_set_flags_finish() to get the result of the operation.
 *
 * See udisks_partition_call_set_flags_sync() for the synchronous, blocking version of this method.
 */
void
udisks_partition_call_set_flags (
    UDisksPartition *proxy,
    guint64 arg_flags,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetFlags",
    g_variant_new ("(t@a{sv})",
                   arg_flags,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_partition_call_set_flags_finish:
 * @proxy: A #UDisksPartitionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_partition_call_set_flags().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_partition_call_set_flags().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_call_set_flags_finish (
    UDisksPartition *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_call_set_flags_sync:
 * @proxy: A #UDisksPartitionProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.SetFlags">SetFlags()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_partition_call_set_flags() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_call_set_flags_sync (
    UDisksPartition *proxy,
    guint64 arg_flags,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetFlags",
    g_variant_new ("(t@a{sv})",
                   arg_flags,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_call_resize:
 * @proxy: A #UDisksPartitionProxy.
 * @arg_size: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.Resize">Resize()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_partition_call_resize_finish() to get the result of the operation.
 *
 * See udisks_partition_call_resize_sync() for the synchronous, blocking version of this method.
 */
void
udisks_partition_call_resize (
    UDisksPartition *proxy,
    guint64 arg_size,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Resize",
    g_variant_new ("(t@a{sv})",
                   arg_size,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_partition_call_resize_finish:
 * @proxy: A #UDisksPartitionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_partition_call_resize().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_partition_call_resize().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_call_resize_finish (
    UDisksPartition *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_call_resize_sync:
 * @proxy: A #UDisksPartitionProxy.
 * @arg_size: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.Resize">Resize()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_partition_call_resize() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_call_resize_sync (
    UDisksPartition *proxy,
    guint64 arg_size,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Resize",
    g_variant_new ("(t@a{sv})",
                   arg_size,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_call_delete:
 * @proxy: A #UDisksPartitionProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.Delete">Delete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_partition_call_delete_finish() to get the result of the operation.
 *
 * See udisks_partition_call_delete_sync() for the synchronous, blocking version of this method.
 */
void
udisks_partition_call_delete (
    UDisksPartition *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_partition_call_delete_finish:
 * @proxy: A #UDisksPartitionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_partition_call_delete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_partition_call_delete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_call_delete_finish (
    UDisksPartition *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_call_delete_sync:
 * @proxy: A #UDisksPartitionProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.Delete">Delete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_partition_call_delete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_partition_call_delete_sync (
    UDisksPartition *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_partition_complete_set_type:
 * @object: A #UDisksPartition.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.SetType">SetType()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_partition_complete_set_type (
    UDisksPartition *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_partition_complete_set_name:
 * @object: A #UDisksPartition.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.SetName">SetName()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_partition_complete_set_name (
    UDisksPartition *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_partition_complete_set_flags:
 * @object: A #UDisksPartition.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.SetFlags">SetFlags()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_partition_complete_set_flags (
    UDisksPartition *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_partition_complete_resize:
 * @object: A #UDisksPartition.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.Resize">Resize()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_partition_complete_resize (
    UDisksPartition *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_partition_complete_delete:
 * @object: A #UDisksPartition.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Partition.Delete">Delete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_partition_complete_delete (
    UDisksPartition *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * UDisksPartitionProxy:
 *
 * The #UDisksPartitionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksPartitionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksPartitionProxy.
 */

struct _UDisksPartitionProxyPrivate
{
  GData *qdata;
};

static void udisks_partition_proxy_iface_init (UDisksPartitionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksPartitionProxy, udisks_partition_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (UDisksPartitionProxy)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_PARTITION, udisks_partition_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksPartitionProxy, udisks_partition_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_PARTITION, udisks_partition_proxy_iface_init))

#endif
static void
udisks_partition_proxy_finalize (GObject *object)
{
  UDisksPartitionProxy *proxy = UDISKS_PARTITION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (udisks_partition_proxy_parent_class)->finalize (object);
}

static void
udisks_partition_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_partition_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
udisks_partition_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.UDisks2.Partition: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
udisks_partition_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_partition_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.UDisks2.Partition", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) udisks_partition_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
udisks_partition_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_udisks_partition_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], UDISKS_TYPE_PARTITION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_PARTITION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
udisks_partition_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  UDisksPartitionProxy *proxy = UDISKS_PARTITION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_partition_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_partition_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
udisks_partition_proxy_get_number (UDisksPartition *object)
{
  UDisksPartitionProxy *proxy = UDISKS_PARTITION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Number");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_partition_proxy_get_type_ (UDisksPartition *object)
{
  UDisksPartitionProxy *proxy = UDISKS_PARTITION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Type");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
udisks_partition_proxy_get_flags (UDisksPartition *object)
{
  UDisksPartitionProxy *proxy = UDISKS_PARTITION_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Flags");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
udisks_partition_proxy_get_offset (UDisksPartition *object)
{
  UDisksPartitionProxy *proxy = UDISKS_PARTITION_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Offset");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
udisks_partition_proxy_get_size (UDisksPartition *object)
{
  UDisksPartitionProxy *proxy = UDISKS_PARTITION_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Size");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_partition_proxy_get_name (UDisksPartition *object)
{
  UDisksPartitionProxy *proxy = UDISKS_PARTITION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_partition_proxy_get_uuid (UDisksPartition *object)
{
  UDisksPartitionProxy *proxy = UDISKS_PARTITION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UUID");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
udisks_partition_proxy_get_table (UDisksPartition *object)
{
  UDisksPartitionProxy *proxy = UDISKS_PARTITION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Table");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_partition_proxy_get_is_container (UDisksPartition *object)
{
  UDisksPartitionProxy *proxy = UDISKS_PARTITION_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IsContainer");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
udisks_partition_proxy_get_is_contained (UDisksPartition *object)
{
  UDisksPartitionProxy *proxy = UDISKS_PARTITION_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IsContained");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
udisks_partition_proxy_init (UDisksPartitionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = udisks_partition_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, UDISKS_TYPE_PARTITION_PROXY, UDisksPartitionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), udisks_partition_interface_info ());
}

static void
udisks_partition_proxy_class_init (UDisksPartitionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = udisks_partition_proxy_finalize;
  gobject_class->get_property = udisks_partition_proxy_get_property;
  gobject_class->set_property = udisks_partition_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = udisks_partition_proxy_g_signal;
  proxy_class->g_properties_changed = udisks_partition_proxy_g_properties_changed;

  udisks_partition_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksPartitionProxyPrivate));
#endif
}

static void
udisks_partition_proxy_iface_init (UDisksPartitionIface *iface)
{
  iface->get_number = udisks_partition_proxy_get_number;
  iface->get_type_ = udisks_partition_proxy_get_type_;
  iface->get_flags = udisks_partition_proxy_get_flags;
  iface->get_offset = udisks_partition_proxy_get_offset;
  iface->get_size = udisks_partition_proxy_get_size;
  iface->get_name = udisks_partition_proxy_get_name;
  iface->get_uuid = udisks_partition_proxy_get_uuid;
  iface->get_table = udisks_partition_proxy_get_table;
  iface->get_is_container = udisks_partition_proxy_get_is_container;
  iface->get_is_contained = udisks_partition_proxy_get_is_contained;
}

/**
 * udisks_partition_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Partition.top_of_page">org.freedesktop.UDisks2.Partition</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_partition_proxy_new_finish() to get the result of the operation.
 *
 * See udisks_partition_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_partition_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_PARTITION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Partition", NULL);
}

/**
 * udisks_partition_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_partition_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_partition_proxy_new().
 *
 * Returns: (transfer full) (type UDisksPartitionProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksPartition *
udisks_partition_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_PARTITION (ret);
  else
    return NULL;
}

/**
 * udisks_partition_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Partition.top_of_page">org.freedesktop.UDisks2.Partition</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_partition_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksPartitionProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksPartition *
udisks_partition_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_PARTITION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Partition", NULL);
  if (ret != NULL)
    return UDISKS_PARTITION (ret);
  else
    return NULL;
}


/**
 * udisks_partition_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like udisks_partition_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_partition_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See udisks_partition_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_partition_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_PARTITION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Partition", NULL);
}

/**
 * udisks_partition_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_partition_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_partition_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type UDisksPartitionProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksPartition *
udisks_partition_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_PARTITION (ret);
  else
    return NULL;
}

/**
 * udisks_partition_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like udisks_partition_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_partition_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksPartitionProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksPartition *
udisks_partition_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_PARTITION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Partition", NULL);
  if (ret != NULL)
    return UDISKS_PARTITION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * UDisksPartitionSkeleton:
 *
 * The #UDisksPartitionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksPartitionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksPartitionSkeleton.
 */

struct _UDisksPartitionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_udisks_partition_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], UDISKS_TYPE_PARTITION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_PARTITION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_udisks_partition_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_partition_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_udisks_partition_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_partition_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _udisks_partition_skeleton_vtable =
{
  _udisks_partition_skeleton_handle_method_call,
  _udisks_partition_skeleton_handle_get_property,
  _udisks_partition_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
udisks_partition_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return udisks_partition_interface_info ();
}

static GDBusInterfaceVTable *
udisks_partition_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_udisks_partition_skeleton_vtable;
}

static GVariant *
udisks_partition_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_udisks_partition_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _udisks_partition_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _udisks_partition_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _udisks_partition_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.UDisks2.Partition", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _udisks_partition_emit_changed (gpointer user_data);

static void
udisks_partition_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _udisks_partition_emit_changed (skeleton);
}

static void udisks_partition_skeleton_iface_init (UDisksPartitionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksPartitionSkeleton, udisks_partition_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (UDisksPartitionSkeleton)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_PARTITION, udisks_partition_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksPartitionSkeleton, udisks_partition_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_PARTITION, udisks_partition_skeleton_iface_init))

#endif
static void
udisks_partition_skeleton_finalize (GObject *object)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  guint n;
  for (n = 0; n < 10; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (udisks_partition_skeleton_parent_class)->finalize (object);
}

static void
udisks_partition_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_udisks_partition_emit_changed (gpointer user_data)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.UDisks2.Partition",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_udisks_partition_schedule_emit_changed (UDisksPartitionSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
udisks_partition_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _udisks_partition_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _udisks_partition_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
udisks_partition_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_partition_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _udisks_partition_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
udisks_partition_skeleton_init (UDisksPartitionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = udisks_partition_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, UDISKS_TYPE_PARTITION_SKELETON, UDisksPartitionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 10);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_BOOLEAN);
}

static guint 
udisks_partition_skeleton_get_number (UDisksPartition *object)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_partition_skeleton_get_type_ (UDisksPartition *object)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
udisks_partition_skeleton_get_flags (UDisksPartition *object)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
udisks_partition_skeleton_get_offset (UDisksPartition *object)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
udisks_partition_skeleton_get_size (UDisksPartition *object)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_partition_skeleton_get_name (UDisksPartition *object)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_partition_skeleton_get_uuid (UDisksPartition *object)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
udisks_partition_skeleton_get_table (UDisksPartition *object)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_partition_skeleton_get_is_container (UDisksPartition *object)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
udisks_partition_skeleton_get_is_contained (UDisksPartition *object)
{
  UDisksPartitionSkeleton *skeleton = UDISKS_PARTITION_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
udisks_partition_skeleton_class_init (UDisksPartitionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = udisks_partition_skeleton_finalize;
  gobject_class->get_property = udisks_partition_skeleton_get_property;
  gobject_class->set_property = udisks_partition_skeleton_set_property;
  gobject_class->notify       = udisks_partition_skeleton_notify;


  udisks_partition_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = udisks_partition_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = udisks_partition_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = udisks_partition_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = udisks_partition_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksPartitionSkeletonPrivate));
#endif
}

static void
udisks_partition_skeleton_iface_init (UDisksPartitionIface *iface)
{
  iface->get_number = udisks_partition_skeleton_get_number;
  iface->get_type_ = udisks_partition_skeleton_get_type_;
  iface->get_flags = udisks_partition_skeleton_get_flags;
  iface->get_offset = udisks_partition_skeleton_get_offset;
  iface->get_size = udisks_partition_skeleton_get_size;
  iface->get_name = udisks_partition_skeleton_get_name;
  iface->get_uuid = udisks_partition_skeleton_get_uuid;
  iface->get_table = udisks_partition_skeleton_get_table;
  iface->get_is_container = udisks_partition_skeleton_get_is_container;
  iface->get_is_contained = udisks_partition_skeleton_get_is_contained;
}

/**
 * udisks_partition_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Partition.top_of_page">org.freedesktop.UDisks2.Partition</link>.
 *
 * Returns: (transfer full) (type UDisksPartitionSkeleton): The skeleton object.
 */
UDisksPartition *
udisks_partition_skeleton_new (void)
{
  return UDISKS_PARTITION (g_object_new (UDISKS_TYPE_PARTITION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.UDisks2.Filesystem
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:UDisksFilesystem
 * @title: UDisksFilesystem
 * @short_description: Generated C code for the org.freedesktop.UDisks2.Filesystem D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Filesystem.top_of_page">org.freedesktop.UDisks2.Filesystem</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.UDisks2.Filesystem ---- */

static const _ExtendedGDBusArgInfo _udisks_filesystem_method_info_set_label_IN_ARG_label =
{
  {
    -1,
    (gchar *) "label",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_filesystem_method_info_set_label_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_filesystem_method_info_set_label_IN_ARG_pointers[] =
{
  &_udisks_filesystem_method_info_set_label_IN_ARG_label.parent_struct,
  &_udisks_filesystem_method_info_set_label_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_filesystem_method_info_set_label =
{
  {
    -1,
    (gchar *) "SetLabel",
    (GDBusArgInfo **) &_udisks_filesystem_method_info_set_label_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-label",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_filesystem_method_info_mount_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_filesystem_method_info_mount_IN_ARG_pointers[] =
{
  &_udisks_filesystem_method_info_mount_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_filesystem_method_info_mount_OUT_ARG_mount_path =
{
  {
    -1,
    (gchar *) "mount_path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_filesystem_method_info_mount_OUT_ARG_pointers[] =
{
  &_udisks_filesystem_method_info_mount_OUT_ARG_mount_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_filesystem_method_info_mount =
{
  {
    -1,
    (gchar *) "Mount",
    (GDBusArgInfo **) &_udisks_filesystem_method_info_mount_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_filesystem_method_info_mount_OUT_ARG_pointers,
    NULL
  },
  "handle-mount",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_filesystem_method_info_unmount_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_filesystem_method_info_unmount_IN_ARG_pointers[] =
{
  &_udisks_filesystem_method_info_unmount_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_filesystem_method_info_unmount =
{
  {
    -1,
    (gchar *) "Unmount",
    (GDBusArgInfo **) &_udisks_filesystem_method_info_unmount_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-unmount",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_filesystem_method_info_resize_IN_ARG_size =
{
  {
    -1,
    (gchar *) "size",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_filesystem_method_info_resize_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_filesystem_method_info_resize_IN_ARG_pointers[] =
{
  &_udisks_filesystem_method_info_resize_IN_ARG_size.parent_struct,
  &_udisks_filesystem_method_info_resize_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_filesystem_method_info_resize =
{
  {
    -1,
    (gchar *) "Resize",
    (GDBusArgInfo **) &_udisks_filesystem_method_info_resize_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-resize",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_filesystem_method_info_check_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_filesystem_method_info_check_IN_ARG_pointers[] =
{
  &_udisks_filesystem_method_info_check_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_filesystem_method_info_check_OUT_ARG_consistent =
{
  {
    -1,
    (gchar *) "consistent",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_filesystem_method_info_check_OUT_ARG_pointers[] =
{
  &_udisks_filesystem_method_info_check_OUT_ARG_consistent.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_filesystem_method_info_check =
{
  {
    -1,
    (gchar *) "Check",
    (GDBusArgInfo **) &_udisks_filesystem_method_info_check_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_filesystem_method_info_check_OUT_ARG_pointers,
    NULL
  },
  "handle-check",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_filesystem_method_info_repair_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_filesystem_method_info_repair_IN_ARG_pointers[] =
{
  &_udisks_filesystem_method_info_repair_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_filesystem_method_info_repair_OUT_ARG_repaired =
{
  {
    -1,
    (gchar *) "repaired",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_filesystem_method_info_repair_OUT_ARG_pointers[] =
{
  &_udisks_filesystem_method_info_repair_OUT_ARG_repaired.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_filesystem_method_info_repair =
{
  {
    -1,
    (gchar *) "Repair",
    (GDBusArgInfo **) &_udisks_filesystem_method_info_repair_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_filesystem_method_info_repair_OUT_ARG_pointers,
    NULL
  },
  "handle-repair",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_filesystem_method_info_take_ownership_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_filesystem_method_info_take_ownership_IN_ARG_pointers[] =
{
  &_udisks_filesystem_method_info_take_ownership_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_filesystem_method_info_take_ownership =
{
  {
    -1,
    (gchar *) "TakeOwnership",
    (GDBusArgInfo **) &_udisks_filesystem_method_info_take_ownership_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-take-ownership",
  FALSE
};

static const GDBusMethodInfo * const _udisks_filesystem_method_info_pointers[] =
{
  &_udisks_filesystem_method_info_set_label.parent_struct,
  &_udisks_filesystem_method_info_mount.parent_struct,
  &_udisks_filesystem_method_info_unmount.parent_struct,
  &_udisks_filesystem_method_info_resize.parent_struct,
  &_udisks_filesystem_method_info_check.parent_struct,
  &_udisks_filesystem_method_info_repair.parent_struct,
  &_udisks_filesystem_method_info_take_ownership.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _udisks_filesystem_property_info_mount_points =
{
  {
    -1,
    (gchar *) "MountPoints",
    (gchar *) "aay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "mount-points",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_filesystem_property_info_size =
{
  {
    -1,
    (gchar *) "Size",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "size",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _udisks_filesystem_property_info_pointers[] =
{
  &_udisks_filesystem_property_info_mount_points.parent_struct,
  &_udisks_filesystem_property_info_size.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _udisks_filesystem_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.UDisks2.Filesystem",
    (GDBusMethodInfo **) &_udisks_filesystem_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_udisks_filesystem_property_info_pointers,
    NULL
  },
  "filesystem",
};


/**
 * udisks_filesystem_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Filesystem.top_of_page">org.freedesktop.UDisks2.Filesystem</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
udisks_filesystem_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_udisks_filesystem_interface_info.parent_struct;
}

/**
 * udisks_filesystem_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #UDisksFilesystem interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
udisks_filesystem_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "mount-points");
  g_object_class_override_property (klass, property_id_begin++, "size");
  return property_id_begin - 1;
}



/**
 * UDisksFilesystem:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Filesystem.top_of_page">org.freedesktop.UDisks2.Filesystem</link>.
 */

/**
 * UDisksFilesystemIface:
 * @parent_iface: The parent interface.
 * @handle_mount: Handler for the #UDisksFilesystem::handle-mount signal.
 * @handle_set_label: Handler for the #UDisksFilesystem::handle-set-label signal.
 * @handle_unmount: Handler for the #UDisksFilesystem::handle-unmount signal.
 * @get_mount_points: Getter for the #UDisksFilesystem:mount-points property.
 * @get_size: Getter for the #UDisksFilesystem:size property.
 * @handle_check: Handler for the #UDisksFilesystem::handle-check signal.
 * @handle_repair: Handler for the #UDisksFilesystem::handle-repair signal.
 * @handle_resize: Handler for the #UDisksFilesystem::handle-resize signal.
 * @handle_take_ownership: Handler for the #UDisksFilesystem::handle-take-ownership signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Filesystem.top_of_page">org.freedesktop.UDisks2.Filesystem</link>.
 */

typedef UDisksFilesystemIface UDisksFilesystemInterface;
G_DEFINE_INTERFACE (UDisksFilesystem, udisks_filesystem, G_TYPE_OBJECT)

static void
udisks_filesystem_default_init (UDisksFilesystemIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * UDisksFilesystem::handle-set-label:
   * @object: A #UDisksFilesystem.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_label: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.SetLabel">SetLabel()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_filesystem_complete_set_label() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-label",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksFilesystemIface, handle_set_label),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * UDisksFilesystem::handle-mount:
   * @object: A #UDisksFilesystem.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Mount">Mount()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_filesystem_complete_mount() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-mount",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksFilesystemIface, handle_mount),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksFilesystem::handle-unmount:
   * @object: A #UDisksFilesystem.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Unmount">Unmount()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_filesystem_complete_unmount() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unmount",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksFilesystemIface, handle_unmount),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksFilesystem::handle-resize:
   * @object: A #UDisksFilesystem.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_size: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Resize">Resize()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_filesystem_complete_resize() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.7.2
   */
  g_signal_new ("handle-resize",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksFilesystemIface, handle_resize),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_VARIANT);

  /**
   * UDisksFilesystem::handle-check:
   * @object: A #UDisksFilesystem.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Check">Check()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_filesystem_complete_check() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.7.2
   */
  g_signal_new ("handle-check",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksFilesystemIface, handle_check),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksFilesystem::handle-repair:
   * @object: A #UDisksFilesystem.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Repair">Repair()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_filesystem_complete_repair() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.7.2
   */
  g_signal_new ("handle-repair",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksFilesystemIface, handle_repair),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksFilesystem::handle-take-ownership:
   * @object: A #UDisksFilesystem.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.TakeOwnership">TakeOwnership()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_filesystem_complete_take_ownership() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.7.2
   */
  g_signal_new ("handle-take-ownership",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksFilesystemIface, handle_take_ownership),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * UDisksFilesystem:mount-points:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Filesystem.MountPoints">"MountPoints"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("mount-points", "MountPoints", "MountPoints", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksFilesystem:size:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Filesystem.Size">"Size"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("size", "Size", "Size", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * udisks_filesystem_get_mount_points: (skip)
 * @object: A #UDisksFilesystem.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Filesystem.MountPoints">"MountPoints"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_filesystem_dup_mount_points() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
udisks_filesystem_get_mount_points (UDisksFilesystem *object)
{
  return UDISKS_FILESYSTEM_GET_IFACE (object)->get_mount_points (object);
}

/**
 * udisks_filesystem_dup_mount_points: (skip)
 * @object: A #UDisksFilesystem.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Filesystem.MountPoints">"MountPoints"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
udisks_filesystem_dup_mount_points (UDisksFilesystem *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "mount-points", &value, NULL);
  return value;
}

/**
 * udisks_filesystem_set_mount_points: (skip)
 * @object: A #UDisksFilesystem.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Filesystem.MountPoints">"MountPoints"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_filesystem_set_mount_points (UDisksFilesystem *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "mount-points", value, NULL);
}

/**
 * udisks_filesystem_get_size: (skip)
 * @object: A #UDisksFilesystem.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Filesystem.Size">"Size"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
udisks_filesystem_get_size (UDisksFilesystem *object)
{
  return UDISKS_FILESYSTEM_GET_IFACE (object)->get_size (object);
}

/**
 * udisks_filesystem_set_size: (skip)
 * @object: A #UDisksFilesystem.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Filesystem.Size">"Size"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_filesystem_set_size (UDisksFilesystem *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "size", value, NULL);
}

/**
 * udisks_filesystem_call_set_label:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_label: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.SetLabel">SetLabel()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_filesystem_call_set_label_finish() to get the result of the operation.
 *
 * See udisks_filesystem_call_set_label_sync() for the synchronous, blocking version of this method.
 */
void
udisks_filesystem_call_set_label (
    UDisksFilesystem *proxy,
    const gchar *arg_label,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetLabel",
    g_variant_new ("(s@a{sv})",
                   arg_label,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_filesystem_call_set_label_finish:
 * @proxy: A #UDisksFilesystemProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_filesystem_call_set_label().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_filesystem_call_set_label().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_filesystem_call_set_label_finish (
    UDisksFilesystem *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_call_set_label_sync:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_label: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.SetLabel">SetLabel()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_filesystem_call_set_label() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_filesystem_call_set_label_sync (
    UDisksFilesystem *proxy,
    const gchar *arg_label,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetLabel",
    g_variant_new ("(s@a{sv})",
                   arg_label,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_call_mount:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Mount">Mount()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_filesystem_call_mount_finish() to get the result of the operation.
 *
 * See udisks_filesystem_call_mount_sync() for the synchronous, blocking version of this method.
 */
void
udisks_filesystem_call_mount (
    UDisksFilesystem *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Mount",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_filesystem_call_mount_finish:
 * @proxy: A #UDisksFilesystemProxy.
 * @out_mount_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_filesystem_call_mount().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_filesystem_call_mount().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_filesystem_call_mount_finish (
    UDisksFilesystem *proxy,
    gchar **out_mount_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_mount_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_call_mount_sync:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_mount_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Mount">Mount()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_filesystem_call_mount() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_filesystem_call_mount_sync (
    UDisksFilesystem *proxy,
    GVariant *arg_options,
    gchar **out_mount_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Mount",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_mount_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_call_unmount:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Unmount">Unmount()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_filesystem_call_unmount_finish() to get the result of the operation.
 *
 * See udisks_filesystem_call_unmount_sync() for the synchronous, blocking version of this method.
 */
void
udisks_filesystem_call_unmount (
    UDisksFilesystem *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Unmount",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_filesystem_call_unmount_finish:
 * @proxy: A #UDisksFilesystemProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_filesystem_call_unmount().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_filesystem_call_unmount().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_filesystem_call_unmount_finish (
    UDisksFilesystem *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_call_unmount_sync:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Unmount">Unmount()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_filesystem_call_unmount() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_filesystem_call_unmount_sync (
    UDisksFilesystem *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Unmount",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_call_resize:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_size: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Resize">Resize()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_filesystem_call_resize_finish() to get the result of the operation.
 *
 * See udisks_filesystem_call_resize_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.7.2
 */
void
udisks_filesystem_call_resize (
    UDisksFilesystem *proxy,
    guint64 arg_size,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Resize",
    g_variant_new ("(t@a{sv})",
                   arg_size,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_filesystem_call_resize_finish:
 * @proxy: A #UDisksFilesystemProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_filesystem_call_resize().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_filesystem_call_resize().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_filesystem_call_resize_finish (
    UDisksFilesystem *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_call_resize_sync:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_size: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Resize">Resize()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_filesystem_call_resize() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_filesystem_call_resize_sync (
    UDisksFilesystem *proxy,
    guint64 arg_size,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Resize",
    g_variant_new ("(t@a{sv})",
                   arg_size,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_call_check:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Check">Check()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_filesystem_call_check_finish() to get the result of the operation.
 *
 * See udisks_filesystem_call_check_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.7.2
 */
void
udisks_filesystem_call_check (
    UDisksFilesystem *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Check",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_filesystem_call_check_finish:
 * @proxy: A #UDisksFilesystemProxy.
 * @out_consistent: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_filesystem_call_check().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_filesystem_call_check().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_filesystem_call_check_finish (
    UDisksFilesystem *proxy,
    gboolean *out_consistent,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_consistent);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_call_check_sync:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_consistent: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Check">Check()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_filesystem_call_check() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_filesystem_call_check_sync (
    UDisksFilesystem *proxy,
    GVariant *arg_options,
    gboolean *out_consistent,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Check",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_consistent);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_call_repair:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Repair">Repair()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_filesystem_call_repair_finish() to get the result of the operation.
 *
 * See udisks_filesystem_call_repair_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.7.2
 */
void
udisks_filesystem_call_repair (
    UDisksFilesystem *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Repair",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_filesystem_call_repair_finish:
 * @proxy: A #UDisksFilesystemProxy.
 * @out_repaired: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_filesystem_call_repair().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_filesystem_call_repair().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_filesystem_call_repair_finish (
    UDisksFilesystem *proxy,
    gboolean *out_repaired,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_repaired);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_call_repair_sync:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_repaired: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Repair">Repair()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_filesystem_call_repair() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_filesystem_call_repair_sync (
    UDisksFilesystem *proxy,
    GVariant *arg_options,
    gboolean *out_repaired,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Repair",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_repaired);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_call_take_ownership:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.TakeOwnership">TakeOwnership()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_filesystem_call_take_ownership_finish() to get the result of the operation.
 *
 * See udisks_filesystem_call_take_ownership_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.7.2
 */
void
udisks_filesystem_call_take_ownership (
    UDisksFilesystem *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "TakeOwnership",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_filesystem_call_take_ownership_finish:
 * @proxy: A #UDisksFilesystemProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_filesystem_call_take_ownership().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_filesystem_call_take_ownership().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_filesystem_call_take_ownership_finish (
    UDisksFilesystem *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_call_take_ownership_sync:
 * @proxy: A #UDisksFilesystemProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.TakeOwnership">TakeOwnership()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_filesystem_call_take_ownership() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.7.2
 */
gboolean
udisks_filesystem_call_take_ownership_sync (
    UDisksFilesystem *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "TakeOwnership",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_filesystem_complete_set_label:
 * @object: A #UDisksFilesystem.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.SetLabel">SetLabel()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_filesystem_complete_set_label (
    UDisksFilesystem *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_filesystem_complete_mount:
 * @object: A #UDisksFilesystem.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @mount_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Mount">Mount()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_filesystem_complete_mount (
    UDisksFilesystem *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *mount_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   mount_path));
}

/**
 * udisks_filesystem_complete_unmount:
 * @object: A #UDisksFilesystem.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Unmount">Unmount()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_filesystem_complete_unmount (
    UDisksFilesystem *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_filesystem_complete_resize:
 * @object: A #UDisksFilesystem.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Resize">Resize()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.7.2
 */
void
udisks_filesystem_complete_resize (
    UDisksFilesystem *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_filesystem_complete_check:
 * @object: A #UDisksFilesystem.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @consistent: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Check">Check()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.7.2
 */
void
udisks_filesystem_complete_check (
    UDisksFilesystem *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean consistent)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   consistent));
}

/**
 * udisks_filesystem_complete_repair:
 * @object: A #UDisksFilesystem.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @repaired: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.Repair">Repair()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.7.2
 */
void
udisks_filesystem_complete_repair (
    UDisksFilesystem *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean repaired)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   repaired));
}

/**
 * udisks_filesystem_complete_take_ownership:
 * @object: A #UDisksFilesystem.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Filesystem.TakeOwnership">TakeOwnership()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.7.2
 */
void
udisks_filesystem_complete_take_ownership (
    UDisksFilesystem *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * UDisksFilesystemProxy:
 *
 * The #UDisksFilesystemProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksFilesystemProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksFilesystemProxy.
 */

struct _UDisksFilesystemProxyPrivate
{
  GData *qdata;
};

static void udisks_filesystem_proxy_iface_init (UDisksFilesystemIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksFilesystemProxy, udisks_filesystem_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (UDisksFilesystemProxy)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_FILESYSTEM, udisks_filesystem_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksFilesystemProxy, udisks_filesystem_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_FILESYSTEM, udisks_filesystem_proxy_iface_init))

#endif
static void
udisks_filesystem_proxy_finalize (GObject *object)
{
  UDisksFilesystemProxy *proxy = UDISKS_FILESYSTEM_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (udisks_filesystem_proxy_parent_class)->finalize (object);
}

static void
udisks_filesystem_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_filesystem_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
udisks_filesystem_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.UDisks2.Filesystem: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
udisks_filesystem_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_filesystem_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.UDisks2.Filesystem", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) udisks_filesystem_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
udisks_filesystem_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_udisks_filesystem_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], UDISKS_TYPE_FILESYSTEM);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_FILESYSTEM);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
udisks_filesystem_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  UDisksFilesystemProxy *proxy = UDISKS_FILESYSTEM_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_filesystem_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_filesystem_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *const *
udisks_filesystem_proxy_get_mount_points (UDisksFilesystem *object)
{
  UDisksFilesystemProxy *proxy = UDISKS_FILESYSTEM_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "MountPoints");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MountPoints");
  if (variant != NULL)
    {
      value = g_variant_get_bytestring_array (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "MountPoints", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
udisks_filesystem_proxy_get_size (UDisksFilesystem *object)
{
  UDisksFilesystemProxy *proxy = UDISKS_FILESYSTEM_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Size");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
udisks_filesystem_proxy_init (UDisksFilesystemProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = udisks_filesystem_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, UDISKS_TYPE_FILESYSTEM_PROXY, UDisksFilesystemProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), udisks_filesystem_interface_info ());
}

static void
udisks_filesystem_proxy_class_init (UDisksFilesystemProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = udisks_filesystem_proxy_finalize;
  gobject_class->get_property = udisks_filesystem_proxy_get_property;
  gobject_class->set_property = udisks_filesystem_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = udisks_filesystem_proxy_g_signal;
  proxy_class->g_properties_changed = udisks_filesystem_proxy_g_properties_changed;

  udisks_filesystem_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksFilesystemProxyPrivate));
#endif
}

static void
udisks_filesystem_proxy_iface_init (UDisksFilesystemIface *iface)
{
  iface->get_mount_points = udisks_filesystem_proxy_get_mount_points;
  iface->get_size = udisks_filesystem_proxy_get_size;
}

/**
 * udisks_filesystem_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Filesystem.top_of_page">org.freedesktop.UDisks2.Filesystem</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_filesystem_proxy_new_finish() to get the result of the operation.
 *
 * See udisks_filesystem_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_filesystem_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_FILESYSTEM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Filesystem", NULL);
}

/**
 * udisks_filesystem_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_filesystem_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_filesystem_proxy_new().
 *
 * Returns: (transfer full) (type UDisksFilesystemProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksFilesystem *
udisks_filesystem_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_FILESYSTEM (ret);
  else
    return NULL;
}

/**
 * udisks_filesystem_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Filesystem.top_of_page">org.freedesktop.UDisks2.Filesystem</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_filesystem_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksFilesystemProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksFilesystem *
udisks_filesystem_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_FILESYSTEM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Filesystem", NULL);
  if (ret != NULL)
    return UDISKS_FILESYSTEM (ret);
  else
    return NULL;
}


/**
 * udisks_filesystem_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like udisks_filesystem_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_filesystem_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See udisks_filesystem_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_filesystem_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_FILESYSTEM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Filesystem", NULL);
}

/**
 * udisks_filesystem_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_filesystem_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_filesystem_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type UDisksFilesystemProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksFilesystem *
udisks_filesystem_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_FILESYSTEM (ret);
  else
    return NULL;
}

/**
 * udisks_filesystem_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like udisks_filesystem_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_filesystem_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksFilesystemProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksFilesystem *
udisks_filesystem_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_FILESYSTEM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Filesystem", NULL);
  if (ret != NULL)
    return UDISKS_FILESYSTEM (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * UDisksFilesystemSkeleton:
 *
 * The #UDisksFilesystemSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksFilesystemSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksFilesystemSkeleton.
 */

struct _UDisksFilesystemSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_udisks_filesystem_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  UDisksFilesystemSkeleton *skeleton = UDISKS_FILESYSTEM_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], UDISKS_TYPE_FILESYSTEM);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_FILESYSTEM);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_udisks_filesystem_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  UDisksFilesystemSkeleton *skeleton = UDISKS_FILESYSTEM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_filesystem_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_udisks_filesystem_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  UDisksFilesystemSkeleton *skeleton = UDISKS_FILESYSTEM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_filesystem_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _udisks_filesystem_skeleton_vtable =
{
  _udisks_filesystem_skeleton_handle_method_call,
  _udisks_filesystem_skeleton_handle_get_property,
  _udisks_filesystem_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
udisks_filesystem_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return udisks_filesystem_interface_info ();
}

static GDBusInterfaceVTable *
udisks_filesystem_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_udisks_filesystem_skeleton_vtable;
}

static GVariant *
udisks_filesystem_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksFilesystemSkeleton *skeleton = UDISKS_FILESYSTEM_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_udisks_filesystem_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _udisks_filesystem_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _udisks_filesystem_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _udisks_filesystem_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.UDisks2.Filesystem", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _udisks_filesystem_emit_changed (gpointer user_data);

static void
udisks_filesystem_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksFilesystemSkeleton *skeleton = UDISKS_FILESYSTEM_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _udisks_filesystem_emit_changed (skeleton);
}

static void udisks_filesystem_skeleton_iface_init (UDisksFilesystemIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksFilesystemSkeleton, udisks_filesystem_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (UDisksFilesystemSkeleton)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_FILESYSTEM, udisks_filesystem_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksFilesystemSkeleton, udisks_filesystem_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_FILESYSTEM, udisks_filesystem_skeleton_iface_init))

#endif
static void
udisks_filesystem_skeleton_finalize (GObject *object)
{
  UDisksFilesystemSkeleton *skeleton = UDISKS_FILESYSTEM_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (udisks_filesystem_skeleton_parent_class)->finalize (object);
}

static void
udisks_filesystem_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  UDisksFilesystemSkeleton *skeleton = UDISKS_FILESYSTEM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_udisks_filesystem_emit_changed (gpointer user_data)
{
  UDisksFilesystemSkeleton *skeleton = UDISKS_FILESYSTEM_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.UDisks2.Filesystem",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_udisks_filesystem_schedule_emit_changed (UDisksFilesystemSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
udisks_filesystem_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  UDisksFilesystemSkeleton *skeleton = UDISKS_FILESYSTEM_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _udisks_filesystem_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _udisks_filesystem_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
udisks_filesystem_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  UDisksFilesystemSkeleton *skeleton = UDISKS_FILESYSTEM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_filesystem_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _udisks_filesystem_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
udisks_filesystem_skeleton_init (UDisksFilesystemSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = udisks_filesystem_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, UDISKS_TYPE_FILESYSTEM_SKELETON, UDisksFilesystemSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT64);
}

static const gchar *const *
udisks_filesystem_skeleton_get_mount_points (UDisksFilesystem *object)
{
  UDisksFilesystemSkeleton *skeleton = UDISKS_FILESYSTEM_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
udisks_filesystem_skeleton_get_size (UDisksFilesystem *object)
{
  UDisksFilesystemSkeleton *skeleton = UDISKS_FILESYSTEM_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
udisks_filesystem_skeleton_class_init (UDisksFilesystemSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = udisks_filesystem_skeleton_finalize;
  gobject_class->get_property = udisks_filesystem_skeleton_get_property;
  gobject_class->set_property = udisks_filesystem_skeleton_set_property;
  gobject_class->notify       = udisks_filesystem_skeleton_notify;


  udisks_filesystem_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = udisks_filesystem_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = udisks_filesystem_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = udisks_filesystem_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = udisks_filesystem_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksFilesystemSkeletonPrivate));
#endif
}

static void
udisks_filesystem_skeleton_iface_init (UDisksFilesystemIface *iface)
{
  iface->get_mount_points = udisks_filesystem_skeleton_get_mount_points;
  iface->get_size = udisks_filesystem_skeleton_get_size;
}

/**
 * udisks_filesystem_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Filesystem.top_of_page">org.freedesktop.UDisks2.Filesystem</link>.
 *
 * Returns: (transfer full) (type UDisksFilesystemSkeleton): The skeleton object.
 */
UDisksFilesystem *
udisks_filesystem_skeleton_new (void)
{
  return UDISKS_FILESYSTEM (g_object_new (UDISKS_TYPE_FILESYSTEM_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.UDisks2.Swapspace
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:UDisksSwapspace
 * @title: UDisksSwapspace
 * @short_description: Generated C code for the org.freedesktop.UDisks2.Swapspace D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Swapspace.top_of_page">org.freedesktop.UDisks2.Swapspace</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.UDisks2.Swapspace ---- */

static const _ExtendedGDBusArgInfo _udisks_swapspace_method_info_start_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_swapspace_method_info_start_IN_ARG_pointers[] =
{
  &_udisks_swapspace_method_info_start_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_swapspace_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    (GDBusArgInfo **) &_udisks_swapspace_method_info_start_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_swapspace_method_info_stop_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_swapspace_method_info_stop_IN_ARG_pointers[] =
{
  &_udisks_swapspace_method_info_stop_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_swapspace_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    (GDBusArgInfo **) &_udisks_swapspace_method_info_stop_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_swapspace_method_info_set_label_IN_ARG_label =
{
  {
    -1,
    (gchar *) "label",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_swapspace_method_info_set_label_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_swapspace_method_info_set_label_IN_ARG_pointers[] =
{
  &_udisks_swapspace_method_info_set_label_IN_ARG_label.parent_struct,
  &_udisks_swapspace_method_info_set_label_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_swapspace_method_info_set_label =
{
  {
    -1,
    (gchar *) "SetLabel",
    (GDBusArgInfo **) &_udisks_swapspace_method_info_set_label_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-label",
  FALSE
};

static const GDBusMethodInfo * const _udisks_swapspace_method_info_pointers[] =
{
  &_udisks_swapspace_method_info_start.parent_struct,
  &_udisks_swapspace_method_info_stop.parent_struct,
  &_udisks_swapspace_method_info_set_label.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _udisks_swapspace_property_info_active =
{
  {
    -1,
    (gchar *) "Active",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _udisks_swapspace_property_info_pointers[] =
{
  &_udisks_swapspace_property_info_active.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _udisks_swapspace_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.UDisks2.Swapspace",
    (GDBusMethodInfo **) &_udisks_swapspace_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_udisks_swapspace_property_info_pointers,
    NULL
  },
  "swapspace",
};


/**
 * udisks_swapspace_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Swapspace.top_of_page">org.freedesktop.UDisks2.Swapspace</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
udisks_swapspace_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_udisks_swapspace_interface_info.parent_struct;
}

/**
 * udisks_swapspace_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #UDisksSwapspace interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
udisks_swapspace_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "active");
  return property_id_begin - 1;
}



/**
 * UDisksSwapspace:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Swapspace.top_of_page">org.freedesktop.UDisks2.Swapspace</link>.
 */

/**
 * UDisksSwapspaceIface:
 * @parent_iface: The parent interface.
 * @handle_set_label: Handler for the #UDisksSwapspace::handle-set-label signal.
 * @handle_start: Handler for the #UDisksSwapspace::handle-start signal.
 * @handle_stop: Handler for the #UDisksSwapspace::handle-stop signal.
 * @get_active: Getter for the #UDisksSwapspace:active property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Swapspace.top_of_page">org.freedesktop.UDisks2.Swapspace</link>.
 */

typedef UDisksSwapspaceIface UDisksSwapspaceInterface;
G_DEFINE_INTERFACE (UDisksSwapspace, udisks_swapspace, G_TYPE_OBJECT)

static void
udisks_swapspace_default_init (UDisksSwapspaceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * UDisksSwapspace::handle-start:
   * @object: A #UDisksSwapspace.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Swapspace.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_swapspace_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksSwapspaceIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksSwapspace::handle-stop:
   * @object: A #UDisksSwapspace.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Swapspace.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_swapspace_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksSwapspaceIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksSwapspace::handle-set-label:
   * @object: A #UDisksSwapspace.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_label: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Swapspace.SetLabel">SetLabel()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_swapspace_complete_set_label() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-label",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksSwapspaceIface, handle_set_label),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * UDisksSwapspace:active:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Swapspace.Active">"Active"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("active", "Active", "Active", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * udisks_swapspace_get_active: (skip)
 * @object: A #UDisksSwapspace.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Swapspace.Active">"Active"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
udisks_swapspace_get_active (UDisksSwapspace *object)
{
  return UDISKS_SWAPSPACE_GET_IFACE (object)->get_active (object);
}

/**
 * udisks_swapspace_set_active: (skip)
 * @object: A #UDisksSwapspace.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Swapspace.Active">"Active"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_swapspace_set_active (UDisksSwapspace *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "active", value, NULL);
}

/**
 * udisks_swapspace_call_start:
 * @proxy: A #UDisksSwapspaceProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Swapspace.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_swapspace_call_start_finish() to get the result of the operation.
 *
 * See udisks_swapspace_call_start_sync() for the synchronous, blocking version of this method.
 */
void
udisks_swapspace_call_start (
    UDisksSwapspace *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_swapspace_call_start_finish:
 * @proxy: A #UDisksSwapspaceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_swapspace_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_swapspace_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_swapspace_call_start_finish (
    UDisksSwapspace *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_swapspace_call_start_sync:
 * @proxy: A #UDisksSwapspaceProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Swapspace.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_swapspace_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_swapspace_call_start_sync (
    UDisksSwapspace *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_swapspace_call_stop:
 * @proxy: A #UDisksSwapspaceProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Swapspace.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_swapspace_call_stop_finish() to get the result of the operation.
 *
 * See udisks_swapspace_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
udisks_swapspace_call_stop (
    UDisksSwapspace *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_swapspace_call_stop_finish:
 * @proxy: A #UDisksSwapspaceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_swapspace_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_swapspace_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_swapspace_call_stop_finish (
    UDisksSwapspace *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_swapspace_call_stop_sync:
 * @proxy: A #UDisksSwapspaceProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Swapspace.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_swapspace_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_swapspace_call_stop_sync (
    UDisksSwapspace *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_swapspace_call_set_label:
 * @proxy: A #UDisksSwapspaceProxy.
 * @arg_label: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Swapspace.SetLabel">SetLabel()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_swapspace_call_set_label_finish() to get the result of the operation.
 *
 * See udisks_swapspace_call_set_label_sync() for the synchronous, blocking version of this method.
 */
void
udisks_swapspace_call_set_label (
    UDisksSwapspace *proxy,
    const gchar *arg_label,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetLabel",
    g_variant_new ("(s@a{sv})",
                   arg_label,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_swapspace_call_set_label_finish:
 * @proxy: A #UDisksSwapspaceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_swapspace_call_set_label().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_swapspace_call_set_label().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_swapspace_call_set_label_finish (
    UDisksSwapspace *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_swapspace_call_set_label_sync:
 * @proxy: A #UDisksSwapspaceProxy.
 * @arg_label: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Swapspace.SetLabel">SetLabel()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_swapspace_call_set_label() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_swapspace_call_set_label_sync (
    UDisksSwapspace *proxy,
    const gchar *arg_label,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetLabel",
    g_variant_new ("(s@a{sv})",
                   arg_label,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_swapspace_complete_start:
 * @object: A #UDisksSwapspace.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Swapspace.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_swapspace_complete_start (
    UDisksSwapspace *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_swapspace_complete_stop:
 * @object: A #UDisksSwapspace.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Swapspace.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_swapspace_complete_stop (
    UDisksSwapspace *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_swapspace_complete_set_label:
 * @object: A #UDisksSwapspace.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Swapspace.SetLabel">SetLabel()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_swapspace_complete_set_label (
    UDisksSwapspace *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * UDisksSwapspaceProxy:
 *
 * The #UDisksSwapspaceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksSwapspaceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksSwapspaceProxy.
 */

struct _UDisksSwapspaceProxyPrivate
{
  GData *qdata;
};

static void udisks_swapspace_proxy_iface_init (UDisksSwapspaceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksSwapspaceProxy, udisks_swapspace_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (UDisksSwapspaceProxy)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_SWAPSPACE, udisks_swapspace_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksSwapspaceProxy, udisks_swapspace_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_SWAPSPACE, udisks_swapspace_proxy_iface_init))

#endif
static void
udisks_swapspace_proxy_finalize (GObject *object)
{
  UDisksSwapspaceProxy *proxy = UDISKS_SWAPSPACE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (udisks_swapspace_proxy_parent_class)->finalize (object);
}

static void
udisks_swapspace_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_swapspace_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
udisks_swapspace_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.UDisks2.Swapspace: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
udisks_swapspace_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_swapspace_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.UDisks2.Swapspace", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) udisks_swapspace_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
udisks_swapspace_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_udisks_swapspace_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], UDISKS_TYPE_SWAPSPACE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_SWAPSPACE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
udisks_swapspace_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  UDisksSwapspaceProxy *proxy = UDISKS_SWAPSPACE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_swapspace_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_swapspace_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
udisks_swapspace_proxy_get_active (UDisksSwapspace *object)
{
  UDisksSwapspaceProxy *proxy = UDISKS_SWAPSPACE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Active");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
udisks_swapspace_proxy_init (UDisksSwapspaceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = udisks_swapspace_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, UDISKS_TYPE_SWAPSPACE_PROXY, UDisksSwapspaceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), udisks_swapspace_interface_info ());
}

static void
udisks_swapspace_proxy_class_init (UDisksSwapspaceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = udisks_swapspace_proxy_finalize;
  gobject_class->get_property = udisks_swapspace_proxy_get_property;
  gobject_class->set_property = udisks_swapspace_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = udisks_swapspace_proxy_g_signal;
  proxy_class->g_properties_changed = udisks_swapspace_proxy_g_properties_changed;

  udisks_swapspace_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksSwapspaceProxyPrivate));
#endif
}

static void
udisks_swapspace_proxy_iface_init (UDisksSwapspaceIface *iface)
{
  iface->get_active = udisks_swapspace_proxy_get_active;
}

/**
 * udisks_swapspace_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Swapspace.top_of_page">org.freedesktop.UDisks2.Swapspace</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_swapspace_proxy_new_finish() to get the result of the operation.
 *
 * See udisks_swapspace_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_swapspace_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_SWAPSPACE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Swapspace", NULL);
}

/**
 * udisks_swapspace_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_swapspace_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_swapspace_proxy_new().
 *
 * Returns: (transfer full) (type UDisksSwapspaceProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksSwapspace *
udisks_swapspace_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_SWAPSPACE (ret);
  else
    return NULL;
}

/**
 * udisks_swapspace_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Swapspace.top_of_page">org.freedesktop.UDisks2.Swapspace</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_swapspace_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksSwapspaceProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksSwapspace *
udisks_swapspace_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_SWAPSPACE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Swapspace", NULL);
  if (ret != NULL)
    return UDISKS_SWAPSPACE (ret);
  else
    return NULL;
}


/**
 * udisks_swapspace_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like udisks_swapspace_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_swapspace_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See udisks_swapspace_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
udisks_swapspace_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UDISKS_TYPE_SWAPSPACE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Swapspace", NULL);
}

/**
 * udisks_swapspace_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_swapspace_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with udisks_swapspace_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type UDisksSwapspaceProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksSwapspace *
udisks_swapspace_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UDISKS_SWAPSPACE (ret);
  else
    return NULL;
}

/**
 * udisks_swapspace_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like udisks_swapspace_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See udisks_swapspace_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UDisksSwapspaceProxy): The constructed proxy object or %NULL if @error is set.
 */
UDisksSwapspace *
udisks_swapspace_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UDISKS_TYPE_SWAPSPACE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UDisks2.Swapspace", NULL);
  if (ret != NULL)
    return UDISKS_SWAPSPACE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * UDisksSwapspaceSkeleton:
 *
 * The #UDisksSwapspaceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksSwapspaceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksSwapspaceSkeleton.
 */

struct _UDisksSwapspaceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_udisks_swapspace_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  UDisksSwapspaceSkeleton *skeleton = UDISKS_SWAPSPACE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], UDISKS_TYPE_SWAPSPACE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UDISKS_TYPE_SWAPSPACE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_udisks_swapspace_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  UDisksSwapspaceSkeleton *skeleton = UDISKS_SWAPSPACE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_swapspace_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_udisks_swapspace_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  UDisksSwapspaceSkeleton *skeleton = UDISKS_SWAPSPACE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_udisks_swapspace_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _udisks_swapspace_skeleton_vtable =
{
  _udisks_swapspace_skeleton_handle_method_call,
  _udisks_swapspace_skeleton_handle_get_property,
  _udisks_swapspace_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
udisks_swapspace_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return udisks_swapspace_interface_info ();
}

static GDBusInterfaceVTable *
udisks_swapspace_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_udisks_swapspace_skeleton_vtable;
}

static GVariant *
udisks_swapspace_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksSwapspaceSkeleton *skeleton = UDISKS_SWAPSPACE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_udisks_swapspace_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _udisks_swapspace_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _udisks_swapspace_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _udisks_swapspace_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.UDisks2.Swapspace", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _udisks_swapspace_emit_changed (gpointer user_data);

static void
udisks_swapspace_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  UDisksSwapspaceSkeleton *skeleton = UDISKS_SWAPSPACE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _udisks_swapspace_emit_changed (skeleton);
}

static void udisks_swapspace_skeleton_iface_init (UDisksSwapspaceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksSwapspaceSkeleton, udisks_swapspace_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (UDisksSwapspaceSkeleton)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_SWAPSPACE, udisks_swapspace_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksSwapspaceSkeleton, udisks_swapspace_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_SWAPSPACE, udisks_swapspace_skeleton_iface_init))

#endif
static void
udisks_swapspace_skeleton_finalize (GObject *object)
{
  UDisksSwapspaceSkeleton *skeleton = UDISKS_SWAPSPACE_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (udisks_swapspace_skeleton_parent_class)->finalize (object);
}

static void
udisks_swapspace_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  UDisksSwapspaceSkeleton *skeleton = UDISKS_SWAPSPACE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_udisks_swapspace_emit_changed (gpointer user_data)
{
  UDisksSwapspaceSkeleton *skeleton = UDISKS_SWAPSPACE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.UDisks2.Swapspace",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_udisks_swapspace_schedule_emit_changed (UDisksSwapspaceSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
udisks_swapspace_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  UDisksSwapspaceSkeleton *skeleton = UDISKS_SWAPSPACE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _udisks_swapspace_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _udisks_swapspace_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
udisks_swapspace_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  UDisksSwapspaceSkeleton *skeleton = UDISKS_SWAPSPACE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_swapspace_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _udisks_swapspace_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
udisks_swapspace_skeleton_init (UDisksSwapspaceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = udisks_swapspace_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, UDISKS_TYPE_SWAPSPACE_SKELETON, UDisksSwapspaceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
}

static gboolean 
udisks_swapspace_skeleton_get_active (UDisksSwapspace *object)
{
  UDisksSwapspaceSkeleton *skeleton = UDISKS_SWAPSPACE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
udisks_swapspace_skeleton_class_init (UDisksSwapspaceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = udisks_swapspace_skeleton_finalize;
  gobject_class->get_property = udisks_swapspace_skeleton_get_property;
  gobject_class->set_property = udisks_swapspace_skeleton_set_property;
  gobject_class->notify       = udisks_swapspace_skeleton_notify;


  udisks_swapspace_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = udisks_swapspace_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = udisks_swapspace_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = udisks_swapspace_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = udisks_swapspace_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UDisksSwapspaceSkeletonPrivate));
#endif
}

static void
udisks_swapspace_skeleton_iface_init (UDisksSwapspaceIface *iface)
{
  iface->get_active = udisks_swapspace_skeleton_get_active;
}

/**
 * udisks_swapspace_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Swapspace.top_of_page">org.freedesktop.UDisks2.Swapspace</link>.
 *
 * Returns: (transfer full) (type UDisksSwapspaceSkeleton): The skeleton object.
 */
UDisksSwapspace *
udisks_swapspace_skeleton_new (void)
{
  return UDISKS_SWAPSPACE (g_object_new (UDISKS_TYPE_SWAPSPACE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.UDisks2.Encrypted
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:UDisksEncrypted
 * @title: UDisksEncrypted
 * @short_description: Generated C code for the org.freedesktop.UDisks2.Encrypted D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Encrypted.top_of_page">org.freedesktop.UDisks2.Encrypted</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.UDisks2.Encrypted ---- */

static const _ExtendedGDBusArgInfo _udisks_encrypted_method_info_unlock_IN_ARG_passphrase =
{
  {
    -1,
    (gchar *) "passphrase",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_encrypted_method_info_unlock_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_encrypted_method_info_unlock_IN_ARG_pointers[] =
{
  &_udisks_encrypted_method_info_unlock_IN_ARG_passphrase.parent_struct,
  &_udisks_encrypted_method_info_unlock_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _udisks_encrypted_method_info_unlock_OUT_ARG_cleartext_device =
{
  {
    -1,
    (gchar *) "cleartext_device",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_encrypted_method_info_unlock_OUT_ARG_pointers[] =
{
  &_udisks_encrypted_method_info_unlock_OUT_ARG_cleartext_device.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_encrypted_method_info_unlock =
{
  {
    -1,
    (gchar *) "Unlock",
    (GDBusArgInfo **) &_udisks_encrypted_method_info_unlock_IN_ARG_pointers,
    (GDBusArgInfo **) &_udisks_encrypted_method_info_unlock_OUT_ARG_pointers,
    NULL
  },
  "handle-unlock",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_encrypted_method_info_lock_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_encrypted_method_info_lock_IN_ARG_pointers[] =
{
  &_udisks_encrypted_method_info_lock_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_encrypted_method_info_lock =
{
  {
    -1,
    (gchar *) "Lock",
    (GDBusArgInfo **) &_udisks_encrypted_method_info_lock_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-lock",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_encrypted_method_info_change_passphrase_IN_ARG_passphrase =
{
  {
    -1,
    (gchar *) "passphrase",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_encrypted_method_info_change_passphrase_IN_ARG_new_passphrase =
{
  {
    -1,
    (gchar *) "new_passphrase",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_encrypted_method_info_change_passphrase_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_encrypted_method_info_change_passphrase_IN_ARG_pointers[] =
{
  &_udisks_encrypted_method_info_change_passphrase_IN_ARG_passphrase.parent_struct,
  &_udisks_encrypted_method_info_change_passphrase_IN_ARG_new_passphrase.parent_struct,
  &_udisks_encrypted_method_info_change_passphrase_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_encrypted_method_info_change_passphrase =
{
  {
    -1,
    (gchar *) "ChangePassphrase",
    (GDBusArgInfo **) &_udisks_encrypted_method_info_change_passphrase_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-change-passphrase",
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_encrypted_method_info_resize_IN_ARG_size =
{
  {
    -1,
    (gchar *) "size",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _udisks_encrypted_method_info_resize_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _udisks_encrypted_method_info_resize_IN_ARG_pointers[] =
{
  &_udisks_encrypted_method_info_resize_IN_ARG_size.parent_struct,
  &_udisks_encrypted_method_info_resize_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _udisks_encrypted_method_info_resize =
{
  {
    -1,
    (gchar *) "Resize",
    (GDBusArgInfo **) &_udisks_encrypted_method_info_resize_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-resize",
  FALSE
};

static const GDBusMethodInfo * const _udisks_encrypted_method_info_pointers[] =
{
  &_udisks_encrypted_method_info_unlock.parent_struct,
  &_udisks_encrypted_method_info_lock.parent_struct,
  &_udisks_encrypted_method_info_change_passphrase.parent_struct,
  &_udisks_encrypted_method_info_resize.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _udisks_encrypted_property_info_child_configuration =
{
  {
    -1,
    (gchar *) "ChildConfiguration",
    (gchar *) "a(sa{sv})",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "child-configuration",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_encrypted_property_info_hint_encryption_type =
{
  {
    -1,
    (gchar *) "HintEncryptionType",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "hint-encryption-type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_encrypted_property_info_metadata_size =
{
  {
    -1,
    (gchar *) "MetadataSize",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "metadata-size",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _udisks_encrypted_property_info_cleartext_device =
{
  {
    -1,
    (gchar *) "CleartextDevice",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "cleartext-device",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _udisks_encrypted_property_info_pointers[] =
{
  &_udisks_encrypted_property_info_child_configuration.parent_struct,
  &_udisks_encrypted_property_info_hint_encryption_type.parent_struct,
  &_udisks_encrypted_property_info_metadata_size.parent_struct,
  &_udisks_encrypted_property_info_cleartext_device.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _udisks_encrypted_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.UDisks2.Encrypted",
    (GDBusMethodInfo **) &_udisks_encrypted_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_udisks_encrypted_property_info_pointers,
    NULL
  },
  "encrypted",
};


/**
 * udisks_encrypted_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-UDisks2-Encrypted.top_of_page">org.freedesktop.UDisks2.Encrypted</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
udisks_encrypted_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_udisks_encrypted_interface_info.parent_struct;
}

/**
 * udisks_encrypted_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #UDisksEncrypted interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
udisks_encrypted_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "child-configuration");
  g_object_class_override_property (klass, property_id_begin++, "hint-encryption-type");
  g_object_class_override_property (klass, property_id_begin++, "metadata-size");
  g_object_class_override_property (klass, property_id_begin++, "cleartext-device");
  return property_id_begin - 1;
}



/**
 * UDisksEncrypted:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Encrypted.top_of_page">org.freedesktop.UDisks2.Encrypted</link>.
 */

/**
 * UDisksEncryptedIface:
 * @parent_iface: The parent interface.
 * @handle_change_passphrase: Handler for the #UDisksEncrypted::handle-change-passphrase signal.
 * @handle_lock: Handler for the #UDisksEncrypted::handle-lock signal.
 * @handle_unlock: Handler for the #UDisksEncrypted::handle-unlock signal.
 * @get_child_configuration: Getter for the #UDisksEncrypted:child-configuration property.
 * @get_cleartext_device: Getter for the #UDisksEncrypted:cleartext-device property.
 * @get_hint_encryption_type: Getter for the #UDisksEncrypted:hint-encryption-type property.
 * @get_metadata_size: Getter for the #UDisksEncrypted:metadata-size property.
 * @handle_resize: Handler for the #UDisksEncrypted::handle-resize signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UDisks2-Encrypted.top_of_page">org.freedesktop.UDisks2.Encrypted</link>.
 */

typedef UDisksEncryptedIface UDisksEncryptedInterface;
G_DEFINE_INTERFACE (UDisksEncrypted, udisks_encrypted, G_TYPE_OBJECT)

static void
udisks_encrypted_default_init (UDisksEncryptedIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * UDisksEncrypted::handle-unlock:
   * @object: A #UDisksEncrypted.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_passphrase: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.Unlock">Unlock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_encrypted_complete_unlock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unlock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksEncryptedIface, handle_unlock),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * UDisksEncrypted::handle-lock:
   * @object: A #UDisksEncrypted.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.Lock">Lock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_encrypted_complete_lock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksEncryptedIface, handle_lock),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * UDisksEncrypted::handle-change-passphrase:
   * @object: A #UDisksEncrypted.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_passphrase: Argument passed by remote caller.
   * @arg_new_passphrase: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.ChangePassphrase">ChangePassphrase()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_encrypted_complete_change_passphrase() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-change-passphrase",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksEncryptedIface, handle_change_passphrase),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * UDisksEncrypted::handle-resize:
   * @object: A #UDisksEncrypted.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_size: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.Resize">Resize()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call udisks_encrypted_complete_resize() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 2.8.0
   */
  g_signal_new ("handle-resize",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UDisksEncryptedIface, handle_resize),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * UDisksEncrypted:child-configuration:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.ChildConfiguration">"ChildConfiguration"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("child-configuration", "ChildConfiguration", "ChildConfiguration", G_VARIANT_TYPE ("a(sa{sv})"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksEncrypted:hint-encryption-type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.HintEncryptionType">"HintEncryptionType"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("hint-encryption-type", "HintEncryptionType", "HintEncryptionType", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksEncrypted:metadata-size:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.MetadataSize">"MetadataSize"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("metadata-size", "MetadataSize", "MetadataSize", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UDisksEncrypted:cleartext-device:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.CleartextDevice">"CleartextDevice"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("cleartext-device", "CleartextDevice", "CleartextDevice", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * udisks_encrypted_get_child_configuration: (skip)
 * @object: A #UDisksEncrypted.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.ChildConfiguration">"ChildConfiguration"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_encrypted_dup_child_configuration() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
udisks_encrypted_get_child_configuration (UDisksEncrypted *object)
{
  return UDISKS_ENCRYPTED_GET_IFACE (object)->get_child_configuration (object);
}

/**
 * udisks_encrypted_dup_child_configuration: (skip)
 * @object: A #UDisksEncrypted.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.ChildConfiguration">"ChildConfiguration"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
udisks_encrypted_dup_child_configuration (UDisksEncrypted *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "child-configuration", &value, NULL);
  return value;
}

/**
 * udisks_encrypted_set_child_configuration: (skip)
 * @object: A #UDisksEncrypted.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.ChildConfiguration">"ChildConfiguration"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_encrypted_set_child_configuration (UDisksEncrypted *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "child-configuration", value, NULL);
}

/**
 * udisks_encrypted_get_hint_encryption_type: (skip)
 * @object: A #UDisksEncrypted.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.HintEncryptionType">"HintEncryptionType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_encrypted_dup_hint_encryption_type() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_encrypted_get_hint_encryption_type (UDisksEncrypted *object)
{
  return UDISKS_ENCRYPTED_GET_IFACE (object)->get_hint_encryption_type (object);
}

/**
 * udisks_encrypted_dup_hint_encryption_type: (skip)
 * @object: A #UDisksEncrypted.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.HintEncryptionType">"HintEncryptionType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_encrypted_dup_hint_encryption_type (UDisksEncrypted *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "hint-encryption-type", &value, NULL);
  return value;
}

/**
 * udisks_encrypted_set_hint_encryption_type: (skip)
 * @object: A #UDisksEncrypted.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.HintEncryptionType">"HintEncryptionType"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_encrypted_set_hint_encryption_type (UDisksEncrypted *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "hint-encryption-type", value, NULL);
}

/**
 * udisks_encrypted_get_metadata_size: (skip)
 * @object: A #UDisksEncrypted.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.MetadataSize">"MetadataSize"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
udisks_encrypted_get_metadata_size (UDisksEncrypted *object)
{
  return UDISKS_ENCRYPTED_GET_IFACE (object)->get_metadata_size (object);
}

/**
 * udisks_encrypted_set_metadata_size: (skip)
 * @object: A #UDisksEncrypted.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.MetadataSize">"MetadataSize"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_encrypted_set_metadata_size (UDisksEncrypted *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "metadata-size", value, NULL);
}

/**
 * udisks_encrypted_get_cleartext_device: (skip)
 * @object: A #UDisksEncrypted.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.CleartextDevice">"CleartextDevice"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use udisks_encrypted_dup_cleartext_device() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
udisks_encrypted_get_cleartext_device (UDisksEncrypted *object)
{
  return UDISKS_ENCRYPTED_GET_IFACE (object)->get_cleartext_device (object);
}

/**
 * udisks_encrypted_dup_cleartext_device: (skip)
 * @object: A #UDisksEncrypted.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.CleartextDevice">"CleartextDevice"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
udisks_encrypted_dup_cleartext_device (UDisksEncrypted *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "cleartext-device", &value, NULL);
  return value;
}

/**
 * udisks_encrypted_set_cleartext_device: (skip)
 * @object: A #UDisksEncrypted.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UDisks2-Encrypted.CleartextDevice">"CleartextDevice"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
udisks_encrypted_set_cleartext_device (UDisksEncrypted *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "cleartext-device", value, NULL);
}

/**
 * udisks_encrypted_call_unlock:
 * @proxy: A #UDisksEncryptedProxy.
 * @arg_passphrase: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.Unlock">Unlock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_encrypted_call_unlock_finish() to get the result of the operation.
 *
 * See udisks_encrypted_call_unlock_sync() for the synchronous, blocking version of this method.
 */
void
udisks_encrypted_call_unlock (
    UDisksEncrypted *proxy,
    const gchar *arg_passphrase,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Unlock",
    g_variant_new ("(s@a{sv})",
                   arg_passphrase,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_encrypted_call_unlock_finish:
 * @proxy: A #UDisksEncryptedProxy.
 * @out_cleartext_device: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_encrypted_call_unlock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_encrypted_call_unlock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_encrypted_call_unlock_finish (
    UDisksEncrypted *proxy,
    gchar **out_cleartext_device,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_cleartext_device);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_encrypted_call_unlock_sync:
 * @proxy: A #UDisksEncryptedProxy.
 * @arg_passphrase: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_cleartext_device: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.Unlock">Unlock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_encrypted_call_unlock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_encrypted_call_unlock_sync (
    UDisksEncrypted *proxy,
    const gchar *arg_passphrase,
    GVariant *arg_options,
    gchar **out_cleartext_device,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Unlock",
    g_variant_new ("(s@a{sv})",
                   arg_passphrase,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_cleartext_device);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_encrypted_call_lock:
 * @proxy: A #UDisksEncryptedProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.Lock">Lock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_encrypted_call_lock_finish() to get the result of the operation.
 *
 * See udisks_encrypted_call_lock_sync() for the synchronous, blocking version of this method.
 */
void
udisks_encrypted_call_lock (
    UDisksEncrypted *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_encrypted_call_lock_finish:
 * @proxy: A #UDisksEncryptedProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_encrypted_call_lock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_encrypted_call_lock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_encrypted_call_lock_finish (
    UDisksEncrypted *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_encrypted_call_lock_sync:
 * @proxy: A #UDisksEncryptedProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.Lock">Lock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_encrypted_call_lock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_encrypted_call_lock_sync (
    UDisksEncrypted *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_encrypted_call_change_passphrase:
 * @proxy: A #UDisksEncryptedProxy.
 * @arg_passphrase: Argument to pass with the method invocation.
 * @arg_new_passphrase: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.ChangePassphrase">ChangePassphrase()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_encrypted_call_change_passphrase_finish() to get the result of the operation.
 *
 * See udisks_encrypted_call_change_passphrase_sync() for the synchronous, blocking version of this method.
 */
void
udisks_encrypted_call_change_passphrase (
    UDisksEncrypted *proxy,
    const gchar *arg_passphrase,
    const gchar *arg_new_passphrase,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ChangePassphrase",
    g_variant_new ("(ss@a{sv})",
                   arg_passphrase,
                   arg_new_passphrase,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_encrypted_call_change_passphrase_finish:
 * @proxy: A #UDisksEncryptedProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_encrypted_call_change_passphrase().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_encrypted_call_change_passphrase().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_encrypted_call_change_passphrase_finish (
    UDisksEncrypted *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_encrypted_call_change_passphrase_sync:
 * @proxy: A #UDisksEncryptedProxy.
 * @arg_passphrase: Argument to pass with the method invocation.
 * @arg_new_passphrase: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.ChangePassphrase">ChangePassphrase()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_encrypted_call_change_passphrase() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
udisks_encrypted_call_change_passphrase_sync (
    UDisksEncrypted *proxy,
    const gchar *arg_passphrase,
    const gchar *arg_new_passphrase,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ChangePassphrase",
    g_variant_new ("(ss@a{sv})",
                   arg_passphrase,
                   arg_new_passphrase,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_encrypted_call_resize:
 * @proxy: A #UDisksEncryptedProxy.
 * @arg_size: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.Resize">Resize()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call udisks_encrypted_call_resize_finish() to get the result of the operation.
 *
 * See udisks_encrypted_call_resize_sync() for the synchronous, blocking version of this method.
 *
 * Since: 2.8.0
 */
void
udisks_encrypted_call_resize (
    UDisksEncrypted *proxy,
    guint64 arg_size,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Resize",
    g_variant_new ("(t@a{sv})",
                   arg_size,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * udisks_encrypted_call_resize_finish:
 * @proxy: A #UDisksEncryptedProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to udisks_encrypted_call_resize().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with udisks_encrypted_call_resize().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.8.0
 */
gboolean
udisks_encrypted_call_resize_finish (
    UDisksEncrypted *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_encrypted_call_resize_sync:
 * @proxy: A #UDisksEncryptedProxy.
 * @arg_size: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.Resize">Resize()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See udisks_encrypted_call_resize() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 2.8.0
 */
gboolean
udisks_encrypted_call_resize_sync (
    UDisksEncrypted *proxy,
    guint64 arg_size,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Resize",
    g_variant_new ("(t@a{sv})",
                   arg_size,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * udisks_encrypted_complete_unlock:
 * @object: A #UDisksEncrypted.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @cleartext_device: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.Unlock">Unlock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_encrypted_complete_unlock (
    UDisksEncrypted *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *cleartext_device)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   cleartext_device));
}

/**
 * udisks_encrypted_complete_lock:
 * @object: A #UDisksEncrypted.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.Lock">Lock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_encrypted_complete_lock (
    UDisksEncrypted *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_encrypted_complete_change_passphrase:
 * @object: A #UDisksEncrypted.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.ChangePassphrase">ChangePassphrase()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
udisks_encrypted_complete_change_passphrase (
    UDisksEncrypted *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * udisks_encrypted_complete_resize:
 * @object: A #UDisksEncrypted.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UDisks2-Encrypted.Resize">Resize()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.8.0
 */
void
udisks_encrypted_complete_resize (
    UDisksEncrypted *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * UDisksEncryptedProxy:
 *
 * The #UDisksEncryptedProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UDisksEncryptedProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UDisksEncryptedProxy.
 */

struct _UDisksEncryptedProxyPrivate
{
  GData *qdata;
};

static void udisks_encrypted_proxy_iface_init (UDisksEncryptedIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UDisksEncryptedProxy, udisks_encrypted_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (UDisksEncryptedProxy)
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_ENCRYPTED, udisks_encrypted_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UDisksEncryptedProxy, udisks_encrypted_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (UDISKS_TYPE_ENCRYPTED, udisks_encrypted_proxy_iface_init))

#endif
static void
udisks_encrypted_proxy_finalize (GObject *object)
{
  UDisksEncryptedProxy *proxy = UDISKS_ENCRYPTED_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (udisks_encrypted_proxy_parent_class)->finalize (object);
}

static void
udisks_encrypted_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _udisks_encrypted_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_stru