// Copyright (c) 2020, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'package:analyzer/src/error/codes.dart';
import 'package:test_reflective_loader/test_reflective_loader.dart';

import '../dart/resolution/context_collection_resolution.dart';

main() {
  defineReflectiveSuite(() {
    defineReflectiveTests(ImportInternalLibraryTest);
  });
}

@reflectiveTest
class ImportInternalLibraryTest extends PubPackageResolutionTest {
  test_internal() async {
    // Note, in these error cases we may generate an UNUSED_IMPORT hint, while
    // we could prevent the hint from being generated by testing the import
    // directive for the error, this is such a minor corner case that we don't
    // think we should add the additional computation time to figure out such
    // cases.
    await assertErrorsInCode('''
import 'dart:_internal';
''', [
      error(CompileTimeErrorCode.IMPORT_INTERNAL_LIBRARY, 7, 16),
      error(WarningCode.UNUSED_IMPORT, 7, 16),
    ]);
  }
}
