All core jsoncons classes and functions are in namespace `jsoncons`.  

#### Variant-like Data Structure

[basic_json](ref/basic_json.md)  

#### Serialize and Deserialize Support

[json_type_traits](ref/json_type_traits.md)  
[encode_json](ref/encode_json.md)  
[decode_json](ref/decode_json.md)  
[basic_json_options](ref/basic_json_options.md)    

#### Streaming API for JSON (StAJ)

[staj_cursor](ref/staj_cursor.md)  
[staj_event](ref/staj_event.md)  
[staj_object_iterator](ref/staj_object_iterator.md)  
[staj_array_iterator](ref/staj_array_iterator.md)  

[basic_json_cursor](ref/basic_json_cursor.md)  
[basic_json_encoder](ref/basic_json_encoder.md)  

#### Push Parsing API

[basic_json_visitor](ref/basic_json_visitor.md)  

[json_parser](ref/json_parser.md)  
[basic_json_reader](ref/basic_json_reader.md)  

[json_decoder](ref/json_decoder.md)  

[basic_json_filter](ref/basic_json_filter.md)  
[rename_object_key_filter](ref/rename_object_key_filter.md)  

### Extensions

#### [jsonpointer](ref/jsonpointer/jsonpointer.md)

#### [jsonpatch](ref/jsonpatch/jsonpatch.md)

#### [jsonpath](ref/jsonpath/jsonpath.md)

#### [bson](ref/bson/bson.md)

#### [cbor](ref/cbor/cbor.md)

#### [msgpack](ref/msgpack/msgpack.md)

#### [ubjson](ref/ubjson/ubjson.md)

### Tutorials

[Basics](Tutorials/Basics.md)

[Custom Allocators](Tutorials/Custom%20Allocators.md)

[Unicode support](Tutorials/Unicode%20support.md)

