/* Generated by wayland-scanner 1.20.0 */

#ifndef AGL_SHELL_DESKTOP_SERVER_PROTOCOL_H
#define AGL_SHELL_DESKTOP_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_agl_shell_desktop The agl_shell_desktop protocol
 * @section page_ifaces_agl_shell_desktop Interfaces
 * - @subpage page_iface_agl_shell_desktop - Private extension to allow applications activate other apps
 * @section page_copyright_agl_shell_desktop Copyright
 * <pre>
 *
 * Copyright © 2020 Collabora, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct agl_shell_desktop;
struct wl_output;

#ifndef AGL_SHELL_DESKTOP_INTERFACE
#define AGL_SHELL_DESKTOP_INTERFACE
/**
 * @page page_iface_agl_shell_desktop agl_shell_desktop
 * @section page_iface_agl_shell_desktop_desc Description
 *
 * This extension can be used by regular application to instruct to compositor
 * to activate or switch to other running (regular) applications. The client
 * is responsible for filtering their own app_id when receiving application id.
 *
 * The compositor will allow clients to bind to this interface only if the
 * policy engine allows it.
 * @section page_iface_agl_shell_desktop_api API
 * See @ref iface_agl_shell_desktop.
 */
/**
 * @defgroup iface_agl_shell_desktop The agl_shell_desktop interface
 *
 * This extension can be used by regular application to instruct to compositor
 * to activate or switch to other running (regular) applications. The client
 * is responsible for filtering their own app_id when receiving application id.
 *
 * The compositor will allow clients to bind to this interface only if the
 * policy engine allows it.
 */
extern const struct wl_interface agl_shell_desktop_interface;
#endif

#ifndef AGL_SHELL_DESKTOP_APP_ROLE_ENUM
#define AGL_SHELL_DESKTOP_APP_ROLE_ENUM
enum agl_shell_desktop_app_role {
	AGL_SHELL_DESKTOP_APP_ROLE_POPUP = 0,
	AGL_SHELL_DESKTOP_APP_ROLE_FULLSCREEN = 1,
	AGL_SHELL_DESKTOP_APP_ROLE_SPLIT_VERTICAL = 2,
	AGL_SHELL_DESKTOP_APP_ROLE_SPLIT_HORIZONTAL = 3,
	AGL_SHELL_DESKTOP_APP_ROLE_REMOTE = 4,
};
#endif /* AGL_SHELL_DESKTOP_APP_ROLE_ENUM */

#ifndef AGL_SHELL_DESKTOP_APP_STATE_ENUM
#define AGL_SHELL_DESKTOP_APP_STATE_ENUM
enum agl_shell_desktop_app_state {
	AGL_SHELL_DESKTOP_APP_STATE_ACTIVATED = 0,
	AGL_SHELL_DESKTOP_APP_STATE_DEACTIVATED = 1,
	AGL_SHELL_DESKTOP_APP_STATE_DESTROYED = 2,
};
#endif /* AGL_SHELL_DESKTOP_APP_STATE_ENUM */

/**
 * @ingroup iface_agl_shell_desktop
 * @struct agl_shell_desktop_interface
 */
struct agl_shell_desktop_interface {
	/**
	 * make client current window
	 *
	 * Ask the compositor to make a toplevel to become the
	 * current/focused window for window management purposes.
	 *
	 * See xdg_toplevel.set_app_id from the xdg-shell protocol for a
	 * description of app_id.
	 */
	void (*activate_app)(struct wl_client *client,
			     struct wl_resource *resource,
			     const char *app_id,
			     const char *app_data,
			     struct wl_resource *output);
	/**
	 * set properties for a client identified by app_id
	 *
	 * Ask the compositor to make a top-level window obey the
	 * 'app_role' enum and, depending on that role, to use some of the
	 * arguments as initial values to take into account.
	 *
	 * Note that x, y, bx, by, width and height would only make sense
	 * for the pop-up role, with the output argument being applicable
	 * to all the roles. The width and height values define the maximum
	 * area which the top-level window should be placed into. Note this
	 * doesn't correspond to top-level surface size, but to a bounding
	 * box which will be used to clip the surface to, in case the
	 * surface area extends that of this bounding box. Both of these
	 * values need to be larger than 0 (zero) to be taken into account
	 * by the compositor. Any negative values for the width and height
	 * will be discarded.
	 *
	 * The x and y values will serve as the (initial) position values.
	 * The bx and by values are the top-left x and y value of the
	 * bounding box. Any clipping happening to the bounding box will
	 * not affect the surface size or the position of the underlying
	 * surface backing the top-level window. The bx and by values, like
	 * the positional values, could be both set to zero, or even
	 * negative values. The compositor will pass those on without any
	 * further validation.
	 *
	 * The initial position values and the bounding rectangle will
	 * still be in effect on a subsequent activation request of the
	 * 'app_id', assuming it was previously de-activated at some point
	 * in time.
	 *
	 * See xdg_toplevel.set_app_id from the xdg-shell protocol for a
	 * description of app_id.
	 */
	void (*set_app_property)(struct wl_client *client,
				 struct wl_resource *resource,
				 const char *app_id,
				 uint32_t role,
				 int32_t x,
				 int32_t y,
				 int32_t bx,
				 int32_t by,
				 int32_t width,
				 int32_t height,
				 struct wl_resource *output);
	/**
	 * de-activate/hide window identified by app_id
	 *
	 * Ask the compositor to hide the toplevel window for window
	 * management purposes. Depending on the window role, this request
	 * will either display the previously active window (or the
	 * background in case there's no previously active surface) or
	 * temporarily (or until a 'activate_app' is called upon) hide the
	 * surface. All the surfaces are identifiable by using the app_id,
	 * and no actions are taken in case the app_id is not/was not
	 * present.
	 *
	 * See xdg_toplevel.set_app_id from the xdg-shell protocol for a
	 * description of app_id.
	 */
	void (*deactivate_app)(struct wl_client *client,
			       struct wl_resource *resource,
			       const char *app_id);
	/**
	 * Request to change the application properties lifetime
	 *
	 * Use this request to inform the compositor to maintain a
	 * pending state for an app_id being set with set_app_property()
	 * request. Any subsequent application matching that app_id would
	 * survive a potential application destruction. Note that this
	 * request will take effect globally on all applications.
	 *
	 * To turn it on, or off, use the 'permanent' argument. Initially,
	 * the compositor will have this option set to off. Note that it
	 * doesn't matter the order of this request with respect to
	 * set_app_property() request, as the changes will only take effect
	 * when the application itself does the commit with an app_id set,
	 * therefore the only requirement is to call this request before
	 * the app_id client does its first commit.
	 * @since 2
	 */
	void (*set_app_property_mode)(struct wl_client *client,
				      struct wl_resource *resource,
				      uint32_t permanent);
};

#define AGL_SHELL_DESKTOP_APPLICATION 0
#define AGL_SHELL_DESKTOP_STATE_APP 1

/**
 * @ingroup iface_agl_shell_desktop
 */
#define AGL_SHELL_DESKTOP_APPLICATION_SINCE_VERSION 1
/**
 * @ingroup iface_agl_shell_desktop
 */
#define AGL_SHELL_DESKTOP_STATE_APP_SINCE_VERSION 1

/**
 * @ingroup iface_agl_shell_desktop
 */
#define AGL_SHELL_DESKTOP_ACTIVATE_APP_SINCE_VERSION 1
/**
 * @ingroup iface_agl_shell_desktop
 */
#define AGL_SHELL_DESKTOP_SET_APP_PROPERTY_SINCE_VERSION 1
/**
 * @ingroup iface_agl_shell_desktop
 */
#define AGL_SHELL_DESKTOP_DEACTIVATE_APP_SINCE_VERSION 1
/**
 * @ingroup iface_agl_shell_desktop
 */
#define AGL_SHELL_DESKTOP_SET_APP_PROPERTY_MODE_SINCE_VERSION 2

/**
 * @ingroup iface_agl_shell_desktop
 * Sends an application event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
agl_shell_desktop_send_application(struct wl_resource *resource_, const char *app_id)
{
	wl_resource_post_event(resource_, AGL_SHELL_DESKTOP_APPLICATION, app_id);
}

/**
 * @ingroup iface_agl_shell_desktop
 * Sends an state_app event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
agl_shell_desktop_send_state_app(struct wl_resource *resource_, const char *app_id, const char *app_data, uint32_t state, uint32_t role)
{
	wl_resource_post_event(resource_, AGL_SHELL_DESKTOP_STATE_APP, app_id, app_data, state, role);
}

#ifdef  __cplusplus
}
#endif

#endif
