/* Generated by wayland-scanner 1.20.0 */

#ifndef IVI_WM_CLIENT_PROTOCOL_H
#define IVI_WM_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_ivi_wm The ivi_wm protocol
 * @section page_ifaces_ivi_wm Interfaces
 * - @subpage page_iface_ivi_wm_screen - controller interface to screen in ivi compositor
 * - @subpage page_iface_ivi_screenshot - screenshot of an output or a surface
 * - @subpage page_iface_ivi_wm - interface for ivi managers to use ivi compositor features
 * @section page_copyright_ivi_wm Copyright
 * <pre>
 *
 * Copyright (C) 2017 Advanced Driver Information Technology Joint Venture GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * </pre>
 */
struct ivi_screenshot;
struct ivi_wm;
struct ivi_wm_screen;
struct wl_output;

#ifndef IVI_WM_SCREEN_INTERFACE
#define IVI_WM_SCREEN_INTERFACE
/**
 * @page page_iface_ivi_wm_screen ivi_wm_screen
 * @section page_iface_ivi_wm_screen_desc Description
 * @section page_iface_ivi_wm_screen_api API
 * See @ref iface_ivi_wm_screen.
 */
/**
 * @defgroup iface_ivi_wm_screen The ivi_wm_screen interface
 */
extern const struct wl_interface ivi_wm_screen_interface;
#endif
#ifndef IVI_SCREENSHOT_INTERFACE
#define IVI_SCREENSHOT_INTERFACE
/**
 * @page page_iface_ivi_screenshot ivi_screenshot
 * @section page_iface_ivi_screenshot_desc Description
 *
 * An ivi_screenshot object receives a single "done" or "error" event.
 * The server will destroy this resource after the event has been send,
 * so the client shall then destroy its proxy too.
 * @section page_iface_ivi_screenshot_api API
 * See @ref iface_ivi_screenshot.
 */
/**
 * @defgroup iface_ivi_screenshot The ivi_screenshot interface
 *
 * An ivi_screenshot object receives a single "done" or "error" event.
 * The server will destroy this resource after the event has been send,
 * so the client shall then destroy its proxy too.
 */
extern const struct wl_interface ivi_screenshot_interface;
#endif
#ifndef IVI_WM_INTERFACE
#define IVI_WM_INTERFACE
/**
 * @page page_iface_ivi_wm ivi_wm
 * @section page_iface_ivi_wm_desc Description
 * @section page_iface_ivi_wm_api API
 * See @ref iface_ivi_wm.
 */
/**
 * @defgroup iface_ivi_wm The ivi_wm interface
 */
extern const struct wl_interface ivi_wm_interface;
#endif

#ifndef IVI_WM_SCREEN_ERROR_ENUM
#define IVI_WM_SCREEN_ERROR_ENUM
enum ivi_wm_screen_error {
	/**
	 * the layer with given id does not exist
	 */
	IVI_WM_SCREEN_ERROR_NO_LAYER = 0,
	/**
	 * the output is already destroyed
	 */
	IVI_WM_SCREEN_ERROR_NO_SCREEN = 1,
	/**
	 * the given parameter is not valid
	 */
	IVI_WM_SCREEN_ERROR_BAD_PARAM = 2,
};
#endif /* IVI_WM_SCREEN_ERROR_ENUM */

/**
 * @ingroup iface_ivi_wm_screen
 * @struct ivi_wm_screen_listener
 */
struct ivi_wm_screen_listener {
	/**
	 * advertise server side id of the ivi-screen
	 *
	 * Sent immediately after creating the ivi_wm_screen object.
	 */
	void (*screen_id)(void *data,
			  struct ivi_wm_screen *ivi_wm_screen,
			  uint32_t id);
	/**
	 * update render order of the screen
	 *
	 * A layer is added to the render order lisf of the screen
	 */
	void (*layer_added)(void *data,
			    struct ivi_wm_screen *ivi_wm_screen,
			    uint32_t layer_id);
	/**
	 * advertise connector name of the corresponding output
	 *
	 * Sent immediately after creating the ivi_wm_screen object.
	 */
	void (*connector_name)(void *data,
			       struct ivi_wm_screen *ivi_wm_screen,
			       const char *process_name);
	/**
	 * error event
	 *
	 * The error event is sent out when an error has occurred.
	 * @param error error code
	 * @param message error description
	 */
	void (*error)(void *data,
		      struct ivi_wm_screen *ivi_wm_screen,
		      uint32_t error,
		      const char *message);
};

/**
 * @ingroup iface_ivi_wm_screen
 */
static inline int
ivi_wm_screen_add_listener(struct ivi_wm_screen *ivi_wm_screen,
			   const struct ivi_wm_screen_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ivi_wm_screen,
				     (void (**)(void)) listener, data);
}

#define IVI_WM_SCREEN_DESTROY 0
#define IVI_WM_SCREEN_CLEAR 1
#define IVI_WM_SCREEN_ADD_LAYER 2
#define IVI_WM_SCREEN_REMOVE_LAYER 3
#define IVI_WM_SCREEN_SCREENSHOT 4
#define IVI_WM_SCREEN_GET 5

/**
 * @ingroup iface_ivi_wm_screen
 */
#define IVI_WM_SCREEN_SCREEN_ID_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm_screen
 */
#define IVI_WM_SCREEN_LAYER_ADDED_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm_screen
 */
#define IVI_WM_SCREEN_CONNECTOR_NAME_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm_screen
 */
#define IVI_WM_SCREEN_ERROR_SINCE_VERSION 1

/**
 * @ingroup iface_ivi_wm_screen
 */
#define IVI_WM_SCREEN_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm_screen
 */
#define IVI_WM_SCREEN_CLEAR_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm_screen
 */
#define IVI_WM_SCREEN_ADD_LAYER_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm_screen
 */
#define IVI_WM_SCREEN_REMOVE_LAYER_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm_screen
 */
#define IVI_WM_SCREEN_SCREENSHOT_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm_screen
 */
#define IVI_WM_SCREEN_GET_SINCE_VERSION 1

/** @ingroup iface_ivi_wm_screen */
static inline void
ivi_wm_screen_set_user_data(struct ivi_wm_screen *ivi_wm_screen, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ivi_wm_screen, user_data);
}

/** @ingroup iface_ivi_wm_screen */
static inline void *
ivi_wm_screen_get_user_data(struct ivi_wm_screen *ivi_wm_screen)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ivi_wm_screen);
}

static inline uint32_t
ivi_wm_screen_get_version(struct ivi_wm_screen *ivi_wm_screen)
{
	return wl_proxy_get_version((struct wl_proxy *) ivi_wm_screen);
}

/**
 * @ingroup iface_ivi_wm_screen
 *
 * Request to destroy the ivi_wm_screen.
 */
static inline void
ivi_wm_screen_destroy(struct ivi_wm_screen *ivi_wm_screen)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm_screen,
			 IVI_WM_SCREEN_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm_screen), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ivi_wm_screen
 *
 * A screen has no content assigned to itself, it is a container for layers.
 * This request removes all layers from the screen render order.
 * Note: the layers are not destroyed, they are just no longer contained by
 * the screen.
 */
static inline void
ivi_wm_screen_clear(struct ivi_wm_screen *ivi_wm_screen)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm_screen,
			 IVI_WM_SCREEN_CLEAR, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm_screen), 0);
}

/**
 * @ingroup iface_ivi_wm_screen
 *
 * A screen has no content assigned to itself, it is a container for layers.
 * This request adds a layers to the topmost position of the screen render order.
 * The added layer will cover all other layers of the screen.
 */
static inline void
ivi_wm_screen_add_layer(struct ivi_wm_screen *ivi_wm_screen, uint32_t layer_id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm_screen,
			 IVI_WM_SCREEN_ADD_LAYER, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm_screen), 0, layer_id);
}

/**
 * @ingroup iface_ivi_wm_screen
 *
 * A screen has no content assigned to itself, it is a container for layers.
 * This request removes a layer.
 */
static inline void
ivi_wm_screen_remove_layer(struct ivi_wm_screen *ivi_wm_screen, uint32_t layer_id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm_screen,
			 IVI_WM_SCREEN_REMOVE_LAYER, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm_screen), 0, layer_id);
}

/**
 * @ingroup iface_ivi_wm_screen
 *
 * An ivi_screenshot object is created which will receive the screenshot
 * data of the specified output.
 */
static inline struct ivi_screenshot *
ivi_wm_screen_screenshot(struct ivi_wm_screen *ivi_wm_screen)
{
	struct wl_proxy *screenshot;

	screenshot = wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm_screen,
			 IVI_WM_SCREEN_SCREENSHOT, &ivi_screenshot_interface, wl_proxy_get_version((struct wl_proxy *) ivi_wm_screen), 0, NULL);

	return (struct ivi_screenshot *) screenshot;
}

/**
 * @ingroup iface_ivi_wm_screen
 *
 * After this request, compositor sends the requested parameter.
 */
static inline void
ivi_wm_screen_get(struct ivi_wm_screen *ivi_wm_screen, int32_t param)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm_screen,
			 IVI_WM_SCREEN_GET, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm_screen), 0, param);
}

#ifndef IVI_SCREENSHOT_ERROR_ENUM
#define IVI_SCREENSHOT_ERROR_ENUM
enum ivi_screenshot_error {
	/**
	 * screenshot file could not be created
	 */
	IVI_SCREENSHOT_ERROR_IO_ERROR = 0,
	/**
	 * screenshot can not be read
	 */
	IVI_SCREENSHOT_ERROR_NOT_SUPPORTED = 1,
	/**
	 * output has been destroyed
	 */
	IVI_SCREENSHOT_ERROR_NO_OUTPUT = 2,
	/**
	 * surface has been destroyed
	 */
	IVI_SCREENSHOT_ERROR_NO_SURFACE = 3,
	/**
	 * surface has no content
	 */
	IVI_SCREENSHOT_ERROR_NO_CONTENT = 4,
};
#endif /* IVI_SCREENSHOT_ERROR_ENUM */

/**
 * @ingroup iface_ivi_screenshot
 * @struct ivi_screenshot_listener
 */
struct ivi_screenshot_listener {
	/**
	 * screenshot finished
	 *
	 * This event contains a filedescriptor for a file with raw image
	 * data. Furthermore size, stride, format and timestamp of
	 * screenshot are provided.
	 * @param fd fd for file containing image data
	 * @param width image width in pixels
	 * @param height image height in pixels
	 * @param stride number of bytes per pixel row
	 * @param format image format of type wl_shm.format
	 * @param timestamp timestamp in milliseconds
	 */
	void (*done)(void *data,
		     struct ivi_screenshot *ivi_screenshot,
		     int32_t fd,
		     int32_t width,
		     int32_t height,
		     int32_t stride,
		     uint32_t format,
		     uint32_t timestamp);
	/**
	 * error event
	 *
	 * The error event is sent when the screenshot could not be
	 * created.
	 * @param error error code
	 * @param message error description
	 */
	void (*error)(void *data,
		      struct ivi_screenshot *ivi_screenshot,
		      uint32_t error,
		      const char *message);
};

/**
 * @ingroup iface_ivi_screenshot
 */
static inline int
ivi_screenshot_add_listener(struct ivi_screenshot *ivi_screenshot,
			    const struct ivi_screenshot_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ivi_screenshot,
				     (void (**)(void)) listener, data);
}

/**
 * @ingroup iface_ivi_screenshot
 */
#define IVI_SCREENSHOT_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_screenshot
 */
#define IVI_SCREENSHOT_ERROR_SINCE_VERSION 1


/** @ingroup iface_ivi_screenshot */
static inline void
ivi_screenshot_set_user_data(struct ivi_screenshot *ivi_screenshot, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ivi_screenshot, user_data);
}

/** @ingroup iface_ivi_screenshot */
static inline void *
ivi_screenshot_get_user_data(struct ivi_screenshot *ivi_screenshot)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ivi_screenshot);
}

static inline uint32_t
ivi_screenshot_get_version(struct ivi_screenshot *ivi_screenshot)
{
	return wl_proxy_get_version((struct wl_proxy *) ivi_screenshot);
}

/** @ingroup iface_ivi_screenshot */
static inline void
ivi_screenshot_destroy(struct ivi_screenshot *ivi_screenshot)
{
	wl_proxy_destroy((struct wl_proxy *) ivi_screenshot);
}

#ifndef IVI_WM_SYNC_ENUM
#define IVI_WM_SYNC_ENUM
/**
 * @ingroup iface_ivi_wm
 * sync request states
 *
 */
enum ivi_wm_sync {
	IVI_WM_SYNC_ADD = 0,
	IVI_WM_SYNC_REMOVE = 1,
};
#endif /* IVI_WM_SYNC_ENUM */

#ifndef IVI_WM_PARAM_ENUM
#define IVI_WM_PARAM_ENUM
/**
 * @ingroup iface_ivi_wm
 * parameter types
 *
 * The HMI controller can request different types of parameters of an
 * ivi-object.
 */
enum ivi_wm_param {
	IVI_WM_PARAM_OPACITY = 1,
	IVI_WM_PARAM_VISIBILITY = 2,
	IVI_WM_PARAM_SIZE = 4,
	IVI_WM_PARAM_RENDER_ORDER = 8,
};
#endif /* IVI_WM_PARAM_ENUM */

#ifndef IVI_WM_SURFACE_TYPE_ENUM
#define IVI_WM_SURFACE_TYPE_ENUM
/**
 * @ingroup iface_ivi_wm
 * hint for the compositor
 *
 * If a surface is restricted type, visible contents of the surface is strictly
 * controlled by the compositor. Its content is not allowed to be go out of
 * its destination region. If the application resizes its buffers or uses
 * wp_viewporter protocol to scale its contents, the old destination region
 * would causes visible glitches.
 * To avoid these issues, the controller process mark a surface as desktop
 * compatible. Source and destination regions of a desktop compatible
 * surface will be modified accordingly,when application sends a request
 * for resizing or scaling its contents. Therefore, applications contents
 * will be drawn according to application's wishes.
 * On the other hand, source and destination regions will be strictly
 * enforced, when the surface's type is restricted. The default type for
 * a surface is ivi.
 */
enum ivi_wm_surface_type {
	/**
	 * strictly controlled
	 */
	IVI_WM_SURFACE_TYPE_RESTRICTED = 0,
	/**
	 * free to resize and scale
	 */
	IVI_WM_SURFACE_TYPE_DESKTOP = 1,
};
#endif /* IVI_WM_SURFACE_TYPE_ENUM */

#ifndef IVI_WM_SURFACE_ERROR_ENUM
#define IVI_WM_SURFACE_ERROR_ENUM
enum ivi_wm_surface_error {
	/**
	 * the surface with given id does not exist
	 */
	IVI_WM_SURFACE_ERROR_NO_SURFACE = 0,
	/**
	 * the given parameter is not valid
	 */
	IVI_WM_SURFACE_ERROR_BAD_PARAM = 1,
	/**
	 * the request is not supported
	 */
	IVI_WM_SURFACE_ERROR_NOT_SUPPORTED = 2,
};
#endif /* IVI_WM_SURFACE_ERROR_ENUM */

#ifndef IVI_WM_LAYER_ERROR_ENUM
#define IVI_WM_LAYER_ERROR_ENUM
enum ivi_wm_layer_error {
	/**
	 * the surface with given id does not exist
	 */
	IVI_WM_LAYER_ERROR_NO_SURFACE = 0,
	/**
	 * the layer with given id does not exist
	 */
	IVI_WM_LAYER_ERROR_NO_LAYER = 1,
	/**
	 * the given parameter is not valid
	 */
	IVI_WM_LAYER_ERROR_BAD_PARAM = 2,
};
#endif /* IVI_WM_LAYER_ERROR_ENUM */

/**
 * @ingroup iface_ivi_wm
 * @struct ivi_wm_listener
 */
struct ivi_wm_listener {
	/**
	 * the visibility of the surface in ivi compositor has changed
	 *
	 * The new visibility state is provided in argument visibility.
	 * If visibility is 0, the surface has become invisible. If
	 * visibility is not 0, the surface has become visible.
	 */
	void (*surface_visibility)(void *data,
				   struct ivi_wm *ivi_wm,
				   uint32_t surface_id,
				   int32_t visibility);
	/**
	 * the visibility of the layer in ivi compositor has changed
	 *
	 * The new visibility state is provided in argument visibility.
	 * If visibility is 0, the layer has become invisible. If
	 * visibility is not 0, the layer has become visible.
	 */
	void (*layer_visibility)(void *data,
				 struct ivi_wm *ivi_wm,
				 uint32_t layer_id,
				 int32_t visibility);
	/**
	 * the opacity of surface in ivi compositor has changed
	 *
	 * The new opacity state is provided in argument opacity. The
	 * valid range for opactiy is 0.0 (fully transparent) to 1.0 (fully
	 * opaque).
	 */
	void (*surface_opacity)(void *data,
				struct ivi_wm *ivi_wm,
				uint32_t surface_id,
				wl_fixed_t opacity);
	/**
	 * the opacity of layer in ivi compositor has changed
	 *
	 * The new opacity state is provided in argument opacity. The
	 * valid range for opactiy is 0.0 (fully transparent) to 1.0 (fully
	 * opaque).
	 */
	void (*layer_opacity)(void *data,
			      struct ivi_wm *ivi_wm,
			      uint32_t layer_id,
			      wl_fixed_t opacity);
	/**
	 * the source rectangle of surface in ivi compositor has changed
	 *
	 * The scanout region of the surface content has changed. The new
	 * values for source rectangle are provided by x: new horizontal
	 * start position of scanout area within the surface y: new
	 * vertical start position of scanout area within the surface
	 * width: new width of scanout area within the surface height: new
	 * height of scanout area within the surface
	 */
	void (*surface_source_rectangle)(void *data,
					 struct ivi_wm *ivi_wm,
					 uint32_t surface_id,
					 int32_t x,
					 int32_t y,
					 int32_t width,
					 int32_t height);
	/**
	 * the source rectangle of layer in ivi compositor has changed
	 *
	 * The scanout region of the layer content has changed. The new
	 * values for source rectangle are provided by x: new horizontal
	 * start position of scanout area within the layer y: new vertical
	 * start position of scanout area within the layer width: new width
	 * of scanout area within the layer height: new height of scanout
	 * area within the layer
	 */
	void (*layer_source_rectangle)(void *data,
				       struct ivi_wm *ivi_wm,
				       uint32_t layer_id,
				       int32_t x,
				       int32_t y,
				       int32_t width,
				       int32_t height);
	/**
	 * the destination rectangle of surface in ivi compositor has changed
	 *
	 * The new values for source rectangle are provided by x: new
	 * horizontal start position of surface within the layer y: new
	 * vertical start position of surface within the layer width : new
	 * width of surface within the layer height: new height of surface
	 * within the layer
	 */
	void (*surface_destination_rectangle)(void *data,
					      struct ivi_wm *ivi_wm,
					      uint32_t surface_id,
					      int32_t x,
					      int32_t y,
					      int32_t width,
					      int32_t height);
	/**
	 * the destination rectangle of layer in ivi compositor has changed
	 *
	 * The new values for source rectangle are provided by x: new
	 * horizontal start position of layer within the screen y: new
	 * vertical start position of layer within the screen width : new
	 * width of layer within the screen height: new height of layer
	 * within the screen
	 */
	void (*layer_destination_rectangle)(void *data,
					    struct ivi_wm *ivi_wm,
					    uint32_t layer_id,
					    int32_t x,
					    int32_t y,
					    int32_t width,
					    int32_t height);
	/**
	 * ivi_layout_surface was created
	 *
	 * 
	 */
	void (*surface_created)(void *data,
				struct ivi_wm *ivi_wm,
				uint32_t surface_id);
	/**
	 * ivi_layout_layer was created
	 *
	 * 
	 */
	void (*layer_created)(void *data,
			      struct ivi_wm *ivi_wm,
			      uint32_t layer_id);
	/**
	 * ivi_layout_surface was destroyed
	 *
	 * 
	 */
	void (*surface_destroyed)(void *data,
				  struct ivi_wm *ivi_wm,
				  uint32_t surface_id);
	/**
	 * ivi_layout_layer was destroyed
	 *
	 * 
	 */
	void (*layer_destroyed)(void *data,
				struct ivi_wm *ivi_wm,
				uint32_t layer_id);
	/**
	 * error event
	 *
	 * The error event is sent out when an error has occurred.
	 * @param object_id id of a layer or surface
	 * @param error error code
	 * @param message error description
	 */
	void (*surface_error)(void *data,
			      struct ivi_wm *ivi_wm,
			      uint32_t object_id,
			      uint32_t error,
			      const char *message);
	/**
	 * error event
	 *
	 * The error event is sent out when an error has occurred.
	 * @param object_id id of a layer or surface
	 * @param error error code
	 * @param message error description
	 */
	void (*layer_error)(void *data,
			    struct ivi_wm *ivi_wm,
			    uint32_t object_id,
			    uint32_t error,
			    const char *message);
	/**
	 * the surface size in ivi compositor has changed
	 *
	 * The client providing content for this surface modified size of
	 * the surface. The modified surface size is provided by arguments
	 * width and height.
	 */
	void (*surface_size)(void *data,
			     struct ivi_wm *ivi_wm,
			     uint32_t surface_id,
			     int32_t width,
			     int32_t height);
	/**
	 * receive updated statistics for surface in ivi compositor
	 *
	 * The information contained in this event is essential for
	 * monitoring, debugging, logging and tracing support in IVI
	 * systems.
	 */
	void (*surface_stats)(void *data,
			      struct ivi_wm *ivi_wm,
			      uint32_t surface_id,
			      uint32_t frame_count,
			      uint32_t pid);
	/**
	 * update render order of the layer
	 *
	 * A surface is added to the render order of the layer
	 */
	void (*layer_surface_added)(void *data,
				    struct ivi_wm *ivi_wm,
				    uint32_t layer_id,
				    uint32_t surface_id);
};

/**
 * @ingroup iface_ivi_wm
 */
static inline int
ivi_wm_add_listener(struct ivi_wm *ivi_wm,
		    const struct ivi_wm_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ivi_wm,
				     (void (**)(void)) listener, data);
}

#define IVI_WM_COMMIT_CHANGES 0
#define IVI_WM_CREATE_SCREEN 1
#define IVI_WM_SET_SURFACE_VISIBILITY 2
#define IVI_WM_SET_LAYER_VISIBILITY 3
#define IVI_WM_SET_SURFACE_OPACITY 4
#define IVI_WM_SET_LAYER_OPACITY 5
#define IVI_WM_SET_SURFACE_SOURCE_RECTANGLE 6
#define IVI_WM_SET_LAYER_SOURCE_RECTANGLE 7
#define IVI_WM_SET_SURFACE_DESTINATION_RECTANGLE 8
#define IVI_WM_SET_LAYER_DESTINATION_RECTANGLE 9
#define IVI_WM_SURFACE_SYNC 10
#define IVI_WM_LAYER_SYNC 11
#define IVI_WM_SURFACE_GET 12
#define IVI_WM_LAYER_GET 13
#define IVI_WM_SURFACE_SCREENSHOT 14
#define IVI_WM_SET_SURFACE_TYPE 15
#define IVI_WM_LAYER_CLEAR 16
#define IVI_WM_LAYER_ADD_SURFACE 17
#define IVI_WM_LAYER_REMOVE_SURFACE 18
#define IVI_WM_CREATE_LAYOUT_LAYER 19
#define IVI_WM_DESTROY_LAYOUT_LAYER 20

/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SURFACE_VISIBILITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_LAYER_VISIBILITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SURFACE_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_LAYER_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SURFACE_SOURCE_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_LAYER_SOURCE_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SURFACE_DESTINATION_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_LAYER_DESTINATION_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SURFACE_CREATED_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_LAYER_CREATED_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SURFACE_DESTROYED_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_LAYER_DESTROYED_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SURFACE_ERROR_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_LAYER_ERROR_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SURFACE_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SURFACE_STATS_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_LAYER_SURFACE_ADDED_SINCE_VERSION 1

/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_COMMIT_CHANGES_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_CREATE_SCREEN_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SET_SURFACE_VISIBILITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SET_LAYER_VISIBILITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SET_SURFACE_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SET_LAYER_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SET_SURFACE_SOURCE_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SET_LAYER_SOURCE_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SET_SURFACE_DESTINATION_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SET_LAYER_DESTINATION_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SURFACE_SYNC_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_LAYER_SYNC_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SURFACE_GET_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_LAYER_GET_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SURFACE_SCREENSHOT_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_SET_SURFACE_TYPE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_LAYER_CLEAR_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_LAYER_ADD_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_LAYER_REMOVE_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_CREATE_LAYOUT_LAYER_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_wm
 */
#define IVI_WM_DESTROY_LAYOUT_LAYER_SINCE_VERSION 1

/** @ingroup iface_ivi_wm */
static inline void
ivi_wm_set_user_data(struct ivi_wm *ivi_wm, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ivi_wm, user_data);
}

/** @ingroup iface_ivi_wm */
static inline void *
ivi_wm_get_user_data(struct ivi_wm *ivi_wm)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ivi_wm);
}

static inline uint32_t
ivi_wm_get_version(struct ivi_wm *ivi_wm)
{
	return wl_proxy_get_version((struct wl_proxy *) ivi_wm);
}

/** @ingroup iface_ivi_wm */
static inline void
ivi_wm_destroy(struct ivi_wm *ivi_wm)
{
	wl_proxy_destroy((struct wl_proxy *) ivi_wm);
}

/**
 * @ingroup iface_ivi_wm
 *
 * All requests are not applied directly to scene object, so a controller
 * can set different properties and apply the changes all at once.
 * Note: there's an exception to this. Creation and destruction of
 * scene objects is executed immediately.
 */
static inline void
ivi_wm_commit_changes(struct ivi_wm *ivi_wm)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_COMMIT_CHANGES, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0);
}

/**
 * @ingroup iface_ivi_wm
 *
 * Ask the ivi-wm to create a ivi-screen for given wl_output.
 */
static inline struct ivi_wm_screen *
ivi_wm_create_screen(struct ivi_wm *ivi_wm, struct wl_output *output)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_CREATE_SCREEN, &ivi_wm_screen_interface, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, output, NULL);

	return (struct ivi_wm_screen *) id;
}

/**
 * @ingroup iface_ivi_wm
 *
 * If visibility argument is 0, the surface in the ivi compositor is set to invisible.
 * If visibility argument is not 0, the surface in the ivi compositor is set to visible.
 */
static inline void
ivi_wm_set_surface_visibility(struct ivi_wm *ivi_wm, uint32_t surface_id, uint32_t visibility)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_SET_SURFACE_VISIBILITY, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, surface_id, visibility);
}

/**
 * @ingroup iface_ivi_wm
 *
 * If visibility argument is 0, the layer in the ivi compositor is set to invisible.
 * If visibility argument is not 0, the layer in the ivi compositor is set to visible.
 */
static inline void
ivi_wm_set_layer_visibility(struct ivi_wm *ivi_wm, uint32_t layer_id, uint32_t visibility)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_SET_LAYER_VISIBILITY, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, layer_id, visibility);
}

/**
 * @ingroup iface_ivi_wm
 *
 * The valid range for opacity is 0.0 (fully transparent) to 1.0 (fully opaque).
 */
static inline void
ivi_wm_set_surface_opacity(struct ivi_wm *ivi_wm, uint32_t surface_id, wl_fixed_t opacity)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_SET_SURFACE_OPACITY, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, surface_id, opacity);
}

/**
 * @ingroup iface_ivi_wm
 *
 * The valid range for opacity is 0.0 (fully transparent) to 1.0 (fully opaque).
 */
static inline void
ivi_wm_set_layer_opacity(struct ivi_wm *ivi_wm, uint32_t layer_id, wl_fixed_t opacity)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_SET_LAYER_OPACITY, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, layer_id, opacity);
}

/**
 * @ingroup iface_ivi_wm
 *
 * The source rectangle defines the part of the surface content, that is used for
 * compositing the surface. It can be used, if valid content of the surface is smaller
 * than the surface. Effectively it can be used to zoom the content of the surface.
 * If a parameter is less than 0, that value is not changed.
 * x:      horizontal start position of scanout area within the surface
 * y:      vertical start position of scanout area within the surface
 * width:  width of scanout area within the surface
 * height: height of scanout area within the surface
 */
static inline void
ivi_wm_set_surface_source_rectangle(struct ivi_wm *ivi_wm, uint32_t surface_id, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_SET_SURFACE_SOURCE_RECTANGLE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, surface_id, x, y, width, height);
}

/**
 * @ingroup iface_ivi_wm
 *
 * The source rectangle defines the part of the layer content, that is used for
 * compositing the screen. It can be used, if valid content of the layer is smaller
 * than the layer. Effectively it can be used to zoom the content of the layer.
 * If a parameter is less than 0, that value is not changed.
 * x:      horizontal start position of scanout area within the layer
 * y:      vertical start position of scanout area within the layer
 * width:  width of scanout area within the layer
 * height: height of scanout area within the layer
 */
static inline void
ivi_wm_set_layer_source_rectangle(struct ivi_wm *ivi_wm, uint32_t layer_id, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_SET_LAYER_SOURCE_RECTANGLE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, layer_id, x, y, width, height);
}

/**
 * @ingroup iface_ivi_wm
 *
 * The destination rectangle defines the position and size of a surface on a layer.
 * The surface will be scaled to this rectangle for rendering.
 * If a parameter is less than 0, that value is not changed.
 * x:      horizontal start position of surface within the layer
 * y:      vertical start position of surface within the layer
 * width : width of surface within the layer
 * height: height of surface within the layer
 */
static inline void
ivi_wm_set_surface_destination_rectangle(struct ivi_wm *ivi_wm, uint32_t surface_id, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_SET_SURFACE_DESTINATION_RECTANGLE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, surface_id, x, y, width, height);
}

/**
 * @ingroup iface_ivi_wm
 *
 * The destination rectangle defines the position and size of a layer on a screen.
 * The layer will be scaled to this rectangle for rendering.
 * If a parameter is less than 0, that value is not changed.
 * x:      horizontal start position of layer within the screen
 * y:      vertical start position of layer within the screen
 * width : width of surface within the screen
 * height: height of surface within the screen
 */
static inline void
ivi_wm_set_layer_destination_rectangle(struct ivi_wm *ivi_wm, uint32_t layer_id, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_SET_LAYER_DESTINATION_RECTANGLE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, layer_id, x, y, width, height);
}

/**
 * @ingroup iface_ivi_wm
 *
 * After this request, compositor sends the properties of the surface.
 * If sync_state argument is 0, compositor sends the properties continously.
 * If sync_state argument is not 0, compositor stops sending the properties
 * continously.
 */
static inline void
ivi_wm_surface_sync(struct ivi_wm *ivi_wm, uint32_t surface_id, int32_t sync_state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_SURFACE_SYNC, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, surface_id, sync_state);
}

/**
 * @ingroup iface_ivi_wm
 *
 * After this request, compositor sends the properties of the layer.
 * If sync_state argument is 0, compositor sends the properties continously.
 * If sync_state argument is not 0, compositor stops sending the properties
 * continously.
 */
static inline void
ivi_wm_layer_sync(struct ivi_wm *ivi_wm, uint32_t layer_id, int32_t sync_state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_LAYER_SYNC, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, layer_id, sync_state);
}

/**
 * @ingroup iface_ivi_wm
 *
 * After this request, compositor sends the requested parameter.
 */
static inline void
ivi_wm_surface_get(struct ivi_wm *ivi_wm, uint32_t surface_id, int32_t param)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_SURFACE_GET, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, surface_id, param);
}

/**
 * @ingroup iface_ivi_wm
 *
 * After this request, compositor sends the requested parameter.
 */
static inline void
ivi_wm_layer_get(struct ivi_wm *ivi_wm, uint32_t layer_id, int32_t param)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_LAYER_GET, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, layer_id, param);
}

/**
 * @ingroup iface_ivi_wm
 *
 * An ivi_screenshot object is created which will receive an image of the
 * buffer currently attached to the surface with the given id. If there
 * is no surface with such name the server will respond with an
 * ivi_screenshot.error event.
 */
static inline struct ivi_screenshot *
ivi_wm_surface_screenshot(struct ivi_wm *ivi_wm, uint32_t surface_id)
{
	struct wl_proxy *screenshot;

	screenshot = wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_SURFACE_SCREENSHOT, &ivi_screenshot_interface, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, NULL, surface_id);

	return (struct ivi_screenshot *) screenshot;
}

/**
 * @ingroup iface_ivi_wm
 *
 * After this request, compositor changes the type of the surface.
 */
static inline void
ivi_wm_set_surface_type(struct ivi_wm *ivi_wm, uint32_t surface_id, int32_t type)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_SET_SURFACE_TYPE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, surface_id, type);
}

/**
 * @ingroup iface_ivi_wm
 *
 * A layer has no content assigned to itself, it is a container for surfaces.
 * This request removes all surfaces from the layer render order.
 */
static inline void
ivi_wm_layer_clear(struct ivi_wm *ivi_wm, uint32_t layer_id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_LAYER_CLEAR, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, layer_id);
}

/**
 * @ingroup iface_ivi_wm
 *
 * A layer has no content assigned to itself, it is a container for surfaces.
 * This request adds a surface to the topmost position of the layer render order.
 * The added surface will cover all other surfaces of the layer.
 */
static inline void
ivi_wm_layer_add_surface(struct ivi_wm *ivi_wm, uint32_t layer_id, uint32_t surface_id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_LAYER_ADD_SURFACE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, layer_id, surface_id);
}

/**
 * @ingroup iface_ivi_wm
 *
 * A layer has no content assigned to itself, it is a container for surfaces.
 * This request removes one surfaces from the layer render order.
 * Note: the surface is not destroyed, it is just no longer contained by
 * the layer.
 */
static inline void
ivi_wm_layer_remove_surface(struct ivi_wm *ivi_wm, uint32_t layer_id, uint32_t surface_id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_LAYER_REMOVE_SURFACE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, layer_id, surface_id);
}

/**
 * @ingroup iface_ivi_wm
 *
 * After this request, compositor creates an ivi_layout_layer
 */
static inline void
ivi_wm_create_layout_layer(struct ivi_wm *ivi_wm, uint32_t layer_id, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_CREATE_LAYOUT_LAYER, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, layer_id, width, height);
}

/**
 * @ingroup iface_ivi_wm
 *
 * After this request, compositor destroyes an existing ivi_layout_layer.
 */
static inline void
ivi_wm_destroy_layout_layer(struct ivi_wm *ivi_wm, uint32_t layer_id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_wm,
			 IVI_WM_DESTROY_LAYOUT_LAYER, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_wm), 0, layer_id);
}

#ifdef  __cplusplus
}
#endif

#endif
