struct msgtable {
	__u8 opcode;
	const char *name;
};

static const struct msgtable msgtable[] = {
	{ CEC_MSG_ACTIVE_SOURCE, "ACTIVE_SOURCE" },
	{ CEC_MSG_IMAGE_VIEW_ON, "IMAGE_VIEW_ON" },
	{ CEC_MSG_TEXT_VIEW_ON, "TEXT_VIEW_ON" },
	{ CEC_MSG_INACTIVE_SOURCE, "INACTIVE_SOURCE" },
	{ CEC_MSG_REQUEST_ACTIVE_SOURCE, "REQUEST_ACTIVE_SOURCE" },
	{ CEC_MSG_ROUTING_INFORMATION, "ROUTING_INFORMATION" },
	{ CEC_MSG_ROUTING_CHANGE, "ROUTING_CHANGE" },
	{ CEC_MSG_SET_STREAM_PATH, "SET_STREAM_PATH" },
	{ CEC_MSG_STANDBY, "STANDBY" },
	{ CEC_MSG_RECORD_OFF, "RECORD_OFF" },
	{ CEC_MSG_RECORD_ON, "RECORD_ON" },
	{ CEC_MSG_RECORD_STATUS, "RECORD_STATUS" },
	{ CEC_MSG_RECORD_TV_SCREEN, "RECORD_TV_SCREEN" },
	{ CEC_MSG_TIMER_STATUS, "TIMER_STATUS" },
	{ CEC_MSG_TIMER_CLEARED_STATUS, "TIMER_CLEARED_STATUS" },
	{ CEC_MSG_CLEAR_ANALOGUE_TIMER, "CLEAR_ANALOGUE_TIMER" },
	{ CEC_MSG_CLEAR_DIGITAL_TIMER, "CLEAR_DIGITAL_TIMER" },
	{ CEC_MSG_CLEAR_EXT_TIMER, "CLEAR_EXT_TIMER" },
	{ CEC_MSG_SET_ANALOGUE_TIMER, "SET_ANALOGUE_TIMER" },
	{ CEC_MSG_SET_DIGITAL_TIMER, "SET_DIGITAL_TIMER" },
	{ CEC_MSG_SET_EXT_TIMER, "SET_EXT_TIMER" },
	{ CEC_MSG_SET_TIMER_PROGRAM_TITLE, "SET_TIMER_PROGRAM_TITLE" },
	{ CEC_MSG_CEC_VERSION, "CEC_VERSION" },
	{ CEC_MSG_GET_CEC_VERSION, "GET_CEC_VERSION" },
	{ CEC_MSG_REPORT_PHYSICAL_ADDR, "REPORT_PHYSICAL_ADDR" },
	{ CEC_MSG_GIVE_PHYSICAL_ADDR, "GIVE_PHYSICAL_ADDR" },
	{ CEC_MSG_SET_MENU_LANGUAGE, "SET_MENU_LANGUAGE" },
	{ CEC_MSG_GET_MENU_LANGUAGE, "GET_MENU_LANGUAGE" },
	{ CEC_MSG_REPORT_FEATURES, "REPORT_FEATURES" },
	{ CEC_MSG_GIVE_FEATURES, "GIVE_FEATURES" },
	{ CEC_MSG_DECK_CONTROL, "DECK_CONTROL" },
	{ CEC_MSG_DECK_STATUS, "DECK_STATUS" },
	{ CEC_MSG_GIVE_DECK_STATUS, "GIVE_DECK_STATUS" },
	{ CEC_MSG_PLAY, "PLAY" },
	{ CEC_MSG_TUNER_DEVICE_STATUS, "TUNER_DEVICE_STATUS" },
	{ CEC_MSG_GIVE_TUNER_DEVICE_STATUS, "GIVE_TUNER_DEVICE_STATUS" },
	{ CEC_MSG_SELECT_ANALOGUE_SERVICE, "SELECT_ANALOGUE_SERVICE" },
	{ CEC_MSG_SELECT_DIGITAL_SERVICE, "SELECT_DIGITAL_SERVICE" },
	{ CEC_MSG_TUNER_STEP_DECREMENT, "TUNER_STEP_DECREMENT" },
	{ CEC_MSG_TUNER_STEP_INCREMENT, "TUNER_STEP_INCREMENT" },
	{ CEC_MSG_DEVICE_VENDOR_ID, "DEVICE_VENDOR_ID" },
	{ CEC_MSG_GIVE_DEVICE_VENDOR_ID, "GIVE_DEVICE_VENDOR_ID" },
	{ CEC_MSG_VENDOR_REMOTE_BUTTON_UP, "VENDOR_REMOTE_BUTTON_UP" },
	{ CEC_MSG_SET_OSD_STRING, "SET_OSD_STRING" },
	{ CEC_MSG_SET_OSD_NAME, "SET_OSD_NAME" },
	{ CEC_MSG_GIVE_OSD_NAME, "GIVE_OSD_NAME" },
	{ CEC_MSG_MENU_STATUS, "MENU_STATUS" },
	{ CEC_MSG_MENU_REQUEST, "MENU_REQUEST" },
	{ CEC_MSG_USER_CONTROL_PRESSED, "USER_CONTROL_PRESSED" },
	{ CEC_MSG_USER_CONTROL_RELEASED, "USER_CONTROL_RELEASED" },
	{ CEC_MSG_REPORT_POWER_STATUS, "REPORT_POWER_STATUS" },
	{ CEC_MSG_GIVE_DEVICE_POWER_STATUS, "GIVE_DEVICE_POWER_STATUS" },
	{ CEC_MSG_FEATURE_ABORT, "FEATURE_ABORT" },
	{ CEC_MSG_ABORT, "ABORT" },
	{ CEC_MSG_REPORT_AUDIO_STATUS, "REPORT_AUDIO_STATUS" },
	{ CEC_MSG_GIVE_AUDIO_STATUS, "GIVE_AUDIO_STATUS" },
	{ CEC_MSG_SET_SYSTEM_AUDIO_MODE, "SET_SYSTEM_AUDIO_MODE" },
	{ CEC_MSG_SYSTEM_AUDIO_MODE_REQUEST, "SYSTEM_AUDIO_MODE_REQUEST" },
	{ CEC_MSG_SYSTEM_AUDIO_MODE_STATUS, "SYSTEM_AUDIO_MODE_STATUS" },
	{ CEC_MSG_GIVE_SYSTEM_AUDIO_MODE_STATUS, "GIVE_SYSTEM_AUDIO_MODE_STATUS" },
	{ CEC_MSG_REPORT_SHORT_AUDIO_DESCRIPTOR, "REPORT_SHORT_AUDIO_DESCRIPTOR" },
	{ CEC_MSG_REQUEST_SHORT_AUDIO_DESCRIPTOR, "REQUEST_SHORT_AUDIO_DESCRIPTOR" },
	{ CEC_MSG_SET_AUDIO_RATE, "SET_AUDIO_RATE" },
	{ CEC_MSG_REPORT_ARC_INITIATED, "REPORT_ARC_INITIATED" },
	{ CEC_MSG_INITIATE_ARC, "INITIATE_ARC" },
	{ CEC_MSG_REQUEST_ARC_INITIATION, "REQUEST_ARC_INITIATION" },
	{ CEC_MSG_REPORT_ARC_TERMINATED, "REPORT_ARC_TERMINATED" },
	{ CEC_MSG_TERMINATE_ARC, "TERMINATE_ARC" },
	{ CEC_MSG_REQUEST_ARC_TERMINATION, "REQUEST_ARC_TERMINATION" },
	{ CEC_MSG_REPORT_CURRENT_LATENCY, "REPORT_CURRENT_LATENCY" },
	{ CEC_MSG_REQUEST_CURRENT_LATENCY, "REQUEST_CURRENT_LATENCY" },
	{ CEC_MSG_VENDOR_COMMAND, "VENDOR_COMMAND" },
	{ CEC_MSG_VENDOR_COMMAND_WITH_ID, "VENDOR_COMMAND_WITH_ID" },
	{ CEC_MSG_VENDOR_REMOTE_BUTTON_DOWN, "VENDOR_REMOTE_BUTTON_DOWN" },
	{ CEC_MSG_CDC_MESSAGE, "CDC_MESSAGE" },
};

static const struct msgtable cdcmsgtable[] = {
	{ CEC_MSG_CDC_HEC_INQUIRE_STATE, "CDC_HEC_INQUIRE_STATE" },
	{ CEC_MSG_CDC_HEC_REPORT_STATE, "CDC_HEC_REPORT_STATE" },
	{ CEC_MSG_CDC_HEC_SET_STATE, "CDC_HEC_SET_STATE" },
	{ CEC_MSG_CDC_HEC_SET_STATE_ADJACENT, "CDC_HEC_SET_STATE_ADJACENT" },
	{ CEC_MSG_CDC_HEC_REQUEST_DEACTIVATION, "CDC_HEC_REQUEST_DEACTIVATION" },
	{ CEC_MSG_CDC_HEC_NOTIFY_ALIVE, "CDC_HEC_NOTIFY_ALIVE" },
	{ CEC_MSG_CDC_HEC_DISCOVER, "CDC_HEC_DISCOVER" },
	{ CEC_MSG_CDC_HPD_SET_STATE, "CDC_HPD_SET_STATE" },
	{ CEC_MSG_CDC_HPD_REPORT_STATE, "CDC_HPD_REPORT_STATE" },
};

static const struct msgtable htngmsgtable[] = {
	{ CEC_MSG_HTNG_TUNER_1PART_CHAN, "HTNG_TUNER_1PART_CHAN" },
	{ CEC_MSG_HTNG_TUNER_2PART_CHAN, "HTNG_TUNER_2PART_CHAN" },
	{ CEC_MSG_HTNG_INPUT_SEL_AV, "HTNG_INPUT_SEL_AV" },
	{ CEC_MSG_HTNG_INPUT_SEL_PC, "HTNG_INPUT_SEL_PC" },
	{ CEC_MSG_HTNG_INPUT_SEL_HDMI, "HTNG_INPUT_SEL_HDMI" },
	{ CEC_MSG_HTNG_INPUT_SEL_COMPONENT, "HTNG_INPUT_SEL_COMPONENT" },
	{ CEC_MSG_HTNG_INPUT_SEL_DVI, "HTNG_INPUT_SEL_DVI" },
	{ CEC_MSG_HTNG_INPUT_SEL_DP, "HTNG_INPUT_SEL_DP" },
	{ CEC_MSG_HTNG_INPUT_SEL_USB, "HTNG_INPUT_SEL_USB" },
	{ CEC_MSG_HTNG_SET_DEF_PWR_ON_INPUT_SRC, "HTNG_SET_DEF_PWR_ON_INPUT_SRC" },
	{ CEC_MSG_HTNG_SET_TV_SPEAKERS, "HTNG_SET_TV_SPEAKERS" },
	{ CEC_MSG_HTNG_SET_DIG_AUDIO, "HTNG_SET_DIG_AUDIO" },
	{ CEC_MSG_HTNG_SET_ANA_AUDIO, "HTNG_SET_ANA_AUDIO" },
	{ CEC_MSG_HTNG_SET_DEF_PWR_ON_VOL, "HTNG_SET_DEF_PWR_ON_VOL" },
	{ CEC_MSG_HTNG_SET_MAX_VOL, "HTNG_SET_MAX_VOL" },
	{ CEC_MSG_HTNG_SET_MIN_VOL, "HTNG_SET_MIN_VOL" },
	{ CEC_MSG_HTNG_SET_BLUE_SCREEN, "HTNG_SET_BLUE_SCREEN" },
	{ CEC_MSG_HTNG_SET_BRIGHTNESS, "HTNG_SET_BRIGHTNESS" },
	{ CEC_MSG_HTNG_SET_COLOR, "HTNG_SET_COLOR" },
	{ CEC_MSG_HTNG_SET_CONTRAST, "HTNG_SET_CONTRAST" },
	{ CEC_MSG_HTNG_SET_SHARPNESS, "HTNG_SET_SHARPNESS" },
	{ CEC_MSG_HTNG_SET_HUE, "HTNG_SET_HUE" },
	{ CEC_MSG_HTNG_SET_LED_BACKLIGHT, "HTNG_SET_LED_BACKLIGHT" },
	{ CEC_MSG_HTNG_SET_TV_OSD_CONTROL, "HTNG_SET_TV_OSD_CONTROL" },
	{ CEC_MSG_HTNG_SET_AUDIO_ONLY_DISPLAY, "HTNG_SET_AUDIO_ONLY_DISPLAY" },
	{ CEC_MSG_HTNG_SET_DATE, "HTNG_SET_DATE" },
	{ CEC_MSG_HTNG_SET_DATE_FORMAT, "HTNG_SET_DATE_FORMAT" },
	{ CEC_MSG_HTNG_SET_TIME, "HTNG_SET_TIME" },
	{ CEC_MSG_HTNG_SET_CLK_BRIGHTNESS_STANDBY, "HTNG_SET_CLK_BRIGHTNESS_STANDBY" },
	{ CEC_MSG_HTNG_SET_CLK_BRIGHTNESS_ON, "HTNG_SET_CLK_BRIGHTNESS_ON" },
	{ CEC_MSG_HTNG_LED_CONTROL, "HTNG_LED_CONTROL" },
	{ CEC_MSG_HTNG_LOCK_TV_PWR_BUTTON, "HTNG_LOCK_TV_PWR_BUTTON" },
	{ CEC_MSG_HTNG_LOCK_TV_VOL_BUTTONS, "HTNG_LOCK_TV_VOL_BUTTONS" },
	{ CEC_MSG_HTNG_LOCK_TV_CHAN_BUTTONS, "HTNG_LOCK_TV_CHAN_BUTTONS" },
	{ CEC_MSG_HTNG_LOCK_TV_INPUT_BUTTONS, "HTNG_LOCK_TV_INPUT_BUTTONS" },
	{ CEC_MSG_HTNG_LOCK_TV_OTHER_BUTTONS, "HTNG_LOCK_TV_OTHER_BUTTONS" },
	{ CEC_MSG_HTNG_LOCK_EVERYTHING, "HTNG_LOCK_EVERYTHING" },
	{ CEC_MSG_HTNG_LOCK_EVERYTHING_BUT_PWR, "HTNG_LOCK_EVERYTHING_BUT_PWR" },
	{ CEC_MSG_HTNG_HOTEL_MODE, "HTNG_HOTEL_MODE" },
	{ CEC_MSG_HTNG_SET_PWR_SAVING_PROFILE, "HTNG_SET_PWR_SAVING_PROFILE" },
	{ CEC_MSG_HTNG_SET_SLEEP_TIMER, "HTNG_SET_SLEEP_TIMER" },
	{ CEC_MSG_HTNG_SET_WAKEUP_TIME, "HTNG_SET_WAKEUP_TIME" },
	{ CEC_MSG_HTNG_SET_AUTO_OFF_TIME, "HTNG_SET_AUTO_OFF_TIME" },
	{ CEC_MSG_HTNG_SET_WAKEUP_SRC, "HTNG_SET_WAKEUP_SRC" },
	{ CEC_MSG_HTNG_SET_INIT_WAKEUP_VOL, "HTNG_SET_INIT_WAKEUP_VOL" },
	{ CEC_MSG_HTNG_CLR_ALL_SLEEP_WAKE, "HTNG_CLR_ALL_SLEEP_WAKE" },
	{ CEC_MSG_HTNG_GLOBAL_DIRECT_TUNE_FREQ, "HTNG_GLOBAL_DIRECT_TUNE_FREQ" },
	{ CEC_MSG_HTNG_GLOBAL_DIRECT_TUNE_CHAN, "HTNG_GLOBAL_DIRECT_TUNE_CHAN" },
	{ CEC_MSG_HTNG_GLOBAL_DIRECT_TUNE_EXT_FREQ, "HTNG_GLOBAL_DIRECT_TUNE_EXT_FREQ" },
};
