# ===========================================================================
#      http://www.gnu.org/software/autoconf-archive/ax_cc_for_build.html
# ===========================================================================
#
# SYNOPSIS
#
#   AX_CC_FOR_BUILD
#
# DESCRIPTION
#
#   Find a build-time compiler. Sets CC_FOR_BUILD and EXEEXT_FOR_BUILD.
#
# LICENSE
#
#   Copyright (c) 2010 Diego Elio Pettenò <flameeyes@gmail.com>
#   Copyright (c) 2010 Reuben Thomas <rrt@sc3d.org>
#   Copyright (c) 1999 Richard Henderson <rth@redhat.com>
#
#   This program is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the
#   Free Software Foundation, either version 3 of the License, or (at your
#   option) any later version.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
#   Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program. If not, see <http://www.gnu.org/licenses/>.
#
#   As a special exception, the respective Autoconf Macro's copyright owner
#   gives unlimited permission to copy, distribute and modify the configure
#   scripts that are the output of Autoconf when processing the Macro. You
#   need not follow the terms of the GNU General Public License when using
#   or distributing such scripts, even though portions of the text of the
#   Macro appear in them. The GNU General Public License (GPL) does govern
#   all other use of the material that constitutes the Autoconf Macro.
#
#   This special exception to the GPL applies to versions of the Autoconf
#   Macro released by the Autoconf Archive. When you make and distribute a
#   modified version of the Autoconf Macro, you may extend this special
#   exception to the GPL to apply to your modified version as well.

#serial 2

dnl Get a default for CC_FOR_BUILD to put into Makefile.
AC_DEFUN([AX_CC_FOR_BUILD], [
  AC_REQUIRE([AC_PROG_CC])

  dnl Declare the new variables
  AC_ARG_VAR([CC_FOR_BUILD],
     [Host's C compiler command for cross-compilation @<:@default=$(CC)@:>@])
  AC_ARG_VAR([BUILD_CFLAGS],
     [Host's C compiler flags @<:@default=$(CFLAGS)@:>@])
  AC_ARG_VAR([BUILD_LDFLAGS],
     [Host's linker flags @<:@default=$(LDFLAGS)@:>@])

  dnl Put a plausible default for CC_FOR_BUILD in Makefile.
  if test -z "$CC_FOR_BUILD"; then
    if test "x$cross_compiling" = "xno"; then
      CC_FOR_BUILD=${CC}
    else
      AC_CHECK_PROGS(CC_FOR_BUILD, [gcc cc])
    fi
  fi

  if test "x${BUILD_CFLAGS+set}" != "xset" ; then
    if test "x$cross_compiling" = "xyes" ; then
      BUILD_CFLAGS=
    else
      BUILD_CFLAGS=${CFLAGS}
    fi
  fi

  if test "x${BUILD_LDFLAGS+set}" != "xset" ; then
    if test "x$cross_compiling" = "xyes" ; then
      BUILD_LDFLAGS=
    else
      BUILD_LDFLAGS=${LDFLAGS}
    fi
  fi

  dnl Also set EXEEXT_FOR_BUILD.
  if test "x$cross_compiling" = "xno"; then
    EXEEXT_FOR_BUILD='$(EXEEXT)'
  else
    AC_CACHE_CHECK([for build system executable suffix], bfd_cv_build_exeext,
      [rm -f conftest*
       echo 'int main () { return 0; }' > conftest.c
       bfd_cv_build_exeext=
       ${CC_FOR_BUILD} ${LDFLAGS} ${CFLAGS} -o conftest conftest.c 1>&5 2>&5
       for file in conftest.*; do
         case $file in
         *.c | *.o | *.obj | *.ilk | *.pdb) ;;
         *) bfd_cv_build_exeext=`echo $file | sed -e s/conftest//` ;;
         esac
       done
       rm -f conftest*
       test x"${bfd_cv_build_exeext}" = x && bfd_cv_build_exeext=no])
    EXEEXT_FOR_BUILD=""
    test x"${bfd_cv_build_exeext}" != xno && EXEEXT_FOR_BUILD=${bfd_cv_build_exeext}
  fi
  AC_SUBST(EXEEXT_FOR_BUILD)
])dnl
