/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-mime.h"
#include "libical-glib-private.h"
#include "i-cal-component.h"

/**
 * i_cal_mime_parse:
 * @func: (scope call): The parsing function
 * @user_data: (closure): The date given to @func
 *
 * Parses data to #ICalComponent using the given function.
 *
 * Returns: (transfer full): The parsed #ICalComponent
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_mime_parse (ICalMimeParseFunc func, 
                  gpointer user_data)
{
	g_return_val_if_fail (func != NULL, NULL);
	g_return_val_if_fail (user_data != NULL, NULL);

	return i_cal_component_new_full (icalmime_parse(func, user_data), NULL);
}
