#ifndef DRM_COMMAND_BASE
#define DRM_COMMAND_BASE                0x40
#endif
static const char *drm_ioctl_cmds[] = {
	[0x00] = "VERSION",
	[0x01] = "GET_UNIQUE",
	[0x02] = "GET_MAGIC",
	[0x03] = "IRQ_BUSID",
	[0x04] = "GET_MAP",
	[0x05] = "GET_CLIENT",
	[0x06] = "GET_STATS",
	[0x07] = "SET_VERSION",
	[0x08] = "MODESET_CTL",
	[0x09] = "GEM_CLOSE",
	[0x0a] = "GEM_FLINK",
	[0x0b] = "GEM_OPEN",
	[0x0c] = "GET_CAP",
	[0x0d] = "SET_CLIENT_CAP",
	[0x10] = "SET_UNIQUE",
	[0x11] = "AUTH_MAGIC",
	[0x12] = "BLOCK",
	[0x13] = "UNBLOCK",
	[0x14] = "CONTROL",
	[0x15] = "ADD_MAP",
	[0x16] = "ADD_BUFS",
	[0x17] = "MARK_BUFS",
	[0x18] = "INFO_BUFS",
	[0x19] = "MAP_BUFS",
	[0x1a] = "FREE_BUFS",
	[0x1b] = "RM_MAP",
	[0x1c] = "SET_SAREA_CTX",
	[0x1d] = "GET_SAREA_CTX",
	[0x1e] = "SET_MASTER",
	[0x1f] = "DROP_MASTER",
	[0x20] = "ADD_CTX",
	[0x21] = "RM_CTX",
	[0x22] = "MOD_CTX",
	[0x23] = "GET_CTX",
	[0x24] = "SWITCH_CTX",
	[0x25] = "NEW_CTX",
	[0x26] = "RES_CTX",
	[0x27] = "ADD_DRAW",
	[0x28] = "RM_DRAW",
	[0x29] = "DMA",
	[0x2a] = "LOCK",
	[0x2b] = "UNLOCK",
	[0x2c] = "FINISH",
	[0x2d] = "PRIME_HANDLE_TO_FD",
	[0x2e] = "PRIME_FD_TO_HANDLE",
	[0x30] = "AGP_ACQUIRE",
	[0x31] = "AGP_RELEASE",
	[0x32] = "AGP_ENABLE",
	[0x33] = "AGP_INFO",
	[0x34] = "AGP_ALLOC",
	[0x35] = "AGP_FREE",
	[0x36] = "AGP_BIND",
	[0x37] = "AGP_UNBIND",
	[0x38] = "SG_ALLOC",
	[0x39] = "SG_FREE",
	[0x3a] = "WAIT_VBLANK",
	[0x3b] = "CRTC_GET_SEQUENCE",
	[0x3c] = "CRTC_QUEUE_SEQUENCE",
	[0x3f] = "UPDATE_DRAW",
	[0xA0] = "MODE_GETRESOURCES",
	[0xA1] = "MODE_GETCRTC",
	[0xA2] = "MODE_SETCRTC",
	[0xA3] = "MODE_CURSOR",
	[0xA4] = "MODE_GETGAMMA",
	[0xA5] = "MODE_SETGAMMA",
	[0xA6] = "MODE_GETENCODER",
	[0xA7] = "MODE_GETCONNECTOR",
	[0xA8] = "MODE_ATTACHMODE",
	[0xA9] = "MODE_DETACHMODE",
	[0xAA] = "MODE_GETPROPERTY",
	[0xAB] = "MODE_SETPROPERTY",
	[0xAC] = "MODE_GETPROPBLOB",
	[0xAD] = "MODE_GETFB",
	[0xAE] = "MODE_ADDFB",
	[0xAF] = "MODE_RMFB",
	[0xB0] = "MODE_PAGE_FLIP",
	[0xB1] = "MODE_DIRTYFB",
	[0xB2] = "MODE_CREATE_DUMB",
	[0xB3] = "MODE_MAP_DUMB",
	[0xB4] = "MODE_DESTROY_DUMB",
	[0xB5] = "MODE_GETPLANERESOURCES",
	[0xB6] = "MODE_GETPLANE",
	[0xB7] = "MODE_SETPLANE",
	[0xB8] = "MODE_ADDFB2",
	[0xB9] = "MODE_OBJ_GETPROPERTIES",
	[0xBA] = "MODE_OBJ_SETPROPERTY",
	[0xBB] = "MODE_CURSOR2",
	[0xBC] = "MODE_ATOMIC",
	[0xBD] = "MODE_CREATEPROPBLOB",
	[0xBE] = "MODE_DESTROYPROPBLOB",
	[0xBF] = "SYNCOBJ_CREATE",
	[0xC0] = "SYNCOBJ_DESTROY",
	[0xC1] = "SYNCOBJ_HANDLE_TO_FD",
	[0xC2] = "SYNCOBJ_FD_TO_HANDLE",
	[0xC3] = "SYNCOBJ_WAIT",
	[0xC4] = "SYNCOBJ_RESET",
	[0xC5] = "SYNCOBJ_SIGNAL",
	[0xC6] = "MODE_CREATE_LEASE",
	[0xC7] = "MODE_LIST_LESSEES",
	[0xC8] = "MODE_GET_LEASE",
	[0xC9] = "MODE_REVOKE_LEASE",
	[0xCA] = "SYNCOBJ_TIMELINE_WAIT",
	[0xCB] = "SYNCOBJ_QUERY",
	[0xCC] = "SYNCOBJ_TRANSFER",
	[0xCD] = "SYNCOBJ_TIMELINE_SIGNAL",
	[0xCE] = "MODE_GETFB2",
	[0xCF] = "SYNCOBJ_EVENTFD",
	[DRM_COMMAND_BASE + 0x00] = "I915_INIT",
	[DRM_COMMAND_BASE + 0x01] = "I915_FLUSH",
	[DRM_COMMAND_BASE + 0x02] = "I915_FLIP",
	[DRM_COMMAND_BASE + 0x03] = "I915_BATCHBUFFER",
	[DRM_COMMAND_BASE + 0x04] = "I915_IRQ_EMIT",
	[DRM_COMMAND_BASE + 0x05] = "I915_IRQ_WAIT",
	[DRM_COMMAND_BASE + 0x06] = "I915_GETPARAM",
	[DRM_COMMAND_BASE + 0x07] = "I915_SETPARAM",
	[DRM_COMMAND_BASE + 0x08] = "I915_ALLOC",
	[DRM_COMMAND_BASE + 0x09] = "I915_FREE",
	[DRM_COMMAND_BASE + 0x0a] = "I915_INIT_HEAP",
	[DRM_COMMAND_BASE + 0x0b] = "I915_CMDBUFFER",
	[DRM_COMMAND_BASE + 0x0c] = "I915_DESTROY_HEAP",
	[DRM_COMMAND_BASE + 0x0d] = "I915_SET_VBLANK_PIPE",
	[DRM_COMMAND_BASE + 0x0e] = "I915_GET_VBLANK_PIPE",
	[DRM_COMMAND_BASE + 0x0f] = "I915_VBLANK_SWAP",
	[DRM_COMMAND_BASE + 0x11] = "I915_HWS_ADDR",
	[DRM_COMMAND_BASE + 0x13] = "I915_GEM_INIT",
	[DRM_COMMAND_BASE + 0x14] = "I915_GEM_EXECBUFFER",
	[DRM_COMMAND_BASE + 0x15] = "I915_GEM_PIN",
	[DRM_COMMAND_BASE + 0x16] = "I915_GEM_UNPIN",
	[DRM_COMMAND_BASE + 0x17] = "I915_GEM_BUSY",
	[DRM_COMMAND_BASE + 0x18] = "I915_GEM_THROTTLE",
	[DRM_COMMAND_BASE + 0x19] = "I915_GEM_ENTERVT",
	[DRM_COMMAND_BASE + 0x1a] = "I915_GEM_LEAVEVT",
	[DRM_COMMAND_BASE + 0x1b] = "I915_GEM_CREATE",
	[DRM_COMMAND_BASE + 0x1c] = "I915_GEM_PREAD",
	[DRM_COMMAND_BASE + 0x1d] = "I915_GEM_PWRITE",
	[DRM_COMMAND_BASE + 0x1e] = "I915_GEM_MMAP",
	[DRM_COMMAND_BASE + 0x1f] = "I915_GEM_SET_DOMAIN",
	[DRM_COMMAND_BASE + 0x20] = "I915_GEM_SW_FINISH",
	[DRM_COMMAND_BASE + 0x21] = "I915_GEM_SET_TILING",
	[DRM_COMMAND_BASE + 0x22] = "I915_GEM_GET_TILING",
	[DRM_COMMAND_BASE + 0x23] = "I915_GEM_GET_APERTURE",
	[DRM_COMMAND_BASE + 0x24] = "I915_GEM_MMAP_GTT",
	[DRM_COMMAND_BASE + 0x25] = "I915_GET_PIPE_FROM_CRTC_ID",
	[DRM_COMMAND_BASE + 0x26] = "I915_GEM_MADVISE",
	[DRM_COMMAND_BASE + 0x27] = "I915_OVERLAY_PUT_IMAGE",
	[DRM_COMMAND_BASE + 0x28] = "I915_OVERLAY_ATTRS",
	[DRM_COMMAND_BASE + 0x29] = "I915_GEM_EXECBUFFER2",
	[DRM_COMMAND_BASE + 0x2a] = "I915_GET_SPRITE_COLORKEY",
	[DRM_COMMAND_BASE + 0x2b] = "I915_SET_SPRITE_COLORKEY",
	[DRM_COMMAND_BASE + 0x2c] = "I915_GEM_WAIT",
	[DRM_COMMAND_BASE + 0x2d] = "I915_GEM_CONTEXT_CREATE",
	[DRM_COMMAND_BASE + 0x2e] = "I915_GEM_CONTEXT_DESTROY",
	[DRM_COMMAND_BASE + 0x2f] = "I915_GEM_SET_CACHING",
	[DRM_COMMAND_BASE + 0x30] = "I915_GEM_GET_CACHING",
	[DRM_COMMAND_BASE + 0x31] = "I915_REG_READ",
	[DRM_COMMAND_BASE + 0x32] = "I915_GET_RESET_STATS",
	[DRM_COMMAND_BASE + 0x33] = "I915_GEM_USERPTR",
	[DRM_COMMAND_BASE + 0x34] = "I915_GEM_CONTEXT_GETPARAM",
	[DRM_COMMAND_BASE + 0x35] = "I915_GEM_CONTEXT_SETPARAM",
	[DRM_COMMAND_BASE + 0x36] = "I915_PERF_OPEN",
	[DRM_COMMAND_BASE + 0x37] = "I915_PERF_ADD_CONFIG",
	[DRM_COMMAND_BASE + 0x38] = "I915_PERF_REMOVE_CONFIG",
	[DRM_COMMAND_BASE + 0x39] = "I915_QUERY",
	[DRM_COMMAND_BASE + 0x3a] = "I915_GEM_VM_CREATE",
	[DRM_COMMAND_BASE + 0x3b] = "I915_GEM_VM_DESTROY",
	[DRM_COMMAND_BASE + 0x3c] = "I915_GEM_CREATE_EXT",
};
