---
title: GStreamer licensing
...

# GStreamer licensing

## How to license the code you write for GStreamer

GStreamer is a plugin-based framework licensed under the LGPL. The
reason for this choice in licensing is to ensure that everyone can use
GStreamer to build applications using licenses of their choice.

To keep this policy viable, the GStreamer community has made a few
licensing rules for code to be included in GStreamer's core or
GStreamer's official modules, like our plugin packages. We require that
all code going into our core package is LGPL. For the plugin code, we
require the use of the LGPL for all plugins written from scratch or
linking to external libraries. The only exception to this is when
plugins contain older code under more liberal licenses (like the MPL or
BSD). They can use those licenses instead and will still be considered
for inclusion. We do not accept GPL code to be added to our plugins
module, but we do accept LGPL-licensed plugins using an external GPL
library. The reason for demanding plugins be licensed under the LGPL,
even when using a GPL library, is that other developers might want to
use the plugin code as a template for plugins linking to non-GPL
libraries.

We also plan on splitting out the plugins using GPL libraries into a
separate package eventually and implement a system which makes sure an
application will not be able to access these plugins unless it uses some
special code to do so. The point of this is not to block GPL-licensed
plugins from being used and developed, but to make sure people are not
unintentionally violating the GPL license of said plugins.

This advisory is part of a bigger advisory with a FAQ which you can find
on the [GStreamer
website](http://gstreamer.freedesktop.org/documentation/licensing.html)
