/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "systemd1_unit_interface.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.systemd1.Unit
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Systemd1Unit
 * @title: Systemd1Unit
 * @short_description: Generated C code for the org.freedesktop.systemd1.Unit D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-systemd1-Unit.top_of_page">org.freedesktop.systemd1.Unit</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.systemd1.Unit ---- */

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_start_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_start_IN_ARG_pointers[] =
{
  &_systemd1_unit_method_info_start_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_start_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_start_OUT_ARG_pointers[] =
{
  &_systemd1_unit_method_info_start_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    (GDBusArgInfo **) &_systemd1_unit_method_info_start_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_unit_method_info_start_OUT_ARG_pointers,
    NULL
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_stop_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_stop_IN_ARG_pointers[] =
{
  &_systemd1_unit_method_info_stop_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_stop_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_stop_OUT_ARG_pointers[] =
{
  &_systemd1_unit_method_info_stop_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    (GDBusArgInfo **) &_systemd1_unit_method_info_stop_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_unit_method_info_stop_OUT_ARG_pointers,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_reload_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_reload_IN_ARG_pointers[] =
{
  &_systemd1_unit_method_info_reload_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_reload_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_reload_OUT_ARG_pointers[] =
{
  &_systemd1_unit_method_info_reload_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_reload =
{
  {
    -1,
    (gchar *) "Reload",
    (GDBusArgInfo **) &_systemd1_unit_method_info_reload_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_unit_method_info_reload_OUT_ARG_pointers,
    NULL
  },
  "handle-reload",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_restart_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_restart_IN_ARG_pointers[] =
{
  &_systemd1_unit_method_info_restart_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_restart_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_restart_OUT_ARG_pointers[] =
{
  &_systemd1_unit_method_info_restart_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_restart =
{
  {
    -1,
    (gchar *) "Restart",
    (GDBusArgInfo **) &_systemd1_unit_method_info_restart_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_unit_method_info_restart_OUT_ARG_pointers,
    NULL
  },
  "handle-restart",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_try_restart_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_try_restart_IN_ARG_pointers[] =
{
  &_systemd1_unit_method_info_try_restart_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_try_restart_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_try_restart_OUT_ARG_pointers[] =
{
  &_systemd1_unit_method_info_try_restart_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_try_restart =
{
  {
    -1,
    (gchar *) "TryRestart",
    (GDBusArgInfo **) &_systemd1_unit_method_info_try_restart_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_unit_method_info_try_restart_OUT_ARG_pointers,
    NULL
  },
  "handle-try-restart",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_reload_or_restart_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_reload_or_restart_IN_ARG_pointers[] =
{
  &_systemd1_unit_method_info_reload_or_restart_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_reload_or_restart_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_reload_or_restart_OUT_ARG_pointers[] =
{
  &_systemd1_unit_method_info_reload_or_restart_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_reload_or_restart =
{
  {
    -1,
    (gchar *) "ReloadOrRestart",
    (GDBusArgInfo **) &_systemd1_unit_method_info_reload_or_restart_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_unit_method_info_reload_or_restart_OUT_ARG_pointers,
    NULL
  },
  "handle-reload-or-restart",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_reload_or_try_restart_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_reload_or_try_restart_IN_ARG_pointers[] =
{
  &_systemd1_unit_method_info_reload_or_try_restart_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_reload_or_try_restart_OUT_ARG_job =
{
  {
    -1,
    (gchar *) "job",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_reload_or_try_restart_OUT_ARG_pointers[] =
{
  &_systemd1_unit_method_info_reload_or_try_restart_OUT_ARG_job.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_reload_or_try_restart =
{
  {
    -1,
    (gchar *) "ReloadOrTryRestart",
    (GDBusArgInfo **) &_systemd1_unit_method_info_reload_or_try_restart_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_unit_method_info_reload_or_try_restart_OUT_ARG_pointers,
    NULL
  },
  "handle-reload-or-try-restart",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_enqueue_job_IN_ARG_job_type =
{
  {
    -1,
    (gchar *) "job_type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_enqueue_job_IN_ARG_job_mode =
{
  {
    -1,
    (gchar *) "job_mode",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_enqueue_job_IN_ARG_pointers[] =
{
  &_systemd1_unit_method_info_enqueue_job_IN_ARG_job_type.parent_struct,
  &_systemd1_unit_method_info_enqueue_job_IN_ARG_job_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_enqueue_job_OUT_ARG_job_id =
{
  {
    -1,
    (gchar *) "job_id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_enqueue_job_OUT_ARG_job_path =
{
  {
    -1,
    (gchar *) "job_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_enqueue_job_OUT_ARG_unit_id =
{
  {
    -1,
    (gchar *) "unit_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_enqueue_job_OUT_ARG_unit_path =
{
  {
    -1,
    (gchar *) "unit_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_enqueue_job_OUT_ARG_job_type =
{
  {
    -1,
    (gchar *) "job_type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_enqueue_job_OUT_ARG_affected_jobs =
{
  {
    -1,
    (gchar *) "affected_jobs",
    (gchar *) "a(uosos)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_enqueue_job_OUT_ARG_pointers[] =
{
  &_systemd1_unit_method_info_enqueue_job_OUT_ARG_job_id.parent_struct,
  &_systemd1_unit_method_info_enqueue_job_OUT_ARG_job_path.parent_struct,
  &_systemd1_unit_method_info_enqueue_job_OUT_ARG_unit_id.parent_struct,
  &_systemd1_unit_method_info_enqueue_job_OUT_ARG_unit_path.parent_struct,
  &_systemd1_unit_method_info_enqueue_job_OUT_ARG_job_type.parent_struct,
  &_systemd1_unit_method_info_enqueue_job_OUT_ARG_affected_jobs.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_enqueue_job =
{
  {
    -1,
    (gchar *) "EnqueueJob",
    (GDBusArgInfo **) &_systemd1_unit_method_info_enqueue_job_IN_ARG_pointers,
    (GDBusArgInfo **) &_systemd1_unit_method_info_enqueue_job_OUT_ARG_pointers,
    NULL
  },
  "handle-enqueue-job",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_kill_IN_ARG_whom =
{
  {
    -1,
    (gchar *) "whom",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_kill_IN_ARG_signal =
{
  {
    -1,
    (gchar *) "signal",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_kill_IN_ARG_pointers[] =
{
  &_systemd1_unit_method_info_kill_IN_ARG_whom.parent_struct,
  &_systemd1_unit_method_info_kill_IN_ARG_signal.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_kill =
{
  {
    -1,
    (gchar *) "Kill",
    (GDBusArgInfo **) &_systemd1_unit_method_info_kill_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-kill",
  FALSE
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_reset_failed =
{
  {
    -1,
    (gchar *) "ResetFailed",
    NULL,
    NULL,
    NULL
  },
  "handle-reset-failed",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_set_properties_IN_ARG_runtime =
{
  {
    -1,
    (gchar *) "runtime",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_set_properties_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a(sv)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_set_properties_IN_ARG_pointers[] =
{
  &_systemd1_unit_method_info_set_properties_IN_ARG_runtime.parent_struct,
  &_systemd1_unit_method_info_set_properties_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_set_properties =
{
  {
    -1,
    (gchar *) "SetProperties",
    (GDBusArgInfo **) &_systemd1_unit_method_info_set_properties_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-properties",
  FALSE
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_ref =
{
  {
    -1,
    (gchar *) "Ref",
    NULL,
    NULL,
    NULL
  },
  "handle-ref",
  FALSE
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_unref =
{
  {
    -1,
    (gchar *) "Unref",
    NULL,
    NULL,
    NULL
  },
  "handle-unref",
  FALSE
};

static const _ExtendedGDBusArgInfo _systemd1_unit_method_info_clean_IN_ARG_mask =
{
  {
    -1,
    (gchar *) "mask",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _systemd1_unit_method_info_clean_IN_ARG_pointers[] =
{
  &_systemd1_unit_method_info_clean_IN_ARG_mask.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_clean =
{
  {
    -1,
    (gchar *) "Clean",
    (GDBusArgInfo **) &_systemd1_unit_method_info_clean_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-clean",
  FALSE
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_freeze =
{
  {
    -1,
    (gchar *) "Freeze",
    NULL,
    NULL,
    NULL
  },
  "handle-freeze",
  FALSE
};

static const _ExtendedGDBusMethodInfo _systemd1_unit_method_info_thaw =
{
  {
    -1,
    (gchar *) "Thaw",
    NULL,
    NULL,
    NULL
  },
  "handle-thaw",
  FALSE
};

static const GDBusMethodInfo * const _systemd1_unit_method_info_pointers[] =
{
  &_systemd1_unit_method_info_start.parent_struct,
  &_systemd1_unit_method_info_stop.parent_struct,
  &_systemd1_unit_method_info_reload.parent_struct,
  &_systemd1_unit_method_info_restart.parent_struct,
  &_systemd1_unit_method_info_try_restart.parent_struct,
  &_systemd1_unit_method_info_reload_or_restart.parent_struct,
  &_systemd1_unit_method_info_reload_or_try_restart.parent_struct,
  &_systemd1_unit_method_info_enqueue_job.parent_struct,
  &_systemd1_unit_method_info_kill.parent_struct,
  &_systemd1_unit_method_info_reset_failed.parent_struct,
  &_systemd1_unit_method_info_set_properties.parent_struct,
  &_systemd1_unit_method_info_ref.parent_struct,
  &_systemd1_unit_method_info_unref.parent_struct,
  &_systemd1_unit_method_info_clean.parent_struct,
  &_systemd1_unit_method_info_freeze.parent_struct,
  &_systemd1_unit_method_info_thaw.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _systemd1_unit_property_id_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_id_annotation_info_pointers[] =
{
  &_systemd1_unit_property_id_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_id =
{
  {
    -1,
    (gchar *) "Id",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_id_annotation_info_pointers
  },
  "id",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_names_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_names_annotation_info_pointers[] =
{
  &_systemd1_unit_property_names_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_names =
{
  {
    -1,
    (gchar *) "Names",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_names_annotation_info_pointers
  },
  "names",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_following_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_following_annotation_info_pointers[] =
{
  &_systemd1_unit_property_following_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_following =
{
  {
    -1,
    (gchar *) "Following",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_following_annotation_info_pointers
  },
  "following",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_requires_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_requires_annotation_info_pointers[] =
{
  &_systemd1_unit_property_requires_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_requires =
{
  {
    -1,
    (gchar *) "Requires",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_requires_annotation_info_pointers
  },
  "requires",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_requisite_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_requisite_annotation_info_pointers[] =
{
  &_systemd1_unit_property_requisite_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_requisite =
{
  {
    -1,
    (gchar *) "Requisite",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_requisite_annotation_info_pointers
  },
  "requisite",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_wants_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_wants_annotation_info_pointers[] =
{
  &_systemd1_unit_property_wants_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_wants =
{
  {
    -1,
    (gchar *) "Wants",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_wants_annotation_info_pointers
  },
  "wants",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_binds_to_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_binds_to_annotation_info_pointers[] =
{
  &_systemd1_unit_property_binds_to_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_binds_to =
{
  {
    -1,
    (gchar *) "BindsTo",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_binds_to_annotation_info_pointers
  },
  "binds-to",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_part_of_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_part_of_annotation_info_pointers[] =
{
  &_systemd1_unit_property_part_of_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_part_of =
{
  {
    -1,
    (gchar *) "PartOf",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_part_of_annotation_info_pointers
  },
  "part-of",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_required_by_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_required_by_annotation_info_pointers[] =
{
  &_systemd1_unit_property_required_by_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_required_by =
{
  {
    -1,
    (gchar *) "RequiredBy",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_required_by_annotation_info_pointers
  },
  "required-by",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_requisite_of_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_requisite_of_annotation_info_pointers[] =
{
  &_systemd1_unit_property_requisite_of_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_requisite_of =
{
  {
    -1,
    (gchar *) "RequisiteOf",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_requisite_of_annotation_info_pointers
  },
  "requisite-of",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_wanted_by_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_wanted_by_annotation_info_pointers[] =
{
  &_systemd1_unit_property_wanted_by_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_wanted_by =
{
  {
    -1,
    (gchar *) "WantedBy",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_wanted_by_annotation_info_pointers
  },
  "wanted-by",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_bound_by_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_bound_by_annotation_info_pointers[] =
{
  &_systemd1_unit_property_bound_by_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_bound_by =
{
  {
    -1,
    (gchar *) "BoundBy",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_bound_by_annotation_info_pointers
  },
  "bound-by",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_consists_of_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_consists_of_annotation_info_pointers[] =
{
  &_systemd1_unit_property_consists_of_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_consists_of =
{
  {
    -1,
    (gchar *) "ConsistsOf",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_consists_of_annotation_info_pointers
  },
  "consists-of",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_conflicts_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_conflicts_annotation_info_pointers[] =
{
  &_systemd1_unit_property_conflicts_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_conflicts =
{
  {
    -1,
    (gchar *) "Conflicts",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_conflicts_annotation_info_pointers
  },
  "conflicts",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_conflicted_by_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_conflicted_by_annotation_info_pointers[] =
{
  &_systemd1_unit_property_conflicted_by_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_conflicted_by =
{
  {
    -1,
    (gchar *) "ConflictedBy",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_conflicted_by_annotation_info_pointers
  },
  "conflicted-by",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_before_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_before_annotation_info_pointers[] =
{
  &_systemd1_unit_property_before_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_before =
{
  {
    -1,
    (gchar *) "Before",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_before_annotation_info_pointers
  },
  "before",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_after_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_after_annotation_info_pointers[] =
{
  &_systemd1_unit_property_after_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_after =
{
  {
    -1,
    (gchar *) "After",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_after_annotation_info_pointers
  },
  "after",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_on_failure_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_on_failure_annotation_info_pointers[] =
{
  &_systemd1_unit_property_on_failure_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_on_failure =
{
  {
    -1,
    (gchar *) "OnFailure",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_on_failure_annotation_info_pointers
  },
  "on-failure",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_on_failure_of_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_on_failure_of_annotation_info_pointers[] =
{
  &_systemd1_unit_property_on_failure_of_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_on_failure_of =
{
  {
    -1,
    (gchar *) "OnFailureOf",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_on_failure_of_annotation_info_pointers
  },
  "on-failure-of",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_on_success_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_on_success_annotation_info_pointers[] =
{
  &_systemd1_unit_property_on_success_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_on_success =
{
  {
    -1,
    (gchar *) "OnSuccess",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_on_success_annotation_info_pointers
  },
  "on-success",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_on_success_of_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_on_success_of_annotation_info_pointers[] =
{
  &_systemd1_unit_property_on_success_of_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_on_success_of =
{
  {
    -1,
    (gchar *) "OnSuccessOf",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_on_success_of_annotation_info_pointers
  },
  "on-success-of",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_triggers_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_triggers_annotation_info_pointers[] =
{
  &_systemd1_unit_property_triggers_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_triggers =
{
  {
    -1,
    (gchar *) "Triggers",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_triggers_annotation_info_pointers
  },
  "triggers",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_triggered_by_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_triggered_by_annotation_info_pointers[] =
{
  &_systemd1_unit_property_triggered_by_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_triggered_by =
{
  {
    -1,
    (gchar *) "TriggeredBy",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_triggered_by_annotation_info_pointers
  },
  "triggered-by",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_propagates_reload_to_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_propagates_reload_to_annotation_info_pointers[] =
{
  &_systemd1_unit_property_propagates_reload_to_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_propagates_reload_to =
{
  {
    -1,
    (gchar *) "PropagatesReloadTo",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_propagates_reload_to_annotation_info_pointers
  },
  "propagates-reload-to",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_reload_propagated_from_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_reload_propagated_from_annotation_info_pointers[] =
{
  &_systemd1_unit_property_reload_propagated_from_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_reload_propagated_from =
{
  {
    -1,
    (gchar *) "ReloadPropagatedFrom",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_reload_propagated_from_annotation_info_pointers
  },
  "reload-propagated-from",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_propagates_stop_to_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_propagates_stop_to_annotation_info_pointers[] =
{
  &_systemd1_unit_property_propagates_stop_to_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_propagates_stop_to =
{
  {
    -1,
    (gchar *) "PropagatesStopTo",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_propagates_stop_to_annotation_info_pointers
  },
  "propagates-stop-to",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_stop_propagated_from_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_stop_propagated_from_annotation_info_pointers[] =
{
  &_systemd1_unit_property_stop_propagated_from_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_stop_propagated_from =
{
  {
    -1,
    (gchar *) "StopPropagatedFrom",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_stop_propagated_from_annotation_info_pointers
  },
  "stop-propagated-from",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_joins_namespace_of_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_joins_namespace_of_annotation_info_pointers[] =
{
  &_systemd1_unit_property_joins_namespace_of_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_joins_namespace_of =
{
  {
    -1,
    (gchar *) "JoinsNamespaceOf",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_joins_namespace_of_annotation_info_pointers
  },
  "joins-namespace-of",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_slice_of_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_slice_of_annotation_info_pointers[] =
{
  &_systemd1_unit_property_slice_of_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_slice_of =
{
  {
    -1,
    (gchar *) "SliceOf",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_slice_of_annotation_info_pointers
  },
  "slice-of",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_requires_mounts_for_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_requires_mounts_for_annotation_info_pointers[] =
{
  &_systemd1_unit_property_requires_mounts_for_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_requires_mounts_for =
{
  {
    -1,
    (gchar *) "RequiresMountsFor",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_requires_mounts_for_annotation_info_pointers
  },
  "requires-mounts-for",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_documentation_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_documentation_annotation_info_pointers[] =
{
  &_systemd1_unit_property_documentation_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_documentation =
{
  {
    -1,
    (gchar *) "Documentation",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_documentation_annotation_info_pointers
  },
  "documentation",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_description_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_description_annotation_info_pointers[] =
{
  &_systemd1_unit_property_description_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_description =
{
  {
    -1,
    (gchar *) "Description",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_description_annotation_info_pointers
  },
  "description",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_load_state_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_load_state_annotation_info_pointers[] =
{
  &_systemd1_unit_property_load_state_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_load_state =
{
  {
    -1,
    (gchar *) "LoadState",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_load_state_annotation_info_pointers
  },
  "load-state",
  FALSE,
  FALSE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_active_state =
{
  {
    -1,
    (gchar *) "ActiveState",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active-state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_freezer_state =
{
  {
    -1,
    (gchar *) "FreezerState",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "freezer-state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_sub_state =
{
  {
    -1,
    (gchar *) "SubState",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "sub-state",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _systemd1_unit_property_fragment_path_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_fragment_path_annotation_info_pointers[] =
{
  &_systemd1_unit_property_fragment_path_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_fragment_path =
{
  {
    -1,
    (gchar *) "FragmentPath",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_fragment_path_annotation_info_pointers
  },
  "fragment-path",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_source_path_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_source_path_annotation_info_pointers[] =
{
  &_systemd1_unit_property_source_path_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_source_path =
{
  {
    -1,
    (gchar *) "SourcePath",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_source_path_annotation_info_pointers
  },
  "source-path",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_drop_in_paths_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_drop_in_paths_annotation_info_pointers[] =
{
  &_systemd1_unit_property_drop_in_paths_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_drop_in_paths =
{
  {
    -1,
    (gchar *) "DropInPaths",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_drop_in_paths_annotation_info_pointers
  },
  "drop-in-paths",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_unit_file_state_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_unit_file_state_annotation_info_pointers[] =
{
  &_systemd1_unit_property_unit_file_state_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_unit_file_state =
{
  {
    -1,
    (gchar *) "UnitFileState",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_unit_file_state_annotation_info_pointers
  },
  "unit-file-state",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_unit_file_preset_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_unit_file_preset_annotation_info_pointers[] =
{
  &_systemd1_unit_property_unit_file_preset_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_unit_file_preset =
{
  {
    -1,
    (gchar *) "UnitFilePreset",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_unit_file_preset_annotation_info_pointers
  },
  "unit-file-preset",
  FALSE,
  FALSE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_state_change_timestamp =
{
  {
    -1,
    (gchar *) "StateChangeTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state-change-timestamp",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_state_change_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "StateChangeTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state-change-timestamp-monotonic",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_inactive_exit_timestamp =
{
  {
    -1,
    (gchar *) "InactiveExitTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "inactive-exit-timestamp",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_inactive_exit_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "InactiveExitTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "inactive-exit-timestamp-monotonic",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_active_enter_timestamp =
{
  {
    -1,
    (gchar *) "ActiveEnterTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active-enter-timestamp",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_active_enter_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "ActiveEnterTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active-enter-timestamp-monotonic",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_active_exit_timestamp =
{
  {
    -1,
    (gchar *) "ActiveExitTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active-exit-timestamp",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_active_exit_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "ActiveExitTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active-exit-timestamp-monotonic",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_inactive_enter_timestamp =
{
  {
    -1,
    (gchar *) "InactiveEnterTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "inactive-enter-timestamp",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_inactive_enter_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "InactiveEnterTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "inactive-enter-timestamp-monotonic",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _systemd1_unit_property_can_start_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_can_start_annotation_info_pointers[] =
{
  &_systemd1_unit_property_can_start_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_can_start =
{
  {
    -1,
    (gchar *) "CanStart",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_can_start_annotation_info_pointers
  },
  "can-start",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_can_stop_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_can_stop_annotation_info_pointers[] =
{
  &_systemd1_unit_property_can_stop_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_can_stop =
{
  {
    -1,
    (gchar *) "CanStop",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_can_stop_annotation_info_pointers
  },
  "can-stop",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_can_reload_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_can_reload_annotation_info_pointers[] =
{
  &_systemd1_unit_property_can_reload_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_can_reload =
{
  {
    -1,
    (gchar *) "CanReload",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_can_reload_annotation_info_pointers
  },
  "can-reload",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_can_isolate_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_can_isolate_annotation_info_pointers[] =
{
  &_systemd1_unit_property_can_isolate_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_can_isolate =
{
  {
    -1,
    (gchar *) "CanIsolate",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_can_isolate_annotation_info_pointers
  },
  "can-isolate",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_can_clean_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_can_clean_annotation_info_pointers[] =
{
  &_systemd1_unit_property_can_clean_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_can_clean =
{
  {
    -1,
    (gchar *) "CanClean",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_can_clean_annotation_info_pointers
  },
  "can-clean",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_can_freeze_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_can_freeze_annotation_info_pointers[] =
{
  &_systemd1_unit_property_can_freeze_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_can_freeze =
{
  {
    -1,
    (gchar *) "CanFreeze",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_can_freeze_annotation_info_pointers
  },
  "can-freeze",
  FALSE,
  FALSE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_job =
{
  {
    -1,
    (gchar *) "Job",
    (gchar *) "(uo)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "job",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _systemd1_unit_property_stop_when_unneeded_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_stop_when_unneeded_annotation_info_pointers[] =
{
  &_systemd1_unit_property_stop_when_unneeded_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_stop_when_unneeded =
{
  {
    -1,
    (gchar *) "StopWhenUnneeded",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_stop_when_unneeded_annotation_info_pointers
  },
  "stop-when-unneeded",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_refuse_manual_start_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_refuse_manual_start_annotation_info_pointers[] =
{
  &_systemd1_unit_property_refuse_manual_start_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_refuse_manual_start =
{
  {
    -1,
    (gchar *) "RefuseManualStart",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_refuse_manual_start_annotation_info_pointers
  },
  "refuse-manual-start",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_refuse_manual_stop_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_refuse_manual_stop_annotation_info_pointers[] =
{
  &_systemd1_unit_property_refuse_manual_stop_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_refuse_manual_stop =
{
  {
    -1,
    (gchar *) "RefuseManualStop",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_refuse_manual_stop_annotation_info_pointers
  },
  "refuse-manual-stop",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_allow_isolate_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_allow_isolate_annotation_info_pointers[] =
{
  &_systemd1_unit_property_allow_isolate_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_allow_isolate =
{
  {
    -1,
    (gchar *) "AllowIsolate",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_allow_isolate_annotation_info_pointers
  },
  "allow-isolate",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_default_dependencies_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_default_dependencies_annotation_info_pointers[] =
{
  &_systemd1_unit_property_default_dependencies_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_default_dependencies =
{
  {
    -1,
    (gchar *) "DefaultDependencies",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_default_dependencies_annotation_info_pointers
  },
  "default-dependencies",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_on_success_job_mode_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_on_success_job_mode_annotation_info_pointers[] =
{
  &_systemd1_unit_property_on_success_job_mode_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_on_success_job_mode =
{
  {
    -1,
    (gchar *) "OnSuccessJobMode",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_on_success_job_mode_annotation_info_pointers
  },
  "on-success-job-mode",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_on_failure_job_mode_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_on_failure_job_mode_annotation_info_pointers[] =
{
  &_systemd1_unit_property_on_failure_job_mode_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_on_failure_job_mode =
{
  {
    -1,
    (gchar *) "OnFailureJobMode",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_on_failure_job_mode_annotation_info_pointers
  },
  "on-failure-job-mode",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_ignore_on_isolate_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_ignore_on_isolate_annotation_info_pointers[] =
{
  &_systemd1_unit_property_ignore_on_isolate_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_ignore_on_isolate =
{
  {
    -1,
    (gchar *) "IgnoreOnIsolate",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_ignore_on_isolate_annotation_info_pointers
  },
  "ignore-on-isolate",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_need_daemon_reload_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_need_daemon_reload_annotation_info_pointers[] =
{
  &_systemd1_unit_property_need_daemon_reload_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_need_daemon_reload =
{
  {
    -1,
    (gchar *) "NeedDaemonReload",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_need_daemon_reload_annotation_info_pointers
  },
  "need-daemon-reload",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_markers_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_markers_annotation_info_pointers[] =
{
  &_systemd1_unit_property_markers_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_markers =
{
  {
    -1,
    (gchar *) "Markers",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_markers_annotation_info_pointers
  },
  "markers",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_job_timeout_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_job_timeout_usec_annotation_info_pointers[] =
{
  &_systemd1_unit_property_job_timeout_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_job_timeout_usec =
{
  {
    -1,
    (gchar *) "JobTimeoutUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_job_timeout_usec_annotation_info_pointers
  },
  "job-timeout-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_job_running_timeout_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_job_running_timeout_usec_annotation_info_pointers[] =
{
  &_systemd1_unit_property_job_running_timeout_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_job_running_timeout_usec =
{
  {
    -1,
    (gchar *) "JobRunningTimeoutUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_job_running_timeout_usec_annotation_info_pointers
  },
  "job-running-timeout-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_job_timeout_action_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_job_timeout_action_annotation_info_pointers[] =
{
  &_systemd1_unit_property_job_timeout_action_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_job_timeout_action =
{
  {
    -1,
    (gchar *) "JobTimeoutAction",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_job_timeout_action_annotation_info_pointers
  },
  "job-timeout-action",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_job_timeout_reboot_argument_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_job_timeout_reboot_argument_annotation_info_pointers[] =
{
  &_systemd1_unit_property_job_timeout_reboot_argument_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_job_timeout_reboot_argument =
{
  {
    -1,
    (gchar *) "JobTimeoutRebootArgument",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_job_timeout_reboot_argument_annotation_info_pointers
  },
  "job-timeout-reboot-argument",
  FALSE,
  FALSE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_condition_result =
{
  {
    -1,
    (gchar *) "ConditionResult",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "condition-result",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_assert_result =
{
  {
    -1,
    (gchar *) "AssertResult",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "assert-result",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_condition_timestamp =
{
  {
    -1,
    (gchar *) "ConditionTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "condition-timestamp",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_condition_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "ConditionTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "condition-timestamp-monotonic",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_assert_timestamp =
{
  {
    -1,
    (gchar *) "AssertTimestamp",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "assert-timestamp",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_assert_timestamp_monotonic =
{
  {
    -1,
    (gchar *) "AssertTimestampMonotonic",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "assert-timestamp-monotonic",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _systemd1_unit_property_conditions_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "invalidates",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_conditions_annotation_info_pointers[] =
{
  &_systemd1_unit_property_conditions_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_conditions =
{
  {
    -1,
    (gchar *) "Conditions",
    (gchar *) "a(sbbsi)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_conditions_annotation_info_pointers
  },
  "conditions",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _systemd1_unit_property_asserts_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "invalidates",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_asserts_annotation_info_pointers[] =
{
  &_systemd1_unit_property_asserts_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_asserts =
{
  {
    -1,
    (gchar *) "Asserts",
    (gchar *) "a(sbbsi)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_asserts_annotation_info_pointers
  },
  "asserts",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _systemd1_unit_property_load_error_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_load_error_annotation_info_pointers[] =
{
  &_systemd1_unit_property_load_error_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_load_error =
{
  {
    -1,
    (gchar *) "LoadError",
    (gchar *) "(ss)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_load_error_annotation_info_pointers
  },
  "load-error",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_transient_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_transient_annotation_info_pointers[] =
{
  &_systemd1_unit_property_transient_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_transient =
{
  {
    -1,
    (gchar *) "Transient",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_transient_annotation_info_pointers
  },
  "transient",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_perpetual_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_perpetual_annotation_info_pointers[] =
{
  &_systemd1_unit_property_perpetual_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_perpetual =
{
  {
    -1,
    (gchar *) "Perpetual",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_perpetual_annotation_info_pointers
  },
  "perpetual",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_start_limit_interval_usec_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_start_limit_interval_usec_annotation_info_pointers[] =
{
  &_systemd1_unit_property_start_limit_interval_usec_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_start_limit_interval_usec =
{
  {
    -1,
    (gchar *) "StartLimitIntervalUSec",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_start_limit_interval_usec_annotation_info_pointers
  },
  "start-limit-interval-usec",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_start_limit_burst_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_start_limit_burst_annotation_info_pointers[] =
{
  &_systemd1_unit_property_start_limit_burst_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_start_limit_burst =
{
  {
    -1,
    (gchar *) "StartLimitBurst",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_start_limit_burst_annotation_info_pointers
  },
  "start-limit-burst",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_start_limit_action_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_start_limit_action_annotation_info_pointers[] =
{
  &_systemd1_unit_property_start_limit_action_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_start_limit_action =
{
  {
    -1,
    (gchar *) "StartLimitAction",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_start_limit_action_annotation_info_pointers
  },
  "start-limit-action",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_failure_action_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_failure_action_annotation_info_pointers[] =
{
  &_systemd1_unit_property_failure_action_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_failure_action =
{
  {
    -1,
    (gchar *) "FailureAction",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_failure_action_annotation_info_pointers
  },
  "failure-action",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_failure_action_exit_status_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_failure_action_exit_status_annotation_info_pointers[] =
{
  &_systemd1_unit_property_failure_action_exit_status_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_failure_action_exit_status =
{
  {
    -1,
    (gchar *) "FailureActionExitStatus",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_failure_action_exit_status_annotation_info_pointers
  },
  "failure-action-exit-status",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_success_action_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_success_action_annotation_info_pointers[] =
{
  &_systemd1_unit_property_success_action_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_success_action =
{
  {
    -1,
    (gchar *) "SuccessAction",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_success_action_annotation_info_pointers
  },
  "success-action",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_success_action_exit_status_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_success_action_exit_status_annotation_info_pointers[] =
{
  &_systemd1_unit_property_success_action_exit_status_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_success_action_exit_status =
{
  {
    -1,
    (gchar *) "SuccessActionExitStatus",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_success_action_exit_status_annotation_info_pointers
  },
  "success-action-exit-status",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_reboot_argument_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_reboot_argument_annotation_info_pointers[] =
{
  &_systemd1_unit_property_reboot_argument_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_reboot_argument =
{
  {
    -1,
    (gchar *) "RebootArgument",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_reboot_argument_annotation_info_pointers
  },
  "reboot-argument",
  FALSE,
  FALSE
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_invocation_id =
{
  {
    -1,
    (gchar *) "InvocationID",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "invocation-id",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _systemd1_unit_property_collect_mode_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "const",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_collect_mode_annotation_info_pointers[] =
{
  &_systemd1_unit_property_collect_mode_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_collect_mode =
{
  {
    -1,
    (gchar *) "CollectMode",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_collect_mode_annotation_info_pointers
  },
  "collect-mode",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _systemd1_unit_property_refs_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _systemd1_unit_property_refs_annotation_info_pointers[] =
{
  &_systemd1_unit_property_refs_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _systemd1_unit_property_info_refs =
{
  {
    -1,
    (gchar *) "Refs",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_systemd1_unit_property_refs_annotation_info_pointers
  },
  "refs",
  FALSE,
  FALSE
};

static const GDBusPropertyInfo * const _systemd1_unit_property_info_pointers[] =
{
  &_systemd1_unit_property_info_id.parent_struct,
  &_systemd1_unit_property_info_names.parent_struct,
  &_systemd1_unit_property_info_following.parent_struct,
  &_systemd1_unit_property_info_requires.parent_struct,
  &_systemd1_unit_property_info_requisite.parent_struct,
  &_systemd1_unit_property_info_wants.parent_struct,
  &_systemd1_unit_property_info_binds_to.parent_struct,
  &_systemd1_unit_property_info_part_of.parent_struct,
  &_systemd1_unit_property_info_required_by.parent_struct,
  &_systemd1_unit_property_info_requisite_of.parent_struct,
  &_systemd1_unit_property_info_wanted_by.parent_struct,
  &_systemd1_unit_property_info_bound_by.parent_struct,
  &_systemd1_unit_property_info_consists_of.parent_struct,
  &_systemd1_unit_property_info_conflicts.parent_struct,
  &_systemd1_unit_property_info_conflicted_by.parent_struct,
  &_systemd1_unit_property_info_before.parent_struct,
  &_systemd1_unit_property_info_after.parent_struct,
  &_systemd1_unit_property_info_on_failure.parent_struct,
  &_systemd1_unit_property_info_on_failure_of.parent_struct,
  &_systemd1_unit_property_info_on_success.parent_struct,
  &_systemd1_unit_property_info_on_success_of.parent_struct,
  &_systemd1_unit_property_info_triggers.parent_struct,
  &_systemd1_unit_property_info_triggered_by.parent_struct,
  &_systemd1_unit_property_info_propagates_reload_to.parent_struct,
  &_systemd1_unit_property_info_reload_propagated_from.parent_struct,
  &_systemd1_unit_property_info_propagates_stop_to.parent_struct,
  &_systemd1_unit_property_info_stop_propagated_from.parent_struct,
  &_systemd1_unit_property_info_joins_namespace_of.parent_struct,
  &_systemd1_unit_property_info_slice_of.parent_struct,
  &_systemd1_unit_property_info_requires_mounts_for.parent_struct,
  &_systemd1_unit_property_info_documentation.parent_struct,
  &_systemd1_unit_property_info_description.parent_struct,
  &_systemd1_unit_property_info_load_state.parent_struct,
  &_systemd1_unit_property_info_active_state.parent_struct,
  &_systemd1_unit_property_info_freezer_state.parent_struct,
  &_systemd1_unit_property_info_sub_state.parent_struct,
  &_systemd1_unit_property_info_fragment_path.parent_struct,
  &_systemd1_unit_property_info_source_path.parent_struct,
  &_systemd1_unit_property_info_drop_in_paths.parent_struct,
  &_systemd1_unit_property_info_unit_file_state.parent_struct,
  &_systemd1_unit_property_info_unit_file_preset.parent_struct,
  &_systemd1_unit_property_info_state_change_timestamp.parent_struct,
  &_systemd1_unit_property_info_state_change_timestamp_monotonic.parent_struct,
  &_systemd1_unit_property_info_inactive_exit_timestamp.parent_struct,
  &_systemd1_unit_property_info_inactive_exit_timestamp_monotonic.parent_struct,
  &_systemd1_unit_property_info_active_enter_timestamp.parent_struct,
  &_systemd1_unit_property_info_active_enter_timestamp_monotonic.parent_struct,
  &_systemd1_unit_property_info_active_exit_timestamp.parent_struct,
  &_systemd1_unit_property_info_active_exit_timestamp_monotonic.parent_struct,
  &_systemd1_unit_property_info_inactive_enter_timestamp.parent_struct,
  &_systemd1_unit_property_info_inactive_enter_timestamp_monotonic.parent_struct,
  &_systemd1_unit_property_info_can_start.parent_struct,
  &_systemd1_unit_property_info_can_stop.parent_struct,
  &_systemd1_unit_property_info_can_reload.parent_struct,
  &_systemd1_unit_property_info_can_isolate.parent_struct,
  &_systemd1_unit_property_info_can_clean.parent_struct,
  &_systemd1_unit_property_info_can_freeze.parent_struct,
  &_systemd1_unit_property_info_job.parent_struct,
  &_systemd1_unit_property_info_stop_when_unneeded.parent_struct,
  &_systemd1_unit_property_info_refuse_manual_start.parent_struct,
  &_systemd1_unit_property_info_refuse_manual_stop.parent_struct,
  &_systemd1_unit_property_info_allow_isolate.parent_struct,
  &_systemd1_unit_property_info_default_dependencies.parent_struct,
  &_systemd1_unit_property_info_on_success_job_mode.parent_struct,
  &_systemd1_unit_property_info_on_failure_job_mode.parent_struct,
  &_systemd1_unit_property_info_ignore_on_isolate.parent_struct,
  &_systemd1_unit_property_info_need_daemon_reload.parent_struct,
  &_systemd1_unit_property_info_markers.parent_struct,
  &_systemd1_unit_property_info_job_timeout_usec.parent_struct,
  &_systemd1_unit_property_info_job_running_timeout_usec.parent_struct,
  &_systemd1_unit_property_info_job_timeout_action.parent_struct,
  &_systemd1_unit_property_info_job_timeout_reboot_argument.parent_struct,
  &_systemd1_unit_property_info_condition_result.parent_struct,
  &_systemd1_unit_property_info_assert_result.parent_struct,
  &_systemd1_unit_property_info_condition_timestamp.parent_struct,
  &_systemd1_unit_property_info_condition_timestamp_monotonic.parent_struct,
  &_systemd1_unit_property_info_assert_timestamp.parent_struct,
  &_systemd1_unit_property_info_assert_timestamp_monotonic.parent_struct,
  &_systemd1_unit_property_info_conditions.parent_struct,
  &_systemd1_unit_property_info_asserts.parent_struct,
  &_systemd1_unit_property_info_load_error.parent_struct,
  &_systemd1_unit_property_info_transient.parent_struct,
  &_systemd1_unit_property_info_perpetual.parent_struct,
  &_systemd1_unit_property_info_start_limit_interval_usec.parent_struct,
  &_systemd1_unit_property_info_start_limit_burst.parent_struct,
  &_systemd1_unit_property_info_start_limit_action.parent_struct,
  &_systemd1_unit_property_info_failure_action.parent_struct,
  &_systemd1_unit_property_info_failure_action_exit_status.parent_struct,
  &_systemd1_unit_property_info_success_action.parent_struct,
  &_systemd1_unit_property_info_success_action_exit_status.parent_struct,
  &_systemd1_unit_property_info_reboot_argument.parent_struct,
  &_systemd1_unit_property_info_invocation_id.parent_struct,
  &_systemd1_unit_property_info_collect_mode.parent_struct,
  &_systemd1_unit_property_info_refs.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _systemd1_unit_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.systemd1.Unit",
    (GDBusMethodInfo **) &_systemd1_unit_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_systemd1_unit_property_info_pointers,
    NULL
  },
  "systemd1-unit",
};


/**
 * systemd1_unit_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-systemd1-Unit.top_of_page">org.freedesktop.systemd1.Unit</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
systemd1_unit_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_systemd1_unit_interface_info.parent_struct;
}

/**
 * systemd1_unit_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Systemd1Unit interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
systemd1_unit_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "id");
  g_object_class_override_property (klass, property_id_begin++, "names");
  g_object_class_override_property (klass, property_id_begin++, "following");
  g_object_class_override_property (klass, property_id_begin++, "requires");
  g_object_class_override_property (klass, property_id_begin++, "requisite");
  g_object_class_override_property (klass, property_id_begin++, "wants");
  g_object_class_override_property (klass, property_id_begin++, "binds-to");
  g_object_class_override_property (klass, property_id_begin++, "part-of");
  g_object_class_override_property (klass, property_id_begin++, "required-by");
  g_object_class_override_property (klass, property_id_begin++, "requisite-of");
  g_object_class_override_property (klass, property_id_begin++, "wanted-by");
  g_object_class_override_property (klass, property_id_begin++, "bound-by");
  g_object_class_override_property (klass, property_id_begin++, "consists-of");
  g_object_class_override_property (klass, property_id_begin++, "conflicts");
  g_object_class_override_property (klass, property_id_begin++, "conflicted-by");
  g_object_class_override_property (klass, property_id_begin++, "before");
  g_object_class_override_property (klass, property_id_begin++, "after");
  g_object_class_override_property (klass, property_id_begin++, "on-failure");
  g_object_class_override_property (klass, property_id_begin++, "on-failure-of");
  g_object_class_override_property (klass, property_id_begin++, "on-success");
  g_object_class_override_property (klass, property_id_begin++, "on-success-of");
  g_object_class_override_property (klass, property_id_begin++, "triggers");
  g_object_class_override_property (klass, property_id_begin++, "triggered-by");
  g_object_class_override_property (klass, property_id_begin++, "propagates-reload-to");
  g_object_class_override_property (klass, property_id_begin++, "reload-propagated-from");
  g_object_class_override_property (klass, property_id_begin++, "propagates-stop-to");
  g_object_class_override_property (klass, property_id_begin++, "stop-propagated-from");
  g_object_class_override_property (klass, property_id_begin++, "joins-namespace-of");
  g_object_class_override_property (klass, property_id_begin++, "slice-of");
  g_object_class_override_property (klass, property_id_begin++, "requires-mounts-for");
  g_object_class_override_property (klass, property_id_begin++, "documentation");
  g_object_class_override_property (klass, property_id_begin++, "description");
  g_object_class_override_property (klass, property_id_begin++, "load-state");
  g_object_class_override_property (klass, property_id_begin++, "active-state");
  g_object_class_override_property (klass, property_id_begin++, "freezer-state");
  g_object_class_override_property (klass, property_id_begin++, "sub-state");
  g_object_class_override_property (klass, property_id_begin++, "fragment-path");
  g_object_class_override_property (klass, property_id_begin++, "source-path");
  g_object_class_override_property (klass, property_id_begin++, "drop-in-paths");
  g_object_class_override_property (klass, property_id_begin++, "unit-file-state");
  g_object_class_override_property (klass, property_id_begin++, "unit-file-preset");
  g_object_class_override_property (klass, property_id_begin++, "state-change-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "state-change-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "inactive-exit-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "inactive-exit-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "active-enter-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "active-enter-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "active-exit-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "active-exit-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "inactive-enter-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "inactive-enter-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "can-start");
  g_object_class_override_property (klass, property_id_begin++, "can-stop");
  g_object_class_override_property (klass, property_id_begin++, "can-reload");
  g_object_class_override_property (klass, property_id_begin++, "can-isolate");
  g_object_class_override_property (klass, property_id_begin++, "can-clean");
  g_object_class_override_property (klass, property_id_begin++, "can-freeze");
  g_object_class_override_property (klass, property_id_begin++, "job");
  g_object_class_override_property (klass, property_id_begin++, "stop-when-unneeded");
  g_object_class_override_property (klass, property_id_begin++, "refuse-manual-start");
  g_object_class_override_property (klass, property_id_begin++, "refuse-manual-stop");
  g_object_class_override_property (klass, property_id_begin++, "allow-isolate");
  g_object_class_override_property (klass, property_id_begin++, "default-dependencies");
  g_object_class_override_property (klass, property_id_begin++, "on-success-job-mode");
  g_object_class_override_property (klass, property_id_begin++, "on-failure-job-mode");
  g_object_class_override_property (klass, property_id_begin++, "ignore-on-isolate");
  g_object_class_override_property (klass, property_id_begin++, "need-daemon-reload");
  g_object_class_override_property (klass, property_id_begin++, "markers");
  g_object_class_override_property (klass, property_id_begin++, "job-timeout-usec");
  g_object_class_override_property (klass, property_id_begin++, "job-running-timeout-usec");
  g_object_class_override_property (klass, property_id_begin++, "job-timeout-action");
  g_object_class_override_property (klass, property_id_begin++, "job-timeout-reboot-argument");
  g_object_class_override_property (klass, property_id_begin++, "condition-result");
  g_object_class_override_property (klass, property_id_begin++, "assert-result");
  g_object_class_override_property (klass, property_id_begin++, "condition-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "condition-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "assert-timestamp");
  g_object_class_override_property (klass, property_id_begin++, "assert-timestamp-monotonic");
  g_object_class_override_property (klass, property_id_begin++, "conditions");
  g_object_class_override_property (klass, property_id_begin++, "asserts");
  g_object_class_override_property (klass, property_id_begin++, "load-error");
  g_object_class_override_property (klass, property_id_begin++, "transient");
  g_object_class_override_property (klass, property_id_begin++, "perpetual");
  g_object_class_override_property (klass, property_id_begin++, "start-limit-interval-usec");
  g_object_class_override_property (klass, property_id_begin++, "start-limit-burst");
  g_object_class_override_property (klass, property_id_begin++, "start-limit-action");
  g_object_class_override_property (klass, property_id_begin++, "failure-action");
  g_object_class_override_property (klass, property_id_begin++, "failure-action-exit-status");
  g_object_class_override_property (klass, property_id_begin++, "success-action");
  g_object_class_override_property (klass, property_id_begin++, "success-action-exit-status");
  g_object_class_override_property (klass, property_id_begin++, "reboot-argument");
  g_object_class_override_property (klass, property_id_begin++, "invocation-id");
  g_object_class_override_property (klass, property_id_begin++, "collect-mode");
  g_object_class_override_property (klass, property_id_begin++, "refs");
  return property_id_begin - 1;
}



/**
 * Systemd1Unit:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-systemd1-Unit.top_of_page">org.freedesktop.systemd1.Unit</link>.
 */

/**
 * Systemd1UnitIface:
 * @parent_iface: The parent interface.
 * @handle_clean: Handler for the #Systemd1Unit::handle-clean signal.
 * @handle_enqueue_job: Handler for the #Systemd1Unit::handle-enqueue-job signal.
 * @handle_freeze: Handler for the #Systemd1Unit::handle-freeze signal.
 * @handle_kill: Handler for the #Systemd1Unit::handle-kill signal.
 * @handle_ref: Handler for the #Systemd1Unit::handle-ref signal.
 * @handle_reload: Handler for the #Systemd1Unit::handle-reload signal.
 * @handle_reload_or_restart: Handler for the #Systemd1Unit::handle-reload-or-restart signal.
 * @handle_reload_or_try_restart: Handler for the #Systemd1Unit::handle-reload-or-try-restart signal.
 * @handle_reset_failed: Handler for the #Systemd1Unit::handle-reset-failed signal.
 * @handle_restart: Handler for the #Systemd1Unit::handle-restart signal.
 * @handle_set_properties: Handler for the #Systemd1Unit::handle-set-properties signal.
 * @handle_start: Handler for the #Systemd1Unit::handle-start signal.
 * @handle_stop: Handler for the #Systemd1Unit::handle-stop signal.
 * @handle_thaw: Handler for the #Systemd1Unit::handle-thaw signal.
 * @handle_try_restart: Handler for the #Systemd1Unit::handle-try-restart signal.
 * @handle_unref: Handler for the #Systemd1Unit::handle-unref signal.
 * @get_active_enter_timestamp: Getter for the #Systemd1Unit:active-enter-timestamp property.
 * @get_active_enter_timestamp_monotonic: Getter for the #Systemd1Unit:active-enter-timestamp-monotonic property.
 * @get_active_exit_timestamp: Getter for the #Systemd1Unit:active-exit-timestamp property.
 * @get_active_exit_timestamp_monotonic: Getter for the #Systemd1Unit:active-exit-timestamp-monotonic property.
 * @get_active_state: Getter for the #Systemd1Unit:active-state property.
 * @get_after: Getter for the #Systemd1Unit:after property.
 * @get_allow_isolate: Getter for the #Systemd1Unit:allow-isolate property.
 * @get_assert_result: Getter for the #Systemd1Unit:assert-result property.
 * @get_assert_timestamp: Getter for the #Systemd1Unit:assert-timestamp property.
 * @get_assert_timestamp_monotonic: Getter for the #Systemd1Unit:assert-timestamp-monotonic property.
 * @get_asserts: Getter for the #Systemd1Unit:asserts property.
 * @get_before: Getter for the #Systemd1Unit:before property.
 * @get_binds_to: Getter for the #Systemd1Unit:binds-to property.
 * @get_bound_by: Getter for the #Systemd1Unit:bound-by property.
 * @get_can_clean: Getter for the #Systemd1Unit:can-clean property.
 * @get_can_freeze: Getter for the #Systemd1Unit:can-freeze property.
 * @get_can_isolate: Getter for the #Systemd1Unit:can-isolate property.
 * @get_can_reload: Getter for the #Systemd1Unit:can-reload property.
 * @get_can_start: Getter for the #Systemd1Unit:can-start property.
 * @get_can_stop: Getter for the #Systemd1Unit:can-stop property.
 * @get_collect_mode: Getter for the #Systemd1Unit:collect-mode property.
 * @get_condition_result: Getter for the #Systemd1Unit:condition-result property.
 * @get_condition_timestamp: Getter for the #Systemd1Unit:condition-timestamp property.
 * @get_condition_timestamp_monotonic: Getter for the #Systemd1Unit:condition-timestamp-monotonic property.
 * @get_conditions: Getter for the #Systemd1Unit:conditions property.
 * @get_conflicted_by: Getter for the #Systemd1Unit:conflicted-by property.
 * @get_conflicts: Getter for the #Systemd1Unit:conflicts property.
 * @get_consists_of: Getter for the #Systemd1Unit:consists-of property.
 * @get_default_dependencies: Getter for the #Systemd1Unit:default-dependencies property.
 * @get_description: Getter for the #Systemd1Unit:description property.
 * @get_documentation: Getter for the #Systemd1Unit:documentation property.
 * @get_drop_in_paths: Getter for the #Systemd1Unit:drop-in-paths property.
 * @get_failure_action: Getter for the #Systemd1Unit:failure-action property.
 * @get_failure_action_exit_status: Getter for the #Systemd1Unit:failure-action-exit-status property.
 * @get_following: Getter for the #Systemd1Unit:following property.
 * @get_fragment_path: Getter for the #Systemd1Unit:fragment-path property.
 * @get_freezer_state: Getter for the #Systemd1Unit:freezer-state property.
 * @get_id: Getter for the #Systemd1Unit:id property.
 * @get_ignore_on_isolate: Getter for the #Systemd1Unit:ignore-on-isolate property.
 * @get_inactive_enter_timestamp: Getter for the #Systemd1Unit:inactive-enter-timestamp property.
 * @get_inactive_enter_timestamp_monotonic: Getter for the #Systemd1Unit:inactive-enter-timestamp-monotonic property.
 * @get_inactive_exit_timestamp: Getter for the #Systemd1Unit:inactive-exit-timestamp property.
 * @get_inactive_exit_timestamp_monotonic: Getter for the #Systemd1Unit:inactive-exit-timestamp-monotonic property.
 * @get_invocation_id: Getter for the #Systemd1Unit:invocation-id property.
 * @get_job: Getter for the #Systemd1Unit:job property.
 * @get_job_running_timeout_usec: Getter for the #Systemd1Unit:job-running-timeout-usec property.
 * @get_job_timeout_action: Getter for the #Systemd1Unit:job-timeout-action property.
 * @get_job_timeout_reboot_argument: Getter for the #Systemd1Unit:job-timeout-reboot-argument property.
 * @get_job_timeout_usec: Getter for the #Systemd1Unit:job-timeout-usec property.
 * @get_joins_namespace_of: Getter for the #Systemd1Unit:joins-namespace-of property.
 * @get_load_error: Getter for the #Systemd1Unit:load-error property.
 * @get_load_state: Getter for the #Systemd1Unit:load-state property.
 * @get_markers: Getter for the #Systemd1Unit:markers property.
 * @get_names: Getter for the #Systemd1Unit:names property.
 * @get_need_daemon_reload: Getter for the #Systemd1Unit:need-daemon-reload property.
 * @get_on_failure: Getter for the #Systemd1Unit:on-failure property.
 * @get_on_failure_job_mode: Getter for the #Systemd1Unit:on-failure-job-mode property.
 * @get_on_failure_of: Getter for the #Systemd1Unit:on-failure-of property.
 * @get_on_success: Getter for the #Systemd1Unit:on-success property.
 * @get_on_success_job_mode: Getter for the #Systemd1Unit:on-success-job-mode property.
 * @get_on_success_of: Getter for the #Systemd1Unit:on-success-of property.
 * @get_part_of: Getter for the #Systemd1Unit:part-of property.
 * @get_perpetual: Getter for the #Systemd1Unit:perpetual property.
 * @get_propagates_reload_to: Getter for the #Systemd1Unit:propagates-reload-to property.
 * @get_propagates_stop_to: Getter for the #Systemd1Unit:propagates-stop-to property.
 * @get_reboot_argument: Getter for the #Systemd1Unit:reboot-argument property.
 * @get_refs: Getter for the #Systemd1Unit:refs property.
 * @get_refuse_manual_start: Getter for the #Systemd1Unit:refuse-manual-start property.
 * @get_refuse_manual_stop: Getter for the #Systemd1Unit:refuse-manual-stop property.
 * @get_reload_propagated_from: Getter for the #Systemd1Unit:reload-propagated-from property.
 * @get_required_by: Getter for the #Systemd1Unit:required-by property.
 * @get_requires: Getter for the #Systemd1Unit:requires property.
 * @get_requires_mounts_for: Getter for the #Systemd1Unit:requires-mounts-for property.
 * @get_requisite: Getter for the #Systemd1Unit:requisite property.
 * @get_requisite_of: Getter for the #Systemd1Unit:requisite-of property.
 * @get_slice_of: Getter for the #Systemd1Unit:slice-of property.
 * @get_source_path: Getter for the #Systemd1Unit:source-path property.
 * @get_start_limit_action: Getter for the #Systemd1Unit:start-limit-action property.
 * @get_start_limit_burst: Getter for the #Systemd1Unit:start-limit-burst property.
 * @get_start_limit_interval_usec: Getter for the #Systemd1Unit:start-limit-interval-usec property.
 * @get_state_change_timestamp: Getter for the #Systemd1Unit:state-change-timestamp property.
 * @get_state_change_timestamp_monotonic: Getter for the #Systemd1Unit:state-change-timestamp-monotonic property.
 * @get_stop_propagated_from: Getter for the #Systemd1Unit:stop-propagated-from property.
 * @get_stop_when_unneeded: Getter for the #Systemd1Unit:stop-when-unneeded property.
 * @get_sub_state: Getter for the #Systemd1Unit:sub-state property.
 * @get_success_action: Getter for the #Systemd1Unit:success-action property.
 * @get_success_action_exit_status: Getter for the #Systemd1Unit:success-action-exit-status property.
 * @get_transient: Getter for the #Systemd1Unit:transient property.
 * @get_triggered_by: Getter for the #Systemd1Unit:triggered-by property.
 * @get_triggers: Getter for the #Systemd1Unit:triggers property.
 * @get_unit_file_preset: Getter for the #Systemd1Unit:unit-file-preset property.
 * @get_unit_file_state: Getter for the #Systemd1Unit:unit-file-state property.
 * @get_wanted_by: Getter for the #Systemd1Unit:wanted-by property.
 * @get_wants: Getter for the #Systemd1Unit:wants property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-systemd1-Unit.top_of_page">org.freedesktop.systemd1.Unit</link>.
 */

typedef Systemd1UnitIface Systemd1UnitInterface;
G_DEFINE_INTERFACE (Systemd1Unit, systemd1_unit, G_TYPE_OBJECT)

static void
systemd1_unit_default_init (Systemd1UnitIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * Systemd1Unit::handle-start:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Unit::handle-stop:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Unit::handle-reload:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Reload">Reload()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_reload() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reload",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_reload),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Unit::handle-restart:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Restart">Restart()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_restart() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-restart",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_restart),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Unit::handle-try-restart:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.TryRestart">TryRestart()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_try_restart() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-try-restart",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_try_restart),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Unit::handle-reload-or-restart:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.ReloadOrRestart">ReloadOrRestart()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_reload_or_restart() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reload-or-restart",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_reload_or_restart),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Unit::handle-reload-or-try-restart:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.ReloadOrTryRestart">ReloadOrTryRestart()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_reload_or_try_restart() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reload-or-try-restart",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_reload_or_try_restart),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * Systemd1Unit::handle-enqueue-job:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_job_type: Argument passed by remote caller.
   * @arg_job_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.EnqueueJob">EnqueueJob()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_enqueue_job() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enqueue-job",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_enqueue_job),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * Systemd1Unit::handle-kill:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_whom: Argument passed by remote caller.
   * @arg_signal: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Kill">Kill()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_kill() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-kill",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_kill),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_INT);

  /**
   * Systemd1Unit::handle-reset-failed:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.ResetFailed">ResetFailed()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_reset_failed() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reset-failed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_reset_failed),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Unit::handle-set-properties:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_runtime: Argument passed by remote caller.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.SetProperties">SetProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_set_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_set_properties),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_VARIANT);

  /**
   * Systemd1Unit::handle-ref:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Ref">Ref()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_ref() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-ref",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_ref),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Unit::handle-unref:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Unref">Unref()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_unref() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unref",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_unref),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Unit::handle-clean:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mask: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Clean">Clean()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_clean() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-clean",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_clean),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * Systemd1Unit::handle-freeze:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Freeze">Freeze()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_freeze() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-freeze",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_freeze),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Systemd1Unit::handle-thaw:
   * @object: A #Systemd1Unit.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Thaw">Thaw()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call systemd1_unit_complete_thaw() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-thaw",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Systemd1UnitIface, handle_thaw),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * Systemd1Unit:id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Id">"Id"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("id", "Id", "Id", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:names:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Names">"Names"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("names", "Names", "Names", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:following:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Following">"Following"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("following", "Following", "Following", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:requires:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Requires">"Requires"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("requires", "Requires", "Requires", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:requisite:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Requisite">"Requisite"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("requisite", "Requisite", "Requisite", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:wants:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Wants">"Wants"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("wants", "Wants", "Wants", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:binds-to:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.BindsTo">"BindsTo"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("binds-to", "BindsTo", "BindsTo", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:part-of:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.PartOf">"PartOf"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("part-of", "PartOf", "PartOf", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:required-by:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RequiredBy">"RequiredBy"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("required-by", "RequiredBy", "RequiredBy", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:requisite-of:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RequisiteOf">"RequisiteOf"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("requisite-of", "RequisiteOf", "RequisiteOf", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:wanted-by:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.WantedBy">"WantedBy"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("wanted-by", "WantedBy", "WantedBy", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:bound-by:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.BoundBy">"BoundBy"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("bound-by", "BoundBy", "BoundBy", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:consists-of:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConsistsOf">"ConsistsOf"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("consists-of", "ConsistsOf", "ConsistsOf", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:conflicts:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Conflicts">"Conflicts"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("conflicts", "Conflicts", "Conflicts", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:conflicted-by:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConflictedBy">"ConflictedBy"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("conflicted-by", "ConflictedBy", "ConflictedBy", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:before:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Before">"Before"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("before", "Before", "Before", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:after:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.After">"After"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("after", "After", "After", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:on-failure:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnFailure">"OnFailure"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("on-failure", "OnFailure", "OnFailure", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:on-failure-of:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnFailureOf">"OnFailureOf"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("on-failure-of", "OnFailureOf", "OnFailureOf", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:on-success:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnSuccess">"OnSuccess"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("on-success", "OnSuccess", "OnSuccess", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:on-success-of:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnSuccessOf">"OnSuccessOf"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("on-success-of", "OnSuccessOf", "OnSuccessOf", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:triggers:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Triggers">"Triggers"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("triggers", "Triggers", "Triggers", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:triggered-by:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.TriggeredBy">"TriggeredBy"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("triggered-by", "TriggeredBy", "TriggeredBy", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:propagates-reload-to:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.PropagatesReloadTo">"PropagatesReloadTo"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("propagates-reload-to", "PropagatesReloadTo", "PropagatesReloadTo", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:reload-propagated-from:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ReloadPropagatedFrom">"ReloadPropagatedFrom"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("reload-propagated-from", "ReloadPropagatedFrom", "ReloadPropagatedFrom", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:propagates-stop-to:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.PropagatesStopTo">"PropagatesStopTo"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("propagates-stop-to", "PropagatesStopTo", "PropagatesStopTo", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:stop-propagated-from:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StopPropagatedFrom">"StopPropagatedFrom"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("stop-propagated-from", "StopPropagatedFrom", "StopPropagatedFrom", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:joins-namespace-of:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JoinsNamespaceOf">"JoinsNamespaceOf"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("joins-namespace-of", "JoinsNamespaceOf", "JoinsNamespaceOf", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:slice-of:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SliceOf">"SliceOf"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("slice-of", "SliceOf", "SliceOf", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:requires-mounts-for:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RequiresMountsFor">"RequiresMountsFor"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("requires-mounts-for", "RequiresMountsFor", "RequiresMountsFor", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:documentation:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Documentation">"Documentation"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("documentation", "Documentation", "Documentation", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:description:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Description">"Description"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("description", "Description", "Description", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:load-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.LoadState">"LoadState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("load-state", "LoadState", "LoadState", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:active-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveState">"ActiveState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("active-state", "ActiveState", "ActiveState", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:freezer-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FreezerState">"FreezerState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("freezer-state", "FreezerState", "FreezerState", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:sub-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SubState">"SubState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("sub-state", "SubState", "SubState", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:fragment-path:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FragmentPath">"FragmentPath"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("fragment-path", "FragmentPath", "FragmentPath", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:source-path:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SourcePath">"SourcePath"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("source-path", "SourcePath", "SourcePath", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:drop-in-paths:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.DropInPaths">"DropInPaths"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("drop-in-paths", "DropInPaths", "DropInPaths", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:unit-file-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.UnitFileState">"UnitFileState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("unit-file-state", "UnitFileState", "UnitFileState", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:unit-file-preset:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.UnitFilePreset">"UnitFilePreset"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("unit-file-preset", "UnitFilePreset", "UnitFilePreset", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:state-change-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StateChangeTimestamp">"StateChangeTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("state-change-timestamp", "StateChangeTimestamp", "StateChangeTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:state-change-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StateChangeTimestampMonotonic">"StateChangeTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("state-change-timestamp-monotonic", "StateChangeTimestampMonotonic", "StateChangeTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:inactive-exit-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InactiveExitTimestamp">"InactiveExitTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("inactive-exit-timestamp", "InactiveExitTimestamp", "InactiveExitTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:inactive-exit-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InactiveExitTimestampMonotonic">"InactiveExitTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("inactive-exit-timestamp-monotonic", "InactiveExitTimestampMonotonic", "InactiveExitTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:active-enter-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveEnterTimestamp">"ActiveEnterTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("active-enter-timestamp", "ActiveEnterTimestamp", "ActiveEnterTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:active-enter-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveEnterTimestampMonotonic">"ActiveEnterTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("active-enter-timestamp-monotonic", "ActiveEnterTimestampMonotonic", "ActiveEnterTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:active-exit-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveExitTimestamp">"ActiveExitTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("active-exit-timestamp", "ActiveExitTimestamp", "ActiveExitTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:active-exit-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveExitTimestampMonotonic">"ActiveExitTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("active-exit-timestamp-monotonic", "ActiveExitTimestampMonotonic", "ActiveExitTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:inactive-enter-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InactiveEnterTimestamp">"InactiveEnterTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("inactive-enter-timestamp", "InactiveEnterTimestamp", "InactiveEnterTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:inactive-enter-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InactiveEnterTimestampMonotonic">"InactiveEnterTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("inactive-enter-timestamp-monotonic", "InactiveEnterTimestampMonotonic", "InactiveEnterTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:can-start:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanStart">"CanStart"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-start", "CanStart", "CanStart", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:can-stop:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanStop">"CanStop"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-stop", "CanStop", "CanStop", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:can-reload:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanReload">"CanReload"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-reload", "CanReload", "CanReload", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:can-isolate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanIsolate">"CanIsolate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-isolate", "CanIsolate", "CanIsolate", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:can-clean:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanClean">"CanClean"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("can-clean", "CanClean", "CanClean", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:can-freeze:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanFreeze">"CanFreeze"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-freeze", "CanFreeze", "CanFreeze", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:job:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Job">"Job"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("job", "Job", "Job", G_VARIANT_TYPE ("(uo)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:stop-when-unneeded:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StopWhenUnneeded">"StopWhenUnneeded"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("stop-when-unneeded", "StopWhenUnneeded", "StopWhenUnneeded", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:refuse-manual-start:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RefuseManualStart">"RefuseManualStart"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("refuse-manual-start", "RefuseManualStart", "RefuseManualStart", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:refuse-manual-stop:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RefuseManualStop">"RefuseManualStop"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("refuse-manual-stop", "RefuseManualStop", "RefuseManualStop", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:allow-isolate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.AllowIsolate">"AllowIsolate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("allow-isolate", "AllowIsolate", "AllowIsolate", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:default-dependencies:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.DefaultDependencies">"DefaultDependencies"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("default-dependencies", "DefaultDependencies", "DefaultDependencies", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:on-success-job-mode:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnSuccessJobMode">"OnSuccessJobMode"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("on-success-job-mode", "OnSuccessJobMode", "OnSuccessJobMode", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:on-failure-job-mode:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnFailureJobMode">"OnFailureJobMode"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("on-failure-job-mode", "OnFailureJobMode", "OnFailureJobMode", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:ignore-on-isolate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.IgnoreOnIsolate">"IgnoreOnIsolate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("ignore-on-isolate", "IgnoreOnIsolate", "IgnoreOnIsolate", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:need-daemon-reload:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.NeedDaemonReload">"NeedDaemonReload"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("need-daemon-reload", "NeedDaemonReload", "NeedDaemonReload", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:markers:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Markers">"Markers"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("markers", "Markers", "Markers", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:job-timeout-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobTimeoutUSec">"JobTimeoutUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("job-timeout-usec", "JobTimeoutUSec", "JobTimeoutUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:job-running-timeout-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobRunningTimeoutUSec">"JobRunningTimeoutUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("job-running-timeout-usec", "JobRunningTimeoutUSec", "JobRunningTimeoutUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:job-timeout-action:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobTimeoutAction">"JobTimeoutAction"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("job-timeout-action", "JobTimeoutAction", "JobTimeoutAction", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:job-timeout-reboot-argument:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobTimeoutRebootArgument">"JobTimeoutRebootArgument"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("job-timeout-reboot-argument", "JobTimeoutRebootArgument", "JobTimeoutRebootArgument", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:condition-result:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConditionResult">"ConditionResult"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("condition-result", "ConditionResult", "ConditionResult", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:assert-result:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.AssertResult">"AssertResult"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("assert-result", "AssertResult", "AssertResult", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:condition-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConditionTimestamp">"ConditionTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("condition-timestamp", "ConditionTimestamp", "ConditionTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:condition-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConditionTimestampMonotonic">"ConditionTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("condition-timestamp-monotonic", "ConditionTimestampMonotonic", "ConditionTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:assert-timestamp:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.AssertTimestamp">"AssertTimestamp"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("assert-timestamp", "AssertTimestamp", "AssertTimestamp", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:assert-timestamp-monotonic:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.AssertTimestampMonotonic">"AssertTimestampMonotonic"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("assert-timestamp-monotonic", "AssertTimestampMonotonic", "AssertTimestampMonotonic", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:conditions:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Conditions">"Conditions"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("conditions", "Conditions", "Conditions", G_VARIANT_TYPE ("a(sbbsi)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:asserts:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Asserts">"Asserts"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("asserts", "Asserts", "Asserts", G_VARIANT_TYPE ("a(sbbsi)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:load-error:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.LoadError">"LoadError"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("load-error", "LoadError", "LoadError", G_VARIANT_TYPE ("(ss)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:transient:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Transient">"Transient"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("transient", "Transient", "Transient", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:perpetual:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Perpetual">"Perpetual"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("perpetual", "Perpetual", "Perpetual", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:start-limit-interval-usec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StartLimitIntervalUSec">"StartLimitIntervalUSec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("start-limit-interval-usec", "StartLimitIntervalUSec", "StartLimitIntervalUSec", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:start-limit-burst:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StartLimitBurst">"StartLimitBurst"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("start-limit-burst", "StartLimitBurst", "StartLimitBurst", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:start-limit-action:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StartLimitAction">"StartLimitAction"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("start-limit-action", "StartLimitAction", "StartLimitAction", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:failure-action:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FailureAction">"FailureAction"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("failure-action", "FailureAction", "FailureAction", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:failure-action-exit-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FailureActionExitStatus">"FailureActionExitStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("failure-action-exit-status", "FailureActionExitStatus", "FailureActionExitStatus", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:success-action:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SuccessAction">"SuccessAction"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("success-action", "SuccessAction", "SuccessAction", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:success-action-exit-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SuccessActionExitStatus">"SuccessActionExitStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("success-action-exit-status", "SuccessActionExitStatus", "SuccessActionExitStatus", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:reboot-argument:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RebootArgument">"RebootArgument"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("reboot-argument", "RebootArgument", "RebootArgument", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:invocation-id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InvocationID">"InvocationID"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("invocation-id", "InvocationID", "InvocationID", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:collect-mode:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CollectMode">"CollectMode"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("collect-mode", "CollectMode", "CollectMode", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * Systemd1Unit:refs:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Refs">"Refs"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("refs", "Refs", "Refs", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * systemd1_unit_get_id: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_id (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_id (object);
}

/**
 * systemd1_unit_dup_id: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_id (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "id", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_id: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Id">"Id"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_id (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "id", value, NULL);
}

/**
 * systemd1_unit_get_names: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Names">"Names"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_names() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_names (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_names (object);
}

/**
 * systemd1_unit_dup_names: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Names">"Names"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_names (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "names", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_names: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Names">"Names"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_names (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "names", value, NULL);
}

/**
 * systemd1_unit_get_following: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Following">"Following"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_following() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_following (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_following (object);
}

/**
 * systemd1_unit_dup_following: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Following">"Following"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_following (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "following", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_following: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Following">"Following"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_following (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "following", value, NULL);
}

/**
 * systemd1_unit_get_requires: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Requires">"Requires"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_requires() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_requires (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_requires (object);
}

/**
 * systemd1_unit_dup_requires: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Requires">"Requires"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_requires (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "requires", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_requires: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Requires">"Requires"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_requires (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "requires", value, NULL);
}

/**
 * systemd1_unit_get_requisite: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Requisite">"Requisite"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_requisite() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_requisite (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_requisite (object);
}

/**
 * systemd1_unit_dup_requisite: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Requisite">"Requisite"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_requisite (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "requisite", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_requisite: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Requisite">"Requisite"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_requisite (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "requisite", value, NULL);
}

/**
 * systemd1_unit_get_wants: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Wants">"Wants"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_wants() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_wants (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_wants (object);
}

/**
 * systemd1_unit_dup_wants: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Wants">"Wants"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_wants (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "wants", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_wants: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Wants">"Wants"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_wants (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "wants", value, NULL);
}

/**
 * systemd1_unit_get_binds_to: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.BindsTo">"BindsTo"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_binds_to() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_binds_to (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_binds_to (object);
}

/**
 * systemd1_unit_dup_binds_to: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.BindsTo">"BindsTo"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_binds_to (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "binds-to", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_binds_to: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.BindsTo">"BindsTo"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_binds_to (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "binds-to", value, NULL);
}

/**
 * systemd1_unit_get_part_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.PartOf">"PartOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_part_of() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_part_of (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_part_of (object);
}

/**
 * systemd1_unit_dup_part_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.PartOf">"PartOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_part_of (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "part-of", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_part_of: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.PartOf">"PartOf"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_part_of (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "part-of", value, NULL);
}

/**
 * systemd1_unit_get_required_by: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RequiredBy">"RequiredBy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_required_by() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_required_by (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_required_by (object);
}

/**
 * systemd1_unit_dup_required_by: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RequiredBy">"RequiredBy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_required_by (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "required-by", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_required_by: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RequiredBy">"RequiredBy"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_required_by (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "required-by", value, NULL);
}

/**
 * systemd1_unit_get_requisite_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RequisiteOf">"RequisiteOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_requisite_of() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_requisite_of (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_requisite_of (object);
}

/**
 * systemd1_unit_dup_requisite_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RequisiteOf">"RequisiteOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_requisite_of (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "requisite-of", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_requisite_of: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RequisiteOf">"RequisiteOf"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_requisite_of (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "requisite-of", value, NULL);
}

/**
 * systemd1_unit_get_wanted_by: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.WantedBy">"WantedBy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_wanted_by() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_wanted_by (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_wanted_by (object);
}

/**
 * systemd1_unit_dup_wanted_by: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.WantedBy">"WantedBy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_wanted_by (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "wanted-by", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_wanted_by: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.WantedBy">"WantedBy"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_wanted_by (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "wanted-by", value, NULL);
}

/**
 * systemd1_unit_get_bound_by: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.BoundBy">"BoundBy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_bound_by() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_bound_by (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_bound_by (object);
}

/**
 * systemd1_unit_dup_bound_by: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.BoundBy">"BoundBy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_bound_by (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "bound-by", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_bound_by: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.BoundBy">"BoundBy"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_bound_by (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "bound-by", value, NULL);
}

/**
 * systemd1_unit_get_consists_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConsistsOf">"ConsistsOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_consists_of() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_consists_of (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_consists_of (object);
}

/**
 * systemd1_unit_dup_consists_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConsistsOf">"ConsistsOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_consists_of (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "consists-of", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_consists_of: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConsistsOf">"ConsistsOf"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_consists_of (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "consists-of", value, NULL);
}

/**
 * systemd1_unit_get_conflicts: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Conflicts">"Conflicts"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_conflicts() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_conflicts (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_conflicts (object);
}

/**
 * systemd1_unit_dup_conflicts: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Conflicts">"Conflicts"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_conflicts (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "conflicts", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_conflicts: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Conflicts">"Conflicts"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_conflicts (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "conflicts", value, NULL);
}

/**
 * systemd1_unit_get_conflicted_by: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConflictedBy">"ConflictedBy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_conflicted_by() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_conflicted_by (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_conflicted_by (object);
}

/**
 * systemd1_unit_dup_conflicted_by: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConflictedBy">"ConflictedBy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_conflicted_by (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "conflicted-by", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_conflicted_by: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConflictedBy">"ConflictedBy"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_conflicted_by (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "conflicted-by", value, NULL);
}

/**
 * systemd1_unit_get_before: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Before">"Before"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_before() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_before (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_before (object);
}

/**
 * systemd1_unit_dup_before: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Before">"Before"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_before (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "before", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_before: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Before">"Before"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_before (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "before", value, NULL);
}

/**
 * systemd1_unit_get_after: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.After">"After"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_after() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_after (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_after (object);
}

/**
 * systemd1_unit_dup_after: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.After">"After"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_after (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "after", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_after: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.After">"After"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_after (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "after", value, NULL);
}

/**
 * systemd1_unit_get_on_failure: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnFailure">"OnFailure"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_on_failure() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_on_failure (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_on_failure (object);
}

/**
 * systemd1_unit_dup_on_failure: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnFailure">"OnFailure"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_on_failure (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "on-failure", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_on_failure: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnFailure">"OnFailure"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_on_failure (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "on-failure", value, NULL);
}

/**
 * systemd1_unit_get_on_failure_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnFailureOf">"OnFailureOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_on_failure_of() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_on_failure_of (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_on_failure_of (object);
}

/**
 * systemd1_unit_dup_on_failure_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnFailureOf">"OnFailureOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_on_failure_of (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "on-failure-of", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_on_failure_of: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnFailureOf">"OnFailureOf"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_on_failure_of (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "on-failure-of", value, NULL);
}

/**
 * systemd1_unit_get_on_success: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnSuccess">"OnSuccess"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_on_success() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_on_success (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_on_success (object);
}

/**
 * systemd1_unit_dup_on_success: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnSuccess">"OnSuccess"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_on_success (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "on-success", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_on_success: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnSuccess">"OnSuccess"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_on_success (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "on-success", value, NULL);
}

/**
 * systemd1_unit_get_on_success_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnSuccessOf">"OnSuccessOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_on_success_of() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_on_success_of (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_on_success_of (object);
}

/**
 * systemd1_unit_dup_on_success_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnSuccessOf">"OnSuccessOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_on_success_of (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "on-success-of", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_on_success_of: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnSuccessOf">"OnSuccessOf"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_on_success_of (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "on-success-of", value, NULL);
}

/**
 * systemd1_unit_get_triggers: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Triggers">"Triggers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_triggers() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_triggers (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_triggers (object);
}

/**
 * systemd1_unit_dup_triggers: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Triggers">"Triggers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_triggers (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "triggers", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_triggers: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Triggers">"Triggers"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_triggers (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "triggers", value, NULL);
}

/**
 * systemd1_unit_get_triggered_by: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.TriggeredBy">"TriggeredBy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_triggered_by() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_triggered_by (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_triggered_by (object);
}

/**
 * systemd1_unit_dup_triggered_by: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.TriggeredBy">"TriggeredBy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_triggered_by (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "triggered-by", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_triggered_by: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.TriggeredBy">"TriggeredBy"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_triggered_by (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "triggered-by", value, NULL);
}

/**
 * systemd1_unit_get_propagates_reload_to: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.PropagatesReloadTo">"PropagatesReloadTo"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_propagates_reload_to() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_propagates_reload_to (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_propagates_reload_to (object);
}

/**
 * systemd1_unit_dup_propagates_reload_to: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.PropagatesReloadTo">"PropagatesReloadTo"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_propagates_reload_to (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "propagates-reload-to", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_propagates_reload_to: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.PropagatesReloadTo">"PropagatesReloadTo"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_propagates_reload_to (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "propagates-reload-to", value, NULL);
}

/**
 * systemd1_unit_get_reload_propagated_from: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ReloadPropagatedFrom">"ReloadPropagatedFrom"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_reload_propagated_from() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_reload_propagated_from (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_reload_propagated_from (object);
}

/**
 * systemd1_unit_dup_reload_propagated_from: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ReloadPropagatedFrom">"ReloadPropagatedFrom"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_reload_propagated_from (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "reload-propagated-from", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_reload_propagated_from: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ReloadPropagatedFrom">"ReloadPropagatedFrom"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_reload_propagated_from (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "reload-propagated-from", value, NULL);
}

/**
 * systemd1_unit_get_propagates_stop_to: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.PropagatesStopTo">"PropagatesStopTo"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_propagates_stop_to() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_propagates_stop_to (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_propagates_stop_to (object);
}

/**
 * systemd1_unit_dup_propagates_stop_to: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.PropagatesStopTo">"PropagatesStopTo"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_propagates_stop_to (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "propagates-stop-to", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_propagates_stop_to: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.PropagatesStopTo">"PropagatesStopTo"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_propagates_stop_to (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "propagates-stop-to", value, NULL);
}

/**
 * systemd1_unit_get_stop_propagated_from: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StopPropagatedFrom">"StopPropagatedFrom"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_stop_propagated_from() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_stop_propagated_from (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_stop_propagated_from (object);
}

/**
 * systemd1_unit_dup_stop_propagated_from: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StopPropagatedFrom">"StopPropagatedFrom"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_stop_propagated_from (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "stop-propagated-from", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_stop_propagated_from: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StopPropagatedFrom">"StopPropagatedFrom"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_stop_propagated_from (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "stop-propagated-from", value, NULL);
}

/**
 * systemd1_unit_get_joins_namespace_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JoinsNamespaceOf">"JoinsNamespaceOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_joins_namespace_of() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_joins_namespace_of (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_joins_namespace_of (object);
}

/**
 * systemd1_unit_dup_joins_namespace_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JoinsNamespaceOf">"JoinsNamespaceOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_joins_namespace_of (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "joins-namespace-of", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_joins_namespace_of: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JoinsNamespaceOf">"JoinsNamespaceOf"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_joins_namespace_of (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "joins-namespace-of", value, NULL);
}

/**
 * systemd1_unit_get_slice_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SliceOf">"SliceOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_slice_of() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_slice_of (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_slice_of (object);
}

/**
 * systemd1_unit_dup_slice_of: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SliceOf">"SliceOf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_slice_of (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "slice-of", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_slice_of: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SliceOf">"SliceOf"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_slice_of (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "slice-of", value, NULL);
}

/**
 * systemd1_unit_get_requires_mounts_for: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RequiresMountsFor">"RequiresMountsFor"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_requires_mounts_for() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_requires_mounts_for (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_requires_mounts_for (object);
}

/**
 * systemd1_unit_dup_requires_mounts_for: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RequiresMountsFor">"RequiresMountsFor"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_requires_mounts_for (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "requires-mounts-for", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_requires_mounts_for: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RequiresMountsFor">"RequiresMountsFor"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_requires_mounts_for (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "requires-mounts-for", value, NULL);
}

/**
 * systemd1_unit_get_documentation: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Documentation">"Documentation"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_documentation() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_documentation (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_documentation (object);
}

/**
 * systemd1_unit_dup_documentation: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Documentation">"Documentation"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_documentation (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "documentation", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_documentation: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Documentation">"Documentation"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_documentation (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "documentation", value, NULL);
}

/**
 * systemd1_unit_get_description: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Description">"Description"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_description() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_description (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_description (object);
}

/**
 * systemd1_unit_dup_description: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Description">"Description"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_description (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "description", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_description: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Description">"Description"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_description (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "description", value, NULL);
}

/**
 * systemd1_unit_get_load_state: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.LoadState">"LoadState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_load_state() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_load_state (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_load_state (object);
}

/**
 * systemd1_unit_dup_load_state: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.LoadState">"LoadState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_load_state (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "load-state", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_load_state: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.LoadState">"LoadState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_load_state (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "load-state", value, NULL);
}

/**
 * systemd1_unit_get_active_state: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveState">"ActiveState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_active_state() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_active_state (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_active_state (object);
}

/**
 * systemd1_unit_dup_active_state: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveState">"ActiveState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_active_state (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "active-state", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_active_state: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveState">"ActiveState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_active_state (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "active-state", value, NULL);
}

/**
 * systemd1_unit_get_freezer_state: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FreezerState">"FreezerState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_freezer_state() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_freezer_state (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_freezer_state (object);
}

/**
 * systemd1_unit_dup_freezer_state: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FreezerState">"FreezerState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_freezer_state (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "freezer-state", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_freezer_state: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FreezerState">"FreezerState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_freezer_state (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "freezer-state", value, NULL);
}

/**
 * systemd1_unit_get_sub_state: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SubState">"SubState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_sub_state() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_sub_state (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_sub_state (object);
}

/**
 * systemd1_unit_dup_sub_state: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SubState">"SubState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_sub_state (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "sub-state", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_sub_state: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SubState">"SubState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_sub_state (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "sub-state", value, NULL);
}

/**
 * systemd1_unit_get_fragment_path: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FragmentPath">"FragmentPath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_fragment_path() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_fragment_path (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_fragment_path (object);
}

/**
 * systemd1_unit_dup_fragment_path: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FragmentPath">"FragmentPath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_fragment_path (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "fragment-path", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_fragment_path: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FragmentPath">"FragmentPath"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_fragment_path (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "fragment-path", value, NULL);
}

/**
 * systemd1_unit_get_source_path: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SourcePath">"SourcePath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_source_path() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_source_path (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_source_path (object);
}

/**
 * systemd1_unit_dup_source_path: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SourcePath">"SourcePath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_source_path (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "source-path", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_source_path: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SourcePath">"SourcePath"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_source_path (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "source-path", value, NULL);
}

/**
 * systemd1_unit_get_drop_in_paths: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.DropInPaths">"DropInPaths"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_drop_in_paths() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_drop_in_paths (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_drop_in_paths (object);
}

/**
 * systemd1_unit_dup_drop_in_paths: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.DropInPaths">"DropInPaths"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_drop_in_paths (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "drop-in-paths", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_drop_in_paths: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.DropInPaths">"DropInPaths"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_drop_in_paths (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "drop-in-paths", value, NULL);
}

/**
 * systemd1_unit_get_unit_file_state: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.UnitFileState">"UnitFileState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_unit_file_state() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_unit_file_state (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_unit_file_state (object);
}

/**
 * systemd1_unit_dup_unit_file_state: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.UnitFileState">"UnitFileState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_unit_file_state (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "unit-file-state", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_unit_file_state: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.UnitFileState">"UnitFileState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_unit_file_state (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "unit-file-state", value, NULL);
}

/**
 * systemd1_unit_get_unit_file_preset: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.UnitFilePreset">"UnitFilePreset"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_unit_file_preset() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_unit_file_preset (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_unit_file_preset (object);
}

/**
 * systemd1_unit_dup_unit_file_preset: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.UnitFilePreset">"UnitFilePreset"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_unit_file_preset (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "unit-file-preset", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_unit_file_preset: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.UnitFilePreset">"UnitFilePreset"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_unit_file_preset (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "unit-file-preset", value, NULL);
}

/**
 * systemd1_unit_get_state_change_timestamp: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StateChangeTimestamp">"StateChangeTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_state_change_timestamp (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_state_change_timestamp (object);
}

/**
 * systemd1_unit_set_state_change_timestamp: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StateChangeTimestamp">"StateChangeTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_state_change_timestamp (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "state-change-timestamp", value, NULL);
}

/**
 * systemd1_unit_get_state_change_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StateChangeTimestampMonotonic">"StateChangeTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_state_change_timestamp_monotonic (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_state_change_timestamp_monotonic (object);
}

/**
 * systemd1_unit_set_state_change_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StateChangeTimestampMonotonic">"StateChangeTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_state_change_timestamp_monotonic (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "state-change-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_unit_get_inactive_exit_timestamp: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InactiveExitTimestamp">"InactiveExitTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_inactive_exit_timestamp (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_inactive_exit_timestamp (object);
}

/**
 * systemd1_unit_set_inactive_exit_timestamp: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InactiveExitTimestamp">"InactiveExitTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_inactive_exit_timestamp (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "inactive-exit-timestamp", value, NULL);
}

/**
 * systemd1_unit_get_inactive_exit_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InactiveExitTimestampMonotonic">"InactiveExitTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_inactive_exit_timestamp_monotonic (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_inactive_exit_timestamp_monotonic (object);
}

/**
 * systemd1_unit_set_inactive_exit_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InactiveExitTimestampMonotonic">"InactiveExitTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_inactive_exit_timestamp_monotonic (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "inactive-exit-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_unit_get_active_enter_timestamp: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveEnterTimestamp">"ActiveEnterTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_active_enter_timestamp (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_active_enter_timestamp (object);
}

/**
 * systemd1_unit_set_active_enter_timestamp: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveEnterTimestamp">"ActiveEnterTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_active_enter_timestamp (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "active-enter-timestamp", value, NULL);
}

/**
 * systemd1_unit_get_active_enter_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveEnterTimestampMonotonic">"ActiveEnterTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_active_enter_timestamp_monotonic (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_active_enter_timestamp_monotonic (object);
}

/**
 * systemd1_unit_set_active_enter_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveEnterTimestampMonotonic">"ActiveEnterTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_active_enter_timestamp_monotonic (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "active-enter-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_unit_get_active_exit_timestamp: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveExitTimestamp">"ActiveExitTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_active_exit_timestamp (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_active_exit_timestamp (object);
}

/**
 * systemd1_unit_set_active_exit_timestamp: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveExitTimestamp">"ActiveExitTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_active_exit_timestamp (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "active-exit-timestamp", value, NULL);
}

/**
 * systemd1_unit_get_active_exit_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveExitTimestampMonotonic">"ActiveExitTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_active_exit_timestamp_monotonic (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_active_exit_timestamp_monotonic (object);
}

/**
 * systemd1_unit_set_active_exit_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ActiveExitTimestampMonotonic">"ActiveExitTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_active_exit_timestamp_monotonic (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "active-exit-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_unit_get_inactive_enter_timestamp: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InactiveEnterTimestamp">"InactiveEnterTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_inactive_enter_timestamp (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_inactive_enter_timestamp (object);
}

/**
 * systemd1_unit_set_inactive_enter_timestamp: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InactiveEnterTimestamp">"InactiveEnterTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_inactive_enter_timestamp (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "inactive-enter-timestamp", value, NULL);
}

/**
 * systemd1_unit_get_inactive_enter_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InactiveEnterTimestampMonotonic">"InactiveEnterTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_inactive_enter_timestamp_monotonic (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_inactive_enter_timestamp_monotonic (object);
}

/**
 * systemd1_unit_set_inactive_enter_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InactiveEnterTimestampMonotonic">"InactiveEnterTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_inactive_enter_timestamp_monotonic (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "inactive-enter-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_unit_get_can_start: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanStart">"CanStart"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_can_start (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_can_start (object);
}

/**
 * systemd1_unit_set_can_start: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanStart">"CanStart"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_can_start (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-start", value, NULL);
}

/**
 * systemd1_unit_get_can_stop: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanStop">"CanStop"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_can_stop (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_can_stop (object);
}

/**
 * systemd1_unit_set_can_stop: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanStop">"CanStop"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_can_stop (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-stop", value, NULL);
}

/**
 * systemd1_unit_get_can_reload: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanReload">"CanReload"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_can_reload (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_can_reload (object);
}

/**
 * systemd1_unit_set_can_reload: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanReload">"CanReload"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_can_reload (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-reload", value, NULL);
}

/**
 * systemd1_unit_get_can_isolate: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanIsolate">"CanIsolate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_can_isolate (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_can_isolate (object);
}

/**
 * systemd1_unit_set_can_isolate: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanIsolate">"CanIsolate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_can_isolate (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-isolate", value, NULL);
}

/**
 * systemd1_unit_get_can_clean: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanClean">"CanClean"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_can_clean() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_can_clean (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_can_clean (object);
}

/**
 * systemd1_unit_dup_can_clean: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanClean">"CanClean"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_can_clean (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "can-clean", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_can_clean: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanClean">"CanClean"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_can_clean (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "can-clean", value, NULL);
}

/**
 * systemd1_unit_get_can_freeze: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanFreeze">"CanFreeze"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_can_freeze (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_can_freeze (object);
}

/**
 * systemd1_unit_set_can_freeze: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CanFreeze">"CanFreeze"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_can_freeze (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-freeze", value, NULL);
}

/**
 * systemd1_unit_get_job: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Job">"Job"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_job() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
systemd1_unit_get_job (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_job (object);
}

/**
 * systemd1_unit_dup_job: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Job">"Job"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
systemd1_unit_dup_job (Systemd1Unit *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "job", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_job: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Job">"Job"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_job (Systemd1Unit *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "job", value, NULL);
}

/**
 * systemd1_unit_get_stop_when_unneeded: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StopWhenUnneeded">"StopWhenUnneeded"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_stop_when_unneeded (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_stop_when_unneeded (object);
}

/**
 * systemd1_unit_set_stop_when_unneeded: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StopWhenUnneeded">"StopWhenUnneeded"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_stop_when_unneeded (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "stop-when-unneeded", value, NULL);
}

/**
 * systemd1_unit_get_refuse_manual_start: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RefuseManualStart">"RefuseManualStart"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_refuse_manual_start (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_refuse_manual_start (object);
}

/**
 * systemd1_unit_set_refuse_manual_start: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RefuseManualStart">"RefuseManualStart"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_refuse_manual_start (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "refuse-manual-start", value, NULL);
}

/**
 * systemd1_unit_get_refuse_manual_stop: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RefuseManualStop">"RefuseManualStop"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_refuse_manual_stop (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_refuse_manual_stop (object);
}

/**
 * systemd1_unit_set_refuse_manual_stop: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RefuseManualStop">"RefuseManualStop"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_refuse_manual_stop (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "refuse-manual-stop", value, NULL);
}

/**
 * systemd1_unit_get_allow_isolate: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.AllowIsolate">"AllowIsolate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_allow_isolate (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_allow_isolate (object);
}

/**
 * systemd1_unit_set_allow_isolate: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.AllowIsolate">"AllowIsolate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_allow_isolate (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "allow-isolate", value, NULL);
}

/**
 * systemd1_unit_get_default_dependencies: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.DefaultDependencies">"DefaultDependencies"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_default_dependencies (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_default_dependencies (object);
}

/**
 * systemd1_unit_set_default_dependencies: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.DefaultDependencies">"DefaultDependencies"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_default_dependencies (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "default-dependencies", value, NULL);
}

/**
 * systemd1_unit_get_on_success_job_mode: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnSuccessJobMode">"OnSuccessJobMode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_on_success_job_mode() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_on_success_job_mode (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_on_success_job_mode (object);
}

/**
 * systemd1_unit_dup_on_success_job_mode: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnSuccessJobMode">"OnSuccessJobMode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_on_success_job_mode (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "on-success-job-mode", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_on_success_job_mode: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnSuccessJobMode">"OnSuccessJobMode"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_on_success_job_mode (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "on-success-job-mode", value, NULL);
}

/**
 * systemd1_unit_get_on_failure_job_mode: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnFailureJobMode">"OnFailureJobMode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_on_failure_job_mode() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_on_failure_job_mode (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_on_failure_job_mode (object);
}

/**
 * systemd1_unit_dup_on_failure_job_mode: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnFailureJobMode">"OnFailureJobMode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_on_failure_job_mode (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "on-failure-job-mode", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_on_failure_job_mode: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.OnFailureJobMode">"OnFailureJobMode"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_on_failure_job_mode (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "on-failure-job-mode", value, NULL);
}

/**
 * systemd1_unit_get_ignore_on_isolate: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.IgnoreOnIsolate">"IgnoreOnIsolate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_ignore_on_isolate (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_ignore_on_isolate (object);
}

/**
 * systemd1_unit_set_ignore_on_isolate: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.IgnoreOnIsolate">"IgnoreOnIsolate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_ignore_on_isolate (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "ignore-on-isolate", value, NULL);
}

/**
 * systemd1_unit_get_need_daemon_reload: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.NeedDaemonReload">"NeedDaemonReload"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_need_daemon_reload (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_need_daemon_reload (object);
}

/**
 * systemd1_unit_set_need_daemon_reload: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.NeedDaemonReload">"NeedDaemonReload"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_need_daemon_reload (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "need-daemon-reload", value, NULL);
}

/**
 * systemd1_unit_get_markers: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Markers">"Markers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_markers() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_markers (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_markers (object);
}

/**
 * systemd1_unit_dup_markers: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Markers">"Markers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_markers (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "markers", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_markers: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Markers">"Markers"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_markers (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "markers", value, NULL);
}

/**
 * systemd1_unit_get_job_timeout_usec: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobTimeoutUSec">"JobTimeoutUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_job_timeout_usec (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_job_timeout_usec (object);
}

/**
 * systemd1_unit_set_job_timeout_usec: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobTimeoutUSec">"JobTimeoutUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_job_timeout_usec (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "job-timeout-usec", value, NULL);
}

/**
 * systemd1_unit_get_job_running_timeout_usec: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobRunningTimeoutUSec">"JobRunningTimeoutUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_job_running_timeout_usec (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_job_running_timeout_usec (object);
}

/**
 * systemd1_unit_set_job_running_timeout_usec: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobRunningTimeoutUSec">"JobRunningTimeoutUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_job_running_timeout_usec (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "job-running-timeout-usec", value, NULL);
}

/**
 * systemd1_unit_get_job_timeout_action: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobTimeoutAction">"JobTimeoutAction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_job_timeout_action() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_job_timeout_action (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_job_timeout_action (object);
}

/**
 * systemd1_unit_dup_job_timeout_action: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobTimeoutAction">"JobTimeoutAction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_job_timeout_action (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "job-timeout-action", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_job_timeout_action: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobTimeoutAction">"JobTimeoutAction"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_job_timeout_action (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "job-timeout-action", value, NULL);
}

/**
 * systemd1_unit_get_job_timeout_reboot_argument: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobTimeoutRebootArgument">"JobTimeoutRebootArgument"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_job_timeout_reboot_argument() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_job_timeout_reboot_argument (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_job_timeout_reboot_argument (object);
}

/**
 * systemd1_unit_dup_job_timeout_reboot_argument: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobTimeoutRebootArgument">"JobTimeoutRebootArgument"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_job_timeout_reboot_argument (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "job-timeout-reboot-argument", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_job_timeout_reboot_argument: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.JobTimeoutRebootArgument">"JobTimeoutRebootArgument"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_job_timeout_reboot_argument (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "job-timeout-reboot-argument", value, NULL);
}

/**
 * systemd1_unit_get_condition_result: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConditionResult">"ConditionResult"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_condition_result (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_condition_result (object);
}

/**
 * systemd1_unit_set_condition_result: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConditionResult">"ConditionResult"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_condition_result (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "condition-result", value, NULL);
}

/**
 * systemd1_unit_get_assert_result: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.AssertResult">"AssertResult"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_assert_result (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_assert_result (object);
}

/**
 * systemd1_unit_set_assert_result: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.AssertResult">"AssertResult"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_assert_result (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "assert-result", value, NULL);
}

/**
 * systemd1_unit_get_condition_timestamp: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConditionTimestamp">"ConditionTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_condition_timestamp (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_condition_timestamp (object);
}

/**
 * systemd1_unit_set_condition_timestamp: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConditionTimestamp">"ConditionTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_condition_timestamp (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "condition-timestamp", value, NULL);
}

/**
 * systemd1_unit_get_condition_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConditionTimestampMonotonic">"ConditionTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_condition_timestamp_monotonic (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_condition_timestamp_monotonic (object);
}

/**
 * systemd1_unit_set_condition_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.ConditionTimestampMonotonic">"ConditionTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_condition_timestamp_monotonic (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "condition-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_unit_get_assert_timestamp: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.AssertTimestamp">"AssertTimestamp"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_assert_timestamp (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_assert_timestamp (object);
}

/**
 * systemd1_unit_set_assert_timestamp: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.AssertTimestamp">"AssertTimestamp"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_assert_timestamp (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "assert-timestamp", value, NULL);
}

/**
 * systemd1_unit_get_assert_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.AssertTimestampMonotonic">"AssertTimestampMonotonic"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_assert_timestamp_monotonic (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_assert_timestamp_monotonic (object);
}

/**
 * systemd1_unit_set_assert_timestamp_monotonic: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.AssertTimestampMonotonic">"AssertTimestampMonotonic"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_assert_timestamp_monotonic (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "assert-timestamp-monotonic", value, NULL);
}

/**
 * systemd1_unit_get_conditions: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Conditions">"Conditions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_conditions() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
systemd1_unit_get_conditions (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_conditions (object);
}

/**
 * systemd1_unit_dup_conditions: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Conditions">"Conditions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
systemd1_unit_dup_conditions (Systemd1Unit *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "conditions", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_conditions: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Conditions">"Conditions"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_conditions (Systemd1Unit *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "conditions", value, NULL);
}

/**
 * systemd1_unit_get_asserts: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Asserts">"Asserts"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_asserts() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
systemd1_unit_get_asserts (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_asserts (object);
}

/**
 * systemd1_unit_dup_asserts: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Asserts">"Asserts"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
systemd1_unit_dup_asserts (Systemd1Unit *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "asserts", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_asserts: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Asserts">"Asserts"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_asserts (Systemd1Unit *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "asserts", value, NULL);
}

/**
 * systemd1_unit_get_load_error: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.LoadError">"LoadError"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_load_error() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
systemd1_unit_get_load_error (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_load_error (object);
}

/**
 * systemd1_unit_dup_load_error: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.LoadError">"LoadError"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
systemd1_unit_dup_load_error (Systemd1Unit *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "load-error", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_load_error: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.LoadError">"LoadError"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_load_error (Systemd1Unit *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "load-error", value, NULL);
}

/**
 * systemd1_unit_get_transient: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Transient">"Transient"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_transient (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_transient (object);
}

/**
 * systemd1_unit_set_transient: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Transient">"Transient"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_transient (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "transient", value, NULL);
}

/**
 * systemd1_unit_get_perpetual: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Perpetual">"Perpetual"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
systemd1_unit_get_perpetual (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_perpetual (object);
}

/**
 * systemd1_unit_set_perpetual: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Perpetual">"Perpetual"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_perpetual (Systemd1Unit *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "perpetual", value, NULL);
}

/**
 * systemd1_unit_get_start_limit_interval_usec: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StartLimitIntervalUSec">"StartLimitIntervalUSec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
systemd1_unit_get_start_limit_interval_usec (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_start_limit_interval_usec (object);
}

/**
 * systemd1_unit_set_start_limit_interval_usec: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StartLimitIntervalUSec">"StartLimitIntervalUSec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_start_limit_interval_usec (Systemd1Unit *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "start-limit-interval-usec", value, NULL);
}

/**
 * systemd1_unit_get_start_limit_burst: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StartLimitBurst">"StartLimitBurst"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
systemd1_unit_get_start_limit_burst (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_start_limit_burst (object);
}

/**
 * systemd1_unit_set_start_limit_burst: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StartLimitBurst">"StartLimitBurst"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_start_limit_burst (Systemd1Unit *object, guint value)
{
  g_object_set (G_OBJECT (object), "start-limit-burst", value, NULL);
}

/**
 * systemd1_unit_get_start_limit_action: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StartLimitAction">"StartLimitAction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_start_limit_action() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_start_limit_action (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_start_limit_action (object);
}

/**
 * systemd1_unit_dup_start_limit_action: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StartLimitAction">"StartLimitAction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_start_limit_action (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "start-limit-action", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_start_limit_action: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.StartLimitAction">"StartLimitAction"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_start_limit_action (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "start-limit-action", value, NULL);
}

/**
 * systemd1_unit_get_failure_action: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FailureAction">"FailureAction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_failure_action() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_failure_action (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_failure_action (object);
}

/**
 * systemd1_unit_dup_failure_action: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FailureAction">"FailureAction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_failure_action (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "failure-action", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_failure_action: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FailureAction">"FailureAction"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_failure_action (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "failure-action", value, NULL);
}

/**
 * systemd1_unit_get_failure_action_exit_status: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FailureActionExitStatus">"FailureActionExitStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
systemd1_unit_get_failure_action_exit_status (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_failure_action_exit_status (object);
}

/**
 * systemd1_unit_set_failure_action_exit_status: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.FailureActionExitStatus">"FailureActionExitStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_failure_action_exit_status (Systemd1Unit *object, gint value)
{
  g_object_set (G_OBJECT (object), "failure-action-exit-status", value, NULL);
}

/**
 * systemd1_unit_get_success_action: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SuccessAction">"SuccessAction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_success_action() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_success_action (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_success_action (object);
}

/**
 * systemd1_unit_dup_success_action: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SuccessAction">"SuccessAction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_success_action (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "success-action", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_success_action: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SuccessAction">"SuccessAction"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_success_action (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "success-action", value, NULL);
}

/**
 * systemd1_unit_get_success_action_exit_status: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SuccessActionExitStatus">"SuccessActionExitStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
systemd1_unit_get_success_action_exit_status (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_success_action_exit_status (object);
}

/**
 * systemd1_unit_set_success_action_exit_status: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.SuccessActionExitStatus">"SuccessActionExitStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_success_action_exit_status (Systemd1Unit *object, gint value)
{
  g_object_set (G_OBJECT (object), "success-action-exit-status", value, NULL);
}

/**
 * systemd1_unit_get_reboot_argument: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RebootArgument">"RebootArgument"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_reboot_argument() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_reboot_argument (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_reboot_argument (object);
}

/**
 * systemd1_unit_dup_reboot_argument: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RebootArgument">"RebootArgument"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_reboot_argument (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "reboot-argument", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_reboot_argument: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.RebootArgument">"RebootArgument"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_reboot_argument (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "reboot-argument", value, NULL);
}

/**
 * systemd1_unit_get_invocation_id: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InvocationID">"InvocationID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_invocation_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_invocation_id (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_invocation_id (object);
}

/**
 * systemd1_unit_dup_invocation_id: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InvocationID">"InvocationID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_invocation_id (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "invocation-id", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_invocation_id: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.InvocationID">"InvocationID"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_invocation_id (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "invocation-id", value, NULL);
}

/**
 * systemd1_unit_get_collect_mode: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CollectMode">"CollectMode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_collect_mode() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
systemd1_unit_get_collect_mode (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_collect_mode (object);
}

/**
 * systemd1_unit_dup_collect_mode: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CollectMode">"CollectMode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
systemd1_unit_dup_collect_mode (Systemd1Unit *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "collect-mode", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_collect_mode: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.CollectMode">"CollectMode"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_collect_mode (Systemd1Unit *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "collect-mode", value, NULL);
}

/**
 * systemd1_unit_get_refs: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Refs">"Refs"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use systemd1_unit_dup_refs() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
systemd1_unit_get_refs (Systemd1Unit *object)
{
  return SYSTEMD1_UNIT_GET_IFACE (object)->get_refs (object);
}

/**
 * systemd1_unit_dup_refs: (skip)
 * @object: A #Systemd1Unit.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Refs">"Refs"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
systemd1_unit_dup_refs (Systemd1Unit *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "refs", &value, NULL);
  return value;
}

/**
 * systemd1_unit_set_refs: (skip)
 * @object: A #Systemd1Unit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-systemd1-Unit.Refs">"Refs"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
systemd1_unit_set_refs (Systemd1Unit *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "refs", value, NULL);
}

/**
 * systemd1_unit_call_start:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_start_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_start_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_start (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_start_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_start_finish (
    Systemd1Unit *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_start_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_start_sync (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_stop:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_stop_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_stop (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_stop_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_stop_finish (
    Systemd1Unit *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_stop_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_stop_sync (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_reload:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Reload">Reload()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_reload_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_reload_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_reload (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reload",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_reload_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_reload().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_reload().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_reload_finish (
    Systemd1Unit *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_reload_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Reload">Reload()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_reload() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_reload_sync (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reload",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_restart:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Restart">Restart()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_restart_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_restart_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_restart (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Restart",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_restart_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_restart().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_restart().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_restart_finish (
    Systemd1Unit *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_restart_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Restart">Restart()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_restart() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_restart_sync (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Restart",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_try_restart:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.TryRestart">TryRestart()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_try_restart_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_try_restart_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_try_restart (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "TryRestart",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_try_restart_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_try_restart().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_try_restart().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_try_restart_finish (
    Systemd1Unit *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_try_restart_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.TryRestart">TryRestart()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_try_restart() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_try_restart_sync (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "TryRestart",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_reload_or_restart:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.ReloadOrRestart">ReloadOrRestart()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_reload_or_restart_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_reload_or_restart_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_reload_or_restart (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReloadOrRestart",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_reload_or_restart_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_reload_or_restart().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_reload_or_restart().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_reload_or_restart_finish (
    Systemd1Unit *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_reload_or_restart_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.ReloadOrRestart">ReloadOrRestart()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_reload_or_restart() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_reload_or_restart_sync (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReloadOrRestart",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_reload_or_try_restart:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.ReloadOrTryRestart">ReloadOrTryRestart()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_reload_or_try_restart_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_reload_or_try_restart_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_reload_or_try_restart (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReloadOrTryRestart",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_reload_or_try_restart_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_reload_or_try_restart().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_reload_or_try_restart().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_reload_or_try_restart_finish (
    Systemd1Unit *proxy,
    gchar **out_job,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_reload_or_try_restart_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @out_job: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.ReloadOrTryRestart">ReloadOrTryRestart()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_reload_or_try_restart() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_reload_or_try_restart_sync (
    Systemd1Unit *proxy,
    const gchar *arg_mode,
    gchar **out_job,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReloadOrTryRestart",
    g_variant_new ("(s)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_job);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_enqueue_job:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_job_type: Argument to pass with the method invocation.
 * @arg_job_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.EnqueueJob">EnqueueJob()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_enqueue_job_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_enqueue_job_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_enqueue_job (
    Systemd1Unit *proxy,
    const gchar *arg_job_type,
    const gchar *arg_job_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnqueueJob",
    g_variant_new ("(ss)",
                   arg_job_type,
                   arg_job_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_enqueue_job_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @out_job_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_job_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_unit_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_unit_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_job_type: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_affected_jobs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_enqueue_job().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_enqueue_job().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_enqueue_job_finish (
    Systemd1Unit *proxy,
    guint *out_job_id,
    gchar **out_job_path,
    gchar **out_unit_id,
    gchar **out_unit_path,
    gchar **out_job_type,
    GVariant **out_affected_jobs,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(uosos@a(uosos))",
                 out_job_id,
                 out_job_path,
                 out_unit_id,
                 out_unit_path,
                 out_job_type,
                 out_affected_jobs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_enqueue_job_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_job_type: Argument to pass with the method invocation.
 * @arg_job_mode: Argument to pass with the method invocation.
 * @out_job_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_job_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_unit_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_unit_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_job_type: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_affected_jobs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.EnqueueJob">EnqueueJob()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_enqueue_job() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_enqueue_job_sync (
    Systemd1Unit *proxy,
    const gchar *arg_job_type,
    const gchar *arg_job_mode,
    guint *out_job_id,
    gchar **out_job_path,
    gchar **out_unit_id,
    gchar **out_unit_path,
    gchar **out_job_type,
    GVariant **out_affected_jobs,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnqueueJob",
    g_variant_new ("(ss)",
                   arg_job_type,
                   arg_job_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(uosos@a(uosos))",
                 out_job_id,
                 out_job_path,
                 out_unit_id,
                 out_unit_path,
                 out_job_type,
                 out_affected_jobs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_kill:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_whom: Argument to pass with the method invocation.
 * @arg_signal: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Kill">Kill()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_kill_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_kill_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_kill (
    Systemd1Unit *proxy,
    const gchar *arg_whom,
    gint arg_signal,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Kill",
    g_variant_new ("(si)",
                   arg_whom,
                   arg_signal),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_kill_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_kill().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_kill().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_kill_finish (
    Systemd1Unit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_kill_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_whom: Argument to pass with the method invocation.
 * @arg_signal: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Kill">Kill()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_kill() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_kill_sync (
    Systemd1Unit *proxy,
    const gchar *arg_whom,
    gint arg_signal,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Kill",
    g_variant_new ("(si)",
                   arg_whom,
                   arg_signal),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_reset_failed:
 * @proxy: A #Systemd1UnitProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.ResetFailed">ResetFailed()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_reset_failed_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_reset_failed_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_reset_failed (
    Systemd1Unit *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ResetFailed",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_reset_failed_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_reset_failed().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_reset_failed().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_reset_failed_finish (
    Systemd1Unit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_reset_failed_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.ResetFailed">ResetFailed()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_reset_failed() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_reset_failed_sync (
    Systemd1Unit *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ResetFailed",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_set_properties:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.SetProperties">SetProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_set_properties_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_set_properties_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_set_properties (
    Systemd1Unit *proxy,
    gboolean arg_runtime,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetProperties",
    g_variant_new ("(b@a(sv))",
                   arg_runtime,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_set_properties_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_set_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_set_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_set_properties_finish (
    Systemd1Unit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_set_properties_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_runtime: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.SetProperties">SetProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_set_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_set_properties_sync (
    Systemd1Unit *proxy,
    gboolean arg_runtime,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetProperties",
    g_variant_new ("(b@a(sv))",
                   arg_runtime,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_ref:
 * @proxy: A #Systemd1UnitProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Ref">Ref()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_ref_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_ref_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_ref (
    Systemd1Unit *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Ref",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_ref_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_ref().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_ref().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_ref_finish (
    Systemd1Unit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_ref_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Ref">Ref()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_ref() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_ref_sync (
    Systemd1Unit *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Ref",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_unref:
 * @proxy: A #Systemd1UnitProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Unref">Unref()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_unref_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_unref_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_unref (
    Systemd1Unit *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Unref",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_unref_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_unref().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_unref().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_unref_finish (
    Systemd1Unit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_unref_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Unref">Unref()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_unref() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_unref_sync (
    Systemd1Unit *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Unref",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_clean:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mask: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Clean">Clean()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_clean_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_clean_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_clean (
    Systemd1Unit *proxy,
    const gchar *const *arg_mask,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Clean",
    g_variant_new ("(^as)",
                   arg_mask),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_clean_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_clean().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_clean().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_clean_finish (
    Systemd1Unit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_clean_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @arg_mask: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Clean">Clean()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_clean() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_clean_sync (
    Systemd1Unit *proxy,
    const gchar *const *arg_mask,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Clean",
    g_variant_new ("(^as)",
                   arg_mask),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_freeze:
 * @proxy: A #Systemd1UnitProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Freeze">Freeze()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_freeze_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_freeze_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_freeze (
    Systemd1Unit *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Freeze",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_freeze_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_freeze().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_freeze().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_freeze_finish (
    Systemd1Unit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_freeze_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Freeze">Freeze()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_freeze() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_freeze_sync (
    Systemd1Unit *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Freeze",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_thaw:
 * @proxy: A #Systemd1UnitProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Thaw">Thaw()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_call_thaw_finish() to get the result of the operation.
 *
 * See systemd1_unit_call_thaw_sync() for the synchronous, blocking version of this method.
 */
void
systemd1_unit_call_thaw (
    Systemd1Unit *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Thaw",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * systemd1_unit_call_thaw_finish:
 * @proxy: A #Systemd1UnitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_call_thaw().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with systemd1_unit_call_thaw().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_thaw_finish (
    Systemd1Unit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_call_thaw_sync:
 * @proxy: A #Systemd1UnitProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Thaw">Thaw()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_call_thaw() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
systemd1_unit_call_thaw_sync (
    Systemd1Unit *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Thaw",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * systemd1_unit_complete_start:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_start (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_unit_complete_stop:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_stop (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_unit_complete_reload:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Reload">Reload()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_reload (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_unit_complete_restart:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Restart">Restart()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_restart (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_unit_complete_try_restart:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.TryRestart">TryRestart()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_try_restart (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_unit_complete_reload_or_restart:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.ReloadOrRestart">ReloadOrRestart()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_reload_or_restart (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_unit_complete_reload_or_try_restart:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.ReloadOrTryRestart">ReloadOrTryRestart()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_reload_or_try_restart (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *job)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   job));
}

/**
 * systemd1_unit_complete_enqueue_job:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @job_id: Parameter to return.
 * @job_path: Parameter to return.
 * @unit_id: Parameter to return.
 * @unit_path: Parameter to return.
 * @job_type: Parameter to return.
 * @affected_jobs: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.EnqueueJob">EnqueueJob()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_enqueue_job (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint job_id,
    const gchar *job_path,
    const gchar *unit_id,
    const gchar *unit_path,
    const gchar *job_type,
    GVariant *affected_jobs)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(uosos@a(uosos))",
                   job_id,
                   job_path,
                   unit_id,
                   unit_path,
                   job_type,
                   affected_jobs));
}

/**
 * systemd1_unit_complete_kill:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Kill">Kill()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_kill (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_unit_complete_reset_failed:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.ResetFailed">ResetFailed()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_reset_failed (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_unit_complete_set_properties:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.SetProperties">SetProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_set_properties (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_unit_complete_ref:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Ref">Ref()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_ref (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_unit_complete_unref:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Unref">Unref()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_unref (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_unit_complete_clean:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Clean">Clean()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_clean (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_unit_complete_freeze:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Freeze">Freeze()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_freeze (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * systemd1_unit_complete_thaw:
 * @object: A #Systemd1Unit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-systemd1-Unit.Thaw">Thaw()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
systemd1_unit_complete_thaw (
    Systemd1Unit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * Systemd1UnitProxy:
 *
 * The #Systemd1UnitProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Systemd1UnitProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Systemd1UnitProxy.
 */

struct _Systemd1UnitProxyPrivate
{
  GData *qdata;
};

static void systemd1_unit_proxy_iface_init (Systemd1UnitIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Systemd1UnitProxy, systemd1_unit_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (Systemd1UnitProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_SYSTEMD1_UNIT, systemd1_unit_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Systemd1UnitProxy, systemd1_unit_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_SYSTEMD1_UNIT, systemd1_unit_proxy_iface_init))

#endif
static void
systemd1_unit_proxy_finalize (GObject *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (systemd1_unit_proxy_parent_class)->finalize (object);
}

static void
systemd1_unit_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 94);
  info = (const _ExtendedGDBusPropertyInfo *) _systemd1_unit_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
systemd1_unit_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.systemd1.Unit: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
systemd1_unit_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 94);
  info = (const _ExtendedGDBusPropertyInfo *) _systemd1_unit_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.systemd1.Unit", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) systemd1_unit_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
systemd1_unit_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_systemd1_unit_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_SYSTEMD1_UNIT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SYSTEMD1_UNIT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
systemd1_unit_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_systemd1_unit_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_systemd1_unit_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
systemd1_unit_proxy_get_id (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Id");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_names (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Names");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Names");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Names", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_following (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Following");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_requires (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Requires");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Requires");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Requires", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_requisite (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Requisite");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Requisite");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Requisite", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_wants (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Wants");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Wants");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Wants", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_binds_to (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "BindsTo");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "BindsTo");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "BindsTo", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_part_of (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "PartOf");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PartOf");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "PartOf", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_required_by (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "RequiredBy");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RequiredBy");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "RequiredBy", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_requisite_of (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "RequisiteOf");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RequisiteOf");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "RequisiteOf", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_wanted_by (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "WantedBy");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WantedBy");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "WantedBy", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_bound_by (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "BoundBy");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "BoundBy");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "BoundBy", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_consists_of (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "ConsistsOf");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConsistsOf");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "ConsistsOf", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_conflicts (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Conflicts");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Conflicts");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Conflicts", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_conflicted_by (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "ConflictedBy");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConflictedBy");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "ConflictedBy", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_before (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Before");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Before");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Before", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_after (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "After");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "After");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "After", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_on_failure (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "OnFailure");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OnFailure");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "OnFailure", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_on_failure_of (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "OnFailureOf");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OnFailureOf");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "OnFailureOf", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_on_success (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "OnSuccess");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OnSuccess");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "OnSuccess", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_on_success_of (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "OnSuccessOf");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OnSuccessOf");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "OnSuccessOf", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_triggers (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Triggers");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Triggers");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Triggers", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_triggered_by (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "TriggeredBy");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TriggeredBy");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "TriggeredBy", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_propagates_reload_to (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "PropagatesReloadTo");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PropagatesReloadTo");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "PropagatesReloadTo", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_reload_propagated_from (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "ReloadPropagatedFrom");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ReloadPropagatedFrom");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "ReloadPropagatedFrom", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_propagates_stop_to (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "PropagatesStopTo");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PropagatesStopTo");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "PropagatesStopTo", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_stop_propagated_from (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "StopPropagatedFrom");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "StopPropagatedFrom");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "StopPropagatedFrom", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_joins_namespace_of (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "JoinsNamespaceOf");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "JoinsNamespaceOf");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "JoinsNamespaceOf", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_slice_of (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "SliceOf");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SliceOf");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "SliceOf", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_requires_mounts_for (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "RequiresMountsFor");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RequiresMountsFor");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "RequiresMountsFor", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_documentation (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Documentation");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Documentation");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Documentation", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_description (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Description");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_load_state (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoadState");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_active_state (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ActiveState");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_freezer_state (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FreezerState");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_sub_state (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SubState");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_fragment_path (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FragmentPath");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_source_path (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SourcePath");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_drop_in_paths (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "DropInPaths");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DropInPaths");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "DropInPaths", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_unit_file_state (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UnitFileState");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_unit_file_preset (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UnitFilePreset");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_state_change_timestamp (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "StateChangeTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_state_change_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "StateChangeTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_inactive_exit_timestamp (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InactiveExitTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_inactive_exit_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InactiveExitTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_active_enter_timestamp (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ActiveEnterTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_active_enter_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ActiveEnterTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_active_exit_timestamp (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ActiveExitTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_active_exit_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ActiveExitTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_inactive_enter_timestamp (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InactiveEnterTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_inactive_enter_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InactiveEnterTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_can_start (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanStart");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_can_stop (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanStop");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_can_reload (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanReload");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_can_isolate (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanIsolate");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_can_clean (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "CanClean");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanClean");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "CanClean", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_can_freeze (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanFreeze");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
systemd1_unit_proxy_get_job (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Job");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static gboolean 
systemd1_unit_proxy_get_stop_when_unneeded (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "StopWhenUnneeded");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_refuse_manual_start (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RefuseManualStart");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_refuse_manual_stop (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RefuseManualStop");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_allow_isolate (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AllowIsolate");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_default_dependencies (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DefaultDependencies");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_on_success_job_mode (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OnSuccessJobMode");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_on_failure_job_mode (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OnFailureJobMode");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_ignore_on_isolate (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IgnoreOnIsolate");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_need_daemon_reload (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NeedDaemonReload");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_markers (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Markers");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Markers");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Markers", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_job_timeout_usec (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "JobTimeoutUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_job_running_timeout_usec (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "JobRunningTimeoutUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_job_timeout_action (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "JobTimeoutAction");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_job_timeout_reboot_argument (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "JobTimeoutRebootArgument");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_condition_result (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConditionResult");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_assert_result (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AssertResult");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_condition_timestamp (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConditionTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_condition_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConditionTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_assert_timestamp (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AssertTimestamp");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_assert_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AssertTimestampMonotonic");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
systemd1_unit_proxy_get_conditions (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Conditions");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
systemd1_unit_proxy_get_asserts (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Asserts");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
systemd1_unit_proxy_get_load_error (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoadError");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static gboolean 
systemd1_unit_proxy_get_transient (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Transient");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
systemd1_unit_proxy_get_perpetual (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Perpetual");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
systemd1_unit_proxy_get_start_limit_interval_usec (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "StartLimitIntervalUSec");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
systemd1_unit_proxy_get_start_limit_burst (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "StartLimitBurst");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_start_limit_action (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "StartLimitAction");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_failure_action (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FailureAction");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
systemd1_unit_proxy_get_failure_action_exit_status (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FailureActionExitStatus");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_success_action (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SuccessAction");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
systemd1_unit_proxy_get_success_action_exit_status (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SuccessActionExitStatus");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_reboot_argument (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RebootArgument");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_invocation_id (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InvocationID");
  if (variant != NULL)
    {
      value = g_variant_get_bytestring (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
systemd1_unit_proxy_get_collect_mode (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CollectMode");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
systemd1_unit_proxy_get_refs (Systemd1Unit *object)
{
  Systemd1UnitProxy *proxy = SYSTEMD1_UNIT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Refs");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Refs");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Refs", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
systemd1_unit_proxy_init (Systemd1UnitProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = systemd1_unit_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_SYSTEMD1_UNIT_PROXY, Systemd1UnitProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), systemd1_unit_interface_info ());
}

static void
systemd1_unit_proxy_class_init (Systemd1UnitProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = systemd1_unit_proxy_finalize;
  gobject_class->get_property = systemd1_unit_proxy_get_property;
  gobject_class->set_property = systemd1_unit_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = systemd1_unit_proxy_g_signal;
  proxy_class->g_properties_changed = systemd1_unit_proxy_g_properties_changed;

  systemd1_unit_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Systemd1UnitProxyPrivate));
#endif
}

static void
systemd1_unit_proxy_iface_init (Systemd1UnitIface *iface)
{
  iface->get_id = systemd1_unit_proxy_get_id;
  iface->get_names = systemd1_unit_proxy_get_names;
  iface->get_following = systemd1_unit_proxy_get_following;
  iface->get_requires = systemd1_unit_proxy_get_requires;
  iface->get_requisite = systemd1_unit_proxy_get_requisite;
  iface->get_wants = systemd1_unit_proxy_get_wants;
  iface->get_binds_to = systemd1_unit_proxy_get_binds_to;
  iface->get_part_of = systemd1_unit_proxy_get_part_of;
  iface->get_required_by = systemd1_unit_proxy_get_required_by;
  iface->get_requisite_of = systemd1_unit_proxy_get_requisite_of;
  iface->get_wanted_by = systemd1_unit_proxy_get_wanted_by;
  iface->get_bound_by = systemd1_unit_proxy_get_bound_by;
  iface->get_consists_of = systemd1_unit_proxy_get_consists_of;
  iface->get_conflicts = systemd1_unit_proxy_get_conflicts;
  iface->get_conflicted_by = systemd1_unit_proxy_get_conflicted_by;
  iface->get_before = systemd1_unit_proxy_get_before;
  iface->get_after = systemd1_unit_proxy_get_after;
  iface->get_on_failure = systemd1_unit_proxy_get_on_failure;
  iface->get_on_failure_of = systemd1_unit_proxy_get_on_failure_of;
  iface->get_on_success = systemd1_unit_proxy_get_on_success;
  iface->get_on_success_of = systemd1_unit_proxy_get_on_success_of;
  iface->get_triggers = systemd1_unit_proxy_get_triggers;
  iface->get_triggered_by = systemd1_unit_proxy_get_triggered_by;
  iface->get_propagates_reload_to = systemd1_unit_proxy_get_propagates_reload_to;
  iface->get_reload_propagated_from = systemd1_unit_proxy_get_reload_propagated_from;
  iface->get_propagates_stop_to = systemd1_unit_proxy_get_propagates_stop_to;
  iface->get_stop_propagated_from = systemd1_unit_proxy_get_stop_propagated_from;
  iface->get_joins_namespace_of = systemd1_unit_proxy_get_joins_namespace_of;
  iface->get_slice_of = systemd1_unit_proxy_get_slice_of;
  iface->get_requires_mounts_for = systemd1_unit_proxy_get_requires_mounts_for;
  iface->get_documentation = systemd1_unit_proxy_get_documentation;
  iface->get_description = systemd1_unit_proxy_get_description;
  iface->get_load_state = systemd1_unit_proxy_get_load_state;
  iface->get_active_state = systemd1_unit_proxy_get_active_state;
  iface->get_freezer_state = systemd1_unit_proxy_get_freezer_state;
  iface->get_sub_state = systemd1_unit_proxy_get_sub_state;
  iface->get_fragment_path = systemd1_unit_proxy_get_fragment_path;
  iface->get_source_path = systemd1_unit_proxy_get_source_path;
  iface->get_drop_in_paths = systemd1_unit_proxy_get_drop_in_paths;
  iface->get_unit_file_state = systemd1_unit_proxy_get_unit_file_state;
  iface->get_unit_file_preset = systemd1_unit_proxy_get_unit_file_preset;
  iface->get_state_change_timestamp = systemd1_unit_proxy_get_state_change_timestamp;
  iface->get_state_change_timestamp_monotonic = systemd1_unit_proxy_get_state_change_timestamp_monotonic;
  iface->get_inactive_exit_timestamp = systemd1_unit_proxy_get_inactive_exit_timestamp;
  iface->get_inactive_exit_timestamp_monotonic = systemd1_unit_proxy_get_inactive_exit_timestamp_monotonic;
  iface->get_active_enter_timestamp = systemd1_unit_proxy_get_active_enter_timestamp;
  iface->get_active_enter_timestamp_monotonic = systemd1_unit_proxy_get_active_enter_timestamp_monotonic;
  iface->get_active_exit_timestamp = systemd1_unit_proxy_get_active_exit_timestamp;
  iface->get_active_exit_timestamp_monotonic = systemd1_unit_proxy_get_active_exit_timestamp_monotonic;
  iface->get_inactive_enter_timestamp = systemd1_unit_proxy_get_inactive_enter_timestamp;
  iface->get_inactive_enter_timestamp_monotonic = systemd1_unit_proxy_get_inactive_enter_timestamp_monotonic;
  iface->get_can_start = systemd1_unit_proxy_get_can_start;
  iface->get_can_stop = systemd1_unit_proxy_get_can_stop;
  iface->get_can_reload = systemd1_unit_proxy_get_can_reload;
  iface->get_can_isolate = systemd1_unit_proxy_get_can_isolate;
  iface->get_can_clean = systemd1_unit_proxy_get_can_clean;
  iface->get_can_freeze = systemd1_unit_proxy_get_can_freeze;
  iface->get_job = systemd1_unit_proxy_get_job;
  iface->get_stop_when_unneeded = systemd1_unit_proxy_get_stop_when_unneeded;
  iface->get_refuse_manual_start = systemd1_unit_proxy_get_refuse_manual_start;
  iface->get_refuse_manual_stop = systemd1_unit_proxy_get_refuse_manual_stop;
  iface->get_allow_isolate = systemd1_unit_proxy_get_allow_isolate;
  iface->get_default_dependencies = systemd1_unit_proxy_get_default_dependencies;
  iface->get_on_success_job_mode = systemd1_unit_proxy_get_on_success_job_mode;
  iface->get_on_failure_job_mode = systemd1_unit_proxy_get_on_failure_job_mode;
  iface->get_ignore_on_isolate = systemd1_unit_proxy_get_ignore_on_isolate;
  iface->get_need_daemon_reload = systemd1_unit_proxy_get_need_daemon_reload;
  iface->get_markers = systemd1_unit_proxy_get_markers;
  iface->get_job_timeout_usec = systemd1_unit_proxy_get_job_timeout_usec;
  iface->get_job_running_timeout_usec = systemd1_unit_proxy_get_job_running_timeout_usec;
  iface->get_job_timeout_action = systemd1_unit_proxy_get_job_timeout_action;
  iface->get_job_timeout_reboot_argument = systemd1_unit_proxy_get_job_timeout_reboot_argument;
  iface->get_condition_result = systemd1_unit_proxy_get_condition_result;
  iface->get_assert_result = systemd1_unit_proxy_get_assert_result;
  iface->get_condition_timestamp = systemd1_unit_proxy_get_condition_timestamp;
  iface->get_condition_timestamp_monotonic = systemd1_unit_proxy_get_condition_timestamp_monotonic;
  iface->get_assert_timestamp = systemd1_unit_proxy_get_assert_timestamp;
  iface->get_assert_timestamp_monotonic = systemd1_unit_proxy_get_assert_timestamp_monotonic;
  iface->get_conditions = systemd1_unit_proxy_get_conditions;
  iface->get_asserts = systemd1_unit_proxy_get_asserts;
  iface->get_load_error = systemd1_unit_proxy_get_load_error;
  iface->get_transient = systemd1_unit_proxy_get_transient;
  iface->get_perpetual = systemd1_unit_proxy_get_perpetual;
  iface->get_start_limit_interval_usec = systemd1_unit_proxy_get_start_limit_interval_usec;
  iface->get_start_limit_burst = systemd1_unit_proxy_get_start_limit_burst;
  iface->get_start_limit_action = systemd1_unit_proxy_get_start_limit_action;
  iface->get_failure_action = systemd1_unit_proxy_get_failure_action;
  iface->get_failure_action_exit_status = systemd1_unit_proxy_get_failure_action_exit_status;
  iface->get_success_action = systemd1_unit_proxy_get_success_action;
  iface->get_success_action_exit_status = systemd1_unit_proxy_get_success_action_exit_status;
  iface->get_reboot_argument = systemd1_unit_proxy_get_reboot_argument;
  iface->get_invocation_id = systemd1_unit_proxy_get_invocation_id;
  iface->get_collect_mode = systemd1_unit_proxy_get_collect_mode;
  iface->get_refs = systemd1_unit_proxy_get_refs;
}

/**
 * systemd1_unit_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-systemd1-Unit.top_of_page">org.freedesktop.systemd1.Unit</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_proxy_new_finish() to get the result of the operation.
 *
 * See systemd1_unit_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
systemd1_unit_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SYSTEMD1_UNIT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.systemd1.Unit", NULL);
}

/**
 * systemd1_unit_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with systemd1_unit_proxy_new().
 *
 * Returns: (transfer full) (type Systemd1UnitProxy): The constructed proxy object or %NULL if @error is set.
 */
Systemd1Unit *
systemd1_unit_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SYSTEMD1_UNIT (ret);
  else
    return NULL;
}

/**
 * systemd1_unit_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-systemd1-Unit.top_of_page">org.freedesktop.systemd1.Unit</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Systemd1UnitProxy): The constructed proxy object or %NULL if @error is set.
 */
Systemd1Unit *
systemd1_unit_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SYSTEMD1_UNIT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.systemd1.Unit", NULL);
  if (ret != NULL)
    return SYSTEMD1_UNIT (ret);
  else
    return NULL;
}


/**
 * systemd1_unit_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like systemd1_unit_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call systemd1_unit_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See systemd1_unit_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
systemd1_unit_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_SYSTEMD1_UNIT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.systemd1.Unit", NULL);
}

/**
 * systemd1_unit_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to systemd1_unit_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with systemd1_unit_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type Systemd1UnitProxy): The constructed proxy object or %NULL if @error is set.
 */
Systemd1Unit *
systemd1_unit_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SYSTEMD1_UNIT (ret);
  else
    return NULL;
}

/**
 * systemd1_unit_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like systemd1_unit_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See systemd1_unit_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Systemd1UnitProxy): The constructed proxy object or %NULL if @error is set.
 */
Systemd1Unit *
systemd1_unit_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_SYSTEMD1_UNIT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.systemd1.Unit", NULL);
  if (ret != NULL)
    return SYSTEMD1_UNIT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * Systemd1UnitSkeleton:
 *
 * The #Systemd1UnitSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Systemd1UnitSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Systemd1UnitSkeleton.
 */

struct _Systemd1UnitSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_systemd1_unit_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_SYSTEMD1_UNIT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_SYSTEMD1_UNIT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_systemd1_unit_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_systemd1_unit_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_systemd1_unit_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_systemd1_unit_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _systemd1_unit_skeleton_vtable =
{
  _systemd1_unit_skeleton_handle_method_call,
  _systemd1_unit_skeleton_handle_get_property,
  _systemd1_unit_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
systemd1_unit_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return systemd1_unit_interface_info ();
}

static GDBusInterfaceVTable *
systemd1_unit_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_systemd1_unit_skeleton_vtable;
}

static GVariant *
systemd1_unit_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_systemd1_unit_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _systemd1_unit_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _systemd1_unit_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _systemd1_unit_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.systemd1.Unit", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _systemd1_unit_emit_changed (gpointer user_data);

static void
systemd1_unit_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _systemd1_unit_emit_changed (skeleton);
}

static void systemd1_unit_skeleton_iface_init (Systemd1UnitIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Systemd1UnitSkeleton, systemd1_unit_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (Systemd1UnitSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_SYSTEMD1_UNIT, systemd1_unit_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Systemd1UnitSkeleton, systemd1_unit_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_SYSTEMD1_UNIT, systemd1_unit_skeleton_iface_init))

#endif
static void
systemd1_unit_skeleton_finalize (GObject *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint n;
  for (n = 0; n < 94; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (systemd1_unit_skeleton_parent_class)->finalize (object);
}

static void
systemd1_unit_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 94);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_systemd1_unit_emit_changed (gpointer user_data)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.systemd1.Unit",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_systemd1_unit_schedule_emit_changed (Systemd1UnitSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
systemd1_unit_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _systemd1_unit_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _systemd1_unit_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
systemd1_unit_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 94);
  info = (const _ExtendedGDBusPropertyInfo *) _systemd1_unit_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _systemd1_unit_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
systemd1_unit_skeleton_init (Systemd1UnitSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = systemd1_unit_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_SYSTEMD1_UNIT_SKELETON, Systemd1UnitSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 94);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[15], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[16], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[17], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[18], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[19], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[20], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[21], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[22], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[23], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[24], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[25], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[26], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[27], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[28], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[29], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[30], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[31], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[32], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[33], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[34], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[35], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[36], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[37], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[38], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[39], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[40], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[41], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[42], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[43], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[44], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[45], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[46], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[47], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[48], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[49], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[50], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[51], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[52], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[53], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[54], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[55], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[56], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[57], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[58], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[59], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[60], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[61], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[62], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[63], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[64], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[65], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[66], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[67], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[68], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[69], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[70], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[71], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[72], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[73], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[74], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[75], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[76], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[77], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[78], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[79], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[80], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[81], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[82], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[83], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[84], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[85], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[86], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[87], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[88], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[89], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[90], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[91], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[92], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[93], G_TYPE_STRV);
}

static const gchar *
systemd1_unit_skeleton_get_id (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_names (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_following (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_requires (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_requisite (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_wants (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_binds_to (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_part_of (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_required_by (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_requisite_of (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_wanted_by (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_bound_by (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_consists_of (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_conflicts (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_conflicted_by (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_before (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[15]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_after (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[16]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_on_failure (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[17]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_on_failure_of (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[18]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_on_success (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[19]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_on_success_of (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[20]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_triggers (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[21]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_triggered_by (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[22]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_propagates_reload_to (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[23]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_reload_propagated_from (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[24]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_propagates_stop_to (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[25]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_stop_propagated_from (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[26]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_joins_namespace_of (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[27]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_slice_of (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[28]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_requires_mounts_for (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[29]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_documentation (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[30]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_description (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[31]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_load_state (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[32]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_active_state (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[33]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_freezer_state (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[34]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_sub_state (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[35]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_fragment_path (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[36]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_source_path (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[37]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_drop_in_paths (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[38]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_unit_file_state (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[39]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_unit_file_preset (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[40]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_state_change_timestamp (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[41]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_state_change_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[42]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_inactive_exit_timestamp (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[43]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_inactive_exit_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[44]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_active_enter_timestamp (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[45]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_active_enter_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[46]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_active_exit_timestamp (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[47]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_active_exit_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[48]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_inactive_enter_timestamp (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[49]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_inactive_enter_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[50]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_can_start (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[51]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_can_stop (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[52]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_can_reload (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[53]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_can_isolate (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[54]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_can_clean (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[55]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_can_freeze (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[56]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
systemd1_unit_skeleton_get_job (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[57]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_stop_when_unneeded (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[58]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_refuse_manual_start (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[59]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_refuse_manual_stop (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[60]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_allow_isolate (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[61]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_default_dependencies (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[62]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_on_success_job_mode (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[63]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_on_failure_job_mode (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[64]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_ignore_on_isolate (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[65]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_need_daemon_reload (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[66]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_markers (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[67]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_job_timeout_usec (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[68]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_job_running_timeout_usec (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[69]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_job_timeout_action (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[70]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_job_timeout_reboot_argument (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[71]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_condition_result (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[72]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_assert_result (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[73]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_condition_timestamp (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[74]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_condition_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[75]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_assert_timestamp (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[76]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_assert_timestamp_monotonic (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[77]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
systemd1_unit_skeleton_get_conditions (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[78]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
systemd1_unit_skeleton_get_asserts (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[79]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
systemd1_unit_skeleton_get_load_error (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[80]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_transient (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[81]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
systemd1_unit_skeleton_get_perpetual (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[82]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
systemd1_unit_skeleton_get_start_limit_interval_usec (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint64 (&(skeleton->priv->properties[83]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
systemd1_unit_skeleton_get_start_limit_burst (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[84]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_start_limit_action (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[85]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_failure_action (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[86]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
systemd1_unit_skeleton_get_failure_action_exit_status (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[87]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_success_action (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[88]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
systemd1_unit_skeleton_get_success_action_exit_status (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[89]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_reboot_argument (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[90]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_invocation_id (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[91]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
systemd1_unit_skeleton_get_collect_mode (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[92]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
systemd1_unit_skeleton_get_refs (Systemd1Unit *object)
{
  Systemd1UnitSkeleton *skeleton = SYSTEMD1_UNIT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[93]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
systemd1_unit_skeleton_class_init (Systemd1UnitSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = systemd1_unit_skeleton_finalize;
  gobject_class->get_property = systemd1_unit_skeleton_get_property;
  gobject_class->set_property = systemd1_unit_skeleton_set_property;
  gobject_class->notify       = systemd1_unit_skeleton_notify;


  systemd1_unit_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = systemd1_unit_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = systemd1_unit_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = systemd1_unit_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = systemd1_unit_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Systemd1UnitSkeletonPrivate));
#endif
}

static void
systemd1_unit_skeleton_iface_init (Systemd1UnitIface *iface)
{
  iface->get_id = systemd1_unit_skeleton_get_id;
  iface->get_names = systemd1_unit_skeleton_get_names;
  iface->get_following = systemd1_unit_skeleton_get_following;
  iface->get_requires = systemd1_unit_skeleton_get_requires;
  iface->get_requisite = systemd1_unit_skeleton_get_requisite;
  iface->get_wants = systemd1_unit_skeleton_get_wants;
  iface->get_binds_to = systemd1_unit_skeleton_get_binds_to;
  iface->get_part_of = systemd1_unit_skeleton_get_part_of;
  iface->get_required_by = systemd1_unit_skeleton_get_required_by;
  iface->get_requisite_of = systemd1_unit_skeleton_get_requisite_of;
  iface->get_wanted_by = systemd1_unit_skeleton_get_wanted_by;
  iface->get_bound_by = systemd1_unit_skeleton_get_bound_by;
  iface->get_consists_of = systemd1_unit_skeleton_get_consists_of;
  iface->get_conflicts = systemd1_unit_skeleton_get_conflicts;
  iface->get_conflicted_by = systemd1_unit_skeleton_get_conflicted_by;
  iface->get_before = systemd1_unit_skeleton_get_before;
  iface->get_after = systemd1_unit_skeleton_get_after;
  iface->get_on_failure = systemd1_unit_skeleton_get_on_failure;
  iface->get_on_failure_of = systemd1_unit_skeleton_get_on_failure_of;
  iface->get_on_success = systemd1_unit_skeleton_get_on_success;
  iface->get_on_success_of = systemd1_unit_skeleton_get_on_success_of;
  iface->get_triggers = systemd1_unit_skeleton_get_triggers;
  iface->get_triggered_by = systemd1_unit_skeleton_get_triggered_by;
  iface->get_propagates_reload_to = systemd1_unit_skeleton_get_propagates_reload_to;
  iface->get_reload_propagated_from = systemd1_unit_skeleton_get_reload_propagated_from;
  iface->get_propagates_stop_to = systemd1_unit_skeleton_get_propagates_stop_to;
  iface->get_stop_propagated_from = systemd1_unit_skeleton_get_stop_propagated_from;
  iface->get_joins_namespace_of = systemd1_unit_skeleton_get_joins_namespace_of;
  iface->get_slice_of = systemd1_unit_skeleton_get_slice_of;
  iface->get_requires_mounts_for = systemd1_unit_skeleton_get_requires_mounts_for;
  iface->get_documentation = systemd1_unit_skeleton_get_documentation;
  iface->get_description = systemd1_unit_skeleton_get_description;
  iface->get_load_state = systemd1_unit_skeleton_get_load_state;
  iface->get_active_state = systemd1_unit_skeleton_get_active_state;
  iface->get_freezer_state = systemd1_unit_skeleton_get_freezer_state;
  iface->get_sub_state = systemd1_unit_skeleton_get_sub_state;
  iface->get_fragment_path = systemd1_unit_skeleton_get_fragment_path;
  iface->get_source_path = systemd1_unit_skeleton_get_source_path;
  iface->get_drop_in_paths = systemd1_unit_skeleton_get_drop_in_paths;
  iface->get_unit_file_state = systemd1_unit_skeleton_get_unit_file_state;
  iface->get_unit_file_preset = systemd1_unit_skeleton_get_unit_file_preset;
  iface->get_state_change_timestamp = systemd1_unit_skeleton_get_state_change_timestamp;
  iface->get_state_change_timestamp_monotonic = systemd1_unit_skeleton_get_state_change_timestamp_monotonic;
  iface->get_inactive_exit_timestamp = systemd1_unit_skeleton_get_inactive_exit_timestamp;
  iface->get_inactive_exit_timestamp_monotonic = systemd1_unit_skeleton_get_inactive_exit_timestamp_monotonic;
  iface->get_active_enter_timestamp = systemd1_unit_skeleton_get_active_enter_timestamp;
  iface->get_active_enter_timestamp_monotonic = systemd1_unit_skeleton_get_active_enter_timestamp_monotonic;
  iface->get_active_exit_timestamp = systemd1_unit_skeleton_get_active_exit_timestamp;
  iface->get_active_exit_timestamp_monotonic = systemd1_unit_skeleton_get_active_exit_timestamp_monotonic;
  iface->get_inactive_enter_timestamp = systemd1_unit_skeleton_get_inactive_enter_timestamp;
  iface->get_inactive_enter_timestamp_monotonic = systemd1_unit_skeleton_get_inactive_enter_timestamp_monotonic;
  iface->get_can_start = systemd1_unit_skeleton_get_can_start;
  iface->get_can_stop = systemd1_unit_skeleton_get_can_stop;
  iface->get_can_reload = systemd1_unit_skeleton_get_can_reload;
  iface->get_can_isolate = systemd1_unit_skeleton_get_can_isolate;
  iface->get_can_clean = systemd1_unit_skeleton_get_can_clean;
  iface->get_can_freeze = systemd1_unit_skeleton_get_can_freeze;
  iface->get_job = systemd1_unit_skeleton_get_job;
  iface->get_stop_when_unneeded = systemd1_unit_skeleton_get_stop_when_unneeded;
  iface->get_refuse_manual_start = systemd1_unit_skeleton_get_refuse_manual_start;
  iface->get_refuse_manual_stop = systemd1_unit_skeleton_get_refuse_manual_stop;
  iface->get_allow_isolate = systemd1_unit_skeleton_get_allow_isolate;
  iface->get_default_dependencies = systemd1_unit_skeleton_get_default_dependencies;
  iface->get_on_success_job_mode = systemd1_unit_skeleton_get_on_success_job_mode;
  iface->get_on_failure_job_mode = systemd1_unit_skeleton_get_on_failure_job_mode;
  iface->get_ignore_on_isolate = systemd1_unit_skeleton_get_ignore_on_isolate;
  iface->get_need_daemon_reload = systemd1_unit_skeleton_get_need_daemon_reload;
  iface->get_markers = systemd1_unit_skeleton_get_markers;
  iface->get_job_timeout_usec = systemd1_unit_skeleton_get_job_timeout_usec;
  iface->get_job_running_timeout_usec = systemd1_unit_skeleton_get_job_running_timeout_usec;
  iface->get_job_timeout_action = systemd1_unit_skeleton_get_job_timeout_action;
  iface->get_job_timeout_reboot_argument = systemd1_unit_skeleton_get_job_timeout_reboot_argument;
  iface->get_condition_result = systemd1_unit_skeleton_get_condition_result;
  iface->get_assert_result = systemd1_unit_skeleton_get_assert_result;
  iface->get_condition_timestamp = systemd1_unit_skeleton_get_condition_timestamp;
  iface->get_condition_timestamp_monotonic = systemd1_unit_skeleton_get_condition_timestamp_monotonic;
  iface->get_assert_timestamp = systemd1_unit_skeleton_get_assert_timestamp;
  iface->get_assert_timestamp_monotonic = systemd1_unit_skeleton_get_assert_timestamp_monotonic;
  iface->get_conditions = systemd1_unit_skeleton_get_conditions;
  iface->get_asserts = systemd1_unit_skeleton_get_asserts;
  iface->get_load_error = systemd1_unit_skeleton_get_load_error;
  iface->get_transient = systemd1_unit_skeleton_get_transient;
  iface->get_perpetual = systemd1_unit_skeleton_get_perpetual;
  iface->get_start_limit_interval_usec = systemd1_unit_skeleton_get_start_limit_interval_usec;
  iface->get_start_limit_burst = systemd1_unit_skeleton_get_start_limit_burst;
  iface->get_start_limit_action = systemd1_unit_skeleton_get_start_limit_action;
  iface->get_failure_action = systemd1_unit_skeleton_get_failure_action;
  iface->get_failure_action_exit_status = systemd1_unit_skeleton_get_failure_action_exit_status;
  iface->get_success_action = systemd1_unit_skeleton_get_success_action;
  iface->get_success_action_exit_status = systemd1_unit_skeleton_get_success_action_exit_status;
  iface->get_reboot_argument = systemd1_unit_skeleton_get_reboot_argument;
  iface->get_invocation_id = systemd1_unit_skeleton_get_invocation_id;
  iface->get_collect_mode = systemd1_unit_skeleton_get_collect_mode;
  iface->get_refs = systemd1_unit_skeleton_get_refs;
}

/**
 * systemd1_unit_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-systemd1-Unit.top_of_page">org.freedesktop.systemd1.Unit</link>.
 *
 * Returns: (transfer full) (type Systemd1UnitSkeleton): The skeleton object.
 */
Systemd1Unit *
systemd1_unit_skeleton_new (void)
{
  return SYSTEMD1_UNIT (g_object_new (TYPE_SYSTEMD1_UNIT_SKELETON, NULL));
}

