/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-parser.h"
#include "libical-glib-private.h"
#include "i-cal-component.h"

G_DEFINE_TYPE (ICalParser, i_cal_parser, I_CAL_TYPE_OBJECT)

static void i_cal_parser_class_init (G_GNUC_UNUSED ICalParserClass *klass)
{
}

static void i_cal_parser_init (G_GNUC_UNUSED ICalParser *self)
{
}

/**
 * i_cal_parser_new_full: (skip)
 * @native: The native libical object.
 * @owner: The parent.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalParser *
i_cal_parser_new_full (icalparser *native, 
                       GObject *owner)
{
    ICalParser *object;
    if (native == NULL)
        return NULL;
    
    
    object = i_cal_object_construct (I_CAL_TYPE_PARSER,
                            (gpointer) native,
                            (GDestroyNotify) icalparser_free,
                            FALSE,
                            owner);

    return object;
}


/**
 * i_cal_parser_new:
 *
 * Creates a default #ICalParser.
 *
 * Returns: (transfer full): The newly created #ICalParser.
 *
 * Since: 1.0
 *
 **/
ICalParser *
i_cal_parser_new (void)
{
	return i_cal_parser_new_full (icalparser_new (), NULL);
}

/**
 * i_cal_parser_add_line:
 * @parser: (in) (transfer full): The #ICalParser used to parse the string into the #ICalComponent
 * @str: (nullable) (transfer none): A line of string representation of the #ICalComponent
 *
 * Add a line at one time into the #ICalParser until the parsing is complete and #ICalComponent will be
 * returned.
 *
 * Returns: (nullable) (transfer full): The complete #ICalComponent.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_parser_add_line (ICalParser *parser, 
                       gchar *str)
{
	g_return_val_if_fail (I_CAL_IS_PARSER (parser), NULL);

	return i_cal_component_new_full (icalparser_add_line ((icalparser *)i_cal_object_get_native (I_CAL_OBJECT (parser)), str), (gpointer) parser);
}

/**
 * i_cal_parser_clean:
 * @parser: The parser to be cleaned and queried
 *
 * We won't get a clean exit if some components did not have an "END" tag. Clear off any component that
 * may be left in the list.
 *
 * Returns: (nullable) (transfer full): The root #ICalComponent in @parser.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_parser_clean (ICalParser *parser)
{
	g_return_val_if_fail (I_CAL_IS_PARSER (parser), NULL);

	return i_cal_component_new_full (icalparser_clean ((icalparser *)i_cal_object_get_native (I_CAL_OBJECT (parser))), (gpointer) parser);
}

/**
 * i_cal_parser_get_state:
 * @parser: The #ICalParser to be queried
 *
 * Gets the state of the target parser.
 *
 * Returns: The parser state stored in the #ICalParser.
 *
 * Since: 1.0
 *
 **/
ICalParserState
i_cal_parser_get_state (ICalParser *parser)
{
	g_return_val_if_fail (I_CAL_IS_PARSER (parser), I_CAL_PARSER_ERROR);

	return (ICalParserState) (icalparser_get_state ((icalparser *)i_cal_object_get_native (I_CAL_OBJECT (parser))));
}

/**
 * i_cal_parser_free:
 * @parser: The #ICalParser to be freed
 *
 * Frees a #ICalParser.
 *
 * Since: 1.0
 *
 **/
void
i_cal_parser_free (ICalParser *parser)
{
	g_return_if_fail (I_CAL_IS_PARSER (parser));

	icalparser_free ((icalparser *)i_cal_object_get_native (I_CAL_OBJECT (parser)));
}

/**
 * i_cal_parser_parse:
 * @parser: The parser used to parse the string and output the #ICalComponent
 * @func: (scope call): The function used to parse
 * @user_data: (closure): The data given to @func
 *
 * icalparser_parse takes a string that holds the text ( in RFC 2445 format ) and returns a pointer to an
 * #ICalComponent. The caller owns the memory. @func is a pointer to a function that returns one content
 * line per invocation.
 *
 * Returns: (transfer full): The component output by the parser.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_parser_parse (ICalParser *parser, 
                    ICalParserLineGenFunc func, 
                    gpointer user_data)
{
	g_return_val_if_fail (parser != NULL && func != NULL, NULL);

	icalparser_set_gen_data ((icalparser *)i_cal_object_get_native ((ICalObject *)parser), user_data);
	return i_cal_component_new_full (icalparser_parse ((icalparser *)i_cal_object_get_native ((ICalObject *)parser), func), NULL);
}

/**
 * i_cal_parser_parse_string:
 * @str: The string to be parsed
 *
 * Parses the string into a #ICalComponent.
 *
 * Returns: (transfer full): The #ICalComponent parsed from str.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_parser_parse_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return i_cal_component_new_full (icalparser_parse_string (str), NULL);
}

/**
 * i_cal_parser_get_line:
 * @parser: The parser to be queried
 * @func: (scope call): A line generator function
 * @user_data: (closure): The data given to @func
 *
 * Given a line generator function, returns a single iCal content line.
 *
 * Returns: (transfer full): A single iCal content line.
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_parser_get_line (ICalParser *parser, 
                       ICalParserLineGenFunc func, 
                       gpointer user_data)
{
	g_return_val_if_fail (parser != NULL && func != NULL, NULL);

	icalparser_set_gen_data ((icalparser *)i_cal_object_get_native ((ICalObject *)parser), user_data);
	return icalparser_get_line ((icalparser *)i_cal_object_get_native ((ICalObject *)parser), func);
}
