#line 1 "numpy/core/src/umath/loops_autovec.dispatch.c.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/*@targets
 ** $maxopt $autovec baseline
 ** sse2 avx2
 ** neon
 ** vsx2
 ** vx
 **/
#define _UMATHMODULE
#define _MULTIARRAYMODULE
#define NPY_NO_DEPRECATED_API NPY_API_VERSION

#include "simd/simd.h"
#include "loops_utils.h"
#include "loops.h"
// Provides the various *_LOOP macros
#include "fast_loop_macros.h"

/*
 *****************************************************************************
 **                           INTEGER LOOPS
 *****************************************************************************
 */
/*
 * Arithmetic bit shift operations.
 *
 * Intel hardware masks bit shift values, so large shifts wrap around
 * and can produce surprising results. The special handling ensures that
 * behavior is independent of compiler or hardware.
 * TODO: We could implement consistent behavior for negative shifts,
 *       which is undefined in C.
 */
#define INT_left_shift_needs_clear_floatstatus
#define UINT_left_shift_needs_clear_floatstatus

#line 45

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_positive)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = +in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_square)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = in * in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_reciprocal)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = 1.0 / in);
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_add)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_byte, io1 += in2);
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 + in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_subtract)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_byte, io1 -= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 - in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_multiply)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_byte, io1 *= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 * in2);
    }
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_left_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps,
                  void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_byte, npy_byte, *out = npy_lshifthh(in1, in2));
#ifdef BYTE_left_shift_needs_clear_floatstatus
    // For some reason, our macOS CI sets an "invalid" flag here, but only
    // for some types.
    npy_clear_floatstatus_barrier((char*)dimensions);
#endif
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_right_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
#ifndef NPY_DO_NOT_OPTIMIZE_BYTE_right_shift
    BINARY_LOOP_FAST(npy_byte, npy_byte, *out = npy_rshifthh(in1, in2));
#else
    BINARY_LOOP {
        npy_byte in1 = *(npy_byte *)ip1;
        npy_byte in2 = *(npy_byte *)ip2;
        *(npy_byte *)op1 = npy_rshifthh(in1, in2);
    }
#endif
}

#line 45

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_positive)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = +in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_square)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in * in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_reciprocal)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = 1.0 / in);
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_add)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ubyte, io1 += in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 + in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_subtract)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ubyte, io1 -= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 - in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_multiply)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ubyte, io1 *= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 * in2);
    }
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_left_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps,
                  void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = npy_lshiftuhh(in1, in2));
#ifdef UBYTE_left_shift_needs_clear_floatstatus
    // For some reason, our macOS CI sets an "invalid" flag here, but only
    // for some types.
    npy_clear_floatstatus_barrier((char*)dimensions);
#endif
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_right_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
#ifndef NPY_DO_NOT_OPTIMIZE_UBYTE_right_shift
    BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = npy_rshiftuhh(in1, in2));
#else
    BINARY_LOOP {
        npy_ubyte in1 = *(npy_ubyte *)ip1;
        npy_ubyte in2 = *(npy_ubyte *)ip2;
        *(npy_ubyte *)op1 = npy_rshiftuhh(in1, in2);
    }
#endif
}

#line 45

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_positive)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = +in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_square)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = in * in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_reciprocal)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = 1.0 / in);
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_add)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_short, io1 += in2);
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 + in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_subtract)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_short, io1 -= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 - in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_multiply)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_short, io1 *= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 * in2);
    }
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_left_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps,
                  void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_short, npy_short, *out = npy_lshifth(in1, in2));
#ifdef SHORT_left_shift_needs_clear_floatstatus
    // For some reason, our macOS CI sets an "invalid" flag here, but only
    // for some types.
    npy_clear_floatstatus_barrier((char*)dimensions);
#endif
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_right_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
#ifndef NPY_DO_NOT_OPTIMIZE_SHORT_right_shift
    BINARY_LOOP_FAST(npy_short, npy_short, *out = npy_rshifth(in1, in2));
#else
    BINARY_LOOP {
        npy_short in1 = *(npy_short *)ip1;
        npy_short in2 = *(npy_short *)ip2;
        *(npy_short *)op1 = npy_rshifth(in1, in2);
    }
#endif
}

#line 45

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_positive)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = +in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_square)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in * in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_reciprocal)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = 1.0 / in);
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_add)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ushort, io1 += in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 + in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_subtract)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ushort, io1 -= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 - in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_multiply)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ushort, io1 *= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 * in2);
    }
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_left_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps,
                  void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = npy_lshiftuh(in1, in2));
#ifdef USHORT_left_shift_needs_clear_floatstatus
    // For some reason, our macOS CI sets an "invalid" flag here, but only
    // for some types.
    npy_clear_floatstatus_barrier((char*)dimensions);
#endif
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_right_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
#ifndef NPY_DO_NOT_OPTIMIZE_USHORT_right_shift
    BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = npy_rshiftuh(in1, in2));
#else
    BINARY_LOOP {
        npy_ushort in1 = *(npy_ushort *)ip1;
        npy_ushort in2 = *(npy_ushort *)ip2;
        *(npy_ushort *)op1 = npy_rshiftuh(in1, in2);
    }
#endif
}

#line 45

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_positive)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = +in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_square)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = in * in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_reciprocal)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = 1.0 / in);
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_add)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_int, io1 += in2);
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 + in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_subtract)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_int, io1 -= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 - in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_multiply)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_int, io1 *= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 * in2);
    }
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_left_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps,
                  void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_int, npy_int, *out = npy_lshift(in1, in2));
#ifdef INT_left_shift_needs_clear_floatstatus
    // For some reason, our macOS CI sets an "invalid" flag here, but only
    // for some types.
    npy_clear_floatstatus_barrier((char*)dimensions);
#endif
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_right_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
#ifndef NPY_DO_NOT_OPTIMIZE_INT_right_shift
    BINARY_LOOP_FAST(npy_int, npy_int, *out = npy_rshift(in1, in2));
#else
    BINARY_LOOP {
        npy_int in1 = *(npy_int *)ip1;
        npy_int in2 = *(npy_int *)ip2;
        *(npy_int *)op1 = npy_rshift(in1, in2);
    }
#endif
}

#line 45

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_positive)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = +in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_square)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = in * in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_reciprocal)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = 1.0 / in);
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_add)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_uint, io1 += in2);
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 + in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_subtract)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_uint, io1 -= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 - in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_multiply)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_uint, io1 *= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 * in2);
    }
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_left_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps,
                  void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_uint, npy_uint, *out = npy_lshiftu(in1, in2));
#ifdef UINT_left_shift_needs_clear_floatstatus
    // For some reason, our macOS CI sets an "invalid" flag here, but only
    // for some types.
    npy_clear_floatstatus_barrier((char*)dimensions);
#endif
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_right_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
#ifndef NPY_DO_NOT_OPTIMIZE_UINT_right_shift
    BINARY_LOOP_FAST(npy_uint, npy_uint, *out = npy_rshiftu(in1, in2));
#else
    BINARY_LOOP {
        npy_uint in1 = *(npy_uint *)ip1;
        npy_uint in2 = *(npy_uint *)ip2;
        *(npy_uint *)op1 = npy_rshiftu(in1, in2);
    }
#endif
}

#line 45

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_positive)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = +in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_square)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = in * in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_reciprocal)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = 1.0 / in);
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_add)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_long, io1 += in2);
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 + in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_subtract)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_long, io1 -= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 - in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_multiply)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_long, io1 *= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 * in2);
    }
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_left_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps,
                  void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_long, npy_long, *out = npy_lshiftl(in1, in2));
#ifdef LONG_left_shift_needs_clear_floatstatus
    // For some reason, our macOS CI sets an "invalid" flag here, but only
    // for some types.
    npy_clear_floatstatus_barrier((char*)dimensions);
#endif
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_right_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
#ifndef NPY_DO_NOT_OPTIMIZE_LONG_right_shift
    BINARY_LOOP_FAST(npy_long, npy_long, *out = npy_rshiftl(in1, in2));
#else
    BINARY_LOOP {
        npy_long in1 = *(npy_long *)ip1;
        npy_long in2 = *(npy_long *)ip2;
        *(npy_long *)op1 = npy_rshiftl(in1, in2);
    }
#endif
}

#line 45

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_positive)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = +in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_square)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in * in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_reciprocal)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = 1.0 / in);
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_add)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ulong, io1 += in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 + in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_subtract)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ulong, io1 -= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 - in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_multiply)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ulong, io1 *= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 * in2);
    }
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_left_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps,
                  void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = npy_lshiftul(in1, in2));
#ifdef ULONG_left_shift_needs_clear_floatstatus
    // For some reason, our macOS CI sets an "invalid" flag here, but only
    // for some types.
    npy_clear_floatstatus_barrier((char*)dimensions);
#endif
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_right_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
#ifndef NPY_DO_NOT_OPTIMIZE_ULONG_right_shift
    BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = npy_rshiftul(in1, in2));
#else
    BINARY_LOOP {
        npy_ulong in1 = *(npy_ulong *)ip1;
        npy_ulong in2 = *(npy_ulong *)ip2;
        *(npy_ulong *)op1 = npy_rshiftul(in1, in2);
    }
#endif
}

#line 45

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_positive)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = +in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_square)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in * in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_reciprocal)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = 1.0 / in);
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_add)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_longlong, io1 += in2);
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 + in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_subtract)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_longlong, io1 -= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 - in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_multiply)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_longlong, io1 *= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 * in2);
    }
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_left_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps,
                  void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = npy_lshiftll(in1, in2));
#ifdef LONGLONG_left_shift_needs_clear_floatstatus
    // For some reason, our macOS CI sets an "invalid" flag here, but only
    // for some types.
    npy_clear_floatstatus_barrier((char*)dimensions);
#endif
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_right_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
#ifndef NPY_DO_NOT_OPTIMIZE_LONGLONG_right_shift
    BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = npy_rshiftll(in1, in2));
#else
    BINARY_LOOP {
        npy_longlong in1 = *(npy_longlong *)ip1;
        npy_longlong in2 = *(npy_longlong *)ip2;
        *(npy_longlong *)op1 = npy_rshiftll(in1, in2);
    }
#endif
}

#line 45

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_positive)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = +in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_square)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in * in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_reciprocal)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = 1.0 / in);
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_add)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ulonglong, io1 += in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 + in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_subtract)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ulonglong, io1 -= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 - in2);
    }
}

#line 69
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_multiply)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ulonglong, io1 *= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 * in2);
    }
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_left_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps,
                  void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = npy_lshiftull(in1, in2));
#ifdef ULONGLONG_left_shift_needs_clear_floatstatus
    // For some reason, our macOS CI sets an "invalid" flag here, but only
    // for some types.
    npy_clear_floatstatus_barrier((char*)dimensions);
#endif
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_right_shift)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
#ifndef NPY_DO_NOT_OPTIMIZE_ULONGLONG_right_shift
    BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = npy_rshiftull(in1, in2));
#else
    BINARY_LOOP {
        npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        *(npy_ulonglong *)op1 = npy_rshiftull(in1, in2);
    }
#endif
}


/*
 *****************************************************************************
 **                         UNSIGNED INTEGER LOOPS
 *****************************************************************************
 */
#line 118
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_absolute)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_sign)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in > 0 ? 1 : 0);
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_bitwise_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ubyte, io1 &= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 & in2);
    }
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_bitwise_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ubyte, io1 |= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 | in2);
    }
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_bitwise_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ubyte, io1 ^= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 ^ in2);
    }
}


#line 151
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_logical_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 && in2);
}

#line 151
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_logical_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 || in2);
}


NPY_FINLINE npy_bool UBYTE_logical_xor_(npy_ubyte in1, npy_ubyte in2)
{ return (!!in1) != (!!in2); }

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_logical_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = UBYTE_logical_xor_(in1, in2));
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(UBYTE_isnan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_ubyte, npy_bool, (void)in; *out = NPY_FALSE);
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(UBYTE_isinf)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_ubyte, npy_bool, (void)in; *out = NPY_FALSE);
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(UBYTE_isfinite)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_ubyte, npy_bool, (void)in; *out = NPY_TRUE);
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_conjugate)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_logical_not)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_bool, *out = !in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UBYTE_invert)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = ~in);
}

#line 118
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_absolute)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_sign)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in > 0 ? 1 : 0);
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_bitwise_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ushort, io1 &= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 & in2);
    }
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_bitwise_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ushort, io1 |= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 | in2);
    }
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_bitwise_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ushort, io1 ^= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 ^ in2);
    }
}


#line 151
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_logical_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 && in2);
}

#line 151
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_logical_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 || in2);
}


NPY_FINLINE npy_bool USHORT_logical_xor_(npy_ushort in1, npy_ushort in2)
{ return (!!in1) != (!!in2); }

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_logical_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = USHORT_logical_xor_(in1, in2));
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(USHORT_isnan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_ushort, npy_bool, (void)in; *out = NPY_FALSE);
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(USHORT_isinf)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_ushort, npy_bool, (void)in; *out = NPY_FALSE);
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(USHORT_isfinite)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_ushort, npy_bool, (void)in; *out = NPY_TRUE);
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_conjugate)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_logical_not)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_bool, *out = !in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(USHORT_invert)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = ~in);
}

#line 118
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_absolute)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_sign)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = in > 0 ? 1 : 0);
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_bitwise_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_uint, io1 &= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 & in2);
    }
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_bitwise_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_uint, io1 |= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 | in2);
    }
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_bitwise_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_uint, io1 ^= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 ^ in2);
    }
}


#line 151
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_logical_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 && in2);
}

#line 151
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_logical_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 || in2);
}


NPY_FINLINE npy_bool UINT_logical_xor_(npy_uint in1, npy_uint in2)
{ return (!!in1) != (!!in2); }

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_logical_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = UINT_logical_xor_(in1, in2));
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(UINT_isnan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_uint, npy_bool, (void)in; *out = NPY_FALSE);
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(UINT_isinf)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_uint, npy_bool, (void)in; *out = NPY_FALSE);
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(UINT_isfinite)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_uint, npy_bool, (void)in; *out = NPY_TRUE);
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_conjugate)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_logical_not)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_bool, *out = !in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(UINT_invert)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = ~in);
}

#line 118
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_absolute)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_sign)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in > 0 ? 1 : 0);
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_bitwise_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ulong, io1 &= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 & in2);
    }
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_bitwise_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ulong, io1 |= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 | in2);
    }
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_bitwise_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ulong, io1 ^= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 ^ in2);
    }
}


#line 151
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_logical_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 && in2);
}

#line 151
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_logical_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 || in2);
}


NPY_FINLINE npy_bool ULONG_logical_xor_(npy_ulong in1, npy_ulong in2)
{ return (!!in1) != (!!in2); }

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_logical_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = ULONG_logical_xor_(in1, in2));
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(ULONG_isnan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_ulong, npy_bool, (void)in; *out = NPY_FALSE);
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(ULONG_isinf)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_ulong, npy_bool, (void)in; *out = NPY_FALSE);
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(ULONG_isfinite)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_ulong, npy_bool, (void)in; *out = NPY_TRUE);
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_conjugate)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_logical_not)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_bool, *out = !in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONG_invert)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = ~in);
}

#line 118
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_absolute)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_sign)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in > 0 ? 1 : 0);
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_bitwise_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ulonglong, io1 &= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 & in2);
    }
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_bitwise_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ulonglong, io1 |= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 | in2);
    }
}

#line 135
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_bitwise_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP_FAST(npy_ulonglong, io1 ^= in2);
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 ^ in2);
    }
}


#line 151
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_logical_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 && in2);
}

#line 151
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_logical_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 || in2);
}


NPY_FINLINE npy_bool ULONGLONG_logical_xor_(npy_ulonglong in1, npy_ulonglong in2)
{ return (!!in1) != (!!in2); }

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_logical_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = ULONGLONG_logical_xor_(in1, in2));
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(ULONGLONG_isnan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_ulonglong, npy_bool, (void)in; *out = NPY_FALSE);
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(ULONGLONG_isinf)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_ulonglong, npy_bool, (void)in; *out = NPY_FALSE);
}

#line 176
NPY_NO_EXPORT void  NPY_CPU_DISPATCH_CURFX(ULONGLONG_isfinite)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * The (void)in; suppresses an unused variable warning raised by gcc and allows
     * us to re-use this macro even though we do not depend on in
     */
    UNARY_LOOP_FAST(npy_ulonglong, npy_bool, (void)in; *out = NPY_TRUE);
}


NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_conjugate)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_logical_not)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = !in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(ULONGLONG_invert)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = ~in);
}


/*
 *****************************************************************************
 **                         SIGNED! INTEGER LOOPS
 *****************************************************************************
 */

#line 217

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_absolute)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = (in >= 0) ? in : -in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_sign)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = in > 0 ? 1 : (in < 0 ? -1 : 0));
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_conjugate)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_conjugate)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_invert)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_invert)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_isnan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_isnan)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_isinf)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_isinf)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_isfinite)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_isfinite)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_logical_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_logical_and)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_logical_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_logical_or)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_logical_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_logical_xor)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_logical_not)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_logical_not)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_bitwise_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_bitwise_and)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_bitwise_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_bitwise_or)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BYTE_bitwise_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_bitwise_xor)(args, dimensions, steps, func);
}


#line 217

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_absolute)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = (in >= 0) ? in : -in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_sign)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = in > 0 ? 1 : (in < 0 ? -1 : 0));
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_conjugate)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(USHORT_conjugate)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_invert)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(USHORT_invert)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_isnan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(USHORT_isnan)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_isinf)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(USHORT_isinf)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_isfinite)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(USHORT_isfinite)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_logical_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(USHORT_logical_and)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_logical_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(USHORT_logical_or)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_logical_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(USHORT_logical_xor)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_logical_not)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(USHORT_logical_not)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_bitwise_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(USHORT_bitwise_and)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_bitwise_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(USHORT_bitwise_or)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(SHORT_bitwise_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(USHORT_bitwise_xor)(args, dimensions, steps, func);
}


#line 217

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_absolute)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = (in >= 0) ? in : -in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_sign)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = in > 0 ? 1 : (in < 0 ? -1 : 0));
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_conjugate)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UINT_conjugate)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_invert)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UINT_invert)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_isnan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UINT_isnan)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_isinf)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UINT_isinf)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_isfinite)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UINT_isfinite)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_logical_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UINT_logical_and)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_logical_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UINT_logical_or)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_logical_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UINT_logical_xor)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_logical_not)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UINT_logical_not)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_bitwise_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UINT_bitwise_and)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_bitwise_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UINT_bitwise_or)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(INT_bitwise_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UINT_bitwise_xor)(args, dimensions, steps, func);
}


#line 217

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_absolute)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = (in >= 0) ? in : -in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_sign)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = in > 0 ? 1 : (in < 0 ? -1 : 0));
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_conjugate)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONG_conjugate)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_invert)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONG_invert)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_isnan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONG_isnan)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_isinf)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONG_isinf)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_isfinite)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONG_isfinite)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_logical_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONG_logical_and)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_logical_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONG_logical_or)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_logical_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONG_logical_xor)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_logical_not)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONG_logical_not)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_bitwise_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONG_bitwise_and)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_bitwise_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONG_bitwise_or)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONG_bitwise_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONG_bitwise_xor)(args, dimensions, steps, func);
}


#line 217

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_absolute)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = (in >= 0) ? in : -in);
}

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_sign)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in > 0 ? 1 : (in < 0 ? -1 : 0));
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_conjugate)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_conjugate)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_invert)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_invert)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_isnan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_isnan)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_isinf)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_isinf)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_isfinite)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_isfinite)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_logical_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_logical_and)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_logical_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_logical_or)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_logical_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_logical_xor)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_logical_not)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_logical_not)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_bitwise_and)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_bitwise_and)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_bitwise_or)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_bitwise_or)(args, dimensions, steps, func);
}

#line 235
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(LONGLONG_bitwise_xor)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_bitwise_xor)(args, dimensions, steps, func);
}



/*
 *****************************************************************************
 **                             BOOLEAN LOOPS                               **
 *****************************************************************************
 */
#line 253
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BOOL_isnan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_isnan)(args, dimensions, steps, func);
}

#line 253
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BOOL_isinf)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_isinf)(args, dimensions, steps, func);
}

#line 253
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(BOOL_isfinite)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(UBYTE_isfinite)(args, dimensions, steps, func);
}


/*
 *****************************************************************************
 **                          HALF-FLOAT LOOPS                               **
 *****************************************************************************
 */

NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(HALF_absolute)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_half, npy_half, *out = in&0x7fffu);
}

/*
 *****************************************************************************
 **                           DATETIME LOOPS                                **
 *****************************************************************************
 */

#line 282
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DATETIME_isinf)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_isinf)(args, dimensions, steps, func);
}

#line 282
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(TIMEDELTA_isinf)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    NPY_CPU_DISPATCH_CURFX(ULONGLONG_isinf)(args, dimensions, steps, func);
}


