#line 1 "numpy/core/src/multiarray/arraytypes.c.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/* -*- c -*- */
#define PY_SSIZE_T_CLEAN
#include <Python.h>
#include <structmember.h>
#include <limits.h>
#include <assert.h>

#define NPY_NO_DEPRECATED_API NPY_API_VERSION
#define _MULTIARRAYMODULE
#define _UMATHMODULE
#define _NPY_NO_DEPRECATIONS /* for NPY_CHAR */

#include "numpy/npy_common.h"
#include "numpy/arrayobject.h"
#include "numpy/arrayscalars.h"
#include "npy_pycompat.h"
#include "numpy/npy_math.h"
#include "numpy/halffloat.h"

#include "npy_config.h"
#include "npy_sort.h"
#include "common.h"
#include "ctors.h"
#include "convert_datatype.h"
#include "dtypemeta.h"
#include "lowlevel_strided_loops.h"
#include "usertypes.h"
#include "_datetime.h"
#include "arrayobject.h"
#include "alloc.h"
#include "typeinfo.h"

#include "npy_longdouble.h"
#include "numpyos.h"
#include <string.h>

#include "cblasfuncs.h"
#include "npy_cblas.h"
#include "npy_buffer.h"

#include "arraytypes.h"

#include "umathmodule.h"

/*
 * Define a stack allocated dummy array with only the minimum information set:
 *   1. The descr, the main field interesting here.
 *   2. The flags, which are needed for alignment;.
 *   3. The type is set to NULL and the base is the original array, if this
 *      is used within a subarray getitem to create a new view, the base
 *      must be walked until the type is not NULL.
 *
 * The following should create errors in debug mode (if deallocated
 * incorrectly), since base would be incorrectly decref'd as well.
 * This is especially important for nonzero and copyswap, which may run with
 * the GIL released.
 */
static inline PyArrayObject_fields
get_dummy_stack_array(PyArrayObject *orig)
{
    PyArrayObject_fields new_fields;
    new_fields.flags = PyArray_FLAGS(orig);
    /* Set to NULL so the dummy object can be distinguished from the real one */
    Py_SET_TYPE(&new_fields, NULL);
    new_fields.base = (PyObject *)orig;
    return new_fields;
}


/* check for sequences, but ignore the types numpy considers scalars */
static inline npy_bool
PySequence_NoString_Check(PyObject *op) {
    return
        PySequence_Check(op) &&
        !PyBytes_Check(op) &&
        !PyUnicode_Check(op) &&
        !PyArray_IsZeroDim(op);
}

/*
 *****************************************************************************
 **                        PYTHON TYPES TO C TYPES                          **
 *****************************************************************************
 */

static double
MyPyFloat_AsDouble(PyObject *obj)
{
    double ret = 0;
    PyObject *num;

    if (obj == Py_None) {
        return NPY_NAN;
    }
    num = PyNumber_Float(obj);
    if (num == NULL) {
        return NPY_NAN;
    }
    ret = PyFloat_AS_DOUBLE(num);
    Py_DECREF(num);
    return ret;
}


static float
MyPyFloat_AsFloat(PyObject *obj)
{
    double d_val = MyPyFloat_AsDouble(obj);
    float res = (float)d_val;
    if (NPY_UNLIKELY(npy_isinf(res) && !npy_isinf(d_val))) {
        if (PyUFunc_GiveFloatingpointErrors("cast", NPY_FPE_OVERFLOW) < 0) {
            return -1;
        }
    }
    return res;
}


static npy_half
MyPyFloat_AsHalf(PyObject *obj)
{
    double d_val = MyPyFloat_AsDouble(obj);
    npy_half res = npy_double_to_half(d_val);
    if (NPY_UNLIKELY(npy_half_isinf(res) && !npy_isinf(d_val))) {
        if (PyUFunc_GiveFloatingpointErrors("cast", NPY_FPE_OVERFLOW) < 0) {
            return npy_double_to_half(-1.);
        }
    }
    return res;
}

static PyObject *
MyPyFloat_FromHalf(npy_half h)
{
    return PyFloat_FromDouble(npy_half_to_double(h));
}

/* Handle case of assigning from an array scalar in setitem */
static int
convert_to_scalar_and_retry(PyObject *op, void *ov, void *vap,
                      int (*setitem)(PyObject *op, void *ov, void *vap))
{
    PyObject *temp;

    assert(PyArray_IsZeroDim(op));
    temp = PyArray_ToScalar(PyArray_BYTES((PyArrayObject *)op),
                                      (PyArrayObject *)op);
    if (temp == NULL) {
        return -1;
    }
    else {
        int res = setitem(temp, ov, vap);
        Py_DECREF(temp);
        return res;
    }
}


#line 164
static npy_long
MyPyLong_AsLong (PyObject *obj)
{
    npy_long ret;
    PyObject *num = PyNumber_Long(obj);

    if (num == NULL) {
        return -1;
    }
    ret = PyLong_AsLong(num);
    Py_DECREF(num);
    return ret;
}

static npy_long
MyPyLong_AsLongWithWrap(PyObject *obj, int *wraparound)
{
    *wraparound = 0;  /* Never happens within the function */
    return MyPyLong_AsLong(obj);
}


#line 164
static npy_longlong
MyPyLong_AsLongLong (PyObject *obj)
{
    npy_longlong ret;
    PyObject *num = PyNumber_Long(obj);

    if (num == NULL) {
        return -1;
    }
    ret = PyLong_AsLongLong(num);
    Py_DECREF(num);
    return ret;
}

static npy_longlong
MyPyLong_AsLongLongWithWrap(PyObject *obj, int *wraparound)
{
    *wraparound = 0;  /* Never happens within the function */
    return MyPyLong_AsLongLong(obj);
}



#line 192
static npy_ulong
MyPyLong_AsUnsignedLongWithWrap(PyObject *obj, int *wraparound)
{
    npy_ulong ret;
    *wraparound = 0;
    PyObject *num = PyNumber_Long(obj);

    if (num == NULL) {
        return -1;
    }
    ret = PyLong_AsUnsignedLong(num);
    if (PyErr_Occurred()) {
        PyErr_Clear();
        *wraparound = 1;  /* negative wrapped to positive */
        ret = PyLong_AsLong(num);
    }
    Py_DECREF(num);
    return ret;
}

static npy_ulong
MyPyLong_AsUnsignedLong(PyObject *obj)
{
    int wraparound;
    return MyPyLong_AsUnsignedLongWithWrap(obj, &wraparound);
}



#line 192
static npy_ulonglong
MyPyLong_AsUnsignedLongLongWithWrap(PyObject *obj, int *wraparound)
{
    npy_ulonglong ret;
    *wraparound = 0;
    PyObject *num = PyNumber_Long(obj);

    if (num == NULL) {
        return -1;
    }
    ret = PyLong_AsUnsignedLongLong(num);
    if (PyErr_Occurred()) {
        PyErr_Clear();
        *wraparound = 1;  /* negative wrapped to positive */
        ret = PyLong_AsLongLong(num);
    }
    Py_DECREF(num);
    return ret;
}

static npy_ulonglong
MyPyLong_AsUnsignedLongLong(PyObject *obj)
{
    int wraparound;
    return MyPyLong_AsUnsignedLongLongWithWrap(obj, &wraparound);
}




/*
 *****************************************************************************
 **                         GETITEM AND SETITEM                             **
 *****************************************************************************
 */
/*
 * Disable harmless compiler warning "4116: unnamed type definition in
 * parentheses" which is caused by the _ALIGN macro.
 */
#if defined(_MSC_VER)
#pragma warning(disable:4116)
#endif


#line 250

/*
 * Helper for conversion from Python integers.  This uses the same conversion
 * function as below for compatibility (which may seem strange).
 * However, it adds more strict integer overflow checks to prevent mainly
 * conversion of negative integers.  These are considered deprecated, which is
 * related to NEP 50 (but somewhat independent).
 */
static int
BYTE_safe_pyint_setitem(PyObject *obj, npy_byte *result)
{
    /* Input is guaranteed to be a Python integer */
    assert(PyLong_Check(obj));
    int wraparound;
    npy_long value = MyPyLong_AsLongWithWrap(obj, &wraparound);
    if (value == (npy_long)-1 && PyErr_Occurred()) {
        return -1;
    }
    *result = (npy_byte)value;

    if (wraparound
#if NPY_SIZEOF_BYTE < NPY_SIZEOF_LONG
            || *result != value
#endif
            ) {
        PyArray_Descr *descr = PyArray_DescrFromType(NPY_BYTE);

        if (npy_promotion_state == NPY_USE_LEGACY_PROMOTION || (
                    npy_promotion_state == NPY_USE_WEAK_PROMOTION_AND_WARN
                        && !npy_give_promotion_warnings())) {
            /*
             * This path will be taken both for the "promotion" case such as
             * `uint8_arr + 123` as well as the assignment case.
             * The "legacy" path should only ever be taken for assignment
             * (legacy promotion will prevent overflows by promoting up)
             * so a normal deprecation makes sense.
             * When weak promotion is active, we use "future" behavior unless
             * warnings were explicitly opt-in.
             */
            if (PyErr_WarnFormat(PyExc_DeprecationWarning, 1,
                    "NumPy will stop allowing conversion of out-of-bound "
                    "Python integers to integer arrays.  The conversion "
                    "of %.100R to %S will fail in the future.\n"
                    "For the old behavior, usually:\n"
                    "    np.array(value).astype(dtype)\n"
                    "will give the desired result (the cast overflows).",
                    obj, descr) < 0) {
                Py_DECREF(descr);
                return -1;
            }
            Py_DECREF(descr);
            return 0;
        }
        else {
            /* Live in the future, outright error: */
            PyErr_Format(PyExc_OverflowError,
                    "Python integer %R out of bounds for %S", obj, descr);
            Py_DECREF(descr);
            return -1;
            }
        assert(0);
    }
    return 0;
}


#line 250

/*
 * Helper for conversion from Python integers.  This uses the same conversion
 * function as below for compatibility (which may seem strange).
 * However, it adds more strict integer overflow checks to prevent mainly
 * conversion of negative integers.  These are considered deprecated, which is
 * related to NEP 50 (but somewhat independent).
 */
static int
SHORT_safe_pyint_setitem(PyObject *obj, npy_short *result)
{
    /* Input is guaranteed to be a Python integer */
    assert(PyLong_Check(obj));
    int wraparound;
    npy_long value = MyPyLong_AsLongWithWrap(obj, &wraparound);
    if (value == (npy_long)-1 && PyErr_Occurred()) {
        return -1;
    }
    *result = (npy_short)value;

    if (wraparound
#if NPY_SIZEOF_SHORT < NPY_SIZEOF_LONG
            || *result != value
#endif
            ) {
        PyArray_Descr *descr = PyArray_DescrFromType(NPY_SHORT);

        if (npy_promotion_state == NPY_USE_LEGACY_PROMOTION || (
                    npy_promotion_state == NPY_USE_WEAK_PROMOTION_AND_WARN
                        && !npy_give_promotion_warnings())) {
            /*
             * This path will be taken both for the "promotion" case such as
             * `uint8_arr + 123` as well as the assignment case.
             * The "legacy" path should only ever be taken for assignment
             * (legacy promotion will prevent overflows by promoting up)
             * so a normal deprecation makes sense.
             * When weak promotion is active, we use "future" behavior unless
             * warnings were explicitly opt-in.
             */
            if (PyErr_WarnFormat(PyExc_DeprecationWarning, 1,
                    "NumPy will stop allowing conversion of out-of-bound "
                    "Python integers to integer arrays.  The conversion "
                    "of %.100R to %S will fail in the future.\n"
                    "For the old behavior, usually:\n"
                    "    np.array(value).astype(dtype)\n"
                    "will give the desired result (the cast overflows).",
                    obj, descr) < 0) {
                Py_DECREF(descr);
                return -1;
            }
            Py_DECREF(descr);
            return 0;
        }
        else {
            /* Live in the future, outright error: */
            PyErr_Format(PyExc_OverflowError,
                    "Python integer %R out of bounds for %S", obj, descr);
            Py_DECREF(descr);
            return -1;
            }
        assert(0);
    }
    return 0;
}


#line 250

/*
 * Helper for conversion from Python integers.  This uses the same conversion
 * function as below for compatibility (which may seem strange).
 * However, it adds more strict integer overflow checks to prevent mainly
 * conversion of negative integers.  These are considered deprecated, which is
 * related to NEP 50 (but somewhat independent).
 */
static int
INT_safe_pyint_setitem(PyObject *obj, npy_int *result)
{
    /* Input is guaranteed to be a Python integer */
    assert(PyLong_Check(obj));
    int wraparound;
    npy_long value = MyPyLong_AsLongWithWrap(obj, &wraparound);
    if (value == (npy_long)-1 && PyErr_Occurred()) {
        return -1;
    }
    *result = (npy_int)value;

    if (wraparound
#if NPY_SIZEOF_INT < NPY_SIZEOF_LONG
            || *result != value
#endif
            ) {
        PyArray_Descr *descr = PyArray_DescrFromType(NPY_INT);

        if (npy_promotion_state == NPY_USE_LEGACY_PROMOTION || (
                    npy_promotion_state == NPY_USE_WEAK_PROMOTION_AND_WARN
                        && !npy_give_promotion_warnings())) {
            /*
             * This path will be taken both for the "promotion" case such as
             * `uint8_arr + 123` as well as the assignment case.
             * The "legacy" path should only ever be taken for assignment
             * (legacy promotion will prevent overflows by promoting up)
             * so a normal deprecation makes sense.
             * When weak promotion is active, we use "future" behavior unless
             * warnings were explicitly opt-in.
             */
            if (PyErr_WarnFormat(PyExc_DeprecationWarning, 1,
                    "NumPy will stop allowing conversion of out-of-bound "
                    "Python integers to integer arrays.  The conversion "
                    "of %.100R to %S will fail in the future.\n"
                    "For the old behavior, usually:\n"
                    "    np.array(value).astype(dtype)\n"
                    "will give the desired result (the cast overflows).",
                    obj, descr) < 0) {
                Py_DECREF(descr);
                return -1;
            }
            Py_DECREF(descr);
            return 0;
        }
        else {
            /* Live in the future, outright error: */
            PyErr_Format(PyExc_OverflowError,
                    "Python integer %R out of bounds for %S", obj, descr);
            Py_DECREF(descr);
            return -1;
            }
        assert(0);
    }
    return 0;
}


#line 250

/*
 * Helper for conversion from Python integers.  This uses the same conversion
 * function as below for compatibility (which may seem strange).
 * However, it adds more strict integer overflow checks to prevent mainly
 * conversion of negative integers.  These are considered deprecated, which is
 * related to NEP 50 (but somewhat independent).
 */
static int
LONG_safe_pyint_setitem(PyObject *obj, npy_long *result)
{
    /* Input is guaranteed to be a Python integer */
    assert(PyLong_Check(obj));
    int wraparound;
    npy_long value = MyPyLong_AsLongWithWrap(obj, &wraparound);
    if (value == (npy_long)-1 && PyErr_Occurred()) {
        return -1;
    }
    *result = (npy_long)value;

    if (wraparound
#if NPY_SIZEOF_LONG < NPY_SIZEOF_LONG
            || *result != value
#endif
            ) {
        PyArray_Descr *descr = PyArray_DescrFromType(NPY_LONG);

        if (npy_promotion_state == NPY_USE_LEGACY_PROMOTION || (
                    npy_promotion_state == NPY_USE_WEAK_PROMOTION_AND_WARN
                        && !npy_give_promotion_warnings())) {
            /*
             * This path will be taken both for the "promotion" case such as
             * `uint8_arr + 123` as well as the assignment case.
             * The "legacy" path should only ever be taken for assignment
             * (legacy promotion will prevent overflows by promoting up)
             * so a normal deprecation makes sense.
             * When weak promotion is active, we use "future" behavior unless
             * warnings were explicitly opt-in.
             */
            if (PyErr_WarnFormat(PyExc_DeprecationWarning, 1,
                    "NumPy will stop allowing conversion of out-of-bound "
                    "Python integers to integer arrays.  The conversion "
                    "of %.100R to %S will fail in the future.\n"
                    "For the old behavior, usually:\n"
                    "    np.array(value).astype(dtype)\n"
                    "will give the desired result (the cast overflows).",
                    obj, descr) < 0) {
                Py_DECREF(descr);
                return -1;
            }
            Py_DECREF(descr);
            return 0;
        }
        else {
            /* Live in the future, outright error: */
            PyErr_Format(PyExc_OverflowError,
                    "Python integer %R out of bounds for %S", obj, descr);
            Py_DECREF(descr);
            return -1;
            }
        assert(0);
    }
    return 0;
}


#line 250

/*
 * Helper for conversion from Python integers.  This uses the same conversion
 * function as below for compatibility (which may seem strange).
 * However, it adds more strict integer overflow checks to prevent mainly
 * conversion of negative integers.  These are considered deprecated, which is
 * related to NEP 50 (but somewhat independent).
 */
static int
LONGLONG_safe_pyint_setitem(PyObject *obj, npy_longlong *result)
{
    /* Input is guaranteed to be a Python integer */
    assert(PyLong_Check(obj));
    int wraparound;
    npy_longlong value = MyPyLong_AsLongLongWithWrap(obj, &wraparound);
    if (value == (npy_longlong)-1 && PyErr_Occurred()) {
        return -1;
    }
    *result = (npy_longlong)value;

    if (wraparound
#if NPY_SIZEOF_LONGLONG < NPY_SIZEOF_LONGLONG
            || *result != value
#endif
            ) {
        PyArray_Descr *descr = PyArray_DescrFromType(NPY_LONGLONG);

        if (npy_promotion_state == NPY_USE_LEGACY_PROMOTION || (
                    npy_promotion_state == NPY_USE_WEAK_PROMOTION_AND_WARN
                        && !npy_give_promotion_warnings())) {
            /*
             * This path will be taken both for the "promotion" case such as
             * `uint8_arr + 123` as well as the assignment case.
             * The "legacy" path should only ever be taken for assignment
             * (legacy promotion will prevent overflows by promoting up)
             * so a normal deprecation makes sense.
             * When weak promotion is active, we use "future" behavior unless
             * warnings were explicitly opt-in.
             */
            if (PyErr_WarnFormat(PyExc_DeprecationWarning, 1,
                    "NumPy will stop allowing conversion of out-of-bound "
                    "Python integers to integer arrays.  The conversion "
                    "of %.100R to %S will fail in the future.\n"
                    "For the old behavior, usually:\n"
                    "    np.array(value).astype(dtype)\n"
                    "will give the desired result (the cast overflows).",
                    obj, descr) < 0) {
                Py_DECREF(descr);
                return -1;
            }
            Py_DECREF(descr);
            return 0;
        }
        else {
            /* Live in the future, outright error: */
            PyErr_Format(PyExc_OverflowError,
                    "Python integer %R out of bounds for %S", obj, descr);
            Py_DECREF(descr);
            return -1;
            }
        assert(0);
    }
    return 0;
}


#line 250

/*
 * Helper for conversion from Python integers.  This uses the same conversion
 * function as below for compatibility (which may seem strange).
 * However, it adds more strict integer overflow checks to prevent mainly
 * conversion of negative integers.  These are considered deprecated, which is
 * related to NEP 50 (but somewhat independent).
 */
static int
UBYTE_safe_pyint_setitem(PyObject *obj, npy_ubyte *result)
{
    /* Input is guaranteed to be a Python integer */
    assert(PyLong_Check(obj));
    int wraparound;
    npy_ulong value = MyPyLong_AsLongWithWrap(obj, &wraparound);
    if (value == (npy_ulong)-1 && PyErr_Occurred()) {
        return -1;
    }
    *result = (npy_ubyte)value;

    if (wraparound
#if NPY_SIZEOF_BYTE < NPY_SIZEOF_LONG
            || *result != value
#endif
            ) {
        PyArray_Descr *descr = PyArray_DescrFromType(NPY_UBYTE);

        if (npy_promotion_state == NPY_USE_LEGACY_PROMOTION || (
                    npy_promotion_state == NPY_USE_WEAK_PROMOTION_AND_WARN
                        && !npy_give_promotion_warnings())) {
            /*
             * This path will be taken both for the "promotion" case such as
             * `uint8_arr + 123` as well as the assignment case.
             * The "legacy" path should only ever be taken for assignment
             * (legacy promotion will prevent overflows by promoting up)
             * so a normal deprecation makes sense.
             * When weak promotion is active, we use "future" behavior unless
             * warnings were explicitly opt-in.
             */
            if (PyErr_WarnFormat(PyExc_DeprecationWarning, 1,
                    "NumPy will stop allowing conversion of out-of-bound "
                    "Python integers to integer arrays.  The conversion "
                    "of %.100R to %S will fail in the future.\n"
                    "For the old behavior, usually:\n"
                    "    np.array(value).astype(dtype)\n"
                    "will give the desired result (the cast overflows).",
                    obj, descr) < 0) {
                Py_DECREF(descr);
                return -1;
            }
            Py_DECREF(descr);
            return 0;
        }
        else {
            /* Live in the future, outright error: */
            PyErr_Format(PyExc_OverflowError,
                    "Python integer %R out of bounds for %S", obj, descr);
            Py_DECREF(descr);
            return -1;
            }
        assert(0);
    }
    return 0;
}


#line 250

/*
 * Helper for conversion from Python integers.  This uses the same conversion
 * function as below for compatibility (which may seem strange).
 * However, it adds more strict integer overflow checks to prevent mainly
 * conversion of negative integers.  These are considered deprecated, which is
 * related to NEP 50 (but somewhat independent).
 */
static int
USHORT_safe_pyint_setitem(PyObject *obj, npy_ushort *result)
{
    /* Input is guaranteed to be a Python integer */
    assert(PyLong_Check(obj));
    int wraparound;
    npy_ulong value = MyPyLong_AsLongWithWrap(obj, &wraparound);
    if (value == (npy_ulong)-1 && PyErr_Occurred()) {
        return -1;
    }
    *result = (npy_ushort)value;

    if (wraparound
#if NPY_SIZEOF_SHORT < NPY_SIZEOF_LONG
            || *result != value
#endif
            ) {
        PyArray_Descr *descr = PyArray_DescrFromType(NPY_USHORT);

        if (npy_promotion_state == NPY_USE_LEGACY_PROMOTION || (
                    npy_promotion_state == NPY_USE_WEAK_PROMOTION_AND_WARN
                        && !npy_give_promotion_warnings())) {
            /*
             * This path will be taken both for the "promotion" case such as
             * `uint8_arr + 123` as well as the assignment case.
             * The "legacy" path should only ever be taken for assignment
             * (legacy promotion will prevent overflows by promoting up)
             * so a normal deprecation makes sense.
             * When weak promotion is active, we use "future" behavior unless
             * warnings were explicitly opt-in.
             */
            if (PyErr_WarnFormat(PyExc_DeprecationWarning, 1,
                    "NumPy will stop allowing conversion of out-of-bound "
                    "Python integers to integer arrays.  The conversion "
                    "of %.100R to %S will fail in the future.\n"
                    "For the old behavior, usually:\n"
                    "    np.array(value).astype(dtype)\n"
                    "will give the desired result (the cast overflows).",
                    obj, descr) < 0) {
                Py_DECREF(descr);
                return -1;
            }
            Py_DECREF(descr);
            return 0;
        }
        else {
            /* Live in the future, outright error: */
            PyErr_Format(PyExc_OverflowError,
                    "Python integer %R out of bounds for %S", obj, descr);
            Py_DECREF(descr);
            return -1;
            }
        assert(0);
    }
    return 0;
}


#line 250

/*
 * Helper for conversion from Python integers.  This uses the same conversion
 * function as below for compatibility (which may seem strange).
 * However, it adds more strict integer overflow checks to prevent mainly
 * conversion of negative integers.  These are considered deprecated, which is
 * related to NEP 50 (but somewhat independent).
 */
static int
UINT_safe_pyint_setitem(PyObject *obj, npy_uint *result)
{
    /* Input is guaranteed to be a Python integer */
    assert(PyLong_Check(obj));
    int wraparound;
    npy_ulong value = MyPyLong_AsUnsignedLongWithWrap(obj, &wraparound);
    if (value == (npy_ulong)-1 && PyErr_Occurred()) {
        return -1;
    }
    *result = (npy_uint)value;

    if (wraparound
#if NPY_SIZEOF_INT < NPY_SIZEOF_LONG
            || *result != value
#endif
            ) {
        PyArray_Descr *descr = PyArray_DescrFromType(NPY_UINT);

        if (npy_promotion_state == NPY_USE_LEGACY_PROMOTION || (
                    npy_promotion_state == NPY_USE_WEAK_PROMOTION_AND_WARN
                        && !npy_give_promotion_warnings())) {
            /*
             * This path will be taken both for the "promotion" case such as
             * `uint8_arr + 123` as well as the assignment case.
             * The "legacy" path should only ever be taken for assignment
             * (legacy promotion will prevent overflows by promoting up)
             * so a normal deprecation makes sense.
             * When weak promotion is active, we use "future" behavior unless
             * warnings were explicitly opt-in.
             */
            if (PyErr_WarnFormat(PyExc_DeprecationWarning, 1,
                    "NumPy will stop allowing conversion of out-of-bound "
                    "Python integers to integer arrays.  The conversion "
                    "of %.100R to %S will fail in the future.\n"
                    "For the old behavior, usually:\n"
                    "    np.array(value).astype(dtype)\n"
                    "will give the desired result (the cast overflows).",
                    obj, descr) < 0) {
                Py_DECREF(descr);
                return -1;
            }
            Py_DECREF(descr);
            return 0;
        }
        else {
            /* Live in the future, outright error: */
            PyErr_Format(PyExc_OverflowError,
                    "Python integer %R out of bounds for %S", obj, descr);
            Py_DECREF(descr);
            return -1;
            }
        assert(0);
    }
    return 0;
}


#line 250

/*
 * Helper for conversion from Python integers.  This uses the same conversion
 * function as below for compatibility (which may seem strange).
 * However, it adds more strict integer overflow checks to prevent mainly
 * conversion of negative integers.  These are considered deprecated, which is
 * related to NEP 50 (but somewhat independent).
 */
static int
ULONG_safe_pyint_setitem(PyObject *obj, npy_ulong *result)
{
    /* Input is guaranteed to be a Python integer */
    assert(PyLong_Check(obj));
    int wraparound;
    npy_ulong value = MyPyLong_AsUnsignedLongWithWrap(obj, &wraparound);
    if (value == (npy_ulong)-1 && PyErr_Occurred()) {
        return -1;
    }
    *result = (npy_ulong)value;

    if (wraparound
#if NPY_SIZEOF_LONG < NPY_SIZEOF_LONG
            || *result != value
#endif
            ) {
        PyArray_Descr *descr = PyArray_DescrFromType(NPY_ULONG);

        if (npy_promotion_state == NPY_USE_LEGACY_PROMOTION || (
                    npy_promotion_state == NPY_USE_WEAK_PROMOTION_AND_WARN
                        && !npy_give_promotion_warnings())) {
            /*
             * This path will be taken both for the "promotion" case such as
             * `uint8_arr + 123` as well as the assignment case.
             * The "legacy" path should only ever be taken for assignment
             * (legacy promotion will prevent overflows by promoting up)
             * so a normal deprecation makes sense.
             * When weak promotion is active, we use "future" behavior unless
             * warnings were explicitly opt-in.
             */
            if (PyErr_WarnFormat(PyExc_DeprecationWarning, 1,
                    "NumPy will stop allowing conversion of out-of-bound "
                    "Python integers to integer arrays.  The conversion "
                    "of %.100R to %S will fail in the future.\n"
                    "For the old behavior, usually:\n"
                    "    np.array(value).astype(dtype)\n"
                    "will give the desired result (the cast overflows).",
                    obj, descr) < 0) {
                Py_DECREF(descr);
                return -1;
            }
            Py_DECREF(descr);
            return 0;
        }
        else {
            /* Live in the future, outright error: */
            PyErr_Format(PyExc_OverflowError,
                    "Python integer %R out of bounds for %S", obj, descr);
            Py_DECREF(descr);
            return -1;
            }
        assert(0);
    }
    return 0;
}


#line 250

/*
 * Helper for conversion from Python integers.  This uses the same conversion
 * function as below for compatibility (which may seem strange).
 * However, it adds more strict integer overflow checks to prevent mainly
 * conversion of negative integers.  These are considered deprecated, which is
 * related to NEP 50 (but somewhat independent).
 */
static int
ULONGLONG_safe_pyint_setitem(PyObject *obj, npy_ulonglong *result)
{
    /* Input is guaranteed to be a Python integer */
    assert(PyLong_Check(obj));
    int wraparound;
    npy_ulonglong value = MyPyLong_AsUnsignedLongLongWithWrap(obj, &wraparound);
    if (value == (npy_ulonglong)-1 && PyErr_Occurred()) {
        return -1;
    }
    *result = (npy_ulonglong)value;

    if (wraparound
#if NPY_SIZEOF_LONGLONG < NPY_SIZEOF_LONGLONG
            || *result != value
#endif
            ) {
        PyArray_Descr *descr = PyArray_DescrFromType(NPY_ULONGLONG);

        if (npy_promotion_state == NPY_USE_LEGACY_PROMOTION || (
                    npy_promotion_state == NPY_USE_WEAK_PROMOTION_AND_WARN
                        && !npy_give_promotion_warnings())) {
            /*
             * This path will be taken both for the "promotion" case such as
             * `uint8_arr + 123` as well as the assignment case.
             * The "legacy" path should only ever be taken for assignment
             * (legacy promotion will prevent overflows by promoting up)
             * so a normal deprecation makes sense.
             * When weak promotion is active, we use "future" behavior unless
             * warnings were explicitly opt-in.
             */
            if (PyErr_WarnFormat(PyExc_DeprecationWarning, 1,
                    "NumPy will stop allowing conversion of out-of-bound "
                    "Python integers to integer arrays.  The conversion "
                    "of %.100R to %S will fail in the future.\n"
                    "For the old behavior, usually:\n"
                    "    np.array(value).astype(dtype)\n"
                    "will give the desired result (the cast overflows).",
                    obj, descr) < 0) {
                Py_DECREF(descr);
                return -1;
            }
            Py_DECREF(descr);
            return 0;
        }
        else {
            /* Live in the future, outright error: */
            PyErr_Format(PyExc_OverflowError,
                    "Python integer %R out of bounds for %S", obj, descr);
            Py_DECREF(descr);
            return -1;
            }
        assert(0);
    }
    return 0;
}




#line 338
static PyObject *
BOOL_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_bool t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_bool *)ip);
        return PyBool_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return PyBool_FromLong((long)t1);
    }
}

NPY_NO_EXPORT int
BOOL_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_bool temp;  /* ensures alignment */

#if 0
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (BOOL_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, Bool)) {
        temp = PyArrayScalar_VAL(op, Bool);
    }
    else {
        temp = (npy_bool)PyObject_IsTrue(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_bool)));
        *((npy_bool *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}


#line 338
static PyObject *
BYTE_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_byte t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_byte *)ip);
        return PyLong_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return PyLong_FromLong((long)t1);
    }
}

NPY_NO_EXPORT int
BYTE_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_byte temp;  /* ensures alignment */

#if 1
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (BYTE_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, Byte)) {
        temp = PyArrayScalar_VAL(op, Byte);
    }
    else {
        temp = (npy_byte)MyPyLong_AsLong(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_byte)));
        *((npy_byte *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}


#line 338
static PyObject *
UBYTE_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_ubyte t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_ubyte *)ip);
        return PyLong_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return PyLong_FromLong((long)t1);
    }
}

NPY_NO_EXPORT int
UBYTE_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_ubyte temp;  /* ensures alignment */

#if 1
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (UBYTE_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, UByte)) {
        temp = PyArrayScalar_VAL(op, UByte);
    }
    else {
        temp = (npy_ubyte)MyPyLong_AsLong(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_ubyte)));
        *((npy_ubyte *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}


#line 338
static PyObject *
SHORT_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_short t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_short *)ip);
        return PyLong_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return PyLong_FromLong((long)t1);
    }
}

NPY_NO_EXPORT int
SHORT_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_short temp;  /* ensures alignment */

#if 1
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (SHORT_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, Short)) {
        temp = PyArrayScalar_VAL(op, Short);
    }
    else {
        temp = (npy_short)MyPyLong_AsLong(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_short)));
        *((npy_short *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}


#line 338
static PyObject *
USHORT_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_ushort t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_ushort *)ip);
        return PyLong_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return PyLong_FromLong((long)t1);
    }
}

NPY_NO_EXPORT int
USHORT_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_ushort temp;  /* ensures alignment */

#if 1
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (USHORT_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, UShort)) {
        temp = PyArrayScalar_VAL(op, UShort);
    }
    else {
        temp = (npy_ushort)MyPyLong_AsLong(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_ushort)));
        *((npy_ushort *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}


#line 338
static PyObject *
INT_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_int t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_int *)ip);
        return PyLong_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return PyLong_FromLong((long)t1);
    }
}

NPY_NO_EXPORT int
INT_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_int temp;  /* ensures alignment */

#if 1
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (INT_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, Int)) {
        temp = PyArrayScalar_VAL(op, Int);
    }
    else {
        temp = (npy_int)MyPyLong_AsLong(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_int)));
        *((npy_int *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}


#line 338
static PyObject *
LONG_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_long t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_long *)ip);
        return PyLong_FromLong((long)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return PyLong_FromLong((long)t1);
    }
}

NPY_NO_EXPORT int
LONG_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_long temp;  /* ensures alignment */

#if 1
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (LONG_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, Long)) {
        temp = PyArrayScalar_VAL(op, Long);
    }
    else {
        temp = (npy_long)MyPyLong_AsLong(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_long)));
        *((npy_long *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}


#line 338
static PyObject *
UINT_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_uint t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_uint *)ip);
        return PyLong_FromUnsignedLong((npy_ulong)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return PyLong_FromUnsignedLong((npy_ulong)t1);
    }
}

NPY_NO_EXPORT int
UINT_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_uint temp;  /* ensures alignment */

#if 1
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (UINT_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, UInt)) {
        temp = PyArrayScalar_VAL(op, UInt);
    }
    else {
        temp = (npy_uint)MyPyLong_AsUnsignedLong(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_uint)));
        *((npy_uint *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}


#line 338
static PyObject *
ULONG_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_ulong t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_ulong *)ip);
        return PyLong_FromUnsignedLong((npy_ulong)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return PyLong_FromUnsignedLong((npy_ulong)t1);
    }
}

NPY_NO_EXPORT int
ULONG_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_ulong temp;  /* ensures alignment */

#if 1
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (ULONG_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, ULong)) {
        temp = PyArrayScalar_VAL(op, ULong);
    }
    else {
        temp = (npy_ulong)MyPyLong_AsUnsignedLong(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_ulong)));
        *((npy_ulong *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}


#line 338
static PyObject *
LONGLONG_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_longlong t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_longlong *)ip);
        return PyLong_FromLongLong((npy_longlong)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return PyLong_FromLongLong((npy_longlong)t1);
    }
}

NPY_NO_EXPORT int
LONGLONG_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_longlong temp;  /* ensures alignment */

#if 1
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (LONGLONG_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, LongLong)) {
        temp = PyArrayScalar_VAL(op, LongLong);
    }
    else {
        temp = (npy_longlong)MyPyLong_AsLongLong(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_longlong)));
        *((npy_longlong *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}


#line 338
static PyObject *
ULONGLONG_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_ulonglong t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_ulonglong *)ip);
        return PyLong_FromUnsignedLongLong((npy_ulonglong)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return PyLong_FromUnsignedLongLong((npy_ulonglong)t1);
    }
}

NPY_NO_EXPORT int
ULONGLONG_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_ulonglong temp;  /* ensures alignment */

#if 1
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (ULONGLONG_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, ULongLong)) {
        temp = PyArrayScalar_VAL(op, ULongLong);
    }
    else {
        temp = (npy_ulonglong)MyPyLong_AsUnsignedLongLong(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_ulonglong)));
        *((npy_ulonglong *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}


#line 338
static PyObject *
HALF_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_half t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_half *)ip);
        return MyPyFloat_FromHalf((npy_half)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return MyPyFloat_FromHalf((npy_half)t1);
    }
}

NPY_NO_EXPORT int
HALF_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_half temp;  /* ensures alignment */

#if 0
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (HALF_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, Half)) {
        temp = PyArrayScalar_VAL(op, Half);
    }
    else {
        temp = (npy_half)MyPyFloat_AsHalf(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_half)));
        *((npy_half *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}


#line 338
static PyObject *
FLOAT_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_float t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_float *)ip);
        return PyFloat_FromDouble((npy_float)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return PyFloat_FromDouble((npy_float)t1);
    }
}

NPY_NO_EXPORT int
FLOAT_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_float temp;  /* ensures alignment */

#if 0
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (FLOAT_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, Float)) {
        temp = PyArrayScalar_VAL(op, Float);
    }
    else {
        temp = (npy_float)MyPyFloat_AsFloat(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_float)));
        *((npy_float *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}


#line 338
static PyObject *
DOUBLE_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_double t1;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        t1 = *((npy_double *)ip);
        return PyFloat_FromDouble((npy_double)t1);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&t1, ip, PyArray_ISBYTESWAPPED(ap), ap);
        return PyFloat_FromDouble((npy_double)t1);
    }
}

NPY_NO_EXPORT int
DOUBLE_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    npy_double temp;  /* ensures alignment */

#if 0
    if (PyLong_Check(op)) {
        /*
         * When weak promotion is enabled (using NEP 50) we also use more
         * strict parsing of integers:  All out-of-bound Python integer
         * parsing fails.
         */
        if (DOUBLE_safe_pyint_setitem(op, &temp) < 0) {
            return -1;
        }
    }
    else  /* continue with if below */
#endif

    if (PyArray_IsScalar(op, Double)) {
        temp = PyArrayScalar_VAL(op, Double);
    }
    else {
        temp = (npy_double)MyPyFloat_AsDouble(op);
    }
    if (PyErr_Occurred()) {
        PyObject *type, *value, *traceback;
        PyErr_Fetch(&type, &value, &traceback);
        if (PySequence_NoString_Check(op)) {
            PyErr_SetString(PyExc_ValueError,
                    "setting an array element with a sequence.");
            npy_PyErr_ChainExceptionsCause(type, value, traceback);
        }
        else {
            PyErr_Restore(type, value, traceback);
        }
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        assert(npy_is_aligned(ov, NPY_ALIGNOF(npy_double)));
        *((npy_double *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }
    return 0;
}




#line 413
static PyObject *
CFLOAT_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_float t1, t2;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        return PyComplex_FromDoubles((double)((npy_float *)ip)[0],
                (double)((npy_float *)ip)[1]);
    }
    else {
        int size = sizeof(npy_float);

        npy_bool swap = PyArray_ISBYTESWAPPED(ap);
        copy_and_swap(&t1, ip, size, 1, 0, swap);
        copy_and_swap(&t2, ip + size, size, 1, 0, swap);
        return PyComplex_FromDoubles((double)t1, (double)t2);
    }
}


#line 413
static PyObject *
CDOUBLE_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    npy_double t1, t2;

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        return PyComplex_FromDoubles((double)((npy_double *)ip)[0],
                (double)((npy_double *)ip)[1]);
    }
    else {
        int size = sizeof(npy_double);

        npy_bool swap = PyArray_ISBYTESWAPPED(ap);
        copy_and_swap(&t1, ip, size, 1, 0, swap);
        copy_and_swap(&t2, ip + size, size, 1, 0, swap);
        return PyComplex_FromDoubles((double)t1, (double)t2);
    }
}





#line 445
NPY_NO_EXPORT int
CFLOAT_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    Py_complex oop;
    npy_cfloat temp;

    if (PyArray_IsZeroDim(op)) {
        return convert_to_scalar_and_retry(op, ov, vap, CFLOAT_setitem);
    }

    if (PyArray_IsScalar(op, CFloat)){
        temp = PyArrayScalar_VAL(op, CFloat);
    }
    else {
        if (op == Py_None) {
            oop.real = NPY_NAN;
            oop.imag = NPY_NAN;
        }
        else if (PyBytes_Check(op) || PyUnicode_Check(op)) {
            /*
             * Unlike most numeric conversion functions PyComplex_AsCComplex
             * does not handle strings, so we have to use its constructor.
             */
            PyObject *pycomplex, *args;
            if (PyBytes_Check(op)) {
                /* The complex constructor expects unicode */
                PyObject *unicode;
                unicode = PyUnicode_FromEncodedObject(op, NULL, NULL);
                if (unicode == NULL) {
                    return -1;
                }
                args = PyTuple_Pack(1, unicode);
                Py_DECREF(unicode);
            }
            else {
                args = PyTuple_Pack(1, op);
            }
            if (args == NULL) {
                return -1;
            }
            pycomplex = PyComplex_Type.tp_new(&PyComplex_Type, args, NULL);
            Py_DECREF(args);
            if (pycomplex == NULL) {
                return -1;
            }
            oop = PyComplex_AsCComplex(pycomplex);
            Py_DECREF(pycomplex);
            if (error_converting(oop.real)) {
                return -1;
            }
        }
        else {
            oop = PyComplex_AsCComplex(op);
            if (error_converting(oop.real)) {
                return -1;
            }
        }
        temp.real = (npy_float) oop.real;
        temp.imag = (npy_float) oop.imag;

#if NPY_SIZEOF_CFLOAT < NPY_SIZEOF_CDOUBLE  /* really just float... */
        /* Overflow could have occurred converting double to float */
        if (NPY_UNLIKELY((npy_isinf(temp.real) && !npy_isinf(oop.real)) ||
                         (npy_isinf(temp.imag) && !npy_isinf(oop.imag)))) {
            if (PyUFunc_GiveFloatingpointErrors("cast", NPY_FPE_OVERFLOW) < 0) {
                return -1;
            }
        }
#endif
    }

    memcpy(ov, &temp, NPY_SIZEOF_CFLOAT);
    if (ap != NULL && PyArray_ISBYTESWAPPED(ap)) {
        byte_swap_vector(ov, 2, sizeof(npy_float));
    }
    return 0;
}


#line 445
NPY_NO_EXPORT int
CDOUBLE_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    Py_complex oop;
    npy_cdouble temp;

    if (PyArray_IsZeroDim(op)) {
        return convert_to_scalar_and_retry(op, ov, vap, CDOUBLE_setitem);
    }

    if (PyArray_IsScalar(op, CDouble)){
        temp = PyArrayScalar_VAL(op, CDouble);
    }
    else {
        if (op == Py_None) {
            oop.real = NPY_NAN;
            oop.imag = NPY_NAN;
        }
        else if (PyBytes_Check(op) || PyUnicode_Check(op)) {
            /*
             * Unlike most numeric conversion functions PyComplex_AsCComplex
             * does not handle strings, so we have to use its constructor.
             */
            PyObject *pycomplex, *args;
            if (PyBytes_Check(op)) {
                /* The complex constructor expects unicode */
                PyObject *unicode;
                unicode = PyUnicode_FromEncodedObject(op, NULL, NULL);
                if (unicode == NULL) {
                    return -1;
                }
                args = PyTuple_Pack(1, unicode);
                Py_DECREF(unicode);
            }
            else {
                args = PyTuple_Pack(1, op);
            }
            if (args == NULL) {
                return -1;
            }
            pycomplex = PyComplex_Type.tp_new(&PyComplex_Type, args, NULL);
            Py_DECREF(args);
            if (pycomplex == NULL) {
                return -1;
            }
            oop = PyComplex_AsCComplex(pycomplex);
            Py_DECREF(pycomplex);
            if (error_converting(oop.real)) {
                return -1;
            }
        }
        else {
            oop = PyComplex_AsCComplex(op);
            if (error_converting(oop.real)) {
                return -1;
            }
        }
        temp.real = (npy_double) oop.real;
        temp.imag = (npy_double) oop.imag;

#if NPY_SIZEOF_CDOUBLE < NPY_SIZEOF_CDOUBLE  /* really just float... */
        /* Overflow could have occurred converting double to float */
        if (NPY_UNLIKELY((npy_isinf(temp.real) && !npy_isinf(oop.real)) ||
                         (npy_isinf(temp.imag) && !npy_isinf(oop.imag)))) {
            if (PyUFunc_GiveFloatingpointErrors("cast", NPY_FPE_OVERFLOW) < 0) {
                return -1;
            }
        }
#endif
    }

    memcpy(ov, &temp, NPY_SIZEOF_CDOUBLE);
    if (ap != NULL && PyArray_ISBYTESWAPPED(ap)) {
        byte_swap_vector(ov, 2, sizeof(npy_double));
    }
    return 0;
}


#line 445
NPY_NO_EXPORT int
CLONGDOUBLE_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    Py_complex oop;
    npy_clongdouble temp;

    if (PyArray_IsZeroDim(op)) {
        return convert_to_scalar_and_retry(op, ov, vap, CLONGDOUBLE_setitem);
    }

    if (PyArray_IsScalar(op, CLongDouble)){
        temp = PyArrayScalar_VAL(op, CLongDouble);
    }
    else {
        if (op == Py_None) {
            oop.real = NPY_NAN;
            oop.imag = NPY_NAN;
        }
        else if (PyBytes_Check(op) || PyUnicode_Check(op)) {
            /*
             * Unlike most numeric conversion functions PyComplex_AsCComplex
             * does not handle strings, so we have to use its constructor.
             */
            PyObject *pycomplex, *args;
            if (PyBytes_Check(op)) {
                /* The complex constructor expects unicode */
                PyObject *unicode;
                unicode = PyUnicode_FromEncodedObject(op, NULL, NULL);
                if (unicode == NULL) {
                    return -1;
                }
                args = PyTuple_Pack(1, unicode);
                Py_DECREF(unicode);
            }
            else {
                args = PyTuple_Pack(1, op);
            }
            if (args == NULL) {
                return -1;
            }
            pycomplex = PyComplex_Type.tp_new(&PyComplex_Type, args, NULL);
            Py_DECREF(args);
            if (pycomplex == NULL) {
                return -1;
            }
            oop = PyComplex_AsCComplex(pycomplex);
            Py_DECREF(pycomplex);
            if (error_converting(oop.real)) {
                return -1;
            }
        }
        else {
            oop = PyComplex_AsCComplex(op);
            if (error_converting(oop.real)) {
                return -1;
            }
        }
        temp.real = (npy_longdouble) oop.real;
        temp.imag = (npy_longdouble) oop.imag;

#if NPY_SIZEOF_CLONGDOUBLE < NPY_SIZEOF_CDOUBLE  /* really just float... */
        /* Overflow could have occurred converting double to float */
        if (NPY_UNLIKELY((npy_isinf(temp.real) && !npy_isinf(oop.real)) ||
                         (npy_isinf(temp.imag) && !npy_isinf(oop.imag)))) {
            if (PyUFunc_GiveFloatingpointErrors("cast", NPY_FPE_OVERFLOW) < 0) {
                return -1;
            }
        }
#endif
    }

    memcpy(ov, &temp, NPY_SIZEOF_CLONGDOUBLE);
    if (ap != NULL && PyArray_ISBYTESWAPPED(ap)) {
        byte_swap_vector(ov, 2, sizeof(npy_longdouble));
    }
    return 0;
}



static inline npy_longdouble
string_to_long_double(PyObject*op)
{
    char *s;
    char *end;
    npy_longdouble temp;
    PyObject* b;

    /* Convert python long objects to a longdouble, without precision or range
     * loss via a double.
     */
    if ((PyLong_Check(op) && !PyBool_Check(op))) {
        return npy_longdouble_from_PyLong(op);
    }

    if (PyUnicode_Check(op)) {
        b = PyUnicode_AsUTF8String(op);
        if (!b) {
            return 0;
        }
    }
    else {
        b = op;
        Py_XINCREF(b);
    }
    s = PyBytes_AsString(b);
    if (s) {
        errno = 0;
        temp = NumPyOS_ascii_strtold(s, &end);
        if (errno == ERANGE) {
           if (PyErr_Warn(PyExc_RuntimeWarning,
                   "overflow encountered in conversion from string") < 0) {
               Py_XDECREF(b);
               return 0;
           }
           /* strtold returns INFINITY of the correct sign. */
        }
        else if (errno) {
            PyErr_Format(PyExc_ValueError,
                         "invalid literal for long double: %s (%s)",
                         s,
                         strerror(errno));
            Py_XDECREF(b);
            return 0;
        }

        /* Extra characters at the end of the string, or nothing parsed */
        if (end == s || *end) {
            PyErr_Format(PyExc_ValueError,
                         "invalid literal for long double: %s",
                         s);
            Py_XDECREF(b);
            return 0;
        }
        Py_XDECREF(b);
    }
    else {
        /* Probably wasn't a string, try converting it via a python double */
        PyErr_Clear();
        Py_XDECREF(b);
        temp = (npy_longdouble) MyPyFloat_AsDouble(op);
    }
    return temp;
}

/*
 * These return array scalars which are different than other date-types.
 */

static PyObject *
LONGDOUBLE_getitem(void *ip, void *ap)
{
    return PyArray_Scalar(ip, PyArray_DESCR((PyArrayObject *)ap), NULL);
}

NPY_NO_EXPORT int
LONGDOUBLE_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    /* ensure alignment */
    npy_longdouble temp;

    if (PyArray_IsZeroDim(op)) {
        return convert_to_scalar_and_retry(op, ov, vap, LONGDOUBLE_setitem);
    }

    if (PyArray_IsScalar(op, LongDouble)) {
        temp = PyArrayScalar_VAL(op, LongDouble);
    }
    else {
        /* In case something funny happened in PyArray_IsScalar */
        if (PyErr_Occurred()) {
            return -1;
        }
        temp = string_to_long_double(op);
    }
    if (PyErr_Occurred()) {
        return -1;
    }
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        *((npy_longdouble *)ov) = temp;
    }
    else {
        copy_and_swap(ov, &temp, PyArray_DESCR(ap)->elsize, 1, 0,
                      PyArray_ISBYTESWAPPED(ap));
    }
    return 0;
}

static PyObject *
CLONGDOUBLE_getitem(void *ip, void *ap)
{
    return PyArray_Scalar(ip, PyArray_DESCR((PyArrayObject *)ap), NULL);
}

/* UNICODE */
static PyObject *
UNICODE_getitem(void *ip, void *vap)
{
    PyArrayObject *ap = vap;
    Py_ssize_t size = PyArray_ITEMSIZE(ap);
    int swap = PyArray_ISBYTESWAPPED(ap);
    int align = !PyArray_ISALIGNED(ap);

    return (PyObject *)PyUnicode_FromUCS4(ip, size, swap, align);
}

static int
UNICODE_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;

    if (PyArray_IsZeroDim(op)) {
        return convert_to_scalar_and_retry(op, ov, vap, UNICODE_setitem);
    }

    if (PySequence_NoString_Check(op)) {
        PyErr_SetString(PyExc_ValueError,
                "setting an array element with a sequence");
        return -1;
    }

    PyObject *temp;
    if (PyBytes_Check(op)) {
        /* Try to decode from ASCII */
        temp = PyUnicode_FromEncodedObject(op, "ASCII", "strict");
        if (temp == NULL) {
            return -1;
        }
    }
    else if ((temp=PyObject_Str(op)) == NULL) {
        return -1;
    }

    /* truncate if needed */
    Py_ssize_t max_len = PyArray_DESCR(ap)->elsize >> 2;
    Py_ssize_t actual_len = PyUnicode_GetLength(temp);
    if (actual_len < 0) {
        Py_DECREF(temp);
        return -1;
    }
    if (actual_len > max_len) {
        Py_SETREF(temp, PyUnicode_Substring(temp, 0, max_len));
        if (temp == NULL) {
            return -1;
        }
        actual_len = max_len;
    }

    Py_ssize_t num_bytes = actual_len * 4;

    char *buffer;
    if (!PyArray_ISALIGNED(ap)) {
        buffer = PyArray_malloc(num_bytes);
        if (buffer == NULL) {
            Py_DECREF(temp);
            PyErr_NoMemory();
            return -1;
        }
    }
    else {
        buffer = ov;
    }
    if (PyUnicode_AsUCS4(temp, (Py_UCS4 *)buffer, actual_len, 0) == NULL) {
        PyArray_free(buffer);
        Py_DECREF(temp);
        return -1;
    }

    if (!PyArray_ISALIGNED(ap)) {
        memcpy(ov, buffer, num_bytes);
        PyArray_free(buffer);
    }

    /* Fill in the rest of the space with 0 */
    if (PyArray_DESCR(ap)->elsize > num_bytes) {
        memset((char*)ov + num_bytes, 0, (PyArray_DESCR(ap)->elsize - num_bytes));
    }
    if (PyArray_ISBYTESWAPPED(ap)) {
        byte_swap_vector(ov, actual_len, 4);
    }
    Py_DECREF(temp);
    return 0;
}

/* STRING
 *
 * can handle both NULL-terminated and not NULL-terminated cases
 * will truncate all ending NULLs in returned string.
 */
static PyObject *
STRING_getitem(void *ip, void *vap)
{
    PyArrayObject *ap = vap;
    /* Will eliminate NULLs at the end */
    char *ptr;
    int size = PyArray_DESCR(ap)->elsize;

    ptr = (char *)ip + size - 1;
    while (size > 0 && *ptr-- == '\0') {
        size--;
    }
    return PyBytes_FromStringAndSize(ip,size);
}

static int
STRING_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    char *ptr;
    Py_ssize_t len;
    PyObject *temp = NULL;

    if (PyArray_IsZeroDim(op)) {
        return convert_to_scalar_and_retry(op, ov, vap, STRING_setitem);
    }

    if (PySequence_NoString_Check(op)) {
        PyErr_SetString(PyExc_ValueError,
                "setting an array element with a sequence");
        return -1;
    }
    if (PyUnicode_Check(op)) {
        /* Assume ASCII codec -- function similarly as Python 2 */
        temp = PyUnicode_AsASCIIString(op);
        if (temp == NULL) {
            return -1;
        }
    }
    else if (PyBytes_Check(op) || PyMemoryView_Check(op)) {
        temp = PyObject_Bytes(op);
        if (temp == NULL) {
            return -1;
        }
    }
    else {
        /* Emulate similar casting behavior as on Python 2 */
        PyObject *str;
        str = PyObject_Str(op);
        if (str == NULL) {
            return -1;
        }
        temp = PyUnicode_AsASCIIString(str);
        Py_DECREF(str);
        if (temp == NULL) {
            return -1;
        }
    }
    if (PyBytes_AsStringAndSize(temp, &ptr, &len) < 0) {
        Py_DECREF(temp);
        return -1;
    }
    memcpy(ov, ptr, PyArray_MIN(PyArray_DESCR(ap)->elsize,len));
    /*
     * If string length is smaller than room in array
     * Then fill the rest of the element size with NULL
     */
    if (PyArray_DESCR(ap)->elsize > len) {
        memset((char *)ov + len, 0, (PyArray_DESCR(ap)->elsize - len));
    }
    Py_DECREF(temp);
    return 0;
}

/* OBJECT */

#define NPY__ALIGNED(obj, sz) ((((size_t) obj) % (sz))==0)

static PyObject *
OBJECT_getitem(void *ip, void *NPY_UNUSED(ap))
{
    PyObject *obj;
    memcpy(&obj, ip, sizeof(obj));
    if (obj == NULL) {
        /* We support NULL, but still try to guarantee this never happens! */
        Py_RETURN_NONE;
    }
    else {
        Py_INCREF(obj);
        return obj;
    }
}


static int
OBJECT_setitem(PyObject *op, void *ov, void *NPY_UNUSED(ap))
{
    PyObject *obj;

    memcpy(&obj, ov, sizeof(obj));

    Py_INCREF(op);
    /* A newly created array/buffer may only be NULLed, so XDECREF */
    Py_XDECREF(obj);

    memcpy(ov, &op, sizeof(op));

    return PyErr_Occurred() ? -1 : 0;
}


/* VOID */

static PyObject *
VOID_getitem(void *input, void *vap)
{
    PyArrayObject *ap = vap;
    char *ip = input;
    PyArray_Descr* descr = PyArray_DESCR(vap);

    if (PyDataType_HASFIELDS(descr)) {
        PyObject *key;
        PyObject *names;
        int i, n;
        PyObject *ret;
        PyObject *tup;
        PyArrayObject_fields dummy_fields = get_dummy_stack_array(ap);
        PyArrayObject *dummy_arr = (PyArrayObject *)&dummy_fields;

        /* get the names from the fields dictionary*/
        names = descr->names;
        n = PyTuple_GET_SIZE(names);
        ret = PyTuple_New(n);
        for (i = 0; i < n; i++) {
            npy_intp offset;
            PyArray_Descr *new;
            key = PyTuple_GET_ITEM(names, i);
            tup = PyDict_GetItem(descr->fields, key);
            if (_unpack_field(tup, &new, &offset) < 0) {
                Py_DECREF(ret);
                return NULL;
            }
            dummy_fields.descr = new;
            /* update alignment based on offset */
            if ((new->alignment > 1)
                    && ((((npy_intp)(ip+offset)) % new->alignment) != 0)) {
                PyArray_CLEARFLAGS(dummy_arr, NPY_ARRAY_ALIGNED);
            }
            else {
                PyArray_ENABLEFLAGS(dummy_arr, NPY_ARRAY_ALIGNED);
            }
            PyTuple_SET_ITEM(ret, i, PyArray_GETITEM(dummy_arr, ip+offset));
        }
        return ret;
    }

    if (descr->subarray) {
        /* return an array of the basic type */
        PyArray_Dims shape = {NULL, -1};
        PyArrayObject *ret;

        if (!(PyArray_IntpConverter(descr->subarray->shape, &shape))) {
            npy_free_cache_dim_obj(shape);
            PyErr_SetString(PyExc_ValueError,
                    "invalid shape in fixed-type tuple.");
            return NULL;
        }
        Py_INCREF(descr->subarray->base);

        /*
         * NOTE: There is the possibility of recursive calls from the above
         *       field branch. These calls use a dummy arr for thread
         *       (and general) safety. However, we must set the base array,
         *       so if such a dummy array was passed (its type is NULL),
         *       we have walk its base until the initial array is found.
         *
         * TODO: This should be fixed, the next "generation" of GETITEM will
         *       probably need to pass in the original array (in addition
         *       to the dtype as a method). Alternatively, VOID dtypes
         *       could have special handling.
         */
        PyObject *base = (PyObject *)ap;
        while (base != NULL && Py_TYPE(base) == NULL) {
            base = PyArray_BASE((PyArrayObject *)base);
        }
        ret = (PyArrayObject *)PyArray_NewFromDescrAndBase(
                &PyArray_Type, descr->subarray->base,
                shape.len, shape.ptr, NULL, ip,
                PyArray_FLAGS(ap) & ~NPY_ARRAY_F_CONTIGUOUS,
                NULL, base);
        if (base == NULL) {
            /*
             * Need to create a copy, or we may point to wrong data.  This path
             * is taken when no "valid" array is passed.  This happens for
             * casts.
             */
            PyObject *copy = PyArray_FromArray(ret, NULL, NPY_ARRAY_ENSURECOPY);
            Py_SETREF(ret, (PyArrayObject *)copy);
        }
        npy_free_cache_dim_obj(shape);
        return (PyObject *)ret;
    }

    return PyBytes_FromStringAndSize(ip, descr->elsize);
}


NPY_NO_EXPORT int PyArray_CopyObject(PyArrayObject *, PyObject *);

/* Given a structured PyArrayObject arr, index i and structured datatype descr,
 * modify the dtype of arr to contain a single field corresponding to the ith
 * field of descr, recompute the alignment flag, and return the offset of the
 * field (in offset_p). This is useful in preparation for calling copyswap on
 * individual fields of a numpy structure, in VOID_setitem.  Compare to inner
 * loops in VOID_getitem and VOID_nonzero.
 *
 * WARNING: Clobbers arr's dtype and alignment flag, should not be used
 *          on the original array!
 */
NPY_NO_EXPORT int
_setup_field(int i, PyArray_Descr *descr, PyArrayObject *arr,
            npy_intp *offset_p, char *dstdata)
{
    PyObject *key;
    PyObject *tup;
    PyArray_Descr *new;
    npy_intp offset;

    key = PyTuple_GET_ITEM(descr->names, i);
    tup = PyDict_GetItem(descr->fields, key);
    if (_unpack_field(tup, &new, &offset) < 0) {
        return -1;
    }

    ((PyArrayObject_fields *)(arr))->descr = new;
    if ((new->alignment > 1) &&
                ((((uintptr_t)dstdata + offset) % new->alignment) != 0)) {
        PyArray_CLEARFLAGS(arr, NPY_ARRAY_ALIGNED);
    }
    else {
        PyArray_ENABLEFLAGS(arr, NPY_ARRAY_ALIGNED);
    }

    *offset_p = offset;
    return 0;
}

/* Helper function for VOID_setitem, which uses the copyswap or casting code to
 * copy structured datatypes between numpy arrays or scalars.
 */
static int
_copy_and_return_void_setitem(PyArray_Descr *dstdescr, char *dstdata,
                              PyArray_Descr *srcdescr, char *srcdata){
    PyArrayObject_fields dummy_struct;
    PyArrayObject *dummy_arr = (PyArrayObject *)&dummy_struct;
    npy_int names_size = PyTuple_GET_SIZE(dstdescr->names);
    npy_intp offset;
    npy_int i;
    int ret;

    /* Fast path if dtypes are equal */
    if (PyArray_EquivTypes(srcdescr, dstdescr)) {
        for (i = 0; i < names_size; i++) {
            /* neither line can ever fail, in principle */
            if (_setup_field(i, dstdescr, dummy_arr, &offset, dstdata)) {
                return -1;
            }
            PyArray_DESCR(dummy_arr)->f->copyswap(dstdata + offset,
                    srcdata + offset, 0, dummy_arr);
        }
        return 0;
    }

    /* Slow path */
    ret = PyArray_CastRawArrays(1, srcdata, dstdata, 0, 0,
                                srcdescr, dstdescr, 0);
    if (ret != NPY_SUCCEED) {
        return -1;
    }
    return 0;
}

static int
VOID_setitem(PyObject *op, void *input, void *vap)
{
    char *ip = input;
    PyArrayObject *ap = vap;
    int itemsize = PyArray_DESCR(ap)->elsize;
    int res;
    PyArray_Descr *descr = PyArray_DESCR(ap);

    if (PyDataType_HASFIELDS(descr)) {
        PyObject *errmsg;
        npy_int i;
        npy_intp offset;
        int failed = 0;

        /* If op is 0d-ndarray or numpy scalar, directly get dtype & data ptr */
        if (PyArray_Check(op)) {
            PyArrayObject *oparr = (PyArrayObject *)op;
            if (PyArray_SIZE(oparr) != 1) {
                PyErr_SetString(PyExc_ValueError,
                        "setting an array element with a sequence.");
                return -1;
            }
            return _copy_and_return_void_setitem(descr, ip,
                                    PyArray_DESCR(oparr), PyArray_DATA(oparr));
        }
        else if (PyArray_IsScalar(op, Void)) {
            PyArray_Descr *srcdescr = ((PyVoidScalarObject *)op)->descr;
            char *srcdata = ((PyVoidScalarObject *)op)->obval;
            return _copy_and_return_void_setitem(descr, ip, srcdescr, srcdata);
        }
        else if (PyTuple_Check(op)) {
            /* if it's a tuple, copy field-by-field to ap, */
            npy_intp names_size = PyTuple_GET_SIZE(descr->names);

            if (names_size != PyTuple_Size(op)) {
                errmsg = PyUnicode_FromFormat(
                        "could not assign tuple of length %zd to structure "
                        "with %" NPY_INTP_FMT " fields.",
                        PyTuple_Size(op), names_size);
                PyErr_SetObject(PyExc_ValueError, errmsg);
                Py_DECREF(errmsg);
                return -1;
            }

            PyArrayObject_fields dummy_fields = get_dummy_stack_array(ap);
            PyArrayObject *dummy_arr = (PyArrayObject *)&dummy_fields;

            for (i = 0; i < names_size; i++) {
                PyObject *item;

                if (_setup_field(i, descr, dummy_arr, &offset, ip) == -1) {
                    failed = 1;
                    break;
                }
                item = PyTuple_GetItem(op, i);
                if (item == NULL) {
                    failed = 1;
                    break;
                }
                /* use setitem to set this field */
                if (PyArray_SETITEM(dummy_arr, ip + offset, item) < 0) {
                    failed = 1;
                    break;
                }
            }
        }
        else {
            /* Otherwise must be non-void scalar. Try to assign to each field */
            npy_intp names_size = PyTuple_GET_SIZE(descr->names);

            PyArrayObject_fields dummy_fields = get_dummy_stack_array(ap);
            PyArrayObject *dummy_arr = (PyArrayObject *)&dummy_fields;

            for (i = 0; i < names_size; i++) {
                /* temporarily make ap have only this field */
                if (_setup_field(i, descr, dummy_arr, &offset, ip) == -1) {
                    failed = 1;
                    break;
                }
                /* use setitem to set this field */
                if (PyArray_SETITEM(dummy_arr, ip + offset, op) < 0) {
                    failed = 1;
                    break;
                }
            }
        }

        if (failed) {
            return -1;
        }
        return 0;
    }
    else if (PyDataType_HASSUBARRAY(descr)) {
        /* copy into an array of the same basic type */
        PyArray_Dims shape = {NULL, -1};
        if (!(PyArray_IntpConverter(descr->subarray->shape, &shape))) {
            npy_free_cache_dim_obj(shape);
            PyErr_SetString(PyExc_ValueError,
                    "invalid shape in fixed-type tuple.");
            return -1;
        }
        Py_INCREF(descr->subarray->base);
        /*
         * Note we set no base object here, as to not rely on the input
         * being a valid object for base setting. `ret` nevertheless does
         * does not own its data, this is generally not good, but localized.
         */
        PyArrayObject *ret = (PyArrayObject *)PyArray_NewFromDescrAndBase(
                &PyArray_Type, descr->subarray->base,
                shape.len, shape.ptr, NULL, ip,
                PyArray_FLAGS(ap), NULL, NULL);
        npy_free_cache_dim_obj(shape);
        if (!ret) {
            return -1;
        }
        res = PyArray_CopyObject(ret, op);
        Py_DECREF(ret);
        return res;
    }

    /*
     * Fall through case - non-structured void datatype. This is a very
     * undiscerning case: It interprets any object as a buffer
     * and reads as many bytes as possible, padding with 0.
     */
    {
        Py_buffer view;

        if (PyObject_GetBuffer(op, &view, PyBUF_SIMPLE) < 0) {
            return -1;
        }
        memcpy(ip, view.buf, PyArray_MIN(view.len, itemsize));
        if (itemsize > view.len) {
            memset(ip + view.len, 0, itemsize - view.len);
        }
        PyBuffer_Release(&view);
    }
    return 0;
}

static PyObject *
DATETIME_getitem(void *ip, void *vap)
{
    PyArrayObject *ap = vap;
    npy_datetime dt;
    PyArray_DatetimeMetaData *meta = NULL;

    /* Get the datetime units metadata */
    meta = get_datetime_metadata_from_dtype(PyArray_DESCR(ap));
    if (meta == NULL) {
        return NULL;
    }

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        dt = *((npy_datetime *)ip);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&dt, ip, PyArray_ISBYTESWAPPED(ap), ap);
    }

    return convert_datetime_to_pyobject(dt, meta);
}


static PyObject *
TIMEDELTA_getitem(void *ip, void *vap)
{
    PyArrayObject *ap = vap;
    npy_timedelta td;
    PyArray_DatetimeMetaData *meta = NULL;

    /* Get the datetime units metadata */
    meta = get_datetime_metadata_from_dtype(PyArray_DESCR(ap));
    if (meta == NULL) {
        return NULL;
    }

    if ((ap == NULL) || PyArray_ISBEHAVED_RO(ap)) {
        td = *((npy_timedelta *)ip);
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(&td, ip, PyArray_ISBYTESWAPPED(ap), ap);
    }

    return convert_timedelta_to_pyobject(td, meta);
}

static int
DATETIME_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    /* ensure alignment */
    npy_datetime temp = 0;
    PyArray_DatetimeMetaData *meta = NULL;

    /* Get the datetime units metadata */
    meta = get_datetime_metadata_from_dtype(PyArray_DESCR(ap));
    if (meta == NULL) {
        return -1;
    }

    /* Convert the object into a NumPy datetime */
    if (convert_pyobject_to_datetime(meta, op,
                            NPY_SAME_KIND_CASTING, &temp) < 0) {
        return -1;
    }

    /* Copy the value into the output */
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        *((npy_datetime *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }

    return 0;
}

static int
TIMEDELTA_setitem(PyObject *op, void *ov, void *vap)
{
    PyArrayObject *ap = vap;
    /* ensure alignment */
    npy_timedelta temp = 0;
    PyArray_DatetimeMetaData *meta = NULL;

    /* Get the datetime units metadata */
    meta = get_datetime_metadata_from_dtype(PyArray_DESCR(ap));
    if (meta == NULL) {
        return -1;
    }

    /* Convert the object into a NumPy datetime */
    if (convert_pyobject_to_timedelta(meta, op,
                            NPY_SAME_KIND_CASTING, &temp) < 0) {
        return -1;
    }

    /* Copy the value into the output */
    if (ap == NULL || PyArray_ISBEHAVED(ap)) {
        *((npy_timedelta *)ov)=temp;
    }
    else {
        PyArray_DESCR(ap)->f->copyswap(ov, &temp, PyArray_ISBYTESWAPPED(ap),
                                       ap);
    }

    return 0;
}


/*
 *****************************************************************************
 **                       TYPE TO TYPE CONVERSIONS                          **
 *****************************************************************************
 */


/* Assumes contiguous, and aligned, from and to */


#line 1292

#line 1304
static void
BYTE_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_byte *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_byte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_byte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_byte)f;
        }
#else
        npy_byte t = (npy_byte)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_ubyte *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_ubyte t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ubyte)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ubyte)f;
        }
#else
        npy_ubyte t = (npy_ubyte)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_short *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_short t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_short)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_short)f;
        }
#else
        npy_short t = (npy_short)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_ushort *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_ushort t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ushort)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ushort)f;
        }
#else
        npy_ushort t = (npy_ushort)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_int *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_int t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_int)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_int)f;
        }
#else
        npy_int t = (npy_int)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_uint *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_uint t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_uint)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_uint)f;
        }
#else
        npy_uint t = (npy_uint)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_long *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_long t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_long)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_long)f;
        }
#else
        npy_long t = (npy_long)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_ulong *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_ulong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulong)f;
        }
#else
        npy_ulong t = (npy_ulong)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_longlong *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_longlong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longlong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longlong)f;
        }
#else
        npy_longlong t = (npy_longlong)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_ulonglong t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_ulonglong)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_ulonglong)f;
        }
#else
        npy_ulonglong t = (npy_ulonglong)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_float *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_float t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_float)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_float)f;
        }
#else
        npy_float t = (npy_float)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_double *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_double t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_double)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_double)f;
        }
#else
        npy_double t = (npy_double)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_longdouble *op = output;

    while (n--) {
#if 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_longdouble t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_longdouble)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_longdouble)f;
        }
#else
        npy_longdouble t = (npy_longdouble)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_datetime *op = output;

    while (n--) {
#if 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_datetime t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_datetime)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_datetime)f;
        }
#else
        npy_datetime t = (npy_datetime)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}



#line 1292

#line 1304
static void
BYTE_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_byte f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UBYTE_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ubyte f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
SHORT_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_short f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
USHORT_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ushort f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
INT_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_int f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
UINT_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_uint f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONG_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_long f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONG_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulong f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGLONG_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longlong f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
ULONGLONG_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_ulonglong f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
FLOAT_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DOUBLE_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
LONGDOUBLE_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
DATETIME_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_datetime f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}

#line 1304
static void
TIMEDELTA_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1 && 0
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_timedelta f = *ip++;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip++;
#endif
        *op++ = t;
    }
}


#line 1339
static void
CFLOAT_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_float f = *ip;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CDOUBLE_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_double f = *ip;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}

#line 1339
static void
CLONGDOUBLE_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_timedelta *op = output;

    while (n--) {
#if 1
        /*
         * volatile works around clang (and gcc sometimes) not branching
         * correctly, leading to floating point errors in the test suite.
         */
        volatile npy_longdouble f = *ip;
        npy_timedelta t;
        /* Avoid undefined behaviour and warning for NaN -> NaT */
        if (npy_isnan(f)) {
            t = (npy_timedelta)NPY_DATETIME_NAT;
        }
        else {
            t = (npy_timedelta)f;
        }
#else
        npy_timedelta t = (npy_timedelta)*ip;
#endif
        *op++ = t;
        ip += 2;
    }
}





#line 1383

static void
BYTE_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_byte *op = output;

    while (n--) {
        *op++ = (npy_byte)npy_half_to_float(*ip++);
    }
}


#line 1383

static void
UBYTE_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_ubyte *op = output;

    while (n--) {
        *op++ = (npy_ubyte)npy_half_to_float(*ip++);
    }
}


#line 1383

static void
SHORT_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_short *op = output;

    while (n--) {
        *op++ = (npy_short)npy_half_to_float(*ip++);
    }
}


#line 1383

static void
USHORT_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_ushort *op = output;

    while (n--) {
        *op++ = (npy_ushort)npy_half_to_float(*ip++);
    }
}


#line 1383

static void
INT_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_int *op = output;

    while (n--) {
        *op++ = (npy_int)npy_half_to_float(*ip++);
    }
}


#line 1383

static void
UINT_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_uint *op = output;

    while (n--) {
        *op++ = (npy_uint)npy_half_to_float(*ip++);
    }
}


#line 1383

static void
LONG_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_long *op = output;

    while (n--) {
        *op++ = (npy_long)npy_half_to_float(*ip++);
    }
}


#line 1383

static void
ULONG_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_ulong *op = output;

    while (n--) {
        *op++ = (npy_ulong)npy_half_to_float(*ip++);
    }
}


#line 1383

static void
LONGLONG_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_longlong *op = output;

    while (n--) {
        *op++ = (npy_longlong)npy_half_to_float(*ip++);
    }
}


#line 1383

static void
ULONGLONG_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
        *op++ = (npy_ulonglong)npy_half_to_float(*ip++);
    }
}


#line 1383

static void
LONGDOUBLE_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)npy_half_to_float(*ip++);
    }
}


#line 1383

static void
DATETIME_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_datetime *op = output;

    while (n--) {
        *op++ = (npy_datetime)npy_half_to_float(*ip++);
    }
}


#line 1383

static void
TIMEDELTA_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_float_to_half((float)(*ip++));
    }
}

static void
HALF_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_timedelta *op = output;

    while (n--) {
        *op++ = (npy_timedelta)npy_half_to_float(*ip++);
    }
}


#if NPY_SIZEOF_SHORT == 2
#define HALF_to_HALF SHORT_to_SHORT
#elif NPY_SIZEOF_INT == 2
#define HALF_to_HALF INT_to_INT
#endif

#line 1422

static void
FLOAT_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint32 *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_floatbits_to_halfbits(*ip);
#if 0
        ip += 2;
#else
        ip++;
#endif
    }
}

static void
HALF_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_uint32 *op = output;

    while (n--) {
        *op++ = npy_halfbits_to_floatbits(*ip++);
#if 0
        *op++ = 0;
#endif
    }
}


#line 1422

static void
DOUBLE_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint64 *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_doublebits_to_halfbits(*ip);
#if 0
        ip += 2;
#else
        ip++;
#endif
    }
}

static void
HALF_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_uint64 *op = output;

    while (n--) {
        *op++ = npy_halfbits_to_doublebits(*ip++);
#if 0
        *op++ = 0;
#endif
    }
}


#line 1422

static void
CFLOAT_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint32 *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_floatbits_to_halfbits(*ip);
#if 1
        ip += 2;
#else
        ip++;
#endif
    }
}

static void
HALF_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_uint32 *op = output;

    while (n--) {
        *op++ = npy_halfbits_to_floatbits(*ip++);
#if 1
        *op++ = 0;
#endif
    }
}


#line 1422

static void
CDOUBLE_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint64 *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_doublebits_to_halfbits(*ip);
#if 1
        ip += 2;
#else
        ip++;
#endif
    }
}

static void
HALF_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_uint64 *op = output;

    while (n--) {
        *op++ = npy_halfbits_to_doublebits(*ip++);
#if 1
        *op++ = 0;
#endif
    }
}



static void
CLONGDOUBLE_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = npy_double_to_half((double) (*ip++));
        ip += 2;
    }
}

static void
HALF_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = npy_half_to_double(*ip++);
        *op++ = 0;
    }
}

#line 1496
static void
BOOL_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
BYTE_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
UBYTE_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
SHORT_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
USHORT_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
INT_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
UINT_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
LONG_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
ULONG_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
LONGLONG_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
ULONGLONG_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
FLOAT_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
DOUBLE_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
LONGDOUBLE_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
DATETIME_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}

#line 1496
static void
TIMEDELTA_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(*ip++ != NPY_FALSE);
    }
}


static void
HALF_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_half *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op++ = (npy_bool)(!npy_half_iszero(*ip++));
    }
}

#line 1526
static void
CFLOAT_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_cfloat *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op = (npy_bool)((ip->real != NPY_FALSE) ||
                (ip->imag != NPY_FALSE));
        op++;
        ip++;
    }
}

#line 1526
static void
CDOUBLE_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_cdouble *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op = (npy_bool)((ip->real != NPY_FALSE) ||
                (ip->imag != NPY_FALSE));
        op++;
        ip++;
    }
}

#line 1526
static void
CLONGDOUBLE_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_clongdouble *ip = input;
    npy_bool *op = output;

    while (n--) {
        *op = (npy_bool)((ip->real != NPY_FALSE) ||
                (ip->imag != NPY_FALSE));
        op++;
        ip++;
    }
}


#line 1554
static void
BOOL_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_byte *op = output;

    while (n--) {
        *op++ = (npy_byte)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_ubyte *op = output;

    while (n--) {
        *op++ = (npy_ubyte)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_short *op = output;

    while (n--) {
        *op++ = (npy_short)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_ushort *op = output;

    while (n--) {
        *op++ = (npy_ushort)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_int *op = output;

    while (n--) {
        *op++ = (npy_int)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_uint *op = output;

    while (n--) {
        *op++ = (npy_uint)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_long *op = output;

    while (n--) {
        *op++ = (npy_long)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_ulong *op = output;

    while (n--) {
        *op++ = (npy_ulong)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_longlong *op = output;

    while (n--) {
        *op++ = (npy_longlong)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_ulonglong *op = output;

    while (n--) {
        *op++ = (npy_ulonglong)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_half *op = output;

    while (n--) {
        *op++ = (npy_half)((*ip++ != NPY_FALSE) ? NPY_HALF_ONE : NPY_HALF_ZERO);
    }
}

#line 1554
static void
BOOL_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_datetime *op = output;

    while (n--) {
        *op++ = (npy_datetime)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}

#line 1554
static void
BOOL_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_timedelta *op = output;

    while (n--) {
        *op++ = (npy_timedelta)((*ip++ != NPY_FALSE) ? 1 : 0);
    }
}


#line 1572

#line 1585
static void
BOOL_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
BYTE_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
UBYTE_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
SHORT_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
USHORT_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
INT_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
UINT_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
LONG_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
ULONG_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
LONGLONG_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
ULONGLONG_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
FLOAT_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
DOUBLE_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
LONGDOUBLE_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
DATETIME_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
TIMEDELTA_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_float *op = output;

    while (n--) {
        *op++ = (npy_float)*ip++;
        *op++ = 0.0;
    }

}


#line 1572

#line 1585
static void
BOOL_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
BYTE_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
UBYTE_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
SHORT_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
USHORT_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
INT_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
UINT_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
LONG_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
ULONG_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
LONGLONG_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
ULONGLONG_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
FLOAT_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
DOUBLE_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
LONGDOUBLE_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
DATETIME_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
TIMEDELTA_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_double *op = output;

    while (n--) {
        *op++ = (npy_double)*ip++;
        *op++ = 0.0;
    }

}


#line 1572

#line 1585
static void
BOOL_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_bool *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
BYTE_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_byte *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
UBYTE_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ubyte *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
SHORT_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_short *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
USHORT_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ushort *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
INT_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_int *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
UINT_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_uint *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
LONG_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_long *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
ULONG_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulong *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
LONGLONG_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longlong *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
ULONGLONG_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_ulonglong *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
FLOAT_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
DOUBLE_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
LONGDOUBLE_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
DATETIME_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_datetime *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}

#line 1585
static void
TIMEDELTA_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_timedelta *ip = input;
    npy_longdouble *op = output;

    while (n--) {
        *op++ = (npy_longdouble)*ip++;
        *op++ = 0.0;
    }

}



#line 1606

#line 1611
static void
CFLOAT_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_float *op = output;

    n <<= 1;
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}


#line 1611
static void
CDOUBLE_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_float *op = output;

    n <<= 1;
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}


#line 1611
static void
CLONGDOUBLE_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_float *op = output;

    n <<= 1;
    while (n--) {
        *op++ = (npy_float)*ip++;
    }
}



#line 1606

#line 1611
static void
CFLOAT_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_double *op = output;

    n <<= 1;
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}


#line 1611
static void
CDOUBLE_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_double *op = output;

    n <<= 1;
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}


#line 1611
static void
CLONGDOUBLE_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_double *op = output;

    n <<= 1;
    while (n--) {
        *op++ = (npy_double)*ip++;
    }
}



#line 1606

#line 1611
static void
CFLOAT_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_float *ip = input;
    npy_longdouble *op = output;

    n <<= 1;
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}


#line 1611
static void
CDOUBLE_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_double *ip = input;
    npy_longdouble *op = output;

    n <<= 1;
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}


#line 1611
static void
CLONGDOUBLE_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *NPY_UNUSED(aop))
{
    const npy_longdouble *ip = input;
    npy_longdouble *op = output;

    n <<= 1;
    while (n--) {
        *op++ = (npy_longdouble)*ip++;
    }
}




#line 1645
static void
BOOL_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_bool *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = BOOL_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
BYTE_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_byte *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = BYTE_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
UBYTE_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_ubyte *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = UBYTE_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
SHORT_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_short *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = SHORT_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
USHORT_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_ushort *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = USHORT_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
INT_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_int *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = INT_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
UINT_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_uint *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = UINT_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
LONG_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_long *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = LONG_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
ULONG_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_ulong *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = ULONG_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
LONGLONG_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_longlong *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = LONGLONG_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
ULONGLONG_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_ulonglong *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = ULONGLONG_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
HALF_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_half *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = HALF_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
FLOAT_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_float *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = FLOAT_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
DOUBLE_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_double *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = DOUBLE_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
LONGDOUBLE_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_longdouble *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = LONGDOUBLE_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
CFLOAT_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_cfloat *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = CFLOAT_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
CDOUBLE_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_cdouble *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = CDOUBLE_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
CLONGDOUBLE_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_clongdouble *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = CLONGDOUBLE_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
STRING_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_char *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = STRING_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
UNICODE_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_char *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = UNICODE_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
VOID_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_char *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = VOID_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
OBJECT_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    PyObject * *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = OBJECT_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
DATETIME_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_datetime *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = DATETIME_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}

#line 1645
static void
TIMEDELTA_to_OBJECT(void *input, void *output, npy_intp n,
        void *vaip, void *NPY_UNUSED(aop))
{
    npy_timedelta *ip = input;
    PyObject **op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = 1;
    PyObject *tmp;
    for (i = 0; i < n; i++, ip +=skip, op++) {
        tmp = *op;
        *op = TIMEDELTA_getitem(ip, aip);
        Py_XDECREF(tmp);
    }
}


#define _NPY_UNUSEDBOOL  NPY_UNUSED
#define _NPY_UNUSEDBYTE  NPY_UNUSED
#define _NPY_UNUSEDUBYTE  NPY_UNUSED
#define _NPY_UNUSEDSHORT  NPY_UNUSED
#define _NPY_UNUSEDUSHORT  NPY_UNUSED
#define _NPY_UNUSEDINT  NPY_UNUSED
#define _NPY_UNUSEDUINT  NPY_UNUSED
#define _NPY_UNUSEDLONG  NPY_UNUSED
#define _NPY_UNUSEDULONG  NPY_UNUSED
#define _NPY_UNUSEDLONGLONG  NPY_UNUSED
#define _NPY_UNUSEDULONGLONG  NPY_UNUSED
#define _NPY_UNUSEDHALF NPY_UNUSED
#define _NPY_UNUSEDFLOAT  NPY_UNUSED
#define _NPY_UNUSEDDOUBLE  NPY_UNUSED
#define _NPY_UNUSEDLONGDOUBLE  NPY_UNUSED
#define _NPY_UNUSEDCFLOAT  NPY_UNUSED
#define _NPY_UNUSEDCDOUBLE  NPY_UNUSED
#define _NPY_UNUSEDCLONGDOUBLE  NPY_UNUSED
#define _NPY_UNUSEDDATETIME  NPY_UNUSED
#define _NPY_UNUSEDTIMEDELTA  NPY_UNUSED
#define _NPY_UNUSEDHALF NPY_UNUSED
#define _NPY_UNUSEDSTRING
#define _NPY_UNUSEDVOID
#define _NPY_UNUSEDUNICODE

#line 1707
static void
OBJECT_to_BOOL(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_bool *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (BOOL_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (BOOL_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_BYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_byte *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (BYTE_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (BYTE_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_UBYTE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_ubyte *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (UBYTE_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (UBYTE_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_SHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_short *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (SHORT_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (SHORT_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_USHORT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_ushort *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (USHORT_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (USHORT_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_INT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_int *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (INT_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (INT_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_UINT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_uint *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (UINT_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (UINT_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_LONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_long *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (LONG_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (LONG_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_ULONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_ulong *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (ULONG_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (ULONG_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_LONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_longlong *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (LONGLONG_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (LONGLONG_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_ulonglong *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (ULONGLONG_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (ULONGLONG_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_HALF(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_half *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (HALF_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (HALF_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_FLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_float *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (FLOAT_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (FLOAT_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_DOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_double *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (DOUBLE_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (DOUBLE_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_longdouble *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (LONGDOUBLE_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (LONGDOUBLE_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_CFLOAT(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_cfloat *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (CFLOAT_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (CFLOAT_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_cdouble *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (CDOUBLE_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (CDOUBLE_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_clongdouble *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (CLONGDOUBLE_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (CLONGDOUBLE_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_STRING(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_char *op = output;

    npy_intp i;
    int skip = PyArray_DESCR(aop)->elsize;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (STRING_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (STRING_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_UNICODE(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_char *op = output;

    npy_intp i;
    int skip = PyArray_DESCR(aop)->elsize;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (UNICODE_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (UNICODE_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_VOID(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_char *op = output;

    npy_intp i;
    int skip = PyArray_DESCR(aop)->elsize;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (VOID_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (VOID_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_DATETIME(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_datetime *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (DATETIME_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (DATETIME_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}

#line 1707
static void
OBJECT_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *NPY_UNUSED(aip), void *aop)
{
    PyObject **ip = input;
    npy_timedelta *op = output;

    npy_intp i;
    int skip = 1;

    for (i = 0; i < n; i++, ip++, op += skip) {
        if (*ip == NULL) {
            if (TIMEDELTA_setitem(Py_False, op, aop) < 0) {
                return;
            }
        }
        else {
            if (TIMEDELTA_setitem(*ip, op, aop) < 0) {
                return;
            }
        }
    }
}



#line 1756

static void
STRING_to_BOOL(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_bool *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 1
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (BOOL_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_BYTE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_byte *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (BYTE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_UBYTE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_ubyte *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (UBYTE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_SHORT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_short *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (SHORT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_USHORT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_ushort *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (USHORT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_INT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_int *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (INT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_UINT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_uint *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (UINT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_LONG(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_long *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (LONG_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_ULONG(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_ulong *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (ULONG_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_LONGLONG(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_longlong *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (LONGLONG_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_ulonglong *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (ULONGLONG_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_HALF(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_half *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (HALF_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_FLOAT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_float *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (FLOAT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_DOUBLE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_double *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (DOUBLE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_longdouble *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (LONGDOUBLE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_CFLOAT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_cfloat *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (CFLOAT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_cdouble *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (CDOUBLE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_clongdouble *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (CLONGDOUBLE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_DATETIME(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_datetime *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (DATETIME_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
STRING_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_timedelta *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (TIMEDELTA_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_BOOL(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_bool *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 1
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (BOOL_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_BYTE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_byte *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (BYTE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_UBYTE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_ubyte *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (UBYTE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_SHORT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_short *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (SHORT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_USHORT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_ushort *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (USHORT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_INT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_int *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (INT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_UINT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_uint *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (UINT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_LONG(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_long *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (LONG_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_ULONG(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_ulong *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (ULONG_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_LONGLONG(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_longlong *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (LONGLONG_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_ulonglong *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (ULONGLONG_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_HALF(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_half *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (HALF_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_FLOAT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_float *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (FLOAT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_DOUBLE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_double *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (DOUBLE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_longdouble *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (LONGDOUBLE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_CFLOAT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_cfloat *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (CFLOAT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_cdouble *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (CDOUBLE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_clongdouble *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (CLONGDOUBLE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_DATETIME(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_datetime *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (DATETIME_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
UNICODE_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_timedelta *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (TIMEDELTA_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_BOOL(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_bool *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (BOOL_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_BYTE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_byte *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (BYTE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_UBYTE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_ubyte *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (UBYTE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_SHORT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_short *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (SHORT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_USHORT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_ushort *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (USHORT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_INT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_int *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (INT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_UINT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_uint *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (UINT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_LONG(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_long *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (LONG_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_ULONG(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_ulong *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (ULONG_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_LONGLONG(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_longlong *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (LONGLONG_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_ULONGLONG(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_ulonglong *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (ULONGLONG_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_HALF(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_half *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (HALF_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_FLOAT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_float *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (FLOAT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_DOUBLE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_double *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (DOUBLE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_LONGDOUBLE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_longdouble *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (LONGDOUBLE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_CFLOAT(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_cfloat *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (CFLOAT_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_CDOUBLE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_cdouble *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (CDOUBLE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_CLONGDOUBLE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_clongdouble *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (CLONGDOUBLE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = (PyArray_DESCR(aop)->elsize);

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_DATETIME(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_datetime *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (DATETIME_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}



#line 1756

static void
VOID_to_TIMEDELTA(void *input, void *output, npy_intp n,
        void *vaip, void *aop)
{
    npy_char *ip = input;
    npy_timedelta *op = output;
    PyArrayObject *aip = vaip;

    npy_intp i;
    int skip = PyArray_DESCR(aip)->elsize;
    int oskip = 1;

    for (i = 0; i < n; i++, ip+=skip, op+=oskip) {
        PyObject *temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            return;
        }
#if 0
        /* Legacy behaviour converts strings to integers before going to bool */
        Py_SETREF(temp, PyNumber_Long(temp));
        if (temp == NULL) {
            return;
        }
#endif
        if (TIMEDELTA_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}





#line 1810
static void
BOOL_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_bool *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
BYTE_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_byte *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
UBYTE_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_ubyte *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
SHORT_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_short *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
USHORT_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_ushort *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
INT_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_int *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
UINT_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_uint *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
LONG_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_long *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
ULONG_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_ulong *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
LONGLONG_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_longlong *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
ULONGLONG_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_ulonglong *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
HALF_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_half *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
FLOAT_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_float *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
DOUBLE_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_double *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
LONGDOUBLE_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_longdouble *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
CFLOAT_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_cfloat *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
CDOUBLE_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_cdouble *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
CLONGDOUBLE_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_clongdouble *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
DATETIME_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_datetime *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
TIMEDELTA_to_STRING(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_timedelta *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (STRING_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
BOOL_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_bool *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
BYTE_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_byte *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
UBYTE_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_ubyte *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
SHORT_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_short *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
USHORT_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_ushort *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
INT_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_int *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
UINT_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_uint *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
LONG_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_long *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
ULONG_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_ulong *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
LONGLONG_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_longlong *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
ULONGLONG_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_ulonglong *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
HALF_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_half *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
FLOAT_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_float *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
DOUBLE_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_double *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
LONGDOUBLE_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_longdouble *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
CFLOAT_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_cfloat *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
CDOUBLE_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_cdouble *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
CLONGDOUBLE_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_clongdouble *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
DATETIME_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_datetime *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
TIMEDELTA_to_UNICODE(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_timedelta *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (UNICODE_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
BOOL_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_bool *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
BYTE_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_byte *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
UBYTE_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_ubyte *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
SHORT_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_short *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
USHORT_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_ushort *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
INT_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_int *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
UINT_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_uint *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
LONG_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_long *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
ULONG_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_ulong *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
LONGLONG_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_longlong *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
ULONGLONG_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_ulonglong *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
HALF_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_half *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
FLOAT_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_float *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
DOUBLE_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_double *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
LONGDOUBLE_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_longdouble *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
CFLOAT_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_cfloat *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
CDOUBLE_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_cdouble *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
CLONGDOUBLE_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_clongdouble *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
DATETIME_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_datetime *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}


#line 1810
static void
TIMEDELTA_to_VOID(void *input, void *output, npy_intp n,
        void *vaip, void *vaop)
{
    npy_timedelta *ip = input;
    npy_char *op = output;
    PyArrayObject *aip = vaip;
    PyArrayObject *aop = vaop;

    npy_intp i;
    PyObject *temp = NULL;
    int skip = 1;
    int oskip = PyArray_DESCR(aop)->elsize;
    for (i = 0; i < n; i++, ip += skip, op += oskip) {
        temp = PyArray_Scalar(ip, PyArray_DESCR(aip), (PyObject *)aip);
        if (temp == NULL) {
            Py_INCREF(Py_False);
            temp = Py_False;
        }
        if (VOID_setitem(temp, op, aop)) {
            Py_DECREF(temp);
            return;
        }
        Py_DECREF(temp);
    }
}




/*
 *****************************************************************************
 **                               SCAN                                      **
 *****************************************************************************
 */


/*
 * The first ignore argument is for backwards compatibility.
 * Should be removed when the API version is bumped up.
 */

#line 1860
static int
SHORT_scan(FILE *fp, npy_short *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%""hd", ip);
}

#line 1860
static int
USHORT_scan(FILE *fp, npy_ushort *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%""hu", ip);
}

#line 1860
static int
INT_scan(FILE *fp, npy_int *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%""d", ip);
}

#line 1860
static int
UINT_scan(FILE *fp, npy_uint *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%""u", ip);
}

#line 1860
static int
LONG_scan(FILE *fp, npy_long *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%""ld", ip);
}

#line 1860
static int
ULONG_scan(FILE *fp, npy_ulong *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%""lu", ip);
}

#line 1860
static int
LONGLONG_scan(FILE *fp, npy_longlong *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%"NPY_LONGLONG_FMT, ip);
}

#line 1860
static int
ULONGLONG_scan(FILE *fp, npy_ulonglong *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    return fscanf(fp, "%"NPY_ULONGLONG_FMT, ip);
}


#line 1872
static int
FLOAT_scan(FILE *fp, npy_float *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    double result;
    int ret;

    ret = NumPyOS_ascii_ftolf(fp, &result);
    *ip = (npy_float) result;
    return ret;
}

#line 1872
static int
DOUBLE_scan(FILE *fp, npy_double *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    double result;
    int ret;

    ret = NumPyOS_ascii_ftolf(fp, &result);
    *ip = (npy_double) result;
    return ret;
}


static int
LONGDOUBLE_scan(FILE *fp, npy_longdouble *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    long double result;
    int ret;

    ret = NumPyOS_ascii_ftoLf(fp, &result);
    *ip = (npy_longdouble) result;
    return ret;
}

static int
HALF_scan(FILE *fp, npy_half *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignored))
{
    double result;
    int ret;

    ret = NumPyOS_ascii_ftolf(fp, &result);
    *ip = npy_double_to_half(result);
    return ret;
}

#line 1915
static int
BYTE_scan(FILE *fp, npy_byte *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignore2))
{
    npy_int temp;
    int num;

    num = fscanf(fp, "%""d", &temp);
    *ip = (npy_byte) temp;
    return num;
}

#line 1915
static int
UBYTE_scan(FILE *fp, npy_ubyte *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignore2))
{
    npy_uint temp;
    int num;

    num = fscanf(fp, "%""u", &temp);
    *ip = (npy_ubyte) temp;
    return num;
}


static int
BOOL_scan(FILE *fp, npy_bool *ip, void *NPY_UNUSED(ignore),
        PyArray_Descr *NPY_UNUSED(ignore2))
{
    double result;
    int ret;

    ret = NumPyOS_ascii_ftolf(fp, &result);
    *ip = (npy_bool) (result != 0.0);
    return ret;
}

#line 1944
static int
CFLOAT_scan(FILE *fp, npy_cfloat *ip, void *NPY_UNUSED(ignore),
             PyArray_Descr *NPY_UNUSED(ignored))
{
    double result;
    int ret_real, ret_imag;

    ret_real = NumPyOS_ascii_ftolf(fp, &result);
    npy_cfloat output;
    // Peek next character
    char next = getc(fp);
    if ((next == '+') || (next == '-')) {
        // Imaginary component specified
        output.real = result;
        // Revert peek and read imaginary component
        ungetc(next, fp);
        ret_imag = NumPyOS_ascii_ftolf(fp, &result);
        // Peak next character
        next = getc(fp);
        if ((ret_imag == 1) && (next == 'j')) {
            // If read is successful and the immediate following char is j
            output.imag = result;
        }
        else {
            output.imag = 0;
            // Push an invalid char to trigger the not everything is read error
            ungetc('a', fp);
        }
    }
    else if (next == 'j') {
        // Real component not specified
        output.real = 0;
        output.imag = result;
    }
    else {
        // Imaginary component not specified
        output.real = result;
        output.imag = 0.;
        // Next character is not + / - / j. Revert peek.
        ungetc(next, fp);
    }
    *(npy_cfloat *)ip = output;
    return ret_real;
}

#line 1944
static int
CDOUBLE_scan(FILE *fp, npy_cdouble *ip, void *NPY_UNUSED(ignore),
             PyArray_Descr *NPY_UNUSED(ignored))
{
    double result;
    int ret_real, ret_imag;

    ret_real = NumPyOS_ascii_ftolf(fp, &result);
    npy_cdouble output;
    // Peek next character
    char next = getc(fp);
    if ((next == '+') || (next == '-')) {
        // Imaginary component specified
        output.real = result;
        // Revert peek and read imaginary component
        ungetc(next, fp);
        ret_imag = NumPyOS_ascii_ftolf(fp, &result);
        // Peak next character
        next = getc(fp);
        if ((ret_imag == 1) && (next == 'j')) {
            // If read is successful and the immediate following char is j
            output.imag = result;
        }
        else {
            output.imag = 0;
            // Push an invalid char to trigger the not everything is read error
            ungetc('a', fp);
        }
    }
    else if (next == 'j') {
        // Real component not specified
        output.real = 0;
        output.imag = result;
    }
    else {
        // Imaginary component not specified
        output.real = result;
        output.imag = 0.;
        // Next character is not + / - / j. Revert peek.
        ungetc(next, fp);
    }
    *(npy_cdouble *)ip = output;
    return ret_real;
}



#line 1996

#define CLONGDOUBLE_scan NULL


#line 1996

#define OBJECT_scan NULL


#line 1996

#define STRING_scan NULL


#line 1996

#define UNICODE_scan NULL


#line 1996

#define VOID_scan NULL


#line 1996

#define DATETIME_scan NULL


#line 1996

#define TIMEDELTA_scan NULL




/*
 *****************************************************************************
 **                             FROMSTR                                     **
 *****************************************************************************
 */


#line 2021
static int
BYTE_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_long result;

    result = PyOS_strtol(str, endptr, 10);
    *(npy_byte *)ip = result;
    return 0;
}

#line 2021
static int
UBYTE_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_ulong result;

    result = PyOS_strtoul(str, endptr, 10);
    *(npy_ubyte *)ip = result;
    return 0;
}

#line 2021
static int
SHORT_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_long result;

    result = PyOS_strtol(str, endptr, 10);
    *(npy_short *)ip = result;
    return 0;
}

#line 2021
static int
USHORT_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_ulong result;

    result = PyOS_strtoul(str, endptr, 10);
    *(npy_ushort *)ip = result;
    return 0;
}

#line 2021
static int
INT_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_long result;

    result = PyOS_strtol(str, endptr, 10);
    *(npy_int *)ip = result;
    return 0;
}

#line 2021
static int
UINT_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_ulong result;

    result = PyOS_strtoul(str, endptr, 10);
    *(npy_uint *)ip = result;
    return 0;
}

#line 2021
static int
LONG_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_long result;

    result = PyOS_strtol(str, endptr, 10);
    *(npy_long *)ip = result;
    return 0;
}

#line 2021
static int
ULONG_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_ulong result;

    result = PyOS_strtoul(str, endptr, 10);
    *(npy_ulong *)ip = result;
    return 0;
}

#line 2021
static int
LONGLONG_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_longlong result;

    result = NumPyOS_strtoll(str, endptr, 10);
    *(npy_longlong *)ip = result;
    return 0;
}

#line 2021
static int
ULONGLONG_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_ulonglong result;

    result = NumPyOS_strtoull(str, endptr, 10);
    *(npy_ulonglong *)ip = result;
    return 0;
}

#line 2021
static int
DATETIME_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_longlong result;

    result = NumPyOS_strtoll(str, endptr, 10);
    *(npy_datetime *)ip = result;
    return 0;
}

#line 2021
static int
TIMEDELTA_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    npy_longlong result;

    result = NumPyOS_strtoll(str, endptr, 10);
    *(npy_timedelta *)ip = result;
    return 0;
}


#line 2038
static int
FLOAT_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    double result;

    result = NumPyOS_ascii_strtod(str, endptr);
    *(npy_float *)ip = result;
    return 0;
}

#line 2038
static int
DOUBLE_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    double result;

    result = NumPyOS_ascii_strtod(str, endptr);
    *(npy_double *)ip = result;
    return 0;
}


static int
LONGDOUBLE_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    long double result;

    result = NumPyOS_ascii_strtold(str, endptr);
    *(npy_longdouble *)ip = result;
    return 0;
}

static int
HALF_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    double result;

    result = NumPyOS_ascii_strtod(str, endptr);
    *(npy_half *)ip = npy_double_to_half(result);
    return 0;
}

static int
BOOL_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    double result;

    result = NumPyOS_ascii_strtod(str, endptr);
    *(npy_bool *)ip = (result != 0.0);
    return 0;
}

#line 2087
static int
CFLOAT_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    double result;

    result = NumPyOS_ascii_strtod(str, endptr);
    npy_cfloat output;

    if (endptr && ((*endptr[0] == '+') || (*endptr[0] == '-'))) {
        // Imaginary component specified
        output.real = result;
        // Reading imaginary component
        char **prev = endptr;
        str = *endptr;
        result = NumPyOS_ascii_strtod(str, endptr);
        if (endptr && *endptr[0] == 'j') {
            // Read is successful if the immediate following char is j
            output.imag = result;
            // Skip j
            ++*endptr;
        }
        else {
            /*
             * Set endptr to previous char to trigger the not everything is
             * read error
             */
            endptr = prev;
            output.imag = 0;
        }
    }
    else if (endptr && *endptr[0] == 'j') {
        // Real component not specified
        output.real = 0;
        output.imag = result;
        // Skip j
        ++*endptr;
    }
    else {
        // Imaginary component not specified
        output.real = result;
        output.imag = 0.;
    }
    *(npy_cfloat *)ip = output;
    return 0;
}

#line 2087
static int
CDOUBLE_fromstr(char *str, void *ip, char **endptr,
        PyArray_Descr *NPY_UNUSED(ignore))
{
    double result;

    result = NumPyOS_ascii_strtod(str, endptr);
    npy_cdouble output;

    if (endptr && ((*endptr[0] == '+') || (*endptr[0] == '-'))) {
        // Imaginary component specified
        output.real = result;
        // Reading imaginary component
        char **prev = endptr;
        str = *endptr;
        result = NumPyOS_ascii_strtod(str, endptr);
        if (endptr && *endptr[0] == 'j') {
            // Read is successful if the immediate following char is j
            output.imag = result;
            // Skip j
            ++*endptr;
        }
        else {
            /*
             * Set endptr to previous char to trigger the not everything is
             * read error
             */
            endptr = prev;
            output.imag = 0;
        }
    }
    else if (endptr && *endptr[0] == 'j') {
        // Real component not specified
        output.real = 0;
        output.imag = result;
        // Skip j
        ++*endptr;
    }
    else {
        // Imaginary component not specified
        output.real = result;
        output.imag = 0.;
    }
    *(npy_cdouble *)ip = output;
    return 0;
}



#line 2140

#define CLONGDOUBLE_fromstr NULL


#line 2140

#define OBJECT_fromstr NULL


#line 2140

#define STRING_fromstr NULL


#line 2140

#define UNICODE_fromstr NULL


#line 2140

#define VOID_fromstr NULL




/*
 *****************************************************************************
 **                            COPYSWAPN                                    **
 *****************************************************************************
 */


static inline void
_basic_copyn(void *dst, npy_intp dstride, void *src, npy_intp sstride,
             npy_intp n, int elsize) {
    if (src == NULL) {
        return;
    }
    if (sstride == elsize && dstride == elsize) {
        memcpy(dst, src, n*elsize);
    }
    else {
        _unaligned_strided_byte_copy(dst, dstride, src, sstride,
                n, elsize);
    }
}

static inline void
_basic_copy(void *dst, void *src, int elsize) {
    if (src == NULL) {
        return;
    }
    memcpy(dst, src, elsize);
}


#line 2192
static void
SHORT_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_short));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_short));
    }
}

static void
SHORT_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_short));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_SHORT == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_SHORT == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_SHORT-1);
            nn = NPY_SIZEOF_SHORT / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2192
static void
USHORT_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_ushort));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_ushort));
    }
}

static void
USHORT_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_ushort));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_SHORT == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_SHORT == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_SHORT == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_SHORT-1);
            nn = NPY_SIZEOF_SHORT / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2192
static void
INT_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_int));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_int));
    }
}

static void
INT_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_int));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_INT == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_INT == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_INT-1);
            nn = NPY_SIZEOF_INT / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2192
static void
UINT_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_uint));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_uint));
    }
}

static void
UINT_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_uint));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_INT == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_INT == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_INT == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_INT-1);
            nn = NPY_SIZEOF_INT / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2192
static void
LONG_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_long));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_long));
    }
}

static void
LONG_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_long));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_LONG == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_LONG == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_LONG-1);
            nn = NPY_SIZEOF_LONG / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2192
static void
ULONG_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_ulong));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_ulong));
    }
}

static void
ULONG_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_ulong));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_LONG == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_LONG == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONG == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_LONG-1);
            nn = NPY_SIZEOF_LONG / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2192
static void
LONGLONG_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_longlong));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_longlong));
    }
}

static void
LONGLONG_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_longlong));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_LONGLONG == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_LONGLONG == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_LONGLONG-1);
            nn = NPY_SIZEOF_LONGLONG / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2192
static void
ULONGLONG_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_ulonglong));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_ulonglong));
    }
}

static void
ULONGLONG_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_ulonglong));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_LONGLONG == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_LONGLONG == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGLONG == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_LONGLONG-1);
            nn = NPY_SIZEOF_LONGLONG / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2192
static void
HALF_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_half));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_half));
    }
}

static void
HALF_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_half));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_HALF == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_HALF == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_HALF == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_HALF == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_HALF == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_HALF == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_HALF-1);
            nn = NPY_SIZEOF_HALF / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2192
static void
FLOAT_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_float));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_float));
    }
}

static void
FLOAT_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_float));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_FLOAT == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_FLOAT == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_FLOAT-1);
            nn = NPY_SIZEOF_FLOAT / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2192
static void
DOUBLE_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_double));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_double));
    }
}

static void
DOUBLE_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_double));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_DOUBLE == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_DOUBLE == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_DOUBLE-1);
            nn = NPY_SIZEOF_DOUBLE / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2192
static void
LONGDOUBLE_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_longdouble));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_longdouble));
    }
}

static void
LONGDOUBLE_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_longdouble));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_LONGDOUBLE == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_LONGDOUBLE == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_LONGDOUBLE-1);
            nn = NPY_SIZEOF_LONGDOUBLE / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2192
static void
DATETIME_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_datetime));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_datetime));
    }
}

static void
DATETIME_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_datetime));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_DATETIME == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_DATETIME == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DATETIME == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DATETIME == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DATETIME == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DATETIME == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_DATETIME-1);
            nn = NPY_SIZEOF_DATETIME / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2192
static void
TIMEDELTA_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
                   npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_timedelta));
    if (swap) {
        _strided_byte_swap(dst, dstride, n, sizeof(npy_timedelta));
    }
}

static void
TIMEDELTA_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_timedelta));

    if (swap) {
        char *a, *b, c;

        a = (char *)dst;
#if NPY_SIZEOF_TIMEDELTA == 2
        b = a + 1;
        c = *a; *a++ = *b; *b = c;
#elif NPY_SIZEOF_TIMEDELTA == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_TIMEDELTA == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_TIMEDELTA == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_TIMEDELTA == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_TIMEDELTA == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_TIMEDELTA-1);
            nn = NPY_SIZEOF_TIMEDELTA / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}



#line 2276
static void
BOOL_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
        npy_intp n, int NPY_UNUSED(swap), void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_bool));
    /* ignore swap */
}

static void
BOOL_copyswap (void *dst, void *src, int NPY_UNUSED(swap),
        void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_bool));
    /* ignore swap */
}


#line 2276
static void
BYTE_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
        npy_intp n, int NPY_UNUSED(swap), void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_byte));
    /* ignore swap */
}

static void
BYTE_copyswap (void *dst, void *src, int NPY_UNUSED(swap),
        void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_byte));
    /* ignore swap */
}


#line 2276
static void
UBYTE_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
        npy_intp n, int NPY_UNUSED(swap), void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_ubyte));
    /* ignore swap */
}

static void
UBYTE_copyswap (void *dst, void *src, int NPY_UNUSED(swap),
        void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_ubyte));
    /* ignore swap */
}





#line 2304
static void
CFLOAT_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
        npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_cfloat));

    if (swap) {
        _strided_byte_swap(dst, dstride, n, NPY_SIZEOF_FLOAT);
        _strided_byte_swap(((char *)dst + NPY_SIZEOF_FLOAT), dstride,
                n, NPY_SIZEOF_FLOAT);
    }
}

static void
CFLOAT_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_cfloat));

    if (swap) {
        char *a, *b, c;
        a = (char *)dst;
#if NPY_SIZEOF_FLOAT == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 2;
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 4;
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 5;
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 6;
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_FLOAT == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 8;
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_FLOAT - 1);
            nn = NPY_SIZEOF_FLOAT / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
            a += nn;
            b = a + (NPY_SIZEOF_FLOAT - 1);
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2304
static void
CDOUBLE_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
        npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_cdouble));

    if (swap) {
        _strided_byte_swap(dst, dstride, n, NPY_SIZEOF_DOUBLE);
        _strided_byte_swap(((char *)dst + NPY_SIZEOF_DOUBLE), dstride,
                n, NPY_SIZEOF_DOUBLE);
    }
}

static void
CDOUBLE_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_cdouble));

    if (swap) {
        char *a, *b, c;
        a = (char *)dst;
#if NPY_SIZEOF_DOUBLE == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 2;
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 4;
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 5;
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 6;
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_DOUBLE == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 8;
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_DOUBLE - 1);
            nn = NPY_SIZEOF_DOUBLE / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
            a += nn;
            b = a + (NPY_SIZEOF_DOUBLE - 1);
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}


#line 2304
static void
CLONGDOUBLE_copyswapn (void *dst, npy_intp dstride, void *src, npy_intp sstride,
        npy_intp n, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copyn(dst, dstride, src, sstride, n, sizeof(npy_clongdouble));

    if (swap) {
        _strided_byte_swap(dst, dstride, n, NPY_SIZEOF_LONGDOUBLE);
        _strided_byte_swap(((char *)dst + NPY_SIZEOF_LONGDOUBLE), dstride,
                n, NPY_SIZEOF_LONGDOUBLE);
    }
}

static void
CLONGDOUBLE_copyswap (void *dst, void *src, int swap, void *NPY_UNUSED(arr))
{
    /* copy first if needed */
    _basic_copy(dst, src, sizeof(npy_clongdouble));

    if (swap) {
        char *a, *b, c;
        a = (char *)dst;
#if NPY_SIZEOF_LONGDOUBLE == 4
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 2;
        b = a + 3;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 8
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 4;
        b = a + 7;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 10
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 5;
        b = a + 9;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 12
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 6;
        b = a + 11;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#elif NPY_SIZEOF_LONGDOUBLE == 16
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
        a += 8;
        b = a + 15;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b-- = c;
        c = *a; *a++ = *b; *b   = c;
#else
        {
            int i, nn;

            b = a + (NPY_SIZEOF_LONGDOUBLE - 1);
            nn = NPY_SIZEOF_LONGDOUBLE / 2;
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
            a += nn;
            b = a + (NPY_SIZEOF_LONGDOUBLE - 1);
            for (i = 0; i < nn; i++) {
                c = *a;
                *a++ = *b;
                *b-- = c;
            }
        }
#endif
    }
}



static void
OBJECT_copyswapn(PyObject **dst, npy_intp dstride, PyObject **src,
        npy_intp sstride, npy_intp n, int NPY_UNUSED(swap),
        void *NPY_UNUSED(arr))
{
    npy_intp i;
    if (src != NULL) {
        if (NPY__ALIGNED(dst, sizeof(PyObject **))
                && NPY__ALIGNED(src, sizeof(PyObject **))
                && NPY__ALIGNED(dstride, sizeof(PyObject **))
                && NPY__ALIGNED(sstride, sizeof(PyObject **))) {
            dstride /= sizeof(PyObject **);
            sstride /= sizeof(PyObject **);
            for (i = 0; i < n; i++) {
                Py_XINCREF(*src);
                Py_XDECREF(*dst);
                *dst = *src;
                dst += dstride;
                src += sstride;
            }
        }
        else {
            unsigned char *dstp, *srcp;
            PyObject *tmp;
            dstp = (unsigned char*)dst;
            srcp = (unsigned char*)src;
            for (i = 0; i < n; i++) {
                memcpy(&tmp, srcp, sizeof(tmp));
                Py_XINCREF(tmp);
                memcpy(&tmp, dstp, sizeof(tmp));
                Py_XDECREF(tmp);
                memcpy(dstp, srcp, sizeof(tmp));
                dstp += dstride;
                srcp += sstride;
            }
        }
    }
    /* ignore swap */
    return;
}

static void
OBJECT_copyswap(PyObject **dst, PyObject **src, int NPY_UNUSED(swap),
        void *NPY_UNUSED(arr))
{

    if (src != NULL) {
        if (NPY__ALIGNED(dst,sizeof(PyObject **)) &&
                NPY__ALIGNED(src,sizeof(PyObject **))) {
            Py_XINCREF(*src);
            Py_XDECREF(*dst);
            *dst = *src;
        }
        else {
            PyObject *tmp;
            memcpy(&tmp, src, sizeof(tmp));
            Py_XINCREF(tmp);
            memcpy(&tmp, dst, sizeof(tmp));
            Py_XDECREF(tmp);
            memcpy(dst, src, sizeof(tmp));
        }
    }
}

/* ignore swap */
static void
STRING_copyswapn (char *dst, npy_intp dstride, char *src, npy_intp sstride,
                  npy_intp n, int NPY_UNUSED(swap), PyArrayObject *arr)
{
    assert(arr != NULL);
    if (arr == NULL) {
        return;
    }
    _basic_copyn(dst, dstride, src, sstride, n, PyArray_DESCR(arr)->elsize);
    return;
}


/* */
static void
VOID_copyswapn (char *dst, npy_intp dstride, char *src, npy_intp sstride,
                npy_intp n, int swap, PyArrayObject *arr)
{
    PyArray_Descr *descr;

    assert(arr != NULL);
    if (arr == NULL) {
        return;
    }

    descr = PyArray_DESCR(arr);

    if (PyArray_HASFIELDS(arr)) {
        PyObject *key, *value;
        Py_ssize_t pos = 0;

        PyArrayObject_fields dummy_fields = get_dummy_stack_array(arr);
        PyArrayObject *dummy_arr = (PyArrayObject *)&dummy_fields;

        while (PyDict_Next(descr->fields, &pos, &key, &value)) {
            npy_intp offset;
            PyArray_Descr *new;
            if (NPY_TITLE_KEY(key, value)) {
                continue;
            }
            if (_unpack_field(value, &new, &offset) < 0) {
                return;
            }

            dummy_fields.descr = new;
            new->f->copyswapn(dst+offset, dstride,
                    (src != NULL ? src+offset : NULL),
                    sstride, n, swap, dummy_arr);
        }
        return;
    }
    if (PyDataType_HASSUBARRAY(descr)) {
        PyArray_Descr *new;
        npy_intp num;
        npy_intp i;
        int subitemsize;
        char *dstptr, *srcptr;
        /*
         * In certain cases subarray copy can be optimized. This is when
         * swapping is unnecessary and the subarrays data type can certainly
         * be simply copied (no object, fields, subarray, and not a user dtype).
         */
        npy_bool can_optimize_subarray = (!swap &&
                !PyDataType_HASFIELDS(descr->subarray->base) &&
                !PyDataType_HASSUBARRAY(descr->subarray->base) &&
                !PyDataType_REFCHK(descr->subarray->base) &&
                (descr->subarray->base->type_num < NPY_NTYPES));

        if (can_optimize_subarray) {
            _basic_copyn(dst, dstride, src, sstride, n, descr->elsize);
            return;
        }

        new = descr->subarray->base;
        dstptr = dst;
        srcptr = src;
        subitemsize = new->elsize;
        if (subitemsize == 0) {
            /* There cannot be any elements, so return */
            return;
        }

        PyArrayObject_fields dummy_fields = get_dummy_stack_array(arr);
        PyArrayObject *dummy_arr = (PyArrayObject *)&dummy_fields;
        ((PyArrayObject_fields *)dummy_arr)->descr = new;

        num = descr->elsize / subitemsize;
        for (i = 0; i < n; i++) {
            new->f->copyswapn(dstptr, subitemsize, srcptr,
                    subitemsize, num, swap, dummy_arr);
            dstptr += dstride;
            if (srcptr) {
                srcptr += sstride;
            }
        }
        return;
    }
    /* Must be a naive Void type (e.g. a "V8") so simple copy is sufficient. */
    _basic_copyn(dst, dstride, src, sstride, n, descr->elsize);
    return;
}

static void
VOID_copyswap (char *dst, char *src, int swap, PyArrayObject *arr)
{
    PyArray_Descr *descr;

    assert(arr != NULL);
    if (arr == NULL) {
        return;
    }

    descr = PyArray_DESCR(arr);

    if (PyArray_HASFIELDS(arr)) {
        PyObject *key, *value;
        Py_ssize_t pos = 0;

        PyArrayObject_fields dummy_fields = get_dummy_stack_array(arr);
        PyArrayObject *dummy_arr = (PyArrayObject *)&dummy_fields;

        while (PyDict_Next(descr->fields, &pos, &key, &value)) {
            npy_intp offset;

            PyArray_Descr * new;
            if (NPY_TITLE_KEY(key, value)) {
                continue;
            }
            if (_unpack_field(value, &new, &offset) < 0) {
                return;
            }
            dummy_fields.descr = new;
            new->f->copyswap(dst+offset,
                    (src != NULL ? src+offset : NULL),
                    swap, dummy_arr);
        }
        return;
    }
    if (PyDataType_HASSUBARRAY(descr)) {
        PyArray_Descr *new;
        npy_intp num;
        int subitemsize;
        /*
         * In certain cases subarray copy can be optimized. This is when
         * swapping is unnecessary and the subarrays data type can certainly
         * be simply copied (no object, fields, subarray, and not a user dtype).
         */
        npy_bool can_optimize_subarray = (!swap &&
                !PyDataType_HASFIELDS(descr->subarray->base) &&
                !PyDataType_HASSUBARRAY(descr->subarray->base) &&
                !PyDataType_REFCHK(descr->subarray->base) &&
                (descr->subarray->base->type_num < NPY_NTYPES));

        if (can_optimize_subarray) {
            _basic_copy(dst, src, descr->elsize);
            return;
        }

        new = descr->subarray->base;
        subitemsize = new->elsize;
        if (subitemsize == 0) {
            /* There cannot be any elements, so return */
            return;
        }

        PyArrayObject_fields dummy_fields = get_dummy_stack_array(arr);
        PyArrayObject *dummy_arr = (PyArrayObject *)&dummy_fields;
        dummy_fields.descr = new;

        num = descr->elsize / subitemsize;
        new->f->copyswapn(dst, subitemsize, src,
                subitemsize, num, swap, dummy_arr);
        return;
    }
    /* Must be a naive Void type (e.g. a "V8") so simple copy is sufficient. */
    _basic_copy(dst, src, descr->elsize);
    return;
}


static void
UNICODE_copyswapn (char *dst, npy_intp dstride, char *src, npy_intp sstride,
                   npy_intp n, int swap, PyArrayObject *arr)
{
    int itemsize;

    assert(arr != NULL);
    if (arr == NULL) {
        return;
    }
    itemsize = PyArray_DESCR(arr)->elsize;
    _basic_copyn(dst, dstride, src, sstride, n, itemsize);

    if (swap) {
        int i;
        char *_dst;
        itemsize = itemsize / 4;

        while (n > 0) {
            _dst = dst;
            for (i=0; i < itemsize; i++) {
                npy_bswap4_unaligned(_dst);
                _dst += 4;
            }
            dst += dstride;
            --n;
        }
    }
}


static void
STRING_copyswap(char *dst, char *src, int NPY_UNUSED(swap), PyArrayObject *arr)
{
    assert(arr != NULL);
    if (arr == NULL) {
        return;
    }
    /* copy first if needed */
    _basic_copy(dst, src, PyArray_DESCR(arr)->elsize);
}

static void
UNICODE_copyswap (char *dst, char *src, int swap, PyArrayObject *arr)
{
    int itemsize;

    assert(arr != NULL);
    if (arr == NULL) {
        return;
    }
    itemsize = PyArray_DESCR(arr)->elsize;
    _basic_copy(dst, src, itemsize);

    if (swap) {
        int i;
        char *_dst;
        itemsize = itemsize / 4;

        _dst = dst;
        for (i=0; i < itemsize; i++) {
            npy_bswap4_unaligned(_dst);
            _dst += 4;
        }
    }
}


/*
 *****************************************************************************
 **                                 NONZERO                                 **
 *****************************************************************************
 */

#define _NONZERO(a) ((a) != 0)

#line 2758
static npy_bool
BOOL_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_bool *ptmp = (npy_bool *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_bool tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_bool));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
BYTE_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_byte *ptmp = (npy_byte *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_byte tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_byte));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
UBYTE_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_ubyte *ptmp = (npy_ubyte *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_ubyte tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_ubyte));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
SHORT_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_short *ptmp = (npy_short *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_short tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_short));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
USHORT_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_ushort *ptmp = (npy_ushort *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_ushort tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_ushort));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
INT_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_int *ptmp = (npy_int *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_int tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_int));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
UINT_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_uint *ptmp = (npy_uint *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_uint tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_uint));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
LONG_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_long *ptmp = (npy_long *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_long tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_long));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
ULONG_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_ulong *ptmp = (npy_ulong *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_ulong tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_ulong));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
LONGLONG_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_longlong *ptmp = (npy_longlong *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_longlong tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_longlong));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
ULONGLONG_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_ulonglong *ptmp = (npy_ulonglong *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_ulonglong tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_ulonglong));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
HALF_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_half *ptmp = (npy_half *)ip;
        return (npy_bool) !npy_half_iszero(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_half tmp;
#if 1
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_half));
#endif
        return (npy_bool) !npy_half_iszero(tmp);
    }
}

#line 2758
static npy_bool
FLOAT_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_float *ptmp = (npy_float *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_float tmp;
#if 1
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_float));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
DOUBLE_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_double *ptmp = (npy_double *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_double tmp;
#if 1
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_double));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
LONGDOUBLE_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_longdouble *ptmp = (npy_longdouble *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_longdouble tmp;
#if 1
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_longdouble));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
DATETIME_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_datetime *ptmp = (npy_datetime *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_datetime tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_datetime));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}

#line 2758
static npy_bool
TIMEDELTA_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_timedelta *ptmp = (npy_timedelta *)ip;
        return (npy_bool) _NONZERO(*ptmp);
    }
    else {
        /*
         * Don't worry about swapping for integer types,
         * since we are just testing for equality with 0.
         * For float types, the signed zeros require us to swap.
         */
        npy_timedelta tmp;
#if 0
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
#else
        memcpy(&tmp, ip, sizeof(npy_timedelta));
#endif
        return (npy_bool) _NONZERO(tmp);
    }
}


#line 2788
static npy_bool
CFLOAT_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_cfloat *ptmp = (npy_cfloat *)ip;
        return (npy_bool) ((ptmp->real != 0) || (ptmp->imag != 0));
    }
    else {
        npy_cfloat tmp;
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
        return (npy_bool) ((tmp.real != 0) || (tmp.imag != 0));
    }
}

#line 2788
static npy_bool
CDOUBLE_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_cdouble *ptmp = (npy_cdouble *)ip;
        return (npy_bool) ((ptmp->real != 0) || (ptmp->imag != 0));
    }
    else {
        npy_cdouble tmp;
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
        return (npy_bool) ((tmp.real != 0) || (tmp.imag != 0));
    }
}

#line 2788
static npy_bool
CLONGDOUBLE_nonzero (char *ip, PyArrayObject *ap)
{
    if (ap == NULL || PyArray_ISBEHAVED_RO(ap)) {
        npy_clongdouble *ptmp = (npy_clongdouble *)ip;
        return (npy_bool) ((ptmp->real != 0) || (ptmp->imag != 0));
    }
    else {
        npy_clongdouble tmp;
        PyArray_DESCR(ap)->f->copyswap(&tmp, ip, PyArray_ISBYTESWAPPED(ap),
                                       ap);
        return (npy_bool) ((tmp.real != 0) || (tmp.imag != 0));
    }
}



#define WHITESPACE " \t\n\r\v\f"
#define WHITELEN 6

static npy_bool
Py_STRING_ISSPACE(char ch)
{
    char white[] = WHITESPACE;
    int j;
    npy_bool space = NPY_FALSE;

    for (j = 0; j < WHITELEN; j++) {
        if (ch == white[j]) {
            space = NPY_TRUE;
            break;
        }
    }
    return space;
}

static npy_bool
STRING_nonzero (char *ip, PyArrayObject *ap)
{
    int len = PyArray_DESCR(ap)->elsize;
    int i;
    npy_bool nonz = NPY_FALSE;
    npy_bool seen_null = NPY_FALSE;

    for (i = 0; i < len; i++) {
        if (*ip == '\0') {
            seen_null = NPY_TRUE;
        }
        else if (seen_null || !Py_STRING_ISSPACE(*ip)) {
            nonz = NPY_TRUE;
            break;
        }
        ip++;
    }
    return nonz;
}

static npy_bool
UNICODE_nonzero (npy_ucs4 *ip, PyArrayObject *ap)
{
    int len = PyArray_DESCR(ap)->elsize >> 2;
    int i;
    npy_bool nonz = NPY_FALSE;
    npy_bool seen_null = NPY_FALSE;
    char *buffer = NULL;

    if (PyArray_ISBYTESWAPPED(ap) || !PyArray_ISALIGNED(ap)) {
        buffer = PyArray_malloc(PyArray_DESCR(ap)->elsize);
        if (buffer == NULL) {
            return nonz;
        }
        memcpy(buffer, ip, PyArray_DESCR(ap)->elsize);
        if (PyArray_ISBYTESWAPPED(ap)) {
            byte_swap_vector(buffer, len, 4);
        }
        ip = (npy_ucs4 *)buffer;
    }

    for (i = 0; i < len; i++) {
        if (*ip == '\0') {
            seen_null = NPY_TRUE;
        }
        else if (seen_null || !Py_UNICODE_ISSPACE(*ip)) {
            nonz = NPY_TRUE;
            break;
        }
        ip++;
    }
    PyArray_free(buffer);
    return nonz;
}

static npy_bool
OBJECT_nonzero (PyObject **ip, PyArrayObject *ap)
{

    if (PyArray_ISALIGNED(ap)) {
        if (*ip == NULL) {
            return NPY_FALSE;
        }
        return (npy_bool) PyObject_IsTrue(*ip);
    }
    else {
        PyObject *obj;
        memcpy(&obj, (void *)ip, sizeof(obj));
        if (obj == NULL) {
            return NPY_FALSE;
        }
        return (npy_bool) PyObject_IsTrue(obj);
    }
}

/*
 * if we have fields, then nonzero only if all sub-fields are nonzero.
 */
static npy_bool
VOID_nonzero (char *ip, PyArrayObject *ap)
{
    int i;
    int len;
    npy_bool nonz = NPY_FALSE;

    if (PyArray_HASFIELDS(ap)) {
        PyArray_Descr *descr;
        PyObject *key, *value;
        Py_ssize_t pos = 0;
        PyArrayObject_fields dummy_fields = get_dummy_stack_array(ap);
        PyArrayObject *dummy_arr = (PyArrayObject *)&dummy_fields;

        descr = PyArray_DESCR(ap);
        while (PyDict_Next(descr->fields, &pos, &key, &value)) {
            PyArray_Descr * new;
            npy_intp offset;
            if (NPY_TITLE_KEY(key, value)) {
                continue;
            }
            if (_unpack_field(value, &new, &offset) < 0) {
                PyErr_Clear();
                continue;
            }

            dummy_fields.descr = new;
            if ((new->alignment > 1) && !NPY__ALIGNED(ip + offset,
                        new->alignment)) {
                PyArray_CLEARFLAGS(dummy_arr, NPY_ARRAY_ALIGNED);
            }
            else {
                PyArray_ENABLEFLAGS(dummy_arr, NPY_ARRAY_ALIGNED);
            }
            if (new->f->nonzero(ip+offset, dummy_arr)) {
                nonz = NPY_TRUE;
                break;
            }
        }
        return nonz;
    }
    len = PyArray_DESCR(ap)->elsize;
    for (i = 0; i < len; i++) {
        if (*ip != '\0') {
            nonz = NPY_TRUE;
            break;
        }
        ip++;
    }
    return nonz;
}

#undef NPY__ALIGNED


/*
 *****************************************************************************
 **                                 COMPARE                                 **
 *****************************************************************************
 */


/* boolean type */

static int
BOOL_compare(npy_bool *ip1, npy_bool *ip2, PyArrayObject *NPY_UNUSED(ap))
{
    return (*ip1 ? (*ip2 ? 0 : 1) : (*ip2 ? -1 : 0));
}


/* integer types */

#line 2982

static int
BYTE_compare (npy_byte *pa, npy_byte *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_byte a = *pa;
    const npy_byte b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2982

static int
UBYTE_compare (npy_ubyte *pa, npy_ubyte *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_ubyte a = *pa;
    const npy_ubyte b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2982

static int
SHORT_compare (npy_short *pa, npy_short *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_short a = *pa;
    const npy_short b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2982

static int
USHORT_compare (npy_ushort *pa, npy_ushort *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_ushort a = *pa;
    const npy_ushort b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2982

static int
INT_compare (npy_int *pa, npy_int *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_int a = *pa;
    const npy_int b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2982

static int
UINT_compare (npy_uint *pa, npy_uint *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_uint a = *pa;
    const npy_uint b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2982

static int
LONG_compare (npy_long *pa, npy_long *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_long a = *pa;
    const npy_long b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2982

static int
ULONG_compare (npy_ulong *pa, npy_ulong *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_ulong a = *pa;
    const npy_ulong b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2982

static int
LONGLONG_compare (npy_longlong *pa, npy_longlong *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_longlong a = *pa;
    const npy_longlong b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}


#line 2982

static int
ULONGLONG_compare (npy_ulonglong *pa, npy_ulonglong *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_ulonglong a = *pa;
    const npy_ulonglong b = *pb;

    return a < b ? -1 : a == b ? 0 : 1;
}




/* float types */

/*
 * The real/complex comparison functions are compatible with the new sort
 * order for nans introduced in numpy 1.4.0. All nan values now compare
 * larger than non-nan values and are sorted to the end. The comparison
 * order is:
 *
 *      Real: [R, nan]
 *      Complex: [R + Rj, R + nanj, nan + Rj, nan + nanj]
 *
 *  where complex values with the same nan placements are sorted according
 *  to the non-nan part if it exists. If both the real and imaginary parts
 *  of complex types are non-nan the order is the same as the real parts
 *  unless they happen to be equal, in which case the order is that of the
 *  imaginary parts.
 */

#line 3018

#define LT(a,b) ((a) < (b) || ((b) != (b) && (a) ==(a)))

static int
FLOAT_compare(npy_float *pa, npy_float *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_float a = *pa;
    const npy_float b = *pb;
    int ret;

    if (LT(a,b)) {
        ret = -1;
    }
    else if (LT(b,a)) {
        ret = 1;
    }
    else {
        ret = 0;
    }
    return ret;
}


static int
CFLOAT_compare(npy_float *pa, npy_float *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_float ar = pa[0];
    const npy_float ai = pa[1];
    const npy_float br = pb[0];
    const npy_float bi = pb[1];
    int ret;

    if (ar < br) {
        if (ai == ai || bi != bi) {
            ret = -1;
        }
        else {
            ret = 1;
        }
    }
    else if (br < ar) {
        if (bi == bi || ai != ai) {
            ret = 1;
        }
        else {
            ret = -1;
        }
    }
    else if (ar == br || (ar != ar && br != br)) {
        if (LT(ai,bi)) {
            ret = -1;
        }
        else if (LT(bi,ai)) {
            ret = 1;
        }
        else {
            ret = 0;
        }
    }
    else if (ar == ar) {
        ret = -1;
    }
    else {
        ret = 1;
    }

    return ret;
}

#undef LT


#line 3018

#define LT(a,b) ((a) < (b) || ((b) != (b) && (a) ==(a)))

static int
DOUBLE_compare(npy_double *pa, npy_double *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_double a = *pa;
    const npy_double b = *pb;
    int ret;

    if (LT(a,b)) {
        ret = -1;
    }
    else if (LT(b,a)) {
        ret = 1;
    }
    else {
        ret = 0;
    }
    return ret;
}


static int
CDOUBLE_compare(npy_double *pa, npy_double *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_double ar = pa[0];
    const npy_double ai = pa[1];
    const npy_double br = pb[0];
    const npy_double bi = pb[1];
    int ret;

    if (ar < br) {
        if (ai == ai || bi != bi) {
            ret = -1;
        }
        else {
            ret = 1;
        }
    }
    else if (br < ar) {
        if (bi == bi || ai != ai) {
            ret = 1;
        }
        else {
            ret = -1;
        }
    }
    else if (ar == br || (ar != ar && br != br)) {
        if (LT(ai,bi)) {
            ret = -1;
        }
        else if (LT(bi,ai)) {
            ret = 1;
        }
        else {
            ret = 0;
        }
    }
    else if (ar == ar) {
        ret = -1;
    }
    else {
        ret = 1;
    }

    return ret;
}

#undef LT


#line 3018

#define LT(a,b) ((a) < (b) || ((b) != (b) && (a) ==(a)))

static int
LONGDOUBLE_compare(npy_longdouble *pa, npy_longdouble *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_longdouble a = *pa;
    const npy_longdouble b = *pb;
    int ret;

    if (LT(a,b)) {
        ret = -1;
    }
    else if (LT(b,a)) {
        ret = 1;
    }
    else {
        ret = 0;
    }
    return ret;
}


static int
CLONGDOUBLE_compare(npy_longdouble *pa, npy_longdouble *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_longdouble ar = pa[0];
    const npy_longdouble ai = pa[1];
    const npy_longdouble br = pb[0];
    const npy_longdouble bi = pb[1];
    int ret;

    if (ar < br) {
        if (ai == ai || bi != bi) {
            ret = -1;
        }
        else {
            ret = 1;
        }
    }
    else if (br < ar) {
        if (bi == bi || ai != ai) {
            ret = 1;
        }
        else {
            ret = -1;
        }
    }
    else if (ar == br || (ar != ar && br != br)) {
        if (LT(ai,bi)) {
            ret = -1;
        }
        else if (LT(bi,ai)) {
            ret = 1;
        }
        else {
            ret = 0;
        }
    }
    else if (ar == ar) {
        ret = -1;
    }
    else {
        ret = 1;
    }

    return ret;
}

#undef LT



#line 3095

static int
DATETIME_compare(npy_datetime *pa, npy_datetime *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_datetime a = *pa;
    const npy_datetime b = *pb;
    int ret;

    if (a == NPY_DATETIME_NAT) {
        if (b == NPY_DATETIME_NAT) {
            ret = 0;
        }
        else {
            ret = 1;
        }
    }
    else if (b == NPY_DATETIME_NAT) {
        ret = -1;
    }
    else {
        ret = a < b ? -1 : a == b ? 0 : 1;
    }
    return ret;
}


#line 3095

static int
TIMEDELTA_compare(npy_timedelta *pa, npy_timedelta *pb, PyArrayObject *NPY_UNUSED(ap))
{
    const npy_timedelta a = *pa;
    const npy_timedelta b = *pb;
    int ret;

    if (a == NPY_DATETIME_NAT) {
        if (b == NPY_DATETIME_NAT) {
            ret = 0;
        }
        else {
            ret = 1;
        }
    }
    else if (b == NPY_DATETIME_NAT) {
        ret = -1;
    }
    else {
        ret = a < b ? -1 : a == b ? 0 : 1;
    }
    return ret;
}



static int
HALF_compare (npy_half *pa, npy_half *pb, PyArrayObject *NPY_UNUSED(ap))
{
    npy_half a = *pa, b = *pb;
    npy_bool a_isnan, b_isnan;
    int ret;

    a_isnan = npy_half_isnan(a);
    b_isnan = npy_half_isnan(b);

    if (a_isnan) {
        ret = b_isnan ? 0 : -1;
    }
    else if (b_isnan) {
        ret = 1;
    }
    else if(npy_half_lt_nonan(a, b)) {
        ret = -1;
    }
    else if(npy_half_lt_nonan(b, a)) {
        ret = 1;
    }
    else {
        ret = 0;
    }

    return ret;
}


/* object type */

static int
OBJECT_compare(PyObject **ip1, PyObject **ip2, PyArrayObject *NPY_UNUSED(ap))
{
    /*
     * ALIGNMENT NOTE: It seems that PyArray_Sort is already handling
     * the alignment of pointers, so it doesn't need to be handled
     * here.
     */

    int ret;
    /*
     * work around gh-3879, we cannot abort an in-progress quicksort
     * so at least do not raise again
     */
    if (PyErr_Occurred()) {
        return 0;
    }
    if ((*ip1 == NULL) || (*ip2 == NULL)) {
        if (ip1 == ip2) {
            return 1;
        }
        if (ip1 == NULL) {
            return -1;
        }
        return 1;
    }

    ret = PyObject_RichCompareBool(*ip1, *ip2, Py_LT);
    if (ret < 0) {
        /* error occurred, avoid the next call to PyObject_RichCompareBool */
        return 0;
    }
    if (ret == 1) {
        return -1;
    }
    else if (PyObject_RichCompareBool(*ip1, *ip2, Py_GT) == 1) {
        return 1;
    }
    else {
        return 0;
    }
}


/* string type */

static int
STRING_compare(char *ip1, char *ip2, PyArrayObject *ap)
{
    const unsigned char *c1 = (unsigned char *)ip1;
    const unsigned char *c2 = (unsigned char *)ip2;
    const size_t len = PyArray_DESCR(ap)->elsize;
    int i;

    i = memcmp(c1, c2, len);
    if (i > 0) {
        return 1;
    }
    else if (i < 0) {
        return -1;
    }
    return 0;
}


/* unicode type */

static int
UNICODE_compare(npy_ucs4 *ip1, npy_ucs4 *ip2,
                PyArrayObject *ap)
{
    int itemsize = PyArray_DESCR(ap)->elsize;

    if (itemsize < 0) {
        return 0;
    }
    itemsize /= sizeof(npy_ucs4);
    while (itemsize-- > 0) {
        npy_ucs4 c1 = *ip1++;
        npy_ucs4 c2 = *ip2++;
        if (c1 != c2) {
            return (c1 < c2) ? -1 : 1;
        }
    }
    return 0;
}


/* void type */

/*
 * If fields are defined, then compare on first field and if equal
 * compare on second field.  Continue until done or comparison results
 * in not_equal.
 *
 * Must align data passed on to sub-comparisons.
 * Also must swap data based on to sub-comparisons.
 */
static int
VOID_compare(char *ip1, char *ip2, PyArrayObject *ap)
{
    PyArray_Descr *descr;
    PyObject *names, *key;
    PyObject *tup;
    PyArrayObject_fields dummy_struct;
    PyArrayObject *dummy = (PyArrayObject *)&dummy_struct;
    char *nip1, *nip2;
    int i, res = 0, swap = 0;

    if (!PyArray_HASFIELDS(ap)) {
        return STRING_compare(ip1, ip2, ap);
    }
    PyObject *mem_handler = PyDataMem_GetHandler();
    if (mem_handler == NULL) {
        goto finish;
    }
    descr = PyArray_DESCR(ap);
    /*
     * Compare on the first-field.  If equal, then
     * compare on the second-field, etc.
     */
    names = descr->names;
    for (i = 0; i < PyTuple_GET_SIZE(names); i++) {
        PyArray_Descr *new;
        npy_intp offset;
        key = PyTuple_GET_ITEM(names, i);
        tup = PyDict_GetItem(descr->fields, key);
        if (_unpack_field(tup, &new, &offset) < 0) {
            goto finish;
        }
        /* Set the fields needed by compare or copyswap */
        dummy_struct.descr = new;

        swap = PyArray_ISBYTESWAPPED(dummy);
        nip1 = ip1 + offset;
        nip2 = ip2 + offset;
        if (swap || new->alignment > 1) {
            if (swap || !npy_is_aligned(nip1, new->alignment)) {
                /*
                 * create temporary buffer and copy,
                 * always use the current handler for internal allocations
                 */
                nip1 = PyDataMem_UserNEW(new->elsize, mem_handler);
                if (nip1 == NULL) {
                    goto finish;
                }
                memcpy(nip1, ip1 + offset, new->elsize);
                if (swap)
                    new->f->copyswap(nip1, NULL, swap, dummy);
            }
            if (swap || !npy_is_aligned(nip2, new->alignment)) {
                /*
                 * create temporary buffer and copy,
                 * always use the current handler for internal allocations
                 */
                nip2 = PyDataMem_UserNEW(new->elsize, mem_handler);
                if (nip2 == NULL) {
                    if (nip1 != ip1 + offset) {
                        /* destroy temporary buffer */
                        PyDataMem_UserFREE(nip1, new->elsize, mem_handler);
                    }
                    goto finish;
                }
                memcpy(nip2, ip2 + offset, new->elsize);
                if (swap)
                    new->f->copyswap(nip2, NULL, swap, dummy);
            }
        }
        res = new->f->compare(nip1, nip2, dummy);
        if (swap || new->alignment > 1) {
            if (nip1 != ip1 + offset) {
                /* destroy temporary buffer */
                PyDataMem_UserFREE(nip1, new->elsize, mem_handler);
            }
            if (nip2 != ip2 + offset) {
                /* destroy temporary buffer */
                PyDataMem_UserFREE(nip2, new->elsize, mem_handler);
            }
        }
        if (res != 0) {
            break;
        }
    }

finish:
    Py_XDECREF(mem_handler);
    return res;
}


/*
 *****************************************************************************
 **                                 ARGFUNC                                 **
 *****************************************************************************
 */

#define _LESS_THAN_OR_EQUAL(a,b) ((a) <= (b))

#line 3365
static int
HALF_argmax(npy_half *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_half mp = *ip;
#if 0
    npy_half mp_im = ip[1];
#endif

    *max_ind = 0;

#if 1
    if (npy_half_isnan(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (npy_half_isnan(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (mp == NPY_DATETIME_NAT) {
        /* NaT encountered, it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || npy_half_isnan(ip[0]) || npy_half_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (npy_half_isnan(mp) || npy_half_isnan(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
#if 0
        if (*ip == NPY_DATETIME_NAT) {
            /* NaT encountered, it's maximal */
            *max_ind = i;
            break;
        }
#endif
        if (!npy_half_le(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 1
            if (npy_half_isnan(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 3365
static int
CFLOAT_argmax(npy_float *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_float mp = *ip;
#if 1
    npy_float mp_im = ip[1];
#endif

    *max_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 1
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (mp == NPY_DATETIME_NAT) {
        /* NaT encountered, it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip+=2;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 1
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
#if 0
        if (*ip == NPY_DATETIME_NAT) {
            /* NaT encountered, it's maximal */
            *max_ind = i;
            break;
        }
#endif
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 3365
static int
CDOUBLE_argmax(npy_double *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_double mp = *ip;
#if 1
    npy_double mp_im = ip[1];
#endif

    *max_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 1
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (mp == NPY_DATETIME_NAT) {
        /* NaT encountered, it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip+=2;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 1
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
#if 0
        if (*ip == NPY_DATETIME_NAT) {
            /* NaT encountered, it's maximal */
            *max_ind = i;
            break;
        }
#endif
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 3365
static int
CLONGDOUBLE_argmax(npy_longdouble *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_longdouble mp = *ip;
#if 1
    npy_longdouble mp_im = ip[1];
#endif

    *max_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 1
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (mp == NPY_DATETIME_NAT) {
        /* NaT encountered, it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip+=2;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 1
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
#if 0
        if (*ip == NPY_DATETIME_NAT) {
            /* NaT encountered, it's maximal */
            *max_ind = i;
            break;
        }
#endif
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 3365
static int
DATETIME_argmax(npy_datetime *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_datetime mp = *ip;
#if 0
    npy_datetime mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 1
    if (mp == NPY_DATETIME_NAT) {
        /* NaT encountered, it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
#if 1
        if (*ip == NPY_DATETIME_NAT) {
            /* NaT encountered, it's maximal */
            *max_ind = i;
            break;
        }
#endif
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 3365
static int
TIMEDELTA_argmax(npy_timedelta *ip, npy_intp n, npy_intp *max_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_timedelta mp = *ip;
#if 0
    npy_timedelta mp_im = ip[1];
#endif

    *max_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's maximal */
        return 0;
    }
#endif
#if 1
    if (mp == NPY_DATETIME_NAT) {
        /* NaT encountered, it's maximal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((ip[0] > mp) || ((ip[0] == mp) && (ip[1] > mp_im))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *max_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's maximal */
                break;
            }
        }
#else
#if 1
        if (*ip == NPY_DATETIME_NAT) {
            /* NaT encountered, it's maximal */
            *max_ind = i;
            break;
        }
#endif
        if (!_LESS_THAN_OR_EQUAL(*ip, mp)) {  /* negated, for correct nan handling */
            mp = *ip;
            *max_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's maximal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}



static int
BOOL_argmin(npy_bool *ip, npy_intp n, npy_intp *min_ind,
            PyArrayObject *NPY_UNUSED(aip))

{
    npy_bool * p = memchr(ip, 0, n * sizeof(*ip));
    if (p == NULL) {
        *min_ind = 0;
        return 0;
    }
    *min_ind = p - ip;
    return 0;
}

#line 3465
static int
HALF_argmin(npy_half *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_half mp = *ip;
#if 0
    npy_half mp_im = ip[1];
#endif

    *min_ind = 0;

#if 1
    if (npy_half_isnan(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (npy_half_isnan(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (mp == NPY_DATETIME_NAT) {
        /* NaT encountered, it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || npy_half_isnan(ip[0]) || npy_half_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (npy_half_isnan(mp) || npy_half_isnan(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
#if 0
        if (*ip == NPY_DATETIME_NAT) {
            /* NaT encountered, it's minimal */
            *min_ind = i;
            break;
        }
#endif
        if (!npy_half_le(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 1
            if (npy_half_isnan(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 3465
static int
CFLOAT_argmin(npy_float *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_float mp = *ip;
#if 1
    npy_float mp_im = ip[1];
#endif

    *min_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 1
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (mp == NPY_DATETIME_NAT) {
        /* NaT encountered, it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip+=2;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 1
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
#if 0
        if (*ip == NPY_DATETIME_NAT) {
            /* NaT encountered, it's minimal */
            *min_ind = i;
            break;
        }
#endif
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 3465
static int
CDOUBLE_argmin(npy_double *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_double mp = *ip;
#if 1
    npy_double mp_im = ip[1];
#endif

    *min_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 1
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (mp == NPY_DATETIME_NAT) {
        /* NaT encountered, it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip+=2;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 1
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
#if 0
        if (*ip == NPY_DATETIME_NAT) {
            /* NaT encountered, it's minimal */
            *min_ind = i;
            break;
        }
#endif
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 3465
static int
CLONGDOUBLE_argmin(npy_longdouble *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_longdouble mp = *ip;
#if 1
    npy_longdouble mp_im = ip[1];
#endif

    *min_ind = 0;

#if 1
    if (npy_isnan(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 1
    if (npy_isnan(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (mp == NPY_DATETIME_NAT) {
        /* NaT encountered, it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip+=2;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 1
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || npy_isnan(ip[0]) || npy_isnan(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (npy_isnan(mp) || npy_isnan(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
#if 0
        if (*ip == NPY_DATETIME_NAT) {
            /* NaT encountered, it's minimal */
            *min_ind = i;
            break;
        }
#endif
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 1
            if (npy_isnan(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 3465
static int
DATETIME_argmin(npy_datetime *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_datetime mp = *ip;
#if 0
    npy_datetime mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 1
    if (mp == NPY_DATETIME_NAT) {
        /* NaT encountered, it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
#if 1
        if (*ip == NPY_DATETIME_NAT) {
            /* NaT encountered, it's minimal */
            *min_ind = i;
            break;
        }
#endif
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}


#line 3465
static int
TIMEDELTA_argmin(npy_timedelta *ip, npy_intp n, npy_intp *min_ind,
        PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;
    npy_timedelta mp = *ip;
#if 0
    npy_timedelta mp_im = ip[1];
#endif

    *min_ind = 0;

#if 0
    if (nop(mp)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 0
    if (nop(mp_im)) {
        /* nan encountered; it's minimal */
        return 0;
    }
#endif
#if 1
    if (mp == NPY_DATETIME_NAT) {
        /* NaT encountered, it's minimal */
        return 0;
    }
#endif

    for (i = 1; i < n; i++) {
        ip++;
        /*
         * Propagate nans, similarly as max() and min()
         */
#if 0
        /* Lexical order for complex numbers */
        if ((mp > ip[0]) || ((ip[0] == mp) && (mp_im > ip[1]))
                || nop(ip[0]) || nop(ip[1])) {
            mp = ip[0];
            mp_im = ip[1];
            *min_ind = i;
            if (nop(mp) || nop(mp_im)) {
                /* nan encountered, it's minimal */
                break;
            }
        }
#else
#if 1
        if (*ip == NPY_DATETIME_NAT) {
            /* NaT encountered, it's minimal */
            *min_ind = i;
            break;
        }
#endif
        if (!_LESS_THAN_OR_EQUAL(mp, *ip)) {  /* negated, for correct nan handling */
            mp = *ip;
            *min_ind = i;
#if 0
            if (nop(mp)) {
                /* nan encountered, it's minimal */
                break;
            }
#endif
        }
#endif
    }
    return 0;
}



#undef _LESS_THAN_OR_EQUAL

static int
OBJECT_argmax(PyObject **ip, npy_intp n, npy_intp *max_ind,
              PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;

    *max_ind = 0;
    /* Skip over all leading NULL entries */
    for (i = 0; i < n && ip[i] == NULL; ++i);
    if (i < n) {
        /* Found first non-NULL entry */
        PyObject *mp = ip[i];
        *max_ind = i;
        for (i = i + 1; i < n; ++i) {
            PyObject *val = ip[i];
            if (val != NULL) {
                int greater_than = PyObject_RichCompareBool(val, mp, Py_GT);

                if (greater_than < 0) {
                    return 0;
                }
                if (greater_than) {
                    mp = val;
                    *max_ind = i;
                }
            }
        }
    }

    return 0;
}

#line 3577
static int
STRING_argmax(npy_char *ip, npy_intp n, npy_intp *max_ind, PyArrayObject *aip)
{
    npy_intp i;
    int elsize = PyArray_DESCR(aip)->elsize;
    npy_char *mp = (npy_char *)PyArray_malloc(elsize);

    if (mp == NULL) {
        return 0;
    }
    memcpy(mp, ip, elsize);
    *max_ind = 0;
    for (i = 1; i < n; i++) {
        ip += elsize / sizeof(npy_char);
        if (STRING_compare(ip, mp, aip) > 0) {
            memcpy(mp, ip, elsize);
            *max_ind = i;
        }
    }
    PyArray_free(mp);
    return 0;
}


#line 3577
static int
UNICODE_argmax(npy_ucs4 *ip, npy_intp n, npy_intp *max_ind, PyArrayObject *aip)
{
    npy_intp i;
    int elsize = PyArray_DESCR(aip)->elsize;
    npy_ucs4 *mp = (npy_ucs4 *)PyArray_malloc(elsize);

    if (mp == NULL) {
        return 0;
    }
    memcpy(mp, ip, elsize);
    *max_ind = 0;
    for (i = 1; i < n; i++) {
        ip += elsize / sizeof(npy_ucs4);
        if (UNICODE_compare(ip, mp, aip) > 0) {
            memcpy(mp, ip, elsize);
            *max_ind = i;
        }
    }
    PyArray_free(mp);
    return 0;
}



#define VOID_argmax NULL

static int
OBJECT_argmin(PyObject **ip, npy_intp n, npy_intp *min_ind,
              PyArrayObject *NPY_UNUSED(aip))
{
    npy_intp i;

    *min_ind = 0;
    /* Skip over all leading NULL entries */
    for (i = 0; i < n && ip[i] == NULL; ++i);
    if (i < n) {
        /* Found first non-NULL entry */
        PyObject *mp = ip[i];
        *min_ind = i;
        for (i = i + 1; i < n ; ++i) {
            PyObject *val = ip[i];
            if (val != NULL) {
                int less_than = PyObject_RichCompareBool(val, mp, Py_LT);

                if (less_than < 0) {
                    return 0;
                }
                if (less_than) {
                    mp = val;
                    *min_ind = i;
                }
            }
        }
    }

    return 0;
}

#line 3641
static int
STRING_argmin(npy_char *ip, npy_intp n, npy_intp *min_ind, PyArrayObject *aip)
{
    npy_intp i;
    int elsize = PyArray_DESCR(aip)->elsize;
    npy_char *mp = (npy_char *)PyArray_malloc(elsize);

    if (mp==NULL) return 0;
    memcpy(mp, ip, elsize);
    *min_ind = 0;
    for(i=1; i<n; i++) {
        ip += elsize / sizeof(npy_char);
        if (STRING_compare(mp,ip,aip) > 0) {
            memcpy(mp, ip, elsize);
            *min_ind=i;
        }
    }
    PyArray_free(mp);
    return 0;
}


#line 3641
static int
UNICODE_argmin(npy_ucs4 *ip, npy_intp n, npy_intp *min_ind, PyArrayObject *aip)
{
    npy_intp i;
    int elsize = PyArray_DESCR(aip)->elsize;
    npy_ucs4 *mp = (npy_ucs4 *)PyArray_malloc(elsize);

    if (mp==NULL) return 0;
    memcpy(mp, ip, elsize);
    *min_ind = 0;
    for(i=1; i<n; i++) {
        ip += elsize / sizeof(npy_ucs4);
        if (UNICODE_compare(mp,ip,aip) > 0) {
            memcpy(mp, ip, elsize);
            *min_ind=i;
        }
    }
    PyArray_free(mp);
    return 0;
}




#define VOID_argmin NULL


/*
 *****************************************************************************
 **                                  DOT                                    **
 *****************************************************************************
 */

/*
 * dot means inner product
 */

/************************** MAYBE USE CBLAS *********************************/


#line 3687
NPY_NO_EXPORT void
FLOAT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op,
           npy_intp n, void *NPY_UNUSED(ignore))
{
#if defined(HAVE_CBLAS)
    CBLAS_INT is1b = blas_stride(is1, sizeof(npy_float));
    CBLAS_INT is2b = blas_stride(is2, sizeof(npy_float));

    if (is1b && is2b)
    {
        double sum = 0.;  /* double for stability */

        while (n > 0) {
            CBLAS_INT chunk = n < NPY_CBLAS_CHUNK ? n : NPY_CBLAS_CHUNK;

            sum += CBLAS_FUNC(cblas_sdot)(chunk,
                                     (npy_float *) ip1, is1b,
                                     (npy_float *) ip2, is2b);
            /* use char strides here */
            ip1 += chunk * is1;
            ip2 += chunk * is2;
            n -= chunk;
        }
        *((npy_float *)op) = (npy_float)sum;
    }
    else
#endif
    {
        npy_float sum = (npy_float)0;  /* could make this double */
        npy_intp i;

        for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
            const npy_float ip1r = *((npy_float *)ip1);
            const npy_float ip2r = *((npy_float *)ip2);

            sum += ip1r * ip2r;
        }
        *((npy_float *)op) = sum;
    }
}

#line 3687
NPY_NO_EXPORT void
DOUBLE_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op,
           npy_intp n, void *NPY_UNUSED(ignore))
{
#if defined(HAVE_CBLAS)
    CBLAS_INT is1b = blas_stride(is1, sizeof(npy_double));
    CBLAS_INT is2b = blas_stride(is2, sizeof(npy_double));

    if (is1b && is2b)
    {
        double sum = 0.;  /* double for stability */

        while (n > 0) {
            CBLAS_INT chunk = n < NPY_CBLAS_CHUNK ? n : NPY_CBLAS_CHUNK;

            sum += CBLAS_FUNC(cblas_ddot)(chunk,
                                     (npy_double *) ip1, is1b,
                                     (npy_double *) ip2, is2b);
            /* use char strides here */
            ip1 += chunk * is1;
            ip2 += chunk * is2;
            n -= chunk;
        }
        *((npy_double *)op) = (npy_double)sum;
    }
    else
#endif
    {
        npy_double sum = (npy_double)0;  /* could make this double */
        npy_intp i;

        for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
            const npy_double ip1r = *((npy_double *)ip1);
            const npy_double ip2r = *((npy_double *)ip2);

            sum += ip1r * ip2r;
        }
        *((npy_double *)op) = sum;
    }
}


#line 3736
NPY_NO_EXPORT void
CFLOAT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2,
           char *op, npy_intp n, void *NPY_UNUSED(ignore))
{
#if defined(HAVE_CBLAS)
    CBLAS_INT is1b = blas_stride(is1, sizeof(npy_cfloat));
    CBLAS_INT is2b = blas_stride(is2, sizeof(npy_cfloat));

    if (is1b && is2b) {
        double sum[2] = {0., 0.};  /* double for stability */

        while (n > 0) {
            CBLAS_INT chunk = n < NPY_CBLAS_CHUNK ? n : NPY_CBLAS_CHUNK;
            npy_float tmp[2];

            CBLAS_FUNC(cblas_cdotu_sub)(
                    (CBLAS_INT)chunk, ip1, is1b, ip2, is2b, tmp);
            sum[0] += (double)tmp[0];
            sum[1] += (double)tmp[1];
            /* use char strides here */
            ip1 += chunk * is1;
            ip2 += chunk * is2;
            n -= chunk;
        }
        ((npy_float *)op)[0] = (npy_float)sum[0];
        ((npy_float *)op)[1] = (npy_float)sum[1];
    }
    else
#endif
    {
        npy_float sumr = (npy_float)0.0;
        npy_float sumi = (npy_float)0.0;
        npy_intp i;

        for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
            const npy_float ip1r = ((npy_float *)ip1)[0];
            const npy_float ip1i = ((npy_float *)ip1)[1];
            const npy_float ip2r = ((npy_float *)ip2)[0];
            const npy_float ip2i = ((npy_float *)ip2)[1];

            sumr += ip1r * ip2r - ip1i * ip2i;
            sumi += ip1r * ip2i + ip1i * ip2r;
        }
        ((npy_float *)op)[0] = sumr;
        ((npy_float *)op)[1] = sumi;
    }
}


#line 3736
NPY_NO_EXPORT void
CDOUBLE_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2,
           char *op, npy_intp n, void *NPY_UNUSED(ignore))
{
#if defined(HAVE_CBLAS)
    CBLAS_INT is1b = blas_stride(is1, sizeof(npy_cdouble));
    CBLAS_INT is2b = blas_stride(is2, sizeof(npy_cdouble));

    if (is1b && is2b) {
        double sum[2] = {0., 0.};  /* double for stability */

        while (n > 0) {
            CBLAS_INT chunk = n < NPY_CBLAS_CHUNK ? n : NPY_CBLAS_CHUNK;
            npy_double tmp[2];

            CBLAS_FUNC(cblas_zdotu_sub)(
                    (CBLAS_INT)chunk, ip1, is1b, ip2, is2b, tmp);
            sum[0] += (double)tmp[0];
            sum[1] += (double)tmp[1];
            /* use char strides here */
            ip1 += chunk * is1;
            ip2 += chunk * is2;
            n -= chunk;
        }
        ((npy_double *)op)[0] = (npy_double)sum[0];
        ((npy_double *)op)[1] = (npy_double)sum[1];
    }
    else
#endif
    {
        npy_double sumr = (npy_double)0.0;
        npy_double sumi = (npy_double)0.0;
        npy_intp i;

        for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
            const npy_double ip1r = ((npy_double *)ip1)[0];
            const npy_double ip1i = ((npy_double *)ip1)[1];
            const npy_double ip2r = ((npy_double *)ip2)[0];
            const npy_double ip2i = ((npy_double *)ip2)[1];

            sumr += ip1r * ip2r - ip1i * ip2i;
            sumi += ip1r * ip2i + ip1i * ip2r;
        }
        ((npy_double *)op)[0] = sumr;
        ((npy_double *)op)[1] = sumi;
    }
}



/**************************** NO CBLAS VERSIONS *****************************/

static void
BOOL_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
         void *NPY_UNUSED(ignore))
{
    npy_bool tmp = NPY_FALSE;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        if ((*((npy_bool *)ip1) != 0) && (*((npy_bool *)ip2) != 0)) {
            tmp = NPY_TRUE;
            break;
        }
    }
    *((npy_bool *)op) = tmp;
}

/*
 * `dot` does not make sense for times, for DATETIME it never worked.
 *  For timedelta it does/did , but should probably also just be removed.
 */
#define DATETIME_dot NULL

#line 3822
static void
BYTE_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_long tmp = (npy_long)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_long)(*((npy_byte *)ip1)) *
               (npy_long)(*((npy_byte *)ip2));
    }
    *((npy_byte *)op) = (npy_byte) tmp;
}

#line 3822
static void
UBYTE_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_ulong tmp = (npy_ulong)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_ulong)(*((npy_ubyte *)ip1)) *
               (npy_ulong)(*((npy_ubyte *)ip2));
    }
    *((npy_ubyte *)op) = (npy_ubyte) tmp;
}

#line 3822
static void
SHORT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_long tmp = (npy_long)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_long)(*((npy_short *)ip1)) *
               (npy_long)(*((npy_short *)ip2));
    }
    *((npy_short *)op) = (npy_short) tmp;
}

#line 3822
static void
USHORT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_ulong tmp = (npy_ulong)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_ulong)(*((npy_ushort *)ip1)) *
               (npy_ulong)(*((npy_ushort *)ip2));
    }
    *((npy_ushort *)op) = (npy_ushort) tmp;
}

#line 3822
static void
INT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_long tmp = (npy_long)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_long)(*((npy_int *)ip1)) *
               (npy_long)(*((npy_int *)ip2));
    }
    *((npy_int *)op) = (npy_int) tmp;
}

#line 3822
static void
UINT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_ulong tmp = (npy_ulong)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_ulong)(*((npy_uint *)ip1)) *
               (npy_ulong)(*((npy_uint *)ip2));
    }
    *((npy_uint *)op) = (npy_uint) tmp;
}

#line 3822
static void
LONG_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_long tmp = (npy_long)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_long)(*((npy_long *)ip1)) *
               (npy_long)(*((npy_long *)ip2));
    }
    *((npy_long *)op) = (npy_long) tmp;
}

#line 3822
static void
ULONG_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_ulong tmp = (npy_ulong)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_ulong)(*((npy_ulong *)ip1)) *
               (npy_ulong)(*((npy_ulong *)ip2));
    }
    *((npy_ulong *)op) = (npy_ulong) tmp;
}

#line 3822
static void
LONGLONG_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_longlong tmp = (npy_longlong)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_longlong)(*((npy_longlong *)ip1)) *
               (npy_longlong)(*((npy_longlong *)ip2));
    }
    *((npy_longlong *)op) = (npy_longlong) tmp;
}

#line 3822
static void
ULONGLONG_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_ulonglong tmp = (npy_ulonglong)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_ulonglong)(*((npy_ulonglong *)ip1)) *
               (npy_ulonglong)(*((npy_ulonglong *)ip2));
    }
    *((npy_ulonglong *)op) = (npy_ulonglong) tmp;
}

#line 3822
static void
LONGDOUBLE_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_longdouble tmp = (npy_longdouble)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_longdouble)(*((npy_longdouble *)ip1)) *
               (npy_longdouble)(*((npy_longdouble *)ip2));
    }
    *((npy_longdouble *)op) = (npy_longdouble) tmp;
}

#line 3822
static void
TIMEDELTA_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    npy_timedelta tmp = (npy_timedelta)0;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += (npy_timedelta)(*((npy_timedelta *)ip1)) *
               (npy_timedelta)(*((npy_timedelta *)ip2));
    }
    *((npy_timedelta *)op) = (npy_timedelta) tmp;
}


static void
HALF_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op,
         npy_intp n, void *NPY_UNUSED(ignore))
{
    float tmp = 0.0f;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        tmp += npy_half_to_float(*((npy_half *)ip1)) *
               npy_half_to_float(*((npy_half *)ip2));
    }
    *((npy_half *)op) = npy_float_to_half(tmp);
}

static void
CLONGDOUBLE_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2,
                            char *op, npy_intp n, void *NPY_UNUSED(ignore))
{
    npy_longdouble tmpr = 0.0L;
    npy_longdouble tmpi = 0.0L;
    npy_intp i;

    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        const npy_longdouble ip1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble ip1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble ip2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble ip2i = ((npy_longdouble *)ip2)[1];

        tmpr += ip1r * ip2r - ip1i * ip2i;
        tmpi += ip1r * ip2i + ip1i * ip2r;
    }
    ((npy_longdouble *)op)[0] = tmpr;
    ((npy_longdouble *)op)[1] = tmpi;
}

static void
OBJECT_dot(char *ip1, npy_intp is1, char *ip2, npy_intp is2, char *op, npy_intp n,
           void *NPY_UNUSED(ignore))
{
    /*
     * ALIGNMENT NOTE: np.dot, np.inner etc. enforce that the array is
     * BEHAVED before getting to this point, so unaligned pointers aren't
     * handled here.
     */
    npy_intp i;
    PyObject *tmp1, *tmp2, *tmp = NULL;
    PyObject **tmp3;
    for (i = 0; i < n; i++, ip1 += is1, ip2 += is2) {
        if ((*((PyObject **)ip1) == NULL) || (*((PyObject **)ip2) == NULL)) {
            tmp1 = Py_False;
            Py_INCREF(Py_False);
        }
        else {
            tmp1 = PyNumber_Multiply(*((PyObject **)ip1), *((PyObject **)ip2));
            if (!tmp1) {
                Py_XDECREF(tmp);
                return;
            }
        }
        if (i == 0) {
            tmp = tmp1;
        }
        else {
            tmp2 = PyNumber_Add(tmp, tmp1);
            Py_XDECREF(tmp);
            Py_XDECREF(tmp1);
            if (!tmp2) {
                return;
            }
            tmp = tmp2;
        }
    }
    tmp3 = (PyObject**) op;
    tmp2 = *tmp3;
    *((PyObject **)op) = tmp;
    Py_XDECREF(tmp2);
}


/*
 *****************************************************************************
 **                                 FILL                                    **
 *****************************************************************************
 */


/* Boolean fill never works, but define it so that it works up to length 2 */
static int
BOOL_fill(PyObject **buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    NPY_ALLOW_C_API_DEF;
    NPY_ALLOW_C_API;
    PyErr_SetString(PyExc_TypeError,
            "arange() is only supported for booleans when the result has at "
            "most length 2.");
    NPY_DISABLE_C_API;
    return -1;
}

/* this requires buffer to be filled with objects or NULL */
static int
OBJECT_fill(PyObject **buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    int retval = 0;
    npy_intp i;
    PyObject *start = buffer[0];
    PyObject *delta = buffer[1];
    PyObject *second;

    delta = PyNumber_Subtract(delta, start);
    if (!delta) {
        return -1;
    }
    second = start = PyNumber_Add(start, delta);
    if (!start) {
        goto error;
    }
    buffer += 2;

    for (i = 2; i < length; i++, buffer++) {
        start = PyNumber_Add(start, delta);
        if (!start) {
            goto error;
        }
        Py_XDECREF(*buffer);
        *buffer = start;
    }
    goto finish;

error:
    retval = -1;

finish:
    Py_XDECREF(second);
    Py_DECREF(delta);
    return retval;
}

#line 3986
static int
BYTE_fill(npy_byte *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_byte start = buffer[0];
    npy_byte delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
UBYTE_fill(npy_ubyte *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ubyte start = buffer[0];
    npy_ubyte delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
SHORT_fill(npy_short *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_short start = buffer[0];
    npy_short delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
USHORT_fill(npy_ushort *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ushort start = buffer[0];
    npy_ushort delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
INT_fill(npy_int *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_int start = buffer[0];
    npy_int delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
UINT_fill(npy_uint *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_uint start = buffer[0];
    npy_uint delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
LONG_fill(npy_long *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_long start = buffer[0];
    npy_long delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
ULONG_fill(npy_ulong *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ulong start = buffer[0];
    npy_ulong delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
LONGLONG_fill(npy_longlong *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_longlong start = buffer[0];
    npy_longlong delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
ULONGLONG_fill(npy_ulonglong *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ulonglong start = buffer[0];
    npy_ulonglong delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
FLOAT_fill(npy_float *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_float start = buffer[0];
    npy_float delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
DOUBLE_fill(npy_double *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_double start = buffer[0];
    npy_double delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
LONGDOUBLE_fill(npy_longdouble *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_longdouble start = buffer[0];
    npy_longdouble delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
DATETIME_fill(npy_datetime *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_datetime start = buffer[0];
    npy_datetime delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}

#line 3986
static int
TIMEDELTA_fill(npy_timedelta *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_timedelta start = buffer[0];
    npy_timedelta delta = buffer[1];

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = start + i*delta;
    }
    return 0;
}


static int
HALF_fill(npy_half *buffer, npy_intp length, void *NPY_UNUSED(ignored))
{
    npy_intp i;
    float start = npy_half_to_float(buffer[0]);
    float delta = npy_half_to_float(buffer[1]);

    delta -= start;
    for (i = 2; i < length; ++i) {
        buffer[i] = npy_float_to_half(start + i*delta);
    }
    return 0;
}

#line 4020
static int
CFLOAT_fill(npy_cfloat *buffer, npy_intp length, void *NPY_UNUSED(ignore))
{
    npy_intp i;
    npy_cfloat start;
    npy_cfloat delta;

    start.real = buffer->real;
    start.imag = buffer->imag;
    delta.real = buffer[1].real;
    delta.imag = buffer[1].imag;
    delta.real -= start.real;
    delta.imag -= start.imag;
    buffer += 2;
    for (i = 2; i < length; i++, buffer++) {
        buffer->real = start.real + i*delta.real;
        buffer->imag = start.imag + i*delta.imag;
    }
    return 0;
}

#line 4020
static int
CDOUBLE_fill(npy_cdouble *buffer, npy_intp length, void *NPY_UNUSED(ignore))
{
    npy_intp i;
    npy_cdouble start;
    npy_cdouble delta;

    start.real = buffer->real;
    start.imag = buffer->imag;
    delta.real = buffer[1].real;
    delta.imag = buffer[1].imag;
    delta.real -= start.real;
    delta.imag -= start.imag;
    buffer += 2;
    for (i = 2; i < length; i++, buffer++) {
        buffer->real = start.real + i*delta.real;
        buffer->imag = start.imag + i*delta.imag;
    }
    return 0;
}

#line 4020
static int
CLONGDOUBLE_fill(npy_clongdouble *buffer, npy_intp length, void *NPY_UNUSED(ignore))
{
    npy_intp i;
    npy_clongdouble start;
    npy_clongdouble delta;

    start.real = buffer->real;
    start.imag = buffer->imag;
    delta.real = buffer[1].real;
    delta.imag = buffer[1].imag;
    delta.real -= start.real;
    delta.imag -= start.imag;
    buffer += 2;
    for (i = 2; i < length; i++, buffer++) {
        buffer->real = start.real + i*delta.real;
        buffer->imag = start.imag + i*delta.imag;
    }
    return 0;
}



/* this requires buffer to be filled with objects or NULL */
static void
OBJECT_fillwithscalar(PyObject **buffer, npy_intp length, PyObject **value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    PyObject *val = *value;
    for (i = 0; i < length; i++) {
        Py_XINCREF(val);
        Py_XDECREF(buffer[i]);
        buffer[i] = val;
    }
}
#line 4061
static void
BOOL_fillwithscalar(npy_bool *buffer, npy_intp length, npy_bool *value,
        void *NPY_UNUSED(ignored))
{
    memset(buffer, *value, length);
}

#line 4061
static void
BYTE_fillwithscalar(npy_byte *buffer, npy_intp length, npy_byte *value,
        void *NPY_UNUSED(ignored))
{
    memset(buffer, *value, length);
}

#line 4061
static void
UBYTE_fillwithscalar(npy_ubyte *buffer, npy_intp length, npy_ubyte *value,
        void *NPY_UNUSED(ignored))
{
    memset(buffer, *value, length);
}


#line 4082
static void
SHORT_fillwithscalar(npy_short *buffer, npy_intp length, npy_short *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_short val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
USHORT_fillwithscalar(npy_ushort *buffer, npy_intp length, npy_ushort *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ushort val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
INT_fillwithscalar(npy_int *buffer, npy_intp length, npy_int *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_int val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
UINT_fillwithscalar(npy_uint *buffer, npy_intp length, npy_uint *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_uint val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
LONG_fillwithscalar(npy_long *buffer, npy_intp length, npy_long *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_long val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
ULONG_fillwithscalar(npy_ulong *buffer, npy_intp length, npy_ulong *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ulong val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
LONGLONG_fillwithscalar(npy_longlong *buffer, npy_intp length, npy_longlong *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_longlong val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
ULONGLONG_fillwithscalar(npy_ulonglong *buffer, npy_intp length, npy_ulonglong *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_ulonglong val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
HALF_fillwithscalar(npy_half *buffer, npy_intp length, npy_half *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_half val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
FLOAT_fillwithscalar(npy_float *buffer, npy_intp length, npy_float *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_float val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
DOUBLE_fillwithscalar(npy_double *buffer, npy_intp length, npy_double *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_double val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
LONGDOUBLE_fillwithscalar(npy_longdouble *buffer, npy_intp length, npy_longdouble *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_longdouble val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
CFLOAT_fillwithscalar(npy_cfloat *buffer, npy_intp length, npy_cfloat *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_cfloat val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
CDOUBLE_fillwithscalar(npy_cdouble *buffer, npy_intp length, npy_cdouble *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_cdouble val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
CLONGDOUBLE_fillwithscalar(npy_clongdouble *buffer, npy_intp length, npy_clongdouble *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_clongdouble val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
DATETIME_fillwithscalar(npy_datetime *buffer, npy_intp length, npy_datetime *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_datetime val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}

#line 4082
static void
TIMEDELTA_fillwithscalar(npy_timedelta *buffer, npy_intp length, npy_timedelta *value,
        void *NPY_UNUSED(ignored))
{
    npy_intp i;
    npy_timedelta val = *value;

    for (i = 0; i < length; ++i) {
        buffer[i] = val;
    }
}



/*
 *****************************************************************************
 **                       small correlate                                   **
 *****************************************************************************
 */

/*
 * Compute correlation of data with small kernels
 * Calling a BLAS dot product for the inner loop of the correlation is overkill
 * for small kernels. It is faster to compute it directly.
 * Intended to be used by _pyarray_correlate so no input verifications is done
 * especially it does not handle the boundaries, they should be handled by the
 * caller.
 * Returns 0 if kernel is considered too large or types are not supported, then
 * the regular array dot should be used to process the data.
 *
 * d_, dstride, nd, dtype: data pointer, its stride in bytes, number of
 *                         elements and type of data
 * k_, kstride, nk, ktype: kernel pointer, its stride in bytes, number of
 *                         elements and type of data
 * out_, ostride: output data pointer and its stride in bytes
 */
NPY_NO_EXPORT int
small_correlate(const char * d_, npy_intp dstride,
                npy_intp nd, enum NPY_TYPES dtype,
                const char * k_, npy_intp kstride,
                npy_intp nk, enum NPY_TYPES ktype,
                char * out_, npy_intp ostride)
{
    /* only handle small kernels and uniform types */
    if (nk > 11 || dtype != ktype) {
        return 0;
    }

    switch (dtype) {
#line 4136
        case NPY_FLOAT:
            {
                npy_intp i;
                const npy_float * d = (npy_float*)d_;
                const npy_float * k = (npy_float*)k_;
                npy_float * out = (npy_float*)out_;
                dstride /= sizeof(npy_float);
                kstride /= sizeof(npy_float);
                ostride /= sizeof(npy_float);
                /* unroll inner loop to optimize register usage of the kernel*/
                switch (nk) {
#line 4149
                    case 1:
                    {
#line 4153
#if 1 <= 1
                        /* load kernel */
                        const npy_float k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 1
                        /* load kernel */
                        const npy_float k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 1
                        /* load kernel */
                        const npy_float k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 1
                        /* load kernel */
                        const npy_float k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 1
                        /* load kernel */
                        const npy_float k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 1
                        /* load kernel */
                        const npy_float k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 1
                        /* load kernel */
                        const npy_float k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 1
                        /* load kernel */
                        const npy_float k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 1
                        /* load kernel */
                        const npy_float k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 1
                        /* load kernel */
                        const npy_float k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 1
                        /* load kernel */
                        const npy_float k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_float s = 0;
#line 4162
#if 1 <= 1
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 1
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 1
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 1
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 1
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 1
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 1
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 1
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 1
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 1
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 1
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 2:
                    {
#line 4153
#if 1 <= 2
                        /* load kernel */
                        const npy_float k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 2
                        /* load kernel */
                        const npy_float k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 2
                        /* load kernel */
                        const npy_float k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 2
                        /* load kernel */
                        const npy_float k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 2
                        /* load kernel */
                        const npy_float k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 2
                        /* load kernel */
                        const npy_float k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 2
                        /* load kernel */
                        const npy_float k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 2
                        /* load kernel */
                        const npy_float k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 2
                        /* load kernel */
                        const npy_float k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 2
                        /* load kernel */
                        const npy_float k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 2
                        /* load kernel */
                        const npy_float k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_float s = 0;
#line 4162
#if 1 <= 2
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 2
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 2
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 2
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 2
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 2
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 2
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 2
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 2
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 2
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 2
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 3:
                    {
#line 4153
#if 1 <= 3
                        /* load kernel */
                        const npy_float k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 3
                        /* load kernel */
                        const npy_float k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 3
                        /* load kernel */
                        const npy_float k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 3
                        /* load kernel */
                        const npy_float k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 3
                        /* load kernel */
                        const npy_float k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 3
                        /* load kernel */
                        const npy_float k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 3
                        /* load kernel */
                        const npy_float k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 3
                        /* load kernel */
                        const npy_float k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 3
                        /* load kernel */
                        const npy_float k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 3
                        /* load kernel */
                        const npy_float k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 3
                        /* load kernel */
                        const npy_float k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_float s = 0;
#line 4162
#if 1 <= 3
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 3
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 3
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 3
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 3
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 3
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 3
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 3
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 3
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 3
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 3
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 4:
                    {
#line 4153
#if 1 <= 4
                        /* load kernel */
                        const npy_float k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 4
                        /* load kernel */
                        const npy_float k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 4
                        /* load kernel */
                        const npy_float k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 4
                        /* load kernel */
                        const npy_float k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 4
                        /* load kernel */
                        const npy_float k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 4
                        /* load kernel */
                        const npy_float k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 4
                        /* load kernel */
                        const npy_float k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 4
                        /* load kernel */
                        const npy_float k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 4
                        /* load kernel */
                        const npy_float k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 4
                        /* load kernel */
                        const npy_float k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 4
                        /* load kernel */
                        const npy_float k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_float s = 0;
#line 4162
#if 1 <= 4
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 4
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 4
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 4
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 4
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 4
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 4
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 4
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 4
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 4
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 4
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 5:
                    {
#line 4153
#if 1 <= 5
                        /* load kernel */
                        const npy_float k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 5
                        /* load kernel */
                        const npy_float k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 5
                        /* load kernel */
                        const npy_float k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 5
                        /* load kernel */
                        const npy_float k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 5
                        /* load kernel */
                        const npy_float k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 5
                        /* load kernel */
                        const npy_float k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 5
                        /* load kernel */
                        const npy_float k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 5
                        /* load kernel */
                        const npy_float k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 5
                        /* load kernel */
                        const npy_float k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 5
                        /* load kernel */
                        const npy_float k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 5
                        /* load kernel */
                        const npy_float k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_float s = 0;
#line 4162
#if 1 <= 5
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 5
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 5
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 5
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 5
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 5
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 5
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 5
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 5
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 5
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 5
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 6:
                    {
#line 4153
#if 1 <= 6
                        /* load kernel */
                        const npy_float k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 6
                        /* load kernel */
                        const npy_float k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 6
                        /* load kernel */
                        const npy_float k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 6
                        /* load kernel */
                        const npy_float k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 6
                        /* load kernel */
                        const npy_float k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 6
                        /* load kernel */
                        const npy_float k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 6
                        /* load kernel */
                        const npy_float k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 6
                        /* load kernel */
                        const npy_float k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 6
                        /* load kernel */
                        const npy_float k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 6
                        /* load kernel */
                        const npy_float k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 6
                        /* load kernel */
                        const npy_float k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_float s = 0;
#line 4162
#if 1 <= 6
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 6
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 6
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 6
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 6
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 6
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 6
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 6
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 6
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 6
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 6
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 7:
                    {
#line 4153
#if 1 <= 7
                        /* load kernel */
                        const npy_float k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 7
                        /* load kernel */
                        const npy_float k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 7
                        /* load kernel */
                        const npy_float k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 7
                        /* load kernel */
                        const npy_float k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 7
                        /* load kernel */
                        const npy_float k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 7
                        /* load kernel */
                        const npy_float k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 7
                        /* load kernel */
                        const npy_float k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 7
                        /* load kernel */
                        const npy_float k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 7
                        /* load kernel */
                        const npy_float k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 7
                        /* load kernel */
                        const npy_float k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 7
                        /* load kernel */
                        const npy_float k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_float s = 0;
#line 4162
#if 1 <= 7
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 7
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 7
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 7
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 7
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 7
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 7
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 7
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 7
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 7
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 7
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 8:
                    {
#line 4153
#if 1 <= 8
                        /* load kernel */
                        const npy_float k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 8
                        /* load kernel */
                        const npy_float k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 8
                        /* load kernel */
                        const npy_float k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 8
                        /* load kernel */
                        const npy_float k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 8
                        /* load kernel */
                        const npy_float k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 8
                        /* load kernel */
                        const npy_float k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 8
                        /* load kernel */
                        const npy_float k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 8
                        /* load kernel */
                        const npy_float k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 8
                        /* load kernel */
                        const npy_float k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 8
                        /* load kernel */
                        const npy_float k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 8
                        /* load kernel */
                        const npy_float k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_float s = 0;
#line 4162
#if 1 <= 8
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 8
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 8
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 8
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 8
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 8
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 8
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 8
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 8
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 8
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 8
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 9:
                    {
#line 4153
#if 1 <= 9
                        /* load kernel */
                        const npy_float k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 9
                        /* load kernel */
                        const npy_float k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 9
                        /* load kernel */
                        const npy_float k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 9
                        /* load kernel */
                        const npy_float k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 9
                        /* load kernel */
                        const npy_float k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 9
                        /* load kernel */
                        const npy_float k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 9
                        /* load kernel */
                        const npy_float k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 9
                        /* load kernel */
                        const npy_float k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 9
                        /* load kernel */
                        const npy_float k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 9
                        /* load kernel */
                        const npy_float k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 9
                        /* load kernel */
                        const npy_float k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_float s = 0;
#line 4162
#if 1 <= 9
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 9
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 9
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 9
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 9
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 9
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 9
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 9
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 9
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 9
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 9
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 10:
                    {
#line 4153
#if 1 <= 10
                        /* load kernel */
                        const npy_float k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 10
                        /* load kernel */
                        const npy_float k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 10
                        /* load kernel */
                        const npy_float k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 10
                        /* load kernel */
                        const npy_float k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 10
                        /* load kernel */
                        const npy_float k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 10
                        /* load kernel */
                        const npy_float k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 10
                        /* load kernel */
                        const npy_float k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 10
                        /* load kernel */
                        const npy_float k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 10
                        /* load kernel */
                        const npy_float k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 10
                        /* load kernel */
                        const npy_float k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 10
                        /* load kernel */
                        const npy_float k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_float s = 0;
#line 4162
#if 1 <= 10
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 10
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 10
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 10
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 10
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 10
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 10
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 10
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 10
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 10
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 10
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 11:
                    {
#line 4153
#if 1 <= 11
                        /* load kernel */
                        const npy_float k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 11
                        /* load kernel */
                        const npy_float k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 11
                        /* load kernel */
                        const npy_float k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 11
                        /* load kernel */
                        const npy_float k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 11
                        /* load kernel */
                        const npy_float k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 11
                        /* load kernel */
                        const npy_float k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 11
                        /* load kernel */
                        const npy_float k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 11
                        /* load kernel */
                        const npy_float k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 11
                        /* load kernel */
                        const npy_float k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 11
                        /* load kernel */
                        const npy_float k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 11
                        /* load kernel */
                        const npy_float k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_float s = 0;
#line 4162
#if 1 <= 11
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 11
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 11
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 11
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 11
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 11
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 11
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 11
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 11
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 11
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 11
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

                    default:
                        return 0;
                }
            }

#line 4136
        case NPY_DOUBLE:
            {
                npy_intp i;
                const npy_double * d = (npy_double*)d_;
                const npy_double * k = (npy_double*)k_;
                npy_double * out = (npy_double*)out_;
                dstride /= sizeof(npy_double);
                kstride /= sizeof(npy_double);
                ostride /= sizeof(npy_double);
                /* unroll inner loop to optimize register usage of the kernel*/
                switch (nk) {
#line 4149
                    case 1:
                    {
#line 4153
#if 1 <= 1
                        /* load kernel */
                        const npy_double k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 1
                        /* load kernel */
                        const npy_double k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 1
                        /* load kernel */
                        const npy_double k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 1
                        /* load kernel */
                        const npy_double k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 1
                        /* load kernel */
                        const npy_double k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 1
                        /* load kernel */
                        const npy_double k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 1
                        /* load kernel */
                        const npy_double k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 1
                        /* load kernel */
                        const npy_double k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 1
                        /* load kernel */
                        const npy_double k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 1
                        /* load kernel */
                        const npy_double k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 1
                        /* load kernel */
                        const npy_double k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_double s = 0;
#line 4162
#if 1 <= 1
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 1
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 1
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 1
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 1
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 1
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 1
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 1
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 1
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 1
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 1
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 2:
                    {
#line 4153
#if 1 <= 2
                        /* load kernel */
                        const npy_double k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 2
                        /* load kernel */
                        const npy_double k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 2
                        /* load kernel */
                        const npy_double k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 2
                        /* load kernel */
                        const npy_double k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 2
                        /* load kernel */
                        const npy_double k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 2
                        /* load kernel */
                        const npy_double k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 2
                        /* load kernel */
                        const npy_double k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 2
                        /* load kernel */
                        const npy_double k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 2
                        /* load kernel */
                        const npy_double k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 2
                        /* load kernel */
                        const npy_double k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 2
                        /* load kernel */
                        const npy_double k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_double s = 0;
#line 4162
#if 1 <= 2
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 2
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 2
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 2
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 2
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 2
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 2
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 2
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 2
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 2
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 2
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 3:
                    {
#line 4153
#if 1 <= 3
                        /* load kernel */
                        const npy_double k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 3
                        /* load kernel */
                        const npy_double k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 3
                        /* load kernel */
                        const npy_double k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 3
                        /* load kernel */
                        const npy_double k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 3
                        /* load kernel */
                        const npy_double k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 3
                        /* load kernel */
                        const npy_double k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 3
                        /* load kernel */
                        const npy_double k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 3
                        /* load kernel */
                        const npy_double k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 3
                        /* load kernel */
                        const npy_double k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 3
                        /* load kernel */
                        const npy_double k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 3
                        /* load kernel */
                        const npy_double k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_double s = 0;
#line 4162
#if 1 <= 3
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 3
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 3
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 3
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 3
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 3
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 3
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 3
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 3
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 3
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 3
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 4:
                    {
#line 4153
#if 1 <= 4
                        /* load kernel */
                        const npy_double k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 4
                        /* load kernel */
                        const npy_double k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 4
                        /* load kernel */
                        const npy_double k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 4
                        /* load kernel */
                        const npy_double k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 4
                        /* load kernel */
                        const npy_double k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 4
                        /* load kernel */
                        const npy_double k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 4
                        /* load kernel */
                        const npy_double k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 4
                        /* load kernel */
                        const npy_double k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 4
                        /* load kernel */
                        const npy_double k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 4
                        /* load kernel */
                        const npy_double k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 4
                        /* load kernel */
                        const npy_double k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_double s = 0;
#line 4162
#if 1 <= 4
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 4
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 4
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 4
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 4
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 4
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 4
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 4
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 4
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 4
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 4
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 5:
                    {
#line 4153
#if 1 <= 5
                        /* load kernel */
                        const npy_double k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 5
                        /* load kernel */
                        const npy_double k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 5
                        /* load kernel */
                        const npy_double k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 5
                        /* load kernel */
                        const npy_double k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 5
                        /* load kernel */
                        const npy_double k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 5
                        /* load kernel */
                        const npy_double k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 5
                        /* load kernel */
                        const npy_double k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 5
                        /* load kernel */
                        const npy_double k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 5
                        /* load kernel */
                        const npy_double k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 5
                        /* load kernel */
                        const npy_double k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 5
                        /* load kernel */
                        const npy_double k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_double s = 0;
#line 4162
#if 1 <= 5
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 5
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 5
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 5
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 5
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 5
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 5
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 5
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 5
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 5
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 5
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 6:
                    {
#line 4153
#if 1 <= 6
                        /* load kernel */
                        const npy_double k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 6
                        /* load kernel */
                        const npy_double k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 6
                        /* load kernel */
                        const npy_double k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 6
                        /* load kernel */
                        const npy_double k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 6
                        /* load kernel */
                        const npy_double k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 6
                        /* load kernel */
                        const npy_double k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 6
                        /* load kernel */
                        const npy_double k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 6
                        /* load kernel */
                        const npy_double k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 6
                        /* load kernel */
                        const npy_double k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 6
                        /* load kernel */
                        const npy_double k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 6
                        /* load kernel */
                        const npy_double k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_double s = 0;
#line 4162
#if 1 <= 6
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 6
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 6
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 6
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 6
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 6
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 6
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 6
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 6
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 6
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 6
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 7:
                    {
#line 4153
#if 1 <= 7
                        /* load kernel */
                        const npy_double k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 7
                        /* load kernel */
                        const npy_double k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 7
                        /* load kernel */
                        const npy_double k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 7
                        /* load kernel */
                        const npy_double k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 7
                        /* load kernel */
                        const npy_double k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 7
                        /* load kernel */
                        const npy_double k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 7
                        /* load kernel */
                        const npy_double k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 7
                        /* load kernel */
                        const npy_double k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 7
                        /* load kernel */
                        const npy_double k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 7
                        /* load kernel */
                        const npy_double k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 7
                        /* load kernel */
                        const npy_double k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_double s = 0;
#line 4162
#if 1 <= 7
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 7
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 7
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 7
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 7
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 7
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 7
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 7
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 7
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 7
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 7
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 8:
                    {
#line 4153
#if 1 <= 8
                        /* load kernel */
                        const npy_double k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 8
                        /* load kernel */
                        const npy_double k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 8
                        /* load kernel */
                        const npy_double k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 8
                        /* load kernel */
                        const npy_double k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 8
                        /* load kernel */
                        const npy_double k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 8
                        /* load kernel */
                        const npy_double k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 8
                        /* load kernel */
                        const npy_double k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 8
                        /* load kernel */
                        const npy_double k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 8
                        /* load kernel */
                        const npy_double k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 8
                        /* load kernel */
                        const npy_double k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 8
                        /* load kernel */
                        const npy_double k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_double s = 0;
#line 4162
#if 1 <= 8
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 8
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 8
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 8
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 8
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 8
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 8
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 8
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 8
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 8
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 8
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 9:
                    {
#line 4153
#if 1 <= 9
                        /* load kernel */
                        const npy_double k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 9
                        /* load kernel */
                        const npy_double k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 9
                        /* load kernel */
                        const npy_double k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 9
                        /* load kernel */
                        const npy_double k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 9
                        /* load kernel */
                        const npy_double k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 9
                        /* load kernel */
                        const npy_double k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 9
                        /* load kernel */
                        const npy_double k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 9
                        /* load kernel */
                        const npy_double k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 9
                        /* load kernel */
                        const npy_double k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 9
                        /* load kernel */
                        const npy_double k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 9
                        /* load kernel */
                        const npy_double k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_double s = 0;
#line 4162
#if 1 <= 9
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 9
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 9
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 9
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 9
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 9
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 9
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 9
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 9
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 9
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 9
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 10:
                    {
#line 4153
#if 1 <= 10
                        /* load kernel */
                        const npy_double k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 10
                        /* load kernel */
                        const npy_double k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 10
                        /* load kernel */
                        const npy_double k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 10
                        /* load kernel */
                        const npy_double k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 10
                        /* load kernel */
                        const npy_double k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 10
                        /* load kernel */
                        const npy_double k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 10
                        /* load kernel */
                        const npy_double k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 10
                        /* load kernel */
                        const npy_double k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 10
                        /* load kernel */
                        const npy_double k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 10
                        /* load kernel */
                        const npy_double k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 10
                        /* load kernel */
                        const npy_double k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_double s = 0;
#line 4162
#if 1 <= 10
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 10
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 10
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 10
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 10
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 10
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 10
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 10
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 10
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 10
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 10
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

#line 4149
                    case 11:
                    {
#line 4153
#if 1 <= 11
                        /* load kernel */
                        const npy_double k1 = k[(1 - 1) * kstride];
#endif

#line 4153
#if 2 <= 11
                        /* load kernel */
                        const npy_double k2 = k[(2 - 1) * kstride];
#endif

#line 4153
#if 3 <= 11
                        /* load kernel */
                        const npy_double k3 = k[(3 - 1) * kstride];
#endif

#line 4153
#if 4 <= 11
                        /* load kernel */
                        const npy_double k4 = k[(4 - 1) * kstride];
#endif

#line 4153
#if 5 <= 11
                        /* load kernel */
                        const npy_double k5 = k[(5 - 1) * kstride];
#endif

#line 4153
#if 6 <= 11
                        /* load kernel */
                        const npy_double k6 = k[(6 - 1) * kstride];
#endif

#line 4153
#if 7 <= 11
                        /* load kernel */
                        const npy_double k7 = k[(7 - 1) * kstride];
#endif

#line 4153
#if 8 <= 11
                        /* load kernel */
                        const npy_double k8 = k[(8 - 1) * kstride];
#endif

#line 4153
#if 9 <= 11
                        /* load kernel */
                        const npy_double k9 = k[(9 - 1) * kstride];
#endif

#line 4153
#if 10 <= 11
                        /* load kernel */
                        const npy_double k10 = k[(10 - 1) * kstride];
#endif

#line 4153
#if 11 <= 11
                        /* load kernel */
                        const npy_double k11 = k[(11 - 1) * kstride];
#endif

                        for (i = 0; i < nd; i++) {
                            npy_double s = 0;
#line 4162
#if 1 <= 11
                            s += d[(i + 1 - 1) * dstride] * k1;
#endif

#line 4162
#if 2 <= 11
                            s += d[(i + 2 - 1) * dstride] * k2;
#endif

#line 4162
#if 3 <= 11
                            s += d[(i + 3 - 1) * dstride] * k3;
#endif

#line 4162
#if 4 <= 11
                            s += d[(i + 4 - 1) * dstride] * k4;
#endif

#line 4162
#if 5 <= 11
                            s += d[(i + 5 - 1) * dstride] * k5;
#endif

#line 4162
#if 6 <= 11
                            s += d[(i + 6 - 1) * dstride] * k6;
#endif

#line 4162
#if 7 <= 11
                            s += d[(i + 7 - 1) * dstride] * k7;
#endif

#line 4162
#if 8 <= 11
                            s += d[(i + 8 - 1) * dstride] * k8;
#endif

#line 4162
#if 9 <= 11
                            s += d[(i + 9 - 1) * dstride] * k9;
#endif

#line 4162
#if 10 <= 11
                            s += d[(i + 10 - 1) * dstride] * k10;
#endif

#line 4162
#if 11 <= 11
                            s += d[(i + 11 - 1) * dstride] * k11;
#endif

                            out[i * ostride] = s;
                        }
                        return 1;
                    }

                    default:
                        return 0;
                }
            }

        default:
            return 0;
    }
}

/*
*/

/* A clone function for the datetime dtype c_metadata */
static NpyAuxData *
_datetime_dtype_metadata_clone(NpyAuxData *data)
{
    PyArray_DatetimeDTypeMetaData *newdata =
        (PyArray_DatetimeDTypeMetaData *)PyArray_malloc(
                        sizeof(*newdata));
    if (newdata == NULL) {
        PyErr_NoMemory();
        return NULL;
    }

    memcpy(newdata, data, sizeof(*newdata));

    return (NpyAuxData *)newdata;
}

/*
 * Allocate and initialize a PyArray_DatetimeDTypeMetaData object
 */
static NpyAuxData*
_create_datetime_metadata(NPY_DATETIMEUNIT base, int num)
{
    PyArray_DatetimeDTypeMetaData *data;

    /* Allocate memory for the metadata */
    data = PyArray_malloc(sizeof(*data));
    if (data == NULL) {
        PyErr_NoMemory();
        return NULL;
    }

    /* Initialize the base aux data */
    memset(data, 0, sizeof(PyArray_DatetimeDTypeMetaData));
    data->base.free = (NpyAuxData_FreeFunc *)PyArray_free;
    data->base.clone = _datetime_dtype_metadata_clone;

    data->meta.base = base;
    data->meta.num = num;

    return (NpyAuxData*)data;
}


/*
 *****************************************************************************
 **                       SETUP FUNCTION POINTERS                           **
 *****************************************************************************
 */

#line 4244
static PyArray_ArrFuncs _PyVoid_ArrFuncs = {
    {
        VOID_to_BOOL,
        VOID_to_BYTE,
        VOID_to_UBYTE,
        VOID_to_SHORT,
        VOID_to_USHORT,
        VOID_to_INT,
        VOID_to_UINT,
        VOID_to_LONG,
        VOID_to_ULONG,
        VOID_to_LONGLONG,
        VOID_to_ULONGLONG,
        VOID_to_FLOAT,
        VOID_to_DOUBLE,
        VOID_to_LONGDOUBLE,
        VOID_to_CFLOAT,
        VOID_to_CDOUBLE,
        VOID_to_CLONGDOUBLE,
        VOID_to_OBJECT,
        VOID_to_STRING,
        VOID_to_UNICODE,
        VOID_to_VOID
    },
    VOID_getitem,
    VOID_setitem,
    (PyArray_CopySwapNFunc*)VOID_copyswapn,
    (PyArray_CopySwapFunc*)VOID_copyswap,
    (PyArray_CompareFunc*)VOID_compare,
    (PyArray_ArgFunc*)VOID_argmax,
    (PyArray_DotFunc*)NULL,
    (PyArray_ScanFunc*)VOID_scan,
    VOID_fromstr,
    (PyArray_NonzeroFunc*)VOID_nonzero,
    (PyArray_FillFunc*)NULL,
    (PyArray_FillWithScalarFunc*)NULL,
#if 0
    {
        quicksort_void,
        heapsort_void,
        timsort_void
    },
    {
        aquicksort_void,
        aheapsort_void,
        atimsort_void
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc *)NULL,
    (PyArray_FastPutmaskFunc *)NULL,
    (PyArray_FastTakeFunc *)NULL,
    (PyArray_ArgFunc*)VOID_argmin
};

/*
 * FIXME: check for PY3K
 */
static PyArray_Descr VOID_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyVoidArrType_Type,
    /* kind */
    NPY_VOIDLTR,
    /* type */
    NPY_VOIDLTR,
    /* byteorder */
    '|',
    /* flags, unicode needs init as py3.3 does not like printing garbage  */
    0,
    /* type_num */
    NPY_VOID,
    /* elsize */
    0,
    /* alignment */
    NPY_ALIGNOF(char),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyVoid_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4244
static PyArray_ArrFuncs _PyString_ArrFuncs = {
    {
        STRING_to_BOOL,
        STRING_to_BYTE,
        STRING_to_UBYTE,
        STRING_to_SHORT,
        STRING_to_USHORT,
        STRING_to_INT,
        STRING_to_UINT,
        STRING_to_LONG,
        STRING_to_ULONG,
        STRING_to_LONGLONG,
        STRING_to_ULONGLONG,
        STRING_to_FLOAT,
        STRING_to_DOUBLE,
        STRING_to_LONGDOUBLE,
        STRING_to_CFLOAT,
        STRING_to_CDOUBLE,
        STRING_to_CLONGDOUBLE,
        STRING_to_OBJECT,
        STRING_to_STRING,
        STRING_to_UNICODE,
        STRING_to_VOID
    },
    STRING_getitem,
    STRING_setitem,
    (PyArray_CopySwapNFunc*)STRING_copyswapn,
    (PyArray_CopySwapFunc*)STRING_copyswap,
    (PyArray_CompareFunc*)STRING_compare,
    (PyArray_ArgFunc*)STRING_argmax,
    (PyArray_DotFunc*)NULL,
    (PyArray_ScanFunc*)STRING_scan,
    STRING_fromstr,
    (PyArray_NonzeroFunc*)STRING_nonzero,
    (PyArray_FillFunc*)NULL,
    (PyArray_FillWithScalarFunc*)NULL,
#if 1
    {
        quicksort_string,
        heapsort_string,
        timsort_string
    },
    {
        aquicksort_string,
        aheapsort_string,
        atimsort_string
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc *)NULL,
    (PyArray_FastPutmaskFunc *)NULL,
    (PyArray_FastTakeFunc *)NULL,
    (PyArray_ArgFunc*)STRING_argmin
};

/*
 * FIXME: check for PY3K
 */
static PyArray_Descr STRING_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyStringArrType_Type,
    /* kind */
    NPY_STRINGLTR,
    /* type */
    NPY_STRINGLTR,
    /* byteorder */
    '|',
    /* flags, unicode needs init as py3.3 does not like printing garbage  */
    0,
    /* type_num */
    NPY_STRING,
    /* elsize */
    0,
    /* alignment */
    NPY_ALIGNOF(char),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyString_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4244
static PyArray_ArrFuncs _PyUnicode_ArrFuncs = {
    {
        UNICODE_to_BOOL,
        UNICODE_to_BYTE,
        UNICODE_to_UBYTE,
        UNICODE_to_SHORT,
        UNICODE_to_USHORT,
        UNICODE_to_INT,
        UNICODE_to_UINT,
        UNICODE_to_LONG,
        UNICODE_to_ULONG,
        UNICODE_to_LONGLONG,
        UNICODE_to_ULONGLONG,
        UNICODE_to_FLOAT,
        UNICODE_to_DOUBLE,
        UNICODE_to_LONGDOUBLE,
        UNICODE_to_CFLOAT,
        UNICODE_to_CDOUBLE,
        UNICODE_to_CLONGDOUBLE,
        UNICODE_to_OBJECT,
        UNICODE_to_STRING,
        UNICODE_to_UNICODE,
        UNICODE_to_VOID
    },
    UNICODE_getitem,
    UNICODE_setitem,
    (PyArray_CopySwapNFunc*)UNICODE_copyswapn,
    (PyArray_CopySwapFunc*)UNICODE_copyswap,
    (PyArray_CompareFunc*)UNICODE_compare,
    (PyArray_ArgFunc*)UNICODE_argmax,
    (PyArray_DotFunc*)NULL,
    (PyArray_ScanFunc*)UNICODE_scan,
    UNICODE_fromstr,
    (PyArray_NonzeroFunc*)UNICODE_nonzero,
    (PyArray_FillFunc*)NULL,
    (PyArray_FillWithScalarFunc*)NULL,
#if 1
    {
        quicksort_unicode,
        heapsort_unicode,
        timsort_unicode
    },
    {
        aquicksort_unicode,
        aheapsort_unicode,
        atimsort_unicode
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc *)NULL,
    (PyArray_FastPutmaskFunc *)NULL,
    (PyArray_FastTakeFunc *)NULL,
    (PyArray_ArgFunc*)UNICODE_argmin
};

/*
 * FIXME: check for PY3K
 */
static PyArray_Descr UNICODE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyUnicodeArrType_Type,
    /* kind */
    NPY_UNICODELTR,
    /* type */
    NPY_UNICODELTR,
    /* byteorder */
    '=',
    /* flags, unicode needs init as py3.3 does not like printing garbage  */
    NPY_NEEDS_INIT,
    /* type_num */
    NPY_UNICODE,
    /* elsize */
    0,
    /* alignment */
    NPY_ALIGNOF(npy_ucs4),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyUnicode_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};



#line 4385

static PyArray_ArrFuncs _PyBool_ArrFuncs = {
    {
        BOOL_to_BOOL,
        BOOL_to_BYTE,
        BOOL_to_UBYTE,
        BOOL_to_SHORT,
        BOOL_to_USHORT,
        BOOL_to_INT,
        BOOL_to_UINT,
        BOOL_to_LONG,
        BOOL_to_ULONG,
        BOOL_to_LONGLONG,
        BOOL_to_ULONGLONG,
        BOOL_to_FLOAT,
        BOOL_to_DOUBLE,
        BOOL_to_LONGDOUBLE,
        BOOL_to_CFLOAT,
        BOOL_to_CDOUBLE,
        BOOL_to_CLONGDOUBLE,
        BOOL_to_OBJECT,
        BOOL_to_STRING,
        BOOL_to_UNICODE,
        BOOL_to_VOID
    },
    BOOL_getitem,
    BOOL_setitem,
    (PyArray_CopySwapNFunc*)BOOL_copyswapn,
    (PyArray_CopySwapFunc*)BOOL_copyswap,
    (PyArray_CompareFunc*)BOOL_compare,
    (PyArray_ArgFunc*)BOOL_argmax,
    (PyArray_DotFunc*)BOOL_dot,
    (PyArray_ScanFunc*)BOOL_scan,
    BOOL_fromstr,
    (PyArray_NonzeroFunc*)BOOL_nonzero,
    (PyArray_FillFunc*)BOOL_fill,
    (PyArray_FillWithScalarFunc*)BOOL_fillwithscalar,
#if 1
    {
        quicksort_bool,
        heapsort_bool,
        #if 1
            radixsort_bool
        #else
            timsort_bool
        #endif
    },
    {
        aquicksort_bool,
        aheapsort_bool,
        #if 1
            aradixsort_bool
        #else
            atimsort_bool
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)BOOL_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr BOOL_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyBoolArrType_Type,
    /* kind */
    NPY_GENBOOLLTR,
    /* type */
    NPY_BOOLLTR,
    /* byteorder */
    '|',
    /* flags */
    0,
    /* type_num */
    NPY_BOOL,
    /* elsize */
    sizeof(npy_bool),
    /* alignment */
    NPY_ALIGNOF(npy_bool),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyBool_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyByte_ArrFuncs = {
    {
        BYTE_to_BOOL,
        BYTE_to_BYTE,
        BYTE_to_UBYTE,
        BYTE_to_SHORT,
        BYTE_to_USHORT,
        BYTE_to_INT,
        BYTE_to_UINT,
        BYTE_to_LONG,
        BYTE_to_ULONG,
        BYTE_to_LONGLONG,
        BYTE_to_ULONGLONG,
        BYTE_to_FLOAT,
        BYTE_to_DOUBLE,
        BYTE_to_LONGDOUBLE,
        BYTE_to_CFLOAT,
        BYTE_to_CDOUBLE,
        BYTE_to_CLONGDOUBLE,
        BYTE_to_OBJECT,
        BYTE_to_STRING,
        BYTE_to_UNICODE,
        BYTE_to_VOID
    },
    BYTE_getitem,
    BYTE_setitem,
    (PyArray_CopySwapNFunc*)BYTE_copyswapn,
    (PyArray_CopySwapFunc*)BYTE_copyswap,
    (PyArray_CompareFunc*)BYTE_compare,
    (PyArray_ArgFunc*)BYTE_argmax,
    (PyArray_DotFunc*)BYTE_dot,
    (PyArray_ScanFunc*)BYTE_scan,
    BYTE_fromstr,
    (PyArray_NonzeroFunc*)BYTE_nonzero,
    (PyArray_FillFunc*)BYTE_fill,
    (PyArray_FillWithScalarFunc*)BYTE_fillwithscalar,
#if 1
    {
        quicksort_byte,
        heapsort_byte,
        #if 1
            radixsort_byte
        #else
            timsort_byte
        #endif
    },
    {
        aquicksort_byte,
        aheapsort_byte,
        #if 1
            aradixsort_byte
        #else
            atimsort_byte
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)BYTE_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr BYTE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyByteArrType_Type,
    /* kind */
    NPY_SIGNEDLTR,
    /* type */
    NPY_BYTELTR,
    /* byteorder */
    '|',
    /* flags */
    0,
    /* type_num */
    NPY_BYTE,
    /* elsize */
    sizeof(npy_byte),
    /* alignment */
    NPY_ALIGNOF(npy_byte),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyByte_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyUByte_ArrFuncs = {
    {
        UBYTE_to_BOOL,
        UBYTE_to_BYTE,
        UBYTE_to_UBYTE,
        UBYTE_to_SHORT,
        UBYTE_to_USHORT,
        UBYTE_to_INT,
        UBYTE_to_UINT,
        UBYTE_to_LONG,
        UBYTE_to_ULONG,
        UBYTE_to_LONGLONG,
        UBYTE_to_ULONGLONG,
        UBYTE_to_FLOAT,
        UBYTE_to_DOUBLE,
        UBYTE_to_LONGDOUBLE,
        UBYTE_to_CFLOAT,
        UBYTE_to_CDOUBLE,
        UBYTE_to_CLONGDOUBLE,
        UBYTE_to_OBJECT,
        UBYTE_to_STRING,
        UBYTE_to_UNICODE,
        UBYTE_to_VOID
    },
    UBYTE_getitem,
    UBYTE_setitem,
    (PyArray_CopySwapNFunc*)UBYTE_copyswapn,
    (PyArray_CopySwapFunc*)UBYTE_copyswap,
    (PyArray_CompareFunc*)UBYTE_compare,
    (PyArray_ArgFunc*)UBYTE_argmax,
    (PyArray_DotFunc*)UBYTE_dot,
    (PyArray_ScanFunc*)UBYTE_scan,
    UBYTE_fromstr,
    (PyArray_NonzeroFunc*)UBYTE_nonzero,
    (PyArray_FillFunc*)UBYTE_fill,
    (PyArray_FillWithScalarFunc*)UBYTE_fillwithscalar,
#if 1
    {
        quicksort_ubyte,
        heapsort_ubyte,
        #if 1
            radixsort_ubyte
        #else
            timsort_ubyte
        #endif
    },
    {
        aquicksort_ubyte,
        aheapsort_ubyte,
        #if 1
            aradixsort_ubyte
        #else
            atimsort_ubyte
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)UBYTE_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr UBYTE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyUByteArrType_Type,
    /* kind */
    NPY_UNSIGNEDLTR,
    /* type */
    NPY_UBYTELTR,
    /* byteorder */
    '|',
    /* flags */
    0,
    /* type_num */
    NPY_UBYTE,
    /* elsize */
    sizeof(npy_ubyte),
    /* alignment */
    NPY_ALIGNOF(npy_ubyte),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyUByte_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyShort_ArrFuncs = {
    {
        SHORT_to_BOOL,
        SHORT_to_BYTE,
        SHORT_to_UBYTE,
        SHORT_to_SHORT,
        SHORT_to_USHORT,
        SHORT_to_INT,
        SHORT_to_UINT,
        SHORT_to_LONG,
        SHORT_to_ULONG,
        SHORT_to_LONGLONG,
        SHORT_to_ULONGLONG,
        SHORT_to_FLOAT,
        SHORT_to_DOUBLE,
        SHORT_to_LONGDOUBLE,
        SHORT_to_CFLOAT,
        SHORT_to_CDOUBLE,
        SHORT_to_CLONGDOUBLE,
        SHORT_to_OBJECT,
        SHORT_to_STRING,
        SHORT_to_UNICODE,
        SHORT_to_VOID
    },
    SHORT_getitem,
    SHORT_setitem,
    (PyArray_CopySwapNFunc*)SHORT_copyswapn,
    (PyArray_CopySwapFunc*)SHORT_copyswap,
    (PyArray_CompareFunc*)SHORT_compare,
    (PyArray_ArgFunc*)SHORT_argmax,
    (PyArray_DotFunc*)SHORT_dot,
    (PyArray_ScanFunc*)SHORT_scan,
    SHORT_fromstr,
    (PyArray_NonzeroFunc*)SHORT_nonzero,
    (PyArray_FillFunc*)SHORT_fill,
    (PyArray_FillWithScalarFunc*)SHORT_fillwithscalar,
#if 1
    {
        quicksort_short,
        heapsort_short,
        #if 1
            radixsort_short
        #else
            timsort_short
        #endif
    },
    {
        aquicksort_short,
        aheapsort_short,
        #if 1
            aradixsort_short
        #else
            atimsort_short
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)SHORT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr SHORT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyShortArrType_Type,
    /* kind */
    NPY_SIGNEDLTR,
    /* type */
    NPY_SHORTLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_SHORT,
    /* elsize */
    sizeof(npy_short),
    /* alignment */
    NPY_ALIGNOF(npy_short),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyShort_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyUShort_ArrFuncs = {
    {
        USHORT_to_BOOL,
        USHORT_to_BYTE,
        USHORT_to_UBYTE,
        USHORT_to_SHORT,
        USHORT_to_USHORT,
        USHORT_to_INT,
        USHORT_to_UINT,
        USHORT_to_LONG,
        USHORT_to_ULONG,
        USHORT_to_LONGLONG,
        USHORT_to_ULONGLONG,
        USHORT_to_FLOAT,
        USHORT_to_DOUBLE,
        USHORT_to_LONGDOUBLE,
        USHORT_to_CFLOAT,
        USHORT_to_CDOUBLE,
        USHORT_to_CLONGDOUBLE,
        USHORT_to_OBJECT,
        USHORT_to_STRING,
        USHORT_to_UNICODE,
        USHORT_to_VOID
    },
    USHORT_getitem,
    USHORT_setitem,
    (PyArray_CopySwapNFunc*)USHORT_copyswapn,
    (PyArray_CopySwapFunc*)USHORT_copyswap,
    (PyArray_CompareFunc*)USHORT_compare,
    (PyArray_ArgFunc*)USHORT_argmax,
    (PyArray_DotFunc*)USHORT_dot,
    (PyArray_ScanFunc*)USHORT_scan,
    USHORT_fromstr,
    (PyArray_NonzeroFunc*)USHORT_nonzero,
    (PyArray_FillFunc*)USHORT_fill,
    (PyArray_FillWithScalarFunc*)USHORT_fillwithscalar,
#if 1
    {
        quicksort_ushort,
        heapsort_ushort,
        #if 1
            radixsort_ushort
        #else
            timsort_ushort
        #endif
    },
    {
        aquicksort_ushort,
        aheapsort_ushort,
        #if 1
            aradixsort_ushort
        #else
            atimsort_ushort
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)USHORT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr USHORT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyUShortArrType_Type,
    /* kind */
    NPY_UNSIGNEDLTR,
    /* type */
    NPY_USHORTLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_USHORT,
    /* elsize */
    sizeof(npy_ushort),
    /* alignment */
    NPY_ALIGNOF(npy_ushort),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyUShort_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyInt_ArrFuncs = {
    {
        INT_to_BOOL,
        INT_to_BYTE,
        INT_to_UBYTE,
        INT_to_SHORT,
        INT_to_USHORT,
        INT_to_INT,
        INT_to_UINT,
        INT_to_LONG,
        INT_to_ULONG,
        INT_to_LONGLONG,
        INT_to_ULONGLONG,
        INT_to_FLOAT,
        INT_to_DOUBLE,
        INT_to_LONGDOUBLE,
        INT_to_CFLOAT,
        INT_to_CDOUBLE,
        INT_to_CLONGDOUBLE,
        INT_to_OBJECT,
        INT_to_STRING,
        INT_to_UNICODE,
        INT_to_VOID
    },
    INT_getitem,
    INT_setitem,
    (PyArray_CopySwapNFunc*)INT_copyswapn,
    (PyArray_CopySwapFunc*)INT_copyswap,
    (PyArray_CompareFunc*)INT_compare,
    (PyArray_ArgFunc*)INT_argmax,
    (PyArray_DotFunc*)INT_dot,
    (PyArray_ScanFunc*)INT_scan,
    INT_fromstr,
    (PyArray_NonzeroFunc*)INT_nonzero,
    (PyArray_FillFunc*)INT_fill,
    (PyArray_FillWithScalarFunc*)INT_fillwithscalar,
#if 1
    {
        quicksort_int,
        heapsort_int,
        #if 0
            radixsort_int
        #else
            timsort_int
        #endif
    },
    {
        aquicksort_int,
        aheapsort_int,
        #if 0
            aradixsort_int
        #else
            atimsort_int
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)INT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr INT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyIntArrType_Type,
    /* kind */
    NPY_SIGNEDLTR,
    /* type */
    NPY_INTLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_INT,
    /* elsize */
    sizeof(npy_int),
    /* alignment */
    NPY_ALIGNOF(npy_int),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyInt_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyUInt_ArrFuncs = {
    {
        UINT_to_BOOL,
        UINT_to_BYTE,
        UINT_to_UBYTE,
        UINT_to_SHORT,
        UINT_to_USHORT,
        UINT_to_INT,
        UINT_to_UINT,
        UINT_to_LONG,
        UINT_to_ULONG,
        UINT_to_LONGLONG,
        UINT_to_ULONGLONG,
        UINT_to_FLOAT,
        UINT_to_DOUBLE,
        UINT_to_LONGDOUBLE,
        UINT_to_CFLOAT,
        UINT_to_CDOUBLE,
        UINT_to_CLONGDOUBLE,
        UINT_to_OBJECT,
        UINT_to_STRING,
        UINT_to_UNICODE,
        UINT_to_VOID
    },
    UINT_getitem,
    UINT_setitem,
    (PyArray_CopySwapNFunc*)UINT_copyswapn,
    (PyArray_CopySwapFunc*)UINT_copyswap,
    (PyArray_CompareFunc*)UINT_compare,
    (PyArray_ArgFunc*)UINT_argmax,
    (PyArray_DotFunc*)UINT_dot,
    (PyArray_ScanFunc*)UINT_scan,
    UINT_fromstr,
    (PyArray_NonzeroFunc*)UINT_nonzero,
    (PyArray_FillFunc*)UINT_fill,
    (PyArray_FillWithScalarFunc*)UINT_fillwithscalar,
#if 1
    {
        quicksort_uint,
        heapsort_uint,
        #if 0
            radixsort_uint
        #else
            timsort_uint
        #endif
    },
    {
        aquicksort_uint,
        aheapsort_uint,
        #if 0
            aradixsort_uint
        #else
            atimsort_uint
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)UINT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr UINT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyUIntArrType_Type,
    /* kind */
    NPY_UNSIGNEDLTR,
    /* type */
    NPY_UINTLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_UINT,
    /* elsize */
    sizeof(npy_uint),
    /* alignment */
    NPY_ALIGNOF(npy_uint),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyUInt_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyLong_ArrFuncs = {
    {
        LONG_to_BOOL,
        LONG_to_BYTE,
        LONG_to_UBYTE,
        LONG_to_SHORT,
        LONG_to_USHORT,
        LONG_to_INT,
        LONG_to_UINT,
        LONG_to_LONG,
        LONG_to_ULONG,
        LONG_to_LONGLONG,
        LONG_to_ULONGLONG,
        LONG_to_FLOAT,
        LONG_to_DOUBLE,
        LONG_to_LONGDOUBLE,
        LONG_to_CFLOAT,
        LONG_to_CDOUBLE,
        LONG_to_CLONGDOUBLE,
        LONG_to_OBJECT,
        LONG_to_STRING,
        LONG_to_UNICODE,
        LONG_to_VOID
    },
    LONG_getitem,
    LONG_setitem,
    (PyArray_CopySwapNFunc*)LONG_copyswapn,
    (PyArray_CopySwapFunc*)LONG_copyswap,
    (PyArray_CompareFunc*)LONG_compare,
    (PyArray_ArgFunc*)LONG_argmax,
    (PyArray_DotFunc*)LONG_dot,
    (PyArray_ScanFunc*)LONG_scan,
    LONG_fromstr,
    (PyArray_NonzeroFunc*)LONG_nonzero,
    (PyArray_FillFunc*)LONG_fill,
    (PyArray_FillWithScalarFunc*)LONG_fillwithscalar,
#if 1
    {
        quicksort_long,
        heapsort_long,
        #if 0
            radixsort_long
        #else
            timsort_long
        #endif
    },
    {
        aquicksort_long,
        aheapsort_long,
        #if 0
            aradixsort_long
        #else
            atimsort_long
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)LONG_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr LONG_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyLongArrType_Type,
    /* kind */
    NPY_SIGNEDLTR,
    /* type */
    NPY_LONGLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_LONG,
    /* elsize */
    sizeof(npy_long),
    /* alignment */
    NPY_ALIGNOF(npy_long),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyLong_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyULong_ArrFuncs = {
    {
        ULONG_to_BOOL,
        ULONG_to_BYTE,
        ULONG_to_UBYTE,
        ULONG_to_SHORT,
        ULONG_to_USHORT,
        ULONG_to_INT,
        ULONG_to_UINT,
        ULONG_to_LONG,
        ULONG_to_ULONG,
        ULONG_to_LONGLONG,
        ULONG_to_ULONGLONG,
        ULONG_to_FLOAT,
        ULONG_to_DOUBLE,
        ULONG_to_LONGDOUBLE,
        ULONG_to_CFLOAT,
        ULONG_to_CDOUBLE,
        ULONG_to_CLONGDOUBLE,
        ULONG_to_OBJECT,
        ULONG_to_STRING,
        ULONG_to_UNICODE,
        ULONG_to_VOID
    },
    ULONG_getitem,
    ULONG_setitem,
    (PyArray_CopySwapNFunc*)ULONG_copyswapn,
    (PyArray_CopySwapFunc*)ULONG_copyswap,
    (PyArray_CompareFunc*)ULONG_compare,
    (PyArray_ArgFunc*)ULONG_argmax,
    (PyArray_DotFunc*)ULONG_dot,
    (PyArray_ScanFunc*)ULONG_scan,
    ULONG_fromstr,
    (PyArray_NonzeroFunc*)ULONG_nonzero,
    (PyArray_FillFunc*)ULONG_fill,
    (PyArray_FillWithScalarFunc*)ULONG_fillwithscalar,
#if 1
    {
        quicksort_ulong,
        heapsort_ulong,
        #if 0
            radixsort_ulong
        #else
            timsort_ulong
        #endif
    },
    {
        aquicksort_ulong,
        aheapsort_ulong,
        #if 0
            aradixsort_ulong
        #else
            atimsort_ulong
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)ULONG_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr ULONG_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyULongArrType_Type,
    /* kind */
    NPY_UNSIGNEDLTR,
    /* type */
    NPY_ULONGLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_ULONG,
    /* elsize */
    sizeof(npy_ulong),
    /* alignment */
    NPY_ALIGNOF(npy_ulong),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyULong_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyLongLong_ArrFuncs = {
    {
        LONGLONG_to_BOOL,
        LONGLONG_to_BYTE,
        LONGLONG_to_UBYTE,
        LONGLONG_to_SHORT,
        LONGLONG_to_USHORT,
        LONGLONG_to_INT,
        LONGLONG_to_UINT,
        LONGLONG_to_LONG,
        LONGLONG_to_ULONG,
        LONGLONG_to_LONGLONG,
        LONGLONG_to_ULONGLONG,
        LONGLONG_to_FLOAT,
        LONGLONG_to_DOUBLE,
        LONGLONG_to_LONGDOUBLE,
        LONGLONG_to_CFLOAT,
        LONGLONG_to_CDOUBLE,
        LONGLONG_to_CLONGDOUBLE,
        LONGLONG_to_OBJECT,
        LONGLONG_to_STRING,
        LONGLONG_to_UNICODE,
        LONGLONG_to_VOID
    },
    LONGLONG_getitem,
    LONGLONG_setitem,
    (PyArray_CopySwapNFunc*)LONGLONG_copyswapn,
    (PyArray_CopySwapFunc*)LONGLONG_copyswap,
    (PyArray_CompareFunc*)LONGLONG_compare,
    (PyArray_ArgFunc*)LONGLONG_argmax,
    (PyArray_DotFunc*)LONGLONG_dot,
    (PyArray_ScanFunc*)LONGLONG_scan,
    LONGLONG_fromstr,
    (PyArray_NonzeroFunc*)LONGLONG_nonzero,
    (PyArray_FillFunc*)LONGLONG_fill,
    (PyArray_FillWithScalarFunc*)LONGLONG_fillwithscalar,
#if 1
    {
        quicksort_longlong,
        heapsort_longlong,
        #if 0
            radixsort_longlong
        #else
            timsort_longlong
        #endif
    },
    {
        aquicksort_longlong,
        aheapsort_longlong,
        #if 0
            aradixsort_longlong
        #else
            atimsort_longlong
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)LONGLONG_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr LONGLONG_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyLongLongArrType_Type,
    /* kind */
    NPY_SIGNEDLTR,
    /* type */
    NPY_LONGLONGLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_LONGLONG,
    /* elsize */
    sizeof(npy_longlong),
    /* alignment */
    NPY_ALIGNOF(npy_longlong),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyLongLong_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyULongLong_ArrFuncs = {
    {
        ULONGLONG_to_BOOL,
        ULONGLONG_to_BYTE,
        ULONGLONG_to_UBYTE,
        ULONGLONG_to_SHORT,
        ULONGLONG_to_USHORT,
        ULONGLONG_to_INT,
        ULONGLONG_to_UINT,
        ULONGLONG_to_LONG,
        ULONGLONG_to_ULONG,
        ULONGLONG_to_LONGLONG,
        ULONGLONG_to_ULONGLONG,
        ULONGLONG_to_FLOAT,
        ULONGLONG_to_DOUBLE,
        ULONGLONG_to_LONGDOUBLE,
        ULONGLONG_to_CFLOAT,
        ULONGLONG_to_CDOUBLE,
        ULONGLONG_to_CLONGDOUBLE,
        ULONGLONG_to_OBJECT,
        ULONGLONG_to_STRING,
        ULONGLONG_to_UNICODE,
        ULONGLONG_to_VOID
    },
    ULONGLONG_getitem,
    ULONGLONG_setitem,
    (PyArray_CopySwapNFunc*)ULONGLONG_copyswapn,
    (PyArray_CopySwapFunc*)ULONGLONG_copyswap,
    (PyArray_CompareFunc*)ULONGLONG_compare,
    (PyArray_ArgFunc*)ULONGLONG_argmax,
    (PyArray_DotFunc*)ULONGLONG_dot,
    (PyArray_ScanFunc*)ULONGLONG_scan,
    ULONGLONG_fromstr,
    (PyArray_NonzeroFunc*)ULONGLONG_nonzero,
    (PyArray_FillFunc*)ULONGLONG_fill,
    (PyArray_FillWithScalarFunc*)ULONGLONG_fillwithscalar,
#if 1
    {
        quicksort_ulonglong,
        heapsort_ulonglong,
        #if 0
            radixsort_ulonglong
        #else
            timsort_ulonglong
        #endif
    },
    {
        aquicksort_ulonglong,
        aheapsort_ulonglong,
        #if 0
            aradixsort_ulonglong
        #else
            atimsort_ulonglong
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)ULONGLONG_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr ULONGLONG_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyULongLongArrType_Type,
    /* kind */
    NPY_UNSIGNEDLTR,
    /* type */
    NPY_ULONGLONGLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_ULONGLONG,
    /* elsize */
    sizeof(npy_ulonglong),
    /* alignment */
    NPY_ALIGNOF(npy_ulonglong),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyULongLong_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyHalf_ArrFuncs = {
    {
        HALF_to_BOOL,
        HALF_to_BYTE,
        HALF_to_UBYTE,
        HALF_to_SHORT,
        HALF_to_USHORT,
        HALF_to_INT,
        HALF_to_UINT,
        HALF_to_LONG,
        HALF_to_ULONG,
        HALF_to_LONGLONG,
        HALF_to_ULONGLONG,
        HALF_to_FLOAT,
        HALF_to_DOUBLE,
        HALF_to_LONGDOUBLE,
        HALF_to_CFLOAT,
        HALF_to_CDOUBLE,
        HALF_to_CLONGDOUBLE,
        HALF_to_OBJECT,
        HALF_to_STRING,
        HALF_to_UNICODE,
        HALF_to_VOID
    },
    HALF_getitem,
    HALF_setitem,
    (PyArray_CopySwapNFunc*)HALF_copyswapn,
    (PyArray_CopySwapFunc*)HALF_copyswap,
    (PyArray_CompareFunc*)HALF_compare,
    (PyArray_ArgFunc*)HALF_argmax,
    (PyArray_DotFunc*)HALF_dot,
    (PyArray_ScanFunc*)HALF_scan,
    HALF_fromstr,
    (PyArray_NonzeroFunc*)HALF_nonzero,
    (PyArray_FillFunc*)HALF_fill,
    (PyArray_FillWithScalarFunc*)HALF_fillwithscalar,
#if 1
    {
        quicksort_half,
        heapsort_half,
        #if 0
            radixsort_half
        #else
            timsort_half
        #endif
    },
    {
        aquicksort_half,
        aheapsort_half,
        #if 0
            aradixsort_half
        #else
            atimsort_half
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)HALF_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr HALF_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyHalfArrType_Type,
    /* kind */
    NPY_FLOATINGLTR,
    /* type */
    NPY_HALFLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_HALF,
    /* elsize */
    sizeof(npy_half),
    /* alignment */
    NPY_ALIGNOF(npy_half),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyHalf_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyFloat_ArrFuncs = {
    {
        FLOAT_to_BOOL,
        FLOAT_to_BYTE,
        FLOAT_to_UBYTE,
        FLOAT_to_SHORT,
        FLOAT_to_USHORT,
        FLOAT_to_INT,
        FLOAT_to_UINT,
        FLOAT_to_LONG,
        FLOAT_to_ULONG,
        FLOAT_to_LONGLONG,
        FLOAT_to_ULONGLONG,
        FLOAT_to_FLOAT,
        FLOAT_to_DOUBLE,
        FLOAT_to_LONGDOUBLE,
        FLOAT_to_CFLOAT,
        FLOAT_to_CDOUBLE,
        FLOAT_to_CLONGDOUBLE,
        FLOAT_to_OBJECT,
        FLOAT_to_STRING,
        FLOAT_to_UNICODE,
        FLOAT_to_VOID
    },
    FLOAT_getitem,
    FLOAT_setitem,
    (PyArray_CopySwapNFunc*)FLOAT_copyswapn,
    (PyArray_CopySwapFunc*)FLOAT_copyswap,
    (PyArray_CompareFunc*)FLOAT_compare,
    (PyArray_ArgFunc*)FLOAT_argmax,
    (PyArray_DotFunc*)FLOAT_dot,
    (PyArray_ScanFunc*)FLOAT_scan,
    FLOAT_fromstr,
    (PyArray_NonzeroFunc*)FLOAT_nonzero,
    (PyArray_FillFunc*)FLOAT_fill,
    (PyArray_FillWithScalarFunc*)FLOAT_fillwithscalar,
#if 1
    {
        quicksort_float,
        heapsort_float,
        #if 0
            radixsort_float
        #else
            timsort_float
        #endif
    },
    {
        aquicksort_float,
        aheapsort_float,
        #if 0
            aradixsort_float
        #else
            atimsort_float
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)FLOAT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr FLOAT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyFloatArrType_Type,
    /* kind */
    NPY_FLOATINGLTR,
    /* type */
    NPY_FLOATLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_FLOAT,
    /* elsize */
    sizeof(npy_float),
    /* alignment */
    NPY_ALIGNOF(npy_float),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyFloat_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyDouble_ArrFuncs = {
    {
        DOUBLE_to_BOOL,
        DOUBLE_to_BYTE,
        DOUBLE_to_UBYTE,
        DOUBLE_to_SHORT,
        DOUBLE_to_USHORT,
        DOUBLE_to_INT,
        DOUBLE_to_UINT,
        DOUBLE_to_LONG,
        DOUBLE_to_ULONG,
        DOUBLE_to_LONGLONG,
        DOUBLE_to_ULONGLONG,
        DOUBLE_to_FLOAT,
        DOUBLE_to_DOUBLE,
        DOUBLE_to_LONGDOUBLE,
        DOUBLE_to_CFLOAT,
        DOUBLE_to_CDOUBLE,
        DOUBLE_to_CLONGDOUBLE,
        DOUBLE_to_OBJECT,
        DOUBLE_to_STRING,
        DOUBLE_to_UNICODE,
        DOUBLE_to_VOID
    },
    DOUBLE_getitem,
    DOUBLE_setitem,
    (PyArray_CopySwapNFunc*)DOUBLE_copyswapn,
    (PyArray_CopySwapFunc*)DOUBLE_copyswap,
    (PyArray_CompareFunc*)DOUBLE_compare,
    (PyArray_ArgFunc*)DOUBLE_argmax,
    (PyArray_DotFunc*)DOUBLE_dot,
    (PyArray_ScanFunc*)DOUBLE_scan,
    DOUBLE_fromstr,
    (PyArray_NonzeroFunc*)DOUBLE_nonzero,
    (PyArray_FillFunc*)DOUBLE_fill,
    (PyArray_FillWithScalarFunc*)DOUBLE_fillwithscalar,
#if 1
    {
        quicksort_double,
        heapsort_double,
        #if 0
            radixsort_double
        #else
            timsort_double
        #endif
    },
    {
        aquicksort_double,
        aheapsort_double,
        #if 0
            aradixsort_double
        #else
            atimsort_double
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)DOUBLE_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr DOUBLE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyDoubleArrType_Type,
    /* kind */
    NPY_FLOATINGLTR,
    /* type */
    NPY_DOUBLELTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_DOUBLE,
    /* elsize */
    sizeof(npy_double),
    /* alignment */
    NPY_ALIGNOF(npy_double),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyDouble_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyLongDouble_ArrFuncs = {
    {
        LONGDOUBLE_to_BOOL,
        LONGDOUBLE_to_BYTE,
        LONGDOUBLE_to_UBYTE,
        LONGDOUBLE_to_SHORT,
        LONGDOUBLE_to_USHORT,
        LONGDOUBLE_to_INT,
        LONGDOUBLE_to_UINT,
        LONGDOUBLE_to_LONG,
        LONGDOUBLE_to_ULONG,
        LONGDOUBLE_to_LONGLONG,
        LONGDOUBLE_to_ULONGLONG,
        LONGDOUBLE_to_FLOAT,
        LONGDOUBLE_to_DOUBLE,
        LONGDOUBLE_to_LONGDOUBLE,
        LONGDOUBLE_to_CFLOAT,
        LONGDOUBLE_to_CDOUBLE,
        LONGDOUBLE_to_CLONGDOUBLE,
        LONGDOUBLE_to_OBJECT,
        LONGDOUBLE_to_STRING,
        LONGDOUBLE_to_UNICODE,
        LONGDOUBLE_to_VOID
    },
    LONGDOUBLE_getitem,
    LONGDOUBLE_setitem,
    (PyArray_CopySwapNFunc*)LONGDOUBLE_copyswapn,
    (PyArray_CopySwapFunc*)LONGDOUBLE_copyswap,
    (PyArray_CompareFunc*)LONGDOUBLE_compare,
    (PyArray_ArgFunc*)LONGDOUBLE_argmax,
    (PyArray_DotFunc*)LONGDOUBLE_dot,
    (PyArray_ScanFunc*)LONGDOUBLE_scan,
    LONGDOUBLE_fromstr,
    (PyArray_NonzeroFunc*)LONGDOUBLE_nonzero,
    (PyArray_FillFunc*)LONGDOUBLE_fill,
    (PyArray_FillWithScalarFunc*)LONGDOUBLE_fillwithscalar,
#if 1
    {
        quicksort_longdouble,
        heapsort_longdouble,
        #if 0
            radixsort_longdouble
        #else
            timsort_longdouble
        #endif
    },
    {
        aquicksort_longdouble,
        aheapsort_longdouble,
        #if 0
            aradixsort_longdouble
        #else
            atimsort_longdouble
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)LONGDOUBLE_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr LONGDOUBLE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyLongDoubleArrType_Type,
    /* kind */
    NPY_FLOATINGLTR,
    /* type */
    NPY_LONGDOUBLELTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_LONGDOUBLE,
    /* elsize */
    sizeof(npy_longdouble),
    /* alignment */
    NPY_ALIGNOF(npy_longdouble),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyLongDouble_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyCFloat_ArrFuncs = {
    {
        CFLOAT_to_BOOL,
        CFLOAT_to_BYTE,
        CFLOAT_to_UBYTE,
        CFLOAT_to_SHORT,
        CFLOAT_to_USHORT,
        CFLOAT_to_INT,
        CFLOAT_to_UINT,
        CFLOAT_to_LONG,
        CFLOAT_to_ULONG,
        CFLOAT_to_LONGLONG,
        CFLOAT_to_ULONGLONG,
        CFLOAT_to_FLOAT,
        CFLOAT_to_DOUBLE,
        CFLOAT_to_LONGDOUBLE,
        CFLOAT_to_CFLOAT,
        CFLOAT_to_CDOUBLE,
        CFLOAT_to_CLONGDOUBLE,
        CFLOAT_to_OBJECT,
        CFLOAT_to_STRING,
        CFLOAT_to_UNICODE,
        CFLOAT_to_VOID
    },
    CFLOAT_getitem,
    CFLOAT_setitem,
    (PyArray_CopySwapNFunc*)CFLOAT_copyswapn,
    (PyArray_CopySwapFunc*)CFLOAT_copyswap,
    (PyArray_CompareFunc*)CFLOAT_compare,
    (PyArray_ArgFunc*)CFLOAT_argmax,
    (PyArray_DotFunc*)CFLOAT_dot,
    (PyArray_ScanFunc*)CFLOAT_scan,
    CFLOAT_fromstr,
    (PyArray_NonzeroFunc*)CFLOAT_nonzero,
    (PyArray_FillFunc*)CFLOAT_fill,
    (PyArray_FillWithScalarFunc*)CFLOAT_fillwithscalar,
#if 1
    {
        quicksort_cfloat,
        heapsort_cfloat,
        #if 0
            radixsort_cfloat
        #else
            timsort_cfloat
        #endif
    },
    {
        aquicksort_cfloat,
        aheapsort_cfloat,
        #if 0
            aradixsort_cfloat
        #else
            atimsort_cfloat
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)CFLOAT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr CFLOAT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyCFloatArrType_Type,
    /* kind */
    NPY_COMPLEXLTR,
    /* type */
    NPY_CFLOATLTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_CFLOAT,
    /* elsize */
    sizeof(npy_cfloat),
    /* alignment */
    NPY_ALIGNOF(npy_cfloat),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyCFloat_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyCDouble_ArrFuncs = {
    {
        CDOUBLE_to_BOOL,
        CDOUBLE_to_BYTE,
        CDOUBLE_to_UBYTE,
        CDOUBLE_to_SHORT,
        CDOUBLE_to_USHORT,
        CDOUBLE_to_INT,
        CDOUBLE_to_UINT,
        CDOUBLE_to_LONG,
        CDOUBLE_to_ULONG,
        CDOUBLE_to_LONGLONG,
        CDOUBLE_to_ULONGLONG,
        CDOUBLE_to_FLOAT,
        CDOUBLE_to_DOUBLE,
        CDOUBLE_to_LONGDOUBLE,
        CDOUBLE_to_CFLOAT,
        CDOUBLE_to_CDOUBLE,
        CDOUBLE_to_CLONGDOUBLE,
        CDOUBLE_to_OBJECT,
        CDOUBLE_to_STRING,
        CDOUBLE_to_UNICODE,
        CDOUBLE_to_VOID
    },
    CDOUBLE_getitem,
    CDOUBLE_setitem,
    (PyArray_CopySwapNFunc*)CDOUBLE_copyswapn,
    (PyArray_CopySwapFunc*)CDOUBLE_copyswap,
    (PyArray_CompareFunc*)CDOUBLE_compare,
    (PyArray_ArgFunc*)CDOUBLE_argmax,
    (PyArray_DotFunc*)CDOUBLE_dot,
    (PyArray_ScanFunc*)CDOUBLE_scan,
    CDOUBLE_fromstr,
    (PyArray_NonzeroFunc*)CDOUBLE_nonzero,
    (PyArray_FillFunc*)CDOUBLE_fill,
    (PyArray_FillWithScalarFunc*)CDOUBLE_fillwithscalar,
#if 1
    {
        quicksort_cdouble,
        heapsort_cdouble,
        #if 0
            radixsort_cdouble
        #else
            timsort_cdouble
        #endif
    },
    {
        aquicksort_cdouble,
        aheapsort_cdouble,
        #if 0
            aradixsort_cdouble
        #else
            atimsort_cdouble
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)CDOUBLE_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr CDOUBLE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyCDoubleArrType_Type,
    /* kind */
    NPY_COMPLEXLTR,
    /* type */
    NPY_CDOUBLELTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_CDOUBLE,
    /* elsize */
    sizeof(npy_cdouble),
    /* alignment */
    NPY_ALIGNOF(npy_cdouble),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyCDouble_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyCLongDouble_ArrFuncs = {
    {
        CLONGDOUBLE_to_BOOL,
        CLONGDOUBLE_to_BYTE,
        CLONGDOUBLE_to_UBYTE,
        CLONGDOUBLE_to_SHORT,
        CLONGDOUBLE_to_USHORT,
        CLONGDOUBLE_to_INT,
        CLONGDOUBLE_to_UINT,
        CLONGDOUBLE_to_LONG,
        CLONGDOUBLE_to_ULONG,
        CLONGDOUBLE_to_LONGLONG,
        CLONGDOUBLE_to_ULONGLONG,
        CLONGDOUBLE_to_FLOAT,
        CLONGDOUBLE_to_DOUBLE,
        CLONGDOUBLE_to_LONGDOUBLE,
        CLONGDOUBLE_to_CFLOAT,
        CLONGDOUBLE_to_CDOUBLE,
        CLONGDOUBLE_to_CLONGDOUBLE,
        CLONGDOUBLE_to_OBJECT,
        CLONGDOUBLE_to_STRING,
        CLONGDOUBLE_to_UNICODE,
        CLONGDOUBLE_to_VOID
    },
    CLONGDOUBLE_getitem,
    CLONGDOUBLE_setitem,
    (PyArray_CopySwapNFunc*)CLONGDOUBLE_copyswapn,
    (PyArray_CopySwapFunc*)CLONGDOUBLE_copyswap,
    (PyArray_CompareFunc*)CLONGDOUBLE_compare,
    (PyArray_ArgFunc*)CLONGDOUBLE_argmax,
    (PyArray_DotFunc*)CLONGDOUBLE_dot,
    (PyArray_ScanFunc*)CLONGDOUBLE_scan,
    CLONGDOUBLE_fromstr,
    (PyArray_NonzeroFunc*)CLONGDOUBLE_nonzero,
    (PyArray_FillFunc*)CLONGDOUBLE_fill,
    (PyArray_FillWithScalarFunc*)CLONGDOUBLE_fillwithscalar,
#if 1
    {
        quicksort_clongdouble,
        heapsort_clongdouble,
        #if 0
            radixsort_clongdouble
        #else
            timsort_clongdouble
        #endif
    },
    {
        aquicksort_clongdouble,
        aheapsort_clongdouble,
        #if 0
            aradixsort_clongdouble
        #else
            atimsort_clongdouble
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)CLONGDOUBLE_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr CLONGDOUBLE_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyCLongDoubleArrType_Type,
    /* kind */
    NPY_COMPLEXLTR,
    /* type */
    NPY_CLONGDOUBLELTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_CLONGDOUBLE,
    /* elsize */
    sizeof(npy_clongdouble),
    /* alignment */
    NPY_ALIGNOF(npy_clongdouble),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyCLongDouble_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyObject_ArrFuncs = {
    {
        OBJECT_to_BOOL,
        OBJECT_to_BYTE,
        OBJECT_to_UBYTE,
        OBJECT_to_SHORT,
        OBJECT_to_USHORT,
        OBJECT_to_INT,
        OBJECT_to_UINT,
        OBJECT_to_LONG,
        OBJECT_to_ULONG,
        OBJECT_to_LONGLONG,
        OBJECT_to_ULONGLONG,
        OBJECT_to_FLOAT,
        OBJECT_to_DOUBLE,
        OBJECT_to_LONGDOUBLE,
        OBJECT_to_CFLOAT,
        OBJECT_to_CDOUBLE,
        OBJECT_to_CLONGDOUBLE,
        OBJECT_to_OBJECT,
        OBJECT_to_STRING,
        OBJECT_to_UNICODE,
        OBJECT_to_VOID
    },
    OBJECT_getitem,
    OBJECT_setitem,
    (PyArray_CopySwapNFunc*)OBJECT_copyswapn,
    (PyArray_CopySwapFunc*)OBJECT_copyswap,
    (PyArray_CompareFunc*)OBJECT_compare,
    (PyArray_ArgFunc*)OBJECT_argmax,
    (PyArray_DotFunc*)OBJECT_dot,
    (PyArray_ScanFunc*)OBJECT_scan,
    OBJECT_fromstr,
    (PyArray_NonzeroFunc*)OBJECT_nonzero,
    (PyArray_FillFunc*)OBJECT_fill,
    (PyArray_FillWithScalarFunc*)OBJECT_fillwithscalar,
#if 0
    {
        quicksort_object,
        heapsort_object,
        #if 0
            radixsort_object
        #else
            timsort_object
        #endif
    },
    {
        aquicksort_object,
        aheapsort_object,
        #if 0
            aradixsort_object
        #else
            atimsort_object
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)OBJECT_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr OBJECT_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyObjectArrType_Type,
    /* kind */
    NPY_OBJECTLTR,
    /* type */
    NPY_OBJECTLTR,
    /* byteorder */
    '|',
    /* flags */
    NPY_OBJECT_DTYPE_FLAGS,
    /* type_num */
    NPY_OBJECT,
    /* elsize */
    sizeof(PyObject *),
    /* alignment */
    NPY_ALIGNOF(PyObject *),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyObject_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyDatetime_ArrFuncs = {
    {
        DATETIME_to_BOOL,
        DATETIME_to_BYTE,
        DATETIME_to_UBYTE,
        DATETIME_to_SHORT,
        DATETIME_to_USHORT,
        DATETIME_to_INT,
        DATETIME_to_UINT,
        DATETIME_to_LONG,
        DATETIME_to_ULONG,
        DATETIME_to_LONGLONG,
        DATETIME_to_ULONGLONG,
        DATETIME_to_FLOAT,
        DATETIME_to_DOUBLE,
        DATETIME_to_LONGDOUBLE,
        DATETIME_to_CFLOAT,
        DATETIME_to_CDOUBLE,
        DATETIME_to_CLONGDOUBLE,
        DATETIME_to_OBJECT,
        DATETIME_to_STRING,
        DATETIME_to_UNICODE,
        DATETIME_to_VOID
    },
    DATETIME_getitem,
    DATETIME_setitem,
    (PyArray_CopySwapNFunc*)DATETIME_copyswapn,
    (PyArray_CopySwapFunc*)DATETIME_copyswap,
    (PyArray_CompareFunc*)DATETIME_compare,
    (PyArray_ArgFunc*)DATETIME_argmax,
    (PyArray_DotFunc*)DATETIME_dot,
    (PyArray_ScanFunc*)DATETIME_scan,
    DATETIME_fromstr,
    (PyArray_NonzeroFunc*)DATETIME_nonzero,
    (PyArray_FillFunc*)DATETIME_fill,
    (PyArray_FillWithScalarFunc*)DATETIME_fillwithscalar,
#if 1
    {
        quicksort_datetime,
        heapsort_datetime,
        #if 0
            radixsort_datetime
        #else
            timsort_datetime
        #endif
    },
    {
        aquicksort_datetime,
        aheapsort_datetime,
        #if 0
            aradixsort_datetime
        #else
            atimsort_datetime
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)DATETIME_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr DATETIME_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyDatetimeArrType_Type,
    /* kind */
    NPY_DATETIMELTR,
    /* type */
    NPY_DATETIMELTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_DATETIME,
    /* elsize */
    sizeof(npy_datetime),
    /* alignment */
    NPY_ALIGNOF(npy_datetime),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyDatetime_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};


#line 4385

static PyArray_ArrFuncs _PyTimedelta_ArrFuncs = {
    {
        TIMEDELTA_to_BOOL,
        TIMEDELTA_to_BYTE,
        TIMEDELTA_to_UBYTE,
        TIMEDELTA_to_SHORT,
        TIMEDELTA_to_USHORT,
        TIMEDELTA_to_INT,
        TIMEDELTA_to_UINT,
        TIMEDELTA_to_LONG,
        TIMEDELTA_to_ULONG,
        TIMEDELTA_to_LONGLONG,
        TIMEDELTA_to_ULONGLONG,
        TIMEDELTA_to_FLOAT,
        TIMEDELTA_to_DOUBLE,
        TIMEDELTA_to_LONGDOUBLE,
        TIMEDELTA_to_CFLOAT,
        TIMEDELTA_to_CDOUBLE,
        TIMEDELTA_to_CLONGDOUBLE,
        TIMEDELTA_to_OBJECT,
        TIMEDELTA_to_STRING,
        TIMEDELTA_to_UNICODE,
        TIMEDELTA_to_VOID
    },
    TIMEDELTA_getitem,
    TIMEDELTA_setitem,
    (PyArray_CopySwapNFunc*)TIMEDELTA_copyswapn,
    (PyArray_CopySwapFunc*)TIMEDELTA_copyswap,
    (PyArray_CompareFunc*)TIMEDELTA_compare,
    (PyArray_ArgFunc*)TIMEDELTA_argmax,
    (PyArray_DotFunc*)TIMEDELTA_dot,
    (PyArray_ScanFunc*)TIMEDELTA_scan,
    TIMEDELTA_fromstr,
    (PyArray_NonzeroFunc*)TIMEDELTA_nonzero,
    (PyArray_FillFunc*)TIMEDELTA_fill,
    (PyArray_FillWithScalarFunc*)TIMEDELTA_fillwithscalar,
#if 1
    {
        quicksort_timedelta,
        heapsort_timedelta,
        #if 0
            radixsort_timedelta
        #else
            timsort_timedelta
        #endif
    },
    {
        aquicksort_timedelta,
        aheapsort_timedelta,
        #if 0
            aradixsort_timedelta
        #else
            atimsort_timedelta
        #endif
    },
#else
    {
        NULL, NULL, NULL
    },
    {
        NULL, NULL, NULL
    },
#endif
    NULL,
    (PyArray_ScalarKindFunc*)NULL,
    NULL,
    NULL,
    (PyArray_FastClipFunc*)NULL,
    (PyArray_FastPutmaskFunc*)NULL,
    (PyArray_FastTakeFunc*)NULL,
    (PyArray_ArgFunc*)TIMEDELTA_argmin
};

/*
 * FIXME: check for PY3K
 */
NPY_NO_EXPORT PyArray_Descr TIMEDELTA_Descr = {
    PyObject_HEAD_INIT(&PyArrayDescr_Type)
    /* typeobj */
    &PyTimedeltaArrType_Type,
    /* kind */
    NPY_TIMEDELTALTR,
    /* type */
    NPY_TIMEDELTALTR,
    /* byteorder */
    '=',
    /* flags */
    0,
    /* type_num */
    NPY_TIMEDELTA,
    /* elsize */
    sizeof(npy_timedelta),
    /* alignment */
    NPY_ALIGNOF(npy_timedelta),
    /* subarray */
    NULL,
    /* fields */
    NULL,
    /* names */
    NULL,
    /* f */
    &_PyTimedelta_ArrFuncs,
    /* metadata */
    NULL,
    /* c_metadata */
    NULL,
    /* hash */
    -1,
};



#define _MAX_LETTER 128
static char _letter_to_num[_MAX_LETTER];

static PyArray_Descr *_builtin_descrs[] = {
    &BOOL_Descr,
    &BYTE_Descr,
    &UBYTE_Descr,
    &SHORT_Descr,
    &USHORT_Descr,
    &INT_Descr,
    &UINT_Descr,
    &LONG_Descr,
    &ULONG_Descr,
    &LONGLONG_Descr,
    &ULONGLONG_Descr,
    &FLOAT_Descr,
    &DOUBLE_Descr,
    &LONGDOUBLE_Descr,
    &CFLOAT_Descr,
    &CDOUBLE_Descr,
    &CLONGDOUBLE_Descr,
    &OBJECT_Descr,
    &STRING_Descr,
    &UNICODE_Descr,
    &VOID_Descr,
    &DATETIME_Descr,
    &TIMEDELTA_Descr,
    &HALF_Descr
};

/*NUMPY_API
 * Get the PyArray_Descr structure for a type.
 */
NPY_NO_EXPORT PyArray_Descr *
PyArray_DescrFromType(int type)
{
    PyArray_Descr *ret = NULL;

    if (type < 0) {
        /*
         * It's not valid for type to be less than 0.
         * If that happens, then no other branch of
         * this if/else chain should be followed.
         * This is effectively a no-op that ensures
         * the default error is raised.
         */
        ret = NULL;
    }
    else if (type < NPY_NTYPES) {
        ret = _builtin_descrs[type];
    }
    else if (type == NPY_NOTYPE) {
        /*
         * This needs to not raise an error so
         * that PyArray_DescrFromType(NPY_NOTYPE)
         * works for backwards-compatible C-API
         */
        return NULL;
    }
    else if ((type == NPY_CHAR) || (type == NPY_CHARLTR)) {
        if (type == NPY_CHAR) {
            /*
             * warning added 2017-04-25, 1.13
             * deprecated in 1.7
             * */
            if (DEPRECATE("The NPY_CHAR type_num is deprecated. "
                          "Please port your code to use "
                          "NPY_STRING instead.") < 0) {
                return NULL;
            }
        }
        ret = PyArray_DescrNew(_builtin_descrs[NPY_STRING]);
        if (ret == NULL) {
            return NULL;
        }
        ret->elsize = 1;
        ret->type = NPY_CHARLTR;
        return ret;
    }
    else if (PyTypeNum_ISUSERDEF(type)) {
        ret = userdescrs[type - NPY_USERDEF];
    }
    else {
        int num = NPY_NTYPES;
        if (type < _MAX_LETTER) {
            num = (int) _letter_to_num[type];
        }
        if (num >= NPY_NTYPES) {
            ret = NULL;
        }
        else {
            ret = _builtin_descrs[num];
        }
    }
    if (ret == NULL) {
        PyErr_SetString(PyExc_ValueError,
                "Invalid data-type for array");
    }
    else {
        Py_INCREF(ret);
    }

    return ret;
}

/*
 *****************************************************************************
 **                             SETUP TYPE INFO                             **
 *****************************************************************************
 */


/*
 * This function is called during numpy module initialization,
 * and is used to initialize internal dtype tables.
 */
NPY_NO_EXPORT int
set_typeinfo(PyObject *dict)
{
    PyObject *infodict, *s;
    int i;

    PyArray_Descr *dtype;
    PyObject *cobj, *key;

    // SIMD runtime dispatching
    #ifndef NPY_DISABLE_OPTIMIZATION
        #include "argfunc.dispatch.h"
    #endif
    #line 4636
    #line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyByte_ArrFuncs.argmax = (PyArray_ArgFunc*)BYTE_argmax);
    
#line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyByte_ArrFuncs.argmin = (PyArray_ArgFunc*)BYTE_argmin);
    
    
#line 4636
    #line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyUByte_ArrFuncs.argmax = (PyArray_ArgFunc*)UBYTE_argmax);
    
#line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyUByte_ArrFuncs.argmin = (PyArray_ArgFunc*)UBYTE_argmin);
    
    
#line 4636
    #line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyShort_ArrFuncs.argmax = (PyArray_ArgFunc*)SHORT_argmax);
    
#line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyShort_ArrFuncs.argmin = (PyArray_ArgFunc*)SHORT_argmin);
    
    
#line 4636
    #line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyUShort_ArrFuncs.argmax = (PyArray_ArgFunc*)USHORT_argmax);
    
#line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyUShort_ArrFuncs.argmin = (PyArray_ArgFunc*)USHORT_argmin);
    
    
#line 4636
    #line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyInt_ArrFuncs.argmax = (PyArray_ArgFunc*)INT_argmax);
    
#line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyInt_ArrFuncs.argmin = (PyArray_ArgFunc*)INT_argmin);
    
    
#line 4636
    #line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyUInt_ArrFuncs.argmax = (PyArray_ArgFunc*)UINT_argmax);
    
#line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyUInt_ArrFuncs.argmin = (PyArray_ArgFunc*)UINT_argmin);
    
    
#line 4636
    #line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyLong_ArrFuncs.argmax = (PyArray_ArgFunc*)LONG_argmax);
    
#line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyLong_ArrFuncs.argmin = (PyArray_ArgFunc*)LONG_argmin);
    
    
#line 4636
    #line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyULong_ArrFuncs.argmax = (PyArray_ArgFunc*)ULONG_argmax);
    
#line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyULong_ArrFuncs.argmin = (PyArray_ArgFunc*)ULONG_argmin);
    
    
#line 4636
    #line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyLongLong_ArrFuncs.argmax = (PyArray_ArgFunc*)LONGLONG_argmax);
    
#line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyLongLong_ArrFuncs.argmin = (PyArray_ArgFunc*)LONGLONG_argmin);
    
    
#line 4636
    #line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyULongLong_ArrFuncs.argmax = (PyArray_ArgFunc*)ULONGLONG_argmax);
    
#line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyULongLong_ArrFuncs.argmin = (PyArray_ArgFunc*)ULONGLONG_argmin);
    
    
#line 4636
    #line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyFloat_ArrFuncs.argmax = (PyArray_ArgFunc*)FLOAT_argmax);
    
#line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyFloat_ArrFuncs.argmin = (PyArray_ArgFunc*)FLOAT_argmin);
    
    
#line 4636
    #line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyDouble_ArrFuncs.argmax = (PyArray_ArgFunc*)DOUBLE_argmax);
    
#line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyDouble_ArrFuncs.argmin = (PyArray_ArgFunc*)DOUBLE_argmin);
    
    
#line 4636
    #line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyLongDouble_ArrFuncs.argmax = (PyArray_ArgFunc*)LONGDOUBLE_argmax);
    
#line 4639
    NPY_CPU_DISPATCH_CALL_XB(_PyLongDouble_ArrFuncs.argmin = (PyArray_ArgFunc*)LONGDOUBLE_argmin);
    
    
    NPY_CPU_DISPATCH_CALL_XB(_PyBool_ArrFuncs.argmax = (PyArray_ArgFunc*)BOOL_argmax);

    /*
     * Override the base class for all types, eventually all of this logic
     * should be defined on the class and inherited to the scalar.
     * (NPY_HALF is the largest builtin one.)
     */
    #line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_BOOL],
            "numpy.dtypes." NPY_BOOL_Name "DType",
#ifdef NPY_BOOL_alias
            "numpy.dtypes." NPY_BOOL_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_BYTE],
            "numpy.dtypes." NPY_BYTE_Name "DType",
#ifdef NPY_BYTE_alias
            "numpy.dtypes." NPY_BYTE_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_UBYTE],
            "numpy.dtypes." NPY_UBYTE_Name "DType",
#ifdef NPY_UBYTE_alias
            "numpy.dtypes." NPY_UBYTE_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_SHORT],
            "numpy.dtypes." NPY_SHORT_Name "DType",
#ifdef NPY_SHORT_alias
            "numpy.dtypes." NPY_SHORT_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_USHORT],
            "numpy.dtypes." NPY_USHORT_Name "DType",
#ifdef NPY_USHORT_alias
            "numpy.dtypes." NPY_USHORT_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_INT],
            "numpy.dtypes." NPY_INT_Name "DType",
#ifdef NPY_INT_alias
            "numpy.dtypes." NPY_INT_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_UINT],
            "numpy.dtypes." NPY_UINT_Name "DType",
#ifdef NPY_UINT_alias
            "numpy.dtypes." NPY_UINT_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_LONG],
            "numpy.dtypes." NPY_LONG_Name "DType",
#ifdef NPY_LONG_alias
            "numpy.dtypes." NPY_LONG_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_ULONG],
            "numpy.dtypes." NPY_ULONG_Name "DType",
#ifdef NPY_ULONG_alias
            "numpy.dtypes." NPY_ULONG_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_LONGLONG],
            "numpy.dtypes." NPY_LONGLONG_Name "DType",
#ifdef NPY_LONGLONG_alias
            "numpy.dtypes." NPY_LONGLONG_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_ULONGLONG],
            "numpy.dtypes." NPY_ULONGLONG_Name "DType",
#ifdef NPY_ULONGLONG_alias
            "numpy.dtypes." NPY_ULONGLONG_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_HALF],
            "numpy.dtypes." NPY_HALF_Name "DType",
#ifdef NPY_HALF_alias
            "numpy.dtypes." NPY_HALF_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_FLOAT],
            "numpy.dtypes." NPY_FLOAT_Name "DType",
#ifdef NPY_FLOAT_alias
            "numpy.dtypes." NPY_FLOAT_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_DOUBLE],
            "numpy.dtypes." NPY_DOUBLE_Name "DType",
#ifdef NPY_DOUBLE_alias
            "numpy.dtypes." NPY_DOUBLE_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_LONGDOUBLE],
            "numpy.dtypes." NPY_LONGDOUBLE_Name "DType",
#ifdef NPY_LONGDOUBLE_alias
            "numpy.dtypes." NPY_LONGDOUBLE_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_CFLOAT],
            "numpy.dtypes." NPY_CFLOAT_Name "DType",
#ifdef NPY_CFLOAT_alias
            "numpy.dtypes." NPY_CFLOAT_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_CDOUBLE],
            "numpy.dtypes." NPY_CDOUBLE_Name "DType",
#ifdef NPY_CDOUBLE_alias
            "numpy.dtypes." NPY_CDOUBLE_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_CLONGDOUBLE],
            "numpy.dtypes." NPY_CLONGDOUBLE_Name "DType",
#ifdef NPY_CLONGDOUBLE_alias
            "numpy.dtypes." NPY_CLONGDOUBLE_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_OBJECT],
            "numpy.dtypes." NPY_OBJECT_Name "DType",
#ifdef NPY_OBJECT_alias
            "numpy.dtypes." NPY_OBJECT_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_STRING],
            "numpy.dtypes." NPY_STRING_Name "DType",
#ifdef NPY_STRING_alias
            "numpy.dtypes." NPY_STRING_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_UNICODE],
            "numpy.dtypes." NPY_UNICODE_Name "DType",
#ifdef NPY_UNICODE_alias
            "numpy.dtypes." NPY_UNICODE_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_VOID],
            "numpy.dtypes." NPY_VOID_Name "DType",
#ifdef NPY_VOID_alias
            "numpy.dtypes." NPY_VOID_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_DATETIME],
            "numpy.dtypes." NPY_DATETIME_Name "DType",
#ifdef NPY_DATETIME_alias
            "numpy.dtypes." NPY_DATETIME_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    
#line 4659
    if (dtypemeta_wrap_legacy_descriptor(
            _builtin_descrs[NPY_TIMEDELTA],
            "numpy.dtypes." NPY_TIMEDELTA_Name "DType",
#ifdef NPY_TIMEDELTA_alias
            "numpy.dtypes." NPY_TIMEDELTA_Alias "DType"
#else
            NULL
#endif
            ) < 0) {
        return -1;
    }

    

    /*
     * Add cast functions for the new types
     */

    #line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_BOOL];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)BOOL_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_BOOL];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)BOOL_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_BOOL];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)BOOL_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_BYTE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)BYTE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_BYTE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)BYTE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_BYTE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)BYTE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_UBYTE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UBYTE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_UBYTE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UBYTE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_UBYTE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UBYTE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_SHORT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)SHORT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_SHORT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)SHORT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_SHORT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)SHORT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_USHORT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)USHORT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_USHORT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)USHORT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_USHORT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)USHORT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_INT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)INT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_INT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)INT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_INT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)INT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_UINT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UINT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_UINT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UINT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_UINT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UINT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_LONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONG_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_LONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONG_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_LONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONG_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_ULONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)ULONG_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_ULONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)ULONG_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_ULONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)ULONG_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_LONGLONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONGLONG_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_LONGLONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONGLONG_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_LONGLONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONGLONG_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_ULONGLONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)ULONGLONG_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_ULONGLONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)ULONGLONG_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_ULONGLONG];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)ULONGLONG_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_HALF];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)HALF_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_HALF];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)HALF_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_HALF];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)HALF_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_FLOAT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)FLOAT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_FLOAT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)FLOAT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_FLOAT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)FLOAT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_DOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)DOUBLE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_DOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)DOUBLE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_DOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)DOUBLE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_LONGDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONGDOUBLE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_LONGDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONGDOUBLE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_LONGDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)LONGDOUBLE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_CFLOAT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CFLOAT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_CFLOAT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CFLOAT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_CFLOAT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CFLOAT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_CDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CDOUBLE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_CDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CDOUBLE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_CDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CDOUBLE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_CLONGDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CLONGDOUBLE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_CLONGDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CLONGDOUBLE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_CLONGDOUBLE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)CLONGDOUBLE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_OBJECT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)OBJECT_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_OBJECT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)OBJECT_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_OBJECT];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)OBJECT_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_STRING];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)STRING_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_STRING];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)STRING_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_STRING];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)STRING_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_UNICODE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UNICODE_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_UNICODE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UNICODE_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_UNICODE];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)UNICODE_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_VOID];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)VOID_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_VOID];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)VOID_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_VOID];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)VOID_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_DATETIME];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)DATETIME_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_DATETIME];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)DATETIME_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_DATETIME];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)DATETIME_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    
#line 4687

    #line 4692

    dtype = _builtin_descrs[NPY_TIMEDELTA];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_HALF);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)TIMEDELTA_to_HALF, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_TIMEDELTA];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_DATETIME);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)TIMEDELTA_to_DATETIME, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    
#line 4692

    dtype = _builtin_descrs[NPY_TIMEDELTA];
    if (dtype->f->castdict == NULL) {
        dtype->f->castdict = PyDict_New();
        if (dtype->f->castdict == NULL) {
            return -1;
        }
    }
    key = PyLong_FromLong(NPY_TIMEDELTA);
    if (key == NULL) {
        return -1;
    }
    cobj = NpyCapsule_FromVoidPtr((void *)TIMEDELTA_to_TIMEDELTA, NULL);
    if (cobj == NULL) {
        Py_DECREF(key);
        return -1;
    }
    if (PyDict_SetItem(dtype->f->castdict, key, cobj) < 0) {
        Py_DECREF(key);
        Py_DECREF(cobj);
        return -1;
    }
    Py_DECREF(key);
    Py_DECREF(cobj);

    

    

    _builtin_descrs[NPY_DATETIME]->c_metadata = _create_datetime_metadata(
                NPY_DATETIME_DEFAULTUNIT, 1);
    if (_builtin_descrs[NPY_DATETIME]->c_metadata == NULL) {
        return -1;
    }
    _builtin_descrs[NPY_TIMEDELTA]->c_metadata = _create_datetime_metadata(
                NPY_DATETIME_DEFAULTUNIT, 1);
    if (_builtin_descrs[NPY_DATETIME]->c_metadata == NULL) {
        return -1;
    }

    for (i = 0; i < _MAX_LETTER; i++) {
        _letter_to_num[i] = NPY_NTYPES;
    }

    #line 4747

    _letter_to_num[NPY_BOOLLTR] = NPY_BOOL;

    
#line 4747

    _letter_to_num[NPY_BYTELTR] = NPY_BYTE;

    
#line 4747

    _letter_to_num[NPY_UBYTELTR] = NPY_UBYTE;

    
#line 4747

    _letter_to_num[NPY_SHORTLTR] = NPY_SHORT;

    
#line 4747

    _letter_to_num[NPY_USHORTLTR] = NPY_USHORT;

    
#line 4747

    _letter_to_num[NPY_INTLTR] = NPY_INT;

    
#line 4747

    _letter_to_num[NPY_UINTLTR] = NPY_UINT;

    
#line 4747

    _letter_to_num[NPY_INTPLTR] = NPY_INTP;

    
#line 4747

    _letter_to_num[NPY_UINTPLTR] = NPY_UINTP;

    
#line 4747

    _letter_to_num[NPY_LONGLTR] = NPY_LONG;

    
#line 4747

    _letter_to_num[NPY_ULONGLTR] = NPY_ULONG;

    
#line 4747

    _letter_to_num[NPY_LONGLONGLTR] = NPY_LONGLONG;

    
#line 4747

    _letter_to_num[NPY_ULONGLONGLTR] = NPY_ULONGLONG;

    
#line 4747

    _letter_to_num[NPY_HALFLTR] = NPY_HALF;

    
#line 4747

    _letter_to_num[NPY_FLOATLTR] = NPY_FLOAT;

    
#line 4747

    _letter_to_num[NPY_DOUBLELTR] = NPY_DOUBLE;

    
#line 4747

    _letter_to_num[NPY_LONGDOUBLELTR] = NPY_LONGDOUBLE;

    
#line 4747

    _letter_to_num[NPY_CFLOATLTR] = NPY_CFLOAT;

    
#line 4747

    _letter_to_num[NPY_CDOUBLELTR] = NPY_CDOUBLE;

    
#line 4747

    _letter_to_num[NPY_CLONGDOUBLELTR] = NPY_CLONGDOUBLE;

    
#line 4747

    _letter_to_num[NPY_OBJECTLTR] = NPY_OBJECT;

    
#line 4747

    _letter_to_num[NPY_STRINGLTR] = NPY_STRING;

    
#line 4747

    _letter_to_num[NPY_UNICODELTR] = NPY_UNICODE;

    
#line 4747

    _letter_to_num[NPY_VOIDLTR] = NPY_VOID;

    
#line 4747

    _letter_to_num[NPY_DATETIMELTR] = NPY_DATETIME;

    
#line 4747

    _letter_to_num[NPY_TIMEDELTALTR] = NPY_TIMEDELTA;

    

    _letter_to_num[NPY_STRINGLTR2] = NPY_STRING;

    #line 4763

    BOOL_Descr.fields = Py_None;

    
#line 4763

    BYTE_Descr.fields = Py_None;

    
#line 4763

    UBYTE_Descr.fields = Py_None;

    
#line 4763

    SHORT_Descr.fields = Py_None;

    
#line 4763

    USHORT_Descr.fields = Py_None;

    
#line 4763

    INT_Descr.fields = Py_None;

    
#line 4763

    UINT_Descr.fields = Py_None;

    
#line 4763

    LONG_Descr.fields = Py_None;

    
#line 4763

    ULONG_Descr.fields = Py_None;

    
#line 4763

    LONGLONG_Descr.fields = Py_None;

    
#line 4763

    ULONGLONG_Descr.fields = Py_None;

    
#line 4763

    HALF_Descr.fields = Py_None;

    
#line 4763

    FLOAT_Descr.fields = Py_None;

    
#line 4763

    DOUBLE_Descr.fields = Py_None;

    
#line 4763

    LONGDOUBLE_Descr.fields = Py_None;

    
#line 4763

    CFLOAT_Descr.fields = Py_None;

    
#line 4763

    CDOUBLE_Descr.fields = Py_None;

    
#line 4763

    CLONGDOUBLE_Descr.fields = Py_None;

    
#line 4763

    OBJECT_Descr.fields = Py_None;

    
#line 4763

    STRING_Descr.fields = Py_None;

    
#line 4763

    UNICODE_Descr.fields = Py_None;

    
#line 4763

    VOID_Descr.fields = Py_None;

    
#line 4763

    DATETIME_Descr.fields = Py_None;

    
#line 4763

    TIMEDELTA_Descr.fields = Py_None;

    


    #line 4772

    PyDataType_MAKEUNSIZED(&STRING_Descr);

    
#line 4772

    PyDataType_MAKEUNSIZED(&UNICODE_Descr);

    
#line 4772

    PyDataType_MAKEUNSIZED(&VOID_Descr);

    

    /* Set a dictionary with type information */
    infodict = PyDict_New();
    if (infodict == NULL) return -1;

    int ret;
    #line 4816

    s = PyArray_typeinforanged(
        NPY_BOOLLTR, NPY_BOOL, NPY_BITSOF_BOOL, NPY_ALIGNOF(npy_bool),
        Py_BuildValue("i", 1),
        Py_BuildValue("i", 0),
        &PyBoolArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "BOOL", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }


    
#line 4816

    s = PyArray_typeinforanged(
        NPY_BYTELTR, NPY_BYTE, NPY_BITSOF_BYTE, NPY_ALIGNOF(npy_byte),
        Py_BuildValue("i", NPY_MAX_BYTE),
        Py_BuildValue("i", NPY_MIN_BYTE),
        &PyByteArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "BYTE", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }


    
#line 4816

    s = PyArray_typeinforanged(
        NPY_UBYTELTR, NPY_UBYTE, NPY_BITSOF_BYTE, NPY_ALIGNOF(npy_ubyte),
        Py_BuildValue("i", NPY_MAX_UBYTE),
        Py_BuildValue("i", 0),
        &PyUByteArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "UBYTE", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }


    
#line 4816

    s = PyArray_typeinforanged(
        NPY_SHORTLTR, NPY_SHORT, NPY_BITSOF_SHORT, NPY_ALIGNOF(npy_short),
        Py_BuildValue("i", NPY_MAX_SHORT),
        Py_BuildValue("i", NPY_MIN_SHORT),
        &PyShortArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "SHORT", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }


    
#line 4816

    s = PyArray_typeinforanged(
        NPY_USHORTLTR, NPY_USHORT, NPY_BITSOF_SHORT, NPY_ALIGNOF(npy_ushort),
        Py_BuildValue("i", NPY_MAX_USHORT),
        Py_BuildValue("i", 0),
        &PyUShortArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "USHORT", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }


    
#line 4816

    s = PyArray_typeinforanged(
        NPY_INTLTR, NPY_INT, NPY_BITSOF_INT, NPY_ALIGNOF(npy_int),
        Py_BuildValue("i", NPY_MAX_INT),
        Py_BuildValue("i", NPY_MIN_INT),
        &PyIntArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "INT", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }


    
#line 4816

    s = PyArray_typeinforanged(
        NPY_UINTLTR, NPY_UINT, NPY_BITSOF_INT, NPY_ALIGNOF(npy_uint),
        Py_BuildValue("N", PyLong_FromUnsignedLong(NPY_MAX_UINT)),
        Py_BuildValue("i", 0),
        &PyUIntArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "UINT", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }


    
#line 4816

    s = PyArray_typeinforanged(
        NPY_INTPLTR, NPY_INTP, NPY_BITSOF_INTP, NPY_ALIGNOF(npy_intp),
        Py_BuildValue("N", PyLong_FromLongLong((npy_longlong) NPY_MAX_INTP)),
        Py_BuildValue("N", PyLong_FromLongLong((npy_longlong) NPY_MIN_INTP)),
        &PyIntpArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "INTP", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }


    
#line 4816

    s = PyArray_typeinforanged(
        NPY_UINTPLTR, NPY_UINTP, NPY_BITSOF_INTP, NPY_ALIGNOF(npy_uintp),
        Py_BuildValue("N", PyLong_FromUnsignedLongLong((npy_ulonglong) NPY_MAX_UINTP)),
        Py_BuildValue("i", 0),
        &PyUIntpArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "UINTP", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }


    
#line 4816

    s = PyArray_typeinforanged(
        NPY_LONGLTR, NPY_LONG, NPY_BITSOF_LONG, NPY_ALIGNOF(npy_long),
        Py_BuildValue("l", NPY_MAX_LONG),
        Py_BuildValue("l", NPY_MIN_LONG),
        &PyLongArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "LONG", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }


    
#line 4816

    s = PyArray_typeinforanged(
        NPY_ULONGLTR, NPY_ULONG, NPY_BITSOF_LONG, NPY_ALIGNOF(npy_ulong),
        Py_BuildValue("N", PyLong_FromUnsignedLong((npy_ulong) NPY_MAX_ULONG)),
        Py_BuildValue("i", 0),
        &PyULongArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "ULONG", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }


    
#line 4816

    s = PyArray_typeinforanged(
        NPY_LONGLONGLTR, NPY_LONGLONG, NPY_BITSOF_LONGLONG, NPY_ALIGNOF(npy_longlong),
        Py_BuildValue("N", PyLong_FromLongLong((npy_longlong) NPY_MAX_LONGLONG)),
        Py_BuildValue("N", PyLong_FromLongLong((npy_longlong) NPY_MIN_LONGLONG)),
        &PyLongLongArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "LONGLONG", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }


    
#line 4816

    s = PyArray_typeinforanged(
        NPY_ULONGLONGLTR, NPY_ULONGLONG, NPY_BITSOF_LONGLONG, NPY_ALIGNOF(npy_ulonglong),
        Py_BuildValue("N", PyLong_FromUnsignedLongLong((npy_ulonglong) NPY_MAX_ULONGLONG)),
        Py_BuildValue("i", 0),
        &PyULongLongArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "ULONGLONG", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }


    


    #line 4847
    s = PyArray_typeinfo(
        NPY_HALFLTR, NPY_HALF, NPY_BITSOF_HALF,
        NPY_ALIGNOF(npy_half), &PyHalfArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "HALF", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }

    
#line 4847
    s = PyArray_typeinfo(
        NPY_FLOATLTR, NPY_FLOAT, NPY_BITSOF_FLOAT,
        NPY_ALIGNOF(npy_float), &PyFloatArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "FLOAT", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }

    
#line 4847
    s = PyArray_typeinfo(
        NPY_DOUBLELTR, NPY_DOUBLE, NPY_BITSOF_DOUBLE,
        NPY_ALIGNOF(npy_double), &PyDoubleArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "DOUBLE", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }

    
#line 4847
    s = PyArray_typeinfo(
        NPY_LONGDOUBLELTR, NPY_LONGDOUBLE, NPY_BITSOF_LONGDOUBLE,
        NPY_ALIGNOF(npy_longdouble), &PyLongDoubleArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "LONGDOUBLE", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }

    
#line 4847
    s = PyArray_typeinfo(
        NPY_CFLOATLTR, NPY_CFLOAT, NPY_BITSOF_CFLOAT,
        NPY_ALIGNOF(npy_cfloat), &PyCFloatArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "CFLOAT", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }

    
#line 4847
    s = PyArray_typeinfo(
        NPY_CDOUBLELTR, NPY_CDOUBLE, NPY_BITSOF_CDOUBLE,
        NPY_ALIGNOF(npy_cdouble), &PyCDoubleArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "CDOUBLE", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }

    
#line 4847
    s = PyArray_typeinfo(
        NPY_CLONGDOUBLELTR, NPY_CLONGDOUBLE, NPY_BITSOF_CLONGDOUBLE,
        NPY_ALIGNOF(npy_clongdouble), &PyCLongDoubleArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "CLONGDOUBLE", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }

    

    s = PyArray_typeinfo(
        NPY_OBJECTLTR, NPY_OBJECT, sizeof(PyObject *) * CHAR_BIT,
        NPY_ALIGNOF(PyObject *),
        &PyObjectArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "OBJECT", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }
    s = PyArray_typeinfo(
        NPY_STRINGLTR, NPY_STRING, 0, NPY_ALIGNOF(char),
        &PyStringArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "STRING", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }
    s = PyArray_typeinfo(
        NPY_UNICODELTR, NPY_UNICODE, 0, NPY_ALIGNOF(npy_ucs4),
        &PyUnicodeArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "UNICODE", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }
    s = PyArray_typeinfo(
        NPY_VOIDLTR, NPY_VOID, 0, NPY_ALIGNOF(char),
        &PyVoidArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "VOID", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }
    s = PyArray_typeinforanged(
        NPY_DATETIMELTR, NPY_DATETIME, NPY_BITSOF_DATETIME,
        NPY_ALIGNOF(npy_datetime),
        MyPyLong_FromInt64(NPY_MAX_DATETIME),
        MyPyLong_FromInt64(NPY_MIN_DATETIME),
        &PyDatetimeArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "DATETIME", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }
    s = PyArray_typeinforanged(
        NPY_TIMEDELTALTR, NPY_TIMEDELTA, NPY_BITSOF_TIMEDELTA,
        NPY_ALIGNOF(npy_timedelta),
        MyPyLong_FromInt64(NPY_MAX_TIMEDELTA),
        MyPyLong_FromInt64(NPY_MIN_TIMEDELTA),
        &PyTimedeltaArrType_Type
    );
    if (s == NULL) {
        Py_DECREF(infodict);
        return -1;
    }
    ret = PyDict_SetItemString(infodict, "TIMEDELTA", s);
    Py_DECREF(s);
    if (ret < 0) {
        Py_DECREF(infodict);
        return -1;
    }

#define SETTYPE(name)                                   \
    Py_INCREF(&Py##name##ArrType_Type);                 \
    if (PyDict_SetItemString(infodict, #name,           \
            (PyObject *)&Py##name##ArrType_Type) < 0) { \
        Py_DECREF(infodict);                            \
        return -1;                                      \
    }

    SETTYPE(Generic);
    SETTYPE(Number);
    SETTYPE(Integer);
    SETTYPE(Inexact);
    SETTYPE(SignedInteger);
    SETTYPE(UnsignedInteger);
    SETTYPE(Floating);
    SETTYPE(ComplexFloating);
    SETTYPE(Flexible);
    SETTYPE(Character);

#undef SETTYPE

    ret = PyDict_SetItemString(dict, "typeinfo", infodict);
    Py_DECREF(infodict);
    if (ret < 0) {
        return -1;
    }
    return 0;
}

#undef _MAX_LETTER

